/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_viewprt.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:51:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #include <com/sun/star/text/NotePrintMode.hpp>

#if STLPORT_VERSION>=321
#include <cstdarg>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif

#ifndef _SVSTDARR_HXX
#define _SVSTDARR_STRINGSDTOR
// auto strip #include <svtools/svstdarr.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif


// auto strip #ifndef _SFXFLAGITEM_HXX //autogen
// auto strip #include <svtools/flagitem.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_PRINTDLG_HXX_ //autogen
// auto strip #include <svtools/printdlg.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_PRINTER_HXX //autogen
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_PRNMON_HXX //autogen
// auto strip #include <bf_sfx2/prnmon.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_PAPERINF_HXX //autogen
// auto strip #include <bf_svx/paperinf.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_MISCCFG_HXX
// auto strip #include <bf_sfx2/misccfg.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_PRTQRY_HXX
// auto strip #include <bf_svx/prtqry.hxx>
// auto strip #endif
// auto strip #ifndef _SVDVIEW_HXX
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXFLAGITEM_HXX
// auto strip #include <svtools/flagitem.hxx>
// auto strip #endif

// auto strip #ifndef _EDTWIN_HXX
// auto strip #include <edtwin.hxx>
// auto strip #endif
// auto strip #ifndef _VIEW_HXX
// auto strip #include <view.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _PRTOPT_HXX
// auto strip #include <prtopt.hxx>
// auto strip #endif
// auto strip #ifndef _SWPRTOPT_HXX
// auto strip #include <swprtopt.hxx>
// auto strip #endif
// auto strip #ifndef _OPTPAGE_HXX
// auto strip #include <optpage.hxx>
// auto strip #endif
// auto strip #ifndef _CFGITEMS_HXX
// auto strip #include <cfgitems.hxx>
// auto strip #endif
// auto strip #ifndef _DBMGR_HXX
// auto strip #include <dbmgr.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSTAT_HXX
// auto strip #include <docstat.hxx>
// auto strip #endif
#ifndef _VIEWFUNC_HXX
#include <viewfunc.hxx>
#endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif

#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _VIEW_HRC
#include <view.hrc>
#endif
#ifndef _APP_HRC
#include <app.hrc>
#endif
namespace binfilter {

#define C2U(cChar) ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(cChar))

/*--------------------------------------------------------------------
	Beschreibung:	Drucker an Sfx uebergeben
 --------------------------------------------------------------------*/


/*N*/ SfxPrinter* __EXPORT SwView::GetPrinter( BOOL bCreate )
/*N*/ {
/*N*/ 	SfxPrinter *pOld = GetWrtShell().GetPrt( FALSE );
/*N*/ 	SfxPrinter *pPrt = GetWrtShell().GetPrt( bCreate );
/*N*/ 	if ( pOld != pPrt )
/*N*/ 	{
/*N*/ 		BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
/*N*/ 		::binfilter::SetAppPrintOptions( &GetWrtShell(), bWeb );
/*N*/ 	}
/*N*/ 	return pPrt;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Druckerwechsel weitermelden
 --------------------------------------------------------------------*/

//STRIP001 void SetPrinter( SfxPrinter* pNew, BOOL bWeb )
//STRIP001 {
//STRIP001 	SwPrintOptions* pOpt = SW_MOD()->GetPrtOptions(bWeb);
//STRIP001 	if( !pOpt)
//STRIP001 		return;
//STRIP001 
//STRIP001 	// Applikationseigene Druckoptionen aus SfxPrinter auslesen
//STRIP001 	const SfxItemSet& rSet = pNew->GetOptions();
//STRIP001 
//STRIP001 	const SwAddPrinterItem* pAddPrinterAttr;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( FN_PARAM_ADDPRINTER, FALSE,
//STRIP001 		(const SfxPoolItem**)&pAddPrinterAttr ) )
//STRIP001 	{
//STRIP001 //		Wir lassen die Druckoptionen so, wie sie sind.
//STRIP001 //		pAddPrinterAttr->SetPrintOptions( pOpt );
//STRIP001         if( pAddPrinterAttr->GetFax().getLength() )
//STRIP001 			pOpt->SetFaxName(pAddPrinterAttr->GetFax());
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 USHORT __EXPORT SwView::SetPrinter(SfxPrinter* pNew, USHORT nDiffFlags )
//STRIP001 {
//STRIP001 	SwWrtShell &rSh = GetWrtShell();
//STRIP001 	if ( (SFX_PRINTER_JOBSETUP | SFX_PRINTER_PRINTER) & nDiffFlags )
//STRIP001 	{
//STRIP001 		rSh.SetPrt( pNew );
//STRIP001 		if ( nDiffFlags & SFX_PRINTER_PRINTER )
//STRIP001 			rSh.SetModified();
//STRIP001 	}
//STRIP001 	BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
//STRIP001 	if ( nDiffFlags & SFX_PRINTER_OPTIONS )
//STRIP001 		::SetPrinter( pNew, bWeb );
//STRIP001 
//STRIP001 	const BOOL bChgOri = nDiffFlags & SFX_PRINTER_CHG_ORIENTATION ? TRUE : FALSE;
//STRIP001 	const BOOL bChgSize= nDiffFlags & SFX_PRINTER_CHG_SIZE ? TRUE : FALSE;
//STRIP001 	if ( bChgOri || bChgSize )
//STRIP001 	{
//STRIP001 		rSh.StartAllAction();
//STRIP001 		if ( bChgOri )
//STRIP001 			rSh.ChgAllPageOrientation( USHORT(pNew->GetOrientation()) );
//STRIP001 		if ( bChgSize )
//STRIP001 		{
//STRIP001 			Size aSz( SvxPaperInfo::GetPaperSize( pNew ) );
//STRIP001 			rSh.ChgAllPageSize( aSz );
//STRIP001 		}
//STRIP001 		rSh.SetModified();
//STRIP001 		rSh.EndAllAction();
//STRIP001 		InvalidateRulerPos();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 ErrCode	SwView::DoPrint( SfxPrinter *pPrinter, PrintDialog *pDlg,
//STRIP001 									 BOOL bSilent )
//STRIP001 {
//STRIP001 	// First test
//STRIP001 	SwWrtShell* pSh = &GetWrtShell();
//STRIP001 	SwNewDBMgr* pMgr = pSh->GetNewDBMgr();
//STRIP001 
//STRIP001 	int bPrintSelection = -1;
//STRIP001 	if( DBMGR_MERGE_MAILMERGE != pMgr->GetMergeType() && !pDlg && !bSilent
//STRIP001 		&& !bIsApi && ( pSh->IsSelection() || pSh->IsFrmSelected() ||
//STRIP001 		pSh->IsObjSelected() ) )
//STRIP001 	{
//STRIP001 		short nBtn = SvxPrtQryBox(&GetEditWin()).Execute();
//STRIP001 		if( RET_CANCEL == nBtn )
//STRIP001 			return ERRCODE_IO_ABORT;
//STRIP001 
//STRIP001 		if( RET_OK == nBtn )
//STRIP001 			bPrintSelection = 1;
//STRIP001 		else
//STRIP001 			bPrintSelection = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 // 	Der PrintProgress stellt Handler am Printer der ViewShell ein.
//STRIP001 //	Das kann natuerlich erste nach dem evtl. Umschalten des Druckers korrekt
//STRIP001 //	funktionieren. #55210#
//STRIP001 //	SfxPrintProgress *pProgress = new SfxPrintProgress( this, !bSilent );
//STRIP001 	SfxPrintProgress *pProgress = 0;
//STRIP001 	SfxPrinter *pDocPrinter = GetPrinter(TRUE);
//STRIP001 	if ( !pPrinter )
//STRIP001 		pPrinter = pDocPrinter;
//STRIP001 	else if ( pDocPrinter != pPrinter )
//STRIP001 	{
//STRIP001 		//Da der Doc-Drucker beim SetPrinter geloescht wird,
//STRIP001 		// muss man ihn vorher clonen
//STRIP001 		SfxPrinter* pClone = pDocPrinter->Clone();
//STRIP001 		SetPrinter( pPrinter, SFX_PRINTER_PRINTER );
//STRIP001 		pProgress = new SfxPrintProgress( this, !bSilent );
//STRIP001 		pProgress->RestoreOnEndPrint( pClone );
//STRIP001 	}
//STRIP001 	if(!pProgress)
//STRIP001 		pProgress = new SfxPrintProgress( this, !bSilent );
//STRIP001 	pProgress->SetWaitMode(FALSE);
//STRIP001 
//STRIP001 	BOOL bStartJob = pPrinter->InitJob( &GetEditWin(), pSh->HasDrawView() &&
//STRIP001 					pSh->GetDrawView()->GetModel()->HasTransparentObjects());
//STRIP001 	if( bStartJob )
//STRIP001 	{
//STRIP001 		// Drucker starten
//STRIP001 		PreparePrint( pDlg );
//STRIP001 		SfxObjectShell *pObjShell = GetViewFrame()->GetObjectShell();
//STRIP001 		SwPrtOptions aOpts( pObjShell->GetTitle(0) );
//STRIP001 		BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
//STRIP001 		if( pMgr->GetMergeType() == DBMGR_MERGE_MAILMERGE )
//STRIP001 		{
//STRIP001             SwView::MakeOptions( pDlg, aOpts, 0, bWeb, GetPrinter(),
//STRIP001 							pSh->GetPrintData() );
//STRIP001 			bStartJob = pMgr->MergePrint( *this, aOpts, *pProgress );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             const BOOL bLockedView = pSh->IsViewLocked();
//STRIP001             pSh->LockView( TRUE );
//STRIP001 
//STRIP001 			//BrowseView abschalten und die View gegen alle Paints locken.
//STRIP001 			FASTBOOL bBrowse = pSh->IsBrowseMode();
//STRIP001 			SfxAllItemSet aSet( SFX_APP()->GetPool() );
//STRIP001 			SfxBoolItem aBrowse( SID_BROWSER_MODE, FALSE );
//STRIP001 			if ( bBrowse )
//STRIP001 			{
//STRIP001 				if ( pSh->GetWin() )
//STRIP001 					pSh->GetWin()->Update();
//STRIP001 				pSh->LockPaint();
//STRIP001 				aSet.Put( aBrowse, aBrowse.Which() );
//STRIP001 				SfxRequest aReq( SID_BROWSER_MODE, 0, aSet );
//STRIP001 				GetDocShell()->Execute( aReq );
//STRIP001 			}
//STRIP001 
//STRIP001 			// die Felder aktualisieren
//STRIP001 			BOOL bIsModified = pSh->IsModified();
//STRIP001 			pSh->StartAllAction();
//STRIP001 			SwDocStat aDocStat;
//STRIP001 			pSh->UpdateDocStat( aDocStat );
//STRIP001 			pSh->EndAllTblBoxEdit();
//STRIP001 			pSh->ViewShell::UpdateFlds(TRUE);
//STRIP001 			if( pSh->IsCrsrInTbl() )
//STRIP001 			{
//STRIP001 				pSh->ClearTblBoxCntnt();
//STRIP001 				pSh->SaveTblBoxCntnt();
//STRIP001 			}
//STRIP001 			pSh->EndAllAction();
//STRIP001 
//STRIP001 			if( !bIsModified )
//STRIP001 				pSh->ResetModified();
//STRIP001 
//STRIP001 			BOOL bPrtPros;
//STRIP001             SwView::MakeOptions( pDlg, aOpts, &bPrtPros, bWeb, GetPrinter(),
//STRIP001 							pSh->GetPrintData() );
//STRIP001 			if( -1 != bPrintSelection )
//STRIP001 				aOpts.bPrintSelection = 0 != bPrintSelection;
//STRIP001 
//STRIP001             ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue> aViewProperties(15);
//STRIP001 		    ::com::sun::star::beans::PropertyValue* pViewProperties =  aViewProperties.getArray();
//STRIP001 		    pViewProperties[1].Name = C2U("PrintGraphics");
//STRIP001 		    pViewProperties[1].Value <<= (sal_Bool)aOpts.IsPrintGraphic();
//STRIP001 		    pViewProperties[2].Name = C2U("PrintTables");
//STRIP001 		    pViewProperties[2].Value <<= (sal_Bool)aOpts.IsPrintTable();
//STRIP001 		    pViewProperties[3].Name = C2U("PrintDrawings");
//STRIP001 		    pViewProperties[3].Value <<= (sal_Bool)aOpts.IsPrintDraw();
//STRIP001 		    pViewProperties[4].Name = C2U("PrintLeftPages");
//STRIP001 		    pViewProperties[4].Value <<= (sal_Bool)aOpts.IsPrintLeftPage();
//STRIP001 		    pViewProperties[5].Name = C2U("PrintRightPages");
//STRIP001 		    pViewProperties[5].Value <<= (sal_Bool)aOpts.IsPrintRightPage();
//STRIP001 		    pViewProperties[6].Name = C2U("PrintControls");
//STRIP001 		    pViewProperties[6].Value <<= (sal_Bool)aOpts.IsPrintControl();
//STRIP001 		    pViewProperties[7].Name = C2U("PrintReversed");
//STRIP001 		    pViewProperties[7].Value <<= (sal_Bool)aOpts.IsPrintReverse();
//STRIP001 		    pViewProperties[8].Name = C2U("PrintPaperFromSetup");
//STRIP001 		    pViewProperties[8].Value <<= (sal_Bool)aOpts.IsPaperFromSetup();
//STRIP001 		    pViewProperties[9].Name = C2U("PrintFaxName");
//STRIP001 		    pViewProperties[9].Value <<= aOpts.GetFaxName();
//STRIP001 		    pViewProperties[10].Name = C2U("PrintAnnotationMode");
//STRIP001 		    pViewProperties[10].Value <<= (::com::sun::star::text::NotePrintMode) aOpts.GetPrintPostIts();
//STRIP001 		    pViewProperties[11].Name = C2U("PrintProspect");
//STRIP001 		    pViewProperties[11].Value <<= (sal_Bool)aOpts.IsPrintProspect();
//STRIP001 		    pViewProperties[12].Name = C2U("PrintPageBackground");
//STRIP001 		    pViewProperties[12].Value <<= (sal_Bool)aOpts.IsPrintPageBackground();
//STRIP001 		    pViewProperties[13].Name = C2U("PrintBlackFonts");
//STRIP001 		    pViewProperties[13].Value <<= (sal_Bool)aOpts.IsPrintBlackFont();
//STRIP001 		    pViewProperties[0].Name = C2U("IsSinglePrintJob");
//STRIP001 		    pViewProperties[0].Value <<= (sal_Bool)aOpts.IsPrintSingleJobs();
//STRIP001             pViewProperties[14].Name = C2U("Selection");
//STRIP001             pViewProperties[14].Value <<= (sal_Bool)aOpts.bPrintSelection;
//STRIP001 		    SetAdditionalPrintOptions(aViewProperties);
//STRIP001 
//STRIP001 			SfxViewShell::Print(*pProgress);
//STRIP001 			if ( !pProgress->IsAborted() )
//STRIP001 			{
//STRIP001 				if( bPrtPros )
//STRIP001 				{
//STRIP001 					bStartJob = pPrinter->StartJob( aOpts.GetJobName() );
//STRIP001 					if( bStartJob )
//STRIP001 						pSh->PrintProspect( aOpts, *pProgress );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					bStartJob = pSh->Prt( aOpts, *pProgress );
//STRIP001 
//STRIP001 				if ( bBrowse )
//STRIP001 				{
//STRIP001 					aBrowse.SetValue( TRUE );
//STRIP001 					aSet.Put( aBrowse, aBrowse.Which() );
//STRIP001 					SfxRequest aReq( SID_BROWSER_MODE, 0, aSet );
//STRIP001 					GetDocShell()->Execute( aReq );
//STRIP001 					pSh->UnlockPaint();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				bStartJob = FALSE;
//STRIP001 
//STRIP001             pSh->LockView( bLockedView );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	bIsApi = FALSE;
//STRIP001 	if( !bStartJob )
//STRIP001 	{
//STRIP001 		// Printer konnte nicht gestartet werden
//STRIP001 		delete pProgress;
//STRIP001         return pPrinter->GetError();
//STRIP001 	}
//STRIP001 
//STRIP001 	pProgress->Stop();
//STRIP001 	pProgress->DeleteOnEndPrint();
//STRIP001 	pPrinter->EndJob();
//STRIP001 	return pPrinter->GetError();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	TabPage fuer applikationsspezifische Druckoptionen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SfxTabPage* __EXPORT SwView::CreatePrintOptionsPage(Window* pParent,
//STRIP001 													const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	return ::CreatePrintOptionsPage( pParent, rSet, FALSE );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Druckerdialog
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 PrintDialog* CreatePrintDialog( Window* pParent, USHORT nPg, SwWrtShell* pSh )
//STRIP001 {
//STRIP001 	PrintDialog *pDlg =
//STRIP001 		new PrintDialog( pParent );
//STRIP001 //	pDlg->ChangeFirstPage( 1 );
//STRIP001 
//STRIP001 	if ( !nPg )
//STRIP001 		nPg = 1;
//STRIP001 //	pDlg->ChangeLastPage( nPg );
//STRIP001 //	pDlg->ChangeMaxPage( 9999 );
//STRIP001 	pDlg->EnableRange( PRINTDIALOG_FROMTO );
//STRIP001 
//STRIP001 	if (pSh && (pSh->IsSelection() || pSh->IsFrmSelected() || pSh->IsObjSelected()))
//STRIP001 		pDlg->EnableRange( PRINTDIALOG_SELECTION );
//STRIP001 
//STRIP001 	pDlg->SetRangeText( String::CreateFromInt32(nPg) );
//STRIP001 	pDlg->EnableRange( PRINTDIALOG_RANGE );
//STRIP001 	pDlg->EnableCollate();
//STRIP001 	return pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 PrintDialog* __EXPORT SwView::CreatePrintDialog( Window* pParent )
//STRIP001 {
//STRIP001 	// AMA: Hier sollte vielleicht die virtuelle Seitennummer angezeigt werden,
//STRIP001 	// 		aber nur, wenn das Drucken virtuelle Seitennummern und nicht wie
//STRIP001 	//		bisher (auch beim SWG 2.0) physikalische beachtet werden.
//STRIP001 	return ::CreatePrintDialog( pParent, GetWrtShell().GetPhyPageNum(), &GetWrtShell() );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Print-Dispatcher
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void __EXPORT SwView::ExecutePrint(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
//STRIP001 	::binfilter::SetAppPrintOptions( &GetWrtShell(), bWeb );
//STRIP001 	switch (rReq.GetSlot())
//STRIP001 	{
//STRIP001 		case FN_FAX:
//STRIP001 		{
//STRIP001 			SwPrintOptions* pOpt = SW_MOD()->GetPrtOptions(bWeb);
//STRIP001 			String sFaxName(pOpt->GetFaxName());
//STRIP001 			if (sFaxName.Len())
//STRIP001 			{
//STRIP001 				SfxStringItem aPrinterName(SID_PRINTER_NAME, sFaxName);
//STRIP001 				SfxBoolItem aSilent( SID_SILENT, TRUE );
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute( SID_PRINTDOC,
//STRIP001 							SFX_CALLMODE_SYNCHRON|SFX_CALLMODE_RECORD,
//STRIP001 							&aPrinterName, &aSilent, 0L );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				InfoBox aInfoBox(&GetEditWin(), SW_RES(MSG_ERR_NO_FAX));
//STRIP001 				String sMsg = aInfoBox.GetMessText();
//STRIP001 				USHORT nResNo = bWeb ? STR_WEBOPTIONS : STR_TEXTOPTIONS;
//STRIP001 				sMsg.SearchAndReplace(String::CreateFromAscii("%1"), String(SW_RES(nResNo)));
//STRIP001 				aInfoBox.SetMessText(sMsg);
//STRIP001 				aInfoBox.Execute();
//STRIP001 				SfxUInt16Item aDefPage(SID_SW_EDITOPTIONS, TP_OPTPRINT_PAGE);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_SW_EDITOPTIONS,
//STRIP001 							SFX_CALLMODE_SYNCHRON|SFX_CALLMODE_RECORD,
//STRIP001 							&aDefPage, 0L );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_PRINTDOC:
//STRIP001 		case SID_PRINTDOCDIRECT:
//STRIP001 		{
//STRIP001 			SwWrtShell* pSh = &GetWrtShell();
//STRIP001 			SwViewOption* pOrgViewOption = 0;
//STRIP001             SFX_REQUEST_ARG(rReq, pSilentItem, SfxBoolItem, SID_SILENT, FALSE);
//STRIP001             BOOL bSilent = pSilentItem ? pSilentItem->GetValue() : FALSE;
//STRIP001             SFX_REQUEST_ARG(rReq, pPrintFromMergeItem, SfxBoolItem, FN_QRY_MERGE, FALSE);
//STRIP001 			if(pPrintFromMergeItem)
//STRIP001 				rReq.RemoveItem(FN_QRY_MERGE);
//STRIP001             BOOL bFromMerge = pPrintFromMergeItem ? pPrintFromMergeItem->GetValue() : FALSE;
//STRIP001             if(!bSilent && !bFromMerge && pSh->IsAnyDatabaseFieldInDoc())
//STRIP001             {
//STRIP001                 QueryBox aBox( &GetEditWin(), SW_RES( MSG_PRINT_AS_MERGE ));
//STRIP001                 if(RET_YES == aBox.Execute())
//STRIP001                 {
//STRIP001                     SfxBoolItem aBool(FN_QRY_MERGE, TRUE);
//STRIP001                     GetViewFrame()->GetDispatcher()->Execute(
//STRIP001                                 FN_QRY_MERGE, SFX_CALLMODE_ASYNCHRON, &aBool, 0L);
//STRIP001                     rReq.Ignore();
//STRIP001 					return;
//STRIP001                 }
//STRIP001             }
//STRIP001             if(!bSilent && pSh->GetViewOptions()->IsFldName() && pSh->IsAnyFieldInDoc())
//STRIP001 			{
//STRIP001 				QueryBox aBox( &GetEditWin(), SW_RES( DLG_PRT_FIELDNAME ) );
//STRIP001 				USHORT nRet = aBox.Execute();
//STRIP001 				if( RET_CANCEL == nRet)
//STRIP001 					return;
//STRIP001 				// disable field commands
//STRIP001 				if( RET_NO == nRet )
//STRIP001 				{
//STRIP001 					pOrgViewOption = new SwViewOption(*pSh->GetViewOptions());
//STRIP001 					pOrgViewOption->SetFldName(FALSE);
//STRIP001 					SW_MOD()->ApplyUsrPref(*pOrgViewOption, this, VIEWOPT_DEST_VIEW_ONLY );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			bIsApi = rReq.IsAPI();
//STRIP001 			SfxViewShell::ExecuteSlot( rReq, SfxViewShell::GetInterface() );
//STRIP001 			if(pOrgViewOption)
//STRIP001 			{
//STRIP001 				pOrgViewOption->SetFldName(TRUE);
//STRIP001 				SW_MOD()->ApplyUsrPref(*pOrgViewOption, this, VIEWOPT_DEST_VIEW_ONLY );
//STRIP001 				delete pOrgViewOption;
//STRIP001 			}
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		default:
//STRIP001 			ASSERT(!this, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Page Drucker/Zusaetze erzeugen fuer SwView und
//STRIP001 					SwPagePreview
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SfxTabPage* CreatePrintOptionsPage( Window *pParent,
//STRIP001 								const SfxItemSet &rOptions, BOOL bPreview )
//STRIP001 {
//STRIP001 	SwAddPrinterTabPage* pPage = ( SwAddPrinterTabPage* )
//STRIP001 							SwAddPrinterTabPage::Create(pParent, rOptions);
//STRIP001 	pPage->SetPreview(bPreview);
//STRIP001 
//STRIP001 	SvStringsDtor aFaxList;
//STRIP001 	const USHORT nCount = Printer::GetQueueCount();
//STRIP001 	pPage->Reset(rOptions);
//STRIP001 	for (USHORT i = 0; i < nCount; ++i)
//STRIP001 	{
//STRIP001 		String* pString = new String( Printer::GetQueueInfo( i ).GetPrinterName() );
//STRIP001 		aFaxList.Insert(pString, 0);
//STRIP001 	}
//STRIP001 	pPage->SetFax( aFaxList );
//STRIP001 	return pPage;
//STRIP001 }


/*N*/ void SetAppPrintOptions( ViewShell* pSh, BOOL bWeb )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SwPrintData aPrtData = *SW_MOD()->GetPrtOptions(bWeb);
//STRIP001     SwPrintData* pShellPrintData = pSh->GetPrintData();
//STRIP001     if(pShellPrintData)
//STRIP001         aPrtData = *pShellPrintData;
//STRIP001     if( pSh && pSh->GetPrt())
//STRIP001 	{
//STRIP001 		// Applikationseigene Druckoptionen in SfxPrinter schiessen
//STRIP001         SwAddPrinterItem aAddPrinterItem (FN_PARAM_ADDPRINTER, aPrtData);
//STRIP001 		SfxItemSet aSet( pSh->GetAttrPool(),
//STRIP001 					FN_PARAM_ADDPRINTER, 		FN_PARAM_ADDPRINTER,
//STRIP001 					SID_HTML_MODE,				SID_HTML_MODE,
//STRIP001 					SID_PRINTER_NOTFOUND_WARN, 	SID_PRINTER_NOTFOUND_WARN,
//STRIP001 					SID_PRINTER_CHANGESTODOC, 	SID_PRINTER_CHANGESTODOC,
//STRIP001 					0 );
//STRIP001 
//STRIP001             SfxMiscCfg* pMisc = SFX_APP()->GetMiscConfig();
//STRIP001 
//STRIP001 		if(bWeb)
//STRIP001 			aSet.Put(SfxUInt16Item(SID_HTML_MODE,
//STRIP001 					::binfilter::GetHtmlMode(((SwWrtShell*)pSh)->GetView().GetDocShell())));
//STRIP001 		aSet.Put(SfxBoolItem(SID_PRINTER_NOTFOUND_WARN,
//STRIP001 						pMisc->IsNotFoundWarning() ));
//STRIP001 		aSet.Put(aAddPrinterItem);
//STRIP001 		aSet.Put( SfxFlagItem( SID_PRINTER_CHANGESTODOC,
//STRIP001 			(pMisc->IsPaperSizeWarning() ? SFX_PRINTER_CHG_SIZE : 0)   |
//STRIP001             (pMisc->IsPaperOrientationWarning()  ? SFX_PRINTER_CHG_ORIENTATION : 0 )));
//STRIP001 
//STRIP001 		pSh->GetPrt()->SetOptions( aSet );
//STRIP001 	}
//STRIP001 
/*N*/ }

}
