/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_actctrl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:57:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop


#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#include "actctrl.hxx"
namespace binfilter {



void NumEditAction::Action()
{
	aActionLink.Call( this );
}


long NumEditAction::Notify( NotifyEvent& rNEvt )
{
	long nHandled = 0;

	if ( rNEvt.GetType() == EVENT_KEYINPUT )
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		const KeyCode aKeyCode = pKEvt->GetKeyCode();
		const USHORT nModifier = aKeyCode.GetModifier();
		if( aKeyCode.GetCode() == KEY_RETURN &&
				!nModifier)
		{
			Action();
			nHandled = 1;
		}

	}
	if(!nHandled)
		NumericField::Notify( rNEvt );
	return nHandled;
}

/*------------------------------------------------------------------------
 Beschreibung:	KeyInput fuer ShortName - Edits ohne Spaces
------------------------------------------------------------------------*/


void NoSpaceEdit::KeyInput(const KeyEvent& rEvt)
{
	BOOL bCallParent = TRUE;
	if(rEvt.GetCharCode())
	{
		String sKey = rEvt.GetCharCode();
		if(	STRING_NOTFOUND != sForbiddenChars.Search(sKey))
			bCallParent = FALSE;
	}
	if(bCallParent)
		Edit::KeyInput(rEvt);
}
/* -----------------------------11.02.00 15:28--------------------------------

 ---------------------------------------------------------------------------*/
void NoSpaceEdit::Modify()
{
	Selection aSel = GetSelection();
	String sTemp = GetText();
	for(USHORT i = 0; i < sForbiddenChars.Len(); i++)
	{
		sTemp.EraseAllChars( sForbiddenChars.GetChar(i) );
	}
	USHORT nDiff = GetText().Len() - sTemp.Len();
	if(nDiff)
	{
		aSel.setMin(aSel.getMin() - nDiff);
		aSel.setMax(aSel.getMin());
		SetText(sTemp);
		SetSelection(aSel);
	}
	if(GetModifyHdl().IsSet())
		GetModifyHdl().Call(this);
}
/* -----------------25.06.2003 15:57-----------------

 --------------------------------------------------*/
ReturnActionEdit::~ReturnActionEdit()
{
}            
/* -----------------25.06.2003 15:58-----------------

 --------------------------------------------------*/
void ReturnActionEdit::KeyInput( const KeyEvent& rEvt)
{
    const KeyCode aKeyCode = rEvt.GetKeyCode();
    const USHORT nModifier = aKeyCode.GetModifier();
    if( aKeyCode.GetCode() == KEY_RETURN &&
            !nModifier)
    {
        if(aReturnActionLink.IsSet())
            aReturnActionLink.Call(this);
    }    
    else 
        Edit::KeyInput(rEvt);
}            



}
