/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdxfer.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:44:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_FIELD EE_FEATURE_FIELD

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_ 
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _UNTOOLS_TEMPFILE_HXX
#include <unotools/tempfile.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

#ifndef _PSTM_HXX
#include <tools/pstm.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#ifndef _SVX_FLDITEM_HXX //autogen
#include <bf_svx/flditem.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVDOOLE2_HXX //autogen
#include <bf_svx/svdoole2.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <bf_svx/svdograf.hxx>
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include <bf_svx/svdotext.hxx>
#endif
#ifndef _OUTLOBJ_HXX //autogen
#include <bf_svx/outlobj.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _EDITOBJ_HXX //autogen
#include <bf_svx/editobj.hxx>
#endif
#ifndef _SVX_FMGLOB_HXX
#include <bf_svx/fmglob.hxx>
#endif
#ifndef _SVDOUNO_HXX //autogen
#include <bf_svx/svdouno.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SOT_FORMATS_HXX //autogen
#include <sot/formats.hxx>
#endif
#ifndef _URLBMK_HXX //autogen
#include <svtools/urlbmk.hxx>
#endif
#ifndef _OUTLINER_HXX //autogen
#include <bf_svx/outliner.hxx>
#endif
#ifndef _SVDETC_HXX //autogen
#include <bf_svx/svdetc.hxx>
#endif

#ifndef _COM_SUN_STAR_FORM_FORMBUTTONTYPE_HPP_
#include <com/sun/star/form/FormButtonType.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _UTL_STREAM_WRAPPER_HXX_ 
#include <unotools/streamwrap.hxx>
#endif

#include <so3/outplace.hxx>
#include <bf_svx/unomodel.hxx>
#include <bf_svx/svditer.hxx>

#include "docshell.hxx"
#include "sdview.hxx"
#include "sdpage.hxx"
#include "drawview.hxx"
#include "drawdoc.hxx"
#include "stlpool.hxx"
#include "strings.hrc"
#include "sdresid.hxx"
#include "imapinfo.hxx"
#include "sdxfer.hxx"
#include "unomodel.hxx"
namespace binfilter {

// --------------
// - Namespaces -
// --------------

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::datatransfer;
using namespace ::com::sun::star::datatransfer::clipboard;

// -----------
// - Defines -
// -----------

#define SDTRANSFER_OBJECTTYPE_DRAWMODEL			0x00000001
#define SDTRANSFER_OBJECTTYPE_DRAWOLE			0x00000002

// ------------------
// - SdTransferable -
// ------------------

//STRIP001 SdTransferable::SdTransferable( SdDrawDocument* pSrcDoc, SdView* pWorkView, BOOL bInitOnGetData ) :
//STRIP001 	pObjDesc( NULL ),
//STRIP001     pPageDocShell( NULL ),
//STRIP001 	pSourceDoc( pSrcDoc ),
//STRIP001 	pSdViewIntern( pWorkView ),
//STRIP001 	pSdView( pWorkView ),
//STRIP001 	pSdDrawDocumentIntern( NULL ),
//STRIP001 	pSdDrawDocument( NULL ),
//STRIP001 	pVDev( NULL ),
//STRIP001 	bInternalMove( FALSE ),
//STRIP001 	bOwnView( FALSE ),
//STRIP001 	bOwnDocument( FALSE ),
//STRIP001     pOLEDataHelper( NULL ),
//STRIP001 	pBookmark( NULL ),
//STRIP001 	pGraphic( NULL ),
//STRIP001 	pImageMap( NULL ),
//STRIP001     bLateInit( bInitOnGetData ),
//STRIP001     bPageTransferable( FALSE ),
//STRIP001     bPageTransferablePersistent( FALSE ),
//STRIP001 	mbIsUnoObj( false )
//STRIP001 {
//STRIP001     if( !bLateInit )
//STRIP001 	    CreateData();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 SdTransferable::~SdTransferable()
//STRIP001 {
//STRIP001 	Application::GetSolarMutex().acquire();
//STRIP001 
//STRIP001     ObjectReleased();
//STRIP001 
//STRIP001     for( void* p = aPageBookmarks.First(); p; p = aPageBookmarks.Next() )
//STRIP001         delete static_cast< String* >( p );
//STRIP001 
//STRIP001 	if( bOwnView )
//STRIP001 		delete pSdViewIntern;
//STRIP001 
//STRIP001 	if( bOwnDocument )
//STRIP001 		delete pSdDrawDocumentIntern;
//STRIP001 
//STRIP001     delete pOLEDataHelper;
//STRIP001 
//STRIP001 	if( aDocShellRef.Is() )
//STRIP001 	{
//STRIP001 		SvEmbeddedObject* pObj = aDocShellRef;
//STRIP001 		SdDrawDocShell* pDocSh = (SdDrawDocShell*) pObj;
//STRIP001 		pDocSh->DoClose();
//STRIP001 	}
//STRIP001 
//STRIP001 	aDocShellRef.Clear();
//STRIP001 
//STRIP001 	delete pGraphic;
//STRIP001 	delete pBookmark;
//STRIP001 	delete pImageMap;
//STRIP001 
//STRIP001 	delete pVDev;
//STRIP001 	delete pObjDesc; 
//STRIP001 
//STRIP001 	Application::GetSolarMutex().release();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTransferable::CreateObjectReplacement( SdrObject* pObj )
//STRIP001 {
//STRIP001 	if( pObj )
//STRIP001 	{
//STRIP001 		UINT32 nInv = pObj->GetObjInventor();
//STRIP001 		UINT16 nIdent = pObj->GetObjIdentifier();
//STRIP001 
//STRIP001         delete pOLEDataHelper, pOLEDataHelper = NULL;
//STRIP001 		delete pGraphic, pGraphic = NULL;
//STRIP001 		delete pBookmark, pBookmark = NULL;
//STRIP001 		delete pImageMap, pImageMap = NULL;
//STRIP001 
//STRIP001 		if( pObj->ISA( SdrOle2Obj ) )
//STRIP001 		{
//STRIP001 			const SvInPlaceObjectRef& rOldObjRef = static_cast< SdrOle2Obj* >( pObj )->GetObjRef();
//STRIP001 			
//STRIP001 			if( rOldObjRef.Is() )
//STRIP001 				pOLEDataHelper = new TransferableDataHelper( rOldObjRef->CreateTransferableSnapshot() );
//STRIP001 		}
//STRIP001 		else if( pObj->ISA( SdrGrafObj ) && !pSourceDoc->GetAnimationInfo( pObj ) )
//STRIP001 		{
//STRIP001 			pGraphic = new Graphic( static_cast< SdrGrafObj* >( pObj )->GetTransformedGraphic() );
//STRIP001 		}
//STRIP001 		else if( pObj->IsUnoObj() && FmFormInventor == pObj->GetObjInventor() && ( nIdent == (UINT16) OBJ_FM_BUTTON ) )
//STRIP001 		{
//STRIP001 			SdrUnoObj* pUnoCtrl = static_cast< SdrUnoObj* >( pObj );
//STRIP001 			
//STRIP001 			if (pUnoCtrl && FmFormInventor == pUnoCtrl->GetObjInventor())
//STRIP001 			{
//STRIP001 				Reference< ::com::sun::star::awt::XControlModel > xControlModel( pUnoCtrl->GetUnoControlModel() );
//STRIP001 
//STRIP001 				if( !xControlModel.is() )
//STRIP001 					return;
//STRIP001 
//STRIP001 				Reference< ::com::sun::star::beans::XPropertySet > xPropSet( xControlModel, UNO_QUERY );
//STRIP001 				
//STRIP001 				if( !xPropSet.is() )
//STRIP001 					return;
//STRIP001 
//STRIP001 				::com::sun::star::form::FormButtonType	eButtonType;
//STRIP001 				Any										aTmp( xPropSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "ButtonType" ) ) ) );
//STRIP001 				
//STRIP001 				if( aTmp >>= eButtonType )
//STRIP001 				{
//STRIP001 					::rtl::OUString aLabel, aURL;
//STRIP001 					
//STRIP001 					xPropSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "Label" ) ) ) >>= aLabel;
//STRIP001 					xPropSet->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("TargetURL") ) ) >>= aURL;
//STRIP001 
//STRIP001 					pBookmark = new INetBookmark( String( aURL ), String( aLabel ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( pObj->ISA( SdrTextObj ) )
//STRIP001 		{
//STRIP001 			const OutlinerParaObject* pPara;
//STRIP001 			
//STRIP001 			if( pPara = static_cast< SdrTextObj* >( pObj )->GetOutlinerParaObject() )
//STRIP001 			{
//STRIP001 				const SvxFieldItem* pField;
//STRIP001 				
//STRIP001 				if( pField = pPara->GetTextObject().GetField() )
//STRIP001 				{
//STRIP001 					const SvxFieldData* pData = pField->GetField();
//STRIP001 				
//STRIP001 					if( pData && pData->ISA( SvxURLField ) )
//STRIP001 					{
//STRIP001 						const SvxURLField* pURL = (SvxURLField*) pData;
//STRIP001 
//STRIP001 						pBookmark = new INetBookmark( pURL->GetURL(), pURL->GetRepresentation() );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		SdIMapInfo*	pInfo = static_cast< SdDrawDocument* >( pObj->GetModel() )->GetIMapInfo( static_cast< SdrObject* >( pObj ) );
//STRIP001 
//STRIP001 		if( pInfo )
//STRIP001 			pImageMap = new ImageMap( pInfo->GetImageMap() );
//STRIP001 
//STRIP001 		mbIsUnoObj = pObj && pObj->IsUnoObj();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTransferable::CreateData()
//STRIP001 {
//STRIP001 	if( pSdDrawDocument && !pSdViewIntern )
//STRIP001 	{
//STRIP001 		bOwnView = TRUE;
//STRIP001 
//STRIP001 		SdPage* pPage = pSdDrawDocument->GetSdPage(0, PK_STANDARD);
//STRIP001 
//STRIP001 		if( 1 == pPage->GetObjCount() )
//STRIP001 			CreateObjectReplacement( pPage->GetObj( 0 ) );
//STRIP001 
//STRIP001 		pVDev = new VirtualDevice( *Application::GetDefaultDevice() );
//STRIP001 		pVDev->SetMapMode( MapMode( pSdDrawDocumentIntern->GetScaleUnit(), Point(), pSdDrawDocumentIntern->GetScaleFraction(), pSdDrawDocumentIntern->GetScaleFraction() ) );
//STRIP001 		pSdViewIntern = new SdView( pSdDrawDocumentIntern, pVDev );
//STRIP001 		pSdViewIntern->EndListening(*pSdDrawDocumentIntern );
//STRIP001 		pSdViewIntern->SetMarkHdlHidden( TRUE );
//STRIP001 		SdrPageView* pPageView = pSdViewIntern->ShowPage(pPage, Point());
//STRIP001 		((SdrMarkView*)pSdViewIntern)->MarkAll(pPageView);
//STRIP001 	}
//STRIP001 	else if( pSdView && !pSdDrawDocumentIntern )
//STRIP001 	{
//STRIP001 		bOwnDocument = TRUE;
//STRIP001 
//STRIP001 		const SdrMarkList& rMarkList = pSdView->GetMarkList();
//STRIP001 
//STRIP001 		if( rMarkList.GetMarkCount() == 1 )
//STRIP001 			CreateObjectReplacement( rMarkList.GetMark( 0 )->GetObj() );
//STRIP001 
//STRIP001 		pSdDrawDocumentIntern = (SdDrawDocument*) pSdView->GetAllMarkedModel();
//STRIP001 
//STRIP001 		if( !aDocShellRef.Is() && pSdDrawDocumentIntern->GetDocSh() )
//STRIP001 		{
//STRIP001 			// DocShell schon vorhanden ( AllocModel() )
//STRIP001 			aDocShellRef = pSdDrawDocumentIntern->GetDocSh();
//STRIP001 			bOwnDocument = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Groesse der Source-Seite uebernehmen
//STRIP001 		SdrPageView*		pPgView = pSdView->GetPageViewPvNum( 0 );
//STRIP001 		SdPage*				pOldPage = (SdPage*) pPgView->GetPage();
//STRIP001 		SdrModel*			pOldModel = pSdView->GetModel();
//STRIP001 		SdStyleSheetPool*	pOldStylePool = (SdStyleSheetPool*) pOldModel->GetStyleSheetPool();
//STRIP001 		SdStyleSheetPool*	pNewStylePool = (SdStyleSheetPool*) pSdDrawDocumentIntern->GetStyleSheetPool();
//STRIP001 		SdPage*				pPage = pSdDrawDocumentIntern->GetSdPage( 0, PK_STANDARD );
//STRIP001 		String				aOldLayoutName( pOldPage->GetLayoutName() );
//STRIP001 		
//STRIP001 		pPage->SetSize( pOldPage->GetSize() );
//STRIP001 		pPage->SetLayoutName( aOldLayoutName );
//STRIP001 		pNewStylePool->CopyGraphicSheets( *pOldStylePool );
//STRIP001 		aOldLayoutName.Erase( aOldLayoutName.SearchAscii( SD_LT_SEPARATOR ) );
//STRIP001 		pNewStylePool->CopyLayoutSheets( aOldLayoutName, *pOldStylePool );
//STRIP001 	}
//STRIP001 
//STRIP001 	// set VisArea and adjust objects if neccessary
//STRIP001 	if( aVisArea.IsEmpty() &&
//STRIP001 		pSdDrawDocumentIntern && pSdViewIntern && 
//STRIP001 		pSdDrawDocumentIntern->GetPageCount() )
//STRIP001 	{
//STRIP001 		SdPage*	pPage = pSdDrawDocumentIntern->GetSdPage( 0, PK_STANDARD );
//STRIP001 
//STRIP001 		if( 1 == pSdDrawDocumentIntern->GetPageCount() )
//STRIP001 		{
//STRIP001 			Point	aOrigin( ( aVisArea = pSdViewIntern->GetAllMarkedRect() ).TopLeft() );
//STRIP001 			Size	aVector( -aOrigin.X(), -aOrigin.Y() );
//STRIP001 
//STRIP001 			for( ULONG nObj = 0, nObjCount = pPage->GetObjCount(); nObj < nObjCount; nObj++ )
//STRIP001 			{
//STRIP001 				SdrObject* pObj = pPage->GetObj( nObj );
//STRIP001 				pObj->NbcMove( aVector );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aVisArea.SetSize( pPage->GetSize() );
//STRIP001 
//STRIP001 		// Die Ausgabe soll am Nullpunkt erfolgen
//STRIP001 		aVisArea.SetPos( Point() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL lcl_HasOnlyControls( SdrModel* pModel )
//STRIP001 {
//STRIP001     BOOL bOnlyControls = FALSE;         // default if there are no objects
//STRIP001 
//STRIP001     if ( pModel )
//STRIP001     {
//STRIP001         SdrPage* pPage = pModel->GetPage(0);
//STRIP001         if (pPage)
//STRIP001         {
//STRIP001             SdrObjListIter aIter( *pPage, IM_DEEPNOGROUPS );
//STRIP001             SdrObject* pObj = aIter.Next();
//STRIP001             if ( pObj )
//STRIP001             {
//STRIP001                 bOnlyControls = TRUE;   // only set if there are any objects at all
//STRIP001                 while ( pObj )
//STRIP001                 {
//STRIP001                     if (!pObj->ISA(SdrUnoObj))
//STRIP001                     {
//STRIP001                         bOnlyControls = FALSE;
//STRIP001                         break;
//STRIP001                     }
//STRIP001                     pObj = aIter.Next();
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bOnlyControls;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdTransferable::AddSupportedFormats()
//STRIP001 {
//STRIP001     if( !bPageTransferable || bPageTransferablePersistent )
//STRIP001     {
//STRIP001         if( !bLateInit )
//STRIP001             CreateData();
//STRIP001 
//STRIP001 	    if( pObjDesc )
//STRIP001             AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         
//STRIP001         if( pOLEDataHelper )
//STRIP001 	    {
//STRIP001 		    AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001 
//STRIP001 		    DataFlavorExVector				aVector( pOLEDataHelper->GetDataFlavorExVector() );
//STRIP001 		    DataFlavorExVector::iterator	aIter( aVector.begin() ), aEnd( aVector.end() );
//STRIP001 
//STRIP001 		    while( aIter != aEnd )
//STRIP001 			    AddFormat( *aIter++ );
//STRIP001 	    }
//STRIP001 	    else if( pGraphic )
//STRIP001 	    {
//STRIP001 		    AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001 
//STRIP001 		    if( pGraphic->GetType() == GRAPHIC_BITMAP )
//STRIP001 		    {
//STRIP001 			    AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 			    AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 		    }
//STRIP001 		    else
//STRIP001 		    {
//STRIP001 			    AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 			    AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 		    }
//STRIP001 	    }
//STRIP001 	    else if( pBookmark )
//STRIP001 	    {
//STRIP001 		    AddFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK );
//STRIP001 		    AddFormat( FORMAT_STRING );
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 	    {
//STRIP001 		    AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001 		    AddFormat( SOT_FORMATSTR_ID_DRAWING );
//STRIP001 			if( !pSdDrawDocument || !lcl_HasOnlyControls( pSdDrawDocument ) )
//STRIP001 			{
//STRIP001 				AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 				AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 			}
//STRIP001 	    }
//STRIP001 
//STRIP001 	    if( pImageMap )
//STRIP001 		    AddFormat( SOT_FORMATSTR_ID_SVIM );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SdTransferable::GetData( const DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_uInt32	nFormat = SotExchange::GetFormat( rFlavor );
//STRIP001 	sal_Bool	bOK = sal_False;
//STRIP001 
//STRIP001     CreateData();
//STRIP001 
//STRIP001 	if( pOLEDataHelper && pOLEDataHelper->HasFormat( rFlavor ) )
//STRIP001 	{
//STRIP001 		ULONG nOldSwapMode;
//STRIP001 
//STRIP001 		if( pSdDrawDocumentIntern )
//STRIP001 		{
//STRIP001 			nOldSwapMode = pSdDrawDocumentIntern->GetSwapGraphicsMode();
//STRIP001 			pSdDrawDocumentIntern->SetSwapGraphicsMode( SDR_SWAPGRAPHICSMODE_PURGE );
//STRIP001 		}
//STRIP001 
//STRIP001 		bOK = SetAny( pOLEDataHelper->GetAny( rFlavor ), rFlavor );
//STRIP001 
//STRIP001 		if( pSdDrawDocumentIntern )
//STRIP001 			pSdDrawDocumentIntern->SetSwapGraphicsMode( nOldSwapMode );
//STRIP001 	}
//STRIP001 	else if( HasFormat( nFormat ) )
//STRIP001 	{
//STRIP001 		if( ( nFormat == SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR || nFormat == SOT_FORMATSTR_ID_OBJECTDESCRIPTOR ) && pObjDesc )
//STRIP001 		{
//STRIP001 			bOK = SetTransferableObjectDescriptor( *pObjDesc, rFlavor );
//STRIP001 		}
//STRIP001 		else if( nFormat == SOT_FORMATSTR_ID_DRAWING )
//STRIP001 		{
//STRIP001 			SdDrawDocument* pDoc = (SdDrawDocument*) pSdViewIntern->GetAllMarkedModel();
//STRIP001 			bOK = SetObject( pDoc, SDTRANSFER_OBJECTTYPE_DRAWMODEL, rFlavor );
//STRIP001 			delete pDoc;
//STRIP001 		}
//STRIP001 		else if( nFormat == FORMAT_GDIMETAFILE )
//STRIP001 		{
//STRIP001 			bOK = SetGDIMetaFile( pSdViewIntern->GetAllMarkedMetaFile( TRUE ), rFlavor );
//STRIP001 		}
//STRIP001 		else if( nFormat == FORMAT_BITMAP )
//STRIP001 		{
//STRIP001 			bOK = SetBitmap( pSdViewIntern->GetAllMarkedBitmap( TRUE ), rFlavor );
//STRIP001 		}
//STRIP001 		else if( ( nFormat == FORMAT_STRING ) && pBookmark )
//STRIP001 		{
//STRIP001 			bOK = SetString( pBookmark->GetURL(), rFlavor );
//STRIP001 		}
//STRIP001 		else if( ( nFormat == SOT_FORMATSTR_ID_SVXB ) && pGraphic )
//STRIP001 		{
//STRIP001 			bOK = SetGraphic( *pGraphic, rFlavor );
//STRIP001 		}
//STRIP001 		else if( ( nFormat == SOT_FORMATSTR_ID_SVIM ) && pImageMap )
//STRIP001 		{
//STRIP001 			bOK = SetImageMap( *pImageMap, rFlavor );
//STRIP001 		}
//STRIP001 		else if( pBookmark )
//STRIP001 		{
//STRIP001 			bOK = SetINetBookmark( *pBookmark, rFlavor );
//STRIP001 		}
//STRIP001 		else if( nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE )
//STRIP001 		{
//STRIP001 			ULONG nOldSwapMode;
//STRIP001 
//STRIP001 			if( pSdDrawDocumentIntern )
//STRIP001 			{
//STRIP001 				nOldSwapMode = pSdDrawDocumentIntern->GetSwapGraphicsMode();
//STRIP001 				pSdDrawDocumentIntern->SetSwapGraphicsMode( SDR_SWAPGRAPHICSMODE_PURGE );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !aDocShellRef.Is() )
//STRIP001 			{
//STRIP001 				aDocShellRef = new SdDrawDocShell( pSdDrawDocumentIntern, SFX_CREATE_MODE_EMBEDDED, TRUE, pSdDrawDocumentIntern->GetDocumentType() );
//STRIP001 				bOwnDocument = FALSE;
//STRIP001 				aDocShellRef->DoInitNew( NULL );
//STRIP001 			}
//STRIP001 
//STRIP001 			aDocShellRef->SetVisArea( aVisArea );
//STRIP001 			bOK = SetObject( &aDocShellRef, SDTRANSFER_OBJECTTYPE_DRAWOLE, rFlavor );
//STRIP001 
//STRIP001 			if( pSdDrawDocumentIntern )
//STRIP001 				pSdDrawDocumentIntern->SetSwapGraphicsMode( nOldSwapMode );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bOK;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 /* testcode
//STRIP001 #ifndef _SFXDOCFILE_HXX 
//STRIP001 #include <bf_sfx2/docfile.hxx>
//STRIP001 #endif
//STRIP001 */
//STRIP001 
//STRIP001 sal_Bool SdTransferable::WriteObject( SotStorageStreamRef& rxOStm, void* pObject, sal_uInt32 nObjectType, const DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 
//STRIP001 	switch( nObjectType )
//STRIP001 	{
//STRIP001 		case( SDTRANSFER_OBJECTTYPE_DRAWMODEL ):
//STRIP001 		{
//STRIP001 			SdDrawDocument* pDoc = (SdDrawDocument*) pObject;
//STRIP001 			pDoc->BurnInStyleSheetAttributes();
//STRIP001 			pDoc->SetStreamingSdrModel( TRUE );
//STRIP001 			pDoc->RemoveNotPersistentObjects( TRUE );
//STRIP001 			rxOStm->SetBufferSize( 16348 );
//STRIP001 
//STRIP001 			Reference< XComponent > xComponent( new SdXImpressDocument( pDoc, sal_True ) );
//STRIP001 			pDoc->setUnoModel( Reference< XInterface >::query( xComponent ) );
//STRIP001 
//STRIP001 			{
//STRIP001 				::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream> xDocOut( new utl::OOutputStreamWrapper( *rxOStm ) );
//STRIP001 				if( SvxDrawingLayerExport( pDoc, xDocOut, xComponent, (pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS) ? "com.sun.star.comp.Impress.XMLClipboardExporter" : "com.sun.star.comp.DrawingLayer.XMLExporter" ) )
//STRIP001 					rxOStm->Commit();
//STRIP001 			}
//STRIP001 
//STRIP001 /* testcode
//STRIP001 			{
//STRIP001 				const ::rtl::OUString aURL( RTL_CONSTASCII_USTRINGPARAM( "file:///e:/test.xml" ) );
//STRIP001 				SfxMedium aMedium( aURL, STREAM_WRITE | STREAM_TRUNC, TRUE );
//STRIP001 				aMedium.IsRemote();
//STRIP001 				::com::sun::star::uno::Reference< ::com::sun::star::io::XOutputStream> xDocOut( new utl::OOutputStreamWrapper( *aMedium.GetOutStream() ) );
//STRIP001 				if( SvxDrawingLayerExport( pDoc, xDocOut, xComponent, (pDoc->GetDocumentType() == DOCUMENT_TYPE_IMPRESS) ? "com.sun.star.comp.Impress.XMLClipboardExporter" : "com.sun.star.comp.DrawingLayer.XMLExporter" ) )
//STRIP001 					aMedium.Commit();
//STRIP001 			}
//STRIP001 */
//STRIP001 
//STRIP001 			pDoc->SetStreamingSdrModel( FALSE );
//STRIP001 
//STRIP001 			bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( SDTRANSFER_OBJECTTYPE_DRAWOLE ):
//STRIP001 		{
//STRIP001 			SvEmbeddedObject*	pEmbObj = (SvEmbeddedObject*) pObject;
//STRIP001             ::utl::TempFile     aTempFile;
//STRIP001 			SvStorageRef		xWorkStore( new SvStorage( TRUE, aTempFile.GetURL() ) );
//STRIP001 
//STRIP001             aTempFile.EnableKillingFile();
//STRIP001 
//STRIP001 			// write document storage
//STRIP001 			xWorkStore->SetVersion( SOFFICE_FILEFORMAT_60 );
//STRIP001 			pEmbObj->SetupStorage( xWorkStore );
//STRIP001 			bRet = pEmbObj->DoSaveAs( xWorkStore );
//STRIP001 			pEmbObj->DoSaveCompleted();
//STRIP001 			xWorkStore->Commit();
//STRIP001 			xWorkStore.Clear();
//STRIP001 
//STRIP001 			SvStream* pSrcStm = ::utl::UcbStreamHelper::CreateStream( aTempFile.GetURL(), STREAM_READ );
//STRIP001 
//STRIP001 			if( pSrcStm )
//STRIP001 			{
//STRIP001 				rxOStm->SetBufferSize( 0xff00 );
//STRIP001 				*rxOStm << *pSrcStm;
//STRIP001 				rxOStm->Commit();
//STRIP001 				delete pSrcStm;
//STRIP001 			}
//STRIP001 
//STRIP001 			bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTransferable::DragFinished( sal_Int8 nDropAction )
//STRIP001 {
//STRIP001 	if( pSdView )
//STRIP001 		( (SdView*) pSdView )->DragFinished( nDropAction );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTransferable::ObjectReleased()
//STRIP001 {
//STRIP001 	if( this == SD_MOD()->pTransferClip )
//STRIP001 		SD_MOD()->pTransferClip = NULL;
//STRIP001 
//STRIP001 	if( this == SD_MOD()->pTransferDrag )
//STRIP001 		SD_MOD()->pTransferDrag = NULL;
//STRIP001 
//STRIP001 	if( this == SD_MOD()->pTransferSelection )
//STRIP001 		SD_MOD()->pTransferSelection = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 								
//STRIP001 void SdTransferable::SetObjectDescriptor( const TransferableObjectDescriptor& rObjDesc )
//STRIP001 {
//STRIP001 	delete pObjDesc;
//STRIP001 	pObjDesc = new TransferableObjectDescriptor( rObjDesc );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdTransferable::SetPageBookmarks( const List& rPageBookmarks, BOOL bPersistent )
//STRIP001 {
//STRIP001     if( pSourceDoc )
//STRIP001     {
//STRIP001 	    if( pSdViewIntern )
//STRIP001 		    pSdViewIntern->HideAllPages();
//STRIP001 
//STRIP001         pSdDrawDocument->Clear();
//STRIP001         pPageDocShell = NULL;
//STRIP001 
//STRIP001         for( void* p = aPageBookmarks.First(); p; p = aPageBookmarks.Next() )
//STRIP001             delete static_cast< String* >( p );
//STRIP001 
//STRIP001         if( bPersistent )
//STRIP001         {
//STRIP001             pSdDrawDocument->CreateFirstPages();
//STRIP001             pSdDrawDocument->InsertBookmarkAsPage( const_cast< List* >( &rPageBookmarks ), NULL, FALSE, TRUE, 1, TRUE, pSourceDoc->GetDocSh(), TRUE, TRUE, FALSE );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             pPageDocShell = pSourceDoc->GetDocSh();
//STRIP001 
//STRIP001             for( ULONG i = 0; i < rPageBookmarks.Count(); i++ )
//STRIP001                 aPageBookmarks.Insert( new String( *static_cast< String* >( rPageBookmarks.GetObject( i ) ) ), LIST_APPEND );
//STRIP001         }
//STRIP001 
//STRIP001 	    if( pSdViewIntern && pSdDrawDocument )
//STRIP001 	    {
//STRIP001 		    SdPage* pPage = pSdDrawDocument->GetSdPage( 0, PK_STANDARD );
//STRIP001 
//STRIP001 		    if( pPage )
//STRIP001             {
//STRIP001 			    ( (SdrMarkView*) pSdViewIntern )->MarkAll( (SdrPageView*) pSdViewIntern->ShowPage( pPage, Point() ) );
//STRIP001             }
//STRIP001 	    }
//STRIP001 
//STRIP001         // set flags for page transferable; if ( bPageTransferablePersistent == FALSE ),
//STRIP001         // don't offer any formats => it's just for internal puposes
//STRIP001         bPageTransferable = TRUE;
//STRIP001         bPageTransferablePersistent = bPersistent;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int64 SAL_CALL SdTransferable::getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& rId ) throw( ::com::sun::star::uno::RuntimeException )
//STRIP001 {
//STRIP001     sal_Int64 nRet;
//STRIP001 
//STRIP001     if( ( rId.getLength() == 16 ) && 
//STRIP001         ( 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(), rId.getConstArray(), 16 ) ) )
//STRIP001     {
//STRIP001         nRet = (sal_Int64) this;
//STRIP001     }
//STRIP001     else
//STRIP001         nRet = 0;
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 const ::com::sun::star::uno::Sequence< sal_Int8 >& SdTransferable::getUnoTunnelId()
//STRIP001 {
//STRIP001     static ::com::sun::star::uno::Sequence< sal_Int8 > aSeq;
//STRIP001 
//STRIP001 	if( !aSeq.getLength() )
//STRIP001 	{
//STRIP001 		static osl::Mutex   aCreateMutex;
//STRIP001     	osl::MutexGuard     aGuard( aCreateMutex );
//STRIP001 
//STRIP001 		aSeq.realloc( 16 );
//STRIP001     	rtl_createUuid( reinterpret_cast< sal_uInt8* >( aSeq.getArray() ), 0, sal_True );
//STRIP001 	}
//STRIP001 	
//STRIP001     return aSeq;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SdTransferable* SdTransferable::getImplementation( const Reference< XInterface >& rxData ) throw()
//STRIP001 {
//STRIP001     try
//STRIP001     {
//STRIP001 	    Reference< ::com::sun::star::lang::XUnoTunnel > xUnoTunnel( rxData, UNO_QUERY );
//STRIP001 
//STRIP001         return( xUnoTunnel.is() ? 
//STRIP001                 ( (SdTransferable*)(void*) xUnoTunnel->getSomething( SdTransferable::getUnoTunnelId() ) ) :
//STRIP001                 NULL );
//STRIP001     }
//STRIP001     catch( const ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001         return NULL;
//STRIP001 	}
//STRIP001 }
}
