/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tabvwsh.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:20:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_TABVWSH_HXX
#define SC_TABVWSH_HXX

#ifndef _SFXVIEWSH_HXX //autogen
#include <bf_sfx2/viewsh.hxx>
#endif

#ifndef _VIEWFAC_HXX //autogen
#include <bf_sfx2/viewfac.hxx>
#endif

#ifndef SC_DBFUNC_HXX
#include "dbfunc.hxx"			// -> tabview
#endif

#ifndef SC_TARGET_HXX
#include "target.hxx"
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"			// ScRangeListRef
#endif

#ifndef SC_SHELLIDS_HXX
#include "shellids.hxx"
#endif
namespace com { namespace sun { namespace star { namespace frame {
	class XDispatchProviderInterceptor;
} } } }

class SbxObject;
namespace binfilter {

class FmFormShell;
class SdrOle2Obj;
class SfxBindings;
class SfxChildWindow;
class SfxModelessDialog;
class SvxBorderLine;
class SvxBoxObjectRef;
class SvxNumberInfoItem;
struct SfxChildWinInfo;

class ScArea;
class ScAuditingShell;
class ScDrawShell;
class ScDrawTextObjectBar;
class ScEditShell;
class ScInputHandler;
class ScPivotShell;
class ScDrawFormShell;
class ScCellShell;
class ScOleObjectShell;
class ScGraphicShell;
class ScChartShell;
class ScPageBreakShell;
class ScDPObject;
class ScNavigatorSettings;

struct ScHeaderFieldData;

//STRIP008 namespace com { namespace sun { namespace star { namespace frame {
//STRIP008 	class XDispatchProviderInterceptor;
//STRIP008 } } } }


enum ObjectSelectionType
{
	OST_NONE,
	OST_Cell,
	OST_Editing,
	OST_DrawText,
	OST_Drawing,
	OST_DrawForm,
	OST_Pivot,
	OST_Auditing,
	OST_OleObject,
	OST_Chart,
	OST_Graphic
};

//==================================================================


class ScTabViewShell: public SfxViewShell, public ScDBFunc
{
private:
	static USHORT			nInsertCtrlState;
	static USHORT			nInsCellsCtrlState;
	static USHORT			nInsObjCtrlState;

	ObjectSelectionType		eCurOST;
	USHORT					nDrawSfxId;
	USHORT					nCtrlSfxId;
	USHORT					nFormSfxId;
	ScDrawShell*			pDrawShell;
	ScDrawTextObjectBar*	pDrawTextShell;
	ScEditShell*			pEditShell;
	ScPivotShell*			pPivotShell;
	ScAuditingShell*		pAuditingShell;
	ScDrawFormShell*		pDrawFormShell;
	ScCellShell*			pCellShell;
	ScOleObjectShell*		pOleObjectShell;
	ScChartShell*			pChartShell;
	ScGraphicShell*			pGraphicShell;
	ScPageBreakShell*		pPageBreakShell;

	FmFormShell*			pFormShell;

	ScInputHandler*			pInputHandler;				// fuer OLE-Eingabezeile

	SvxBorderLine*			pCurFrameLine;

	::com::sun::star::uno::Reference<
		::com::sun::star::frame::XDispatchProviderInterceptor >
							xDisProvInterceptor;

	Point					aWinPos;

	ScTabViewTarget			aTarget;
	ScArea*					pPivotSource;
	ScDPObject*				pDialogDPObject;

    ScNavigatorSettings*    pNavSettings;

	String					aPendingUserData;			// used in first Activate
	BOOL					bFirstActivate;

	BOOL					bActiveDrawSh;
	BOOL					bActiveDrawTextSh;
	BOOL					bActivePivotSh;
	BOOL					bActiveAuditingSh;
	BOOL					bActiveDrawFormSh;
	BOOL					bActiveOleObjectSh;
	BOOL					bActiveChartSh;
	BOOL					bActiveGraphicSh;
	BOOL					bActiveEditSh;


	BOOL					bDontSwitch;				// EditShell nicht abschalten
	BOOL					bInFormatDialog;			// fuer GetSelectionText
	BOOL					bPrintSelected;				// for result of SvxPrtQryBox

	BOOL					bReadOnly;					// um Status-Aenderungen zu erkennen

	SbxObject*				pScSbxObject;

	BOOL					bChartDlgIsEdit;			// Datenbereich aendern
	BOOL					bChartAreaValid;			// wenn Chart aufgezogen wird
	String					aEditChartName;
	ScRangeListRef			aChartSource;
	Rectangle				aChartPos;
	USHORT					nChartDestTab;
	USHORT					nCurRefDlgId;

	SfxBroadcaster*			pAccessibilityBroadcaster;


private:
	void	Construct( BYTE nForceDesignMode = SC_FORCEMODE_NONE );

//STRIP001 	void			SetMySubShell( SfxShell* pShell );
//STRIP001 	SfxShell*		GetMySubShell() const;

//STRIP001 	void			DoReadUserData( const String& rData );

//STRIP001 	DECL_LINK( SimpleRefClose, String* );
//STRIP001 	DECL_LINK( SimpleRefDone, String* );
//STRIP001 	DECL_LINK( SimpleRefAborted, String* );
//STRIP001 	DECL_LINK( SimpleRefChange, String* );

protected:
//STRIP001 	virtual void	Activate(BOOL bMDI);
//STRIP001 	virtual void	Deactivate(BOOL bMDI);
	virtual USHORT	PrepareClose( BOOL bUI = TRUE, BOOL bForBrowsing = FALSE );

	virtual void	ShowCursor(FASTBOOL bOn);

	virtual void	Move();		// Benachrichtigung

//STRIP001 	virtual void	AdjustPosSizePixel( const Point &rPos, const Size &rSize );		// alt

//STRIP001 	virtual void	InnerResizePixel( const Point &rOfs, const Size &rSize );		// neu
	virtual void	OuterResizePixel( const Point &rOfs, const Size &rSize );
//STRIP001 	virtual void	SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY );

//STRIP001 	virtual void	QueryObjAreaPixel( Rectangle& rRect ) const;

//STRIP001 	virtual Size	GetOptimalSizePixel() const;

//STRIP001 	virtual String  GetSelectionText( BOOL bWholeWord );
//STRIP001 	virtual BOOL	HasSelection( BOOL bText ) const;
//STRIP001 	virtual String  GetDescription() const;

	virtual void	WriteUserData(String &, BOOL bBrowse = FALSE);
//STRIP001 	virtual void	ReadUserData(const String &, BOOL bBrowse = FALSE);
    virtual void    WriteUserDataSequence (::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );
//STRIP001     virtual void    ReadUserDataSequence (const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );

//STRIP001 	virtual FASTBOOL KeyInput( const KeyEvent &rKeyEvent );
//STRIP001 	virtual SdrView* GetDrawView() const;

public:
					TYPEINFO();

					SFX_DECL_INTERFACE(SCID_TABVIEW_SHELL);
					SFX_DECL_VIEWFACTORY(ScTabViewShell);


					// -> Clone-Methode fuer Factory

//STRIP001 					ScTabViewShell( SfxViewFrame*			pViewFrame,
//STRIP001 									const ScTabViewShell&	rWin );

					// aus einer allgemeinen Shell konstruieren und
					// soviel wie moeglich uebernehmen (SliderPos etc.):

					ScTabViewShell( SfxViewFrame*			pViewFrame,
									SfxViewShell*			pOldSh );

	virtual			~ScTabViewShell();

//STRIP001 	Window*			GetDialogParent();

//STRIP001 	void			ExecuteInputDirect();

	ScInputHandler*	GetInputHandler() const;
	void			UpdateInputHandler( BOOL bForce = FALSE, BOOL bStopEditing = TRUE );
//STRIP001 	BOOL			TabKeyInput(const KeyEvent& rKEvt);
//STRIP001 	BOOL			SfxKeyInput(const KeyEvent& rKEvt);

//STRIP001 	void			SetActive();

	SvxBorderLine*	GetDefaultFrameLine() const { return pCurFrameLine; }
//STRIP001 	void 			SetDefaultFrameLine(const SvxBorderLine* pLine );

//STRIP001 	void			ExecuteShowNIY( SfxRequest& rReq );
//STRIP001 	void			StateDisabled( SfxItemSet& rSet );

	void			Execute( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			Execute( SfxRequest& rReq );
	void			GetState( SfxItemSet& rSet );

	void			ExecuteTable( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecuteTable( SfxRequest& rReq );
	void			GetStateTable( SfxItemSet& rSet );

//STRIP001 	void			WindowChanged();
	void 			ExecDraw(SfxRequest&){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void 			ExecDraw(SfxRequest&);
	void			ExecDrawIns(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecDrawIns(SfxRequest& rReq);
	void 			GetDrawState(SfxItemSet &rSet);
	void 			GetDrawInsState(SfxItemSet &rSet){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void 			GetDrawInsState(SfxItemSet &rSet);
	void			ExecGallery(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecGallery(SfxRequest& rReq);		// StarGallery
	void			GetGalleryState(SfxItemSet& rSet){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			GetGalleryState(SfxItemSet& rSet);

	void			ExecChildWin(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecChildWin(SfxRequest& rReq);
	void			GetChildWinState( SfxItemSet& rSet );

	void			ExecImageMap( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecImageMap( SfxRequest& rReq );
	void			GetImageMapState( SfxItemSet& rSet ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			GetImageMapState( SfxItemSet& rSet );

	void			ExecTbx( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecTbx( SfxRequest& rReq );
	void			GetTbxState( SfxItemSet& rSet );

	void			ExecuteSave( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecuteSave( SfxRequest& rReq );
	void			GetSaveState( SfxItemSet& rSet );
	void			ExecSearch( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecSearch( SfxRequest& rReq );

	void			ExecuteUndo(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecuteUndo(SfxRequest& rReq);
	void			GetUndoState(SfxItemSet &rSet);

	void			ExecuteSbx( SfxRequest& rReq ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecuteSbx( SfxRequest& rReq );
	void			GetSbxState( SfxItemSet& rSet ){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			GetSbxState( SfxItemSet& rSet );

	void			ExecuteObject(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecuteObject(SfxRequest& rReq);
	void			GetObjectState(SfxItemSet &rSet){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			GetObjectState(SfxItemSet &rSet);

	void			ExecDrawOpt(SfxRequest& rReq){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			ExecDrawOpt(SfxRequest& rReq);
	void			GetDrawOptState(SfxItemSet &rSet){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	void			GetDrawOptState(SfxItemSet &rSet);


	void			SetDrawShell( BOOL bActive );
//STRIP001 	void			SetDrawTextShell( BOOL bActive );

//STRIP001 	void			SetPivotShell( BOOL bActive );
	ScArea*			GetPivotSource(){return pPivotSource;}
	void			SetPivotSource(ScArea* pSrc){pPivotSource=pSrc;}
//STRIP001 	void			SetDialogDPObject( const ScDPObject* pObj );
	const ScDPObject* GetDialogDPObject() const { return pDialogDPObject; }

	BOOL			GetDontSwitch(){return bDontSwitch;}
	void			SetDontSwitch(BOOL bFlag){bDontSwitch=bFlag;}


//STRIP001 	void			SetAuditShell( BOOL bActive );
//STRIP001 	void			SetDrawFormShell( BOOL bActive );
//STRIP001 	void			SetEditShell(EditView* pView, BOOL bActive );
//STRIP001 	void			SetOleObjectShell( BOOL bActive );
	void			SetChartShell( BOOL bActive );
//STRIP001 	void			SetGraphicShell( BOOL bActive );


//STRIP001 	void			SetDrawShellOrSub();
	void			SetCurSubShell( ObjectSelectionType eOST, BOOL bForce = FALSE );

//STRIP001 	ObjectSelectionType GetCurObjectSelectionType();

//STRIP001 	virtual ErrCode	DoVerb(long nVerb);


	void			StopEditShell();
//STRIP001 	BOOL			IsDrawTextShell() const;
//STRIP001 	BOOL			IsAuditShell() const;

//STRIP001 	void			SetDrawTextUndo( SfxUndoManager* pUndoMgr );

//STRIP001 	void			FillFieldData( ScHeaderFieldData& rData );

//STRIP001 	void			ResetChartArea();
//STRIP001 	void			SetChartArea( const ScRangeListRef& rSource, const Rectangle& rDest );
//STRIP001 	BOOL			GetChartArea( ScRangeListRef& rSource, Rectangle& rDest, USHORT& rTab ) const;

//STRIP001 	BOOL			IsChartDlgEdit() const;
	void			SetChartDlgEdit(BOOL bFlag){bChartDlgIsEdit=bFlag;}

	void			SetEditChartName(const String& aStr){aEditChartName=aStr;}
//STRIP001 	const String&	GetEditChartName() const;

	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
						 const SfxHint& rHint, const TypeId& rHintType );

//STRIP001     ScNavigatorSettings*    GetNavigatorSettings();

	// Drucken:
	virtual SfxPrinter*		GetPrinter( BOOL bCreate = FALSE );
//STRIP001 	virtual USHORT			SetPrinter( SfxPrinter* pNewPrinter,
//STRIP001 										  USHORT nDiffFlags = SFX_PRINTER_ALL );

//STRIP001 	virtual PrintDialog*	CreatePrintDialog( Window* pParent );
//STRIP001 	virtual SfxTabPage*     CreatePrintOptionsPage( Window *pParent, const SfxItemSet &rOptions );
//STRIP001 	virtual void			PreparePrint( PrintDialog* pPrintDialog = NULL );
//STRIP001 	virtual ErrCode			DoPrint( SfxPrinter *pPrinter,
//STRIP001 										 PrintDialog *pPrintDialog,
//STRIP001 										 BOOL bSilent );
//STRIP001 	virtual USHORT			Print( SfxProgress& rProgress, PrintDialog* pPrintDialog = NULL );

//STRIP001 	void			TestFunction( USHORT nPar );

//STRIP001 	void			ConnectObject( SdrOle2Obj* pObj );
//STRIP001 	BOOL			ActivateObject( SdrOle2Obj* pObj, long nVerb );

	static ScTabViewShell* GetActiveViewShell();
//STRIP001 	SfxModelessDialog*	CreateRefDialog( SfxBindings* pB, SfxChildWindow* pCW,
//STRIP001 										SfxChildWinInfo* pInfo,
//STRIP001 										Window* pParent, USHORT nSlotId );

//STRIP001 	void			UpdateOleZoom();
	inline SbxObject* GetScSbxObject() const
					{ return pScSbxObject; }
	inline void		SetScSbxObject( SbxObject* pOb )
					{ pScSbxObject = pOb; }

	FmFormShell*	GetFormShell() const	{ return pFormShell; }

//STRIP001 	void 	InsertURL( const String& rName, const String& rURL, const String& rTarget,
//STRIP001 							USHORT nMode );
//STRIP001 	void 	InsertURLButton( const String& rName, const String& rURL, const String& rTarget,
//STRIP001 							const Point* pInsPos = NULL );
//STRIP001 	void 	InsertURLField( const String& rName, const String& rURL, const String& rTarget );

//STRIP001 	BOOL	SelectObject( const String& rName );

	void	SetInFormatDialog(BOOL bFlag) {bInFormatDialog=bFlag;}
	BOOL    IsInFormatDialog() {return bInFormatDialog;}

	void	ForceMove()		{ Move(); }

//STRIP001 	void 	MakeNumberInfoItem		( ScDocument*			 pDoc,
//STRIP001 									  ScViewData*			 pViewData,
//STRIP001 									  SvxNumberInfoItem**	 ppItem );

//STRIP001 	void 	UpdateNumberFormatter	( ScDocument*		     	pDoc,
//STRIP001 									  const SvxNumberInfoItem& 	rInfoItem );

//STRIP001 	void	ExecuteCellFormatDlg	( SfxRequest& rReq, USHORT nTabPage = 0xffff );

	BOOL	GetFunction( String& rFuncStr );

	void	StartSimpleRefDialog( const String& rTitle, const String& rInitVal,
									BOOL bCloseOnButtonUp );
	void	StopSimpleRefDialog();

//STRIP001 	void	SetCurRefDlgId( USHORT nNew );

//STRIP001 	void	AddAccessibilityObject( SfxListener& rObject );
//STRIP001 	void	RemoveAccessibilityObject( SfxListener& rObject );
//STRIP001 	void	BroadcastAccessibility( const SfxHint &rHint );
	BOOL	HasAccessibilityObjects();

};

//==================================================================


} //namespace binfilter
#endif

