/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: OOo2Oasis.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:49:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _RTL_UUID_H_
#include <rtl/uuid.h>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _XMLOFF_NMSPMAP_HXX
#include "nmspmap.hxx"
#endif
#ifndef _XMLOFF_XMLNMSPE_HXX
#include "xmlnmspe.hxx"
#endif
#ifndef _XMLOFF_XMLTOKEN_HXX
#include "xmltoken.hxx"
#endif
#ifndef _XMLOFF_MUTABLEATTRLIST_HXX
#include "MutableAttrList.hxx"
#endif
#ifndef _XMLOFF_DEEPTCONTEXT_HXX
#include "DeepTContext.hxx"
#endif
#ifndef _XMLOFF_STYLEOOOTCONTEXT_HXX
#include "StyleOOoTContext.hxx"
#endif
#ifndef _XMLOFF_FRAMEOOOTCONTEXT_HXX
#include "FrameOOoTContext.hxx"
#endif
#ifndef _XMLOFF_EVENTOOOTCONTEXT_HXX
#include "EventOOoTContext.hxx"
#endif
#ifndef _XMLOFF_CONTROLOOOTCONTEXT_HXX
#include "ControlOOoTContext.hxx"
#endif
#ifndef _XMLOFF_FORMPROPOOOTCONTEXT_HXX
#include "FormPropOOoTContext.hxx"
#endif
#ifndef _XMLOFF_CHARTOOOTCONTEXT_HXX
#include "ChartOOoTContext.hxx"
#endif
#ifndef XMLOFF_XMLCHARTPLOTAREAOOOTCONTEXT_HXX
#include "ChartPlotAreaOOoTContext.hxx"
#endif
#ifndef _XMLOFF_ELEMTRANSFORMERACTION_HXX
#include "ElemTransformerAction.hxx"
#endif
#ifndef _XMLOFF_ATTRTRANSFORMERACTION_HXX
#include "AttrTransformerAction.hxx"
#endif
#ifndef _XMLOFF_PROPERTYACTIONSOOO_HXX
#include "PropertyActionsOOo.hxx"
#endif
#ifndef _XMLOFF_TRANSFORMERACTIONS_HXX
#include "TransformerActions.hxx"
#endif
#ifndef _XMLOFF_XMLUCONV_HXX
#include "xmluconv.hxx"
#endif
#ifndef _XMLOFF_OOO2OOO_HXX
#include "OOo2Oasis.hxx"
#endif

using ::rtl::OUString;
using namespace ::xmloff::token;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::beans;

OUString SAL_CALL OOo2OasisTransformer_getImplementationName() throw();

enum XMLUserDefinedTransformerAction
{
	XML_ETACTION_DOCUMENT=XML_ETACTION_USER_DEFINED,
	XML_ETACTION_BODY,
	XML_ETACTION_STYLE,
	XML_ETACTION_STYLE_RENAME,
	XML_ETACTION_FRAME,
	XML_ETACTION_EVENT,
	XML_ETACTION_TAB_STOP,
	XML_ETACTION_FORM_CONTROL,
	XML_ETACTION_FORM_PROPERTY,
	XML_ETACTION_CHART,
	XML_ETACTION_TRACKED_CHANGES,
    XML_ETACTION_CHART_PLOT_AREA,
	XML_ETACTION_DOCUMENT_RENAME,
    XML_ETACTION_TABLE
};

#define ENTRY3( n, l, a, p1, p2, p3 ) \
	{ XML_NAMESPACE_##n, XML_##l, a, p1, p2, p3 }
#define ENTRY3QQN( n, l, a, n1, l1, n2, l2, p3 ) \
	ENTRY3( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), \
			XMLTransformerActionInit::QNameParam( n2, l2 ), p3 )

#define ENTRY2( n, l, a, p1, p2 ) \
	ENTRY3( n, l, a, p1, p2, 0 )
#define ENTRY2QQ( n, l, a, n1, l1, n2, l2 ) \
	ENTRY2( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), \
			XMLTransformerActionInit::QNameParam( n2, l2 ) )
#define ENTRY2QN( n, l, a, n1, l1, p2 ) \
	ENTRY2( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), p2 )

#define ENTRY1( n, l, a, p1 ) \
	ENTRY3( n, l, a, p1, 0, 0 )
#define ENTRY1Q( n, l, a, n1, l1 ) \
	ENTRY1( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ) )

#define ENTRY0( n, l, a ) \
	ENTRY3( n, l, a, 0, 0, 0 )

// BM: a macro to put two tokens into one sal_Int32 for the action
// XML_ATACTION_RENAME_ATTRIBUTE
#define RENAME_ENTRY( f, s ) \
    (static_cast< sal_Int32 >(f) | (static_cast< sal_Int32 >(s) << 16))

static XMLTransformerActionInit aActionTable[] =
{
	// remove office:class from <office:document> and <office:document-content>
	ENTRY0( OFFICE, DOCUMENT, XML_ETACTION_DOCUMENT ),
	ENTRY0( OFFICE, DOCUMENT_CONTENT, XML_ETACTION_DOCUMENT ),
	ENTRY0( OFFICE, DOCUMENT_STYLES, XML_ETACTION_DOCUMENT ),
	ENTRY0( OFFICE, DOCUMENT_SETTINGS, XML_ETACTION_DOCUMENT ),
	ENTRY1Q( OFFICE, AUTO_TEXT_EVENTS, XML_ETACTION_DOCUMENT_RENAME,
						  XML_NAMESPACE_OOO, XML_AUTO_TEXT_EVENTS),

	// remove <meta:keywords>
	ENTRY0( META, KEYWORDS, XML_ETACTION_COPY_CONTENT ),

    // rename <office:script> to <office:scripts>
    ENTRY1Q( OFFICE, SCRIPT, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_OFFICE, XML_SCRIPTS ),

    // rename <office:script-data> to <office:script> and process attributes
    ENTRY2QN( OFFICE, SCRIPT_DATA, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_OFFICE, XML_SCRIPT,
                        OOO_SCRIPT_ACTIONS ),

    // rename <script:libraries> to <ooo:libraries>
    ENTRY1Q( SCRIPT, LIBRARIES, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_OOO, XML_LIBRARIES ),

    // rename <script:library-linked> to <ooo:library-linked> and process attributes
    ENTRY2QN( SCRIPT, LIBRARY_LINKED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_OOO, XML_LIBRARY_LINKED,
                        OOO_SCRIPT_ACTIONS ),

    // rename <script:library-embedded> to <ooo:library-embedded> and process attributes
    ENTRY2QN( SCRIPT, LIBRARY_EMBEDDED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_OOO, XML_LIBRARY_EMBEDDED,
                        OOO_SCRIPT_ACTIONS ),

    // rename <script:module> to <ooo:module> and process attributes
    ENTRY2QN( SCRIPT, MODULE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_OOO, XML_MODULE,
                        OOO_SCRIPT_ACTIONS ),

    // rename <script:source-code> to <ooo:source-code>
    ENTRY1Q( SCRIPT, SOURCE_CODE, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_OOO, XML_SOURCE_CODE ),

	// rename <office:font-decls> to <office:font-face-decl>,
	// rename <style:font-decl> to <style:font-face>, process attrs
	ENTRY1Q( OFFICE, FONT_DECLS, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_OFFICE, XML_FONT_FACE_DECLS ),
	ENTRY2QN( STYLE, FONT_DECL, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
						XML_NAMESPACE_STYLE, XML_FONT_FACE,
		   				OOO_FONT_DECL_ACTIONS ),

	// add genre element
	ENTRY0( OFFICE, BODY, XML_ETACTION_BODY ),

	// rename <style:page-master> to <style:page-layout>
	ENTRY2QN( STYLE, PAGE_MASTER, XML_ETACTION_STYLE_RENAME,
						XML_NAMESPACE_STYLE, XML_PAGE_LAYOUT,
		   				XML_FAMILY_TYPE_PAGE_LAYOUT	),
	ENTRY1( STYLE, MASTER_PAGE, XML_ETACTION_PROC_ATTRS,
						OOO_MASTER_PAGE_ACTIONS ),

	// split <style:properties> into <style:*-properties> and do other
	// styles processing
	ENTRY1( STYLE, STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_END ),
	ENTRY1( STYLE, DEFAULT_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_END ),
	ENTRY1( NUMBER, NUMBER_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, CURRENCY_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, PERCENTAGE_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, DATE_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, TIME_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, BOOLEAN_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( NUMBER, TEXT_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_DATA ),
	ENTRY1( TEXT, LIST_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_LIST ),
//	ENTRY0( TEXT, OUTLINE_STYLE, STYLE ),
	ENTRY1( STYLE, HEADER_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_HEADER_FOOTER ),
	ENTRY1( STYLE, FOOTER_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_HEADER_FOOTER ),
	ENTRY1( TEXT, LIST_LEVEL_STYLE_NUMBER, XML_ETACTION_STYLE, XML_FAMILY_TYPE_LIST ),
	ENTRY1( TEXT, LIST_LEVEL_STYLE_BULLET, XML_ETACTION_STYLE, XML_FAMILY_TYPE_LIST ),
	ENTRY1( TEXT, LIST_LEVEL_STYLE_IMAGE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_LIST ),
	ENTRY1( TEXT, OUTLINE_LEVEL_STYLE, XML_ETACTION_STYLE, XML_FAMILY_TYPE_LIST ),
	ENTRY1( DRAW, GRADIENT, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_GRADIENT ),
	ENTRY1( DRAW, FILL_IMAGE, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_FILL_IMAGE ),
	ENTRY2QN( DRAW, TRANSPARENCY, XML_ETACTION_STYLE_RENAME,
				XML_NAMESPACE_DRAW, XML_OPACITY,
		 		XML_FAMILY_TYPE_GRADIENT ),
	ENTRY1( DRAW, MARKER, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_MARKER ),
	ENTRY1( DRAW, HATCH, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_HATCH ),
	ENTRY1( DRAW, STROKE_DASH, XML_ETACTION_STYLE,
		 		XML_FAMILY_TYPE_STROKE_DASH ),

	// rename <text:h>'s text:level to text:outline-level
	// process <text:h/p>: process style-name attributes,
	ENTRY1( TEXT, H, XML_ETACTION_PROC_ATTRS, OOO_PARA_ACTIONS ),
	ENTRY1( TEXT, P, XML_ETACTION_PROC_ATTRS, OOO_PARA_ACTIONS ),

	// rename <text:ordered-list> and <text:unordered-list> to <text:list>
	ENTRY2QN( TEXT, UNORDERED_LIST, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
						XML_NAMESPACE_TEXT, XML_LIST,
		  				OOO_STYLE_REF_ACTIONS ),
	ENTRY2QN( TEXT, ORDERED_LIST, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
						XML_NAMESPACE_TEXT, XML_LIST,
		  				OOO_STYLE_REF_ACTIONS ),

	// rename <text:footnote*> to <text:note*>
	ENTRY3QQN( TEXT, FOOTNOTE, XML_ETACTION_RENAME_ELEM_ADD_ATTR,
						XML_NAMESPACE_TEXT, XML_NOTE,
		   				XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_FOOTNOTE ),
	ENTRY1Q( TEXT, FOOTNOTE_BODY, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TEXT, XML_NOTE_BODY ),
	ENTRY1Q( TEXT, FOOTNOTE_CITATION, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TEXT, XML_NOTE_CITATION ),
	ENTRY3QQN( TEXT, FOOTNOTES_CONFIGURATION,
						XML_ETACTION_RENAME_ELEM_ADD_PROC_ATTR,
						XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION,
		   				XML_NAMESPACE_TEXT, XML_NOTE_CLASS,
						XML_FOOTNOTE | (OOO_STYLE_REF_ACTIONS << 16) ),

	// rename <text:endnote*> to <text:endnote*>
	ENTRY3QQN( TEXT, ENDNOTE, XML_ETACTION_RENAME_ELEM_ADD_ATTR,
						XML_NAMESPACE_TEXT, XML_NOTE,
		   				XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_ENDNOTE ),
	ENTRY1Q( TEXT, ENDNOTE_BODY, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TEXT, XML_NOTE_BODY ),
	ENTRY1Q( TEXT, ENDNOTE_CITATION, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TEXT, XML_NOTE_CITATION ),
	ENTRY3QQN( TEXT, ENDNOTES_CONFIGURATION,
						XML_ETACTION_RENAME_ELEM_ADD_PROC_ATTR,
						XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION,
		   				XML_NAMESPACE_TEXT, XML_NOTE_CLASS,
						XML_ENDNOTE | (OOO_STYLE_REF_ACTIONS << 16) ),

	// rename <text:footnote> and <text:endnote> to <text:note>
	ENTRY3QQN( TEXT, ENDNOTE_REF, XML_ETACTION_RENAME_ELEM_ADD_ATTR,
						XML_NAMESPACE_TEXT, XML_NOTE_REF,
		   				XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_ENDNOTE ),
	ENTRY3QQN( TEXT, FOOTNOTE_REF, XML_ETACTION_RENAME_ELEM_ADD_ATTR,
						XML_NAMESPACE_TEXT, XML_NOTE_REF,
		   				XML_NAMESPACE_TEXT, XML_NOTE_CLASS, XML_FOOTNOTE ),

	// rename <text:tab-stop> to <text:tab>
	ENTRY1Q( TEXT, TAB_STOP, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TEXT, XML_TAB ),

	// replace <table:sub-table> with <table:table table:is-sub-table>
	ENTRY3QQN( TABLE, SUB_TABLE, XML_ETACTION_RENAME_ELEM_ADD_ATTR,
						XML_NAMESPACE_TABLE, XML_TABLE,
		   				XML_NAMESPACE_TABLE, XML_IS_SUB_TABLE, XML_TRUE ),

	// process *:style-name attributes
	ENTRY1( TEXT, SECTION, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, SPAN, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, A, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, RUBY, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, RUBY_TEXT, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, DATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TIME, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, VARIABLE_GET, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, USER_FIELD_GET, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, USER_FIELD_INPUT, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, CREATION_DATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, CREATION_TIME, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, PRINT_TIME, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, PRINT_DATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, EDITING_DURATION, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, MODIFICATION_TIME, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, MODIFICATION_DATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, DATABASE_DISPLAY, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TABLE_FORMULA, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_TITLE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TABLE_OF_CONTENT, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TABLE_OF_CONTENT_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ILLUSTRATION_INDEX, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ILLUSTRATION_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TABLE_INDEX, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, TABLE_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, OBJECT_INDEX, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, OBJECT_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, USER_INDEX, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, USER_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ALPHABETICAL_INDEX, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ALPHABETICAL_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, BIBLIOGRAPHY, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, BIBLIOGRAPHY_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_SOURCE_STYLE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_TITLE_TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_CHAPTER, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY2QN( TEXT, INDEX_ENTRY_CHAPTER_NUMBER,
			XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
			XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_CHAPTER,
			OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_TEXT, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_PAGE_NUMBER, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_SPAN, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_BIBLIOGRAPHY, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_LINK_START, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, INDEX_ENTRY_LINK_END, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( STYLE, HANDOUT_MASTER, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( DRAW, PAGE, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( STYLE, MAP, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( PRESENTATION, NOTES, XML_ETACTION_PROC_ATTRS,
		OOO_STYLE_REF_ACTIONS ), /* generated entry */
	ENTRY1( STYLE, PRESENTATION_PAGE_LAYOUT, XML_ETACTION_PROC_ATTRS,
						OOO_MASTER_PAGE_ACTIONS ),
    // --> OD 2005-01-10 #i40011#, #i40015#
    // - consider also attribute table:style-name for <table:table>,
    //   <table:table-row> and <table:table-column>.
//    ENTRY1( TABLE, TABLE, XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ),
	ENTRY0( TABLE, TABLE, XML_ETACTION_TABLE ),

    ENTRY1( TABLE, TABLE_ROW, XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ),
    ENTRY1( TABLE, TABLE_COLUMN, XML_ETACTION_PROC_ATTRS, OOO_STYLE_REF_ACTIONS ),
    // <--

	// split frame elements
	ENTRY0( DRAW, TEXT_BOX, XML_ETACTION_FRAME ),
	ENTRY0( DRAW, IMAGE, XML_ETACTION_FRAME ),
	ENTRY0( DRAW, OBJECT, XML_ETACTION_FRAME ),
	ENTRY0( DRAW, OBJECT_OLE, XML_ETACTION_FRAME ),
	ENTRY0( DRAW, APPLET, XML_ETACTION_FRAME ),
	ENTRY0( DRAW, PLUGIN, XML_ETACTION_FRAME ),
	ENTRY0( DRAW, FLOATING_FRAME, XML_ETACTION_FRAME ),
	ENTRY0( SVG, DESC, XML_ETACTION_COPY_TEXT ),

	// process events
	ENTRY1Q( OFFICE, EVENTS, XML_ETACTION_RENAME_ELEM,
		  			XML_NAMESPACE_OFFICE, XML_EVENT_LISTENERS ),
	ENTRY0( SCRIPT, EVENT, XML_ETACTION_EVENT ),
	ENTRY0( PRESENTATION, EVENT, XML_ETACTION_EVENT ),

	// process length attributes
	ENTRY1( DRAW, RECT, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, LINE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, POLYLINE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, POLYGON, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, PATH, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CIRCLE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, ELLIPSE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONNECTOR, XML_ETACTION_PROC_ATTRS, OOO_CONNECTOR_ACTIONS ),
	ENTRY1( DRAW, CAPTION, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONTROL, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, PAGE_THUMBNAIL, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, MEASURE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, G, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
//	ENTRY1( DRAW, TEXT_BOX, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( PRESENTATION, PLACEHOLDER, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONTOUR_POLYGON, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, CONTOUR_PATH, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, AREA_RECTANGLE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, AREA_CIRCLE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DRAW, AREA_POLYGON, XML_ETACTION_PROC_ATTRS, OOO_DRAW_AREA_POLYGON_ACTIONS ),
	ENTRY1( DRAW, GLUE_POINT, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DR3D, SCENE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DR3D, CUBE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DR3D, SPHERE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DR3D, EXTRUDE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( DR3D, ROTATE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, TITLE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, SUBTITLE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, FOOTER, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, LEGEND, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, WALL, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, FLOOR, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, AXIS, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, GRID, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, SERIES, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, DATA_POINT, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, MEAN_VALUE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, ERROR_INDICATOR, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, REGRESSION_CURVE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, STOCK_GAIN_MARKER, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, STOCK_LOSS_MARKER, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),
	ENTRY1( CHART, STOCK_RANGE_LINE, XML_ETACTION_PROC_ATTRS, OOO_SHAPE_ACTIONS ),

	ENTRY0( CHART, CHART, XML_ETACTION_CHART ),
    ENTRY0( CHART, PLOT_AREA, XML_ETACTION_CHART_PLOT_AREA ),

	ENTRY1Q( TEXT, TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES,
						XML_NAMESPACE_TEXT, XML_PROTECTION_KEY ),
	ENTRY1Q( TABLE, TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES,
						XML_NAMESPACE_TABLE, XML_PROTECTION_KEY ),

	ENTRY1( TEXT, INDEX_ENTRY_TAB_STOP, XML_ETACTION_PROC_ATTRS,
				  OOO_INDEX_ENTRY_TAB_STOP_ACTIONS ),
	ENTRY0( STYLE, TAB_STOP, XML_ETACTION_TAB_STOP ),
	ENTRY1( STYLE, BACKGROUND_IMAGE, XML_ETACTION_PROC_ATTRS,
		 			OOO_BACKGROUND_IMAGE_ACTIONS  ),
	ENTRY1( TEXT, LINENUMBERING_CONFIGURATION, XML_ETACTION_PROC_ATTRS,
				  OOO_LINENUMBERING_ACTIONS ),
	ENTRY1( STYLE, FOOTNOTE_SEP, XML_ETACTION_PROC_ATTRS,
				   OOO_FOOTNOTE_SEP_ACTIONS ),
	ENTRY1( STYLE, DROP_CAP, XML_ETACTION_PROC_ATTRS, OOO_DROP_CAP_ACTIONS ),
	ENTRY1( STYLE, COLUMNS, XML_ETACTION_PROC_ATTRS, OOO_COLUMNS_ACTIONS ),
	ENTRY1( STYLE, COLUMN, XML_ETACTION_PROC_ATTRS, OOO_COLUMNS_ACTIONS ),

	// rename office:value-* to *:value-*
	ENTRY1( TEXT, VARIABLE_DECL, XML_ETACTION_PROC_ATTRS,
			OOO_TEXT_VALUE_TYPE_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, VARIABLE_SET, XML_ETACTION_PROC_ATTRS,
			OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TEXT, VARIABLE_INPUT, XML_ETACTION_PROC_ATTRS,
			OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TEXT, USER_FIELD_DECL, XML_ETACTION_PROC_ATTRS,
			OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TEXT, EXPRESSION, XML_ETACTION_PROC_ATTRS,
			OOO_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
//	ENTRY1( TEXT, USER_DEFINED, XML_ETACTION_PROC_ATTRS,
//			OOO_TEXT_VALUE_TYPE_ACTIONS), /* text:user-defined has no attrs so far */
	ENTRY1( TABLE, TABLE_CELL, XML_ETACTION_PROC_ATTRS,
			OOO_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TABLE, COVERED_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
			OOO_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
	ENTRY1( TABLE, CHANGE_TRACK_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
			OOO_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
//	ENTRY1( FORM, PROPERTY, XML_ETACTION_PROC_ATTRS,
//			OOO_VALUE_TYPE_ACTIONS), /* TODO: generated entry */
//	ENTRY1( FORM, LIST_PROPERTY, XML_ETACTION_PROC_ATTRS,
//			OOO_VALUE_TYPE_ACTIONS), /* generated entry */

	ENTRY1( OFFICE, ANNOTATION, XML_ETACTION_MOVE_ATTRS_TO_ELEMS,
			OOO_ANNOTATION_ACTIONS ), /* generated entry */
	ENTRY1( OFFICE, CHANGE_INFO, XML_ETACTION_MOVE_ATTRS_TO_ELEMS,
			OOO_CHANGE_INFO_ACTIONS ), /* generated entry */

	ENTRY1( TEXT, DDE_CONNECTION_DECL, XML_ETACTION_PROC_ATTRS,
		 			OOO_DDE_CONNECTION_DECL_ACTIONS  ),

	ENTRY0( FORM, CONTROL, XML_ETACTION_FORM_CONTROL ),
	ENTRY1( FORM, COLUMN, XML_ETACTION_PROC_ATTRS,
		 			OOO_FORM_COLUMN_ACTIONS  ),
	ENTRY0( FORM, PROPERTY, XML_ETACTION_FORM_PROPERTY ),

	// process xlink:href
	ENTRY1( META, TEMPLATE, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( META, AUTO_RELOAD, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, SECTION_SOURCE, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, SCRIPT, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TEXT, ALPHABETICAL_INDEX_AUTO_MARK_FILE, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TABLE, TABLE_SOURCE, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( TABLE, CELL_RANGE_SOURCE, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( DRAW, A, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( PRESENTATION, SOUND, XML_ETACTION_PROC_ATTRS,
		OOO_XLINK_ACTIONS ), /* generated entry */
	ENTRY1( FORM, FORM, XML_ETACTION_PROC_ATTRS,
		OOO_FORM_CONTROL_ACTIONS ),
    ENTRY2QN( STYLE, SYMBOL_IMAGE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
              XML_NAMESPACE_CHART, XML_SYMBOL_IMAGE,
              OOO_BACKGROUND_IMAGE_ACTIONS ),

	ENTRY2QN( CONFIG, CONFIG_ITEM_SET, XML_ETACTION_PROC_ATTRS_COND,
		XML_NAMESPACE_OFFICE, XML_SETTINGS,
		OOO_CONFIG_ITEM_SET_ACTIONS ),

	// add namespace prefix
	//  text:formula
	ENTRY1( TEXT, SEQUENCE, XML_ETACTION_PROC_ATTRS,
		OOO_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, DATABASE_NEXT, XML_ETACTION_PROC_ATTRS,
		OOO_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY2QN( TEXT, DATABASE_SELECT, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
				XML_NAMESPACE_TEXT, XML_DATABASE_ROW_SELECT,
		OOO_FORMULA_ACTIONS ),
	//  text:condition
	ENTRY1( TEXT, CONDITIONAL_TEXT, XML_ETACTION_PROC_ATTRS,
		OOO_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, HIDDEN_TEXT, XML_ETACTION_PROC_ATTRS,
		OOO_FORMULA_ACTIONS ), /* generated entry */
	//  text:condition
	ENTRY1( TEXT, HIDDEN_PARAGRAPH, XML_ETACTION_PROC_ATTRS,
		OOO_FORMULA_ACTIONS ), /* generated entry */
	//  table:condition
	ENTRY1( TABLE, CONTENT_VALIDATION, XML_ETACTION_PROC_ATTRS,
		OOO_FORMULA_ACTIONS ), /* generated entry */

	// rename <table:dependences> to <table:dependencies>
	ENTRY1Q( TABLE, DEPENDENCES, XML_ETACTION_RENAME_ELEM,
						XML_NAMESPACE_TABLE, XML_DEPENDENCIES ),

    // process table::error-macro
	ENTRY1( TABLE, ERROR_MACRO, XML_ETACTION_PROC_ATTRS,
			OOO_ERROR_MACRO_ACTIONS ),

    // process table::conversion-mode
	ENTRY1( TABLE, CONVERSION_MODE, XML_ETACTION_PROC_ATTRS,
			OOO_DDE_CONV_MODE_ACTIONS ),

    // fix <text:alphabatical-index-mark text:main-etry>
	ENTRY1( TEXT, ALPHABETICAL_INDEX_MARK, XML_ETACTION_PROC_ATTRS,
            OOO_ALPHABETICAL_INDEX_MARK_ACTIONS ),
	ENTRY1( TEXT, ALPHABETICAL_INDEX_MARK_START, XML_ETACTION_PROC_ATTRS,
            OOO_ALPHABETICAL_INDEX_MARK_ACTIONS ),

    // process table::data-pilot-member
	ENTRY1( TABLE, DATA_PILOT_MEMBER, XML_ETACTION_PROC_ATTRS,
			OOO_DATAPILOT_MEMBER_ACTIONS ),

    // process table::data-pilot-level
	ENTRY1( TABLE, DATA_PILOT_LEVEL, XML_ETACTION_PROC_ATTRS,
			OOO_DATAPILOT_LEVEL_ACTIONS ),

    // process table::source-service
	ENTRY1( TABLE, SOURCE_SERVICE, XML_ETACTION_PROC_ATTRS,
			OOO_SOURCE_SERVICE_ACTIONS ),

    ENTRY0( OFFICE, TOKEN_INVALID, XML_ETACTION_EOT )
};

// XML_ETACTION_STYLE
static XMLTransformerActionInit aStyleActionTable[] =
{
	ENTRY0( STYLE, FAMILY, XML_ATACTION_STYLE_FAMILY ),
	ENTRY0( STYLE, NAME, XML_ATACTION_ENCODE_STYLE_NAME ),
	ENTRY0( STYLE, PARENT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, NEXT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, LIST_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, MASTER_PAGE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, DATA_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, NAME, XML_ATACTION_ENCODE_STYLE_NAME ),
	ENTRY0( DRAW, DISTANCE, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, DOTS1_LENGTH, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, DOTS2_LENGTH, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
	ENTRY0( DRAW, START, XML_ATACTION_NEG_PERCENT ),
	ENTRY0( DRAW, END, XML_ATACTION_NEG_PERCENT ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_True ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_FRAME_ELEM_ACTIONS
static XMLTransformerActionInit aFrameElemActionTable[] =
{
	ENTRY1Q( OFFICE, EVENTS, XML_ETACTION_RENAME_ELEM,
		  			XML_NAMESPACE_OFFICE, XML_EVENT_LISTENERS ),
	ENTRY0( DRAW, GLUE_POINT, XML_ETACTION_COPY ),
	ENTRY0( DRAW, IMAGE_MAP, XML_ETACTION_COPY ),
	ENTRY0( SVG, DESC, XML_ETACTION_COPY_TEXT ),
	ENTRY0( DRAW, CONTOUR_POLYGON, XML_ETACTION_COPY ),
	ENTRY0( DRAW, CONTOUR_PATH, XML_ETACTION_COPY ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ETACTION_EOT )
};

// OOO_FRAME_ATTR_ACTIONS
static XMLTransformerActionInit aFrameAttrActionTable[] =
{
	ENTRY0( DRAW, ZINDEX, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( DRAW, ID, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( DRAW, LAYER, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( DRAW, STYLE_NAME, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( PRESENTATION, STYLE_NAME, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( DRAW, TRANSFORM, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( DRAW, NAME, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( TABLE, END_CELL_ADDRESS, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( TABLE, END_X, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( TABLE, END_Y, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( TABLE, TABLE_BACKGROUND, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( TEXT, ANCHOR_TYPE, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( TEXT, ANCHOR_PAGE_NUMBER, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( DRAW, TEXT_STYLE_NAME, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( SVG, X, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( SVG, Y, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( SVG, WIDTH, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( SVG, HEIGHT, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( STYLE, REL_WIDTH, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( STYLE, REL_HEIGHT, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( PRESENTATION, CLASS, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( PRESENTATION, PLACEHOLDER, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( PRESENTATION, USER_TRANSFORMED, XML_ATACTION_MOVE_TO_ELEM ), /* generated entry */
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_EVENT_ELEM_ACTIONS
static XMLTransformerActionInit aEventActionTable[] =
{
	ENTRY0( XLINK, HREF, XML_ATACTION_HREF ),
	ENTRY1( SCRIPT, LANGUAGE, XML_ATACTION_ADD_NAMESPACE_PREFIX,
					XML_NAMESPACE_OOO ),
	ENTRY0( SCRIPT, EVENT_NAME, XML_ATACTION_EVENT_NAME ),
	ENTRY0( SCRIPT, MACRO_NAME, XML_ATACTION_MACRO_NAME ),
	ENTRY0( SCRIPT, LOCATION, XML_ATACTION_MACRO_LOCATION ),
	ENTRY0( SCRIPT, LIBRARY, XML_ATACTION_MACRO_LOCATION ), // bug in draw
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};


// action table for OOO_MASTER_PAGE_ACTIONS
static XMLTransformerActionInit aMasterPageActionTable[] =
{
	ENTRY0( STYLE, NAME, XML_ATACTION_ENCODE_STYLE_NAME ),
	ENTRY0( STYLE, NEXT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY1Q( STYLE, PAGE_MASTER_NAME, XML_ATACTION_RENAME_ENCODE_STYLE_NAME_REF,
						XML_NAMESPACE_STYLE, XML_PAGE_LAYOUT_NAME ),
	ENTRY0( DRAW, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTransformerActionInit aFontDeclActionTable[] =
{
	ENTRY1Q( FO, FONT_FAMILY, XML_ATACTION_RENAME,
						XML_NAMESPACE_SVG, XML_FONT_FAMILY ),
	ENTRY1Q( STYLE, FONT_STYLE_NAME, XML_ATACTION_RENAME,
						XML_NAMESPACE_STYLE, XML_FONT_ADORNMENTS ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OOO_PARA_ACTIONS
static XMLTransformerActionInit aParaActionTable[] =
{
	ENTRY0( TEXT, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, COND_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
//	ENTRY0( TEXT, CLASS_NAMES, XML_ATACTION_REMOVE ),
	ENTRY1Q( TEXT, LEVEL, XML_ATACTION_RENAME,
						XML_NAMESPACE_TEXT, XML_OUTLINE_LEVEL ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OOO_STYLE_REF_ACTIONS
static XMLTransformerActionInit aStyleRefActionTable[] =
{
	ENTRY0( TEXT, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, VISITED_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, MAIN_ENTRY_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, CITATION_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, CITATION_BODY_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, DEFAULT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TEXT, MASTER_PAGE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, DATA_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, APPLY_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( STYLE, PAGE_LAYOUT_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TABLE, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( TABLE, DEFAULT_CELL_STYLE_NAME,
			XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, MASTER_PAGE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( PRESENTATION, PRESENTATION_PAGE_LAYOUT_NAME,
			XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_False ),
	ENTRY1( TEXT, CONDITION, XML_ATACTION_ADD_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY1( TEXT, FORMULA, XML_ATACTION_ADD_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_SHAPE_ACTIONS
// !!ATTENTION!! If you change something here, please also change
// aConnectorActionTable if apropriate
static XMLTransformerActionInit aShapeActionTable[] =
{
	ENTRY0( SVG, X, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, Y, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, X1, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, Y1, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, X2, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, Y2, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, CX, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, CY, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, R, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, RX, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, RY, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
	ENTRY0( FO, MIN_WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( FO, MIN_HEIGHT, XML_ATACTION_INCH2IN ),
	ENTRY0( FO, MAX_WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( FO, MAX_HEIGHT, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, CORNER_RADIUS, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, LINE_SKEW, XML_ATACTION_INCHS2INS ),
	ENTRY0( DRAW, CAPTION_POINT_X, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, CAPTION_POINT_Y, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, TEXT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, END_X, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, END_Y, XML_ATACTION_INCH2IN ),
	ENTRY0( PRESENTATION, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DR3D, DISTANCE, XML_ATACTION_INCH2IN ),
	ENTRY0( DR3D, FOCAL_LENGTH, XML_ATACTION_INCH2IN ),
	ENTRY1Q( FORM, ID, XML_ATACTION_RENAME,
					XML_NAMESPACE_DRAW, XML_CONTROL ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_True ),

    // BM: needed by chart:legend.  The legend needs also the draw actions.  As
    // there is no merge mechanism, all actions have to be in the same table
    ENTRY2( CHART, LEGEND_POSITION, XML_ATACTION_RENAME_ATTRIBUTE,
            RENAME_ENTRY( XML_LEFT, XML_START ),
            RENAME_ENTRY( XML_RIGHT, XML_END )),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTransformerActionInit aConnectorActionTable[] =
{
	ENTRY0( SVG, X1, XML_ATACTION_TWIPS2IN ),
	ENTRY0( SVG, Y1, XML_ATACTION_TWIPS2IN ),
	ENTRY0( SVG, X2, XML_ATACTION_TWIPS2IN ),
	ENTRY0( SVG, Y2, XML_ATACTION_TWIPS2IN ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_SVG_WIDTH_HEIGHT_OOO ),
	ENTRY0( FO, MIN_WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( FO, MIN_HEIGHT, XML_ATACTION_INCH2IN ),
	ENTRY0( FO, MAX_WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( FO, MAX_HEIGHT, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, TEXT_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( DRAW, END_X, XML_ATACTION_INCH2IN ),
	ENTRY0( DRAW, END_Y, XML_ATACTION_INCH2IN ),
	ENTRY0( PRESENTATION, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY1Q( FORM, ID, XML_ATACTION_RENAME,
					XML_NAMESPACE_DRAW, XML_CONTROL ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_True ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_INDEX_ENTRY_TAB_STOP_ACTIONS
static XMLTransformerActionInit aIndexEntryTabStopActionTable[] =
{
	ENTRY0( STYLE, POSITION, XML_ATACTION_INCH2IN ),
	ENTRY0( TEXT, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_TAB_STOP_ACTIONS
static XMLTransformerActionInit aTabStopActionTable[] =
{
	ENTRY0( STYLE, POSITION, XML_ATACTION_INCH2IN ),
	ENTRY1Q( STYLE, LEADER_CHAR, XML_ATACTION_RENAME,
					XML_NAMESPACE_STYLE, XML_LEADER_TEXT ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_LINENUMBERING_ACTIONS
static XMLTransformerActionInit aLineNumberingActionTable[] =
{
	ENTRY0( TEXT, OFFSET, XML_ATACTION_INCH2IN ),
	ENTRY0( TEXT, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY1Q( TEXT, COUNT_IN_FLOATING_FRAMES, XML_ATACTION_RENAME,
					XML_NAMESPACE_TEXT, XML_COUNT_IN_TEXT_BOXES ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTransformerActionInit aFootnoteSepActionTable[] =
{
	ENTRY0( STYLE, WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( STYLE, DISTANCE_BEFORE_SEP, XML_ATACTION_INCH2IN ),
	ENTRY0( STYLE, DISTANCE_AFTER_SEP, XML_ATACTION_INCH2IN ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DROP_CAP_ACTIONS
static XMLTransformerActionInit aDropCapActionTable[] =
{
	ENTRY0( STYLE, DISTANCE, XML_ATACTION_INCH2IN ),
	ENTRY0( STYLE, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTransformerActionInit aColumnsActionTable[] =
{
	ENTRY0( STYLE, COLUMN_GAP, XML_ATACTION_INCH2IN ),
//	ENTRY0( STYLE, SPACE_BEFORE, XML_ATACTION_INCH2IN ),
//	ENTRY0( STYLE, SPACE_AFTER, XML_ATACTION_INCH2IN ),
	ENTRY1Q( FO, MARGIN_LEFT, XML_ATACTION_RENAME_INCH2IN,
		   XML_NAMESPACE_FO, XML_START_INDENT ),
	ENTRY1Q( FO, MARGIN_RIGHT, XML_ATACTION_RENAME_INCH2IN,
		   XML_NAMESPACE_FO, XML_END_INDENT ),
	ENTRY0( STYLE, WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_TEXT_VALUE_TYPE_ACTIONS
static XMLTransformerActionInit aTextValueTypeActionTable[] =
{
	ENTRY1Q( TEXT, VALUE_TYPE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_VALUE_TYPE ),
	ENTRY1Q( TEXT, VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_VALUE ),
	ENTRY1Q( TEXT, CURRENCY, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_CURRENCY ),
	ENTRY1Q( TEXT, DATE_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_DATE_VALUE ),
	ENTRY1Q( TEXT, TIME_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_TIME_VALUE ),
	ENTRY1Q( TEXT, BOOLEAN_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE ),
	ENTRY1Q( TEXT, STRING_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_STRING_VALUE ),
	ENTRY0( STYLE, DATA_STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY1( TEXT, FORMULA, XML_ATACTION_ADD_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY0( TEXT, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_TABLE_VALUE_TYPE_ACTIONS
static XMLTransformerActionInit aTableValueTypeActionTable[] =
{
	ENTRY1Q( TABLE, VALUE_TYPE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_VALUE_TYPE ),
	ENTRY1Q( TABLE, VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_VALUE ),
	ENTRY1Q( TABLE, CURRENCY, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_CURRENCY ),
	ENTRY1Q( TABLE, DATE_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_DATE_VALUE ),
	ENTRY1Q( TABLE, TIME_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_TIME_VALUE ),
	ENTRY1Q( TABLE, BOOLEAN_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE ),
	ENTRY1Q( TABLE, STRING_VALUE, XML_ATACTION_RENAME,
		   XML_NAMESPACE_OFFICE, XML_STRING_VALUE ),
	ENTRY0( TABLE, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY1( TABLE, FORMULA, XML_ATACTION_ADD_APP_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY1Q( TABLE, VALIDATION_NAME, XML_ATACTION_RENAME,
		   XML_NAMESPACE_TABLE, XML_CONTENT_VALIDATION_NAME ),
	ENTRY0( TABLE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OOO_ANNOTATION_ACTIONS
static XMLTransformerActionInit aAnnotationActionTable[] =
{
	ENTRY1Q( OFFICE, AUTHOR, XML_ATACTION_MOVE_TO_ELEM,
				XML_NAMESPACE_DC, XML_CREATOR ),
	ENTRY1Q( OFFICE, CREATE_DATE, XML_ATACTION_MOVE_TO_ELEM,
				XML_NAMESPACE_DC, XML_DATE ),
	ENTRY1Q( OFFICE, CREATE_DATE_STRING, XML_ATACTION_MOVE_TO_ELEM,
				XML_NAMESPACE_META, XML_DATE_STRING ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OOO_CHANGE_INFO_ACTIONS
static XMLTransformerActionInit aChangeInfoActionTable[] =
{
	ENTRY1Q( OFFICE, CHG_AUTHOR, XML_ATACTION_MOVE_TO_ELEM,
				XML_NAMESPACE_DC, XML_CREATOR ),
	ENTRY1Q( OFFICE, CHG_DATE_TIME, XML_ATACTION_MOVE_TO_ELEM,
				XML_NAMESPACE_DC, XML_DATE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_BACKGROUND_IMAGE_ACTIONS
static XMLTransformerActionInit aBackgroundImageActionTable[] =
{
	ENTRY1Q( DRAW, TRANSPARENCY, XML_ATACTION_RENAME_NEG_PERCENT,
		 			XML_NAMESPACE_DRAW, XML_OPACITY ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_True ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// --> OD 2005-06-10 #i50322#
// OOO_BACKGROUND_IMAGE_ACTIONS for OpenOffice.org text documents
// OpenOffice.org text documents, written by OpenOffice.org, contain
// wrong value for the transparency of the background graphic
static XMLTransformerActionInit aWriterBackgroundImageActionTable[] =
{
    ENTRY1Q( DRAW, TRANSPARENCY, XML_ATACTION_WRITER_BACK_GRAPHIC_TRANSPARENCY, XML_NAMESPACE_DRAW, XML_OPACITY ),
    ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_True ),
    ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};
// <--

// OOO_DDE_CONNECTION_DECL
static XMLTransformerActionInit aDDEConnectionDeclActionTable[] =
{
	ENTRY1Q( TEXT, NAME, XML_ATACTION_RENAME,
		 			XML_NAMESPACE_OFFICE, XML_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_FORM_CONTROL_ACTIONS
static XMLTransformerActionInit aFormControlActionTable[] =
{
	ENTRY2QN( FORM, SERVICE_NAME,
					XML_ATACTION_RENAME_ADD_NAMESPACE_PREFIX,
		   			XML_NAMESPACE_FORM, XML_CONTROL_IMPLEMENTATION,
					XML_NAMESPACE_OOO ),
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_False ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_FORM_COLUMN_ACTIONS
static XMLTransformerActionInit aFormColumnActionTable[] =
{
	ENTRY1Q( FORM, COLUMN_STYLE_NAME, XML_ATACTION_RENAME_ENCODE_STYLE_NAME_REF,
						XML_NAMESPACE_FORM, XML_TEXT_STYLE_NAME ),
	ENTRY2QN( FORM, SERVICE_NAME,
					XML_ATACTION_RENAME_ADD_NAMESPACE_PREFIX,
		   			XML_NAMESPACE_FORM, XML_CONTROL_IMPLEMENTATION,
					XML_NAMESPACE_OOO ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_FORM_PROP_ACTIONS
static XMLTransformerActionInit aFormPropActionTable[] =
{
	ENTRY1Q( FORM, PROPERTY_TYPE, XML_ATACTION_RENAME,
		  				XML_NAMESPACE_OFFICE, XML_VALUE_TYPE ),
	ENTRY0( FORM, PROPERTY_IS_LIST, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_XLINK_ACTIONS
static XMLTransformerActionInit aXLinkActionTable[] =
{
	ENTRY1( XLINK, HREF, XML_ATACTION_URI_OOO, sal_False ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_CONFIG_ITEM_SET_ACTIONS
static XMLTransformerActionInit aConfigItemSetActionTable[] =
{
	ENTRY1( CONFIG, NAME, XML_ATACTION_ADD_NAMESPACE_PREFIX,
					XML_NAMESPACE_OOO ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORMULA_ACTIONS
static XMLTransformerActionInit aFormulaActionTable[] =
{
	ENTRY1( TEXT, CONDITION, XML_ATACTION_ADD_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY1( TEXT, FORMULA, XML_ATACTION_ADD_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY1( TABLE, CONDITION, XML_ATACTION_ADD_APP_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY1( TABLE, FORMULA, XML_ATACTION_ADD_APP_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_OOOW ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_ERROR_MACRO_ACTIONS
static XMLTransformerActionInit aErrorMacroActionTable[] =
{
	ENTRY0( TABLE, NAME, XML_ATACTION_REMOVE ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DDE_CONV_MODE_ACTIONS
static XMLTransformerActionInit aDDEConvModeActionTable[] =
{
	ENTRY1Q( TABLE, LET_TEXT, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_KEEP_TEXT ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DATAPILOT_MEMBER_ACTIONS
static XMLTransformerActionInit aDataPilotMemberActionTable[] =
{
	ENTRY1Q( TABLE, DISPLAY_DETAILS, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_SHOW_DETAILS ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DATAPILOT_LEVEL_ACTIONS
static XMLTransformerActionInit aDataPilotLevelActionTable[] =
{
	ENTRY1Q( TABLE, DISPLAY_EMPTY, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_SHOW_EMPTY ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_SOURCE_SERVICE_ACTIONS
static XMLTransformerActionInit aSourceServiceActionTable[] =
{
	ENTRY1Q( TABLE, USERNAME, XML_ATACTION_RENAME,
						XML_NAMESPACE_TABLE, XML_USER_NAME ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_DRAW_AREA_POLYGON_ACTIONS (to be added to OOO_SHAPE_ACTIONS)
static XMLTransformerActionInit aDrawAreaPolygonActionTable[] =
{
	ENTRY1Q( SVG, POINTS, XML_ATACTION_RENAME,
             XML_NAMESPACE_DRAW, XML_POINTS ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_CHART_ACTIONS
static XMLTransformerActionInit aChartActionTable[] =
{
	ENTRY1( CHART, CLASS, XML_ATACTION_ADD_NAMESPACE_PREFIX,
		 			XML_NAMESPACE_CHART ),
	ENTRY0( CHART, ADD_IN_NAME, XML_ATACTION_REMOVE ),
	ENTRY0( SVG, WIDTH, XML_ATACTION_INCH2IN ),
	ENTRY0( SVG, HEIGHT, XML_ATACTION_INCH2IN ),
	ENTRY0( CHART, STYLE_NAME, XML_ATACTION_ENCODE_STYLE_NAME_REF ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_ALPHABETICAL_INDEX_MARK_ACTIONS
static XMLTransformerActionInit aAlphabeticalIndexMarkActionTable[] =
{
	ENTRY1Q( TEXT, MAIN_ETRY, XML_ATACTION_RENAME,
             XML_NAMESPACE_TEXT, XML_MAIN_ENTRY ),
	ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_SCRIPT_ACTIONS
static XMLTransformerActionInit aScriptActionTable[] =
{
    ENTRY1( SCRIPT, LANGUAGE, XML_ATACTION_ADD_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY1Q( SCRIPT, NAME, XML_ATACTION_RENAME, XML_NAMESPACE_OOO, XML_NAME ),
    ENTRY1Q( SCRIPT, READONLY, XML_ATACTION_RENAME, XML_NAMESPACE_OOO, XML_READONLY ),
    ENTRY0( OFFICE, TOKEN_INVALID, XML_ATACTION_EOT )
};

static XMLTokenEnum aTokenMap[] =
{
	XML_NONE, XML_SINGLE, XML_DOUBLE, XML_BOLD, XML_BOLD_DOTTED,
	XML_BOLD_DASH, XML_BOLD_LONG_DASH, XML_BOLD_DOT_DASH,
	XML_BOLD_DOT_DOT_DASH, XML_BOLD_WAVE, XML_DOUBLE_WAVE,
	XML_SINGLE_LINE, XML_DOUBLE_LINE, XML_THICK_LINE, XML_SLASH, XML_uX,
	XML_TOKEN_END
};

//-----------------------------------------------------------------------------

class XMLDocumentTransformerContext_Impl : public XMLTransformerContext
{
	::rtl::OUString m_aElemQName;
	::rtl::OUString m_aOldClass;

public:
	TYPEINFO();

	XMLDocumentTransformerContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );
	XMLDocumentTransformerContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName,
		   				   sal_uInt16 nPrefix,
		   				   ::xmloff::token::XMLTokenEnum eToken	);

	virtual ~XMLDocumentTransformerContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
	virtual void EndElement();
};

TYPEINIT1( XMLDocumentTransformerContext_Impl, XMLTransformerContext );

XMLDocumentTransformerContext_Impl::XMLDocumentTransformerContext_Impl(
		XMLTransformerBase& rImp,
		const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName ),
	m_aElemQName( rQName )
{
}
XMLDocumentTransformerContext_Impl::XMLDocumentTransformerContext_Impl(
		XMLTransformerBase& rImp,
		const OUString& rQName ,
	    sal_uInt16 nPrefix,
		::xmloff::token::XMLTokenEnum eToken) :
	XMLTransformerContext( rImp, rQName ),
	m_aElemQName( rImp.GetNamespaceMap().GetQNameByKey( nPrefix,
							::xmloff::token::GetXMLToken( eToken ) ) )
{
}

XMLDocumentTransformerContext_Impl::~XMLDocumentTransformerContext_Impl()
{
}

void XMLDocumentTransformerContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	Reference< XAttributeList > xAttrList( rAttrList );

	m_aOldClass = GetTransformer().GetClass();

	XMLMutableAttributeList *pMutableAttrList = 0;
	sal_Bool bOOo = sal_False, bOOoW = sal_False, bOOoC = sal_False,
			 bDOM=sal_False, bDC = sal_False, bSVG = sal_False;
	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																 &aLocalName );
		if( XML_NAMESPACE_OFFICE == nPrefix &&
			IsXMLToken( aLocalName, XML_CLASS ) )
		{
			const OUString& rValue = xAttrList->getValueByIndex( i );
			GetTransformer().SetClass( rValue );

			pMutableAttrList = new XMLMutableAttributeList( xAttrList );
			xAttrList = pMutableAttrList;
			OUString sMime(RTL_CONSTASCII_USTRINGPARAM("application/x-vnd.oasis.openoffice.") );
			sMime += rValue;
			pMutableAttrList->SetValueByIndex( i, sMime );
			OUString aNewAttrQName( GetTransformer().GetNamespaceMap().GetQNameByKey( XML_NAMESPACE_OFFICE, ::xmloff::token::GetXMLToken( XML_MIMETYPE ) ) );
			pMutableAttrList->RenameAttributeByIndex(i, aNewAttrQName );
			break;
		}
		else if( XML_NAMESPACE_XMLNS == nPrefix )
		{
			const OUString& rAttrValue = xAttrList->getValueByIndex( i );
			if( IsXMLToken( rAttrValue, XML_N_OOO ) )
				bOOo = sal_True;
			else if( IsXMLToken( rAttrValue, XML_N_OOOW ) )
				bOOoW = sal_True;
			else if( IsXMLToken( rAttrValue, XML_N_OOOC ) )
				bOOoC = sal_True;
			else if( IsXMLToken( rAttrValue, XML_N_DOM ) )
				bDOM = sal_True;
			else if( IsXMLToken( rAttrValue, XML_N_DC ) )
				bDC = sal_True;
			else if( IsXMLToken( rAttrValue, XML_N_SVG ) )
				bSVG = sal_True;
		}
	}
	if( !(bOOo && bOOoW && bOOoC && bDOM && bDC && bSVG) )
	{
		if( !pMutableAttrList  )
		{
			pMutableAttrList = new XMLMutableAttributeList( xAttrList );
			xAttrList = pMutableAttrList;
		}
		if( !bOOo )
			pMutableAttrList->AddAttribute(
					GetTransformer().GetNamespaceMap().GetAttrNameByKey(
						XML_NAMESPACE_OOO ),
					GetTransformer().GetNamespaceMap().GetNameByKey(
						XML_NAMESPACE_OOO ) );
		if( !bOOoW )
			pMutableAttrList->AddAttribute(
					GetTransformer().GetNamespaceMap().GetAttrNameByKey(
						XML_NAMESPACE_OOOW ),
					GetTransformer().GetNamespaceMap().GetNameByKey(
						XML_NAMESPACE_OOOW ) );
		if( !bOOoC )
			pMutableAttrList->AddAttribute(
					GetTransformer().GetNamespaceMap().GetAttrNameByKey(
						XML_NAMESPACE_OOOC ),
					GetTransformer().GetNamespaceMap().GetNameByKey(
						XML_NAMESPACE_OOOC ) );
		if( !bDOM )
			pMutableAttrList->AddAttribute(
					GetTransformer().GetNamespaceMap().GetAttrNameByKey(
						XML_NAMESPACE_DOM ),
					GetTransformer().GetNamespaceMap().GetNameByKey(
						XML_NAMESPACE_DOM ) );
		if( !bDC )
			pMutableAttrList->AddAttribute(
					GetTransformer().GetNamespaceMap().GetAttrNameByKey(
						XML_NAMESPACE_DC ),
					GetTransformer().GetNamespaceMap().GetNameByKey(
						XML_NAMESPACE_DC ) );
		if( !bSVG )
			pMutableAttrList->AddAttribute(
					GetTransformer().GetNamespaceMap().GetAttrNameByKey(
						XML_NAMESPACE_SVG ),
					GetTransformer().GetNamespaceMap().GetNameByKey(
						XML_NAMESPACE_SVG ) );
	}

	GetTransformer().GetDocHandler()->startElement( m_aElemQName, xAttrList );
}

void XMLDocumentTransformerContext_Impl::EndElement()
{
	GetTransformer().GetDocHandler()->endElement( m_aElemQName );

	GetTransformer().SetClass( m_aOldClass );
}

//-----------------------------------------------------------------------------

class XMLBodyTransformerContext_Impl : public XMLTransformerContext
{
	OUString m_aClassQName;

public:
	TYPEINFO();

	XMLBodyTransformerContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLBodyTransformerContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
	virtual void EndElement();
};

TYPEINIT1( XMLBodyTransformerContext_Impl, XMLTransformerContext );

XMLBodyTransformerContext_Impl::XMLBodyTransformerContext_Impl(
		XMLTransformerBase& rImp,
		const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName )
{
}

XMLBodyTransformerContext_Impl::~XMLBodyTransformerContext_Impl()
{
}

void XMLBodyTransformerContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	XMLTransformerContext::StartElement( rAttrList );

	XMLMutableAttributeList *pMutableAttrList =
		new XMLMutableAttributeList( rAttrList );
	Reference< XAttributeList > xAttrList = pMutableAttrList;
	OUString aClass( GetTransformer().GetClass() );
	if( !aClass.getLength() )
	{
		aClass = GetXMLToken( XML_TEXT );
	}
	else if( IsXMLToken( aClass, XML_TEXT_GLOBAL ) )
	{
		OUString aGlobalQName(
				GetTransformer().GetNamespaceMap().GetQNameByKey(
							XML_NAMESPACE_TEXT, GetXMLToken(XML_GLOBAL ) ) );
		pMutableAttrList->AddAttribute( aGlobalQName, GetXMLToken(XML_TRUE) );

		aClass = GetXMLToken( XML_TEXT );
	}

	m_aClassQName = GetTransformer().GetNamespaceMap().GetQNameByKey(
						XML_NAMESPACE_OFFICE, aClass );
	GetTransformer().GetDocHandler()->startElement( m_aClassQName,
													xAttrList );
}

void XMLBodyTransformerContext_Impl::EndElement()
{
	GetTransformer().GetDocHandler()->endElement( m_aClassQName );
	XMLTransformerContext::EndElement();
}

//-----------------------------------------------------------------------------

class XMLTabStopOOoTContext_Impl : public XMLPersElemContentTContext
{
public:
	TYPEINFO();

	XMLTabStopOOoTContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLTabStopOOoTContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
};

TYPEINIT1( XMLTabStopOOoTContext_Impl, XMLPersElemContentTContext );

XMLTabStopOOoTContext_Impl::XMLTabStopOOoTContext_Impl(
		XMLTransformerBase& rImp,
		const OUString& rQName ) :
	XMLPersElemContentTContext( rImp, rQName )
{
}

XMLTabStopOOoTContext_Impl::~XMLTabStopOOoTContext_Impl()
{
}

void XMLTabStopOOoTContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	XMLTransformerActions *pActions =
		GetTransformer().GetUserDefinedActions( OOO_TAB_STOP_ACTIONS  );
	OSL_ENSURE( pActions, "go no actions" );

	Reference< XAttributeList > xAttrList( rAttrList );
	XMLMutableAttributeList *pMutableAttrList = 0;
	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																 &aLocalName );
		XMLTransformerActions::key_type aKey( nPrefix, aLocalName );
		XMLTransformerActions::const_iterator aIter =
			pActions->find( aKey );
		if( !(aIter == pActions->end() ) )
		{
			if( !pMutableAttrList )
			{
				pMutableAttrList =
					new XMLMutableAttributeList( xAttrList );
				xAttrList = pMutableAttrList;
			}
			const OUString& rAttrValue = xAttrList->getValueByIndex( i );
			switch( (*aIter).second.m_nActionType )
			{
			case XML_ATACTION_RENAME:
				{
					OUString aNewAttrQName(
						GetTransformer().GetNamespaceMap().GetQNameByKey(
							(*aIter).second.GetQNamePrefixFromParam1(),
							::xmloff::token::GetXMLToken(
							(*aIter).second.GetQNameTokenFromParam1()) ) );
					pMutableAttrList->RenameAttributeByIndex( i,
															  aNewAttrQName );
				}
				if( IsXMLToken( aLocalName, XML_LEADER_CHAR ) &&
				 	rAttrValue.getLength() > 0 &&
					rAttrValue[0] != ' ' )
				{
					OUString aNewAttrQName(
						GetTransformer().GetNamespaceMap().GetQNameByKey(
							XML_NAMESPACE_STYLE,
							::xmloff::token::GetXMLToken(XML_LEADER_STYLE) ) );
					pMutableAttrList->AddAttribute( aNewAttrQName,
												 GetXMLToken( XML_SOLID ) );
				}
				break;
			case XML_ATACTION_INCH2IN:
				{
					OUString aAttrValue( rAttrValue );
					if( XMLTransformerBase::ReplaceSingleInchWithIn(
								aAttrValue ) )
						pMutableAttrList->SetValueByIndex( i, aAttrValue );
				}
				break;
			default:
				OSL_ENSURE( !this, "unknown action" );
				break;
			}
		}
	}

	XMLPersElemContentTContext::StartElement( xAttrList );
}

// -----------------------------------------------------------------------------

class XMLTrackedChangesOOoTContext_Impl : public XMLTransformerContext
{
	sal_uInt16 m_nPrefix;
	XMLTokenEnum m_eToken;

public:

	TYPEINFO();

	XMLTrackedChangesOOoTContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName,
		   					sal_uInt16 nPrefix,
							XMLTokenEnum eToken	);

	virtual ~XMLTrackedChangesOOoTContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
};

TYPEINIT1( XMLTrackedChangesOOoTContext_Impl, XMLTransformerContext );

XMLTrackedChangesOOoTContext_Impl::XMLTrackedChangesOOoTContext_Impl(
		XMLTransformerBase& rImp,
	    const OUString& rQName,
		sal_uInt16 nPrefix,
		XMLTokenEnum eToken	) :
	XMLTransformerContext( rImp, rQName ),
	m_nPrefix( nPrefix ),
	m_eToken( eToken )
{
}

XMLTrackedChangesOOoTContext_Impl::~XMLTrackedChangesOOoTContext_Impl()
{
}

void XMLTrackedChangesOOoTContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
	Reference< XAttributeList > xAttrList( rAttrList );
	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rAttrName = xAttrList->getNameByIndex( i );
		OUString aLocalName;
		sal_uInt16 nPrefix =
			GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																 &aLocalName );
		if( m_nPrefix == nPrefix && IsXMLToken( aLocalName, m_eToken ) )
		{
			const Reference< XPropertySet > rPropSet =
				GetTransformer().GetPropertySet();
			OSL_ENSURE( rPropSet.is(), "no info property set" );
			if( rPropSet.is() )
			{
				const sal_Char sRedlineProtectionKey[] = "RedlineProtectionKey";
				OUString aPropName(RTL_CONSTASCII_USTRINGPARAM(sRedlineProtectionKey));
				Reference< XPropertySetInfo > xPropSetInfo(
							rPropSet->getPropertySetInfo() );
				if( xPropSetInfo.is() &&
					xPropSetInfo->hasPropertyByName( aPropName ) )
				{
					Sequence < sal_Int8 > aKey;
					SvXMLUnitConverter::decodeBase64( aKey,
										xAttrList->getValueByIndex( i ) );
					rPropSet->setPropertyValue( aPropName, makeAny( aKey ) );
				}
				else
				{
					OSL_ENSURE( !this, "RedineProtectionKey is missing" );
				}
			}
			break;
		}
	}
	XMLTransformerContext::StartElement( xAttrList );
}

// -----------------------------------------------------------------------------

class XMLTableOOoTransformerContext_Impl : public XMLTransformerContext
{
	::rtl::OUString m_aElemQName;

public:
	TYPEINFO();

	XMLTableOOoTransformerContext_Impl( XMLTransformerBase& rTransformer,
						   const ::rtl::OUString& rQName );

	virtual ~XMLTableOOoTransformerContext_Impl();

	virtual void StartElement( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList );
	virtual void EndElement();
};

TYPEINIT1( XMLTableOOoTransformerContext_Impl, XMLTransformerContext );

XMLTableOOoTransformerContext_Impl::XMLTableOOoTransformerContext_Impl(
		XMLTransformerBase& rImp,
	    const OUString& rQName ) :
	XMLTransformerContext( rImp, rQName ),
	m_aElemQName( rQName )
{
}

XMLTableOOoTransformerContext_Impl::~XMLTableOOoTransformerContext_Impl()
{
}

void XMLTableOOoTransformerContext_Impl::StartElement(
		const Reference< XAttributeList >& rAttrList )
{
    // --> OD 2005-07-05 #i50521# - perform OOO_STYLE_REF_ACTIONS for all applications
    Reference< XAttributeList > xAttrList( rAttrList );
    XMLMutableAttributeList* pMutableAttrList =
        GetTransformer().ProcessAttrList( xAttrList, OOO_STYLE_REF_ACTIONS, sal_False );
    // <--
    if( rAttrList->getLength() && IsXMLToken( GetTransformer().GetClass(), XML_SPREADSHEET  ) )
    {
        sal_Bool bPrintRanges(sal_False);

	    sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	    for( sal_Int16 i=0; i < nAttrCount; i++ )
	    {
		    const OUString& rAttrName = xAttrList->getNameByIndex( i );
		    OUString aLocalName;
		    sal_uInt16 nPrefix =
			    GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
																    &aLocalName );
            if( XML_NAMESPACE_TABLE == nPrefix &&
                IsXMLToken( aLocalName, XML_PRINT_RANGES ) )
            {
                bPrintRanges = sal_True;
            }
	    }
        if (!bPrintRanges && pMutableAttrList)
        {
			xAttrList = pMutableAttrList;
            pMutableAttrList->AddAttribute(GetTransformer().GetNamespaceMap().GetQNameByKey(
								XML_NAMESPACE_TABLE,
								GetXMLToken( XML_PRINT ) ), GetXMLToken ( XML_FALSE ));
        }
    }

    GetTransformer().GetDocHandler()->startElement( m_aElemQName, xAttrList );
}

void XMLTableOOoTransformerContext_Impl::EndElement()
{
	GetTransformer().GetDocHandler()->endElement( m_aElemQName );
}


//-----------------------------------------------------------------------------

XMLTransformerContext *OOo2OasisTransformer::CreateUserDefinedContext(
							  const TransformerAction_Impl& rAction,
							  const OUString& rQName,
	   						  sal_Bool bPersistent	)
{
	switch( rAction.m_nActionType )
	{
	case XML_ETACTION_DOCUMENT:
		return new XMLDocumentTransformerContext_Impl( *this, rQName );

		break;
	case XML_ETACTION_DOCUMENT_RENAME:
		return new XMLDocumentTransformerContext_Impl( *this, rQName,
							rAction.GetQNamePrefixFromParam1(),
							rAction.GetQNameTokenFromParam1() );
		break;
	case XML_ETACTION_BODY:
		return new XMLBodyTransformerContext_Impl( *this, rQName );
		break;
	case XML_ETACTION_STYLE:
		return new XMLStyleOOoTContext( *this, rQName,
			   				static_cast< XMLFamilyType >( rAction.m_nParam1 ),
			   				bPersistent	);
		break;
	case XML_ETACTION_STYLE_RENAME:
		return new XMLStyleOOoTContext( *this, rQName,
				    static_cast< XMLFamilyType >( rAction.m_nParam2 ),
					rAction.GetQNamePrefixFromParam1(),
					rAction.GetQNameTokenFromParam1(),
					bPersistent	);
		break;
	case XML_ETACTION_FRAME:
		return new XMLFrameOOoTransformerContext( *this, rQName );
		break;
	case XML_ETACTION_EVENT:
		return new XMLEventOOoTransformerContext( *this, rQName, bPersistent );
		break;
	case XML_ETACTION_TAB_STOP:
		return new XMLTabStopOOoTContext_Impl( *this, rQName );
		break;
	case XML_ETACTION_FORM_CONTROL:
		return new XMLControlOOoTransformerContext( *this, rQName );
		break;
	case XML_ETACTION_FORM_PROPERTY:
		return new XMLFormPropOOoTransformerContext( *this, rQName );
		break;
	case XML_ETACTION_CHART:
		return new XMLChartOOoTransformerContext( *this, rQName );
		break;
	case XML_ETACTION_TRACKED_CHANGES:
		return new XMLTrackedChangesOOoTContext_Impl( *this, rQName,
			   				rAction.GetQNamePrefixFromParam1(),
							rAction.GetQNameTokenFromParam1() );
    case XML_ETACTION_CHART_PLOT_AREA:
        return new XMLChartPlotAreaOOoTContext( *this, rQName );
        break;
    case XML_ETACTION_TABLE:
        return new XMLTableOOoTransformerContext_Impl( *this, rQName );
        break;
	default:
		OSL_ENSURE( !this, "no user defined context found!" );
	}

	// default is copying
	return new XMLTransformerContext( *this, rQName );
}

XMLTransformerActions *OOo2OasisTransformer::GetUserDefinedActions(
		sal_uInt16 n )
{
	XMLTransformerActions *pActions = 0;
	if( n < MAX_OOO_ACTIONS )
	{
		if( !m_aActions[n] )
		{
			if( n<MAX_OOO_PROP_ACTIONS )
			{
				m_aActions[n] =
					XMLStyleOOoTContext::CreateTransformerActions( n );
			}
			else switch( n )
			{
				case OOO_STYLE_ACTIONS:
					m_aActions[OOO_STYLE_ACTIONS] =
						new XMLTransformerActions( aStyleActionTable );
					break;
				case OOO_FONT_DECL_ACTIONS:
					m_aActions[OOO_FONT_DECL_ACTIONS] =
						new XMLTransformerActions( aFontDeclActionTable );
					break;
				case OOO_SHAPE_ACTIONS:
					m_aActions[OOO_SHAPE_ACTIONS] =
						new XMLTransformerActions( aShapeActionTable );
					break;
				case OOO_CONNECTOR_ACTIONS:
					m_aActions[OOO_CONNECTOR_ACTIONS] =
						new XMLTransformerActions( aConnectorActionTable );
					break;
				case OOO_TAB_STOP_ACTIONS:
					m_aActions[OOO_TAB_STOP_ACTIONS] =
						new XMLTransformerActions( aTabStopActionTable );
					break;
				case OOO_INDEX_ENTRY_TAB_STOP_ACTIONS:
					m_aActions[OOO_INDEX_ENTRY_TAB_STOP_ACTIONS] =
						new XMLTransformerActions( aIndexEntryTabStopActionTable );
					break;
				case OOO_LINENUMBERING_ACTIONS:
					m_aActions[OOO_LINENUMBERING_ACTIONS] =
						new XMLTransformerActions( aLineNumberingActionTable );
					break;
				case OOO_FOOTNOTE_SEP_ACTIONS:
					m_aActions[OOO_FOOTNOTE_SEP_ACTIONS] =
						new XMLTransformerActions( aFootnoteSepActionTable );
					break;
				case OOO_DROP_CAP_ACTIONS:
					m_aActions[OOO_DROP_CAP_ACTIONS] =
						new XMLTransformerActions( aDropCapActionTable );
					break;
				case OOO_COLUMNS_ACTIONS:
					m_aActions[OOO_COLUMNS_ACTIONS] =
						new XMLTransformerActions( aColumnsActionTable );
					break;
				case OOO_TEXT_VALUE_TYPE_ACTIONS:
					m_aActions[OOO_TEXT_VALUE_TYPE_ACTIONS] =
						new XMLTransformerActions( aTextValueTypeActionTable );
					break;
				case OOO_TABLE_VALUE_TYPE_ACTIONS:
					m_aActions[OOO_TABLE_VALUE_TYPE_ACTIONS] =
						new XMLTransformerActions( aTableValueTypeActionTable );
					break;
				case OOO_PARA_ACTIONS:
					m_aActions[OOO_PARA_ACTIONS] =
						new XMLTransformerActions( aParaActionTable );
					break;
				case OOO_STYLE_REF_ACTIONS:
					m_aActions[OOO_STYLE_REF_ACTIONS] =
						new XMLTransformerActions( aStyleRefActionTable );
					break;
				case OOO_MASTER_PAGE_ACTIONS:
					m_aActions[OOO_MASTER_PAGE_ACTIONS] =
						new XMLTransformerActions( aMasterPageActionTable );
					break;
				case OOO_ANNOTATION_ACTIONS:
					m_aActions[OOO_ANNOTATION_ACTIONS] =
						new XMLTransformerActions( aAnnotationActionTable );
					break;
				case OOO_CHANGE_INFO_ACTIONS:
					m_aActions[OOO_CHANGE_INFO_ACTIONS] =
						new XMLTransformerActions( aChangeInfoActionTable );
					break;
				case OOO_FRAME_ELEM_ACTIONS:
					m_aActions[OOO_FRAME_ELEM_ACTIONS] =
						new XMLTransformerActions( aFrameElemActionTable );
					break;
				case OOO_FRAME_ATTR_ACTIONS:
					m_aActions[OOO_FRAME_ATTR_ACTIONS] =
						new XMLTransformerActions( aFrameAttrActionTable );
					break;
				case OOO_BACKGROUND_IMAGE_ACTIONS:
                    // --> OD 2005-06-10 #i50322#
                    // use special actions for Writer documents.
                    m_aActions[OOO_BACKGROUND_IMAGE_ACTIONS] =
                        isWriter()
                        ? new XMLTransformerActions( aWriterBackgroundImageActionTable )
                        : new XMLTransformerActions( aBackgroundImageActionTable );
                    // <--
					break;
				case OOO_DDE_CONNECTION_DECL_ACTIONS:
					m_aActions[OOO_DDE_CONNECTION_DECL_ACTIONS] =
						new XMLTransformerActions( aDDEConnectionDeclActionTable );
					break;
				case OOO_EVENT_ACTIONS:
					m_aActions[OOO_EVENT_ACTIONS] =
						new XMLTransformerActions( aEventActionTable );
					break;
				case OOO_FORM_CONTROL_ACTIONS:
					m_aActions[OOO_FORM_CONTROL_ACTIONS] =
						new XMLTransformerActions( aFormControlActionTable );
					break;
				case OOO_FORM_COLUMN_ACTIONS:
					m_aActions[OOO_FORM_COLUMN_ACTIONS] =
						new XMLTransformerActions( aFormColumnActionTable );
					break;
				case OOO_FORM_PROP_ACTIONS:
					m_aActions[OOO_FORM_PROP_ACTIONS] =
						new XMLTransformerActions( aFormPropActionTable );
					break;
				case OOO_XLINK_ACTIONS:
					m_aActions[OOO_XLINK_ACTIONS] =
						new XMLTransformerActions( aXLinkActionTable );
					break;
				case OOO_CONFIG_ITEM_SET_ACTIONS:
					m_aActions[OOO_CONFIG_ITEM_SET_ACTIONS] =
						new XMLTransformerActions( aConfigItemSetActionTable );
					break;
				case OOO_FORMULA_ACTIONS:
					m_aActions[OOO_FORMULA_ACTIONS] =
						new XMLTransformerActions( aFormulaActionTable );
					break;
                case OOO_CHART_ACTIONS:
					m_aActions[OOO_CHART_ACTIONS] =
						new XMLTransformerActions( aChartActionTable );
					break;
				case OOO_ERROR_MACRO_ACTIONS:
					m_aActions[OOO_ERROR_MACRO_ACTIONS] =
						new XMLTransformerActions( aErrorMacroActionTable );
					break;
				case OOO_DDE_CONV_MODE_ACTIONS:
					m_aActions[OOO_DDE_CONV_MODE_ACTIONS] =
						new XMLTransformerActions( aDDEConvModeActionTable );
					break;
                case OOO_ALPHABETICAL_INDEX_MARK_ACTIONS:
                    m_aActions[OOO_ALPHABETICAL_INDEX_MARK_ACTIONS] =
                        new XMLTransformerActions( aAlphabeticalIndexMarkActionTable );
                    break;
			    case OOO_DATAPILOT_MEMBER_ACTIONS:
				    m_aActions[OOO_DATAPILOT_MEMBER_ACTIONS] =
					    new XMLTransformerActions( aDataPilotMemberActionTable );
			    case OOO_DATAPILOT_LEVEL_ACTIONS:
				    m_aActions[OOO_DATAPILOT_LEVEL_ACTIONS] =
					    new XMLTransformerActions( aDataPilotLevelActionTable );
			    case OOO_SOURCE_SERVICE_ACTIONS:
				    m_aActions[OOO_SOURCE_SERVICE_ACTIONS] =
					    new XMLTransformerActions( aSourceServiceActionTable );
                case OOO_DRAW_AREA_POLYGON_ACTIONS:
                    m_aActions[OOO_DRAW_AREA_POLYGON_ACTIONS] =
                        new XMLTransformerActions( aShapeActionTable );
                    m_aActions[OOO_DRAW_AREA_POLYGON_ACTIONS]
                        ->Add( aDrawAreaPolygonActionTable );
                    break;
                case OOO_SCRIPT_ACTIONS:
                    m_aActions[OOO_SCRIPT_ACTIONS] =
                        new XMLTransformerActions( aScriptActionTable );
					break;
			}
		}
		pActions = m_aActions[n];
	}

	return pActions;
}

OUString OOo2OasisTransformer::GetEventName( const OUString& rName, sal_Bool )
{
	if( !m_pEventMap )
		m_pEventMap = XMLEventOOoTransformerContext::CreateEventMap();

	OUString aNewName;
	sal_uInt16 nPrefix = XMLEventOOoTransformerContext::GetEventName( rName,
													aNewName, *m_pEventMap );
	if( XML_NAMESPACE_UNKNOWN != nPrefix )
		aNewName = GetNamespaceMap().GetQNameByKey( nPrefix, aNewName );
	else
		aNewName = rName;

	return aNewName;
}


OOo2OasisTransformer::OOo2OasisTransformer( const sal_Char *pImplName,
											const sal_Char *pSubServiceName )
		throw() :
	XMLTransformerBase( aActionTable, aTokenMap ),
	m_pEventMap( 0 )
{
	if( pImplName )
		m_aImplName = OUString::createFromAscii( pImplName );
	else
		m_aImplName = OOo2OasisTransformer_getImplementationName();
	if( pSubServiceName )
		m_aSubServiceName = OUString::createFromAscii( pSubServiceName );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE_OOO), XML_NAMESPACE_OFFICE );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE), XML_NAMESPACE_OFFICE );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META_OOO), XML_NAMESPACE_META );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META), XML_NAMESPACE_META );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE_OOO), XML_NAMESPACE_STYLE );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE), XML_NAMESPACE_STYLE );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER_OOO), XML_NAMESPACE_NUMBER );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER), XML_NAMESPACE_NUMBER );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG_OOO), XML_NAMESPACE_CONFIG );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG), XML_NAMESPACE_CONFIG );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT_OOO), XML_NAMESPACE_TEXT );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT), XML_NAMESPACE_TEXT );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE_OOO), XML_NAMESPACE_TABLE );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE), XML_NAMESPACE_TABLE );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW_OOO), XML_NAMESPACE_DRAW );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW), XML_NAMESPACE_DRAW );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D_OOO), XML_NAMESPACE_DR3D );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D), XML_NAMESPACE_DR3D );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION_OOO), XML_NAMESPACE_PRESENTATION );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION), XML_NAMESPACE_PRESENTATION );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART_OOO), XML_NAMESPACE_CHART );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART), XML_NAMESPACE_CHART );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM_OOO), XML_NAMESPACE_FORM );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM), XML_NAMESPACE_FORM );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT_OOO), XML_NAMESPACE_SCRIPT );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT), XML_NAMESPACE_SCRIPT );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO), XML_NAMESPACE_FO );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO_COMPAT), XML_NAMESPACE_FO );

	GetNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG),  XML_NAMESPACE_SVG );
	GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG_COMPAT), XML_NAMESPACE_SVG );

	for( sal_uInt16 i=0; i<MAX_OOO_ACTIONS; ++i )
		m_aActions[i] = 0;
}

OOo2OasisTransformer::~OOo2OasisTransformer() throw()
{
	for( sal_uInt16 i=0; i<MAX_OOO_ACTIONS; ++i )
		delete m_aActions[i];
	XMLEventOOoTransformerContext::FlushEventMap( m_pEventMap );
}

Any OOo2OasisTransformer::queryInterface( const Type& rType )
    throw (RuntimeException)
{
    Any aRet;
    if ( rType == ::getCppuType((Reference<XImporter> *)0) )
    {
        Reference<XImporter> xThis( this );
       	aRet <<= xThis;
    }
    else if ( rType == ::getCppuType((Reference<XFilter> *)0) )
    {
        Reference<XFilter> xThis( this );
        aRet <<= xThis;
    }
    else
    {
        aRet = XMLTransformerBase::queryInterface(rType);
    }

    return aRet;
}

// XImporter
void SAL_CALL OOo2OasisTransformer::setTargetDocument(
		const Reference< XComponent >& xDoc )
	throw( IllegalArgumentException, RuntimeException)
{
	if( !GetDocHandler().is() )
	{
		// if initialize hasn't been called, then we have to call it now
		// to get the sub component initialized.
		Sequence<Any> aArgs( 0 );
		Initialize( aArgs );
	}

	mxModel.set( xDoc, UNO_QUERY );

	Reference< XImporter > xImp( GetDocHandler(), UNO_QUERY );
	OSL_ENSURE( xImp.is(), "doc handler is not an importer" );
	if( xImp.is() )
		xImp->setTargetDocument( xDoc );
}

// XFilter
sal_Bool SAL_CALL OOo2OasisTransformer::filter(
		const Sequence< PropertyValue >& aDescriptor )
    throw ( RuntimeException)
{
	Reference< XFilter> xFilter( GetDocHandler(), UNO_QUERY );
	OSL_ENSURE( xFilter.is(), "doc handler is not a filter" );
	if( xFilter.is() )
		return xFilter->filter( aDescriptor );

    return sal_False;
}

void SAL_CALL OOo2OasisTransformer::cancel(  )
    throw ( RuntimeException)
{
	Reference< XFilter> xFilter( GetDocHandler(), UNO_QUERY );
	OSL_ENSURE( xFilter.is(), "doc handler is not a filter" );
	if( xFilter.is() )
		xFilter->cancel();
}

// XInitialize
void SAL_CALL OOo2OasisTransformer::initialize(
				const Sequence< Any >& rArguments )
	throw( Exception, RuntimeException )
{
	Initialize( rArguments );
}

void SAL_CALL OOo2OasisTransformer::startDocument( void )
	throw( SAXException, RuntimeException )
{
	if( !GetDocHandler().is() )
	{
		// if initialize hasn't been called, then we have to call it now
		// to get the sub component initialized.
		Sequence<Any> aArgs( 0 );
		Initialize( aArgs );
	}

	XMLTransformerBase::startDocument();
}


void SAL_CALL OOo2OasisTransformer::Initialize(
				const Sequence< Any >& rArguments )
	throw( Exception, RuntimeException )
{
	OSL_ENSURE( !GetDocHandler().is(), "duplication initialization" );

	Reference< XDocumentHandler > xDocHandler;
	if( m_aSubServiceName.getLength() )
	{
		Reference< XMultiServiceFactory > xFactory =
			comphelper::getProcessServiceFactory();
		if( xFactory.is() )
		{
			try
			{
				// get filter component
				xDocHandler = Reference< XDocumentHandler >(
						xFactory->createInstanceWithArguments( m_aSubServiceName,
															   rArguments ),
						UNO_QUERY);
			}
			catch( Exception& )
			{
			}
		}
	}

	OSL_ENSURE( xDocHandler.is(), "can't instantiate filter component" );
	if( xDocHandler.is() )
	{
		Sequence<Any> aArgs( 1 + rArguments.getLength() );
		aArgs[0] <<= xDocHandler;
		for(sal_Int32 i = 0; i < rArguments.getLength(); i++)
			aArgs[i+1] = rArguments[i];
		XMLTransformerBase::initialize( aArgs );

		OSL_ENSURE( GetDocHandler() == xDocHandler,
					"duplicate doc handler" );
	}
	else
	{
		XMLTransformerBase::initialize( rArguments );
	}
}


Sequence< sal_Int8 >  static CreateUnoTunnelId()
{
	static osl::Mutex aCreateMutex;
	::osl::Guard<osl::Mutex> aGuard( aCreateMutex );
	Sequence< sal_Int8 > aSeq( 16 );
    rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0,	sal_True );
	return aSeq;
}

// XUnoTunnelHelper
OOo2OasisTransformer* OOo2OasisTransformer::getImplementation( Reference< XInterface > xInt ) throw()
{
	Reference< XUnoTunnel > xUT( xInt, UNO_QUERY );
	if( xUT.is() )
		return reinterpret_cast< OOo2OasisTransformer* >(
            xUT->getSomething( OOo2OasisTransformer::getUnoTunnelId() ));
	else
		return NULL;
}

const Sequence< sal_Int8 > & OOo2OasisTransformer::getUnoTunnelId() throw()
{
    static Sequence< sal_Int8 > aSeq = ::CreateUnoTunnelId();
	return aSeq;
}

// XUnoTunnel
sal_Int64 SAL_CALL OOo2OasisTransformer::getSomething( const Sequence< sal_Int8 >& rId )
	throw(RuntimeException)
{
    if( rId.getLength() == 16
        && 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(),
										rId.getConstArray(), 16 ) )
    {
		return reinterpret_cast< sal_Int64 >( this );
    }
	else
	{
		return (sal_Int64)0;
	}
}

// XServiceInfo
OUString SAL_CALL OOo2OasisTransformer::getImplementationName()
    throw(RuntimeException)
{
	return m_aImplName;
}

sal_Bool SAL_CALL OOo2OasisTransformer::supportsService( const OUString& rServiceName )
	throw(RuntimeException)
{
    return sal_False;
}

Sequence< OUString > SAL_CALL OOo2OasisTransformer::getSupportedServiceNames(  )
	throw(RuntimeException)
{
    Sequence<OUString> aSeq(0);
    return aSeq;
}

// XTypeProvider
Sequence< ::com::sun::star::uno::Type > SAL_CALL
	OOo2OasisTransformer::getTypes() throw(RuntimeException)
{
	Sequence< ::com::sun::star::uno::Type > aTypes(
						XMLTransformerBase::getTypes() );

	sal_Int32 nIndex = aTypes.getLength();
	aTypes.realloc( nIndex + 2 );

	::com::sun::star::uno::Type* pTypes = aTypes.getArray();
	pTypes[nIndex++] = ::getCppuType( static_cast< Reference< XImporter > * >( 0 ) );
	pTypes[nIndex++] = ::getCppuType( static_cast< Reference< XFilter > * >( 0 ) );

	return aTypes;
}

// Service registration

OUString SAL_CALL OOo2OasisTransformer_getImplementationName() throw()
{
	return OUString( RTL_CONSTASCII_USTRINGPARAM(
		"com.sun.star.comp.OOo2OasisTransformer" ) );
}

Sequence< OUString > SAL_CALL OOo2OasisTransformer_getSupportedServiceNames() throw()
{
	const OUString aServiceName( OOo2OasisTransformer_getImplementationName() );
	const Sequence< OUString > aSeq( &aServiceName, 1 );
	return aSeq;
}

Reference< XInterface > SAL_CALL OOo2OasisTransformer_createInstance(
		const Reference< XMultiServiceFactory > & rSMgr )
	throw( Exception )
{
	return (cppu::OWeakObject*)new OOo2OasisTransformer();
}

#define OOO_IMPORTER( className, implName, subServiceName ) 			\
OUString SAL_CALL className##_getImplementationName() throw()			\
{																		\
	return OUString( RTL_CONSTASCII_USTRINGPARAM( implName ) );			\
}																		\
																		\
Sequence< OUString > SAL_CALL className##_getSupportedServiceNames() throw()\
{																		\
	const OUString aServiceName( className##_getImplementationName() );	\
	const Sequence< OUString > aSeq( &aServiceName, 1 );				\
	return aSeq;														\
}																		\
																		\
Reference< XInterface > SAL_CALL className##_createInstance(			\
		const Reference< XMultiServiceFactory > & rSMgr )				\
	throw( Exception )													\
{																		\
	return (cppu::OWeakObject*)new OOo2OasisTransformer( implName,		\
										 subServiceName );				\
}

OOO_IMPORTER( XMLWriterImportOOO,
			  "com.sun.star.comp.Writer.XMLImporter",
			  "com.sun.star.comp.Writer.XMLOasisImporter" )
OOO_IMPORTER( XMLWriterStylesImportOOO,
			  "com.sun.star.comp.Writer.XMLStylesImporter",
			  "com.sun.star.comp.Writer.XMLOasisStylesImporter" )
OOO_IMPORTER( XMLWriterContentImportOOO,
			  "com.sun.star.comp.Writer.XMLContentImporter",
			  "com.sun.star.comp.Writer.XMLOasisContentImporter" )
OOO_IMPORTER( XMLWriterMetaImportOOO,
			  "com.sun.star.comp.Writer.XMLMetaImporter",
			  "com.sun.star.comp.Writer.XMLOasisMetaImporter" )
OOO_IMPORTER( XMLWriterSettingsImportOOO,
			  "com.sun.star.comp.Writer.XMLSettingsImporter",
			  "com.sun.star.comp.Writer.XMLOasisSettingsImporter" )

OOO_IMPORTER( XMLImpressImportOOO,
			  "com.sun.star.comp.Impress.XMLImporter",
			  "com.sun.star.comp.Impress.XMLOasisImporter" )
OOO_IMPORTER( XMLImpressStylesImportOOO,
			  "com.sun.star.comp.Impress.XMLStylesImporter",
			  "com.sun.star.comp.Impress.XMLOasisStylesImporter" )
OOO_IMPORTER( XMLImpressContentImportOOO,
			  "com.sun.star.comp.Impress.XMLContentImporter",
			  "com.sun.star.comp.Impress.XMLOasisContentImporter" )
OOO_IMPORTER( XMLImpressMetaImportOOO,
			  "com.sun.star.comp.Impress.XMLMetaImporter",
			  "com.sun.star.comp.Impress.XMLOasisMetaImporter" )
OOO_IMPORTER( XMLImpressSettingsImportOOO,
			  "com.sun.star.comp.Impress.XMLSettingsImporter",
			  "com.sun.star.comp.Impress.XMLOasisSettingsImporter" )

OOO_IMPORTER( XMLDrawImportOOO,
			  "com.sun.star.comp.Draw.XMLImporter",
			  "com.sun.star.comp.Draw.XMLOasisImporter" )
OOO_IMPORTER( XMLDrawStylesImportOOO,
			  "com.sun.star.comp.Draw.XMLStylesImporter",
			  "com.sun.star.comp.Draw.XMLOasisStylesImporter" )
OOO_IMPORTER( XMLDrawContentImportOOO,
			  "com.sun.star.comp.Draw.XMLContentImporter",
			  "com.sun.star.comp.Draw.XMLOasisContentImporter" )
OOO_IMPORTER( XMLDrawMetaImportOOO,
			  "com.sun.star.comp.Draw.XMLMetaImporter",
			  "com.sun.star.comp.Draw.XMLOasisMetaImporter" )
OOO_IMPORTER( XMLDrawSettingsImportOOO,
			  "com.sun.star.comp.Draw.XMLSettingsImporter",
			  "com.sun.star.comp.Draw.XMLOasisSettingsImporter" )

OOO_IMPORTER( XMLCalcImportOOO,
			  "com.sun.star.comp.Calc.XMLImporter",
			  "com.sun.star.comp.Calc.XMLOasisImporter" )
OOO_IMPORTER( XMLCalcStylesImportOOO,
			  "com.sun.star.comp.Calc.XMLStylesImporter",
			  "com.sun.star.comp.Calc.XMLOasisStylesImporter" )
OOO_IMPORTER( XMLCalcContentImportOOO,
			  "com.sun.star.comp.Calc.XMLContentImporter",
			  "com.sun.star.comp.Calc.XMLOasisContentImporter" )
OOO_IMPORTER( XMLCalcMetaImportOOO,
			  "com.sun.star.comp.Calc.XMLMetaImporter",
			  "com.sun.star.comp.Calc.XMLOasisMetaImporter" )
OOO_IMPORTER( XMLCalcSettingsImportOOO,
			  "com.sun.star.comp.Calc.XMLSettingsImporter",
			  "com.sun.star.comp.Calc.XMLOasisSettingsImporter" )

OOO_IMPORTER( XMLChartImportOOO,
			  "com.sun.star.comp.Chart.XMLImporter",
			  "com.sun.star.comp.Chart.XMLOasisImporter" )
OOO_IMPORTER( XMLChartStylesImportOOO,
			  "com.sun.star.comp.Chart.XMLStylesImporter",
			  "com.sun.star.comp.Chart.XMLOasisStylesImporter" )
OOO_IMPORTER( XMLChartContentImportOOO,
			  "com.sun.star.comp.Chart.XMLContentImporter",
			  "com.sun.star.comp.Chart.XMLOasisContentImporter" )

OOO_IMPORTER( XMLMathMetaImportOOO,
			  "com.sun.star.comp.Math.XMLMetaImporter",
			  "com.sun.star.comp.Math.XMLOasisMetaImporter" )
OOO_IMPORTER( XMLMathSettingsImportOOO,
			  "com.sun.star.comp.Math.XMLSettingsImporter",
			  "com.sun.star.comp.Math.XMLOasisSettingsImporter" )

OOO_IMPORTER( XMLMetaImportOOO,
			  "com.sun.star.document.XMLMetaImporter",
			  "com.sun.star.document.XMLOasisMetaImporter" )

OOO_IMPORTER( XMLAutoTextEventImportOOO,
			  "com.sun.star.comp.Writer.XMLAutotextEventsImporter",
			  "com.sun.star.comp.Writer.XMLOasisAutotextEventsImporter" )
