/*
 * DesktopDialog.java
 *
 * Created on 29. August 2002, 11:04
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

import com.sun.star.wizards.tutorial.executer.util.FindInterfaces;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * This class is meant for handling all the StarOffice dialogs functionality
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class DesktopDialog extends Components implements XTabList {
	private Helper m_helper;
	private static DesktopDialog m_desktopDialog;

	static {
		new DesktopDialog();
	}

	/**
	 * Creates a new DesktopDialog object.
	 */
	public DesktopDialog() {
		m_desktopDialog = this;
	}

	/**
	 * Creates a new DesktopDialog object.
	 *
	 * @param helper
	 *
	 * @throws java.lang.Exception
	 * @throws Exception DOCUMENT ME!
	 */
	public DesktopDialog(Helper helper) throws java.lang.Exception {
		if (helper == null) {
			throw new Exception("ERROR : Helper is not initialized.");
		}

		m_helper = helper;
	}

	/**
	 * Get Helper
	 *
	 * @return Helper instance
	 */
	public Helper getHelper() {
		return m_helper;
	}

	/**
	 * Set Helper instance
	 *
	 * @param helper DOCUMENT ME!
	 */
	public void setHelper(Helper helper) {
		m_helper = helper;
	}

	/**
	 * Get implemented interfaces
	 *
	 * @return interfaces.
	 */
	public static Hashtable getInterfaces() {
		return (FindInterfaces.getInterfaces(m_desktopDialog.getClass()));
	}
}
