/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salrectangleutils.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:36:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALRECTANGLEUTILS_HXX
#define _SV_SALRECTANGLEUTILS_HXX

#include <premac.h>
#include <ApplicationServices/ApplicationServices.h>
#include <postmac.h>

#ifndef _SV_SALBTYPE_HXX
	#include <salbtype.hxx>
#endif

#ifndef _SV_SALCONST_H
	#include <salconst.h>
#endif

#ifndef _SV_SALBMP_HXX
	#include <salbmp.hxx>
#endif

// ------------------------------------------------------------------

void CheckRectBounds ( const Rect  *rPortBoundsRect,
                       Rect        *rSrcRect, 
                       Rect        *rDstRect
                     );

// ------------------------------------------------------------------

void SalTwoRect2QDDstRect ( const SalTwoRect  *pPosAry,
                            Rect              *rDstRect
                          );
                          
void SalTwoRect2QDSrcRect ( const SalTwoRect  *pPosAry,
                            Rect              *rSrcRect
                          );
                          
// ------------------------------------------------------------------

void GetQDRect ( const long   nX, 
                 const long   nY,
                 const long   nWidth, 
                 const long   nHeight,
                 Rect        *rRect
               );
               
void GetTwoRectFromSalBmp( const SalBitmap  &rSalBmp,
                           SalTwoRect       *rTwoRect
                         );
                         
// ------------------------------------------------------------------

#endif	// _SV_SALRECTANGLEUTILS_HXX
