/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: framedlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:02:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FRAMEDLG_HXX
#define _FRAMEDLG_HXX

// include ---------------------------------------------------------------

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

#include "tabdlg.hxx"

// class SfxFramePropertiesPage_Impl -------------------------------------

class SfxFramePropertiesPage_Impl : public SfxTabPage
{
private:
	FixedText           	aFTName;
	Edit		        	aEDName;
	FixedText	        	aFTURL;
	Edit		        	aEDURL;
	PushButton				aBTOpen;

	RadioButton		    	aRBScrollingOn;
	RadioButton		    	aRBScrollingOff;
	RadioButton		    	aRBScrollingAuto;
    FixedLine               aFLScrolling;

    FixedLine               aFLSepLeft;
    RadioButton             aRBFrameBorderOn;
	RadioButton 	    	aRBFrameBorderOff;
    FixedLine               aFLFrameBorder;

    FixedLine               aFLSepRight;
    FixedText               aFTMarginWidth;
	NumericField	    	aNMMarginWidth;
	CheckBox				aCBMarginWidthDefault;
	FixedText		    	aFTMarginHeight;
	NumericField	    	aNMMarginHeight;
	CheckBox				aCBMarginHeightDefault;
    FixedLine               aFLMargin;

	DECL_STATIC_LINK( 		SfxFramePropertiesPage_Impl, OpenHdl, PushButton* );
	DECL_STATIC_LINK( 		SfxFramePropertiesPage_Impl, CheckHdl, CheckBox* );

public:
							SfxFramePropertiesPage_Impl( Window *pParent, const SfxItemSet& rSet );
	virtual BOOL			FillItemSet( SfxItemSet& );
	virtual void			Reset( const SfxItemSet& );
};

#endif

