/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accelinfo.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:30:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "app.hxx"
#include "accmgr.hxx"

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _SV_KEYCODE_HXX
#include <vcl/keycod.hxx>
#endif

#include <tools/urlobj.hxx>
#include <comphelper/processfactory.hxx>

#include "msgpool.hxx"
#include "module.hxx"
#include "unoctitm.hxx"
#include "dispatch.hxx"
#include "msg.hxx"
#include "msgpool.hxx"
#include "viewfrm.hxx"
#include "objsh.hxx"

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;

::rtl::OUString SAL_CALL GetCommandURLFromKeyCode( const KeyCode& aKeyCode )
{
    SfxAcceleratorManager* pAccManager = SFX_APP()->GetGlobalAcceleratorManager();
	if ( pAccManager )
	{
		USHORT nId = pAccManager->GetId( aKeyCode );
		if ( nId > 0 )
		{
            const SfxSlot* pSlot = SFX_APP()->GetSlotPool().GetSlot( nId );

            // create the dispatch name from the slot data
            ::com::sun::star::util::URL aURL;
            String aName( pSlot && pSlot->pUnoName ? String::CreateFromAscii(pSlot->GetUnoName()) : String() );
            String aCmd;
            if ( aName.Len() )
            {
                aCmd = DEFINE_CONST_UNICODE(".uno:");
                aCmd += aName;
            }
            else
            {
                aCmd = DEFINE_CONST_UNICODE("slot:");
                aCmd += String::CreateFromInt32( nId );
            }

			return aCmd;
		}
	}

	return rtl::OUString();
}

KeyCode SAL_CALL GetKeyCodeFromCommandURL( Reference< XFrame >& rFrame, const rtl::OUString& aCommandURL )
{
    INetURLObject aObj( aCommandURL );
    INetProtocol nProtocol = aObj.GetProtocol();
    switch ( nProtocol )
    {
        case INET_PROT_UNO :
        case INET_PROT_SLOT :
        {
            URL aTargetURL;
            aTargetURL.Complete = aCommandURL;
            Reference < XURLTransformer > xTrans( ::comphelper::getProcessServiceFactory()->createInstance( rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
            xTrans->parseStrict( aTargetURL );

            SfxViewFrame* pViewFrame = NULL;
            Reference < XController > xController;
            if ( rFrame.is() )
                xController = rFrame->getController();

            Reference < XDispatchProvider > xProvider( xController, UNO_QUERY );
            if ( xProvider.is() )
            {
                Reference < XDispatch > xDisp = xProvider->queryDispatch( aTargetURL, ::rtl::OUString(), 0 );
                if ( xDisp.is() )
                {
                    Reference< XUnoTunnel > xTunnel( xDisp, UNO_QUERY );
                    SfxOfficeDispatch* pDisp = NULL;
                    if ( xTunnel.is() )
                    {
                        sal_Int64 nImplementation = xTunnel->getSomething(SfxOfficeDispatch::impl_getStaticIdentifier());
                        pDisp = (SfxOfficeDispatch*)(nImplementation);
                    }

                    if ( pDisp )
                        pViewFrame = pDisp->GetDispatcher_Impl()->GetFrame();
                }
            }

            USHORT nId = 0;
            if ( nProtocol == INET_PROT_UNO )
            {
                SfxSlotPool& rPool = SFX_APP()->GetSlotPool( pViewFrame );
                const SfxSlot* pSlot = rPool.GetUnoSlot( aTargetURL.Path );
                if ( pSlot )
                    nId = pSlot->GetSlotId();
            }
            else
                nId = ( USHORT ) aTargetURL.Path.toInt32();

            SfxModule* pModule = pViewFrame ? pViewFrame->GetObjectShell()->GetModule() : NULL;
            if ( nId )
            {
                if ( pViewFrame )
                {
                    KeyCode                aKeyCode;
                    SfxAcceleratorManager* pAccelMgr = pViewFrame->GetAcceleratorManager();
                    if ( pAccelMgr )
                    {
                        aKeyCode = pAccelMgr->GetKeyCode( nId );
                        if ( aKeyCode == KeyCode() )
                            return SFX_APP()->GetGlobalAcceleratorManager()->GetKeyCode( nId );
                    }
                    
                    return aKeyCode;
                }
                else
                {
                    return SFX_APP()->GetGlobalAcceleratorManager()->GetKeyCode( nId );
                }
            }
            break;
        }

        case INET_PROT_NOT_VALID :
        {
            return KeyCode();
            break;
        }
    }

    return KeyCode();
}
