/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DataSeriesTree.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:26:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "DataSeriesTree.hxx"
#include "macros.hxx"
#include "algohelper.hxx"

#ifndef _COM_SUN_STAR_CHART2_XCHARTTYPEGROUP_HPP_
#include <com/sun/star/chart2/XChartTypeGroup.hpp>
#endif

#include <algorithm>

using namespace ::com::sun::star;

namespace chart
{

DataSeriesTree::DataSeriesTree(
    const uno::Reference< uno::XComponentContext > & xContext )
        : m_xContext( xContext )
{}

DataSeriesTree::~DataSeriesTree()
{}

// ____ XDataSeriesTreeParent ____
uno::Sequence< uno::Reference< chart2::XDataSeriesTreeNode > >
        SAL_CALL DataSeriesTree::getChildren()
    throw (uno::RuntimeException)
{
    return helper::VectorToSequence( m_aChildren );
}

void SAL_CALL DataSeriesTree::addChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (lang::IllegalArgumentException,
               uno::RuntimeException)
{
    if( aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XChartTypeGroup >* )(0))).hasValue() )
    {
        m_aChildren.push_back( aNode );
    }
    else
    {
        throw lang::IllegalArgumentException();
    }
}

void SAL_CALL DataSeriesTree::removeChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (container::NoSuchElementException,
               uno::RuntimeException)
{
    m_tChildType::iterator aIt( ::std::find(
        m_aChildren.begin(),
        m_aChildren.end(),
        aNode ));

    if( aIt == m_aChildren.end())
    {
        throw container::NoSuchElementException();
    }
    else
    {
        m_aChildren.erase( aIt );
    }
}

// helper for lang::XServiceInfo
uno::Sequence< ::rtl::OUString > DataSeriesTree::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.DataSeriesTree" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( DataSeriesTree,
                             C2U( "com.sun.star.comp.chart2.DataSeriesTree" ));


} //  namespace chart
