/*************************************************************************
 *
 *  $RCSfile: revision.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:55:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>
#include "revision.hxx"


/*
 * class Revision
 *
 */

Revision::Revision()
{
	nMajorNumber = 0;
	nMinorNumber = 0;
	pIntList = 0;
}

Revision::Revision( ByteString aRev )
{
	ULONG nCount = aRev.GetTokenCount( '.' );
	pIntList = 0;
	nMajorNumber = aRev.GetToken( 0, '.' ).ToInt32();
	nMinorNumber = aRev.GetToken( 1, '.' ).ToInt32();
	if ( nCount  > 1 )
	{
		pIntList = new IntList;
		for ( USHORT i=2; i<nCount; i++ )
		{
			ByteString aStr = aRev.GetToken( i, '.' );
			int *pInt = new int (atoi ( aStr.GetBuffer() ));
			pIntList->Insert( pInt, LIST_APPEND );
		}
	}
}

Revision& Revision::operator = ( ByteString aRev )
{
	ULONG nCount = aRev.GetTokenCount( '.' );
	nMajorNumber = aRev.GetToken( 0, '.' ).ToInt32();
	nMinorNumber = aRev.GetToken( 1, '.' ).ToInt32();
	if ( nCount  > 1 )
	{
		pIntList = new IntList;
		for ( USHORT i=2; i<nCount; i++ )
		{
			ByteString aStr = aRev.GetToken( i, '.' );
			int *pInt = new int (atoi ( aStr.GetBuffer() ));
			pIntList->Insert( pInt, LIST_APPEND );
		}
	}
	return *this;
}

Revision& Revision::operator=(char const* pChar)
{
	ByteString aRev = pChar;
	ULONG nCount = aRev.GetTokenCount( '.' );
	nMajorNumber = aRev.GetToken( 0, '.' ).ToInt32();
	nMinorNumber = aRev.GetToken( 1, '.' ).ToInt32();
	if ( nCount  > 1 )
	{
		pIntList = new IntList;
		for ( USHORT i=2; i<nCount; i++ )
		{
			ByteString aStr = aRev.GetToken( i, '.' );
			int *pInt = new int (atoi ( aStr.GetBuffer() ));
			pIntList->Insert( pInt, LIST_APPEND );
		}
	}
	return *this;
}

Revision::Revision( ULONG nMajor, ULONG nMinor )
{
	nMajorNumber = nMajor;
	nMinorNumber = nMinor;
	pIntList = 0;
}

Revision::Revision( const Revision& rRev )
{
	nMajorNumber = rRev.nMajorNumber;
	nMinorNumber = rRev.nMinorNumber;
	pIntList = 0;
	if ( rRev.pIntList )
	{
		pIntList = new IntList;
		ULONG nCount = rRev.pIntList->Count();
		for ( ULONG i=0; i<nCount; i++ )
		{
			int *pInt = new int( *rRev.pIntList->GetObject(i));
			pIntList->Insert( pInt, LIST_APPEND );
		}
	}
}

// cast operator auf ByteString
Revision::operator ByteString()
{
	ByteString aByteString = ByteString(nMajorNumber);
	aByteString += ".";
	aByteString += nMinorNumber;
	if ( pIntList )
	{
		ULONG nCount = pIntList->Count();
		for ( ULONG i=0; i<nCount; i++ )
		{
			aByteString += ".";
			aByteString += *pIntList->GetObject(i);
		}
	}
	return aByteString;
}

BOOL operator > ( const Revision& rRev1, const Revision& rRev2 )
{
	if ( rRev1.nMajorNumber > rRev2.nMajorNumber )
		return TRUE;
	else
	if ( rRev1.nMajorNumber < rRev2.nMajorNumber )
		return FALSE;
	else
		if ( rRev1.nMinorNumber > rRev2.nMinorNumber )
			return TRUE;
		else
		if ( rRev1.nMinorNumber < rRev2.nMinorNumber )
			return FALSE;
		else
		{
			ULONG nCount1 = rRev1.pIntList->Count();
			ULONG nCount2 = rRev2.pIntList->Count();
			if ( nCount1 && nCount2 == 0 )
				return TRUE;
			for ( ULONG i=0; i<nCount1; i++ )
			{
				if ( i >= nCount2 )
					return TRUE;
				if ( *rRev1.pIntList->GetObject(i) >
									*rRev2.pIntList->GetObject(i) )
				{
					return TRUE;
					break;
				}
				else
				if ( *rRev1.pIntList->GetObject(i) <
									*rRev2.pIntList->GetObject(i) )
				{
					return FALSE;
					break;
				}
			}
		}
		return FALSE;
}

BOOL operator < ( const Revision& rRev1, const Revision& rRev2 )
{
	if ( rRev1.nMajorNumber < rRev2.nMajorNumber )
		return TRUE;
	else
	if ( rRev1.nMajorNumber > rRev2.nMajorNumber )
		return FALSE;
	else
	{
		if ( rRev1.nMinorNumber < rRev2.nMinorNumber )
			return TRUE;
		else
		if ( rRev1.nMinorNumber > rRev2.nMinorNumber )
			return FALSE;
		else
		{
			ULONG nCount1 = rRev1.pIntList->Count();
			ULONG nCount2 = rRev2.pIntList->Count();
			if ( nCount2 && nCount1 == 0 )
				return TRUE;
			for ( ULONG i=0; i<nCount2; i++ )
			{
				if ( i >= nCount1 )
					return TRUE;
				if ( *rRev1.pIntList->GetObject(i) <
									*rRev2.pIntList->GetObject(i) )
				{
					return TRUE;
					break;
				}
				else
				if ( *rRev1.pIntList->GetObject(i) >
									*rRev2.pIntList->GetObject(i) )
				{
					return FALSE;
					break;
				}
			}
		}
		return FALSE;
	}
	return FALSE;
}

BOOL operator == ( const Revision& rRev1, const Revision& rRev2 )
{
#if OSL_DEBUG_LEVEL > 1
	//fprintf( stderr, "Comparing :  %d . %d : %d . %d \n" , rRev1.nMajorNumber ,
	//		rRev1.nMinorNumber, rRev2.nMajorNumber, rRev2.nMinorNumber );
#endif
	if ( rRev1.nMajorNumber != rRev2.nMajorNumber )
		return FALSE;
	else
	if ( rRev1.nMinorNumber != rRev2.nMinorNumber )
		return FALSE;
	else
	{
		ULONG nCount1 = rRev1.pIntList->Count();
		ULONG nCount2 = rRev2.pIntList->Count();
		if ( nCount2 != nCount1 )
			return FALSE;
		for ( ULONG i=0; i<nCount1; i++ )
		{
			if ( *rRev1.pIntList->GetObject(i) !=
								*rRev2.pIntList->GetObject(i) )
			{
				return FALSE;
				break;
			}
		}
		return TRUE;
	}
}

ULONG Revision::operator++()
{
	if ( pIntList )
	{
		ULONG nCount = pIntList->Count();
		(*pIntList->GetObject(nCount-1))++;
	}
	else
		nMinorNumber++;

	return nMinorNumber;
}


ULONG Revision::operator++(int)
{
	if ( pIntList )
	{
		ULONG nCount = pIntList->Count();
		(*pIntList->GetObject(nCount-1))++;
	}
	else
		nMinorNumber++;
	return nMinorNumber;
}

ULONG Revision::operator--()
{
	if (nMinorNumber)
		return nMinorNumber--;
	else
		return 0;
}


ULONG Revision::operator--(int)
{
	if (nMinorNumber)
		return nMinorNumber--;
	else
		return 0;
}
