/*************************************************************************
 *
 *  $RCSfile: pamcor.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:03:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "editsh.hxx"
#include "pam.hxx"

#include "edimp.hxx"


/*
 * MACROS um ueber alle CrsrShells zu iterieren
 */
#define PCURSH ((SwCrsrShell*)_pStartShell)
#define FOREACHSHELL_START( pEShell ) \
    {\
		register ViewShell *_pStartShell = pEShell; \
		do { \
			if( _pStartShell->IsA( TYPE( SwCrsrShell )) ) \
			{

#define FOREACHSHELL_END( pEShell ) \
			} \
        } while((_pStartShell=(ViewShell*)_pStartShell->GetNext())!= pEShell ); \
	}

/*  */

#define _PaMCorrAbs2( pPam ) \
	for( int nb = 0; nb < 2; ++nb )	\
		if( (pPam)->GetBound( BOOL(nb) ).nNode == nOldNode )	\
		{ \
			(pPam)->GetBound( BOOL(nb) ) = aNewPos; \
			(pPam)->GetBound( BOOL(nb) ).nContent += nOffset; \
		}



void PaMCorrAbs( SwEditShell* pShell,
				const SwNodeIndex &rOldNode,
				const SwPosition &rNewPos,
				const USHORT nOffset)
{
	const ULONG nOldNode = rOldNode.GetIndex();
	const SwPosition aNewPos( rNewPos );

	FOREACHSHELL_START( pShell )
		register SwPaM *_pStkCrsr = PCURSH->GetStkCrsr();
// Alle ueberfluessigen Crsr sind vom Stack, oder ??
//		ASSERT( !_pStkCrsr, "Es stehen noch Crsr auf dem CrsrStack" );
		if( _pStkCrsr )
		do {
			_PaMCorrAbs2( _pStkCrsr )
		} while ( (_pStkCrsr != 0 ) &&
			((_pStkCrsr=(SwPaM *)_pStkCrsr->GetNext()) != PCURSH->GetStkCrsr()) );

		FOREACHPAM_START(PCURSH)
			_PaMCorrAbs2( PCURCRSR )
		FOREACHPAM_END(PCURSH)
		if( PCURSH->IsTableMode() )
			_PaMCorrAbs2( PCURSH->GetTblCrs() )

	FOREACHSHELL_END( pShell )
}


void SwEditShell::PaMCorrAbs( const SwNodeIndex &rOldNode,
							  const SwPosition &rNewPos,
							  const USHORT nOffset )
{
	// alle Verzeichnisse/Bookmarks/.. verschieben.
	GetDoc()->CorrAbs( rOldNode, rNewPos, nOffset );
	::PaMCorrAbs( this, rOldNode, rNewPos, nOffset );
}

/*  */

#define _PaMCorrAbs3( pPam ) \
	for( int nb = 0; nb < 2; ++nb )	\
		if( (pPam)->GetBound( BOOL(nb) ).nNode >= nSttNode && \
			(pPam)->GetBound( BOOL(nb) ).nNode <= nEndNode ) \
			(pPam)->GetBound( BOOL(nb) ) = aNewPos;



void PaMCorrAbs( SwEditShell* pShell,
				 const SwNodeIndex &rStartNode,
				 const SwNodeIndex &rEndNode,
				 const SwPosition &rNewPos )
{
	const ULONG nSttNode = rStartNode.GetIndex();
	const ULONG nEndNode = rEndNode.GetIndex();
	const SwPosition aNewPos( rNewPos );

	FOREACHSHELL_START( pShell )
		register SwPaM *_pStkCrsr = PCURSH->GetStkCrsr();
// Alle ueberfluessigen Crsr sind vom Stack, oder ??
//		ASSERT( !_pStkCrsr, "Es stehen noch Crsr auf dem CrsrStack" );
		if( _pStkCrsr )
		do {
			_PaMCorrAbs3( _pStkCrsr )
		} while ( (_pStkCrsr != 0 ) &&
			((_pStkCrsr=(SwPaM *)_pStkCrsr->GetNext()) != PCURSH->GetStkCrsr()) );

		FOREACHPAM_START(PCURSH)
			_PaMCorrAbs3( PCURCRSR )
		FOREACHPAM_END(PCURSH)

		if( PCURSH->IsTableMode() )
			_PaMCorrAbs3( PCURSH->GetTblCrs() )

	FOREACHSHELL_END( pShell )
}


void SwEditShell::PaMCorrAbs( const SwNodeIndex &rStartNode,
							  const SwNodeIndex &rEndNode,
							  const SwPosition &rNewPos )
{
	// alle Verzeichnisse/Bookmarks/.. verschieben.
	GetDoc()->CorrAbs( rStartNode, rEndNode, rNewPos );
	::PaMCorrAbs( this, rStartNode, rEndNode, rNewPos );
}

/*  */

#define _PaMCorrRel1( pPam ) \
	for( int nb = 0; nb < 2; ++nb )	\
		if( (pPam)->GetBound( BOOL(nb) ).nNode == nOldNode ) \
		{ \
            (pPam)->GetBound( BOOL(nb) ).nNode = aNewPos.nNode; \
			(pPam)->GetBound( BOOL(nb) ).nContent.Assign( (SwIndexReg*) \
							aNewPos.nContent.GetIdxReg(), \
							nCntIdx + (pPam)->GetBound( BOOL(nb) ).nContent. \
								GetIndex() ); \
		}



void PaMCorrRel( SwEditShell *pShell,
				 const SwNodeIndex &rOldNode,
				 const SwPosition &rNewPos,
				 const USHORT nOffset )
{
	const ULONG nOldNode = rOldNode.GetIndex();
	SwPosition aNewPos( rNewPos );
	USHORT nCntIdx = rNewPos.nContent.GetIndex() + nOffset;

	FOREACHSHELL_START( pShell )
		register SwPaM *_pStkCrsr = PCURSH->GetStkCrsr();
// Alle ueberfluessigen Crsr sind vom Stack, oder ??
//		ASSERT( !_pStkCrsr, "Es stehen noch Crsr auf dem CrsrStack" );
		if( _pStkCrsr )
		do {
			_PaMCorrRel1( _pStkCrsr )
		} while ( (_pStkCrsr != 0 ) &&
			((_pStkCrsr=(SwPaM *)_pStkCrsr->GetNext()) != PCURSH->GetStkCrsr()) );

		FOREACHPAM_START(PCURSH)
			_PaMCorrRel1( PCURCRSR )
		FOREACHPAM_END(PCURSH)

		if( PCURSH->IsTableMode() )
			_PaMCorrRel1( PCURSH->GetTblCrs() )

	FOREACHSHELL_END( pShell )
}


void SwEditShell::PaMCorrRel( const SwNodeIndex &rOldNode,
							  const SwPosition &rNewPos,
							  const USHORT nOffset )
{
	// alle Verzeichnisse/Bookmarks/.. verschieben.
	GetDoc()->CorrRel( rOldNode, rNewPos, nOffset );
	::PaMCorrRel( this, rOldNode, rNewPos, nOffset );
}

/*  */


void lcl_PaMCorrAbs( SwPaM* pPam, const SwPosition& rStt,
						const SwPosition& rEnd, const SwPosition& rNewPos )
{
	if( rStt <= pPam->GetBound() && pPam->GetBound() <= rEnd )
		// dann auf die neue Position setzen
		pPam->GetBound() = rNewPos;

	// teste, ob sich die Position innerhalb des Ranges befindet
	if( rStt <= pPam->GetBound(FALSE) && pPam->GetBound(FALSE) <= rEnd )
		pPam->GetBound(FALSE) = rNewPos;
}


void PaMCorrAbs( SwEditShell *pShell,
				const SwPaM& rRange,
				const SwPosition& rNewPos )
{
	SwPosition aStart( *rRange.Start() );
	SwPosition aEnd( *rRange.End() );
	SwPosition aNewPos( rNewPos );

	FOREACHSHELL_START( pShell )
		register SwPaM *_pStkCrsr = PCURSH->GetStkCrsr();
// Alle ueberfluessigen Crsr sind vom Stack, oder ??
//		ASSERT( !_pStkCrsr, "Es stehen noch Crsr auf dem CrsrStack" );
		if( _pStkCrsr )
		do {
			lcl_PaMCorrAbs( _pStkCrsr, aStart, aEnd, aNewPos );
		} while ( (_pStkCrsr != 0 ) &&
			((_pStkCrsr=(SwPaM *)_pStkCrsr->GetNext()) != PCURSH->GetStkCrsr()) );

		FOREACHPAM_START(PCURSH)
			lcl_PaMCorrAbs( PCURCRSR, aStart, aEnd, aNewPos );
		FOREACHPAM_END(PCURSH)

		if( PCURSH->IsTableMode() )
			lcl_PaMCorrAbs( PCURSH->GetTblCrs(), aStart, aEnd, aNewPos );

	FOREACHSHELL_END( pShell )
}


void SwEditShell::PaMCorrAbs( const SwPaM& rRange, const SwPosition& rNewPos )
{
	// alle Verzeichnisse/Bookmarks/.. verschieben.
	GetDoc()->CorrAbs( rRange, rNewPos );
	::PaMCorrAbs( this, rRange, rNewPos );
}



