/*************************************************************************
 *
 *  $RCSfile: patch.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#define ENABLE_BYTESTRING_STREAM_OPERATORS	1

#include <stdio.h>
#include <stdlib.h>

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#define _BUF_LEN 16000

/****************************************************************************/

BOOL _PatchLicense( const SiDirEntry& rDllToPatch, const ByteString& rCode )
{
	SiDirEntry aNew( rDllToPatch.GetPath() );
	aNew += ByteString("~new~");

	SvFileStream aOldStrm( rDllToPatch.GetFull(), STREAM_READ );
	SvFileStream aNewStrm( aNew.GetFull(), STREAM_WRITE | STREAM_TRUNC );

	if( !aOldStrm.IsOpen() || !aNewStrm.IsOpen() )
		return FALSE;

	char cBuf[_BUF_LEN];
	while( !aOldStrm.IsEof() )
	{
		memset( cBuf, 0, _BUF_LEN );
		ULONG nRead = aOldStrm.Read( cBuf, _BUF_LEN );

		for( USHORT i = 0; i < nRead; ++i )
			if( cBuf[i] == 'd' && (((ULONG)(i + 6)) <= nRead) )
				if( strncmp(&(cBuf[i]), "dNiK", 4) == 0 )
				{
					// cBuf[i+4] = rCode.GetChar(0);
					cBuf[i+5] = rCode.GetChar(1);
				}

		aNewStrm.Write( cBuf, nRead );
	}
	aOldStrm.Close();
	aNewStrm.Close();

	rDllToPatch.Kill();
	aNew.MoveTo(rDllToPatch);

	return TRUE;
}

/****************************************************************************/
#if defined( UNX ) || defined( MAC )
int main( int argc, char *argv[] )
#else
int _cdecl main( int argc, char *argv[] )
#endif
/****************************************************************************/
{
	printf( "\nStarOffice 5.0 Registration Patch\n" );
	SiDirEntry aSVTLibrary;

	if( argc == 2 )
		aSVTLibrary = ByteString( argv[1] );
	else
	{
		#ifdef WNT
		aSVTLibrary = ByteString("svt516mi.dll");
		#elif OS2
		aSVTLibrary = ByteString("svt516co.dll");
		#elif UNX
			#ifdef SOLARIS
				#ifdef SPARC
				aSVTLibrary = ByteString("libsvt516ss.so");
				#else
				aSVTLibrary = ByteString("libsvt516si.so");
				#endif
			#else
				aSVTLibrary = ByteString("libsvt516li.so");
			#endif
		#endif
	}

	if( !aSVTLibrary.Exists() )
	{
		printf( "error: %s, library cannot be found.\n", aSVTLibrary.GetFull().GetBuffer() );
		return 1;
	}

	SiDirEntry aSVTLibraryBackup( aSVTLibrary );
	aSVTLibraryBackup.SetExtension( "org" );

	FileCopier aCpy( aSVTLibrary, aSVTLibraryBackup );
	aCpy.Execute();
	printf( "backup %s saved.\n", aSVTLibraryBackup.GetFull().GetBuffer() );

	if( !_PatchLicense(aSVTLibrary, "?a") )
	{
		printf( "error: while patching library %s.\n", aSVTLibrary.GetFull().GetBuffer() );
		return 1;
	}

	printf( "%s, library successfully patched.\n", aSVTLibrary.GetFull().GetBuffer() );
	return 1;
}

