/*************************************************************************
 *
 *  $RCSfile: scppkg.cxx,v $
 *
 *  $Revision: 1.5.30.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:44:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif

#include <com/sun/star/setup/OSType.hpp>

#include "setup2/sistream.hxx"
#include "setup2/script.hxx"
#include "setup2/zipfile.hxx"
#include "setup2/hashtbl.hxx"
#include "setup2/sifsys.hxx"

#include "tools/geninfo.hxx"
#include "bootstrp/inimgr.hxx"
#include "tools/iparser.hxx"
#include "bootstrp/appdef.hxx"

#include "ziplst.hxx"
#include "protocol.hxx"
#include "searchcache.hxx"
#include "parameterhelper.hxx"

// ============================================================================

ParameterHelper::Association aGlobalAssociation;

IniManager*		pIniManager = NULL;
IniManager*		pZipIniManager = NULL;

ByteString		aDestinationPath;
ByteString		aProjectName;
ByteString 		aScriptFilename;
ByteString		aLanguages;
ByteString		aWorkStamp;
ByteString		aEnvironment;
ByteString		aMinor;

USHORT 			nDefLang			= 0;
Protocol*		pLog				= NULL;

#define 		PKGINFO_FILE		"pkginfo"
#define 		PROTOTYPE_FILE		"prototype"

// ============================================================================

void PrintPkgUsage()
{
	fprintf( stderr, "usage:\n" );
	fprintf( stderr, "\t-n <projectname>\n" );
	fprintf( stderr, "\t-d <destination path>\n" );
	fprintf( stderr, "\t-l <langcode,...> (first langcode is default language)\n" );
}

// ============================================================================


DECLARE_HASHTABLE( DoneList,ByteString,UINT32 );
DoneList aDoneList(1017);

DECLARE_LIST( DirSlot, SiDirectory* );
DECLARE_LIST( FileSlot, SiFile* );

class PackageBuilder
{
		DirSlot			m_aDirSlot;
		FileSlot		m_aFileSlot;

	void			Add4Languages( SiDeclarator* pDecl );
	void 			Add( SiDeclarator* pDecl );

public:
			PackageBuilder()  {}
			~PackageBuilder() {}

	void 			FillSlots( SiModule* pMod );
	void 			WritePkgInfo();
	void 			WritePrototype();

	void			ExecutePgkBuild();
};

// ============================================================================

void PackageBuilder::Add( SiDeclarator* pDecl )
{
	if( PTR_CAST(SiDirectory,pDecl) != NULL )
		m_aDirSlot.Insert( (SiDirectory*)pDecl, LIST_APPEND );

	if( PTR_CAST(SiFile,pDecl) != NULL )
		m_aFileSlot.Insert( (SiFile*)pDecl, LIST_APPEND );
}

void PackageBuilder::Add4Languages( SiDeclarator* pDecl )
{
	if( pDecl->HasLangRef() )
	{
		for( USHORT xx = 0; xx < aLanguageList.Count(); ++xx )
		{
			USHORT nLang = aLanguageList.GetObject(xx)->nId;
			SiDeclarator* pLangRef = (SiDeclarator*) pDecl->GetLangRef( nLang );
			if( pLangRef )
			{
				pLangRef->JoinWithParent();

				ByteString aDoneID( pLangRef->GetID() );
				aDoneID += ByteString::CreateFromInt32( nLang );
				if( aDoneList.Find(aDoneID) != 0 )
					continue;

				aDoneList.Insert( aDoneID, 1 );
				Add( pLangRef );
			}
		}
	}
	else
	{
		if( aDoneList.Find(pDecl->GetID()) == 0 )
		{
			aDoneList.Insert( pDecl->GetID(), 1 );
			Add( pDecl );
		}
	}
}

void PackageBuilder::FillSlots( SiModule* pMod )
{
	USHORT i;
	for( i = 0; i < pMod->GetDirList().Count(); ++i )
		Add4Languages( pMod->GetDirList().GetObject(i) );

	for( i = 0; i < pMod->GetFileList().Count(); ++i )
	{
		SiFile* pFile = pMod->GetFileList().GetObject(i);
		if( pFile->DeleteOnly() ) continue;
		Add4Languages( pFile );
	}

	const SiModuleList* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		FillSlots( pModuleList->GetObject(x) );
}

void PackageBuilder::WritePkgInfo()
{
	SiDirEntry aPkgInfoFile( aDestinationPath );
	aPkgInfoFile += ByteString( PKGINFO_FILE );

	FILE* pPkgInfoFile = fopen( aPkgInfoFile.GetFull().GetBuffer(), "w" );
	if( !pPkgInfoFile ) {
		fprintf( stderr, "error: an error occured while creating pkginfo file\n" );
		exit( -1 );
	}

	fprintf( pPkgInfoFile, "PKG=SUNWsipl\n" );
	fprintf( pPkgInfoFile, "NAME=StarOffice\n" );
	fprintf( pPkgInfoFile, "ARCH=sparc\n" );
	fprintf( pPkgInfoFile, "VERSION=release 1.0\n" );
	fprintf( pPkgInfoFile, "CATEGORY=system\n" );
	fprintf( pPkgInfoFile, "BASEDIR=/export/home/ok\n" );

	fclose( pPkgInfoFile );
}

void PackageBuilder::WritePrototype()
{
	SiDirEntry aPrototypeFile( aDestinationPath );
	aPrototypeFile += ByteString( PROTOTYPE_FILE );

	FILE* pPrototypeFile = fopen( aPrototypeFile.GetFull().GetBuffer(), "w" );
	if( !pPrototypeFile ) {
		fprintf( stderr, "error: an error occured while creating prototype file\n" );
		exit( -1 );
	}

	SiDirEntry temp = aPrototypeFile.GetPath();
	fprintf( pPrototypeFile, "i pkginfo=%s/%s\n",
			 temp.GetFull().GetBuffer(),
			 PKGINFO_FILE );

	USHORT i;
	for( i = 0; i < m_aDirSlot.Count(); ++i )
	{
		SiDirectory* pDir = m_aDirSlot.GetObject(i);
		if( pDir->IsSystem() ) continue;

		ByteString aDirname( pDir->GetName().GetBuffer() );
		aDirname.SearchAndReplaceAll( " ", "_" );

		fprintf( pPrototypeFile, "d none %s 0%d root sys\n",
				 aDirname.GetBuffer(),
				 pDir->GetUnixRights() );
	}

	for( i = 0; i < m_aFileSlot.Count(); ++i )
	{
		SiFile* pFile = m_aFileSlot.GetObject(i);
		if( pFile->GetDirectory()->IsSystem() ) continue;  // that is not the right way
														   // it must propagate via environent variables

		ByteString aSource( FindSourcefile(pFile, pFile->GetLanguage()) );

		if( !aSource.Len() )
		{
			fprintf( stderr, "error: %s not found, ignore it!\n", pFile->GetName().GetBuffer() );
			continue;
		}

		if( !pFile->IsArchive() )
		{
			fprintf( pPrototypeFile, "f none %s/%s=%s 0%d root sys\n",
				 	pFile->GetDirectory()->GetName().GetBuffer(),
				 	pFile->GetName().GetBuffer(),
				 	aSource.GetBuffer(),
				 	pFile->GetUnixRights() );

		}
		else
		{
			SiDirEntry aFoo( aDestinationPath );
			aFoo += SiDirEntry( "tmp_broken_archives" );
			SiDirEntry aTmp( aFoo.TempName() );
			aTmp.ToAbs();
			aTmp.MakeDir();
			aTmp.SetCWD();

			fprintf( stderr, "break archive: %s...\n", aSource.GetBuffer() );

			SiZipFile aZipFile;
			aZipFile.AddSubfileListTo( aSource, pFile, "*" );
			aZipFile.Unzip( aSource, "*" );

			for( USHORT x = 0; x < pFile->GetSubfileList().Count(); ++x )
			{
				fprintf( pPrototypeFile, "f none %s/%s=%s/%s 0%d root sys\n",
				 		pFile->GetDirectory()->GetName().GetBuffer(),
				 		pFile->GetSubfileList().GetObject(x)->aFilename.GetBuffer(),
				 		aTmp.GetFull().GetBuffer(),
						pFile->GetSubfileList().GetObject(x)->aFilename.GetBuffer(),
				 		pFile->GetUnixRights() );
			}
		}
	}

	fclose( pPrototypeFile );
}

void PackageBuilder::ExecutePgkBuild()
{
}

// ============================================================================

int __LOADONCALLAPI main( int argv, char** argc )
{
	fprintf( stderr, "\nScript Particel Package Builder (c) 2000 Sun Microsystems\n\n" );
	if( argv == 1 )
	{
		PrintPkgUsage();
		exit( -1 );
	}

	// === evaluate parameter & environment ===================================
	for( USHORT n = 1; n < argv; n++ )
	{
		if( argc[ n ][ 0 ] == '-' )
		{
			switch( argc[ n ][ 1 ] )
			{
	   			case 'n':	aProjectName = argc[ ++n ];
							break;

				case 'd':	aDestinationPath = argc[ ++n ];
							break;

				case 'l': {
							aLanguages = argc[ ++n ];
							USHORT nDelimTok = 0;
							USHORT nTokCount = aLanguages.GetTokenCount(PARA_DELIM);
							for( USHORT x = 0; x < nTokCount; ++x )
							{
								ByteString aLang = aLanguages.GetToken(0, PARA_DELIM, nDelimTok);
								LangId* pNew = new LangId;
								pNew->nId = (USHORT)aLang.ToInt32();
								aLanguageList.Insert( pNew, LIST_APPEND );
							}
						  } break;
			}
		}
	}

	if( !aProjectName.Len() )
	{
		fprintf( stderr, "error: no projectname defined\n" );
		PrintPkgUsage();
		exit( -1 );
	}

	if( !aDestinationPath.Len() ) {
		fprintf( stderr, "error: no destinationpath defined\n" );
		PrintPkgUsage();
		exit( -1 );
	}

	if( !aLanguageList.Count() )
	{
		LangId* pNew = new LangId;
		pNew->nId = 1;
		aLanguageList.Insert( pNew, LIST_APPEND );
	}

	aWorkStamp   	= ByteString( getenv("WORK_STAMP")?	getenv("WORK_STAMP")	: "" );
	aEnvironment	= ByteString( getenv("INPATH")? 	getenv("INPATH") 		: "" );
	aMinor	   		= ByteString( getenv("UPDMINOR")? 	getenv("UPDMINOR")		: "" );

	// === get iserver project configuration ==================================
	pIniManager = new IniManager;
	pIniManager->Update();

	ByteString sZipRoot( ZIPROOT );
	CONVERT_R_TO_HOSTFSYS( sZipRoot );
	pZipIniManager = new IniManager( sZipRoot );
	pZipIniManager->Update();

	ByteString aMsg( aWorkStamp );
	aMsg += ";";
	aMsg += aEnvironment;
	aMsg += ";";
	aMsg += aMinor;

	aMsg.ToLowerAscii();

	ByteString sDefLst( GetDefStandList() );
	ByteString sStandLst( pIniManager->ToLocal( sDefLst ));
	InformationParser aParser;
    UniString aTmpString( UniString::CreateFromAscii( sStandLst.GetBuffer()) );
    GenericInformationList* pGenList = aParser.Execute( aTmpString );

	MetaReplacement aM;
	if( !::GetMetaReplacement(&aM, aMsg, pGenList) )
	{
		fprintf( stderr, "fatal internal error: no meta replacement!\n" );
		exit( -1 );
	}

	ByteString sZipList = ZIPLIST;
	CONVERT_R_TO_HOSTFSYS( sZipList );
	sZipList = pZipIniManager->ToLocal( sZipList );
    UniString aTmpString2( UniString::CreateFromAscii( sZipList.GetBuffer()) );
    pGenList = aParser.Execute( aTmpString2 );
	Project* pPrj = new Project( NULL );
	BOOL bFnd = FALSE;

	for( USHORT i = 0; i < pGenList->Count(); ++i )
	{
		GenericInformation* pInf = pGenList->GetObject(i);
		if( aProjectName.CompareIgnoreCaseToAscii(*pInf) == COMPARE_EQUAL )
		{
			pPrj->Read( pGenList, pInf );
			bFnd = TRUE;
			break;
		}
	}

	if( !bFnd ) {
		fprintf( stderr, "error: project not found\n" );
		PrintPkgUsage();
		exit( -1 );
	}

	// get script filename
	UniString aPathExtension( UniString::CreateFromAscii("bin") );
	if( aM.aMetaMinor.Len() )
	{
		aPathExtension += UniString::CreateFromAscii( "." );
		aPathExtension += UniString::CreateFromAscii( aM.aMetaMinor.GetBuffer() );
	}
	SiDirEntry aScriptEntry( aM.aMetaSolarPath );
	aScriptEntry += aPathExtension;
	aScriptEntry += pPrj->m_aScript;
	aScriptEntry.SetExtension(UniString::CreateFromAscii("ins") );

	if( !aScriptEntry.Exists() ) {
		fprintf( stderr, "sourcescript '%s' not found\n", aScriptEntry.GetFull().GetBuffer() );
		exit( -1 );
	}
	aScriptFilename = aScriptEntry.GetFull();


	// === do main action =====================================================
	SiDirEntry aDestPath( aDestinationPath );
	if( !aDestPath.Exists() ) aDestPath.MakeDir();

	pLog = new Protocol( "PKG Protocol " );
	pLog->DoConsole();

	SiDirEntry aScriptFile( aScriptFilename );
	if( !aScriptFile.Exists() ) {
		ByteString aMsg( "error: source '");
		aMsg += aScriptFile.GetFull();
		aMsg += "' cannot be found.";
		pLog->Log( aMsg );
		delete pLog;
		exit( -1 );
	}
	else
	{
		ByteString aLog( "sourcescript: " );
		aLog += aScriptFile.GetFull();
		pLog->Log( aLog );
	}

	SiAnsiFileStream aStrm;
    aStrm.Open( aScriptFile.GetFullUni(), STREAM_READ );
	if( !aStrm.IsOpen() ) {
		ByteString aMsg( "error: script '");
		aMsg += aScriptFile.GetFull();
		aMsg += "' cannot be open.";
		pLog->Log( aMsg );
		delete pLog;
		exit( -1 );
	}

	ByteString aDefLangStr;
	ByteString aAllLangStr;
	for( USHORT q = 0; q < aLanguageList.Count(); ++q )
	{
		ByteString n( ByteString::CreateFromInt32(aLanguageList.GetObject(q)->nId) );
		if( aAllLangStr.Search(n) == STRING_NOTFOUND )
		{
			if( n.Len() == 1 )
				n.Insert( "0", 0 );
			if( !q )
			{
				aDefLangStr = n;
				nDefLang = aDefLangStr.ToInt32();
			}
			else
				aAllLangStr += ',';
			aAllLangStr += n;
		}
	}

	PreCacheIncludes( ::DoMetaReplacement(&aM, aLanguages, pPrj->m_aInclude) );

	SiCompiledScript*	pCS = new SiCompiledScript;
	SiCompilerRef		xCompiler = new SiCompiler( aStrm, com::sun::star::setup::OSType_UNIX_SOLS );

	xCompiler->NoApplication();
	xCompiler->SetDefDefaultLanguage( aDefLangStr );
	xCompiler->SetDefLanguages( aAllLangStr );

	if( !xCompiler->CompileTo( pCS ) ) {
		pLog->Log( "error: script error." );
		return -1;
	}
	aStrm.Close();

	fprintf( stderr, "process modules...\n" );

	PackageBuilder aPackageBuilder;
	aPackageBuilder.FillSlots( pCS->GetRootModule() );
	aPackageBuilder.WritePkgInfo();
	aPackageBuilder.WritePrototype();
	aPackageBuilder.ExecutePgkBuild();

	// === delete objects =====================================================
	fprintf( stderr, "\ndone\n\n" );

	delete pIniManager;
	delete pZipIniManager;
	delete pLog;

	return 0;
}

