/*************************************************************************
 *
 *  $RCSfile: undmovsize.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: iha $ $Date: 2002/11/11 19:37:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//svdraw.hxx
//#define _SVDRAW_HXX
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
//#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif

#include "schdll.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "undmovsize.hxx"
#include "objid.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "schgroup.hxx"
#include "chtscene.hxx"
#include "guiutil.hxx"

TYPEINIT1(SchUndoMoveOrResize, SchUndoAction);

//*************************************************************************
//*************************************************************************

SchUndoMoveOrResize::SchUndoMoveOrResize(ChartModel& rChDoc, UINT16 nObjId
		, const Rectangle& rOldRect, const Rectangle& rNewRect
		, const Matrix4D& rOldMatrix, const Matrix4D& rNewMatrix )
		: SchUndoAction(rChDoc), m_nObjId(nObjId)
		, m_aOldRect(rOldRect), m_aNewRect(rNewRect)
		, m_aOldSceneMatrix(rOldMatrix), m_aNewSceneMatrix(rNewMatrix)
{
	SetCommentTemplate(STR_UNDO_TRANSFORM);
}

//*************************************************************************
//*************************************************************************

SchUndoMoveOrResize::SchUndoMoveOrResize(ChartModel& rChDoc, UINT16 nObjId
					, const Rectangle& rOldRect, const Rectangle& rNewRect )
			: SchUndoAction(rChDoc), m_nObjId(nObjId)
			, m_aOldRect(rOldRect), m_aNewRect(rNewRect)
			
{
	SetCommentTemplate(STR_UNDO_TRANSFORM);
}

//*************************************************************************
//*************************************************************************

void SchUndoMoveOrResize::Undo()
{
	DoIt( m_aOldRect, m_aOldSceneMatrix );
}

//*************************************************************************
//*************************************************************************

void SchUndoMoveOrResize::Redo()
{
	DoIt( m_aNewRect, m_aNewSceneMatrix );
}

//************************************************************************/
//************************************************************************/

void SchUndoMoveOrResize::DoIt(const Rectangle& rRect, const Matrix4D& rMatrix)
{
	switch(m_nObjId)
	{
		case CHOBJID_DIAGRAM:
			ModifyDiagram(rRect,rMatrix);
			break;
		case CHOBJID_LEGEND:
		case CHOBJID_TITLE_MAIN:
		case CHOBJID_TITLE_SUB:
		case CHOBJID_DIAGRAM_TITLE_X_AXIS:
		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
			MoveSdrObject( rRect.TopLeft() );
			break;
	}
}

//************************************************************************/
//************************************************************************/

void SchUndoMoveOrResize::MoveSdrObject(const Point& rNewPos)
{
	SdrObject *pObj = GetObject(m_nObjId);
	if( !pObj )
		return;

	rDoc.SetUseRelativePositions(TRUE);
	if( pObj->ISA( SchObjGroup ) )
	{
		SchObjGroup* pGrp = static_cast< SchObjGroup* >( pObj );
		pGrp->SetGroupMoved( TRUE );
	}

    Point aCurrent( pObj->GetBoundRect().TopLeft() );
	Size aDist( rNewPos.X() - aCurrent.X()
		, rNewPos.Y() - aCurrent.Y() );
	pObj->Move( aDist );
	rDoc.SetHasBeenMoved(m_nObjId,TRUE);
}

//************************************************************************/
//************************************************************************/

void SchUndoMoveOrResize::ModifyDiagram(
						const Rectangle& rRect, const Matrix4D& rMatrix)
{
	SdrObject *pObj = GetObject(CHOBJID_DIAGRAM);
	if( !pObj )
		return;

	if( pObj->ISA( SchObjGroup ) )
	{
        rDoc.SetUseRelativePositions( TRUE );
        rDoc.SetDiagramHasBeenMovedOrResized( TRUE );
        Rectangle aNewChartRect(rRect);
        rDoc.SetChartRect(aNewChartRect);
        rDoc.SetDiagramRectangle(aNewChartRect);
		rDoc.BuildChart(FALSE);
	}
	else if( pObj->ISA(ChartScene) )
	{
        rDoc.SetUseRelativePositions(TRUE);
		BOOL bRotate = m_aOldSceneMatrix!=m_aNewSceneMatrix;

		if(bRotate)
		{
			((ChartScene*)pObj)->SetTransform(rMatrix);
			((ChartScene*)pObj)->CorrectSceneDimensions();

			pObj->SetSnapRect( rRect );
			((ChartScene *)pObj)->SetAskForLogicRect(FALSE);
            Rectangle aNewChartRect(rRect);
            rDoc.SetChartRect(aNewChartRect);
			rDoc.SetDiagramRectangle(aNewChartRect);
			rDoc.SetDiagramHasBeenMovedOrResized( TRUE );

			BOOL& rbScalable = rDoc.TextScalability();
			BOOL bOriginalTextScalability = rbScalable;
			rbScalable = FALSE;
			rDoc.BuildChart(FALSE);
			rbScalable = bOriginalTextScalability;
		}
		else
		{
			pObj->SetSnapRect( rRect );
			((ChartScene *)pObj)->SetAskForLogicRect(FALSE);
            Rectangle aNewChartRect(rRect);
            rDoc.SetChartRect(aNewChartRect);
			rDoc.SetDiagramRectangle(aNewChartRect);
			rDoc.SetDiagramHasBeenMovedOrResized( TRUE );
			rDoc.BuildChart(FALSE);
		}
	}
}

//************************************************************************/
//************************************************************************/

void SchUndoMoveOrResize::GetGeoAttribFromItemSet(const SfxItemSet& rAttr
		, Rectangle& rPosAndSize, Rectangle& rRotation )
{
	rPosAndSize = Rectangle(0,0,0,0);
	rRotation = Rectangle(0,0,0,0);
	
	long nPosDX(0);
	long nPosDY(0);
	long nSizX(0);
	long nSizY(0);
	long nRotateAngle(0);
	long nRotateX(0);
	long nRotateY(0);
	
	const SfxPoolItem* pPoolItem=NULL;
	// read position from rAttr
	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_POS_X,TRUE,&pPoolItem))
		nPosDX=((const SfxInt32Item*)pPoolItem)->GetValue();
	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_POS_Y,TRUE,&pPoolItem))
		nPosDY=((const SfxInt32Item*)pPoolItem)->GetValue();
	// read size from rAttr
	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_WIDTH,TRUE,&pPoolItem))
		nSizX=((const SfxUInt32Item*)pPoolItem)->GetValue();
	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_HEIGHT,TRUE,&pPoolItem))
		nSizY=((const SfxUInt32Item*)pPoolItem)->GetValue();
	// read rotation from rAttr
	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_ANGLE,TRUE,&pPoolItem))
		nRotateAngle=((const SfxInt32Item*)pPoolItem)->GetValue();
	if(SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_ROT_X, TRUE ,&pPoolItem)) 
		nRotateX = ((const SfxInt32Item&)rAttr.Get(SID_ATTR_TRANSFORM_ROT_X)).GetValue();
	if(SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_ROT_Y, TRUE ,&pPoolItem)) 
		nRotateY = ((const SfxInt32Item&)rAttr.Get(SID_ATTR_TRANSFORM_ROT_Y)).GetValue();

	rPosAndSize = Rectangle(Point(nPosDX,nPosDY),Size(nSizX,nSizY));
	rRotation = Rectangle(nRotateAngle,nRotateX,nRotateY,1);
}

//*************************************************************************
//*************************************************************************

void SchUndoMoveOrResize::SetCommentTemplate(USHORT nResId)
{
	SchResId aNameResId(GuiUtilities::GetObjectNameResId(m_nObjId,rDoc));
	String sObjectName(aNameResId);
	SchResId aTemplateResId(nResId);
	String sUndoMsg(aTemplateResId);

	sUndoMsg.SearchAndReplaceAll( String(RTL_CONSTASCII_USTRINGPARAM("%O")), sObjectName );
	SetComment(sUndoMsg);
}

//************************************************************************/
//************************************************************************/

SdrObject* SchUndoMoveOrResize::GetObject(UINT16 nObjId)
{
	SdrPage *pPage = rDoc.GetPage(0);
	if( pPage )
		return GetObjWithId( nObjId, *pPage );
	return NULL;
}

//************************************************************************/
//************************************************************************/

BOOL SchUndoMoveOrResize::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}