/*************************************************************************
 *
 *  $RCSfile: objfac.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 00:29:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#include "axisid.hxx"
#include "schgroup.hxx"
#include "objfac.hxx"
#include "objid.hxx"
#include "objadj.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "lightfac.hxx"
#include "glob.hxx"


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjFactory::SchObjFactory() :
	bInserted(FALSE)
{
}

/*************************************************************************
|*
|* Chart-interne Objekte erzeugen
|*
\************************************************************************/

IMPL_LINK( SchObjFactory, MakeObject, SdrObjFactory*, pObjFactory)
{
	if (pObjFactory->nInventor == SchInventor &&
		pObjFactory->nIdentifier == SCH_OBJGROUP_ID)
		pObjFactory->pNewObj = new SchObjGroup;

	return 0;
}

/*************************************************************************
|*
|* Chart-Userdata erzeugen
|*
\************************************************************************/

IMPL_LINK( SchObjFactory, MakeUserData, SdrObjFactory* ,pObjFactory)
{
	if (pObjFactory->nInventor == SchInventor)
		switch (pObjFactory->nIdentifier)
		{
			case SCH_OBJECTID_ID:
				pObjFactory->pNewData = new SchObjectId;
				break;

			case SCH_OBJECTADJUST_ID:
				pObjFactory->pNewData = new SchObjectAdjust;
				break;

			case SCH_DATAROW_ID:
				pObjFactory->pNewData = new SchDataRow;
				break;

			case SCH_DATAPOINT_ID:
				pObjFactory->pNewData = new SchDataPoint;
				break;

			case SCH_LIGHTFACTOR_ID:
				pObjFactory->pNewData = new SchLightFactor;
				DBG_ERROR("SCH_LIGHTFACTOR_ID no longer available");
				break;

			case SCH_AXIS_ID :
				pObjFactory->pNewData = new SchAxisId;
				break;
		}

		return 0;
}



