/*************************************************************************
 *
 *  $RCSfile: rmtpclst.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kso $ $Date: 2000/10/16 14:54:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTPCLST_HXX_
#define _UCPRMT_RMTPCLST_HXX_

#include <list>

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_ 
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_ 
#include <com/sun/star/uno/Sequence.hxx>
#endif

namespace com { namespace sun { namespace star {
	namespace beans {
		struct PropertyChangeEvent;
		class XPropertiesChangeListener;
	}
	namespace lang { struct EventObject; }
} } }
namespace rtl { class OUString; }

//============================================================================
namespace ucprmt {

class PropertiesChangeListener
{
public:
	enum Kind
	{
		ALL_PROPS,
		SOME_PROPS,
		ALL_BUT_SOME_PROPS
	};

	inline
	PropertiesChangeListener(
		com::sun::star::uno::Reference<
		        com::sun::star::beans::XPropertiesChangeListener > const &
		    rTheListener,
		Kind eTheKind,
		com::sun::star::uno::Sequence< rtl::OUString > const &
		    rTheProperties);

	inline
	com::sun::star::uno::Reference<
	    com::sun::star::beans::XPropertiesChangeListener > const &
	getListener() const
	{ return m_xListener; }

	inline Kind getKind() const { return m_eKind; }

	inline void setKind(Kind eTheKind,
						com::sun::star::uno::Sequence< rtl::OUString > const &
						    rTheProperties);

	void addProperties(com::sun::star::uno::Sequence< rtl::OUString > const &
					       rTheProperties);

	bool removeProperties(
		     com::sun::star::uno::Sequence< rtl::OUString > const &
			     rTheProperties);

	bool
	intersectsWith(
		com::sun::star::uno::Sequence<
		        com::sun::star::beans::PropertyChangeEvent > const &
		    rEvt) const;

	bool
	subsetOf(
		com::sun::star::uno::Sequence<
		        com::sun::star::beans::PropertyChangeEvent > const &
		    rEvt) const;

private:
	com::sun::star::uno::Reference<
	        com::sun::star::beans::XPropertiesChangeListener >
	    m_xListener;
	com::sun::star::uno::Sequence< rtl::OUString > m_aProperties;
	Kind m_eKind;
};

inline
PropertiesChangeListener::PropertiesChangeListener(
	com::sun::star::uno::Reference<
	        com::sun::star::beans::XPropertiesChangeListener > const &
	    rTheListener,
	Kind eTheKind,
	com::sun::star::uno::Sequence< rtl::OUString > const & rTheProperties):
	m_xListener(rTheListener),
	m_eKind(eTheKind),
	m_aProperties(rTheProperties)
{}

inline void PropertiesChangeListener::setKind(
	            Kind eTheKind,
				com::sun::star::uno::Sequence< rtl::OUString > const &
				    rTheProperties)
{
	m_eKind = eTheKind;
	m_aProperties = rTheProperties;
}

inline bool
operator ==(
	PropertiesChangeListener const & rListener1,
	com::sun::star::uno::Reference<
	        com::sun::star::beans::XPropertiesChangeListener > const &
	    rListener2)
{
	return (rListener1.getListener() == rListener2) != false;
}

//============================================================================
class PropertiesChangeListeners: public std::list< PropertiesChangeListener >
{
public:
	void dispose(com::sun::star::lang::EventObject const & rSource);
};

}

#endif // _UCPRMT_RMTPCLST_HXX_

