/*************************************************************************
 *
 *  $RCSfile: objsys.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 19:24:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef WNT

#define UINT64 USE_WIN_UINT64
#define INT64 USE_WIN_INT64
#define UINT32 USE_WIN_UINT32
#define INT32 USE_WIN_INT32

#include <tools/presys.h>
#include <windows.h>
#include <tools/postsys.h>

#undef UINT64
#undef INT64
#undef UINT32
#undef INT32

#endif

#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_XTRANSFERABLE_HPP_
#include <com/sun/star/datatransfer/XTransferable.hpp>
#endif

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif
#ifndef _SV_GDIMTF_HXX
#include <vcl/gdimtf.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif
#ifndef _SV_CVTGRF_HXX
#include <vcl/cvtgrf.hxx>
#endif
#ifndef _SV_OUTDEV_HXX
#include <vcl/outdev.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _UNOTOOLS_TEMPFILE_HXX
#include <unotools/tempfile.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif

using namespace ::com::sun::star;

SvMemoryStream* getMetaMemStrFromGDI_Impl( const GDIMetaFile* pGDIMeta, sal_uInt32 nFormat )
{
	SvMemoryStream* pResult = NULL;
	if ( pGDIMeta )
	{
		SvMemoryStream* pStream = new SvMemoryStream( 65535, 65535 );
		if ( pStream )
		{
			Graphic aGraph( *pGDIMeta );
			if ( GraphicConverter::Export( *pStream, aGraph, nFormat ) == 0 )
				pResult = pStream;
			else
				delete pStream;
		}
	}

	return pResult;
}

void* getEnhMetaFileFromGDI_Impl( const GDIMetaFile* pGDIMeta )
{
	void* pResult = NULL;

#ifdef WNT
	if ( pGDIMeta )
	{
		String aStr = ::rtl::OUString::createFromAscii( ".emf" );
		::utl::TempFile aTempFile( ::rtl::OUString(),
								   &aStr,
								   NULL,
								   sal_False );

		::rtl::OUString aMetaFile = aTempFile.GetFileName();
		::rtl::OUString aMetaURL = aTempFile.GetURL();
		::rtl::OString aWinFile = ::rtl::OUStringToOString( aMetaFile, osl_getThreadTextEncoding() );

		SvStream* pStream = ::utl::UcbStreamHelper::CreateStream( aMetaURL, STREAM_STD_READWRITE );
		if ( pStream )
		{
			Graphic aGraph( *pGDIMeta );
			sal_Bool bFailed = (sal_Bool)GraphicConverter::Export( *pStream, aGraph, CVT_EMF );
			pStream->Flush();
			delete pStream;
			
			if ( !bFailed )
				pResult = GetEnhMetaFileA( aWinFile.getStr() );
		}
	}
#endif

	return pResult;
}

void* getWinMetaFileFromGDI_Impl( const GDIMetaFile* pGDIMeta, const Size& aMetaSize )
{
	void* pResult = NULL;

#ifdef WNT
	if ( pGDIMeta )
	{
		SvMemoryStream* pStream = new SvMemoryStream( 65535, 65535 );
		if ( pStream )
		{
			Graphic aGraph( *pGDIMeta );
			sal_Bool bFailed = (sal_Bool)GraphicConverter::Export( *pStream, aGraph, CVT_WMF );
			pStream->Flush();
			if ( !bFailed )
			{
				sal_Int32 nLength = pStream->Seek( STREAM_SEEK_TO_END );
				if ( nLength > 22 )
				{
					HMETAFILE hMeta = SetMetaFileBitsEx( nLength - 22, 
									( reinterpret_cast< const sal_uChar*>( pStream->GetData() ) ) + 22 );

					if ( hMeta )
					{
						HGLOBAL hMemory = GlobalAlloc( GMEM_DDESHARE | GMEM_MOVEABLE, sizeof( METAFILEPICT ) );
				
						if ( hMemory )
						{
   							METAFILEPICT* pMF = (METAFILEPICT*)GlobalLock( hMemory );

   							pMF->hMF = hMeta;
   							pMF->mm = MM_ANISOTROPIC;

							MapMode aMetaMode = pGDIMeta->GetPrefMapMode();
							MapMode aWinMode( MAP_100TH_MM );

							if ( aWinMode == pGDIMeta->GetPrefMapMode() )
							{
								pMF->xExt = aMetaSize.Width();
								pMF->yExt = aMetaSize.Height();
							}
							else
							{
								Size aWinSize = OutputDevice::LogicToLogic( Size( aMetaSize.Width(), aMetaSize.Height() ), 
																			aWinMode, 
																			pGDIMeta->GetPrefMapMode() );
								pMF->xExt = aWinSize.Width();
								pMF->yExt = aWinSize.Height();
							}

							GlobalUnlock( hMemory );
							pResult = (void*)hMemory;
						}
						else
   							DeleteMetaFile( hMeta );
					}
				}
			}

			delete pStream;
		}
	}

#endif


	return pResult;
}

sal_Bool supportsMetaFileHandle_Impl()
{
#ifdef WNT
	return sal_True;
#else
	return sal_False;
#endif
}

