/*************************************************************************
 *
 *  $RCSfile: preins.cxx,v $
 *
 *  $Revision: 1.24.60.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:53:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <tools/rcid.h>

#include "script.hxx"
#include "main.hxx"
#include "maindlg.hxx"
#include "environ.hxx"
#include "sihelp.hxx"

#include "preins.hxx"
#include "preins.hrc"

#define PROP_CHANGE			1
#define PROP_UNINSTALL		2
#define PROP_RECOVER		3

PageReInstallation::PageReInstallation( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aRBChange		( this, ResId(RB_CHANGE, rResId.GetResMgr()) ),
	aRBRecover		( this, ResId(RB_RECOVER, rResId.GetResMgr()) ),
	aRBUninstall		( this, ResId(RB_UNINSTALL, rResId.GetResMgr()) ),
	aFTChange		( this, ResId(FT_CHANGE, rResId.GetResMgr()) ),
	aFTRecover		( this, ResId(FT_RECOVER, rResId.GetResMgr()) ),
	aFTUninstall		( this, ResId(FT_UNINSTALL, rResId.GetResMgr()) ),
    aStrPatchRepair ( ResId( STR_PATCH_REPAIR, rResId.GetResMgr() ) ),
    aStrPatchModify ( ResId( STR_PATCH_MODIFY, rResId.GetResMgr() ) ),
	m_aOfficeRunning(this, rResId)
{
    String aPatchNameVar( UniString::CreateFromAscii( "%PRODUCTPATCHNAME" ) );
    String aPatchName = pParent->GetSetupApp()->GetProductPatchName();

    aStrPatchRepair.SearchAndReplaceAll( aPatchNameVar, aPatchName );
    aStrPatchModify.SearchAndReplaceAll( aPatchNameVar, aPatchName );
	
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	// aStrQuitAppWin.SearchAndReplaceAll( UniString::CreateFromAscii("%1"),
	//		UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	// aStrQuitApp.SearchAndReplaceAll( UniString::CreateFromAscii("%1"),
	//		UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	pParent->SetTitleStr( aText );
	FreeResource();

	String aProductName(UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()));
	aText = aFTInfo1.GetText();
	aText.SearchAndReplaceAll( UniString::CreateFromAscii("%1"), aProductName);
	aFTInfo1.SetText(aText);

	Font aBold( aFTInfo2.GetFont() );
	aBold.SetWeight(WEIGHT_BOLD);

	aFTInfo2.SetFont(aBold);
	// aFTInfo2.SetText( UniString::CreateFromAscii(GETDLG()->GetEnv()->GetInstalledPath().GetBuffer()) );
	// #91499#
	aFTInfo2.SetText( UniString(GETDLG()->GetEnv()->GetInstalledPath(), osl_getThreadTextEncoding() ) );

	// #92465# new texts
	String aFTChangeText = aFTChange.GetText();
	aFTChangeText.SearchAndReplace( UniString::CreateFromAscii("%1"), aProductName);
	aFTChange.SetText(aFTChangeText);

	String aFTRecoverText = aFTRecover.GetText();
	aFTRecoverText.SearchAndReplace( UniString::CreateFromAscii("%1"), aProductName);
	aFTRecover.SetText(aFTRecoverText);

	String aFTUninstallText = aFTUninstall.GetText();
	aFTUninstallText.SearchAndReplace( UniString::CreateFromAscii("%1"), aProductName);
	aFTUninstall.SetText(aFTUninstallText);

	aRBChange.SetFont(aBold);
	aRBUninstall.SetFont(aBold);
	aRBRecover.SetFont(aBold);

#ifdef WNT
    ByteString nOS = WinOS::GetOSVersion();
    if( GETDLG()->GetEnv()->IsForceDeinstall() && WinOS::IsNT() &&
        ( nOS != "NT35" ) && ( nOS != "NT4" ) )
#else
    if( GETDLG()->GetEnv()->IsForceDeinstall() )
#endif
	{
		aRBRecover.Enable( FALSE );
		aFTRecover.Enable( FALSE );
		aRBChange.Enable( FALSE );
		aFTChange.Enable( FALSE );

		aRBUninstall.Check( TRUE );
	}
	else if( GETDLG()->GetEnv()->IsForceReinstall() )
	{
		aFTUninstall.Enable( FALSE );
		aRBUninstall.Enable( FALSE );

        // for a workstation installation we have to disable modify, too
        if( !GETDLG()->GetCScript()->GetRootModule()->HasUISubModules() ||
             GETDLG()->GetEnv()->GetInstallMode() == IM_WORKSTATION )
        {
            aRBRecover.Check( TRUE );

            aRBChange.Enable( FALSE );
            aFTChange.Enable( FALSE );
        }
        else
            aRBChange.Check( TRUE );
	}
	else if( !GETDLG()->GetCScript()->GetRootModule()->HasUISubModules() ||
			 GETDLG()->GetEnv()->GetInstallMode() == IM_WORKSTATION )
	{
		aRBUninstall.Check( TRUE );

		aRBChange.Enable( FALSE );
		aFTChange.Enable( FALSE );
	}
	else
		aRBChange.Check( TRUE );

	if( GETDLG()->GetEnv()->HasKHPatched() )
	{
		aRBUninstall.Check( TRUE );

		aRBChange.Enable( FALSE );
		aFTChange.Enable( FALSE );
		aRBRecover.Enable( FALSE );
		aFTRecover.Enable( FALSE );
	}
	// #88505# try to stop QuickStarter
	SiHelp::KillQuickStarter(GETDLG()->GetEnv(), GETDLG()->GetCScript());}

PageReInstallation::~PageReInstallation()
{
}

SvAgentPage* PageReInstallation::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageReInstallation( pParent, rResId );
}

// -----------------------------------------------------------------------------

BOOL OfficeRunning::isRunning( SiEnvironment* _pEnv,
                               const String& rProdName )
{
	if( SiHelp::IsOfficeRunning( _pEnv->GetInstalledPath(), _pEnv->IsLocal() ) ||
        SiHelp::IsOfficeRunning( _pEnv->GetDestPath(), _pEnv->IsLocal() ) )
	{
		String aStrQuitAppWin(m_aStrQuitAppWin);
		String aStrQuitApp(m_aStrQuitApp);
		String sPercent(UniString::CreateFromAscii("%1"));

		aStrQuitAppWin.SearchAndReplaceAll( sPercent, rProdName );
		aStrQuitApp.SearchAndReplaceAll( sPercent, rProdName );
#ifdef WNT
			ErrorBox( m_pParentWindow, WB_OK, aStrQuitAppWin ).Execute();
#else
			ErrorBox( m_pParentWindow, WB_OK, aStrQuitApp ).Execute();
#endif
		return TRUE;
	}
	return FALSE;
}

// -----------------------------------------------------------------------------

BOOL OfficeRunning::isRunning( SiEnvironment* _pEnv )
{
	return isRunning( _pEnv, UniString::CreateFromAscii(_pEnv->GetProductName().GetBuffer()) );
}

// -----------------------------------------------------------------------------
BOOL PageReInstallation::AllowNext()
{
    if ( GETDLG()->GetCScript()->GetInstallation()->IsPatched() )
    {
        if( aRBRecover.IsChecked() )
            InfoBox( this, aStrPatchRepair ).Execute();
        else if ( aRBChange.IsChecked() )
            InfoBox( this, aStrPatchModify ).Execute();
    }

    return !m_aOfficeRunning.isRunning(GETDLG()->GetEnv());
}


USHORT PageReInstallation::GetReturnVal()
{
	if(	aRBChange.IsChecked() )
		return RETURN_CHANGE;
	else if( aRBUninstall.IsChecked() )
		return RETURN_UNINSTALL;
	else if( aRBRecover.IsChecked() )
		return RETURN_RECOVER;
	return RETURN_CHANGE;
}

ULONG PageReInstallation::GetProperty()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();

	if(	aRBChange.IsChecked() )
	{
		pEnv->SetInstallType( IT_CHANGE );
		return PROP_CHANGE;
	}
	else if( aRBUninstall.IsChecked() )
	{
		pEnv->SetInstallType( IT_UNINSTALL );
		return PROP_UNINSTALL;
	}
	else if( aRBRecover.IsChecked() )
	{
		pEnv->SetInstallType( IT_RECOVER );
		return PROP_RECOVER;
	}

	pEnv->SetInstallType( IT_CHANGE );
	return PROP_NOTSET;
}

void PageReInstallation::InitProperty( ULONG nProp )
{
	if( nProp == PROP_NOTSET )
		return ;

	if( nProp == PROP_CHANGE )
		aRBChange.Check(TRUE);
	else if( nProp == PROP_UNINSTALL )
		aRBUninstall.Check();
	else if( nProp == PROP_RECOVER )
		aRBRecover.Check();
}

