/*************************************************************************
 *
 *  $RCSfile: CommandLineToArgv.c,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: tra $ $Date: 2001/06/15 10:17:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>
//#include <CommandLineToArgv.h>

#define DLL_EXPORT extern


DLL_EXPORT LPWSTR * WINAPI CommandLineToArgvW_9x (
  LPCWSTR lpCmdLine,  // pointer to a command-line string
  int *pNumArgs       // receives the argument count
)
{
	LPWSTR * ArgvW;
	DWORD dwLen, dwPos;
	DWORD dwTokenLen, dwNumTokens;
	BOOL  fInToken;

	if (*lpCmdLine == L'\0')
	{
		CHAR  FileName[MAX_PATH];

		if (dwLen = GetModuleFileNameA(NULL, FileName, MAX_PATH))
		{
			int n = MultiByteToWideChar(CP_ACP, 0, FileName, -1, NULL, 0);
			ArgvW = (LPWSTR *) GlobalAlloc(0, n * sizeof(WCHAR) + sizeof(LPWSTR));

			if (ArgvW)
			{
				ArgvW[0] = (LPWSTR) (ArgvW + 1);
				if (MultiByteToWideChar(CP_ACP, 0, FileName, -1, ArgvW[0], n) > 0)
				{
					*pNumArgs = 1;
					return ArgvW;
				}

				// cleanup on error
				GlobalFree(ArgvW);
			}
			else
				SetLastError(ERROR_OUTOFMEMORY);
		}

		return NULL;
	}

	// calculate memory size needed
	dwTokenLen = dwNumTokens = dwLen = 0;
	fInToken = FALSE;

	for (dwPos = 0; lpCmdLine[dwPos] != L'\0'; dwPos++)
	{
		switch (lpCmdLine[dwPos])
		{
			case L'\t':
			case L' ':
				if (fInToken)
				{
					if(dwTokenLen++ == 0)
						dwNumTokens++;
				}
				else if (dwTokenLen)
				{
					dwLen += dwTokenLen + 1;
					dwTokenLen = 0;
				}

				break;

			case L'"':
				fInToken = !fInToken;
				break;

			default:
				if (dwTokenLen++ == 0)
					dwNumTokens++;
				break;
		}
	}

	// append last token length + 
	// space for the trainling '\0'	
    // fix for #87973 the space for
    // the trailing '\0' was initialy
    // not added
	dwLen += dwTokenLen + 1;
	
	// remeber we do return an array of string pointer LPWSTR argv[]
	// the entries of this array are pointer to strings, that's why
	// ... + dwNumTokens * sizeof( LPWSTR )
	ArgvW = (LPWSTR *) GlobalAlloc(0, dwLen * sizeof(WCHAR) + dwNumTokens * sizeof(LPWSTR));

	if (ArgvW)
	{
		DWORD dwTokenNo = 0;
		LPWSTR cToken;

		dwTokenLen = 0;
		fInToken = FALSE;

		cToken = (LPWSTR) (ArgvW + dwNumTokens);
		ArgvW[0] = cToken;

		// copy data to separate strings
		for (dwPos = 0; lpCmdLine[dwPos] != L'\0'; dwPos++)
		{
			switch (lpCmdLine[dwPos])
			{
				case L'\t':
				case L' ':
					if (fInToken)
					{
						cToken[dwTokenLen++] = lpCmdLine[dwPos];
					}
					else if (dwTokenLen)
					{
						cToken[dwTokenLen++] = L'\0';
						if (dwTokenNo + 1 < dwNumTokens)
						{
							cToken += dwTokenLen;
							ArgvW[++dwTokenNo] = cToken;
						}
						dwLen -= dwTokenLen;
						dwTokenLen = 0;
					}
	
					break;
	
				case L'"':
					fInToken = !fInToken;
					break;
	
				default:
					cToken[dwTokenLen++] = lpCmdLine[dwPos];
					break;
			}
		}

		cToken[dwTokenLen] = L'\0';
		*pNumArgs = dwNumTokens;
		return ArgvW;
	}
	else
		SetLastError(ERROR_OUTOFMEMORY);

	return NULL;
}



