/*************************************************************************
 *
 *  $RCSfile: OutputThread.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 14:13:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Martin Gallwey (gallwey@sun.com)
 *
 *
 ************************************************************************/
#ifndef _OUTPUT_THREAD_HXX
#include <OutputThread.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HDL_
#include <com/sun/star/uno/RuntimeException.hdl>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _ZIP_PACKAGE_HXX
#include <ZipPackage.hxx>
#endif
#ifndef _ZIP_PACKAGE_FOLDER_HXX
#include <ZipPackageFolder.hxx>
#endif
#ifndef _ZIP_PACKAGE_BUFFER_HXX
#include <ZipPackageBuffer.hxx>
#endif
#ifndef _ZIP_OUTPUT_STREAM_HXX
#include <ZipOutputStream.hxx>
#endif
#ifndef _COM_SUN_STAR_PACKAGES_MANIFEST_XMANIFESTWRITER_HPP_
#include <com/sun/star/packages/manifest/XManifestWriter.hpp>
#endif
#ifndef _COM_SUN_STAR_PACKAGES_ZIP_ZIPENTRY_HPP_
#include <com/sun/star/packages/zip/ZipEntry.hpp>
#endif
#ifndef _COM_SUN_STAR_PACKAGES_ZIP_ZIPCONSTANTS_HPP_
#include <com/sun/star/packages/zip/ZipConstants.hpp>
#endif
#ifndef _ENCRYPTION_DATA_HXX_
#include <EncryptionData.hxx>
#endif
#include <vector>
#ifndef _THREADED_BUFFER_HXX
#include <ThreadedBuffer.hxx>
#endif
#ifndef _PACKAGE_CONSTANTS_HXX_
#include <PackageConstants.hxx>
#endif
#ifndef _RTL_RANDOM_H_
#include <rtl/random.h>
#endif

using namespace ::osl;
using namespace ::std;
using namespace ::rtl;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::packages;
using namespace ::com::sun::star::packages::zip;
using namespace ::com::sun::star::packages::manifest;
using namespace ::com::sun::star::packages::zip::ZipConstants;

OutputThread::OutputThread ( ZipPackage & rNewZipPackage )
: rZipPackage ( rNewZipPackage )
, bFinished ( sal_False )
{
}
OutputThread::~OutputThread ( )
{
}
void SAL_CALL OutputThread::run()
{
	// very first thing we do is make sure we haven't been terminated...
	vector < Sequence < PropertyValue > > aManList;

	// Make a reference to the manifest output stream so it persists
	// until the call to ZipOutputStream->finish()
	Reference < XOutputStream > xManOutStream;
	const OUString sMediaType ( RTL_CONSTASCII_USTRINGPARAM ( "MediaType" ) );
	const OUString sFullPath ( RTL_CONSTASCII_USTRINGPARAM ( "FullPath" ) );

	Sequence < PropertyValue > aPropSeq ( 2 );
	aPropSeq [0].Name = sMediaType;
	aPropSeq [0].Value <<= rZipPackage.pRootFolder->GetMediaType( );
	aPropSeq [1].Name = sFullPath;
	aPropSeq [1].Value <<= OUString ( RTL_CONSTASCII_USTRINGPARAM ( "/" ) );

	aManList.push_back( aPropSeq );

	// Get a random number generator and seed it with current timestamp
	TimeValue aTime;
	osl_getSystemTime( &aTime );
	rtlRandomPool aRandomPool = rtl_random_createPool ();
	rtl_random_addBytes ( aRandomPool, &aTime, 8 ); 

	// note: saveContents is called recursively
	rZipPackage.pRootFolder->saveContents(OUString(), aManList, *pZipOutputStream, rZipPackage.aEncryptionKey, aRandomPool );
	rtl_random_destroyPool ( aRandomPool );

	OUString sManifestWriter( RTL_CONSTASCII_USTRINGPARAM ( "com.sun.star.packages.manifest.ManifestWriter" ) );
	Reference < XManifestWriter > xWriter (rZipPackage.xFactory->createInstance( sManifestWriter ), UNO_QUERY );
	if ( xWriter.is() )
	{
		ZipEntry * pEntry = new ZipEntry;
		ZipPackageBuffer *pBuffer = new ZipPackageBuffer( n_ConstBufferSize );
		xManOutStream = Reference < XOutputStream > (*pBuffer, UNO_QUERY);

		pEntry->sName = OUString( RTL_CONSTASCII_USTRINGPARAM ( "META-INF/manifest.xml") );
		pEntry->nMethod = DEFLATED;
		pEntry->nCrc = pEntry->nSize = pEntry->nCompressedSize = -1;
		pEntry->nTime = ZipOutputStream::getCurrentDosTime();
	
		// Convert vector into a Sequence
		Sequence < Sequence < PropertyValue > > aManifestSequence ( aManList.size() );
		Sequence < PropertyValue > * pSequence = aManifestSequence.getArray();
		for (vector < Sequence < PropertyValue > >::const_iterator aIter = aManList.begin(), aEnd = aManList.end();
			 aIter != aEnd;
			 aIter++, pSequence++)
			*pSequence= (*aIter);
		xWriter->writeManifestSequence ( xManOutStream,  aManifestSequence );

		sal_Int32 nBufferLength = static_cast < sal_Int32 > (pBuffer->getPosition());
		pBuffer->m_aBuffer.realloc( nBufferLength );

		try
		{
			vos::ORef < EncryptionData > xEmpty;
			pZipOutputStream->putNextEntry(*pEntry, xEmpty);
			pZipOutputStream->write(pBuffer->m_aBuffer, 0, nBufferLength);
			pZipOutputStream->closeEntry();
		}
		catch (::com::sun::star::io::IOException & )
		{
			VOS_ENSURE( 0, "Error adding META-INF/manifest.xml to the ZipOutputStream" );
		}
	}
	try
	{
		pZipOutputStream->finish();
	}
	catch (::com::sun::star::io::IOException & )
	{
		VOS_ENSURE( 0, "Error writing ZIP file to disk" );
	}
	pThreadedBuffer->m_aReadSemaphore.release();
	bFinished = sal_True;
}

void SAL_CALL OutputThread::onTerminated()
{
}
