/*************************************************************************
 *
 *  $RCSfile: Marshal.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kr $ $Date: 2001/01/16 18:01:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.uno.protocols.iiop;


import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import java.io.DataOutputStream;
import java.io.IOException;

import java.util.Hashtable;


import com.sun.star.uno.Any;
import com.sun.star.uno.Ascii;
import com.sun.star.uno.AsciiString;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.Union;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

import com.sun.star.corba.CorbaString8;
import com.sun.star.corba.CorbaUnion;
import com.sun.star.corba.ObjectKey;
import com.sun.star.corba.TCKind;

import com.sun.star.corba.iiop.ProfileBody_1_1;

import com.sun.star.corba.iop.IOR;
import com.sun.star.corba.iop.ProfileIdGroup;
import com.sun.star.corba.iop.TaggedProfile;

import com.sun.star.corba.giop.MessageHeader_1_1;
import com.sun.star.corba.giop.ReplyHeader_1_2;
import com.sun.star.corba.giop.RequestHeader_1_2;

import com.sun.star.uno.Type;

import com.sun.star.lib.uno.environments.remote.IMarshal;
import com.sun.star.lib.uno.environments.remote.Protocol;
import com.sun.star.lib.uno.environments.remote.ThreadID;

import com.sun.star.lib.uno.typeinfo.MemberTypeInfo;
import com.sun.star.lib.uno.typedesc.TypeDescription;


final class Marshal extends CDROutputStream implements IMarshal {
	public static boolean DEBUG = false;

	private void todo() throws com.sun.star.uno.Exception {
		throw new com.sun.star.uno.Exception(getClass().getName() + " - todo: not implemented");
	}

	protected IBridge bridge;

	Marshal(boolean littleEndian, IBridge bridge) {
		super(littleEndian);

		this.bridge = bridge;
//  		if(bridge == null)
//  			throw new NullPointerException();
	}

	/** Return the proper type kind of a class 
		
	 */
	private static int classToIIOPTypeKind(TypeDescription typeDescription) {
		return Unmarshal.classToIIOPTypeKind(typeDescription);
	};

//  	private int getStructMemberCount( Class StructClass, Class UntilClass )
//  	{
//  		int nMemberCount = 0;
//  		Class Superclass = StructClass.getSuperclass();
//  		// superclass must be filled before subclass
//  		if( Superclass != UntilClass )
//  			nMemberCount += getStructMemberCount( Superclass, UntilClass );

//  		// The precondition is, that the fields occure in the same order as 
//  		// specified in the IDL language, but this is not specified in Java.
//  		Field [] Fields = Unmarshal.__getDeclaredFields(StructClass);

//  		int nFieldsLength = Fields.length;
//  		for( int i = 0; i < nFieldsLength; i++ )
//  		{
//  			Field aField = Fields[i];
//  			if( (aField.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0 )
//  				nMemberCount++;
//  		}
//  		return nMemberCount;
//  	}

	private int getStructMemberCount(TypeDescription typeDescription) {
		return typeDescription.getFields().length;
	}

//  	private void write_structtypemembers( Class StructClass, Class UntilClass ) throws Exception
//  	{
//  		Class Superclass = StructClass.getSuperclass();
//  		// superclass must be filled before subclass
//  		if( Superclass != UntilClass )
//  			write_structtypemembers( Superclass, UntilClass );

//  		// The precondition is, that the fields occure in the same order as 
//  		// specified in the IDL language, but this is not specified in Java.
//  		Field [] Fields = Unmarshal.__getDeclaredFields(StructClass);
//  		int nFieldsLength = Fields.length;
//  		for( int i = 0; i < nFieldsLength; i++ )
//  		{
//  			Field aField = Fields[i];
//  			if( (aField.getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0 )
//  			{
//  				// member name
//  				write_asciistring(aField.getName());
//  				writeType(TypeDescription.getType(aField.getType()));
//  			}
//  		}
//  	}

	private void write_structtypemembers(TypeDescription typeDescription) throws Exception {
		Field fields[] = typeDescription.getFields();
		
		for(int i = 0; i < fields.length; ++ i) {
			write_asciistring(fields[i].getName());
			writeTypeDescription(TypeDescription.getTypeDescription(fields[i].getType()));
		}
	}

	private int writeTypeDescription(TypeDescription typeDescription) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeType:" + typeDescription);

		//Class return = null;
		String TypeName = typeDescription.getTypeName();
		int kind = classToIIOPTypeKind(typeDescription);
  		write_long(kind);

		// java optimize the switch statement to a jump table, only if
		// the case values are subsequent.
		switch(kind) {
			case TCKind.tk_TypeCode_value:	break;

			case TCKind.tk_Principal_value:	todo(); 	break;

			case TCKind.tk_objref_value:
				write_asciistring( TypeName );
				write_asciistring("");// dummy
				break;

			case TCKind.tk_except_value:
			case TCKind.tk_struct_value:
				write_asciistring( TypeName );
				// dummy
				write_asciistring("");
				int nCount = getStructMemberCount(typeDescription);
//  				int nCount = getStructMemberCount(type.getZClass(), Object.class );
				write_long( nCount );
				if( kind == TCKind.tk_except_value )
					write_structtypemembers(typeDescription);
//  					write_structtypemembers( type.getZClass(), Exception.class );
				else
					write_structtypemembers(typeDescription);
//  					write_structtypemembers( type.getZClass(), Object.class );
				break;

			case TCKind.tk_union_value:	todo();	break;

			case TCKind.tk_enum_value:
				write_asciistring( TypeName );
				write_asciistring(""); // dummy
				write_long( 0 );

				break;

			case TCKind.tk_string_value:
				// read the bounds of an string
				write_long( 0 );
				break;

			case TCKind.tk_sequence_value:
				TypeDescription elementTypeDescription = typeDescription.getComponentType();	// get the element type
				writeTypeDescription(elementTypeDescription);
				if( elementTypeDescription != null ){
					TypeName = "]" + elementTypeDescription.getTypeName();
					write_long(0);
				}
				break;

			case TCKind.tk_array_value:
			case TCKind.tk_alias_value:
			case TCKind.tk_longdouble_value:todo();	break;

			case TCKind.tk_wstring_value:
				// write the bounds of an string
				write_long( 0 );
				break;
		}
		return kind;
	}

	void writeBoolean(Boolean zBoolean) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeBoolean:" + zBoolean);

		write_boolean(zBoolean.booleanValue());
	}

	void writeByte(Byte zByte) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeByte:" + zByte);

		write_octet(zByte.byteValue());
	}

	void writeCharacter(Character character) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeCharacter:" + character);

		write_ascii(character.charValue());
	}

	void writeDouble(Double zDouble) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeDouble:" + zDouble);

		write_double(zDouble.doubleValue());

	}

	void writeFloat(Float zFloat) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeFloat:" + zFloat);

		write_float(zFloat.floatValue());
	}

	void writeInteger(Integer integer) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeInteger:" + integer);

		write_long(integer.intValue());
	}

	void writeLong(Long zLong) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeLong:" + zLong);

		write_longlong(zLong.longValue());
	}

	void writeShort(Short zShort) {
		write_short(zShort.shortValue());
	}

	void writeSequence(TypeDescription typeDescription, Object object) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeSequence:" + typeDescription + " " + object);

		typeDescription = typeDescription.getComponentType();

  		if(typeDescription.getTypeClass() == TypeClass.BYTE) // write a byte sequence ?
  			write_octet_array((byte [])object);

		else {
			int size = Array.getLength(object);
			write_long(size);
			
			for(int i = 0; i < size; ++ i)
				writeObject(typeDescription, Array.get(object, i));
		}
	}

	void writeUnion(Union union) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeUnion:" + union);

		throw new Exception("Marshal.writeUnion is not implemented yet!!!");
	}

	void writeStruct(TypeDescription typeDescription, Object object) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeStruct:" + typeDescription + " " + object);

		if(typeDescription.getZClass() == CorbaString8.class) { // special treatment for CorbaString8
			write_asciistring(((CorbaString8)object).theString);
		}
		else {
			Field fields[] = typeDescription.getFields();
			for(int i = 0; i < fields.length; ++ i) {
				if((fields[i].getModifiers() & (Modifier.STATIC | Modifier.TRANSIENT)) == 0) { // neither static nor transient ?
					MemberTypeInfo memberTypeInfo = typeDescription.getMemberTypeInfo(fields[i].getName());
					
					// default the member type to the declared type
					Class zInterface = fields[i].getType();
					
					if(memberTypeInfo != null) { // do we have any type infos?
						if(memberTypeInfo.isAny()) // is the member any any?
							if(zInterface.isArray())
								zInterface = Class.forName("[Lcom.sun.star.uno.Any;");
							else
								zInterface = Any.class;
						
						else if(memberTypeInfo.isInterface()) { // is the member an interface ?
							fields[i].getType().getFields();
							
							Class xInterface = zInterface;
							
							if(!XInterface.class.isAssignableFrom(fields[i].getType())) // is the member type not derived of XInterface ?
								xInterface = XInterface.class; // ensure that we write at least an XInterface
							
							if(zInterface.isArray())
								zInterface = Class.forName("[L" + xInterface.getName() + ";");
							else
								zInterface = xInterface;
						}
					}
					
					writeObject(TypeDescription.getTypeDescription(zInterface), fields[i].get(object));
				}
			}
		}
	}

	void writeThreadID(ThreadID threadID) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeThreadID:" + threadID);

		throw new Exception("Marshal.writeThreadID is not implemented yet!!!");
	}

	public void writeObject(TypeDescription typeDescription, Object object) throws Exception  {
		if(DEBUG) System.err.println("##### Marshal - index:" + size + " " + object + " " + typeDescription);

		switch(typeDescription.getTypeClass().getValue()) {
  		case TypeClass.ANY_value:       writeAny(object); 	                     break; // write an any ?
		case TypeClass.SEQUENCE_value:  
		case TypeClass.ARRAY_value:	    writeSequence(typeDescription, object);             break; // write a sequence ?
		case TypeClass.VOID_value:                                               break; // write nothing ?
  		case TypeClass.ENUM_value:      writeEnum((Enum)object);	             break; // write an enum ?
  		case TypeClass.UNION_value:     writeUnion((Union)object);               break; // write a union ?  ???????????
  		case TypeClass.TYPE_value:      writeTypeDescription((TypeDescription)((Type)object).getTypeDescription());                 break; // write a type ?
  		case TypeClass.INTERFACE_value:	write_objref(object, typeDescription);	             break; // is it an interface ?
  		case TypeClass.BOOLEAN_value:   writeBoolean((Boolean)object);           break; // is it a boolean
  		case TypeClass.CHAR_value:      writeCharacter((Character)object);       break; // is it a character ?
  		case TypeClass.BYTE_value:	    writeByte((Byte)object);	             break; // is it a byte ?
  		case TypeClass.SHORT_value:	    writeShort((Short)object);	             break; // is it a short ?
  		case TypeClass.LONG_value:      writeInteger((Integer)object);           break; // is it an integer ?
  		case TypeClass.HYPER_value:	    writeLong((Long)object);                 break; // is it a long ?
  		case TypeClass.FLOAT_value:     writeFloat((Float)object);	             break; // is it a float ?
  		case TypeClass.DOUBLE_value:    writeDouble((Double)object);             break; // is it a double ?
  		case TypeClass.STRING_value:    write_unicodestring((String)object);     break; // is it a String ?
  		case TypeClass.STRUCT_value:    
			if(object instanceof ThreadID) // is it a thread id ?
				writeThreadID((ThreadID)object);

			else if(object instanceof CorbaUnion)
				writeCorbaUnion((CorbaUnion)object);

			else  // is it a struct ?
				writeStruct(typeDescription, object);               
			
			break;

  		case TypeClass.EXCEPTION_value:	writeThrowable(typeDescription, (Throwable)object); break; // is it an exception?


		default:
			throw new com.sun.star.uno.RuntimeException("unknown typeClass:" + typeDescription.getTypeClass().getValue());
		}		
	}

	
	void writeAny(Object object) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeAny:" + object);

		TypeDescription typeDescription = null;

		if(object == null)
			typeDescription = TypeDescription.__void_TypeDescription;

		else if(object instanceof Any) {
			Any any = (Any)object;

			typeDescription = (TypeDescription)any.getType().getTypeDescription();
			object = any.getObject();
		}
		else if(object instanceof XInterface)
			typeDescription = Unmarshal.__xInterfaceTypeDescription;
			
		else
			typeDescription = TypeDescription.getTypeDescription(object.getClass());

		writeTypeDescription(typeDescription);
		writeObject(typeDescription, object);
	}

	void writeEnum(Enum enum) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeEnum:" + enum + " " + enum.getValue());

		write_long(enum.getValue());
	}

	void writeThrowable(TypeDescription typeDescription, Throwable throwable) throws Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".writeThrowable:" + throwable);

		write_asciistring(throwable.getClass().getName());

		String message = throwable.getMessage();
		write_unicodestring((message == null) ? "" : message);

		writeStruct(typeDescription, throwable);
	}

	private void write_objref(Object obj, TypeDescription typeDescription) throws Exception {
		String sType = typeDescription.getTypeName();

		IOR ior = new IOR(new CorbaString8(sType), null);

		if(obj != null) {
			String oId = (String)bridge.mapInterfaceTo(obj, new Type(typeDescription));
			
			if(DEBUG) System.err.println("##### Marshal.write_objref:" + obj + " " + typeDescription + " oId:" + oId + " stype:" + sType);
			
			ObjectKey objectKey = new ObjectKey(new CorbaString8(oId), new CorbaString8(sType));
			Marshal tmpMarshal = new Marshal(littleEndian, bridge);
			tmpMarshal.writeObject(Unmarshal.__ObjectKeyTypeDescription, objectKey);
			
			ProfileBody_1_1 profileBody = new ProfileBody_1_1(new com.sun.star.corba.iiop.Version((byte)1, (byte)2), 
															  new CorbaString8("unknown"), 
															  (short)0, 
															  tmpMarshal.reset(), 
															  new com.sun.star.corba.iop.TaggedComponent[0]);

			Marshal marshal = new Marshal(littleEndian, bridge);
			marshal.writeObject(Unmarshal.__ProfileBody_1_1TypeDescription, profileBody);
			
			ior.profiles = new TaggedProfile[]{new TaggedProfile(ProfileIdGroup.TAG_INTERNET_IOP, marshal.reset())};
		}
		else
			ior.profiles = new TaggedProfile[0];

  		writeObject(Unmarshal.__IORTypeDescription, ior);
	}

	private void writeCorbaUnion(CorbaUnion corbaUnion) throws Exception {
		TypeDescription typeDescription = TypeDescription.getTypeDescription(corbaUnion.getClass());

		Field descriminatorField = typeDescription.getZClass().getField("nDiscriminator");
		
		short index = descriminatorField.getShort(corbaUnion);
		write_short(index);

		Field fields[] = typeDescription.getFields();
		writeObject(TypeDescription.getTypeDescription(fields[index + 2].getType()), fields[index + 2].get(corbaUnion));
	}
}



