/*************************************************************************
 *
 *  $RCSfile: g_stgifc.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <precomp.h>
#include <store/g_stgifc.hxx>


// NOT FULLY DEFINED SERVICES
#include <cosv/template/tpltools.hxx>
#include <ary/cpp/cg_proj.hxx>
#include <ary/cpp/cg_file.hxx>
#include "sto_grps.hxx"
#include "ti_storg.hxx"


namespace ary
{
namespace store
{


//********************		CheshireCat		**************//

struct Groups_Ifc::CheshireCat
{
	typedef std::map< Gid, ary::AryGroup* >          GroupIndex;
	typedef std::map< Lid, ary::cpp::ProjectGroup* > MapLid2Project;
	typedef std::map< udmstri, ary::cpp::ProjectGroup* >
                                                     MapName2Project;
	typedef std::map< Lid, ary::cpp::FileGroup* >    MapLid2File;

    GroupIndex          aIndex;
    MapLid2Project      aProjectsByLid;
    MapName2Project     aProjectsByName;
    MapLid2File         aFilesByLid;

    ary::store::IndependentGroups *
                        pStorage;
	Dyn<ary::TopProject>
                     	pTopProject;                // KORR_FUTURE!
                                                    //   Has to be part of Storage!

						CheshireCat(
							IndependentGroups & io_rGroupStorage );
						~CheshireCat();
};


Groups_Ifc::
CheshireCat::CheshireCat( IndependentGroups & io_rGroupStorage )
	:	// aIndex,
        // aProjectsByLid,
        // aFilesByLid,
        pStorage( &io_rGroupStorage ),
        pTopProject(0)
{
}

Groups_Ifc::
CheshireCat::~CheshireCat()
{
}


//********************		Groups_Ifc		**************//

Groups_Ifc::Groups_Ifc( IndependentGroups & io_rGroupStorage )
	:	pi( new CheshireCat(io_rGroupStorage) )
{
}

void
Groups_Ifc::Init_TopProject( ary::TopProject & let_drProject )
{
    pi->pTopProject = &let_drProject;
    pi->aIndex[let_drProject.Id()] = &let_drProject;
}

Groups_Ifc::~Groups_Ifc()
{
}

void
Groups_Ifc::Add_ProjectGroup_Cpp( DYN ary::cpp::ProjectGroup & let_drProject )
{
    Gid nId = let_drProject.Id_Group();
    pi->pStorage->Projects_Cpp().Add( nId, let_drProject );
    pi->aIndex[nId] = &let_drProject;
    pi->aProjectsByLid[let_drProject.RootDir()] = &let_drProject;
    pi->aProjectsByName[let_drProject.Name()] = &let_drProject;
}

void
Groups_Ifc::Add_FileGroup_Cpp( DYN ary::cpp::FileGroup & let_drFile )
{
    Gid nId = let_drFile.Id_Group();
    pi->pStorage->Files_Cpp().Add( nId, let_drFile );
    pi->aIndex[nId] = &let_drFile;
    pi->aFilesByLid[let_drFile.AssociatedFile()] = &let_drFile;
}

const ary::TopProject &
Groups_Ifc::Top() const
{
    csv_assert( pi->pTopProject != 0 );
    return *pi->pTopProject;
}

const ary::AryGroup *
Groups_Ifc::Find_Group( Gid i_nId ) const
{
	return csv::value_from_map( pi->aIndex, i_nId );
}

const ary::cpp::ProjectGroup *
Groups_Ifc::Search_ProjectGroup_Cpp( const udmstri & i_sProjectName  ) const
{
    return csv::value_from_map( pi->aProjectsByName, i_sProjectName );
}

ary::TopProject &
Groups_Ifc::Top()
{
    csv_assert( pi->pTopProject != 0 );
    return *pi->pTopProject;
}

ary::cpp::ProjectGroup *
Groups_Ifc::Find_ProjectGroup_Cpp( Gid i_nProject )
{
    return pi->pStorage->Projects_Cpp().Find( i_nProject );
}

ary::cpp::ProjectGroup *
Groups_Ifc::Search_ProjectGroup_Cpp( Lid i_nRootDir )
{
	return csv::value_from_map( pi->aProjectsByLid, i_nRootDir );
}

ary::cpp::FileGroup *
Groups_Ifc::Search_FileGroup_Cpp( Lid i_nFile )
{
	return csv::value_from_map( pi->aFilesByLid, i_nFile );
}


} // namespace store
} // namespace ary


