/*************************************************************************
 *
 *  $RCSfile: unxmain.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: ok $ $Date: 2001/01/30 08:14:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

#include <stdlib.h>
#include <stdio.h>

Bool b_xerror = False;

int NewErrorHandler(Display *p_display, XErrorEvent *p_event)
{
	b_xerror = True;
	return 0;
}

int (*OldErrorHandler)(Display* p_display, XErrorEvent *p_event);

Bool check_fontpath (Display *p_display)
{
	Bool   b_anyxerror = False;
	int    n_oldfp;
	char** pp_oldfp;

	if (p_display == NULL)
		return 0;

	OldErrorHandler = XSetErrorHandler (NewErrorHandler);
	pp_oldfp = XGetFontPath (p_display, &n_oldfp);

	b_xerror = False;
	XSetFontPath (p_display, pp_oldfp, n_oldfp);
	XSync (p_display, False);

	if (b_xerror)
	{
		int i;
		int n_newfp = n_oldfp;
		char** pp_newfp = (char**)malloc(n_newfp * sizeof(char*));

		for (i = 0, n_newfp = 0; i < n_oldfp; i++)
		{
			pp_newfp[ n_newfp ] = pp_oldfp[i];
			b_xerror = False;
			XSetFontPath (p_display, pp_newfp, n_newfp + 1);
			XSync (p_display, False);

			if (b_xerror)
				b_anyxerror = True;
			else
				n_newfp++;
		}

		free (pp_newfp);
	}
	XFreeFontPath (pp_oldfp);

	XSetErrorHandler (OldErrorHandler);

	return b_anyxerror;
}

unsigned char check_fontpath ()
{
	Display* display;
	char* display_name = NULL;
	if( (display=XOpenDisplay(display_name)) == NULL )
	{
		(void) fprintf( stderr, "cannot connect to X server\n" );
		exit( -1 );
	}
	return check_fontpath(display);
}

