/*************************************************************************
 *
 *  $RCSfile: chrtdefs.hxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 18:04:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHRTDEFS_HXX
#define _CHRTDEFS_HXX


#define CHART_STRING_LINE				"com.sun.star.chart.LineDiagram"
#define CHART_STRING_AREA				"com.sun.star.chart.AreaDiagram"
#define CHART_STRING_BAR				"com.sun.star.chart.BarDiagram"
#define CHART_STRING_PIE				"com.sun.star.chart.PieDiagram"
#define CHART_STRING_DONUT				"com.sun.star.chart.DonutDiagram"
#define CHART_STRING_XY					"com.sun.star.chart.XYDiagram"
#define CHART_STRING_NET				"com.sun.star.chart.NetDiagram"
#define CHART_STRING_STOCK				"com.sun.star.chart.StockDiagram"

#define CHART_PROP_ALIGNMENT			"Alignment"
#define CHART_PROP_ATTRIBUTEDDP         "AttributedDataPoints"
#define CHART_PROP_AUTOMAX				"AutoMax"
#define CHART_PROP_AUTOMIN				"AutoMin"
#define CHART_PROP_AUTOORIG				"AutoOrigin"
#define CHART_PROP_AUTOSTHELP			"AutoStepHelp"
#define CHART_PROP_AUTOSTMAIN			"AutoStepMain"
#define CHART_PROP_AXIS					"Axis"
#define CHART_PROP_CHARFONTFAMILY		"CharFontFamily"
#define CHART_PROP_CHARFONTCHARSET		"CharFontCharSet"
#define CHART_PROP_CHARCOLOR			"CharColor"
#define CHART_PROP_CHARCONTOURED		"CharContoured"
#define CHART_PROP_CHARCROSSEDOUT		"CharCrossedOut"
#define CHART_PROP_CHARFONT				"CharFont"
#define CHART_PROP_CHARFONTNAME			"CharFontName"
#define CHART_PROP_CHARHEIGHT			"CharHeight"
#define CHART_PROP_CHARPOSTURE			"CharPosture"
#define CHART_PROP_CHARSHADOWED			"CharShadowed"
#define CHART_PROP_CHARUNDERL			"CharUnderline"
#define CHART_PROP_CHARWEIGHT			"CharWeight"
#define CHART_PROP_DATACAPTION			"DataCaption"
#define CHART_PROP_DEEP					"Deep"
#define CHART_PROP_DIAGRAMTYPE			"DiagramType"
#define CHART_PROP_DIM3D				"Dim3D"
#define CHART_PROP_FILLCOLOR			"FillColor"
#define CHART_PROP_FILLGRADIENT			"FillGradient"
#define CHART_PROP_FILLGRADIENTSTEPC	"FillGradientStepCount"
#define CHART_PROP_FILLSTYLE			"FillStyle"
#define CHART_PROP_GAPWIDTH				"GapWidth"
#define CHART_PROP_HASLEGEND			"HasLegend"
#define CHART_PROP_HASMAINTIT			"HasMainTitle"
#define CHART_PROP_HASSECXAXIS			"HasSecondaryXAxis"
#define CHART_PROP_HASSECXAXISDESCR		"HasSecondaryXAxisDescription"
#define CHART_PROP_HASSECYAXIS			"HasSecondaryYAxis"
#define CHART_PROP_HASSECYAXISDESCR		"HasSecondaryYAxisDescription"
#define CHART_PROP_HASXAXIS				"HasXAxis"
#define CHART_PROP_HASXAXISDESCR		"HasXAxisDescription"
#define CHART_PROP_HASXAXISHELPGRID		"HasXAxisHelpGrid"
#define CHART_PROP_HASXAXISGRID			"HasXAxisGrid"
#define CHART_PROP_HASXAXISTIT			"HasXAxisTitle"
#define CHART_PROP_HASYAXIS				"HasYAxis"
#define CHART_PROP_HASYAXISDESCR		"HasYAxisDescription"
#define CHART_PROP_HASYAXISHELPGRID		"HasYAxisHelpGrid"
#define CHART_PROP_HASYAXISGRID			"HasYAxisGrid"
#define CHART_PROP_HASYAXISTIT			"HasYAxisTitle"
#define CHART_PROP_HASZAXIS				"HasZAxis"
#define CHART_PROP_HASZAXISDESCR		"HasZAxisDescription"
#define CHART_PROP_HASZAXISHELPGRID		"HasZAxisHelpGrid"
#define CHART_PROP_HASZAXISGRID			"HasZAxisGrid"
#define CHART_PROP_HASZAXISTIT			"HasZAxisTitle"
#define CHART_PROP_HELPMARKS			"HelpMarks"
#define CHART_PROP_LINECOLOR			"LineColor"
#define CHART_PROP_LINEDASH				"LineDash"
#define CHART_PROP_LINES				"Lines"
#define CHART_PROP_LINESTYLE			"LineStyle"
#define CHART_PROP_LINETRANSPARENCE     "LineTransparence"
#define CHART_PROP_LINEWIDTH			"LineWidth"
#define CHART_PROP_LINKNUMFMT           "LinkNumberFormatToSource"
#define CHART_PROP_LOG					"Logarithmic"
#define CHART_PROP_MARKS				"Marks"
#define CHART_PROP_MAX					"Max"
#define CHART_PROP_MIN					"Min"
#define CHART_PROP_NUMFMT				"NumberFormat"
#define CHART_PROP_NULLDATE				"NullDate"
#define CHART_PROP_ORIGIN				"Origin"
#define CHART_PROP_OVERLAP				"Overlap"
#define CHART_PROP_PERCENT				"Percent"
#define CHART_PROP_ROWSOURCE			"DataRowSource"
#define CHART_PROP_SEGMENTOFFSET		"SegmentOffset"
#define	CHART_PROP_SOLIDTYPE			"SolidType"
#define	CHART_PROP_SPLINETYPE			"SplineType"
#define CHART_PROP_STACKCONN			"StackedBarsConnected"
#define CHART_PROP_STACKED				"Stacked"
#define CHART_PROP_STEPHELP				"StepHelp"
#define CHART_PROP_STEPMAIN				"StepMain"
#define CHART_PROP_STRING				"String"
#define	CHART_PROP_SYMBOLTYPE			"SymbolType"
#define	CHART_PROP_TEXT					"Text"
#define	CHART_PROP_TEXTBREAK			"TextBreak"
#define CHART_PROP_TEXTOVERLAP			"TextCanOverlap"
#define	CHART_PROP_TEXTROTATION			"TextRotation"
#define CHART_PROP_UPDOWN				"UpDown"
#define	CHART_PROP_VERTICAL				"Vertical"
#define CHART_PROP_VOLUME				"Volume"

//_________________________________________________________

//	Min. Abstand zum Rand des Ole-Objekts
//	(0 ist fuer Chart nochmal spezial)
#define SC_CHART_MINDIST				200

#define TWIP_TO_MM100(TWIP) 			(((TWIP)*127L+36L)/72L)
#define MM100_TO_TWIP(MM100)			(((MM100)*72L+63L)/127L)

// for chart and axis titles
#define MM100_TO_PIXEL(MM100)			INT32(((MM100)*96.0+1270.0)/2540.0)

//_________________________________________________________

#define CSS                             ::com::sun::star

//_________________________________________________________

enum XclChartType
{
	ctUnknown,
	ctLine,
	ctArea,				// filled line chart
	ctBar,				// horizontal bar chart
	ctColumn,			// vertical bar chart
	ctPie,
	ctDonut,			// pie sub type
	ctScatter,			// XY
	ctNet,				// radar
    ctStock,
    ctSurface           // not supported yet
};

//_________________________________________________________

// common
#define EXC_CHART_FIRSTAXESSET          0x0000      // primary axes set
#define EXC_CHART_SECONDAXESSET         0x0001      // secondary axes set

#define EXC_CHART_XAXIS					0x0000		// category or X axis
#define EXC_CHART_YAXIS					0x0001		// value or Y axis
#define EXC_CHART_ZAXIS					0x0002		// series axis

#define EXC_CHART_FONT_AUTOCOLOR        77          // index for font autocolor

// rotation, for various records
#define EXC_CHART_ROT_CCLOCKW			0x0002		// rotate counterclockwise
#define EXC_CHART_ROT_CLOCKW			0x0003		// rotate clockwise

// (0x103A) 3D
#define EXC_CHART_3D_PERSP				0x0001
#define EXC_CHART_3D_CLUSTER			0x0002
#define EXC_CHART_3D_AUTOSCALE			0x0004
#define EXC_CHART_3D_2DWALLS			0x0020		// use 2D walls & grids
#define EXC_CHART_3D_FLAGS				0x0015		// perspecive & auto scaling

// (0x105F) 3DDATAFORMAT
#define EXC_CHART_DATAF_RECT			0x00		// base formats
#define EXC_CHART_DATAF_CIRC			0x01
#define EXC_CHART_DATAF_STRAIGHT		0x00		// top formats
#define EXC_CHART_DATAF_SHARP			0x01
#define EXC_CHART_DATAF_TRUNC			0x02

// (0x1051) AI
#define EXC_CHART_AI_LINKTITLE			0x00		// title or text
#define EXC_CHART_AI_LINKVALUE			0x01		// series values
#define EXC_CHART_AI_LINKCAT			0x02		// series categories
#define EXC_CHART_AI_LINKUNKNOWN		0x03

#define EXC_CHART_AI_REFDEF				0x00		// default category
#define EXC_CHART_AI_REFDIRECTLY		0x01		// entered directly
#define EXC_CHART_AI_REFWORKSH			0x02		// linked to worksheet

// (0x100A) AREAFORMAT
#define EXC_CHART_AREAF_NONE			0x0000		// transparent
#define EXC_CHART_AREAF_SOLID			0x0001		// solid

#define EXC_CHART_AREAF_AUTO			0x0001
#define EXC_CHART_AREAF_INVERT			0x0002		// invert if negative

// (0x100C) ATTACHEDLABEL
#define EXC_CHART_ATLAB_SHOWVALUE		0x0001		// value
#define EXC_CHART_ATLAB_SHOWPERCENT		0x0002		// percent
#define EXC_CHART_ATLAB_SHOWLABELPERC	0x0004		// cat name & percent
#define EXC_CHART_ATLAB_SHOWLABEL		0x0010		// category name
#define EXC_CHART_ATLAB_ISATTACHED		0x0017		// all above

// (0x1062) AXCEXT
#define EXC_CHART_AXCEXT_FLAGS			0x00EF		// default format

// (0x1021) AXISLINEFORMAT
#define EXC_CHART_AXLINEF_AXISLINE		0			// axis
#define EXC_CHART_AXLINEF_MAJORGRID		1			// main grid
#define EXC_CHART_AXLINEF_MINORGRID		2			// help grid
#define EXC_CHART_AXLINEF_WALLS			3			// walls if parent axis is type 0 or 2
													// floor if parent axis is type 1
// (0x1017) BAR
#define EXC_CHART_BAR_TRANS				0x0001		// 0 = column diagram
#define EXC_CHART_BAR_STACKED			0x0002
#define EXC_CHART_BAR_PERCENT			0x0004
#define EXC_CHART_BAR_SHADOW			0x0008

// (0x1020) CATSERRANGE
#define EXC_CHART_CATR_BETWEEN			0x0001		// axis between categories
#define EXC_CHART_CATR_MAXCROSS			0x0002		// secondary Y axis at right margin

// (0x1014) CHARTFORMAT
#define EXC_CHART_CHARTF_VARIED			0x0001		// varied colors for pie/donut

// (0x01C) CHARTLINE
#define EXC_CHART_CHLINE_HILO			0x0001		// hi-lo line in stock charts

// (0x1006) DATAFORMAT
#define EXC_CHART_DATAF_SERIES			0xFFFF		// entire series
#define EXC_CHART_DATAF_CHART			0xFFFD		// all series

// (0x103D) DROPBAR
#define EXC_CHART_DROP_UP				1
#define EXC_CHART_DROP_DOWN				2

// (0x1026) FONTX
#define EXC_CHART_FONTX_DEFAULT			5

// (0x1032) FRAME
#define EXC_CHART_FRAME_AUTOSIZE		0x0001
#define EXC_CHART_FRAME_AUTOPOS			0x0002

// (0x104E) IFMT
#define EXC_CHART_IFMT_INVALID			0xFFFFFFFF

// (0x1015) LEGEND
#define EXC_CHART_LEGEND_BOTTOM			0x00
#define EXC_CHART_LEGEND_TOP			0x02
#define EXC_CHART_LEGEND_RIGHT			0x03
#define EXC_CHART_LEGEND_LEFT			0x04
#define EXC_CHART_LEGEND_NOTDOCKED		0x07

#define EXC_CHART_LEGEND_SPACINGMED		0x01		// always set in Excel

#define EXC_CHART_LEGEND_AUTOPOS		0x000D		// all flags for auto position
#define EXC_CHART_LEGEND_DOCKED			0x0001
#define EXC_CHART_LEGEND_AUTOSERIES		0x0002
#define EXC_CHART_LEGEND_AUTOPOSX		0x0004
#define EXC_CHART_LEGEND_AUTOPOSY		0x0008
#define EXC_CHART_LEGEND_VERT			0x0010
#define EXC_CHART_LEGEND_DATATABLE		0x0020

// (0x1018) LINE, (0x101A) AREA
#define EXC_CHART_LINE_STACKED			0x0001
#define EXC_CHART_LINE_PERCENT			0x0002
#define EXC_CHART_LINE_SHADOW			0x0004

// (0x1007) LINEFORMAT
#define EXC_CHART_LINEF_SOLID			0x0000		// line style
#define EXC_CHART_LINEF_DASH			0x0001
#define EXC_CHART_LINEF_DOT				0x0002
#define EXC_CHART_LINEF_DASHDOT			0x0003
#define EXC_CHART_LINEF_DASHDOTDOT		0x0004
#define EXC_CHART_LINEF_NONE			0x0005
#define EXC_CHART_LINEF_DARKTRANS		0x0006
#define EXC_CHART_LINEF_MEDTRANS		0x0007
#define EXC_CHART_LINEF_LIGHTTRANS		0x0008

#define EXC_CHART_LINEF_HAIR			-1			// line width
#define EXC_CHART_LINEF_SINGLE			0
#define EXC_CHART_LINEF_DOUBLE			1
#define EXC_CHART_LINEF_TRIPLE			2

#define EXC_CHART_LINEF_AUTO			0x0001
#define EXC_CHART_LINEF_TICK			0x0004

// (0x1009) MARKERFORMAT
#define EXC_CHART_MARKF_COUNT			9
#define EXC_CHART_MARKF_NOSYMBOL		0
#define EXC_CHART_MARKF_DOWJ			6

// (0x1027) OBJECTLINK
#define EXC_CHART_OLINK_NONE			0x0000		// don't write this record
#define EXC_CHART_OLINK_TITLE			0x0001		// chart title
#define EXC_CHART_OLINK_YAXIS			0x0002		// value or Y axis
#define EXC_CHART_OLINK_XAXIS			0x0003		// category or X axis
#define EXC_CHART_OLINK_DATA			0x0004		// data point
#define EXC_CHART_OLINK_ZAXIS			0x0007		// series or Z axis

// (0x103C) PICF
const sal_uInt16 EXC_CHART_PICF_STRETCH     = 0x0001;       /// Bitmap stretched to area.
const sal_uInt16 EXC_CHART_PICF_STACK       = 0x0002;       /// Bitmap stacked.
const sal_uInt16 EXC_CHART_PICF_SCALE       = 0x0003;       /// Bitmap scaled to axis scale.

// (0x1019) PIE
#define EXC_CHART_PIE_SHADOW			0x0001
#define EXC_CHART_PIE_LINES				0x0002

// (0x103E) RADAR
#define EXC_CHART_RADAR_AXLAB			0x0001		// axis labels

// (0x101B) SCATTER
#define EXC_CHART_SCAT_BUBBLES			0x0001
#define EXC_CHART_SCAT_NEGBUBBLES		0x0002
#define EXC_CHART_SCAT_SHADOW			0x0004

// (0x105D) SERFMT
#define EXC_CHART_SERF_SMOOTHED			0x0001		// spline

// (0x1003) SERIES
#define EXC_CHART_SER_NUM				0x0001		// data types of series
#define EXC_CHART_SER_TEXT				0x0003

// (0x1044) SHTPROPS
#define EXC_CHART_SHTPR_CHANGED         0x0003      // chart changed by user

// (0x1025) TEXT
#define EXC_CHART_TEXT_ALIGNCENTER		2			// always centered
#define EXC_CHART_TEXT_BGTRANS			1			// character background always transparent
													// (this is not the shape background)
#define EXC_CHART_TEXT_AUTOCOLOR		0x0001
#define EXC_CHART_TEXT_SHOWKEY			0x0002		// legend key for data point caption
#define EXC_CHART_TEXT_SHOWVALUE		0x0004		// data point caption is a value
#define EXC_CHART_TEXT_VERTICAL			0x0008
#define EXC_CHART_TEXT_AUTOTEXT			0x0010
#define EXC_CHART_TEXT_GENERATED		0x0020
#define EXC_CHART_TEXT_DELETED			0x0040		// data label deleted
#define EXC_CHART_TEXT_AUTOMODE			0x0080
#define EXC_CHART_TEXT_SHOWLABELPERC	0x0800		// data point caption name & percent
#define EXC_CHART_TEXT_SHOWPERCENT		0x1000		// data point caption as percent
#define EXC_CHART_TEXT_SHOWBSIZE		0x2000		// show bubble size
#define EXC_CHART_TEXT_SHOWLABEL		0x4000		// data point caption is a name

#define EXC_CHART_TEXT_POSDEFAULT		0
#define EXC_CHART_TEXT_POSABOVE			5
#define EXC_CHART_TEXT_POSMOVED			10

#define EXC_CHART_TEXT_GETROTMODE(nF)	(((nF) & 0x0700) >> 8)	// rotation mode (import)
#define EXC_CHART_TEXT_GETROTFLAGS(nF)	(((nF) & 0x0003) << 8)	// rotation flags (export)

// (0x101E) TICK
#define EXC_CHART_TICK_NOMARK			0x00		// tick marks
#define EXC_CHART_TICK_INSIDE			0x01
#define EXC_CHART_TICK_OUTSIDE			0x02
#define EXC_CHART_TICK_CROSS			0x03

#define EXC_CHART_TICK_NOLABEL			0x00		// tick label position
#define EXC_CHART_TICK_LOW				0x01		// below X, right of Y
#define EXC_CHART_TICK_HIGH				0x02		// above X, left of Y
#define EXC_CHART_TICK_NEXT				0x03		// next to axis -> net chart

#define EXC_CHART_TICK_OPAQUE			2

#define EXC_CHART_TICK_AUTO				0x0001
#define EXC_CHART_TICK_AUTOMODE			0x0002
#define EXC_CHART_TICK_AUTOROT			0x0020

#define EXC_CHART_TICK_GETROTMODE(nF)	(((nF) & 0x001C) >> 2)	// rotation mode (import)
#define EXC_CHART_TICK_GETROTFLAGS(nF)	(((nF) & 0x0003) << 2)	// rotation flags (export)

// (0x101F) VALUERANGE
#define EXC_CHART_VALR_AUTOMIN			0x0001
#define EXC_CHART_VALR_AUTOMAX			0x0002
#define EXC_CHART_VALR_AUTOMAJOR		0x0004
#define EXC_CHART_VALR_AUTOMINOR		0x0008
#define EXC_CHART_VALR_AUTOCROSS		0x0010
#define EXC_CHART_VALR_LOGSCALE			0x0020
#define EXC_CHART_VALR_REVERSE			0x0040
#define EXC_CHART_VALR_MAXCROSS			0x0080
#define EXC_CHART_VALR_STOCKFLAG		0x0100


#endif // _CHRTDEFS_HXX

