/*
 * $Header: /cvsroot/opencryptoki/opencryptoki/usr/lib/pkcs11/leeds_stdll/args.h,v 1.2 2005/02/22 20:48:04 mhalcrow Exp $
 */

//
/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


// File:  cardargs.h
//
// Argument block definitions for coprocessor requests/replies
//
// This file is required for both host and coprocessor-side code
//
#ifndef _CARD_ARGS_H
#define _CARD_ARGS_H

#ifndef _PKCS11TYPES_H_
   #include "PKCS11Types.h"
#endif

#if (LEEDS_BUILD)

#pragma pack(1)
#pragma options align=packed
#endif


#ifdef PKCS64

//-------------------------------------------------------------------
//
typedef struct _GetMechList_Args
{
   CK_ULONG_32  list_length;
   CK_BBOOL  length_only;
} GetMechList_Args;

// C_GetMechanismList reply:
//
// +-----------+------------------------------------+
// | CK_ULONG_32  | List of CK_MECHANISM_TYPE_32 elements |
// +-----------+------------------------------------+
//

typedef struct _GetMechInfo_Args
{
   CK_MECHANISM_TYPE_32 mech_type;
} GetMechInfo_Args;

typedef struct _InitPIN_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BYTE              pin[MAX_PIN_LEN];
   CK_ULONG_32             pin_len;
} InitPIN_Args;

typedef struct _SetPIN_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BYTE              old_pin[MAX_PIN_LEN];
   CK_ULONG_32             old_pin_len;
   CK_BYTE              new_pin[MAX_PIN_LEN];
   CK_ULONG_32             new_pin_len;
} SetPIN_Args;


typedef struct _OpenSession_Args
{
   CK_SLOT_ID_32        slot_id;
   CK_FLAGS_32          flags;
   CK_ULONG_32       application_ptr;  // not used
   CK_ULONG_32         notify;           // not used

   //CK_VOID_PTR       application_ptr;  // not used
   //CK_NOTIFY         notify;           // not used
   CK_BBOOL          req_proc_handle;
} OpenSession_Args;

typedef struct _CloseSession_Args
{
   CK_SESSION_HANDLE_32  session_handle;
} CloseSession_Args;

typedef struct _GetSessionInfo_Args
{
   CK_SESSION_HANDLE_32  session_handle;
} GetSessionInfo_Args;

typedef struct _Login_Args
{
   CK_SESSION_HANDLE_32  session_handle;
   CK_USER_TYPE_32       user_type;
   CK_BYTE            pin[MAX_PIN_LEN];
   CK_ULONG_32           pin_len;
} Login_Args;

typedef struct _Logout_Args
{
   CK_SESSION_HANDLE_32  session_handle;
} Logout_Args;

// CreateObject_Args is a bit different.  The attributes themselves
// are passed as a datablock immediately following this structure
//
typedef struct _CreateObject_Args
{
   CK_SESSION_HANDLE_32   session_handle;
   CK_ULONG_32            attribute_count;
   CK_ULONG_32            attribute_block_len;
   // attributes/template gets appended here
   //
} CreateObject_Args;


typedef struct _CopyObject_Args
{
   CK_SESSION_HANDLE_32   session_handle;
   CK_OBJECT_HANDLE_32    object_handle;
   CK_ULONG_32            attribute_count;
   CK_ULONG_32            attribute_block_len;
   // attributes/template gets appended here
   //
} CopyObject_Args;


typedef struct _DestroyObject_Args
{
   CK_SESSION_HANDLE_32 session_handle;
   CK_OBJECT_HANDLE_32  object_handle;
} DestroyObject_Args;


typedef struct _GetObjectSize_Args
{
   CK_SESSION_HANDLE_32  session_handle;
   CK_OBJECT_HANDLE_32   object_handle;
} GetObjectSize_Args;


typedef struct _GetAttributeValue_Args
{
   CK_SESSION_HANDLE_32  session_handle;
   CK_OBJECT_HANDLE_32   object_handle;
   CK_ULONG_32           attribute_count;
   CK_ULONG_32           attribute_block_len;
   CK_BBOOL           size_only;
   // list of attribute types (CK_ATTRIBUTE_TYPE) gets appended here.
   //
} GetAttributeValue_Args;


typedef struct _SetAttributeValue_Args
{
   CK_SESSION_HANDLE_32  session_handle;
   CK_OBJECT_HANDLE_32   object_handle;
   CK_ULONG_32           attribute_count;
   CK_ULONG_32           attribute_block_len;
   // attribute template gets appended here
   //
} SetAttributeValue_Args;


typedef struct _FindObjectsInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             attribute_count;
   CK_ULONG_32             attribute_block_len;
   // attribute template gets appended here
   //
} FindObjectsInit_Args;


typedef struct _FindObjects_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             max_count;
} FindObjects_Args;


typedef struct _FindObjectsFinal_Args
{
   CK_SESSION_HANDLE_32    session_handle;
} FindObjectsFinal_Args;


typedef struct _GenerateRandom_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             num_bytes;
} GenerateRandom_Args;


typedef struct _GenerateKey_Args
{
   CK_SESSION_HANDLE_32   session_handle;
   CK_MECHANISM_TYPE_32   mech_type;
   CK_ULONG_32            mech_param_len;
   CK_ULONG_32            attribute_count;
   CK_ULONG_32            attribute_block_len;
   // mechanism parameter gets appended here
   // attributes get appended here
   //
} GenerateKey_Args;


typedef struct _GenKeyPair_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             mech_param_len;
   CK_ULONG_32             publ_key_attr_count;   // # of attributes
   CK_ULONG_32             publ_key_tmpl_len;     // overall template length
   CK_ULONG_32             priv_key_attr_count;   // # of attributes
   CK_ULONG_32             priv_key_tmpl_len;     // overall template length
   // the mechanism parameter is appended here
   // the public key template is appended here
   // the private key template is appended here
   //
} GenKeyPair_Args;


typedef struct _EncryptInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} EncryptInit_Args;


typedef struct _Encrypt_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             cleartext_len;
   CK_BBOOL             length_only;
   // cleartext is appended here
   //
} Encrypt_Args;


typedef struct _EncryptUpdate_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             cleartext_len;
   CK_BBOOL             length_only;
   // cleartext is appended here
   //
} EncryptUpdate_Args;


typedef struct _EncryptFinal_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BBOOL             length_only;
} EncryptFinal_Args;


typedef struct _DecryptInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} DecryptInit_Args;


typedef struct _Decrypt_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             ciphertext_len;
   CK_BBOOL             length_only;
   // ciphertext is appended here
   //
} Decrypt_Args;


typedef struct _DecryptUpdate_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             ciphertext_len;
   CK_BBOOL             length_only;
   // ciphertext is appended here
   //
} DecryptUpdate_Args;


typedef struct _DecryptFinal_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BBOOL             length_only;
} DecryptFinal_Args;


typedef struct _WrapKey_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             mech_param_len;
   CK_OBJECT_HANDLE_32     wrapping_key;
   CK_OBJECT_HANDLE_32     key;             // key to be wrapped
   CK_BBOOL             length_only;
   // mechanism parameter (if any) is appended here
   //
} WrapKey_Args;


typedef struct _UnWrapKey_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             mech_param_len;
   CK_OBJECT_HANDLE_32     unwrapping_key;
   CK_ULONG_32             wrapped_key_len;
   CK_ULONG_32             attribute_count;
   CK_ULONG_32             attribute_block_len;
   // mechanism parameter appended here      (mech_param_len bytes     )
   // wrapped key appended here              (wrapped_key_len bytes    )
   // attributes appended here               (attribute_block_len bytes)
   //
} UnWrapKey_Args;



typedef struct _DeriveKey_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             mech_param_len;
   CK_OBJECT_HANDLE_32     base_key;
   CK_ULONG_32             attribute_count;
   CK_ULONG_32             attribute_block_len;
   // mechanism parameter and things it points to get appended here
   // attributes get appended here
   //
} DeriveKey_Args;


typedef struct _DigestInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} DigestInit_Args;


typedef struct _Digest_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   CK_BBOOL             length_only;
   // data to digest is appended here
   //
} Digest_Args;


typedef struct _DigestUpdate_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   // data to digest is appeneded here
   //
} DigestUpdate_Args;


typedef struct _DigestKey_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
} DigestKey_Args;


typedef struct _DigestFinal_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BBOOL             length_only;
} DigestFinal_Args;


typedef struct _SignInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} SignInit_Args;


typedef struct _Sign_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   CK_BBOOL             length_only;
   // data is appended here
   //
} Sign_Args;


typedef struct _SignUpdate_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   CK_BBOOL             length_only;
   // data is appended here
   //
} SignUpdate_Args;


typedef struct _SignFinal_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BBOOL             length_only;
} SignFinal_Args;


typedef struct _VerifyInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} VerifyInit_Args;


typedef struct _Verify_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   CK_ULONG_32             signature_len;
   // data is appended here
   // signature is appended here
   //
} Verify_Args;


typedef struct _VerifyUpdate_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   // data is appended here
   //
} VerifyUpdate_Args;


typedef struct _VerifyFinal_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             signature_len;
   // signature is appended here
   //
} VerifyFinal_Args;


typedef struct _SignRecoverInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} SignRecoverInit_Args;


typedef struct _SignRecover_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_ULONG_32             data_len;
   CK_BBOOL             length_only;
   // data is appended here
   //
} SignRecover_Args;


typedef struct _VerifyRecoverInit_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     key;
   CK_MECHANISM_TYPE_32    mech_type;
   CK_ULONG_32             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} VerifyRecoverInit_Args;


typedef struct _VerifyRecover_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BBOOL             length_only;
   CK_ULONG_32             signature_len;
   // signature is appended here
   //
} VerifyRecover_Args;


typedef struct _GetOperationState_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_BBOOL             length_only;
} GetOperationState_Args;


typedef struct _SetOperationState_Args
{
   CK_SESSION_HANDLE_32    session_handle;
   CK_OBJECT_HANDLE_32     encr_key;
   CK_OBJECT_HANDLE_32     auth_key;
   CK_ULONG_32             data_len;
   // operation state data is appended here
   //
} SetOperationState_Args;


typedef struct _InitToken_Args
{
   CK_BYTE     label[32];  // must be 32 bytes
   CK_ULONG_32    so_pin_len;
   // SO PIN data is appended here
   //
} InitToken_Args;


#else // !PKCS64

// WJH - here is the original content . . . 


//-------------------------------------------------------------------
//
typedef struct _GetMechList_Args
{
   CK_ULONG  list_length;
   CK_BBOOL  length_only;
} GetMechList_Args;

// C_GetMechanismList reply:
//
// +-----------+------------------------------------+
// | CK_ULONG  | List of CK_MECHANISM_TYPE elements |
// +-----------+------------------------------------+
//

typedef struct _GetMechInfo_Args
{
   CK_MECHANISM_TYPE mech_type;
} GetMechInfo_Args;

typedef struct _InitPIN_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BYTE              pin[MAX_PIN_LEN];
   CK_ULONG             pin_len;
} InitPIN_Args;

typedef struct _SetPIN_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BYTE              old_pin[MAX_PIN_LEN];
   CK_ULONG             old_pin_len;
   CK_BYTE              new_pin[MAX_PIN_LEN];
   CK_ULONG             new_pin_len;
} SetPIN_Args;


typedef struct _OpenSession_Args
{
   CK_SLOT_ID        slot_id;
   CK_FLAGS          flags;
   CK_ULONG       application_ptr;  // not used
   CK_ULONG         notify;           // not used

   //CK_VOID_PTR       application_ptr;  // not used
   //CK_NOTIFY         notify;           // not used
   CK_BBOOL          req_proc_handle;
} OpenSession_Args;

typedef struct _CloseSession_Args
{
   CK_SESSION_HANDLE  session_handle;
} CloseSession_Args;

typedef struct _GetSessionInfo_Args
{
   CK_SESSION_HANDLE  session_handle;
} GetSessionInfo_Args;

typedef struct _Login_Args
{
   CK_SESSION_HANDLE  session_handle;
   CK_USER_TYPE       user_type;
   CK_BYTE            pin[MAX_PIN_LEN];
   CK_ULONG           pin_len;
} Login_Args;

typedef struct _Logout_Args
{
   CK_SESSION_HANDLE  session_handle;
} Logout_Args;

// CreateObject_Args is a bit different.  The attributes themselves
// are passed as a datablock immediately following this structure
//
typedef struct _CreateObject_Args
{
   CK_SESSION_HANDLE   session_handle;
   CK_ULONG            attribute_count;
   CK_ULONG            attribute_block_len;
   // attributes/template gets appended here
   //
} CreateObject_Args;


typedef struct _CopyObject_Args
{
   CK_SESSION_HANDLE   session_handle;
   CK_OBJECT_HANDLE    object_handle;
   CK_ULONG            attribute_count;
   CK_ULONG            attribute_block_len;
   // attributes/template gets appended here
   //
} CopyObject_Args;


typedef struct _DestroyObject_Args
{
   CK_SESSION_HANDLE session_handle;
   CK_OBJECT_HANDLE  object_handle;
} DestroyObject_Args;


typedef struct _GetObjectSize_Args
{
   CK_SESSION_HANDLE  session_handle;
   CK_OBJECT_HANDLE   object_handle;
} GetObjectSize_Args;


typedef struct _GetAttributeValue_Args
{
   CK_SESSION_HANDLE  session_handle;
   CK_OBJECT_HANDLE   object_handle;
   CK_ULONG           attribute_count;
   CK_ULONG           attribute_block_len;
   CK_BBOOL           size_only;
   // list of attribute types (CK_ATTRIBUTE_TYPE) gets appended here.
   //
} GetAttributeValue_Args;


typedef struct _SetAttributeValue_Args
{
   CK_SESSION_HANDLE  session_handle;
   CK_OBJECT_HANDLE   object_handle;
   CK_ULONG           attribute_count;
   CK_ULONG           attribute_block_len;
   // attribute template gets appended here
   //
} SetAttributeValue_Args;


typedef struct _FindObjectsInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             attribute_count;
   CK_ULONG             attribute_block_len;
   // attribute template gets appended here
   //
} FindObjectsInit_Args;


typedef struct _FindObjects_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             max_count;
} FindObjects_Args;


typedef struct _FindObjectsFinal_Args
{
   CK_SESSION_HANDLE    session_handle;
} FindObjectsFinal_Args;


typedef struct _GenerateRandom_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             num_bytes;
} GenerateRandom_Args;


typedef struct _GenerateKey_Args
{
   CK_SESSION_HANDLE   session_handle;
   CK_MECHANISM_TYPE   mech_type;
   CK_ULONG            mech_param_len;
   CK_ULONG            attribute_count;
   CK_ULONG            attribute_block_len;
   // mechanism parameter gets appended here
   // attributes get appended here
   //
} GenerateKey_Args;


typedef struct _GenKeyPair_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             mech_param_len;
   CK_ULONG             publ_key_attr_count;   // # of attributes
   CK_ULONG             publ_key_tmpl_len;     // overall template length
   CK_ULONG             priv_key_attr_count;   // # of attributes
   CK_ULONG             priv_key_tmpl_len;     // overall template length
   // the mechanism parameter is appended here
   // the public key template is appended here
   // the private key template is appended here
   //
} GenKeyPair_Args;


typedef struct _EncryptInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} EncryptInit_Args;


typedef struct _Encrypt_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             cleartext_len;
   CK_BBOOL             length_only;
   // cleartext is appended here
   //
} Encrypt_Args;


typedef struct _EncryptUpdate_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             cleartext_len;
   CK_BBOOL             length_only;
   // cleartext is appended here
   //
} EncryptUpdate_Args;


typedef struct _EncryptFinal_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BBOOL             length_only;
} EncryptFinal_Args;


typedef struct _DecryptInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} DecryptInit_Args;


typedef struct _Decrypt_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             ciphertext_len;
   CK_BBOOL             length_only;
   // ciphertext is appended here
   //
} Decrypt_Args;


typedef struct _DecryptUpdate_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             ciphertext_len;
   CK_BBOOL             length_only;
   // ciphertext is appended here
   //
} DecryptUpdate_Args;


typedef struct _DecryptFinal_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BBOOL             length_only;
} DecryptFinal_Args;


typedef struct _WrapKey_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             mech_param_len;
   CK_OBJECT_HANDLE     wrapping_key;
   CK_OBJECT_HANDLE     key;             // key to be wrapped
   CK_BBOOL             length_only;
   // mechanism parameter (if any) is appended here
   //
} WrapKey_Args;


typedef struct _UnWrapKey_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             mech_param_len;
   CK_OBJECT_HANDLE     unwrapping_key;
   CK_ULONG             wrapped_key_len;
   CK_ULONG             attribute_count;
   CK_ULONG             attribute_block_len;
   // mechanism parameter appended here      (mech_param_len bytes     )
   // wrapped key appended here              (wrapped_key_len bytes    )
   // attributes appended here               (attribute_block_len bytes)
   //
} UnWrapKey_Args;



typedef struct _DeriveKey_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             mech_param_len;
   CK_OBJECT_HANDLE     base_key;
   CK_ULONG             attribute_count;
   CK_ULONG             attribute_block_len;
   // mechanism parameter and things it points to get appended here
   // attributes get appended here
   //
} DeriveKey_Args;


typedef struct _DigestInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} DigestInit_Args;


typedef struct _Digest_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   CK_BBOOL             length_only;
   // data to digest is appended here
   //
} Digest_Args;


typedef struct _DigestUpdate_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   // data to digest is appeneded here
   //
} DigestUpdate_Args;


typedef struct _DigestKey_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
} DigestKey_Args;


typedef struct _DigestFinal_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BBOOL             length_only;
} DigestFinal_Args;


typedef struct _SignInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} SignInit_Args;


typedef struct _Sign_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   CK_BBOOL             length_only;
   // data is appended here
   //
} Sign_Args;


typedef struct _SignUpdate_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   CK_BBOOL             length_only;
   // data is appended here
   //
} SignUpdate_Args;


typedef struct _SignFinal_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BBOOL             length_only;
} SignFinal_Args;


typedef struct _VerifyInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} VerifyInit_Args;


typedef struct _Verify_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   CK_ULONG             signature_len;
   // data is appended here
   // signature is appended here
   //
} Verify_Args;


typedef struct _VerifyUpdate_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   // data is appended here
   //
} VerifyUpdate_Args;


typedef struct _VerifyFinal_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             signature_len;
   // signature is appended here
   //
} VerifyFinal_Args;


typedef struct _SignRecoverInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} SignRecoverInit_Args;


typedef struct _SignRecover_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_ULONG             data_len;
   CK_BBOOL             length_only;
   // data is appended here
   //
} SignRecover_Args;


typedef struct _VerifyRecoverInit_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     key;
   CK_MECHANISM_TYPE    mech_type;
   CK_ULONG             param_len;     // length of parameter in bytes
   // mechanism parameter (if any) is appended here
   //
} VerifyRecoverInit_Args;


typedef struct _VerifyRecover_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BBOOL             length_only;
   CK_ULONG             signature_len;
   // signature is appended here
   //
} VerifyRecover_Args;


typedef struct _GetOperationState_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_BBOOL             length_only;
} GetOperationState_Args;


typedef struct _SetOperationState_Args
{
   CK_SESSION_HANDLE    session_handle;
   CK_OBJECT_HANDLE     encr_key;
   CK_OBJECT_HANDLE     auth_key;
   CK_ULONG             data_len;
   // operation state data is appended here
   //
} SetOperationState_Args;


typedef struct _InitToken_Args
{
   CK_BYTE     label[32];  // must be 32 bytes
   CK_ULONG    so_pin_len;
   // SO PIN data is appended here
   //
} InitToken_Args;



#endif // PKCS64


#if (LEEDS_BUILD)

#pragma pack()
#pragma options align=full
#endif

#endif
