import random

from twisted.application import service
from twisted.application import internet

from nevow import appserver
from nevow import loaders
from nevow import rend


class Table(rend.Page):

    # addSlash is used to automatically ad a slash at the end of each url
    # http://localhost:8080/foo -> http://localhost:8080/foo/
    addSlash = True
    docFactory = loaders.xmlfile('tablehtml.html')

    def data_theList(self, context, data):
        return [(x, random.randint(0, 5000)) for x in range(random.randint(0, 10))]
        
    def render_row(self, context, data):
        context.fillSlots('first_column', data[0])
        context.fillSlots('second_column', data[1])
        return context.tag

application = service.Application("tables")
internet.TCPServer(
    8080, 
    appserver.NevowSite(
        Table()
    )
).setServiceParent(application)