/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.DefaultNioSocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.util.internal.LinkedTransferQueue;
import org.jboss.netty.util.internal.ThreadLocalBoolean;

class NioSocketChannel
extends AbstractChannel
implements SocketChannel {
    final java.nio.channels.SocketChannel socket;
    final NioWorker worker;
    private final NioSocketChannelConfig config;
    final Object interestOpsLock = new Object();
    final Object writeLock = new Object();
    final Runnable writeTask = new WriteTask();
    final AtomicBoolean writeTaskInTaskQueue = new AtomicBoolean();
    final Queue<MessageEvent> writeBuffer = new WriteBuffer();
    final AtomicInteger writeBufferSize = new AtomicInteger();
    final AtomicInteger highWaterMarkCounter = new AtomicInteger();
    volatile boolean inWriteNowLoop;
    MessageEvent currentWriteEvent;
    int currentWriteIndex;

    public NioSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, java.nio.channels.SocketChannel socket, NioWorker worker) {
        super(parent, factory, pipeline, sink);
        this.socket = socket;
        this.worker = worker;
        this.config = new DefaultNioSocketChannelConfig(socket.socket());
    }

    public NioSocketChannelConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getLocalAddress() {
        try {
            return (InetSocketAddress)this.socket.socket().getLocalSocketAddress();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public InetSocketAddress getRemoteAddress() {
        try {
            return (InetSocketAddress)this.socket.socket().getRemoteSocketAddress();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean isBound() {
        return this.isOpen() && this.socket.socket().isBound();
    }

    public boolean isConnected() {
        return this.isOpen() && this.socket.socket().isConnected();
    }

    public int getInterestOps() {
        int highWaterMark;
        int lowWaterMark;
        if (!this.isOpen()) {
            return 4;
        }
        int interestOps = this.getRawInterestOps();
        int writeBufferSize = this.writeBufferSize.get();
        interestOps = writeBufferSize != 0 ? (this.highWaterMarkCounter.get() > 0 ? (writeBufferSize >= (lowWaterMark = this.getConfig().getWriteBufferLowWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB)) : (writeBufferSize >= (highWaterMark = this.getConfig().getWriteBufferHighWaterMark()) ? (interestOps |= 4) : (interestOps &= 0xFFFFFFFB))) : (interestOps &= 0xFFFFFFFB);
        return interestOps;
    }

    int getRawInterestOps() {
        return super.getInterestOps();
    }

    void setRawInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return this.getUnsupportedOperationFuture();
    }

    private final class WriteTask
    implements Runnable {
        WriteTask() {
        }

        public void run() {
            NioSocketChannel.this.writeTaskInTaskQueue.set(false);
            NioWorker.write(NioSocketChannel.this, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WriteBuffer
    extends LinkedTransferQueue<MessageEvent> {
        private final ThreadLocalBoolean notifying = new ThreadLocalBoolean();

        WriteBuffer() {
        }

        @Override
        public boolean offer(MessageEvent e) {
            int highWaterMark;
            boolean success = super.offer(e);
            assert (success);
            int messageSize = ((ChannelBuffer)e.getMessage()).readableBytes();
            int newWriteBufferSize = NioSocketChannel.this.writeBufferSize.addAndGet(messageSize);
            if (newWriteBufferSize >= (highWaterMark = NioSocketChannel.this.getConfig().getWriteBufferHighWaterMark()) && newWriteBufferSize - messageSize < highWaterMark) {
                NioSocketChannel.this.highWaterMarkCounter.incrementAndGet();
                if (!((Boolean)this.notifying.get()).booleanValue()) {
                    this.notifying.set(Boolean.TRUE);
                    Channels.fireChannelInterestChanged(NioSocketChannel.this);
                    this.notifying.set(Boolean.FALSE);
                }
            }
            return true;
        }

        @Override
        public MessageEvent poll() {
            MessageEvent e = (MessageEvent)super.poll();
            if (e != null) {
                int messageSize = ((ChannelBuffer)e.getMessage()).readableBytes();
                int newWriteBufferSize = NioSocketChannel.this.writeBufferSize.addAndGet(-messageSize);
                int lowWaterMark = NioSocketChannel.this.getConfig().getWriteBufferLowWaterMark();
                if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && newWriteBufferSize + messageSize >= lowWaterMark) {
                    NioSocketChannel.this.highWaterMarkCounter.decrementAndGet();
                    if (!((Boolean)this.notifying.get()).booleanValue()) {
                        this.notifying.set(Boolean.TRUE);
                        Channels.fireChannelInterestChanged(NioSocketChannel.this);
                        this.notifying.set(Boolean.FALSE);
                    }
                }
            }
            return e;
        }
    }
}

