/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.SystemPropertyUtil;

class NioProviderMetadata {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioProviderMetadata.class);
    private static final String CONSTRAINT_LEVEL_PROPERTY = "java.nio.channels.spi.constraintLevel";
    private static final long AUTODETECTION_TIMEOUT = 7000L;
    static final int CONSTRAINT_LEVEL;

    NioProviderMetadata() {
    }

    private static int detectConstraintLevelFromSystemProperties() {
        String provider;
        String version = SystemPropertyUtil.get("java.specification.version");
        String os = SystemPropertyUtil.get("os.name");
        String vendor = SystemPropertyUtil.get("java.vm.vendor");
        try {
            provider = SelectorProvider.provider().getClass().getName();
        }
        catch (Exception e) {
            provider = null;
        }
        if (version == null || os == null || vendor == null || provider == null) {
            return -1;
        }
        os = os.toLowerCase();
        if ((vendor = vendor.toLowerCase()).indexOf("sun") >= 0) {
            if (os.indexOf("linux") >= 0 ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : (os.indexOf("windows") >= 0 ? provider.equals("sun.nio.ch.WindowsSelectorProvider") : (os.indexOf("sun") >= 0 || os.indexOf("solaris") >= 0) && provider.equals("sun.nio.ch.DevPollSelectorProvider"))) {
                return 0;
            }
        } else if (vendor.indexOf("apple") >= 0) {
            if (os.indexOf("mac") >= 0 && os.indexOf("os") >= 0 && provider.equals("sun.nio.ch.KQueueSelectorProvider")) {
                return 0;
            }
        } else if (vendor.indexOf("ibm") >= 0) {
            if (os.indexOf("linux") >= 0 && (version.equals("1.5") || version.matches("^1\\.5\\D.*$")) && provider.equals("sun.nio.ch.PollSelectorProvider")) {
                return 1;
            }
            if (os.indexOf("aix") >= 0 && (version.equals("1.5") || version.matches("^1\\.5\\D.*$")) && provider.equals("sun.nio.ch.PollSelectorProvider")) {
                return 1;
            }
        } else if ((vendor.indexOf("bea") >= 0 || vendor.indexOf("oracle") >= 0) && (os.indexOf("linux") >= 0 ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : os.indexOf("windows") >= 0 && provider.equals("sun.nio.ch.WindowsSelectorProvider"))) {
            return 0;
        }
        return -1;
    }

    static {
        int constraintLevel = -1;
        try {
            String value = SystemPropertyUtil.get(CONSTRAINT_LEVEL_PROPERTY, "-1");
            constraintLevel = Integer.parseInt(value);
            if (constraintLevel < 0 || constraintLevel > 2) {
                constraintLevel = -1;
            } else {
                logger.debug("Using the specified NIO constraint level: " + constraintLevel);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (constraintLevel < 0) {
            constraintLevel = NioProviderMetadata.detectConstraintLevelFromSystemProperties();
            if (constraintLevel < 0) {
                logger.debug("Couldn't get the NIO constraint level from the system properties.");
                ConstraintLevelAutodetector autodetector = new ConstraintLevelAutodetector();
                try {
                    constraintLevel = autodetector.autodetectWithTimeout();
                }
                catch (Exception e) {
                    constraintLevel = autodetector.autodetectWithoutTimeout();
                }
            }
            if (constraintLevel < 0) {
                constraintLevel = 2;
                logger.warn("Failed to autodetect the NIO constraint level; using the safest level (2)");
            } else if (constraintLevel != 0) {
                logger.info("Using the autodetected NIO constraint level: " + constraintLevel + " (Use better NIO provider for better performance)");
            } else {
                logger.debug("Using the autodetected NIO constraint level: " + constraintLevel);
            }
        }
        if ((CONSTRAINT_LEVEL = constraintLevel) < 0 || CONSTRAINT_LEVEL > 2) {
            throw new Error("Unexpected NIO constraint level: " + CONSTRAINT_LEVEL + ", please report this error.");
        }
    }

    private static final class SelectorLoop
    implements Runnable {
        final Selector selector = Selector.open();
        volatile boolean done;
        volatile boolean selecting;

        SelectorLoop() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.done) {
                SelectorLoop selectorLoop = this;
                synchronized (selectorLoop) {
                }
                try {
                    Object var4_7;
                    this.selecting = true;
                    try {
                        this.selector.select(1000L);
                        var4_7 = null;
                        this.selecting = false;
                    }
                    catch (Throwable throwable) {
                        var4_7 = null;
                        this.selecting = false;
                        throw throwable;
                    }
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    for (SelectionKey k : keys) {
                        k.interestOps(0);
                    }
                    keys.clear();
                }
                catch (IOException e) {
                    logger.warn("Failed to wait for a temporary selector.", e);
                }
            }
        }
    }

    private static final class ConstraintLevelAutodetector {
        ConstraintLevelAutodetector() {
        }

        int autodetectWithTimeout() {
            final LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
            ThreadRenamingRunnable detector = new ThreadRenamingRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int level = -1;
                    try {
                        level = ConstraintLevelAutodetector.this.autodetectWithoutTimeout();
                    }
                    finally {
                        boolean finished = resultQueue.offer(level);
                        assert (finished);
                    }
                }
            }, "NIO constraint level detector");
            Thread detectorThread = new Thread(detector);
            detectorThread.start();
            while (true) {
                try {
                    Integer result = (Integer)resultQueue.poll(7000L, TimeUnit.MILLISECONDS);
                    if (result == null) {
                        logger.warn("NIO constraint level autodetection timed out.");
                        return -1;
                    }
                    return result;
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        int autodetectWithoutTimeout() {
            int constraintLevel;
            block101: {
                Throwable e3222222222;
                SelectorLoop loop;
                ServerSocketChannel ch;
                ExecutorService executor;
                block93: {
                    block92: {
                        long startTime;
                        int i;
                        executor = Executors.newCachedThreadPool();
                        ch = null;
                        loop = null;
                        ch = ServerSocketChannel.open();
                        try {
                            ch.socket().bind(new InetSocketAddress(0));
                            ch.configureBlocking(false);
                        }
                        catch (Throwable e2) {
                            Throwable e3222222222;
                            logger.warn("Failed to configure a temporary socket.", e2);
                            int n = -1;
                            Object var14_14 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                            return n;
                        }
                        try {
                            loop = new SelectorLoop();
                        }
                        catch (Throwable e4) {
                            Throwable e3222222222;
                            logger.warn("Failed to open a temporary selector.", e4);
                            int n = -1;
                            Object var14_15 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                            return n;
                        }
                        try {
                            ch.register(loop.selector, 0);
                        }
                        catch (Throwable e5) {
                            Throwable e3222222222;
                            logger.warn("Failed to register a temporary selector.", e5);
                            int n = -1;
                            Object var14_16 = null;
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary socket.", e3222222222);
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3222222222) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e3222222222) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e3222222222) {
                                    logger.warn("Failed to close a temporary selector.", e3222222222);
                                }
                            }
                            return n;
                        }
                        SelectionKey key = ch.keyFor(loop.selector);
                        executor.execute(loop);
                        boolean success = true;
                        for (i = 0; i < 10; ++i) {
                            while (true) {
                                if (!loop.selecting) {
                                    Thread.yield();
                                    continue;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e6) {
                                    // empty catch block
                                }
                                if (loop.selecting) break;
                            }
                            startTime = System.nanoTime();
                            key.interestOps(key.interestOps() | 0x10);
                            key.interestOps(key.interestOps() & 0xFFFFFFEF);
                            if (System.nanoTime() - startTime < 500000000L) continue;
                            success = false;
                            break;
                        }
                        if (success) {
                            constraintLevel = 0;
                            break block92;
                        }
                        success = true;
                        for (i = 0; i < 10; ++i) {
                            while (true) {
                                if (!loop.selecting) {
                                    Thread.yield();
                                    continue;
                                }
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException e7) {
                                    // empty catch block
                                }
                                if (loop.selecting) break;
                            }
                            startTime = System.nanoTime();
                            int interestOps = key.interestOps();
                            SelectorLoop selectorLoop = loop;
                            synchronized (selectorLoop) {
                                loop.selector.wakeup();
                                key.interestOps(interestOps | 0x10);
                                key.interestOps(interestOps & 0xFFFFFFEF);
                            }
                            if (System.nanoTime() - startTime < 500000000L) continue;
                            success = false;
                            break;
                        }
                        if (success) {
                            constraintLevel = 1;
                            break block92;
                        }
                        constraintLevel = 2;
                    }
                    Object var14_17 = null;
                    if (ch == null) break block93;
                    try {
                        ch.close();
                    }
                    catch (Throwable e3222222222) {
                        logger.warn("Failed to close a temporary socket.", e3222222222);
                    }
                }
                if (loop != null) {
                    loop.done = true;
                    try {
                        executor.shutdownNow();
                    }
                    catch (NullPointerException ex) {
                        // empty catch block
                    }
                    try {
                        while (true) {
                            loop.selector.wakeup();
                            try {
                                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                            }
                            catch (InterruptedException e3222222222) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable e3222222222) {
                        // empty catch block
                    }
                    try {
                        loop.selector.close();
                    }
                    catch (Throwable e3222222222) {
                        logger.warn("Failed to close a temporary selector.", e3222222222);
                    }
                }
                break block101;
                {
                    catch (Throwable e8) {
                        Throwable e3222222222;
                        int n = -1;
                        Object var14_18 = null;
                        if (ch != null) {
                            try {
                                ch.close();
                            }
                            catch (Throwable e3222222222) {
                                logger.warn("Failed to close a temporary socket.", e3222222222);
                            }
                        }
                        if (loop != null) {
                            loop.done = true;
                            try {
                                executor.shutdownNow();
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            try {
                                while (true) {
                                    loop.selector.wakeup();
                                    try {
                                        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                    }
                                    catch (InterruptedException e3222222222) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e3222222222) {
                                // empty catch block
                            }
                            try {
                                loop.selector.close();
                            }
                            catch (Throwable e3222222222) {
                                logger.warn("Failed to close a temporary selector.", e3222222222);
                            }
                        }
                        return n;
                    }
                }
                catch (Throwable throwable) {
                    Throwable e3222222222;
                    Object var14_19 = null;
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable e3222222222) {
                            logger.warn("Failed to close a temporary socket.", e3222222222);
                        }
                    }
                    if (loop != null) {
                        loop.done = true;
                        try {
                            executor.shutdownNow();
                        }
                        catch (NullPointerException ex) {
                            // empty catch block
                        }
                        try {
                            while (true) {
                                loop.selector.wakeup();
                                try {
                                    if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                }
                                catch (InterruptedException e3222222222) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable e3222222222) {
                            // empty catch block
                        }
                        try {
                            loop.selector.close();
                        }
                        catch (Throwable e3222222222) {
                            logger.warn("Failed to close a temporary selector.", e3222222222);
                        }
                    }
                    throw throwable;
                }
            }
            return constraintLevel;
        }
    }
}

