/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.http.HttpTunnelingChannelHandler;

public class HttpTunnelingServlet
extends HttpServlet {
    private static final long serialVersionUID = -872309493835745385L;
    static final String CHANNEL_PROP = "channel";
    static final String HANDLER_PROP = "handler";

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Channel channel = (Channel)session.getAttribute(CHANNEL_PROP);
        HttpTunnelingChannelHandler handler = (HttpTunnelingChannelHandler)session.getAttribute(HANDLER_PROP);
        if (handler.isStreaming()) {
            this.streamResponse(request, response, session, handler, channel);
        } else {
            this.pollResponse(channel, request, response, session, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamResponse(HttpServletRequest request, HttpServletResponse response, HttpSession session, HttpTunnelingChannelHandler handler, Channel channel) throws IOException {
        block6: {
            try {
                response.setHeader("JSESSIONID", session.getId());
                response.setHeader("Content-Type", "application/octet-stream");
                response.setStatus(200);
                response.getOutputStream().flush();
                handler.setOutputStream(response.getOutputStream());
                PushbackInputStream in = new PushbackInputStream((InputStream)request.getInputStream());
                try {
                    ChannelBuffer buffer;
                    while ((buffer = this.read(in)) != null) {
                        channel.write(buffer);
                    }
                }
                catch (IOException e) {
                }
                Object var9_9 = null;
                if (handler.awaitReconnect()) break block6;
                channel.close();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!handler.awaitReconnect()) {
                    channel.close();
                }
                throw throwable;
            }
            {
            }
        }
    }

    private ChannelBuffer read(PushbackInputStream in) throws IOException {
        int bytesToRead;
        block3: {
            while (true) {
                if ((bytesToRead = in.available()) > 0) break block3;
                if (bytesToRead != 0) break;
                int b = in.read();
                if (b < 0 || in.available() < 0) {
                    return null;
                }
                if (b == 13) {
                    in.read();
                    continue;
                }
                in.unread(b);
            }
            return null;
        }
        byte[] buf = new byte[bytesToRead];
        int readBytes = in.read(buf);
        ChannelBuffer buffer = readBytes == buf.length ? ChannelBuffers.wrappedBuffer(buf) : ChannelBuffers.wrappedBuffer(buf, 0, readBytes);
        return buffer;
    }

    private void pollResponse(Channel channel, HttpServletRequest request, HttpServletResponse response, HttpSession session, HttpTunnelingChannelHandler handler) throws IOException {
        ServletInputStream in = request.getInputStream();
        if (in != null) {
            int writtenBytes;
            ChannelBuffer requestContent = ChannelBuffers.dynamicBuffer();
            while ((writtenBytes = requestContent.writeBytes((InputStream)in, 4096)) >= 0) {
            }
            if (requestContent.readable()) {
                channel.write(requestContent);
            }
        }
        handler.setOutputStream(response.getOutputStream());
        List<MessageEvent> buffers = handler.getAwaitingEvents();
        int length = 0;
        if (buffers.size() > 0) {
            for (MessageEvent buffer : buffers) {
                length += ((ChannelBuffer)buffer.getMessage()).readableBytes();
            }
        }
        response.setHeader("JSESSIONID", session.getId());
        response.setContentLength(length);
        response.setStatus(200);
        for (MessageEvent event : buffers) {
            ChannelBuffer buffer = (ChannelBuffer)event.getMessage();
            byte[] b = new byte[buffer.readableBytes()];
            buffer.readBytes(b);
            try {
                response.getOutputStream().write(b);
                event.getFuture().setSuccess();
            }
            catch (IOException e) {
                event.getFuture().setFailure(e);
            }
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }
}

