/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelPipelineCoverage(value="one")
class HttpTunnelingChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpTunnelingChannelHandler.class);
    private final List<MessageEvent> awaitingEvents = new ArrayList<MessageEvent>();
    private final Lock reconnectLock = new ReentrantLock();
    private final Condition reconnectCondition = this.reconnectLock.newCondition();
    private final long reconnectTimeoutMillis;
    private volatile boolean connected = false;
    private final AtomicBoolean invalidated = new AtomicBoolean(false);
    private volatile ServletOutputStream outputStream;
    private final boolean stream;
    private final HttpSession session;

    public HttpTunnelingChannelHandler(boolean stream, HttpSession session, long reconnectTimeoutMillis) {
        this.stream = stream;
        this.session = session;
        this.reconnectTimeoutMillis = reconnectTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        if (this.stream) {
            boolean success = false;
            Exception cause = null;
            byte[] b = null;
            this.reconnectLock.lock();
            try {
                if (this.outputStream == null) {
                    this.awaitingEvents.add(e);
                    return;
                }
                b = new byte[buffer.readableBytes()];
                buffer.readBytes(b);
                this.outputStream.write(b);
                this.outputStream.flush();
                success = true;
                return;
            }
            catch (Exception ex) {
                success = false;
                cause = ex;
                if (this.awaitReconnect()) {
                    try {
                        this.outputStream.write(b);
                        this.outputStream.flush();
                        success = true;
                    }
                    catch (Exception ex2) {
                        success = false;
                        cause = ex2;
                    }
                }
                this.invalidateHttpSession();
                e.getChannel().close();
            }
            finally {
                this.reconnectLock.unlock();
                if (success) return;
                if ($assertionsDisabled || cause != null) throw cause;
                throw new AssertionError();
            }
        } else {
            this.awaitingEvents.add(e);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.warn("Unexpected exception", e.getCause());
        this.invalidateHttpSession();
        e.getChannel().close();
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.invalidateHttpSession();
    }

    private void invalidateHttpSession() {
        if (this.invalidated.compareAndSet(false, true)) {
            try {
                this.session.invalidate();
            }
            catch (Exception e) {
                logger.debug("Unexpected exception raised by the Servlet container; ignoring.", e);
            }
        }
    }

    synchronized List<MessageEvent> getAwaitingEvents() {
        ArrayList<MessageEvent> list = new ArrayList<MessageEvent>();
        list.addAll(this.awaitingEvents);
        this.awaitingEvents.clear();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOutputStream(ServletOutputStream outputStream) throws IOException {
        this.reconnectLock.lock();
        try {
            this.outputStream = outputStream;
            this.connected = true;
            for (MessageEvent awaitingEvent : this.awaitingEvents) {
                ChannelBuffer buffer = (ChannelBuffer)awaitingEvent.getMessage();
                byte[] b = new byte[buffer.readableBytes()];
                buffer.readBytes(b);
                outputStream.write(b);
                outputStream.flush();
            }
            this.reconnectCondition.signalAll();
        }
        finally {
            this.reconnectLock.unlock();
        }
    }

    boolean isStreaming() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitReconnect() {
        this.reconnectLock.lock();
        try {
            this.connected = false;
            this.reconnectCondition.await(this.reconnectTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.reconnectLock.unlock();
        }
        return this.connected;
    }
}

