/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.http;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannel;

final class HttpTunnelWorker
implements Runnable {
    private final HttpTunnelingClientSocketChannel channel;

    HttpTunnelWorker(HttpTunnelingClientSocketChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.channel.workerThread = Thread.currentThread();
        while (this.channel.isOpen()) {
            byte[] buf;
            Object object = this.channel.interestOpsLock;
            synchronized (object) {
                while (!this.channel.isReadable()) {
                    try {
                        this.channel.interestOpsLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (this.channel.isOpen()) continue;
                        break;
                    }
                }
            }
            try {
                buf = this.channel.receiveChunk();
            }
            catch (Throwable t) {
                if (this.channel.isOpen()) break;
                Channels.fireExceptionCaught(this.channel, t);
                break;
            }
            if (buf == null) continue;
            Channels.fireMessageReceived(this.channel, (Object)ChannelBuffers.wrappedBuffer(this.channel.getConfig().getBufferFactory().getDefaultOrder(), buf));
        }
        this.channel.workerThread = null;
        HttpTunnelWorker.close(this.channel, Channels.succeededFuture(this.channel));
    }

    static void write(HttpTunnelingClientSocketChannel channel, ChannelFuture future, Object message) {
        try {
            ChannelBuffer buf = (ChannelBuffer)message;
            int writtenBytes = channel.sendChunk(buf);
            future.setSuccess();
            Channels.fireWriteComplete(channel, writtenBytes);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(HttpTunnelingClientSocketChannel channel, ChannelFuture future, int interestOps) {
        block9: {
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInterestOpsNow(1);
                    } else {
                        channel.setInterestOpsNow(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block9;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInterestOpsNow(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                Channels.fireChannelInterestChanged(channel);
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
            }
        }
    }

    static void close(HttpTunnelingClientSocketChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.closeSocket();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

