/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef __NL_SIDEBAR_H_
#define __NL_SIDEBAR_H_

#include <glib.h>
#include <clutter/clutter.h>

#include <clutk/clutk.h>

#define NL_TYPE_SIDEBAR (nl_sidebar_get_type ())

#define NL_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_SIDEBAR, NlSidebar))

#define NL_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_SIDEBAR, NlSidebarClass))

#define NL_IS_SIDEBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_SIDEBAR))

#define NL_IS_SIDEBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_SIDEBAR))

#define NL_SIDEBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_SIDEBAR, NlSidebarClass))

typedef struct _NlSidebar        NlSidebar;
typedef struct _NlSidebarClass   NlSidebarClass;
typedef struct _NlSidebarPrivate NlSidebarPrivate;
 
struct _NlSidebar
{
  CtkBox        parent;	

  NlSidebarPrivate *priv;
};

struct _NlSidebarClass
{
  CtkBoxClass   parent_class;
};

GType          nl_sidebar_get_type (void) G_GNUC_CONST;

ClutterActor * nl_sidebar_new      (void);

#endif /* _NL_SIDEBAR_H_ */
