# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200502-08.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(16445);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200502-08");
 script_cve_id("CAN-2005-0227");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200502-08
(PostgreSQL: Local privilege escalation)


    PostgreSQL\'s LOAD extension is vulnerable to a local privilege
    escalation discovered by John Heasman. A local user can load any shared
    library, but the initialization function will then be executed with the
    permissions of the PostgreSQL server.
  
Impact

    A malicious local user could exploit this to execute arbitrary code
    with the privileges of the PostgreSQL server.
  
Workaround

    There is no know workaround at this time.
  
References:
    http://archives.postgresql.org/pgsql-announce/2005-02/msg00000.php
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2005-0227


Solution: 
    All PostgreSQL users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-db/postgresql-7.4.7"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200502-08] PostgreSQL: Local privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PostgreSQL: Local privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/postgresql", unaffected: make_list("rge 7.4.7", "ge 8.0.1"), vulnerable: make_list("lt 8.0.1")
)) { security_warning(0); exit(0); }
