#
# (C) Noam Rathaus GPLv2
#
# Multiple vulnerabilities in MercuryBoard 1.1.1
# "Alberto Trivero" <trivero@jumpy.it>
# 2005-01-24 23:37

if(description)
{
 script_id(16247);
 script_version ("$Revision: 1.3 $");
 script_bugtraq_id(12359); 
 name["english"] = "Multiple Vulnerabilities in MercuryBoard";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running MercuryBoard, a message board system written
in PHP.

Multiple vulnerabilities have been discovered in the product that allow
an attacker to cause numerous cross site scripting attacks, inject
arbitrary SQL statements and disclose the path under which the product
has been installed.

Solution: Upgrade to MercuryBoard version 1.1.2

Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of an old version of mercuryBoard";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Noam Rathaus");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "httpver.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

function check(loc)
{
 req = http_get(item:string(loc, "/index.php"), port:port);
 r = http_keepalive_send_recv(port:port, data:req, bodyonly: 1);
 if( r == NULL )exit(0);

 if ( "Powered by <a href='http://www.mercuryboard.com' class='small'><b>MercuryBoard</b></a>" >< r )
 {
  if ( egrep(pattern:'<b>MercuryBoard</b></a> \\[v(0\\..*|1\\.0\\..*|1\\.1\\.[0-1])\\]', string:r) ) 
  {
   security_warning(port);
   exit(0);
  }
 }
}

foreach dir (make_list("", "/bb", cgi_dirs()))
{
 check(loc:dir);
}

