#TRUSTED 4c02b7c5e60a5f972aae200afa21130166bbe52006f0b65a0f2b9bbece142afa62de7f38a760dc99f001ea3d2e35455ba1311fd9ef67b656458db0c3ac0700a8d836043e125b48441d9575f77ad1c4680c2d57ef0fff875f26b1f54f06a24c4b584dcbacd7f421c611776309428537d6363c596dd02129f657052140a11231885df3e89436cd7c7027f9fb55a60ab391eac6c5cf98c2d7846bdcf70cf6dc1c5b3b480f8ede947ae6b9fa160761cfc437a22ad3765022f722b689f3d0d916db50411170f0e5d1b605f07301d519928128723838756d455ed4035b43003549bb3bba70f81a833aba38053ca5978df87ce3225fd7a5416e564e924de1cab81196988f7e274188e4e78d6be014ea333cc5c8b208930fdfdc59972717afa7e819bded9a2be931424f6d84f372786deb0c0b407896c710919e907a3249b30657a4e00ded712e91328a44d85f97b0bcaeb4c433cee31f29779be09adc342b1eb36ffd65ad493de19786682e684549739f24cd009fb6acaf06750454445ba60a9711dd25e16439ee77aed54b932d3bd752858807de42d7ef0f79e1904b2bb9cfddb7643f4e36f51d54ef704566bee53132cabc16dc1ead1ac5ea5a365fe853f289c3658357ffd3ea26724d198941aa37c45bfcb05dd0e8b47f0eecefd6f33d6f6baaa1a2489b31bdb4958cd2b489742662b6a2f1d48e2bd8fcb5c662f2713a88398787cc
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15870);
 script_version ("1.1");
 name["english"] = "Hydra: Cisco enable";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Cisco 'enable' passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force 'Cisco enable' authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Logon password : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/telnet", 23);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "hydra_cisco.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("Services/telnet");
if (! port) port = 23;
if (! get_port_state(port)) exit(0);
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv(socket: soc, length: 1024);
close(soc);
if ("Password:" >!< r) exit(0);

# Logon password is required
pass = script_get_preference("Logon password : ");
if (! pass)
{
 l = get_kb_list("Hydra/cisco/"+port);
 if (isnull(l)) exit(0);
 foreach pass (l)
   if (! pass)
    break;
 if (! pass) exit(0);
}

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cisco-enable";
argv[i++] = pass;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    # l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: "Hydra/cisco-enable/"+port, value: p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following Cisco enable passwords:\n' + report);
