#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#

if (description) {
script_id(14306);
script_bugtraq_id(5065);


# script_cve_id("CVE-MAP-NOMATCH");
# NOTE: no CVE id assigned (gat, August 2004)
  script_version ("$Revision: 1.7 $"); 
  name["english"] = "BasiliX Attachment Disclosure Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
The target is running at least one instance of BasiliX whose version
number is 1.1.0 or lower.  Such versions save attachments by default
under /tmp/BasiliX, which is world-readable and apparently never emptied
by BasiliX itself.  As a result, anyone with shell access to the target
or who can place CGI files on it can access attachments uploaded to
BasiliX. 

***** Nessus has determined the vulnerability exists on the target
***** simply by looking at the version number(s) of BasiliX
***** installed there.

Solution : Upgrade to BasiliX version 1.1.1 or later.
Risk factor : Low";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for Attachment Disclosure Vulnerability in BasiliX";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 George A. Theall");

  family["english"] = "Misc.";
  script_family(english:family["english"]);

  script_dependencie("basilix_detect.nasl", "global_settings.nasl");
  script_require_ports("services/www", 80);

  exit(0);
}

include("global_settings.inc");
include("http_func.inc");

host = get_host_name();
port = get_http_port(default:80);
if (debug_level) display("debug: searching for Attachment Disclosure vulnerability in BasiliX on ", host, ":", port, ".\n");

if (!get_port_state(port)) exit(0);

# Check each installed instance, stopping if we find a vulnerability.
installs = get_kb_list(string("www/", port, "/basilix"));
if (isnull(installs)) exit(0);
foreach install (installs) {
  matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
  if (!isnull(matches)) {
    ver = matches[1];
    dir = matches[2];
    if (debug_level) display("debug: checking version ", ver, " under ", dir, ".\n");

    if (ereg(pattern:"^(0\..*|1\.0.*|1\.1\.0)$", string:ver)) {
      security_warning(port);
      exit(0);
    }
  }
}
