 * Program: System uptime plugin for NetSaint
 * License: GPL
 * Copyright (c) 1999 Adam G. Bowen (agbowen@bealenet.com)
 *
 * Description:
 *
 * This plugin will check the system uptime on the remote host at ipaddress and
 * generate an alert if the uptime is above the <max_up> value or if
 * (<weekend_boot> = Y) and ((max_up - uptime) < 7) and ((today = Saturday) or
 * (today = Sunday)).
 *
 * Other errors result in a STATE_UNKNOWN return.
 *
 * Command line:
 *
 * check_boot ipaddress sys_type
 * check_boot ipaddress sys_type <weekend_boot>
 * check_boot ipaddress sys_type <weekend_boot> <max_up>
 *
 * Required input:
 *
 * ipaddress = The ipaddress of the remote system to run the check on.
 * sys_type = The remote system type.
 *
 * Optional input:
 *
 * <weekend_boot> = Should this system only be rebooted on the weekend.
 * <max_up> = Number of days up required to return a CRITICAL state.
 *
 * Notes:
 *
 * If <weekend_boot> and <max_up> are not passed on the command line, they will
 * be set to the default values in the check_boot config file.
 *
 * If <weekend_boot> is passed on the command line, and <max_up> is not,
 * <max_up> will be set to the default value in the check_boot config file.
 *
 * sys_type is used to determine which config file to use to generate the
 * remote command.
 *
 * The configuration file /usr/local/netsaint/config/check_boot/local
 * contains the following values:
 *
 * RSH_COMMAND|<location of rsh command on netsaint system>|
 * CUT_COMMAND|<location of cut command on netsaint system>|
 * WEEKEND_BOOT|<should check system only be booted on the weekend>|
 * MAX_UP|<max days between reboot>|
 *
 * The configuration file /usr/local/netsaint/config/check_boot/<sys_type>
 * contains the following values:
 *
 * UPTIME_COMMAND|<location of uptime command on system sys_type>|
 * CUT_OPTIONS|<options for cut command to retrieve required info>|
