/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse MYSQLparse
#define yylex   MYSQLlex
#define yyerror MYSQLerror
#define yylval  MYSQLlval
#define yychar  MYSQLchar
#define yydebug MYSQLdebug
#define yynerrs MYSQLnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     END_OF_INPUT = 258,
     ABORT_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     ATAN = 277,
     AUTO_INC = 278,
     AVG_ROW_LENGTH = 279,
     AVG_SYM = 280,
     BACKUP_SYM = 281,
     BEFORE_SYM = 282,
     BEGIN_SYM = 283,
     BENCHMARK_SYM = 284,
     BERKELEY_DB_SYM = 285,
     BIGINT = 286,
     BINARY = 287,
     BINLOG_SYM = 288,
     BIN_NUM = 289,
     BIT_AND = 290,
     BIT_OR = 291,
     BIT_SYM = 292,
     BIT_XOR = 293,
     BLOB_SYM = 294,
     BOOLEAN_SYM = 295,
     BOOL_SYM = 296,
     BOTH = 297,
     BTREE_SYM = 298,
     BY = 299,
     BYTE_SYM = 300,
     CACHE_SYM = 301,
     CALL_SYM = 302,
     CASCADE = 303,
     CASCADED = 304,
     CAST_SYM = 305,
     CHAIN_SYM = 306,
     CHANGE = 307,
     CHANGED = 308,
     CHARSET = 309,
     CHAR_SYM = 310,
     CHECKSUM_SYM = 311,
     CHECK_SYM = 312,
     CIPHER_SYM = 313,
     CLIENT_SYM = 314,
     CLOSE_SYM = 315,
     COALESCE = 316,
     CODE_SYM = 317,
     COLLATE_SYM = 318,
     COLLATION_SYM = 319,
     COLUMNS = 320,
     COLUMN_SYM = 321,
     COMMENT_SYM = 322,
     COMMITTED_SYM = 323,
     COMMIT_SYM = 324,
     COMPACT_SYM = 325,
     COMPRESSED_SYM = 326,
     CONCAT = 327,
     CONCAT_WS = 328,
     CONCURRENT = 329,
     CONDITION_SYM = 330,
     CONNECTION_SYM = 331,
     CONSISTENT_SYM = 332,
     CONSTRAINT = 333,
     CONTAINS_SYM = 334,
     CONTINUE_SYM = 335,
     CONVERT_SYM = 336,
     CONVERT_TZ_SYM = 337,
     COUNT_SYM = 338,
     CREATE = 339,
     CROSS = 340,
     CUBE_SYM = 341,
     CURDATE = 342,
     CURRENT_USER = 343,
     CURSOR_SYM = 344,
     CURTIME = 345,
     DATABASE = 346,
     DATABASES = 347,
     DATA_SYM = 348,
     DATETIME = 349,
     DATE_ADD_INTERVAL = 350,
     DATE_SUB_INTERVAL = 351,
     DATE_SYM = 352,
     DAY_HOUR_SYM = 353,
     DAY_MICROSECOND_SYM = 354,
     DAY_MINUTE_SYM = 355,
     DAY_SECOND_SYM = 356,
     DAY_SYM = 357,
     DEALLOCATE_SYM = 358,
     DECIMAL_NUM = 359,
     DECIMAL_SYM = 360,
     DECLARE_SYM = 361,
     DECODE_SYM = 362,
     DEFAULT = 363,
     DEFINER_SYM = 364,
     DELAYED_SYM = 365,
     DELAY_KEY_WRITE_SYM = 366,
     DELETE_SYM = 367,
     DESC = 368,
     DESCRIBE = 369,
     DES_DECRYPT_SYM = 370,
     DES_ENCRYPT_SYM = 371,
     DES_KEY_FILE = 372,
     DETERMINISTIC_SYM = 373,
     DIRECTORY_SYM = 374,
     DISABLE_SYM = 375,
     DISCARD = 376,
     DISTINCT = 377,
     DIV_SYM = 378,
     DOUBLE_SYM = 379,
     DO_SYM = 380,
     DROP = 381,
     DUAL_SYM = 382,
     DUMPFILE = 383,
     DUPLICATE_SYM = 384,
     DYNAMIC_SYM = 385,
     EACH_SYM = 386,
     ELSEIF_SYM = 387,
     ELT_FUNC = 388,
     ENABLE_SYM = 389,
     ENCLOSED = 390,
     ENCODE_SYM = 391,
     ENCRYPT = 392,
     END = 393,
     ENGINES_SYM = 394,
     ENGINE_SYM = 395,
     ENUM = 396,
     EQ = 397,
     EQUAL_SYM = 398,
     ERRORS = 399,
     ESCAPED = 400,
     ESCAPE_SYM = 401,
     EVENTS_SYM = 402,
     EXECUTE_SYM = 403,
     EXISTS = 404,
     EXIT_SYM = 405,
     EXPANSION_SYM = 406,
     EXPORT_SET = 407,
     EXTENDED_SYM = 408,
     EXTRACT_SYM = 409,
     FALSE_SYM = 410,
     FAST_SYM = 411,
     FETCH_SYM = 412,
     FIELD_FUNC = 413,
     FILE_SYM = 414,
     FIRST_SYM = 415,
     FIXED_SYM = 416,
     FLOAT_NUM = 417,
     FLOAT_SYM = 418,
     FLUSH_SYM = 419,
     FORCE_SYM = 420,
     FOREIGN = 421,
     FORMAT_SYM = 422,
     FOR_SYM = 423,
     FOUND_SYM = 424,
     FRAC_SECOND_SYM = 425,
     FROM = 426,
     FROM_UNIXTIME = 427,
     FULL = 428,
     FULLTEXT_SYM = 429,
     FUNCTION_SYM = 430,
     FUNC_ARG0 = 431,
     FUNC_ARG1 = 432,
     FUNC_ARG2 = 433,
     FUNC_ARG3 = 434,
     GE = 435,
     GEOMCOLLFROMTEXT = 436,
     GEOMETRYCOLLECTION = 437,
     GEOMETRY_SYM = 438,
     GEOMFROMTEXT = 439,
     GEOMFROMWKB = 440,
     GET_FORMAT = 441,
     GLOBAL_SYM = 442,
     GRANT = 443,
     GRANTS = 444,
     GREATEST_SYM = 445,
     GROUP = 446,
     GROUP_CONCAT_SYM = 447,
     GROUP_UNIQUE_USERS = 448,
     GT_SYM = 449,
     HANDLER_SYM = 450,
     HASH_SYM = 451,
     HAVING = 452,
     HELP_SYM = 453,
     HEX_NUM = 454,
     HIGH_PRIORITY = 455,
     HOSTS_SYM = 456,
     HOUR_MICROSECOND_SYM = 457,
     HOUR_MINUTE_SYM = 458,
     HOUR_SECOND_SYM = 459,
     HOUR_SYM = 460,
     IDENT = 461,
     IDENTIFIED_SYM = 462,
     IDENT_QUOTED = 463,
     IF = 464,
     IGNORE_SYM = 465,
     IMPORT = 466,
     INDEXES = 467,
     INDEX_SYM = 468,
     INFILE = 469,
     INNER_SYM = 470,
     INNOBASE_SYM = 471,
     INOUT_SYM = 472,
     INSENSITIVE_SYM = 473,
     INSERT = 474,
     INSERT_METHOD = 475,
     INTERVAL_SYM = 476,
     INTO = 477,
     INT_SYM = 478,
     INVOKER_SYM = 479,
     IN_SYM = 480,
     IS = 481,
     ISOLATION = 482,
     ISSUER_SYM = 483,
     ITERATE_SYM = 484,
     JOIN_SYM = 485,
     KEYS = 486,
     KEY_SYM = 487,
     KILL_SYM = 488,
     LABEL_SYM = 489,
     LANGUAGE_SYM = 490,
     LAST_INSERT_ID = 491,
     LAST_SYM = 492,
     LE = 493,
     LEADING = 494,
     LEAST_SYM = 495,
     LEAVES = 496,
     LEAVE_SYM = 497,
     LEFT = 498,
     LEVEL_SYM = 499,
     LEX_HOSTNAME = 500,
     LIKE = 501,
     LIMIT = 502,
     LINEFROMTEXT = 503,
     LINES = 504,
     LINESTRING = 505,
     LOAD = 506,
     LOCAL_SYM = 507,
     LOCATE = 508,
     LOCATOR_SYM = 509,
     LOCKS_SYM = 510,
     LOCK_SYM = 511,
     LOGS_SYM = 512,
     LOG_SYM = 513,
     LONGBLOB = 514,
     LONGTEXT = 515,
     LONG_NUM = 516,
     LONG_SYM = 517,
     LOOP_SYM = 518,
     LOW_PRIORITY = 519,
     LT = 520,
     MAKE_SET_SYM = 521,
     MASTER_CONNECT_RETRY_SYM = 522,
     MASTER_HOST_SYM = 523,
     MASTER_LOG_FILE_SYM = 524,
     MASTER_LOG_POS_SYM = 525,
     MASTER_PASSWORD_SYM = 526,
     MASTER_PORT_SYM = 527,
     MASTER_POS_WAIT = 528,
     MASTER_SERVER_ID_SYM = 529,
     MASTER_SSL_CAPATH_SYM = 530,
     MASTER_SSL_CA_SYM = 531,
     MASTER_SSL_CERT_SYM = 532,
     MASTER_SSL_CIPHER_SYM = 533,
     MASTER_SSL_KEY_SYM = 534,
     MASTER_SSL_SYM = 535,
     MASTER_SYM = 536,
     MASTER_USER_SYM = 537,
     MATCH = 538,
     MAX_CONNECTIONS_PER_HOUR = 539,
     MAX_QUERIES_PER_HOUR = 540,
     MAX_ROWS = 541,
     MAX_SYM = 542,
     MAX_UPDATES_PER_HOUR = 543,
     MAX_USER_CONNECTIONS_SYM = 544,
     MEDIUMBLOB = 545,
     MEDIUMINT = 546,
     MEDIUMTEXT = 547,
     MEDIUM_SYM = 548,
     MERGE_SYM = 549,
     MICROSECOND_SYM = 550,
     MIGRATE_SYM = 551,
     MINUTE_MICROSECOND_SYM = 552,
     MINUTE_SECOND_SYM = 553,
     MINUTE_SYM = 554,
     MIN_ROWS = 555,
     MIN_SYM = 556,
     MLINEFROMTEXT = 557,
     MODE_SYM = 558,
     MODIFIES_SYM = 559,
     MODIFY_SYM = 560,
     MOD_SYM = 561,
     MONTH_SYM = 562,
     MPOINTFROMTEXT = 563,
     MPOLYFROMTEXT = 564,
     MULTILINESTRING = 565,
     MULTIPOINT = 566,
     MULTIPOLYGON = 567,
     MUTEX_SYM = 568,
     NAMES_SYM = 569,
     NAME_SYM = 570,
     NATIONAL_SYM = 571,
     NATURAL = 572,
     NCHAR_STRING = 573,
     NCHAR_SYM = 574,
     NDBCLUSTER_SYM = 575,
     NE = 576,
     NEW_SYM = 577,
     NEXT_SYM = 578,
     NONE_SYM = 579,
     NOT2_SYM = 580,
     NOT_SYM = 581,
     NOW_SYM = 582,
     NO_SYM = 583,
     NO_WRITE_TO_BINLOG = 584,
     NULL_SYM = 585,
     NUM = 586,
     NUMERIC_SYM = 587,
     NVARCHAR_SYM = 588,
     OFFSET_SYM = 589,
     OJ_SYM = 590,
     OLD_PASSWORD = 591,
     ON = 592,
     ONE_SHOT_SYM = 593,
     ONE_SYM = 594,
     OPEN_SYM = 595,
     OPTIMIZE = 596,
     OPTION = 597,
     OPTIONALLY = 598,
     OR2_SYM = 599,
     ORDER_SYM = 600,
     OR_OR_SYM = 601,
     OR_SYM = 602,
     OUTER = 603,
     OUTFILE = 604,
     OUT_SYM = 605,
     PACK_KEYS_SYM = 606,
     PARTIAL = 607,
     PASSWORD = 608,
     PARAM_MARKER = 609,
     PHASE_SYM = 610,
     POINTFROMTEXT = 611,
     POINT_SYM = 612,
     POLYFROMTEXT = 613,
     POLYGON = 614,
     POSITION_SYM = 615,
     PRECISION = 616,
     PREPARE_SYM = 617,
     PREV_SYM = 618,
     PRIMARY_SYM = 619,
     PRIVILEGES = 620,
     PROCEDURE = 621,
     PROCESS = 622,
     PROCESSLIST_SYM = 623,
     PURGE = 624,
     QUARTER_SYM = 625,
     QUERY_SYM = 626,
     QUICK = 627,
     RAID_0_SYM = 628,
     RAID_CHUNKS = 629,
     RAID_CHUNKSIZE = 630,
     RAID_STRIPED_SYM = 631,
     RAID_TYPE = 632,
     RAND = 633,
     READS_SYM = 634,
     READ_SYM = 635,
     REAL = 636,
     RECOVER_SYM = 637,
     REDUNDANT_SYM = 638,
     REFERENCES = 639,
     REGEXP = 640,
     RELAY_LOG_FILE_SYM = 641,
     RELAY_LOG_POS_SYM = 642,
     RELAY_THREAD = 643,
     RELEASE_SYM = 644,
     RELOAD = 645,
     RENAME = 646,
     REPAIR = 647,
     REPEATABLE_SYM = 648,
     REPEAT_SYM = 649,
     REPLACE = 650,
     REPLICATION = 651,
     REQUIRE_SYM = 652,
     RESET_SYM = 653,
     RESOURCES = 654,
     RESTORE_SYM = 655,
     RESTRICT = 656,
     RESUME_SYM = 657,
     RETURNS_SYM = 658,
     RETURN_SYM = 659,
     REVOKE = 660,
     RIGHT = 661,
     ROLLBACK_SYM = 662,
     ROLLUP_SYM = 663,
     ROUND = 664,
     ROUTINE_SYM = 665,
     ROWS_SYM = 666,
     ROW_COUNT_SYM = 667,
     ROW_FORMAT_SYM = 668,
     ROW_SYM = 669,
     RTREE_SYM = 670,
     SAVEPOINT_SYM = 671,
     SECOND_MICROSECOND_SYM = 672,
     SECOND_SYM = 673,
     SECURITY_SYM = 674,
     SELECT_SYM = 675,
     SENSITIVE_SYM = 676,
     SEPARATOR_SYM = 677,
     SERIALIZABLE_SYM = 678,
     SERIAL_SYM = 679,
     SESSION_SYM = 680,
     SET = 681,
     SET_VAR = 682,
     SHARE_SYM = 683,
     SHIFT_LEFT = 684,
     SHIFT_RIGHT = 685,
     SHOW = 686,
     SHUTDOWN = 687,
     SIGNED_SYM = 688,
     SIMPLE_SYM = 689,
     SLAVE = 690,
     SMALLINT = 691,
     SNAPSHOT_SYM = 692,
     SOUNDS_SYM = 693,
     SPATIAL_SYM = 694,
     SPECIFIC_SYM = 695,
     SQLEXCEPTION_SYM = 696,
     SQLSTATE_SYM = 697,
     SQLWARNING_SYM = 698,
     SQL_BIG_RESULT = 699,
     SQL_BUFFER_RESULT = 700,
     SQL_CACHE_SYM = 701,
     SQL_CALC_FOUND_ROWS = 702,
     SQL_NO_CACHE_SYM = 703,
     SQL_SMALL_RESULT = 704,
     SQL_SYM = 705,
     SQL_THREAD = 706,
     SSL_SYM = 707,
     STARTING = 708,
     START_SYM = 709,
     STATUS_SYM = 710,
     STD_SYM = 711,
     STDDEV_SAMP_SYM = 712,
     STOP_SYM = 713,
     STORAGE_SYM = 714,
     STRAIGHT_JOIN = 715,
     STRING_SYM = 716,
     SUBDATE_SYM = 717,
     SUBJECT_SYM = 718,
     SUBSTRING = 719,
     SUBSTRING_INDEX = 720,
     SUM_SYM = 721,
     SUPER_SYM = 722,
     SUSPEND_SYM = 723,
     SYSDATE = 724,
     TABLES = 725,
     TABLESPACE = 726,
     TABLE_SYM = 727,
     TEMPORARY = 728,
     TEMPTABLE_SYM = 729,
     TERMINATED = 730,
     TEXT_STRING = 731,
     TEXT_SYM = 732,
     TIMESTAMP = 733,
     TIMESTAMP_ADD = 734,
     TIMESTAMP_DIFF = 735,
     TIME_SYM = 736,
     TINYBLOB = 737,
     TINYINT = 738,
     TINYTEXT = 739,
     TO_SYM = 740,
     TRAILING = 741,
     TRANSACTION_SYM = 742,
     TRIGGER_SYM = 743,
     TRIGGERS_SYM = 744,
     TRIM = 745,
     TRUE_SYM = 746,
     TRUNCATE_SYM = 747,
     TYPES_SYM = 748,
     TYPE_SYM = 749,
     UDF_RETURNS_SYM = 750,
     UDF_SONAME_SYM = 751,
     ULONGLONG_NUM = 752,
     UNCOMMITTED_SYM = 753,
     UNDEFINED_SYM = 754,
     UNDERSCORE_CHARSET = 755,
     UNDO_SYM = 756,
     UNICODE_SYM = 757,
     UNION_SYM = 758,
     UNIQUE_SYM = 759,
     UNIQUE_USERS = 760,
     UNIX_TIMESTAMP = 761,
     UNKNOWN_SYM = 762,
     UNLOCK_SYM = 763,
     UNSIGNED = 764,
     UNTIL_SYM = 765,
     UPDATE_SYM = 766,
     UPGRADE_SYM = 767,
     USAGE = 768,
     USER = 769,
     USE_FRM = 770,
     USE_SYM = 771,
     USING = 772,
     UTC_DATE_SYM = 773,
     UTC_TIMESTAMP_SYM = 774,
     UTC_TIME_SYM = 775,
     VAR_SAMP_SYM = 776,
     VALUES = 777,
     VALUE_SYM = 778,
     VARBINARY = 779,
     VARCHAR = 780,
     VARIABLES = 781,
     VARIANCE_SYM = 782,
     VARYING = 783,
     VIEW_SYM = 784,
     WARNINGS = 785,
     WEEK_SYM = 786,
     WHEN_SYM = 787,
     WHERE = 788,
     WHILE_SYM = 789,
     WITH = 790,
     WORK_SYM = 791,
     WRITE_SYM = 792,
     X509_SYM = 793,
     XA_SYM = 794,
     XOR = 795,
     YEARWEEK = 796,
     YEAR_MONTH_SYM = 797,
     YEAR_SYM = 798,
     ZEROFILL = 799,
     TABLE_REF_PRIORITY = 800,
     ELSE = 801,
     THEN_SYM = 802,
     CASE_SYM = 803,
     BETWEEN_SYM = 804,
     NEG = 805
   };
#endif
#define END_OF_INPUT 258
#define ABORT_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define ATAN 277
#define AUTO_INC 278
#define AVG_ROW_LENGTH 279
#define AVG_SYM 280
#define BACKUP_SYM 281
#define BEFORE_SYM 282
#define BEGIN_SYM 283
#define BENCHMARK_SYM 284
#define BERKELEY_DB_SYM 285
#define BIGINT 286
#define BINARY 287
#define BINLOG_SYM 288
#define BIN_NUM 289
#define BIT_AND 290
#define BIT_OR 291
#define BIT_SYM 292
#define BIT_XOR 293
#define BLOB_SYM 294
#define BOOLEAN_SYM 295
#define BOOL_SYM 296
#define BOTH 297
#define BTREE_SYM 298
#define BY 299
#define BYTE_SYM 300
#define CACHE_SYM 301
#define CALL_SYM 302
#define CASCADE 303
#define CASCADED 304
#define CAST_SYM 305
#define CHAIN_SYM 306
#define CHANGE 307
#define CHANGED 308
#define CHARSET 309
#define CHAR_SYM 310
#define CHECKSUM_SYM 311
#define CHECK_SYM 312
#define CIPHER_SYM 313
#define CLIENT_SYM 314
#define CLOSE_SYM 315
#define COALESCE 316
#define CODE_SYM 317
#define COLLATE_SYM 318
#define COLLATION_SYM 319
#define COLUMNS 320
#define COLUMN_SYM 321
#define COMMENT_SYM 322
#define COMMITTED_SYM 323
#define COMMIT_SYM 324
#define COMPACT_SYM 325
#define COMPRESSED_SYM 326
#define CONCAT 327
#define CONCAT_WS 328
#define CONCURRENT 329
#define CONDITION_SYM 330
#define CONNECTION_SYM 331
#define CONSISTENT_SYM 332
#define CONSTRAINT 333
#define CONTAINS_SYM 334
#define CONTINUE_SYM 335
#define CONVERT_SYM 336
#define CONVERT_TZ_SYM 337
#define COUNT_SYM 338
#define CREATE 339
#define CROSS 340
#define CUBE_SYM 341
#define CURDATE 342
#define CURRENT_USER 343
#define CURSOR_SYM 344
#define CURTIME 345
#define DATABASE 346
#define DATABASES 347
#define DATA_SYM 348
#define DATETIME 349
#define DATE_ADD_INTERVAL 350
#define DATE_SUB_INTERVAL 351
#define DATE_SYM 352
#define DAY_HOUR_SYM 353
#define DAY_MICROSECOND_SYM 354
#define DAY_MINUTE_SYM 355
#define DAY_SECOND_SYM 356
#define DAY_SYM 357
#define DEALLOCATE_SYM 358
#define DECIMAL_NUM 359
#define DECIMAL_SYM 360
#define DECLARE_SYM 361
#define DECODE_SYM 362
#define DEFAULT 363
#define DEFINER_SYM 364
#define DELAYED_SYM 365
#define DELAY_KEY_WRITE_SYM 366
#define DELETE_SYM 367
#define DESC 368
#define DESCRIBE 369
#define DES_DECRYPT_SYM 370
#define DES_ENCRYPT_SYM 371
#define DES_KEY_FILE 372
#define DETERMINISTIC_SYM 373
#define DIRECTORY_SYM 374
#define DISABLE_SYM 375
#define DISCARD 376
#define DISTINCT 377
#define DIV_SYM 378
#define DOUBLE_SYM 379
#define DO_SYM 380
#define DROP 381
#define DUAL_SYM 382
#define DUMPFILE 383
#define DUPLICATE_SYM 384
#define DYNAMIC_SYM 385
#define EACH_SYM 386
#define ELSEIF_SYM 387
#define ELT_FUNC 388
#define ENABLE_SYM 389
#define ENCLOSED 390
#define ENCODE_SYM 391
#define ENCRYPT 392
#define END 393
#define ENGINES_SYM 394
#define ENGINE_SYM 395
#define ENUM 396
#define EQ 397
#define EQUAL_SYM 398
#define ERRORS 399
#define ESCAPED 400
#define ESCAPE_SYM 401
#define EVENTS_SYM 402
#define EXECUTE_SYM 403
#define EXISTS 404
#define EXIT_SYM 405
#define EXPANSION_SYM 406
#define EXPORT_SET 407
#define EXTENDED_SYM 408
#define EXTRACT_SYM 409
#define FALSE_SYM 410
#define FAST_SYM 411
#define FETCH_SYM 412
#define FIELD_FUNC 413
#define FILE_SYM 414
#define FIRST_SYM 415
#define FIXED_SYM 416
#define FLOAT_NUM 417
#define FLOAT_SYM 418
#define FLUSH_SYM 419
#define FORCE_SYM 420
#define FOREIGN 421
#define FORMAT_SYM 422
#define FOR_SYM 423
#define FOUND_SYM 424
#define FRAC_SECOND_SYM 425
#define FROM 426
#define FROM_UNIXTIME 427
#define FULL 428
#define FULLTEXT_SYM 429
#define FUNCTION_SYM 430
#define FUNC_ARG0 431
#define FUNC_ARG1 432
#define FUNC_ARG2 433
#define FUNC_ARG3 434
#define GE 435
#define GEOMCOLLFROMTEXT 436
#define GEOMETRYCOLLECTION 437
#define GEOMETRY_SYM 438
#define GEOMFROMTEXT 439
#define GEOMFROMWKB 440
#define GET_FORMAT 441
#define GLOBAL_SYM 442
#define GRANT 443
#define GRANTS 444
#define GREATEST_SYM 445
#define GROUP 446
#define GROUP_CONCAT_SYM 447
#define GROUP_UNIQUE_USERS 448
#define GT_SYM 449
#define HANDLER_SYM 450
#define HASH_SYM 451
#define HAVING 452
#define HELP_SYM 453
#define HEX_NUM 454
#define HIGH_PRIORITY 455
#define HOSTS_SYM 456
#define HOUR_MICROSECOND_SYM 457
#define HOUR_MINUTE_SYM 458
#define HOUR_SECOND_SYM 459
#define HOUR_SYM 460
#define IDENT 461
#define IDENTIFIED_SYM 462
#define IDENT_QUOTED 463
#define IF 464
#define IGNORE_SYM 465
#define IMPORT 466
#define INDEXES 467
#define INDEX_SYM 468
#define INFILE 469
#define INNER_SYM 470
#define INNOBASE_SYM 471
#define INOUT_SYM 472
#define INSENSITIVE_SYM 473
#define INSERT 474
#define INSERT_METHOD 475
#define INTERVAL_SYM 476
#define INTO 477
#define INT_SYM 478
#define INVOKER_SYM 479
#define IN_SYM 480
#define IS 481
#define ISOLATION 482
#define ISSUER_SYM 483
#define ITERATE_SYM 484
#define JOIN_SYM 485
#define KEYS 486
#define KEY_SYM 487
#define KILL_SYM 488
#define LABEL_SYM 489
#define LANGUAGE_SYM 490
#define LAST_INSERT_ID 491
#define LAST_SYM 492
#define LE 493
#define LEADING 494
#define LEAST_SYM 495
#define LEAVES 496
#define LEAVE_SYM 497
#define LEFT 498
#define LEVEL_SYM 499
#define LEX_HOSTNAME 500
#define LIKE 501
#define LIMIT 502
#define LINEFROMTEXT 503
#define LINES 504
#define LINESTRING 505
#define LOAD 506
#define LOCAL_SYM 507
#define LOCATE 508
#define LOCATOR_SYM 509
#define LOCKS_SYM 510
#define LOCK_SYM 511
#define LOGS_SYM 512
#define LOG_SYM 513
#define LONGBLOB 514
#define LONGTEXT 515
#define LONG_NUM 516
#define LONG_SYM 517
#define LOOP_SYM 518
#define LOW_PRIORITY 519
#define LT 520
#define MAKE_SET_SYM 521
#define MASTER_CONNECT_RETRY_SYM 522
#define MASTER_HOST_SYM 523
#define MASTER_LOG_FILE_SYM 524
#define MASTER_LOG_POS_SYM 525
#define MASTER_PASSWORD_SYM 526
#define MASTER_PORT_SYM 527
#define MASTER_POS_WAIT 528
#define MASTER_SERVER_ID_SYM 529
#define MASTER_SSL_CAPATH_SYM 530
#define MASTER_SSL_CA_SYM 531
#define MASTER_SSL_CERT_SYM 532
#define MASTER_SSL_CIPHER_SYM 533
#define MASTER_SSL_KEY_SYM 534
#define MASTER_SSL_SYM 535
#define MASTER_SYM 536
#define MASTER_USER_SYM 537
#define MATCH 538
#define MAX_CONNECTIONS_PER_HOUR 539
#define MAX_QUERIES_PER_HOUR 540
#define MAX_ROWS 541
#define MAX_SYM 542
#define MAX_UPDATES_PER_HOUR 543
#define MAX_USER_CONNECTIONS_SYM 544
#define MEDIUMBLOB 545
#define MEDIUMINT 546
#define MEDIUMTEXT 547
#define MEDIUM_SYM 548
#define MERGE_SYM 549
#define MICROSECOND_SYM 550
#define MIGRATE_SYM 551
#define MINUTE_MICROSECOND_SYM 552
#define MINUTE_SECOND_SYM 553
#define MINUTE_SYM 554
#define MIN_ROWS 555
#define MIN_SYM 556
#define MLINEFROMTEXT 557
#define MODE_SYM 558
#define MODIFIES_SYM 559
#define MODIFY_SYM 560
#define MOD_SYM 561
#define MONTH_SYM 562
#define MPOINTFROMTEXT 563
#define MPOLYFROMTEXT 564
#define MULTILINESTRING 565
#define MULTIPOINT 566
#define MULTIPOLYGON 567
#define MUTEX_SYM 568
#define NAMES_SYM 569
#define NAME_SYM 570
#define NATIONAL_SYM 571
#define NATURAL 572
#define NCHAR_STRING 573
#define NCHAR_SYM 574
#define NDBCLUSTER_SYM 575
#define NE 576
#define NEW_SYM 577
#define NEXT_SYM 578
#define NONE_SYM 579
#define NOT2_SYM 580
#define NOT_SYM 581
#define NOW_SYM 582
#define NO_SYM 583
#define NO_WRITE_TO_BINLOG 584
#define NULL_SYM 585
#define NUM 586
#define NUMERIC_SYM 587
#define NVARCHAR_SYM 588
#define OFFSET_SYM 589
#define OJ_SYM 590
#define OLD_PASSWORD 591
#define ON 592
#define ONE_SHOT_SYM 593
#define ONE_SYM 594
#define OPEN_SYM 595
#define OPTIMIZE 596
#define OPTION 597
#define OPTIONALLY 598
#define OR2_SYM 599
#define ORDER_SYM 600
#define OR_OR_SYM 601
#define OR_SYM 602
#define OUTER 603
#define OUTFILE 604
#define OUT_SYM 605
#define PACK_KEYS_SYM 606
#define PARTIAL 607
#define PASSWORD 608
#define PARAM_MARKER 609
#define PHASE_SYM 610
#define POINTFROMTEXT 611
#define POINT_SYM 612
#define POLYFROMTEXT 613
#define POLYGON 614
#define POSITION_SYM 615
#define PRECISION 616
#define PREPARE_SYM 617
#define PREV_SYM 618
#define PRIMARY_SYM 619
#define PRIVILEGES 620
#define PROCEDURE 621
#define PROCESS 622
#define PROCESSLIST_SYM 623
#define PURGE 624
#define QUARTER_SYM 625
#define QUERY_SYM 626
#define QUICK 627
#define RAID_0_SYM 628
#define RAID_CHUNKS 629
#define RAID_CHUNKSIZE 630
#define RAID_STRIPED_SYM 631
#define RAID_TYPE 632
#define RAND 633
#define READS_SYM 634
#define READ_SYM 635
#define REAL 636
#define RECOVER_SYM 637
#define REDUNDANT_SYM 638
#define REFERENCES 639
#define REGEXP 640
#define RELAY_LOG_FILE_SYM 641
#define RELAY_LOG_POS_SYM 642
#define RELAY_THREAD 643
#define RELEASE_SYM 644
#define RELOAD 645
#define RENAME 646
#define REPAIR 647
#define REPEATABLE_SYM 648
#define REPEAT_SYM 649
#define REPLACE 650
#define REPLICATION 651
#define REQUIRE_SYM 652
#define RESET_SYM 653
#define RESOURCES 654
#define RESTORE_SYM 655
#define RESTRICT 656
#define RESUME_SYM 657
#define RETURNS_SYM 658
#define RETURN_SYM 659
#define REVOKE 660
#define RIGHT 661
#define ROLLBACK_SYM 662
#define ROLLUP_SYM 663
#define ROUND 664
#define ROUTINE_SYM 665
#define ROWS_SYM 666
#define ROW_COUNT_SYM 667
#define ROW_FORMAT_SYM 668
#define ROW_SYM 669
#define RTREE_SYM 670
#define SAVEPOINT_SYM 671
#define SECOND_MICROSECOND_SYM 672
#define SECOND_SYM 673
#define SECURITY_SYM 674
#define SELECT_SYM 675
#define SENSITIVE_SYM 676
#define SEPARATOR_SYM 677
#define SERIALIZABLE_SYM 678
#define SERIAL_SYM 679
#define SESSION_SYM 680
#define SET 681
#define SET_VAR 682
#define SHARE_SYM 683
#define SHIFT_LEFT 684
#define SHIFT_RIGHT 685
#define SHOW 686
#define SHUTDOWN 687
#define SIGNED_SYM 688
#define SIMPLE_SYM 689
#define SLAVE 690
#define SMALLINT 691
#define SNAPSHOT_SYM 692
#define SOUNDS_SYM 693
#define SPATIAL_SYM 694
#define SPECIFIC_SYM 695
#define SQLEXCEPTION_SYM 696
#define SQLSTATE_SYM 697
#define SQLWARNING_SYM 698
#define SQL_BIG_RESULT 699
#define SQL_BUFFER_RESULT 700
#define SQL_CACHE_SYM 701
#define SQL_CALC_FOUND_ROWS 702
#define SQL_NO_CACHE_SYM 703
#define SQL_SMALL_RESULT 704
#define SQL_SYM 705
#define SQL_THREAD 706
#define SSL_SYM 707
#define STARTING 708
#define START_SYM 709
#define STATUS_SYM 710
#define STD_SYM 711
#define STDDEV_SAMP_SYM 712
#define STOP_SYM 713
#define STORAGE_SYM 714
#define STRAIGHT_JOIN 715
#define STRING_SYM 716
#define SUBDATE_SYM 717
#define SUBJECT_SYM 718
#define SUBSTRING 719
#define SUBSTRING_INDEX 720
#define SUM_SYM 721
#define SUPER_SYM 722
#define SUSPEND_SYM 723
#define SYSDATE 724
#define TABLES 725
#define TABLESPACE 726
#define TABLE_SYM 727
#define TEMPORARY 728
#define TEMPTABLE_SYM 729
#define TERMINATED 730
#define TEXT_STRING 731
#define TEXT_SYM 732
#define TIMESTAMP 733
#define TIMESTAMP_ADD 734
#define TIMESTAMP_DIFF 735
#define TIME_SYM 736
#define TINYBLOB 737
#define TINYINT 738
#define TINYTEXT 739
#define TO_SYM 740
#define TRAILING 741
#define TRANSACTION_SYM 742
#define TRIGGER_SYM 743
#define TRIGGERS_SYM 744
#define TRIM 745
#define TRUE_SYM 746
#define TRUNCATE_SYM 747
#define TYPES_SYM 748
#define TYPE_SYM 749
#define UDF_RETURNS_SYM 750
#define UDF_SONAME_SYM 751
#define ULONGLONG_NUM 752
#define UNCOMMITTED_SYM 753
#define UNDEFINED_SYM 754
#define UNDERSCORE_CHARSET 755
#define UNDO_SYM 756
#define UNICODE_SYM 757
#define UNION_SYM 758
#define UNIQUE_SYM 759
#define UNIQUE_USERS 760
#define UNIX_TIMESTAMP 761
#define UNKNOWN_SYM 762
#define UNLOCK_SYM 763
#define UNSIGNED 764
#define UNTIL_SYM 765
#define UPDATE_SYM 766
#define UPGRADE_SYM 767
#define USAGE 768
#define USER 769
#define USE_FRM 770
#define USE_SYM 771
#define USING 772
#define UTC_DATE_SYM 773
#define UTC_TIMESTAMP_SYM 774
#define UTC_TIME_SYM 775
#define VAR_SAMP_SYM 776
#define VALUES 777
#define VALUE_SYM 778
#define VARBINARY 779
#define VARCHAR 780
#define VARIABLES 781
#define VARIANCE_SYM 782
#define VARYING 783
#define VIEW_SYM 784
#define WARNINGS 785
#define WEEK_SYM 786
#define WHEN_SYM 787
#define WHERE 788
#define WHILE_SYM 789
#define WITH 790
#define WORK_SYM 791
#define WRITE_SYM 792
#define X509_SYM 793
#define XA_SYM 794
#define XOR 795
#define YEARWEEK 796
#define YEAR_MONTH_SYM 797
#define YEAR_SYM 798
#define ZEROFILL 799
#define TABLE_REF_PRIORITY 800
#define ELSE 801
#define THEN_SYM 802
#define CASE_SYM 803
#define BETWEEN_SYM 804
#define NEG 805




/* Copy the first part of user declarations.  */
#line 18 "sql_yacc.yy"

/* thd is passed as an arg to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200				/* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "mysql_priv.h"
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include <myisam.h>
#include <myisammrg.h>

int yylex(void *yylval, void *yythd);

const LEX_STRING null_lex_str={0,0};

#define yyoverflow(A,B,C,D,E,F) {ulong val= *(F); if (my_yyoverflow((B), (D), &val)) { yyerror((char*) (A)); return 2; } else { *(F)= (YYSIZE_T)val; }}

#undef 	WARN_DEPRECATED			/* this macro is also defined in mysql_priv.h */
#define WARN_DEPRECATED(A,B)                                        \
  push_warning_printf(((THD *)yythd), MYSQL_ERROR::WARN_LEVEL_WARN, \
		      ER_WARN_DEPRECATED_SYNTAX,                    \
		      ER(ER_WARN_DEPRECATED_SYNTAX), (A), (B));

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;

  char *yytext= (char*) thd->lex->tok_start;
  /* Push an error into the error stack */
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  (yytext ? (char*) yytext : ""),
                  thd->lex->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  sp->add_instr(i);

  return 0;
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->push_backpatch(i, ctx->push_label((char *)"", 0));
  sp->add_cont_backpatch(i);
  sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

void case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  sp->add_instr(i);

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 414 "sql_yacc.yy"
typedef union YYSTYPE {
  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  enum db_type db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  struct st_lex *lex;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 1621 "sql_yacc.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 454 "sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 213 of yacc.c.  */
#line 1636 "sql_yacc.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  459
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   44290

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  570
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  672
/* YYNRULES -- Number of rules. */
#define YYNRULES  2023
/* YYNRULES -- Number of states. */
#define YYNSTATES  3668

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   805

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short int yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   563,     2,     2,     2,   556,   551,     2,
     560,   561,   554,   553,   562,   552,   567,   555,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   569,   568,
       2,     2,     2,     2,   566,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   557,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   564,   550,   565,   558,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   559
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    14,    16,    18,
      20,    22,    24,    26,    28,    30,    32,    34,    36,    38,
      40,    42,    44,    46,    48,    50,    52,    54,    56,    58,
      60,    62,    64,    66,    68,    70,    72,    74,    76,    78,
      80,    82,    84,    86,    88,    90,    92,    94,    96,    98,
     100,   102,   104,   106,   110,   112,   114,   119,   121,   124,
     125,   130,   131,   134,   138,   140,   143,   144,   148,   149,
     155,   157,   161,   165,   169,   173,   177,   181,   185,   189,
     193,   197,   201,   205,   207,   211,   215,   219,   223,   224,
     232,   233,   245,   246,   253,   254,   258,   263,   264,   268,
     270,   275,   276,   277,   278,   279,   280,   293,   294,   297,
     298,   301,   304,   307,   310,   313,   317,   321,   323,   325,
     327,   330,   334,   338,   339,   344,   345,   349,   350,   352,
     356,   358,   359,   361,   365,   367,   368,   372,   373,   375,
     379,   381,   386,   387,   389,   391,   393,   394,   398,   401,
     405,   406,   410,   411,   417,   423,   424,   432,   438,   439,
     442,   444,   446,   448,   452,   454,   458,   459,   461,   463,
     465,   467,   470,   472,   474,   478,   479,   482,   483,   486,
     487,   491,   492,   498,   500,   502,   503,   506,   509,   512,
     515,   516,   523,   526,   527,   530,   532,   534,   538,   539,
     540,   541,   549,   550,   553,   556,   558,   560,   561,   562,
     571,   572,   579,   581,   584,   586,   589,   590,   591,   598,
     599,   600,   607,   608,   611,   612,   618,   619,   621,   622,
     628,   633,   634,   635,   644,   645,   653,   655,   657,   659,
     661,   663,   666,   669,   672,   677,   682,   683,   688,   689,
     690,   696,   697,   705,   706,   707,   714,   715,   717,   718,
     720,   722,   725,   727,   729,   730,   732,   734,   737,   739,
     740,   744,   745,   747,   749,   752,   754,   757,   761,   765,
     769,   773,   777,   781,   785,   789,   793,   797,   801,   805,
     809,   813,   817,   821,   825,   831,   833,   835,   839,   844,
     849,   853,   858,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   881,   883,   885,   887,   889,   891,   894,   895,
     897,   899,   901,   903,   905,   907,   911,   913,   915,   918,
     921,   928,   936,   945,   948,   951,   952,   954,   957,   958,
     960,   963,   964,   969,   973,   977,   981,   983,   988,   990,
     992,   998,  1001,  1007,  1010,  1015,  1017,  1023,  1029,  1034,
    1038,  1040,  1042,  1045,  1047,  1049,  1052,  1054,  1056,  1058,
    1061,  1065,  1068,  1072,  1075,  1078,  1082,  1086,  1090,  1091,
    1098,  1099,  1106,  1109,  1111,  1113,  1115,  1117,  1119,  1121,
    1123,  1125,  1127,  1129,  1131,  1134,  1137,  1139,  1142,  1144,
    1147,  1151,  1154,  1156,  1158,  1160,  1162,  1164,  1166,  1168,
    1171,  1172,  1176,  1178,  1184,  1185,  1187,  1190,  1192,  1194,
    1196,  1198,  1199,  1203,  1204,  1206,  1207,  1209,  1212,  1214,
    1216,  1219,  1222,  1227,  1229,  1233,  1236,  1238,  1241,  1244,
    1247,  1250,  1252,  1255,  1257,  1259,  1261,  1263,  1265,  1266,
    1269,  1271,  1273,  1275,  1277,  1279,  1280,  1283,  1285,  1287,
    1288,  1290,  1291,  1294,  1296,  1299,  1303,  1306,  1307,  1309,
    1310,  1312,  1314,  1317,  1318,  1320,  1321,  1326,  1328,  1333,
    1337,  1339,  1340,  1342,  1345,  1347,  1351,  1355,  1358,  1361,
    1364,  1366,  1368,  1371,  1374,  1377,  1379,  1382,  1385,  1388,
    1391,  1393,  1395,  1396,  1398,  1400,  1402,  1404,  1405,  1407,
    1409,  1411,  1412,  1415,  1418,  1420,  1422,  1424,  1429,  1432,
    1434,  1439,  1440,  1442,  1443,  1446,  1448,  1452,  1453,  1460,
    1461,  1467,  1468,  1474,  1475,  1481,  1482,  1494,  1495,  1497,
    1498,  1501,  1504,  1506,  1510,  1513,  1517,  1520,  1525,  1526,
    1533,  1534,  1535,  1544,  1549,  1554,  1558,  1562,  1565,  1568,
    1575,  1581,  1585,  1591,  1593,  1595,  1597,  1598,  1600,  1601,
    1603,  1604,  1606,  1608,  1609,  1612,  1614,  1615,  1617,  1619,
    1621,  1622,  1628,  1632,  1633,  1639,  1643,  1647,  1648,  1652,
    1653,  1656,  1658,  1662,  1663,  1665,  1667,  1668,  1671,  1673,
    1677,  1678,  1685,  1686,  1693,  1694,  1700,  1701,  1703,  1705,
    1706,  1713,  1714,  1716,  1718,  1721,  1723,  1725,  1727,  1728,
    1735,  1736,  1742,  1743,  1745,  1747,  1750,  1752,  1754,  1756,
    1758,  1760,  1763,  1764,  1771,  1772,  1774,  1776,  1777,  1782,
    1787,  1791,  1797,  1799,  1803,  1807,  1813,  1815,  1819,  1822,
    1824,  1826,  1827,  1834,  1836,  1840,  1844,  1845,  1848,  1849,
    1854,  1855,  1858,  1860,  1863,  1868,  1871,  1875,  1876,  1880,
    1881,  1882,  1889,  1892,  1894,  1896,  1899,  1902,  1911,  1916,
    1917,  1919,  1922,  1924,  1926,  1928,  1930,  1932,  1934,  1936,
    1938,  1940,  1942,  1944,  1945,  1948,  1953,  1957,  1959,  1961,
    1966,  1967,  1968,  1970,  1972,  1973,  1976,  1979,  1981,  1983,
    1984,  1987,  1988,  1992,  1993,  1997,  2001,  2002,  2006,  2007,
    2011,  2014,  2016,  2020,  2025,  2029,  2034,  2038,  2043,  2045,
    2049,  2054,  2058,  2062,  2069,  2071,  2077,  2084,  2090,  2098,
    2105,  2114,  2120,  2127,  2132,  2137,  2143,  2147,  2152,  2154,
    2158,  2160,  2164,  2166,  2170,  2174,  2176,  2180,  2184,  2189,
    2194,  2196,  2200,  2204,  2208,  2212,  2216,  2218,  2222,  2224,
    2226,  2228,  2230,  2232,  2234,  2236,  2238,  2240,  2242,  2244,
    2246,  2248,  2250,  2252,  2254,  2256,  2259,  2261,  2265,  2267,
    2269,  2271,  2273,  2277,  2280,  2283,  2286,  2289,  2293,  2297,
    2303,  2310,  2315,  2320,  2328,  2333,  2336,  2343,  2349,  2356,
    2363,  2368,  2373,  2377,  2382,  2389,  2398,  2405,  2414,  2421,
    2426,  2433,  2438,  2445,  2450,  2455,  2460,  2465,  2472,  2481,
    2484,  2487,  2492,  2495,  2503,  2511,  2515,  2520,  2525,  2532,
    2539,  2544,  2551,  2558,  2565,  2570,  2577,  2582,  2589,  2598,
    2609,  2622,  2629,  2634,  2641,  2648,  2650,  2657,  2662,  2671,
    2682,  2687,  2689,  2693,  2698,  2705,  2712,  2721,  2728,  2735,
    2740,  2747,  2754,  2763,  2768,  2773,  2780,  2785,  2788,  2793,
    2798,  2803,  2810,  2815,  2820,  2824,  2833,  2840,  2845,  2852,
    2856,  2863,  2872,  2877,  2886,  2893,  2902,  2909,  2918,  2921,
    2926,  2931,  2936,  2943,  2952,  2961,  2966,  2974,  2982,  2990,
    2997,  3004,  3011,  3018,  3025,  3032,  3033,  3039,  3050,  3054,
    3059,  3063,  3066,  3069,  3072,  3077,  3084,  3089,  3094,  3101,
    3108,  3115,  3122,  3127,  3134,  3139,  3146,  3151,  3156,  3161,
    3166,  3173,  3178,  3185,  3190,  3197,  3202,  3207,  3214,  3219,
    3226,  3231,  3238,  3243,  3248,  3255,  3260,  3267,  3268,  3272,
    3276,  3277,  3279,  3280,  3283,  3285,  3289,  3294,  3299,  3305,
    3310,  3315,  3320,  3326,  3331,  3332,  3333,  3341,  3352,  3357,
    3363,  3368,  3374,  3379,  3384,  3389,  3394,  3399,  3405,  3406,
    3415,  3416,  3420,  3424,  3426,  3431,  3432,  3434,  3435,  3438,
    3439,  3441,  3442,  3446,  3449,  3453,  3456,  3458,  3461,  3463,
    3466,  3468,  3470,  3472,  3475,  3476,  3478,  3479,  3482,  3484,
    3488,  3490,  3494,  3495,  3498,  3500,  3504,  3505,  3507,  3508,
    3511,  3516,  3522,  3524,  3526,  3528,  3530,  3534,  3538,  3542,
    3543,  3550,  3551,  3558,  3559,  3568,  3573,  3574,  3583,  3584,
    3595,  3602,  3603,  3612,  3613,  3624,  3631,  3633,  3636,  3639,
    3640,  3645,  3646,  3658,  3662,  3669,  3670,  3674,  3675,  3676,
    3682,  3683,  3685,  3686,  3688,  3689,  3692,  3695,  3698,  3699,
    3705,  3706,  3708,  3712,  3714,  3716,  3718,  3722,  3724,  3726,
    3728,  3730,  3732,  3734,  3736,  3738,  3740,  3742,  3744,  3746,
    3748,  3750,  3752,  3754,  3756,  3758,  3760,  3762,  3764,  3766,
    3768,  3770,  3772,  3774,  3775,  3777,  3779,  3780,  3783,  3784,
    3786,  3787,  3788,  3792,  3793,  3794,  3798,  3801,  3802,  3803,
    3808,  3813,  3816,  3817,  3820,  3823,  3827,  3831,  3833,  3836,
    3837,  3839,  3840,  3845,  3850,  3853,  3854,  3856,  3858,  3859,
    3861,  3862,  3864,  3867,  3869,  3873,  3877,  3879,  3881,  3883,
    3885,  3886,  3889,  3891,  3893,  3895,  3897,  3899,  3901,  3903,
    3905,  3907,  3909,  3911,  3912,  3913,  3920,  3921,  3923,  3927,
    3929,  3932,  3933,  3936,  3940,  3942,  3945,  3947,  3948,  3952,
    3953,  3959,  3962,  3964,  3965,  3969,  3976,  3977,  3984,  3989,
    3994,  3999,  4004,  4010,  4015,  4017,  4021,  4023,  4024,  4027,
    4028,  4030,  4031,  4032,  4041,  4042,  4043,  4050,  4051,  4053,
    4055,  4057,  4059,  4061,  4064,  4066,  4068,  4070,  4074,  4079,
    4080,  4084,  4088,  4090,  4093,  4096,  4097,  4101,  4102,  4108,
    4112,  4114,  4118,  4120,  4124,  4126,  4128,  4129,  4131,  4132,
    4137,  4138,  4140,  4144,  4146,  4148,  4150,  4151,  4152,  4159,
    4160,  4161,  4173,  4177,  4179,  4183,  4187,  4189,  4193,  4194,
    4196,  4197,  4202,  4203,  4210,  4211,  4217,  4218,  4225,  4227,
    4231,  4235,  4241,  4242,  4245,  4246,  4249,  4251,  4253,  4255,
    4259,  4260,  4262,  4263,  4267,  4270,  4275,  4280,  4285,  4290,
    4291,  4296,  4303,  4320,  4323,  4326,  4327,  4334,  4340,  4343,
    4346,  4349,  4351,  4357,  4363,  4366,  4369,  4373,  4376,  4379,
    4382,  4386,  4389,  4392,  4395,  4397,  4399,  4403,  4408,  4412,
    4416,  4419,  4422,  4426,  4430,  4434,  4438,  4442,  4446,  4448,
    4450,  4452,  4454,  4455,  4457,  4458,  4461,  4462,  4464,  4466,
    4468,  4469,  4472,  4473,  4476,  4477,  4480,  4483,  4484,  4489,
    4490,  4495,  4497,  4499,  4500,  4502,  4503,  4505,  4507,  4508,
    4513,  4517,  4519,  4520,  4524,  4529,  4532,  4534,  4536,  4538,
    4540,  4542,  4544,  4546,  4548,  4549,  4551,  4552,  4556,  4560,
    4562,  4564,  4566,  4569,  4570,  4574,  4578,  4581,  4584,  4585,
    4590,  4591,  4593,  4595,  4598,  4599,  4604,  4610,  4611,  4612,
    4613,  4614,  4633,  4636,  4637,  4639,  4640,  4642,  4644,  4645,
    4647,  4649,  4650,  4653,  4656,  4658,  4662,  4667,  4671,  4675,
    4676,  4679,  4682,  4684,  4688,  4692,  4693,  4697,  4698,  4702,
    4705,  4709,  4711,  4713,  4716,  4717,  4720,  4722,  4724,  4727,
    4730,  4732,  4734,  4736,  4738,  4740,  4743,  4746,  4748,  4750,
    4752,  4754,  4756,  4758,  4760,  4763,  4766,  4769,  4772,  4775,
    4777,  4779,  4781,  4783,  4785,  4787,  4789,  4793,  4799,  4801,
    4803,  4805,  4807,  4809,  4813,  4818,  4824,  4826,  4832,  4836,
    4839,  4841,  4845,  4848,  4850,  4852,  4854,  4856,  4858,  4860,
    4862,  4864,  4866,  4868,  4870,  4872,  4874,  4876,  4880,  4883,
    4885,  4887,  4889,  4891,  4893,  4895,  4897,  4899,  4901,  4903,
    4905,  4907,  4909,  4911,  4913,  4915,  4917,  4919,  4921,  4923,
    4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,  4941,  4943,
    4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,  4961,  4963,
    4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,  4981,  4983,
    4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,  5001,  5003,
    5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,  5021,  5023,
    5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,  5041,  5043,
    5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,  5061,  5063,
    5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,  5081,  5083,
    5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,  5101,  5103,
    5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,  5121,  5123,
    5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,  5141,  5143,
    5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,  5161,  5163,
    5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,  5181,  5183,
    5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,
    5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,
    5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,  5241,  5243,
    5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,  5261,  5263,
    5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,  5281,  5283,
    5285,  5287,  5289,  5291,  5293,  5295,  5297,  5299,  5301,  5303,
    5305,  5307,  5309,  5311,  5313,  5315,  5317,  5319,  5321,  5323,
    5325,  5327,  5329,  5331,  5333,  5335,  5337,  5339,  5341,  5343,
    5345,  5347,  5349,  5351,  5353,  5355,  5357,  5359,  5361,  5363,
    5365,  5367,  5369,  5371,  5373,  5375,  5377,  5379,  5381,  5383,
    5384,  5389,  5390,  5392,  5394,  5398,  5399,  5402,  5404,  5406,
    5408,  5410,  5411,  5413,  5414,  5416,  5418,  5420,  5421,  5424,
    5427,  5430,  5432,  5435,  5440,  5446,  5451,  5458,  5461,  5465,
    5469,  5473,  5479,  5481,  5485,  5489,  5492,  5495,  5498,  5500,
    5502,  5507,  5512,  5514,  5516,  5518,  5520,  5522,  5523,  5528,
    5530,  5532,  5534,  5538,  5542,  5544,  5546,  5549,  5552,  5553,
    5557,  5562,  5566,  5567,  5575,  5577,  5580,  5582,  5584,  5586,
    5588,  5590,  5592,  5593,  5599,  5601,  5603,  5605,  5607,  5609,
    5613,  5620,  5627,  5634,  5642,  5646,  5655,  5664,  5673,  5674,
    5676,  5678,  5681,  5682,  5684,  5686,  5690,  5691,  5695,  5696,
    5700,  5701,  5705,  5706,  5710,  5712,  5714,  5716,  5718,  5720,
    5722,  5724,  5726,  5728,  5730,  5732,  5735,  5738,  5740,  5744,
    5747,  5750,  5753,  5756,  5759,  5762,  5765,  5768,  5769,  5771,
    5775,  5777,  5780,  5783,  5786,  5788,  5792,  5796,  5798,  5800,
    5804,  5806,  5810,  5815,  5821,  5823,  5824,  5828,  5832,  5834,
    5836,  5837,  5840,  5843,  5846,  5849,  5850,  5853,  5856,  5858,
    5861,  5864,  5867,  5870,  5873,  5874,  5878,  5879,  5881,  5882,
    5886,  5889,  5890,  5892,  5895,  5896,  5898,  5903,  5908,  5914,
    5917,  5921,  5922,  5924,  5925,  5930,  5931,  5933,  5935,  5936,
    5939,  5942,  5944,  5945,  5947,  5949,  5954,  5955,  5963,  5965,
    5966,  5967,  5970,  5974,  5976,  5978,  5980,  5981,  5985,  5987,
    5990,  5992,  5995,  5999,  6003,  6007,  6008,  6010,  6011,  6015,
    6019,  6020,  6029,  6030,  6034,  6036,  6040,  6041,  6044,  6048,
    6054,  6055,  6059,  6064,  6069,  6070,  6085,  6086,  6093,  6094,
    6095,  6096,  6097,  6110,  6115,  6120,  6124,  6129,  6133,  6136,
    6138,  6142,  6148,  6150,  6152,  6153,  6155,  6157,  6158,  6161,
    6162,  6163,  6167,  6168
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     571,     0,    -1,     3,    -1,   572,     3,    -1,   573,    -1,
    1187,    -1,   770,    -1,   811,    -1,   801,    -1,   608,    -1,
     585,    -1,   813,    -1,   803,    -1,  1193,    -1,   590,    -1,
     574,    -1,  1031,    -1,  1058,    -1,   987,    -1,   989,    -1,
     578,    -1,  1064,    -1,  1162,    -1,  1153,    -1,   583,    -1,
     995,    -1,  1078,    -1,  1082,    -1,  1145,    -1,   818,    -1,
     826,    -1,   830,    -1,   576,    -1,  1074,    -1,  1196,    -1,
     821,    -1,   806,    -1,   998,    -1,  1070,    -1,   799,    -1,
    1160,    -1,  1194,    -1,  1195,    -1,   838,    -1,  1128,    -1,
    1044,    -1,   788,    -1,   791,    -1,  1042,    -1,  1151,    -1,
    1023,    -1,  1081,    -1,  1234,    -1,   575,   362,  1122,    -1,
     103,    -1,   126,    -1,   362,  1122,   171,   577,    -1,  1119,
      -1,   566,  1124,    -1,    -1,   148,  1122,   579,   580,    -1,
      -1,   517,   581,    -1,   581,   562,   582,    -1,   582,    -1,
     566,  1124,    -1,    -1,   198,   584,  1124,    -1,    -1,    52,
     281,   485,   586,   587,    -1,   588,    -1,   587,   562,   588,
      -1,   268,   142,  1119,    -1,   282,   142,  1119,    -1,   271,
     142,  1119,    -1,   272,   142,   972,    -1,   267,   142,   972,
      -1,   280,   142,   972,    -1,   276,   142,  1119,    -1,   275,
     142,  1119,    -1,   277,   142,  1119,    -1,   278,   142,  1119,
      -1,   279,   142,  1119,    -1,   589,    -1,   269,   142,  1119,
      -1,   270,   142,   973,    -1,   386,   142,  1119,    -1,   387,
     142,   972,    -1,    -1,    84,   687,   472,   690,  1116,   591,
     674,    -1,    -1,    84,   762,   213,  1122,   763,   337,  1116,
     592,   560,   765,   561,    -1,    -1,    84,    91,   690,  1122,
     593,   684,    -1,    -1,    84,   594,  1210,    -1,    84,   514,
     595,  1178,    -1,    -1,  1122,   567,  1122,    -1,  1122,    -1,
     403,   703,   496,  1119,    -1,    -1,    -1,    -1,    -1,    -1,
     560,   598,   613,   561,   599,   403,   600,   714,   601,   604,
     602,   636,    -1,    -1,   603,   605,    -1,    -1,   604,   606,
      -1,    67,  1119,    -1,   235,   450,    -1,   328,   450,    -1,
      79,   450,    -1,   379,   450,    93,    -1,   304,   450,    93,
      -1,   607,    -1,   605,    -1,   118,    -1,   877,   118,    -1,
     450,   419,   109,    -1,   450,   419,   224,    -1,    -1,    47,
     596,   609,   610,    -1,    -1,   560,   611,   561,    -1,    -1,
     612,    -1,   612,   562,   859,    -1,   859,    -1,    -1,   614,
      -1,   614,   562,   616,    -1,   616,    -1,    -1,  1122,   615,
     714,    -1,    -1,   618,    -1,   618,   562,   619,    -1,   619,
      -1,   620,   615,  1122,   714,    -1,    -1,   225,    -1,   350,
      -1,   217,    -1,    -1,   621,   636,   568,    -1,   636,   568,
      -1,   622,   636,   568,    -1,    -1,   623,   624,   568,    -1,
      -1,   106,   634,   625,   714,   635,    -1,   106,  1122,    75,
     168,   631,    -1,    -1,   106,   629,   195,   168,   626,   630,
     636,    -1,   106,  1122,    89,   168,   627,    -1,    -1,   628,
     573,    -1,   150,    -1,    80,    -1,   633,    -1,   630,   562,
     633,    -1,   972,    -1,   442,   632,  1120,    -1,    -1,   523,
      -1,   631,    -1,  1122,    -1,   443,    -1,   877,   169,    -1,
     441,    -1,  1122,    -1,   634,   562,  1122,    -1,    -1,   108,
     859,    -1,    -1,   637,   573,    -1,    -1,   404,   638,   859,
      -1,    -1,   209,   639,   644,   138,   209,    -1,   649,    -1,
     664,    -1,    -1,   640,   667,    -1,   242,  1123,    -1,   229,
    1123,    -1,   340,  1122,    -1,    -1,   157,   642,  1122,   222,
     641,   643,    -1,    60,  1122,    -1,    -1,   323,   171,    -1,
     171,    -1,  1122,    -1,   643,   562,  1122,    -1,    -1,    -1,
      -1,   645,   859,   547,   646,   622,   647,   648,    -1,    -1,
     132,   644,    -1,   546,   622,    -1,   650,    -1,   653,    -1,
      -1,    -1,   548,   651,   859,   652,   655,   663,   138,   548,
      -1,    -1,   548,   654,   656,   663,   138,   548,    -1,   657,
      -1,   655,   657,    -1,   660,    -1,   656,   660,    -1,    -1,
      -1,   532,   658,   859,   659,   547,   622,    -1,    -1,    -1,
     532,   661,   859,   662,   547,   622,    -1,    -1,   546,   622,
      -1,    -1,  1123,   569,   665,   667,   666,    -1,    -1,  1123,
      -1,    -1,    28,   668,   623,   621,   138,    -1,   263,   622,
     138,   263,    -1,    -1,    -1,   534,   669,   859,   125,   670,
     622,   138,   534,    -1,    -1,   394,   622,   510,   671,   859,
     138,   394,    -1,    27,    -1,     8,    -1,   219,    -1,   511,
      -1,   112,    -1,   560,   675,    -1,   691,   677,    -1,   246,
    1116,    -1,   560,   246,  1116,   561,    -1,   704,   561,   691,
     677,    -1,    -1,   680,   561,   676,  1200,    -1,    -1,    -1,
    1091,   683,   680,   678,  1197,    -1,    -1,  1091,   683,   560,
     680,   561,   679,  1200,    -1,    -1,    -1,   420,   681,   848,
     852,   682,   701,    -1,    -1,    18,    -1,    -1,   685,    -1,
     686,    -1,   685,   686,    -1,   696,    -1,   695,    -1,    -1,
     688,    -1,   689,    -1,   689,   688,    -1,   473,    -1,    -1,
     209,   877,   149,    -1,    -1,   693,    -1,   694,    -1,   694,
     692,    -1,   694,    -1,   694,   693,    -1,   694,   562,   693,
      -1,   140,  1015,   697,    -1,   494,  1015,   697,    -1,   286,
    1015,   973,    -1,   300,  1015,   973,    -1,    24,  1015,   972,
      -1,   353,  1015,  1119,    -1,    67,  1015,  1119,    -1,    23,
    1015,   973,    -1,   351,  1015,   972,    -1,   351,  1015,   108,
      -1,    56,  1015,   972,    -1,   111,  1015,   972,    -1,   413,
    1015,   698,    -1,   377,  1015,   699,    -1,   374,  1015,   972,
      -1,   375,  1015,   972,    -1,   503,  1015,   560,   991,   561,
      -1,   695,    -1,   696,    -1,   220,  1015,   700,    -1,    93,
     119,  1015,  1119,    -1,   213,   119,  1015,  1119,    -1,    76,
    1015,  1119,    -1,   744,   735,  1015,   737,    -1,   744,    63,
    1015,   743,    -1,  1124,    -1,   108,    -1,   161,    -1,   130,
      -1,    71,    -1,   383,    -1,    70,    -1,   376,    -1,   373,
      -1,   972,    -1,   328,    -1,   160,    -1,   237,    -1,   967,
      -1,   847,   851,    -1,    -1,    10,    -1,   461,    -1,   381,
      -1,   105,    -1,   223,    -1,   705,    -1,   704,   562,   705,
      -1,   706,    -1,   707,    -1,   712,   708,    -1,   712,   749,
      -1,   757,   767,   763,   560,   765,   561,    -1,   710,   758,
     767,   763,   560,   765,   561,    -1,   710,   166,   232,   767,
     560,   765,   561,   749,    -1,   711,   708,    -1,   710,   709,
      -1,    -1,   709,    -1,    57,   859,    -1,    -1,   711,    -1,
      78,   767,    -1,    -1,  1115,   713,   714,   731,    -1,   722,
     729,   726,    -1,   723,   730,   726,    -1,   163,   724,   726,
      -1,    37,    -1,    37,   560,   331,   561,    -1,    41,    -1,
      40,    -1,   718,   560,   331,   561,   745,    -1,   718,   745,
      -1,   719,   560,   331,   561,   746,    -1,   719,   746,    -1,
      32,   560,   331,   561,    -1,    32,    -1,   720,   560,   331,
     561,   745,    -1,   721,   560,   331,   561,   746,    -1,   524,
     560,   331,   561,    -1,   543,   729,   726,    -1,    97,    -1,
     481,    -1,   478,   729,    -1,    94,    -1,   482,    -1,    39,
     729,    -1,   717,    -1,   290,    -1,   259,    -1,   262,   524,
      -1,   262,   720,   745,    -1,   484,   745,    -1,   477,   729,
     745,    -1,   292,   745,    -1,   260,   745,    -1,   105,   724,
     726,    -1,   332,   724,   726,    -1,   161,   724,   726,    -1,
      -1,   141,   715,   560,   769,   561,   745,    -1,    -1,   426,
     716,   560,   769,   561,   745,    -1,   262,   745,    -1,   424,
      -1,   183,    -1,   182,    -1,   357,    -1,   311,    -1,   250,
      -1,   310,    -1,   359,    -1,   312,    -1,    55,    -1,   319,
      -1,   316,    55,    -1,   718,   528,    -1,   525,    -1,   316,
     525,    -1,   333,    -1,   319,   525,    -1,   316,    55,   528,
      -1,   319,   528,    -1,   223,    -1,   483,    -1,   436,    -1,
     291,    -1,    31,    -1,   381,    -1,   124,    -1,   124,   361,
      -1,    -1,   560,   331,   561,    -1,   725,    -1,   560,   331,
     562,   331,   561,    -1,    -1,   727,    -1,   727,   728,    -1,
     728,    -1,   433,    -1,   509,    -1,   544,    -1,    -1,   560,
     331,   561,    -1,    -1,   725,    -1,    -1,   732,    -1,   732,
     733,    -1,   733,    -1,   330,    -1,   877,   330,    -1,   108,
     734,    -1,   337,   511,   327,   858,    -1,    23,    -1,   424,
     108,   523,    -1,   748,   232,    -1,   504,    -1,   504,   232,
      -1,    67,  1119,    -1,    63,   741,    -1,   327,   858,    -1,
    1106,    -1,    55,   426,    -1,    54,    -1,  1124,    -1,    32,
      -1,   736,    -1,   108,    -1,    -1,   735,   737,    -1,  1124,
      -1,    32,    -1,   739,    -1,   108,    -1,  1124,    -1,    -1,
      63,   743,    -1,   741,    -1,   108,    -1,    -1,   108,    -1,
      -1,    20,   746,    -1,    45,    -1,   502,   746,    -1,   735,
     736,   746,    -1,    32,   747,    -1,    -1,    32,    -1,    -1,
      20,    -1,   502,    -1,   735,   736,    -1,    -1,   364,    -1,
      -1,   384,  1116,   750,   751,    -1,   753,    -1,   560,   752,
     561,   753,    -1,   752,   562,  1122,    -1,  1122,    -1,    -1,
     754,    -1,   754,   755,    -1,   755,    -1,   337,   112,   756,
      -1,   337,   511,   756,    -1,   283,   173,    -1,   283,   352,
      -1,   283,   434,    -1,   401,    -1,    48,    -1,   426,   330,
      -1,   328,     5,    -1,   426,   108,    -1,   759,    -1,   174,
     760,    -1,   439,   760,    -1,   364,   232,    -1,   504,   760,
      -1,   232,    -1,   213,    -1,    -1,   759,    -1,   231,    -1,
     213,    -1,   212,    -1,    -1,   504,    -1,   174,    -1,   439,
      -1,    -1,   517,   764,    -1,   494,   764,    -1,    43,    -1,
     415,    -1,   196,    -1,   765,   562,   766,   965,    -1,   766,
     965,    -1,  1122,    -1,  1122,   560,   331,   561,    -1,    -1,
    1115,    -1,    -1,   567,  1122,    -1,  1104,    -1,   769,   562,
    1104,    -1,    -1,    13,   784,   472,  1116,   771,   777,    -1,
      -1,    13,    91,   776,   772,   684,    -1,    -1,    13,   366,
     596,   773,   603,    -1,    -1,    13,   175,   596,   774,   603,
      -1,    -1,    13,  1216,  1212,  1217,   529,  1116,   775,  1220,
      18,  1222,  1225,    -1,    -1,  1122,    -1,    -1,   121,   471,
      -1,   211,   471,    -1,   779,    -1,   777,   562,   779,    -1,
       6,   783,    -1,   778,   706,   786,    -1,     6,   707,    -1,
     778,   560,   704,   561,    -1,    -1,    52,   783,  1115,   780,
     712,   786,    -1,    -1,    -1,   305,   783,  1115,   781,   714,
     731,   782,   786,    -1,   126,   783,  1115,   785,    -1,   126,
     166,   232,   767,    -1,   126,   364,   232,    -1,   126,   759,
    1115,    -1,   120,   231,    -1,   134,   231,    -1,    13,   783,
    1115,   426,   108,  1106,    -1,    13,   783,  1115,   126,   108,
      -1,   391,   787,  1116,    -1,    81,   485,   735,   737,   742,
      -1,   692,    -1,   165,    -1,   958,    -1,    -1,    66,    -1,
      -1,   210,    -1,    -1,   401,    -1,    48,    -1,    -1,     8,
    1122,    -1,   160,    -1,    -1,   485,    -1,   142,    -1,    18,
      -1,    -1,   454,   435,   793,   789,   797,    -1,   458,   435,
     793,    -1,    -1,   435,   454,   793,   790,   797,    -1,   435,
     458,   793,    -1,   454,   487,   792,    -1,    -1,   535,    77,
     437,    -1,    -1,   794,   795,    -1,   796,    -1,   795,   562,
     796,    -1,    -1,   451,    -1,   388,    -1,    -1,   510,   798,
      -1,   589,    -1,   798,   562,   589,    -1,    -1,   400,  1147,
     800,   991,   171,  1119,    -1,    -1,    26,  1147,   802,   991,
     485,  1119,    -1,    -1,    56,  1147,   804,   991,   805,    -1,
      -1,   372,    -1,   153,    -1,    -1,   392,   820,  1147,   807,
     991,   808,    -1,    -1,   809,    -1,   810,    -1,   810,   809,
      -1,   372,    -1,   153,    -1,   515,    -1,    -1,    14,   820,
    1147,   812,   991,   815,    -1,    -1,    57,  1147,   814,   991,
     815,    -1,    -1,   816,    -1,   817,    -1,   817,   816,    -1,
     372,    -1,   156,    -1,   293,    -1,   153,    -1,    53,    -1,
     168,   512,    -1,    -1,   341,   820,  1147,   819,   991,   815,
      -1,    -1,   329,    -1,   252,    -1,    -1,   391,  1147,   822,
     824,    -1,   391,   514,   595,   823,    -1,  1125,   485,  1125,
      -1,   823,   562,  1125,   485,  1125,    -1,   825,    -1,   824,
     562,   825,    -1,  1116,   485,  1116,    -1,    46,   213,   827,
     225,   829,    -1,   828,    -1,   827,   562,   828,    -1,  1116,
     834,    -1,  1122,    -1,   108,    -1,    -1,   251,   213,   222,
      46,   831,   832,    -1,   833,    -1,   832,   562,   833,    -1,
    1116,   834,   837,    -1,    -1,   835,   836,    -1,    -1,   760,
     560,   942,   561,    -1,    -1,   210,   241,    -1,   839,    -1,
     420,   841,    -1,   560,   840,   561,  1200,    -1,   420,   843,
      -1,   560,   840,   561,    -1,    -1,   843,   842,  1197,    -1,
      -1,    -1,   844,   848,   852,   845,   846,   851,    -1,   961,
     967,    -1,   983,    -1,   847,    -1,   983,   847,    -1,   847,
     983,    -1,   171,   916,   950,   955,   952,   961,   967,   974,
      -1,   171,   127,   950,   967,    -1,    -1,   849,    -1,   849,
     850,    -1,   850,    -1,   460,    -1,   200,    -1,   122,    -1,
     449,    -1,   444,    -1,   445,    -1,   447,    -1,   448,    -1,
     446,    -1,    12,    -1,    -1,   168,   511,    -1,   256,   225,
     428,   303,    -1,   852,   562,   853,    -1,   853,    -1,   554,
      -1,   854,   856,   855,   857,    -1,    -1,    -1,  1110,    -1,
     859,    -1,    -1,    18,  1122,    -1,    18,  1119,    -1,  1122,
      -1,  1119,    -1,    -1,   560,   561,    -1,    -1,   862,   860,
     861,    -1,    -1,   861,   875,   862,    -1,   862,   540,   862,
      -1,    -1,   865,   863,   864,    -1,    -1,   864,   876,   865,
      -1,   326,   865,    -1,   866,    -1,   867,   226,   491,    -1,
     867,   226,   877,   491,    -1,   867,   226,   155,    -1,   867,
     226,   877,   155,    -1,   867,   226,   507,    -1,   867,   226,
     877,   507,    -1,   867,    -1,   867,   226,   330,    -1,   867,
     226,   877,   330,    -1,   867,   143,   868,    -1,   867,   879,
     868,    -1,   867,   879,   880,   560,  1205,   561,    -1,   868,
      -1,   869,   225,   560,  1205,   561,    -1,   869,   877,   225,
     560,  1205,   561,    -1,   869,   225,   560,   859,   561,    -1,
     869,   225,   560,   859,   562,   905,   561,    -1,   869,   877,
     225,   560,   859,   561,    -1,   869,   877,   225,   560,   859,
     562,   905,   561,    -1,   869,   549,   869,    16,   868,    -1,
     869,   877,   549,   869,    16,   868,    -1,   869,   438,   246,
     869,    -1,   869,   246,   882,   954,    -1,   869,   877,   246,
     882,   954,    -1,   869,   385,   869,    -1,   869,   877,   385,
     869,    -1,   869,    -1,   869,   550,   870,    -1,   870,    -1,
     870,   551,   871,    -1,   871,    -1,   871,   429,   872,    -1,
     871,   430,   872,    -1,   872,    -1,   872,   553,   873,    -1,
     872,   552,   873,    -1,   872,   553,   881,   944,    -1,   872,
     552,   881,   944,    -1,   873,    -1,   873,   554,   874,    -1,
     873,   555,   874,    -1,   873,   556,   874,    -1,   873,   123,
     874,    -1,   873,   306,   874,    -1,   874,    -1,   874,   557,
     882,    -1,   882,    -1,   347,    -1,   344,    -1,    16,    -1,
      15,    -1,   326,    -1,   325,    -1,   563,    -1,   325,    -1,
     142,    -1,   180,    -1,   194,    -1,   238,    -1,   265,    -1,
     321,    -1,    12,    -1,    17,    -1,   221,   859,    -1,  1112,
      -1,   882,    63,  1124,    -1,  1107,    -1,  1105,    -1,   895,
      -1,   891,    -1,   882,   346,   882,    -1,   553,   882,    -1,
     552,   882,    -1,   558,   882,    -1,   878,   882,    -1,   560,
    1205,   561,    -1,   560,   859,   561,    -1,   560,   859,   562,
     905,   561,    -1,   414,   560,   859,   562,   905,   561,    -1,
     149,   560,  1205,   561,    -1,   564,  1122,   859,   565,    -1,
     283,   908,     9,   560,   869,   885,   561,    -1,    20,   560,
     859,   561,    -1,    32,   882,    -1,    50,   560,   859,    18,
     903,   561,    -1,   548,   912,   914,   913,   138,    -1,    81,
     560,   859,   562,   903,   561,    -1,    81,   560,   859,   517,
     736,   561,    -1,   108,   560,  1112,   561,    -1,   522,   560,
    1113,   561,    -1,   176,   560,   561,    -1,   177,   560,   859,
     561,    -1,   178,   560,   859,   562,   859,   561,    -1,   179,
     560,   859,   562,   859,   562,   859,   561,    -1,     7,   560,
     859,   562,   859,   561,    -1,     7,   560,   859,   562,   221,
     859,   944,   561,    -1,   394,   560,   859,   562,   859,   561,
      -1,    22,   560,   859,   561,    -1,    22,   560,   859,   562,
     859,   561,    -1,    55,   560,   905,   561,    -1,    55,   560,
     905,   517,   736,   561,    -1,    54,   560,   859,   561,    -1,
      61,   560,   905,   561,    -1,    64,   560,   859,   561,    -1,
      72,   560,   905,   561,    -1,    73,   560,   859,   562,   905,
     561,    -1,    82,   560,   859,   562,   859,   562,   859,   561,
      -1,    87,   858,    -1,    90,   858,    -1,    90,   560,   859,
     561,    -1,    88,   858,    -1,    95,   560,   859,   562,   881,
     944,   561,    -1,    96,   560,   859,   562,   881,   944,   561,
      -1,    91,   560,   561,    -1,    97,   560,   859,   561,    -1,
     102,   560,   859,   561,    -1,   133,   560,   859,   562,   905,
     561,    -1,   266,   560,   859,   562,   905,   561,    -1,   137,
     560,   859,   561,    -1,   137,   560,   859,   562,   859,   561,
      -1,   107,   560,   859,   562,  1120,   561,    -1,   136,   560,
     859,   562,  1120,   561,    -1,   115,   560,   859,   561,    -1,
     115,   560,   859,   562,   859,   561,    -1,   116,   560,   859,
     561,    -1,   116,   560,   859,   562,   859,   561,    -1,   152,
     560,   859,   562,   859,   562,   859,   561,    -1,   152,   560,
     859,   562,   859,   562,   859,   562,   859,   561,    -1,   152,
     560,   859,   562,   859,   562,   859,   562,   859,   562,   859,
     561,    -1,   167,   560,   859,   562,   331,   561,    -1,   172,
     560,   859,   561,    -1,   172,   560,   859,   562,   859,   561,
      -1,   158,   560,   859,   562,   905,   561,    -1,   884,    -1,
     186,   560,   946,   562,   859,   561,    -1,   205,   560,   859,
     561,    -1,   209,   560,   859,   562,   859,   562,   859,   561,
      -1,   219,   560,   859,   562,   859,   562,   859,   562,   859,
     561,    -1,   881,   944,   553,   859,    -1,   881,    -1,   236,
     560,   561,    -1,   236,   560,   859,   561,    -1,   243,   560,
     859,   562,   859,   561,    -1,   253,   560,   859,   562,   859,
     561,    -1,   253,   560,   859,   562,   859,   562,   859,   561,
      -1,   190,   560,   859,   562,   905,   561,    -1,   240,   560,
     859,   562,   905,   561,    -1,   258,   560,   859,   561,    -1,
     258,   560,   859,   562,   859,   561,    -1,   273,   560,   859,
     562,   859,   561,    -1,   273,   560,   859,   562,   859,   562,
     859,   561,    -1,   295,   560,   859,   561,    -1,   299,   560,
     859,   561,    -1,   306,   560,   859,   562,   859,   561,    -1,
     307,   560,   859,   561,    -1,   327,   858,    -1,   327,   560,
     859,   561,    -1,   353,   560,   859,   561,    -1,   336,   560,
     859,   561,    -1,   360,   560,   869,   225,   859,   561,    -1,
     370,   560,   859,   561,    -1,   378,   560,   859,   561,    -1,
     378,   560,   561,    -1,   395,   560,   859,   562,   859,   562,
     859,   561,    -1,   406,   560,   859,   562,   859,   561,    -1,
     409,   560,   859,   561,    -1,   409,   560,   859,   562,   859,
     561,    -1,   412,   560,   561,    -1,   462,   560,   859,   562,
     859,   561,    -1,   462,   560,   859,   562,   221,   859,   944,
     561,    -1,   418,   560,   859,   561,    -1,   464,   560,   859,
     562,   859,   562,   859,   561,    -1,   464,   560,   859,   562,
     859,   561,    -1,   464,   560,   859,   171,   859,   168,   859,
     561,    -1,   464,   560,   859,   171,   859,   561,    -1,   465,
     560,   859,   562,   859,   562,   859,   561,    -1,   469,   858,
      -1,   469,   560,   859,   561,    -1,   481,   560,   859,   561,
      -1,   478,   560,   859,   561,    -1,   478,   560,   859,   562,
     859,   561,    -1,   479,   560,   945,   562,   859,   562,   859,
     561,    -1,   480,   560,   945,   562,   859,   562,   859,   561,
      -1,   490,   560,   859,   561,    -1,   490,   560,   239,   859,
     171,   859,   561,    -1,   490,   560,   486,   859,   171,   859,
     561,    -1,   490,   560,    42,   859,   171,   859,   561,    -1,
     490,   560,   239,   171,   859,   561,    -1,   490,   560,   486,
     171,   859,   561,    -1,   490,   560,    42,   171,   859,   561,
      -1,   490,   560,   859,   171,   859,   561,    -1,   492,   560,
     859,   562,   859,   561,    -1,  1122,   567,  1122,   560,   904,
     561,    -1,    -1,  1118,   560,   883,   886,   561,    -1,   505,
     560,  1103,   562,   331,   562,   331,   562,   905,   561,    -1,
     506,   560,   561,    -1,   506,   560,   859,   561,    -1,   514,
     560,   561,    -1,   518,   858,    -1,   520,   858,    -1,   519,
     858,    -1,   531,   560,   859,   561,    -1,   531,   560,   859,
     562,   859,   561,    -1,   543,   560,   859,   561,    -1,   541,
     560,   859,   561,    -1,   541,   560,   859,   562,   859,   561,
      -1,    29,   560,   972,   562,   859,   561,    -1,   154,   560,
     944,   171,   859,   561,    -1,    79,   560,   859,   562,   859,
     561,    -1,   184,   560,   859,   561,    -1,   184,   560,   859,
     562,   859,   561,    -1,   185,   560,   859,   561,    -1,   185,
     560,   859,   562,   859,   561,    -1,   182,   560,   905,   561,
      -1,   250,   560,   905,   561,    -1,   310,   560,   905,   561,
      -1,   302,   560,   859,   561,    -1,   302,   560,   859,   562,
     859,   561,    -1,   308,   560,   859,   561,    -1,   308,   560,
     859,   562,   859,   561,    -1,   309,   560,   859,   561,    -1,
     309,   560,   859,   562,   859,   561,    -1,   311,   560,   905,
     561,    -1,   312,   560,   905,   561,    -1,   357,   560,   859,
     562,   859,   561,    -1,   356,   560,   859,   561,    -1,   356,
     560,   859,   562,   859,   561,    -1,   358,   560,   859,   561,
      -1,   358,   560,   859,   562,   859,   561,    -1,   359,   560,
     905,   561,    -1,   181,   560,   859,   561,    -1,   181,   560,
     859,   562,   859,   561,    -1,   248,   560,   859,   561,    -1,
     248,   560,   859,   562,   859,   561,    -1,    -1,   535,   371,
     151,    -1,   225,    40,   303,    -1,    -1,   887,    -1,    -1,
     888,   889,    -1,   890,    -1,   889,   562,   890,    -1,   854,
     859,   855,   857,    -1,    25,   560,   901,   561,    -1,    25,
     560,   122,   901,   561,    -1,    35,   560,   901,   561,    -1,
      36,   560,   901,   561,    -1,    38,   560,   901,   561,    -1,
      83,   560,   949,   554,   561,    -1,    83,   560,   901,   561,
      -1,    -1,    -1,    83,   560,   122,   892,   905,   893,   561,
      -1,   193,   560,  1103,   562,   331,   562,   331,   562,   901,
     561,    -1,   301,   560,   901,   561,    -1,   301,   560,   122,
     901,   561,    -1,   287,   560,   901,   561,    -1,   287,   560,
     122,   901,   561,    -1,   456,   560,   901,   561,    -1,   527,
     560,   901,   561,    -1,   457,   560,   901,   561,    -1,   521,
     560,   901,   561,    -1,   466,   560,   901,   561,    -1,   466,
     560,   122,   901,   561,    -1,    -1,   192,   560,   898,   894,
     905,   900,   899,   561,    -1,    -1,   566,   896,   897,    -1,
    1124,   427,   859,    -1,  1124,    -1,   566,  1137,  1124,   768,
      -1,    -1,   122,    -1,    -1,   422,  1104,    -1,    -1,   962,
      -1,    -1,   949,   902,   859,    -1,    32,   729,    -1,    55,
     729,   745,    -1,   319,   729,    -1,   433,    -1,   433,   223,
      -1,   509,    -1,   509,   223,    -1,    97,    -1,   481,    -1,
      94,    -1,   105,   724,    -1,    -1,   905,    -1,    -1,   906,
     907,    -1,   859,    -1,   907,   562,   859,    -1,   909,    -1,
     560,   909,   561,    -1,    -1,   910,   911,    -1,  1112,    -1,
     911,   562,  1112,    -1,    -1,   859,    -1,    -1,   546,   859,
      -1,   532,   859,   547,   859,    -1,   914,   532,   859,   547,
     859,    -1,   927,    -1,   918,    -1,   917,    -1,   915,    -1,
     917,   562,   915,    -1,   915,   926,   915,    -1,   915,   460,
     927,    -1,    -1,   915,   926,   915,   337,   919,   859,    -1,
      -1,   915,   460,   927,   337,   920,   859,    -1,    -1,   915,
     926,   915,   517,   921,   560,   943,   561,    -1,   915,   317,
     230,   927,    -1,    -1,   915,   243,   937,   230,   915,   337,
     922,   859,    -1,    -1,   915,   243,   937,   230,   927,   923,
     517,   560,   943,   561,    -1,   915,   317,   243,   937,   230,
     927,    -1,    -1,   915,   406,   937,   230,   915,   337,   924,
     859,    -1,    -1,   915,   406,   937,   230,   927,   925,   517,
     560,   943,   561,    -1,   915,   317,   406,   937,   230,   927,
      -1,   230,    -1,   215,   230,    -1,    85,   230,    -1,    -1,
     928,  1116,   948,   938,    -1,    -1,   564,  1122,   915,   243,
     348,   230,   915,   337,   929,   859,   565,    -1,   936,   935,
     932,    -1,   560,   935,   930,  1200,   561,   948,    -1,    -1,
     935,   931,   917,    -1,    -1,    -1,   933,   848,   852,   934,
     701,    -1,    -1,   420,    -1,    -1,   348,    -1,    -1,   516,
     939,    -1,   165,   939,    -1,   210,   939,    -1,    -1,   759,
     940,   560,   941,   561,    -1,    -1,   942,    -1,   942,   562,
    1122,    -1,  1122,    -1,   364,    -1,  1122,    -1,   943,   562,
    1122,    -1,   945,    -1,    98,    -1,    99,    -1,   100,    -1,
     101,    -1,   202,    -1,   203,    -1,   204,    -1,   295,    -1,
     297,    -1,   298,    -1,   417,    -1,   542,    -1,   102,    -1,
     531,    -1,   205,    -1,   170,    -1,   299,    -1,   307,    -1,
     370,    -1,   418,    -1,   543,    -1,    97,    -1,   481,    -1,
      94,    -1,   478,    -1,    -1,    18,    -1,   142,    -1,    -1,
     947,  1122,    -1,    -1,    12,    -1,    -1,    -1,   533,   951,
     859,    -1,    -1,    -1,   197,   953,   859,    -1,   146,   882,
      -1,    -1,    -1,   191,    44,   956,   957,    -1,   956,   562,
    1111,   965,    -1,  1111,   965,    -1,    -1,   535,    86,    -1,
     535,   408,    -1,   345,    44,   959,    -1,   959,   562,   960,
      -1,   960,    -1,  1113,   965,    -1,    -1,   962,    -1,    -1,
     345,    44,   963,   964,    -1,   964,   562,  1111,   965,    -1,
    1111,   965,    -1,    -1,    19,    -1,   113,    -1,    -1,   968,
      -1,    -1,   968,    -1,   247,   969,    -1,   970,    -1,   970,
     562,   970,    -1,   970,   334,   970,    -1,  1105,    -1,   497,
      -1,   261,    -1,   331,    -1,    -1,   247,   970,    -1,   331,
      -1,   199,    -1,   261,    -1,   497,    -1,   104,    -1,   162,
      -1,   331,    -1,   497,    -1,   261,    -1,   104,    -1,   162,
      -1,    -1,    -1,   366,  1122,   975,   560,   976,   561,    -1,
      -1,   977,    -1,   977,   562,   978,    -1,   978,    -1,   854,
     859,    -1,    -1,   980,   981,    -1,   981,   562,   982,    -1,
     982,    -1,   566,  1124,    -1,  1124,    -1,    -1,   222,   984,
     985,    -1,    -1,   349,  1121,   986,  1092,  1095,    -1,   128,
    1121,    -1,   979,    -1,    -1,   125,   988,   905,    -1,   126,
     994,  1147,   993,   991,   785,    -1,    -1,   126,   213,  1122,
     337,  1116,   990,    -1,   126,    91,   993,  1122,    -1,   126,
     175,   993,   596,    -1,   126,   366,   993,   596,    -1,   126,
     514,   595,  1177,    -1,   126,   529,   993,   991,   785,    -1,
     126,   488,   993,   596,    -1,   992,    -1,   991,   562,   992,
      -1,  1116,    -1,    -1,   209,   149,    -1,    -1,   473,    -1,
      -1,    -1,   219,   996,  1001,   784,  1003,   997,  1005,  1021,
      -1,    -1,    -1,   395,   999,  1002,  1003,  1000,  1005,    -1,
      -1,   264,    -1,   110,    -1,   200,    -1,  1030,    -1,   110,
      -1,   222,  1004,    -1,  1004,    -1,   992,    -1,  1008,    -1,
     560,   561,  1008,    -1,   560,  1007,   561,  1008,    -1,    -1,
     426,  1006,  1012,    -1,  1007,   562,  1109,    -1,  1109,    -1,
     522,  1011,    -1,   523,  1011,    -1,    -1,   680,  1009,  1197,
      -1,    -1,   560,   680,   561,  1010,  1200,    -1,  1011,   562,
    1016,    -1,  1016,    -1,  1012,   562,  1013,    -1,  1013,    -1,
    1113,  1014,  1020,    -1,   142,    -1,   427,    -1,    -1,  1014,
      -1,    -1,   560,  1017,  1018,   561,    -1,    -1,  1019,    -1,
    1019,   562,  1020,    -1,  1020,    -1,   859,    -1,   108,    -1,
      -1,    -1,   337,   129,  1022,   232,   511,  1028,    -1,    -1,
      -1,   511,  1024,  1030,   784,   916,   426,  1026,  1025,   950,
     961,   971,    -1,  1026,   562,  1027,    -1,  1027,    -1,  1113,
    1014,  1020,    -1,  1028,   562,  1029,    -1,  1029,    -1,  1113,
    1014,  1020,    -1,    -1,   264,    -1,    -1,   112,  1032,  1040,
    1033,    -1,    -1,   171,  1116,  1034,   950,   961,   971,    -1,
      -1,  1037,  1035,   171,   916,   950,    -1,    -1,   171,  1037,
    1036,   517,   916,   950,    -1,  1038,    -1,  1037,   562,  1038,
      -1,  1122,  1039,   948,    -1,  1122,   567,  1122,  1039,   948,
      -1,    -1,   567,   554,    -1,    -1,  1041,  1040,    -1,   372,
      -1,   264,    -1,   210,    -1,   492,  1043,   992,    -1,    -1,
     472,    -1,    -1,   431,  1045,  1046,    -1,    92,  1057,    -1,
    1053,   470,  1052,  1057,    -1,  1053,   489,  1052,  1057,    -1,
     472,   455,  1052,  1057,    -1,   340,   470,  1052,  1057,    -1,
      -1,   140,   697,  1047,  1049,    -1,  1053,    65,  1054,  1116,
    1052,  1057,    -1,   322,   281,   168,   435,   535,   269,   142,
    1119,    16,   270,   142,   973,    16,   274,   142,   972,    -1,
    1050,   257,    -1,   435,   201,    -1,    -1,    33,   147,  1055,
    1056,  1048,   966,    -1,   761,  1054,  1116,  1052,   950,    -1,
      66,   493,    -1,   472,   493,    -1,  1051,   139,    -1,   365,
      -1,    83,   560,   554,   561,   530,    -1,    83,   560,   554,
     561,   144,    -1,   530,   966,    -1,   144,   966,    -1,  1136,
     455,  1057,    -1,   216,   455,    -1,   313,   455,    -1,  1053,
     368,    -1,  1136,   526,  1057,    -1,   735,  1057,    -1,    64,
    1057,    -1,    30,   257,    -1,   257,    -1,   189,    -1,   189,
     168,  1125,    -1,    84,    91,   690,  1122,    -1,    84,   472,
    1116,    -1,    84,   529,  1116,    -1,   281,   455,    -1,   435,
     455,    -1,    84,   366,   596,    -1,    84,   175,   596,    -1,
     366,   455,  1057,    -1,   175,   455,  1057,    -1,   366,    62,
     596,    -1,   175,    62,   596,    -1,   455,    -1,   257,    -1,
     281,    -1,    32,    -1,    -1,   459,    -1,    -1,  1054,  1122,
      -1,    -1,   173,    -1,   171,    -1,   225,    -1,    -1,   225,
    1119,    -1,    -1,   171,   973,    -1,    -1,   246,  1119,    -1,
     533,   859,    -1,    -1,  1061,  1116,  1059,  1063,    -1,    -1,
    1061,  1062,  1060,   838,    -1,   113,    -1,   114,    -1,    -1,
     153,    -1,    -1,  1104,    -1,  1122,    -1,    -1,   164,   820,
    1065,  1066,    -1,  1066,   562,  1067,    -1,  1067,    -1,    -1,
    1147,  1068,  1069,    -1,   470,   535,   380,   256,    -1,   371,
      46,    -1,   201,    -1,   365,    -1,   257,    -1,   455,    -1,
     435,    -1,   281,    -1,   117,    -1,   399,    -1,    -1,   991,
      -1,    -1,   398,  1071,  1072,    -1,  1072,   562,  1073,    -1,
    1073,    -1,   435,    -1,   281,    -1,   371,    46,    -1,    -1,
     369,  1075,  1076,    -1,  1050,   257,  1077,    -1,   485,  1119,
      -1,    27,   859,    -1,    -1,   233,  1079,  1080,   859,    -1,
      -1,    76,    -1,   371,    -1,   516,  1122,    -1,    -1,   251,
      93,  1083,  1084,    -1,   251,   472,  1116,   171,   281,    -1,
      -1,    -1,    -1,    -1,  1090,  1089,   214,  1121,  1085,  1091,
     222,  1086,   472,  1116,  1087,   738,  1088,  1092,  1095,  1098,
    1099,  1102,    -1,   171,   281,    -1,    -1,   252,    -1,    -1,
      74,    -1,   264,    -1,    -1,   395,    -1,   210,    -1,    -1,
      65,  1093,    -1,  1093,  1094,    -1,  1094,    -1,   475,    44,
    1104,    -1,   343,   135,    44,  1104,    -1,   135,    44,  1104,
      -1,   145,    44,  1104,    -1,    -1,   249,  1096,    -1,  1096,
    1097,    -1,  1097,    -1,   475,    44,  1104,    -1,   453,    44,
    1104,    -1,    -1,   210,   331,   249,    -1,    -1,   560,  1100,
     561,    -1,   560,   561,    -1,  1100,   562,  1101,    -1,  1101,
      -1,  1113,    -1,   566,  1124,    -1,    -1,   426,  1028,    -1,
    1120,    -1,   318,    -1,   500,   476,    -1,  1103,  1120,    -1,
    1120,    -1,   199,    -1,    34,    -1,   354,    -1,  1107,    -1,
     553,  1108,    -1,   552,  1108,    -1,  1103,    -1,  1108,    -1,
     330,    -1,   155,    -1,   491,    -1,   199,    -1,    34,    -1,
     500,   199,    -1,   500,    34,    -1,    97,  1103,    -1,   481,
    1103,    -1,   478,  1103,    -1,   331,    -1,   261,    -1,   497,
      -1,   104,    -1,   162,    -1,  1113,    -1,  1110,    -1,  1122,
     567,   554,    -1,  1122,   567,  1122,   567,   554,    -1,   859,
      -1,  1122,    -1,  1114,    -1,  1122,    -1,  1114,    -1,  1122,
     567,  1122,    -1,   567,  1122,   567,  1122,    -1,  1122,   567,
    1122,   567,  1122,    -1,  1122,    -1,  1122,   567,  1122,   567,
    1122,    -1,  1122,   567,  1122,    -1,   567,  1122,    -1,  1122,
      -1,  1122,   567,  1122,    -1,   567,  1122,    -1,  1122,    -1,
     206,    -1,   208,    -1,   476,    -1,   476,    -1,   476,    -1,
    1118,    -1,  1126,    -1,  1118,    -1,  1127,    -1,  1122,    -1,
    1119,    -1,   245,    -1,  1124,    -1,  1124,   566,  1124,    -1,
      88,   858,    -1,  1127,    -1,    20,    -1,    26,    -1,    28,
      -1,    45,    -1,    46,    -1,    54,    -1,    56,    -1,    60,
      -1,    67,    -1,    69,    -1,    79,    -1,   103,    -1,   125,
      -1,   138,    -1,   148,    -1,   164,    -1,   195,    -1,   198,
      -1,   235,    -1,   328,    -1,   340,    -1,   362,    -1,   392,
      -1,   398,    -1,   400,    -1,   407,    -1,   416,    -1,   419,
      -1,   433,    -1,   435,    -1,   454,    -1,   458,    -1,   492,
      -1,   502,    -1,   539,    -1,   512,    -1,     5,    -1,     7,
      -1,     8,    -1,     9,    -1,    10,    -1,    11,    -1,    17,
      -1,    23,    -1,    24,    -1,    25,    -1,    30,    -1,    33,
      -1,    37,    -1,    41,    -1,    40,    -1,    43,    -1,    49,
      -1,    51,    -1,    53,    -1,    58,    -1,    59,    -1,    62,
      -1,    64,    -1,    65,    -1,    68,    -1,    70,    -1,    71,
      -1,    74,    -1,    76,    -1,    77,    -1,    86,    -1,    93,
      -1,    94,    -1,    97,    -1,   102,    -1,   109,    -1,   111,
      -1,   117,    -1,   119,    -1,   121,    -1,   128,    -1,   129,
      -1,   130,    -1,   141,    -1,   140,    -1,   139,    -1,   144,
      -1,   146,    -1,   147,    -1,   151,    -1,   153,    -1,   156,
      -1,   169,    -1,   120,    -1,   134,    -1,   173,    -1,   159,
      -1,   160,    -1,   161,    -1,   170,    -1,   183,    -1,   182,
      -1,   186,    -1,   189,    -1,   187,    -1,   196,    -1,   201,
      -1,   205,    -1,   207,    -1,   224,    -1,   211,    -1,   212,
      -1,   227,    -1,   228,    -1,   216,    -1,   220,    -1,   388,
      -1,   237,    -1,   241,    -1,   244,    -1,   250,    -1,   252,
      -1,   255,    -1,   257,    -1,   286,    -1,   281,    -1,   268,
      -1,   272,    -1,   269,    -1,   270,    -1,   282,    -1,   271,
      -1,   274,    -1,   267,    -1,   280,    -1,   276,    -1,   275,
      -1,   277,    -1,   278,    -1,   279,    -1,   284,    -1,   285,
      -1,   288,    -1,   289,    -1,   293,    -1,   294,    -1,   295,
      -1,   296,    -1,   299,    -1,   300,    -1,   305,    -1,   303,
      -1,   307,    -1,   310,    -1,   311,    -1,   312,    -1,   313,
      -1,   315,    -1,   314,    -1,   316,    -1,   319,    -1,   320,
      -1,   323,    -1,   322,    -1,   324,    -1,   333,    -1,   334,
      -1,   336,    -1,   338,    -1,   339,    -1,   351,    -1,   352,
      -1,   353,    -1,   355,    -1,   357,    -1,   359,    -1,   363,
      -1,   365,    -1,   367,    -1,   368,    -1,   370,    -1,   371,
      -1,   372,    -1,   373,    -1,   374,    -1,   375,    -1,   376,
      -1,   377,    -1,   382,    -1,   383,    -1,   386,    -1,   387,
      -1,   390,    -1,   393,    -1,   396,    -1,   399,    -1,   402,
      -1,   403,    -1,   408,    -1,   410,    -1,   411,    -1,   413,
      -1,   414,    -1,   415,    -1,   418,    -1,   424,    -1,   423,
      -1,   425,    -1,   434,    -1,   428,    -1,   432,    -1,   437,
      -1,   438,    -1,   446,    -1,   445,    -1,   448,    -1,   451,
      -1,   455,    -1,   459,    -1,   461,    -1,   462,    -1,   463,
      -1,   467,    -1,   468,    -1,   470,    -1,   471,    -1,   473,
      -1,   474,    -1,   477,    -1,   487,    -1,   489,    -1,   478,
      -1,   479,    -1,   480,    -1,   481,    -1,   493,    -1,   494,
      -1,   495,    -1,   175,    -1,   498,    -1,   499,    -1,   507,
      -1,   510,    -1,   514,    -1,   515,    -1,   526,    -1,   529,
      -1,   523,    -1,   530,    -1,   531,    -1,   536,    -1,   538,
      -1,   543,    -1,    -1,   426,  1130,  1129,  1131,    -1,    -1,
     342,    -1,  1132,    -1,  1131,   562,  1132,    -1,    -1,  1133,
    1138,    -1,  1135,    -1,   187,    -1,   252,    -1,   425,    -1,
      -1,   338,    -1,    -1,   187,    -1,   252,    -1,   425,    -1,
      -1,   187,   567,    -1,   252,   567,    -1,   425,   567,    -1,
    1139,    -1,  1135,  1140,    -1,  1134,  1141,  1014,  1144,    -1,
    1134,   487,   227,   244,  1142,    -1,   566,  1124,  1014,   859,
      -1,   566,   566,  1137,  1141,  1014,  1144,    -1,   735,   740,
      -1,   314,  1014,   859,    -1,   314,   737,   742,    -1,   353,
    1014,  1143,    -1,   353,   168,  1125,  1014,  1143,    -1,  1122,
      -1,  1122,   567,  1122,    -1,   108,   567,  1122,    -1,   380,
     498,    -1,   380,    68,    -1,   393,   380,    -1,   423,    -1,
     476,    -1,   353,   560,   476,   561,    -1,   336,   560,   476,
     561,    -1,   859,    -1,   108,    -1,   337,    -1,    12,    -1,
      32,    -1,    -1,   256,  1147,  1146,  1148,    -1,   472,    -1,
     470,    -1,  1149,    -1,  1148,   562,  1149,    -1,  1116,   948,
    1150,    -1,   380,    -1,   537,    -1,   264,   537,    -1,   380,
     252,    -1,    -1,   508,  1152,  1147,    -1,   195,  1116,   340,
     948,    -1,   195,  1117,    60,    -1,    -1,   195,  1117,   380,
    1154,  1155,   950,   967,    -1,  1156,    -1,  1122,  1157,    -1,
     160,    -1,   323,    -1,   160,    -1,   323,    -1,   363,    -1,
     237,    -1,    -1,  1159,  1158,   560,  1019,   561,    -1,   142,
      -1,   180,    -1,   238,    -1,   194,    -1,   265,    -1,   405,
     595,  1161,    -1,  1165,   337,  1164,  1176,   171,  1178,    -1,
    1165,   337,   175,  1176,   171,  1178,    -1,  1165,   337,   366,
    1176,   171,  1178,    -1,    12,  1166,   562,   188,   342,   171,
    1178,    -1,   188,   595,  1163,    -1,  1165,   337,  1164,  1176,
     485,  1178,  1183,  1184,    -1,  1165,   337,   175,  1176,   485,
    1178,  1183,  1184,    -1,  1165,   337,   366,  1176,   485,  1178,
    1183,  1184,    -1,    -1,   472,    -1,  1167,    -1,    12,  1166,
      -1,    -1,   365,    -1,  1168,    -1,  1167,   562,  1168,    -1,
      -1,   420,  1169,  1180,    -1,    -1,   219,  1170,  1180,    -1,
      -1,   511,  1171,  1180,    -1,    -1,   384,  1172,  1180,    -1,
     112,    -1,   513,    -1,   213,    -1,    13,    -1,    84,    -1,
     126,    -1,   148,    -1,   390,    -1,   432,    -1,   367,    -1,
     159,    -1,   188,   342,    -1,   431,    92,    -1,   467,    -1,
      84,   473,   470,    -1,   256,   470,    -1,   396,   435,    -1,
     396,    59,    -1,    84,   529,    -1,   431,   529,    -1,    84,
     410,    -1,    13,   410,    -1,    84,   514,    -1,    -1,    16,
      -1,  1175,  1173,  1174,    -1,  1175,    -1,   463,   476,    -1,
     228,   476,    -1,    58,   476,    -1,   554,    -1,  1122,   567,
     554,    -1,   554,   567,   554,    -1,  1116,    -1,  1125,    -1,
    1177,   562,  1125,    -1,  1179,    -1,  1178,   562,  1179,    -1,
    1125,   207,    44,   476,    -1,  1125,   207,    44,   353,   476,
      -1,  1125,    -1,    -1,   560,  1181,   561,    -1,  1181,   562,
    1182,    -1,  1182,    -1,  1122,    -1,    -1,   397,  1174,    -1,
     397,   452,    -1,   397,   538,    -1,   397,   324,    -1,    -1,
     535,  1185,    -1,  1185,  1186,    -1,  1186,    -1,   188,   342,
      -1,   285,   972,    -1,   288,   972,    -1,   284,   972,    -1,
     289,   972,    -1,    -1,    28,  1188,  1189,    -1,    -1,   536,
      -1,    -1,    16,   328,    51,    -1,    16,    51,    -1,    -1,
     389,    -1,   328,   389,    -1,    -1,   416,    -1,    69,  1189,
    1190,  1191,    -1,   407,  1189,  1190,  1191,    -1,   407,  1189,
     485,  1192,  1122,    -1,   416,  1122,    -1,   389,   416,  1122,
      -1,    -1,  1198,    -1,    -1,   503,  1204,  1199,   839,    -1,
      -1,  1198,    -1,  1201,    -1,    -1,  1202,  1203,    -1,   962,
     966,    -1,   968,    -1,    -1,   122,    -1,    12,    -1,   420,
    1208,  1207,  1209,    -1,    -1,   560,  1208,  1205,   561,  1206,
    1197,  1209,    -1,   841,    -1,    -1,    -1,  1212,  1211,    -1,
    1213,  1212,  1218,    -1,  1218,    -1,  1226,    -1,  1228,    -1,
      -1,   109,   142,  1125,    -1,  1214,    -1,  1214,  1215,    -1,
    1215,    -1,   347,   395,    -1,    11,   142,   499,    -1,    11,
     142,   294,    -1,    11,   142,   474,    -1,    -1,  1215,    -1,
      -1,   450,   419,   109,    -1,   450,   419,   224,    -1,    -1,
    1217,   529,  1116,  1219,  1220,    18,  1222,  1225,    -1,    -1,
     560,  1221,   561,    -1,  1122,    -1,  1221,   562,  1122,    -1,
      -1,  1223,  1224,    -1,   420,   854,   841,    -1,   560,   854,
     840,   561,  1200,    -1,    -1,   535,    57,   342,    -1,   535,
      49,    57,   342,    -1,   535,   252,    57,   342,    -1,    -1,
     488,   854,   596,   672,   673,   337,   854,  1116,   168,   854,
     131,   414,  1227,   636,    -1,    -1,   702,   854,   175,   596,
    1229,   597,    -1,    -1,    -1,    -1,    -1,   366,   854,   596,
    1230,   560,  1231,   617,   561,  1232,   604,  1233,   636,    -1,
     539,  1236,  1235,  1237,    -1,   539,   138,  1235,  1239,    -1,
     539,   362,  1235,    -1,   539,    69,  1235,  1238,    -1,   539,
     407,  1235,    -1,   539,   382,    -1,  1104,    -1,  1104,   562,
    1104,    -1,  1104,   562,  1104,   562,   972,    -1,    28,    -1,
     454,    -1,    -1,   230,    -1,   402,    -1,    -1,   339,   355,
      -1,    -1,    -1,   468,  1240,  1241,    -1,    -1,   168,   296,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,  1201,  1201,  1215,  1218,  1219,  1224,  1225,  1226,  1227,
    1228,  1229,  1230,  1231,  1232,  1233,  1234,  1235,  1236,  1237,
    1238,  1239,  1240,  1241,  1242,  1243,  1244,  1245,  1246,  1247,
    1248,  1249,  1250,  1251,  1252,  1253,  1254,  1255,  1256,  1257,
    1258,  1259,  1260,  1261,  1262,  1263,  1264,  1265,  1266,  1267,
    1268,  1269,  1270,  1274,  1288,  1289,  1294,  1308,  1315,  1325,
    1324,  1340,  1342,  1346,  1347,  1350,  1363,  1362,  1381,  1380,
    1391,  1392,  1395,  1400,  1405,  1410,  1415,  1419,  1424,  1428,
    1432,  1436,  1440,  1445,  1449,  1453,  1469,  1473,  1485,  1484,
    1507,  1506,  1527,  1526,  1539,  1538,  1546,  1554,  1568,  1583,
    1601,  1621,  1658,  1664,  1672,  1684,  1620,  1713,  1714,  1718,
    1719,  1724,  1726,  1728,  1730,  1732,  1734,  1736,  1742,  1743,
    1744,  1748,  1752,  1760,  1759,  1772,  1774,  1777,  1779,  1783,
    1787,  1794,  1796,  1800,  1801,  1806,  1825,  1851,  1853,  1857,
    1858,  1862,  1888,  1889,  1890,  1891,  1895,  1896,  1900,  1901,
    1906,  1909,  1936,  1935,  1991,  2006,  2005,  2045,  2069,  2069,
    2100,  2101,  2106,  2127,  2151,  2157,  2172,  2173,  2177,  2181,
    2190,  2195,  2200,  2208,  2223,  2241,  2242,  2246,  2246,  2292,
    2291,  2315,  2314,  2318,  2319,  2321,  2321,  2332,  2361,  2389,
    2405,  2404,  2421,  2438,  2440,  2441,  2445,  2466,  2489,  2491,
    2505,  2489,  2523,  2525,  2526,  2530,  2531,  2536,  2542,  2535,
    2561,  2560,  2576,  2577,  2581,  2582,  2587,  2591,  2586,  2608,
    2612,  2607,  2627,  2635,  2640,  2639,  2677,  2678,  2683,  2682,
    2709,  2720,  2722,  2719,  2746,  2745,  2763,  2765,  2770,  2772,
    2774,  2779,  2780,  2781,  2793,  2808,  2809,  2809,  2813,  2815,
    2814,  2817,  2816,  2822,  2838,  2821,  2852,  2853,  2856,  2857,
    2860,  2861,  2864,  2865,  2868,  2869,  2872,  2873,  2876,  2879,
    2880,  2882,  2884,  2887,  2888,  2891,  2892,  2893,  2896,  2897,
    2898,  2899,  2900,  2901,  2902,  2903,  2904,  2919,  2925,  2926,
    2927,  2928,  2933,  2938,  2943,  2958,  2959,  2960,  2961,  2962,
    2963,  2967,  2984,  3000,  3010,  3011,  3012,  3013,  3014,  3015,
    3018,  3019,  3020,  3023,  3024,  3025,  3028,  3029,  3032,  3033,
    3036,  3037,  3038,  3039,  3042,  3043,  3047,  3048,  3052,  3053,
    3060,  3068,  3076,  3093,  3097,  3103,  3105,  3109,  3113,  3114,
    3118,  3123,  3122,  3144,  3145,  3146,  3147,  3149,  3151,  3153,
    3155,  3157,  3159,  3162,  3165,  3168,  3171,  3173,  3176,  3179,
    3180,  3181,  3182,  3195,  3196,  3198,  3200,  3212,  3214,  3216,
    3218,  3219,  3220,  3221,  3222,  3223,  3225,  3227,  3229,  3229,
    3231,  3231,  3233,  3234,  3243,  3244,  3245,  3248,  3249,  3250,
    3251,  3252,  3256,  3260,  3261,  3265,  3266,  3270,  3271,  3272,
    3273,  3274,  3278,  3279,  3280,  3281,  3282,  3285,  3287,  3288,
    3292,  3293,  3294,  3297,  3304,  3305,  3308,  3309,  3312,  3313,
    3314,  3317,  3318,  3321,  3322,  3325,  3326,  3329,  3330,  3333,
    3334,  3335,  3336,  3338,  3339,  3345,  3351,  3357,  3363,  3364,
    3380,  3381,  3385,  3386,  3390,  3398,  3402,  3403,  3406,  3407,
    3411,  3420,  3424,  3425,  3428,  3438,  3439,  3443,  3444,  3447,
    3448,  3451,  3452,  3453,  3454,  3463,  3464,  3467,  3468,  3471,
    3472,  3473,  3482,  3484,  3486,  3491,  3490,  3502,  3503,  3506,
    3507,  3511,  3512,  3515,  3516,  3519,  3520,  3521,  3522,  3523,
    3526,  3527,  3528,  3529,  3530,  3533,  3534,  3535,  3547,  3548,
    3551,  3552,  3555,  3556,  3560,  3561,  3562,  3565,  3566,  3567,
    3568,  3581,  3582,  3583,  3586,  3587,  3591,  3594,  3595,  3598,
    3599,  3610,  3611,  3614,  3615,  3618,  3619,  3627,  3626,  3650,
    3649,  3664,  3663,  3682,  3681,  3701,  3699,  3714,  3715,  3717,
    3718,  3719,  3720,  3721,  3724,  3732,  3733,  3737,  3742,  3741,
    3749,  3758,  3748,  3770,  3777,  3781,  3788,  3795,  3801,  3807,
    3813,  3820,  3839,  3860,  3865,  3869,  3876,  3877,  3880,  3881,
    3885,  3886,  3887,  3891,  3892,  3893,  3896,  3897,  3898,  3899,
    3907,  3906,  3917,  3925,  3924,  3934,  3944,  3953,  3954,  3961,
    3961,  3967,  3968,  3972,  3973,  3974,  3978,  3979,  3996,  3997,
    4002,  4001,  4012,  4011,  4022,  4021,  4031,  4032,  4033,  4038,
    4037,  4049,  4050,  4053,  4054,  4057,  4058,  4059,  4063,  4062,
    4075,  4074,  4091,  4092,  4095,  4096,  4099,  4100,  4101,  4102,
    4103,  4104,  4108,  4107,  4119,  4120,  4121,  4126,  4125,  4131,
    4138,  4143,  4151,  4152,  4155,  4167,  4176,  4177,  4180,  4193,
    4194,  4199,  4198,  4208,  4209,  4212,  4225,  4225,  4235,  4236,
    4245,  4246,  4255,  4264,  4266,  4269,  4291,  4295,  4294,  4314,
    4322,  4314,  4328,  4329,  4330,  4331,  4332,  4335,  4342,  4349,
    4351,  4362,  4363,  4366,  4367,  4373,  4374,  4375,  4376,  4382,
    4388,  4394,  4404,  4407,  4409,  4415,  4425,  4426,  4427,  4440,
    4458,  4461,  4464,  4465,  4468,  4469,  4470,  4471,  4472,  4476,
    4477,  4481,  4481,  4498,  4500,  4505,  4506,  4506,  4523,  4525,
    4530,  4531,  4534,  4536,  4538,  4540,  4542,  4543,  4544,  4548,
    4549,  4550,  4551,  4553,  4555,  4558,  4562,  4568,  4572,  4578,
    4582,  4590,  4592,  4598,  4601,  4603,  4605,  4606,  4608,  4611,
    4612,  4615,  4616,  4619,  4621,  4623,  4626,  4627,  4628,  4630,
    4632,  4635,  4636,  4637,  4638,  4639,  4640,  4643,  4644,  4646,
    4646,  4647,  4647,  4648,  4648,  4649,  4649,  4651,  4652,  4653,
    4654,  4655,  4656,  4659,  4660,  4664,  4668,  4669,  4676,  4677,
    4678,  4679,  4680,  4682,  4683,  4684,  4685,  4686,  4690,  4691,
    4696,  4701,  4705,  4706,  4710,  4711,  4715,  4725,  4727,  4736,
    4738,  4749,  4751,  4762,  4773,  4784,  4795,  4797,  4799,  4801,
    4803,  4805,  4807,  4809,  4811,  4813,  4815,  4817,  4819,  4825,
    4827,  4829,  4834,  4839,  4841,  4843,  4848,  4850,  4852,  4854,
    4856,  4861,  4862,  4864,  4866,  4868,  4870,  4872,  4874,  4876,
    4878,  4880,  4882,  4884,  4888,  4890,  4900,  4902,  4904,  4906,
    4908,  4911,  4920,  4925,  4930,  4932,  4934,  4936,  4938,  4940,
    4942,  4944,  4949,  4954,  4956,  4958,  4960,  4962,  4964,  4966,
    4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,  4988,  4989,
    4994,  4996,  4998,  5000,  5002,  5004,  5006,  5008,  5010,  5017,
    5024,  5026,  5028,  5030,  5032,  5034,  5036,  5038,  5040,  5042,
    5044,  5046,  5048,  5050,  5052,  5066,  5065,  5182,  5186,  5191,
    5193,  5195,  5197,  5199,  5201,  5206,  5208,  5210,  5212,  5214,
    5219,  5223,  5225,  5227,  5229,  5231,  5233,  5237,  5240,  5243,
    5245,  5247,  5249,  5251,  5253,  5255,  5258,  5261,  5263,  5265,
    5267,  5269,  5271,  5274,  5276,  5278,  5280,  5285,  5286,  5287,
    5291,  5292,  5296,  5296,  5302,  5306,  5313,  5344,  5346,  5348,
    5350,  5352,  5354,  5356,  5359,  5361,  5358,  5364,  5366,  5373,
    5375,  5377,  5379,  5381,  5383,  5385,  5387,  5389,  5392,  5391,
    5406,  5405,  5420,  5426,  5432,  5445,  5446,  5449,  5450,  5455,
    5458,  5470,  5469,  5485,  5486,  5487,  5488,  5489,  5490,  5491,
    5492,  5493,  5494,  5495,  5499,  5500,  5504,  5504,  5509,  5510,
    5513,  5514,  5517,  5517,  5522,  5523,  5526,  5527,  5530,  5531,
    5534,  5540,  5550,  5551,  5560,  5565,  5566,  5586,  5588,  5592,
    5590,  5607,  5605,  5623,  5621,  5628,  5637,  5635,  5653,  5652,
    5662,  5673,  5671,  5690,  5689,  5700,  5710,  5711,  5712,  5717,
    5717,  5736,  5734,  5753,  5775,  5823,  5822,  5845,  5862,  5845,
    5869,  5873,  5899,  5900,  5903,  5904,  5910,  5917,  5925,  5925,
    5931,  5932,  5936,  5940,  5944,  5950,  5958,  5967,  5968,  5969,
    5970,  5971,  5972,  5973,  5974,  5975,  5976,  5977,  5978,  5979,
    5982,  5983,  5984,  5985,  5986,  5987,  5988,  5989,  5990,  5994,
    5995,  5996,  5997,  6000,  6002,  6003,  6006,  6007,  6010,  6012,
    6016,  6018,  6017,  6031,  6034,  6033,  6048,  6054,  6067,  6069,
    6072,  6074,  6078,  6079,  6092,  6110,  6114,  6115,  6119,  6132,
    6134,  6138,  6137,  6169,  6171,  6175,  6176,  6177,  6182,  6188,
    6192,  6193,  6197,  6201,  6208,  6215,  6224,  6225,  6226,  6227,
    6232,  6236,  6244,  6245,  6246,  6247,  6248,  6249,  6253,  6254,
    6255,  6256,  6257,  6260,  6263,  6262,  6291,  6292,  6295,  6296,
    6299,  6312,  6312,  6322,  6323,  6327,  6339,  6372,  6371,  6384,
    6383,  6392,  6404,  6415,  6414,  6431,  6438,  6438,  6450,  6457,
    6469,  6481,  6485,  6491,  6501,  6502,  6505,  6513,  6514,  6518,
    6519,  6527,  6536,  6526,  6546,  6553,  6545,  6563,  6575,  6576,
    6577,  6581,  6582,  6585,  6586,  6589,  6598,  6599,  6600,  6602,
    6601,  6611,  6612,  6615,  6616,  6617,  6617,  6618,  6618,  6622,
    6623,  6626,  6628,  6631,  6639,  6640,  6644,  6645,  6650,  6649,
    6662,  6663,  6666,  6671,  6679,  6680,  6683,  6685,  6685,  6693,
    6702,  6692,  6724,  6725,  6728,  6735,  6736,  6739,  6748,  6749,
    6755,  6754,  6768,  6767,  6776,  6775,  6783,  6782,  6792,  6793,
    6796,  6803,  6816,  6817,  6821,  6822,  6825,  6826,  6827,  6830,
    6840,  6842,  6847,  6846,  6860,  6868,  6877,  6886,  6895,  6905,
    6904,  6907,  6917,  6927,  6931,  6936,  6935,  6940,  6950,  6955,
    6961,  6966,  6971,  6973,  6975,  6977,  6979,  6988,  6990,  6992,
    6994,  7003,  7011,  7019,  7021,  7023,  7033,  7040,  7046,  7054,
    7062,  7066,  7070,  7077,  7084,  7094,  7104,  7114,  7127,  7141,
    7154,  7155,  7157,  7159,  7162,  7163,  7166,  7167,  7170,  7171,
    7174,  7175,  7178,  7179,  7181,  7183,  7186,  7198,  7197,  7212,
    7211,  7221,  7222,  7225,  7226,  7230,  7231,  7232,  7240,  7239,
    7251,  7252,  7255,  7255,  7256,  7257,  7258,  7259,  7260,  7261,
    7262,  7263,  7264,  7265,  7268,  7269,  7273,  7272,  7281,  7282,
    7285,  7286,  7287,  7291,  7290,  7299,  7303,  7308,  7320,  7320,
    7328,  7329,  7330,  7335,  7345,  7344,  7357,  7375,  7386,  7391,
    7401,  7374,  7406,  7415,  7416,  7419,  7420,  7432,  7436,  7437,
    7438,  7440,  7442,  7445,  7446,  7449,  7454,  7461,  7466,  7472,
    7474,  7477,  7478,  7481,  7486,  7492,  7494,  7501,  7502,  7503,
    7506,  7508,  7513,  7514,  7519,  7520,  7526,  7531,  7533,  7535,
    7540,  7542,  7553,  7566,  7586,  7587,  7588,  7597,  7598,  7599,
    7601,  7602,  7603,  7604,  7605,  7619,  7633,  7634,  7635,  7638,
    7639,  7640,  7641,  7649,  7664,  7665,  7668,  7674,  7685,  7688,
    7722,  7726,  7734,  7738,  7806,  7821,  7845,  7846,  7862,  7872,
    7875,  7876,  7877,  7881,  7885,  7886,  7911,  7923,  7936,  7948,
    7949,  7958,  7959,  7968,  7969,  7970,  7973,  7986,  7999,  8013,
    8014,  8015,  8016,  8017,  8018,  8019,  8020,  8021,  8022,  8023,
    8024,  8025,  8026,  8027,  8028,  8029,  8030,  8031,  8032,  8033,
    8034,  8035,  8036,  8037,  8038,  8039,  8040,  8041,  8042,  8043,
    8044,  8045,  8046,  8047,  8048,  8049,  8059,  8060,  8061,  8062,
    8063,  8064,  8065,  8066,  8067,  8068,  8069,  8070,  8071,  8072,
    8073,  8074,  8075,  8076,  8077,  8078,  8079,  8080,  8081,  8082,
    8083,  8084,  8085,  8086,  8087,  8088,  8089,  8090,  8091,  8092,
    8093,  8094,  8095,  8096,  8097,  8098,  8099,  8100,  8101,  8102,
    8103,  8104,  8105,  8106,  8107,  8108,  8109,  8110,  8111,  8112,
    8113,  8114,  8115,  8116,  8117,  8118,  8119,  8120,  8121,  8122,
    8123,  8124,  8125,  8126,  8127,  8128,  8129,  8130,  8131,  8132,
    8133,  8134,  8135,  8136,  8137,  8138,  8139,  8140,  8141,  8142,
    8143,  8144,  8145,  8146,  8147,  8148,  8149,  8150,  8151,  8152,
    8153,  8154,  8155,  8156,  8157,  8158,  8159,  8160,  8161,  8162,
    8163,  8164,  8165,  8166,  8167,  8168,  8169,  8170,  8171,  8172,
    8173,  8174,  8175,  8176,  8177,  8178,  8179,  8180,  8181,  8182,
    8183,  8184,  8185,  8186,  8187,  8188,  8189,  8190,  8191,  8192,
    8193,  8194,  8195,  8196,  8197,  8198,  8199,  8200,  8201,  8202,
    8203,  8204,  8205,  8206,  8207,  8208,  8209,  8210,  8211,  8212,
    8213,  8214,  8215,  8216,  8217,  8218,  8219,  8220,  8221,  8222,
    8223,  8224,  8225,  8226,  8227,  8228,  8229,  8230,  8231,  8232,
    8233,  8234,  8235,  8236,  8237,  8238,  8239,  8240,  8241,  8242,
    8243,  8244,  8245,  8246,  8247,  8248,  8249,  8250,  8251,  8252,
    8253,  8254,  8255,  8256,  8257,  8258,  8259,  8260,  8261,  8262,
    8263,  8264,  8265,  8266,  8267,  8268,  8269,  8270,  8271,  8278,
    8277,  8291,  8292,  8295,  8296,  8299,  8299,  8371,  8372,  8373,
    8374,  8378,  8379,  8383,  8384,  8385,  8386,  8390,  8391,  8392,
    8393,  8397,  8398,  8401,  8481,  8494,  8498,  8503,  8510,  8525,
    8538,  8559,  8566,  8604,  8647,  8661,  8662,  8663,  8664,  8668,
    8669,  8676,  8685,  8686,  8687,  8688,  8689,  8697,  8696,  8712,
    8713,  8716,  8717,  8720,  8728,  8729,  8730,  8731,  8736,  8735,
    8756,  8768,  8781,  8780,  8799,  8800,  8804,  8805,  8809,  8810,
    8811,  8812,  8814,  8813,  8824,  8825,  8826,  8827,  8828,  8834,
    8839,  8846,  8859,  8871,  8878,  8883,  8891,  8904,  8918,  8920,
    8923,  8924,  8931,  8933,  8937,  8938,  8941,  8941,  8942,  8942,
    8943,  8943,  8944,  8944,  8945,  8946,  8947,  8948,  8949,  8950,
    8951,  8952,  8953,  8954,  8955,  8956,  8957,  8958,  8959,  8960,
    8961,  8962,  8963,  8964,  8965,  8966,  8967,  8972,  8973,  8977,
    8978,  8982,  8992,  9002,  9015,  9030,  9043,  9056,  9068,  9069,
    9078,  9079,  9088,  9113,  9115,  9122,  9126,  9129,  9130,  9133,
    9154,  9155,  9159,  9163,  9167,  9174,  9175,  9178,  9179,  9183,
    9184,  9190,  9196,  9202,  9212,  9211,  9221,  9222,  9226,  9227,
    9228,  9232,  9233,  9234,  9238,  9239,  9243,  9253,  9260,  9270,
    9279,  9293,  9294,  9299,  9298,  9333,  9334,  9335,  9339,  9339,
    9363,  9364,  9368,  9369,  9370,  9374,  9379,  9378,  9398,  9404,
    9424,  9446,  9448,  9453,  9455,  9457,  9469,  9479,  9492,  9494,
    9496,  9501,  9506,  9508,  9510,  9516,  9517,  9523,  9524,  9526,
    9532,  9531,  9546,  9547,  9551,  9556,  9564,  9564,  9582,  9591,
    9604,  9605,  9607,  9609,  9622,  9620,  9695,  9694,  9704,  9733,
    9740,  9747,  9703,  9769,  9773,  9777,  9781,  9785,  9789,  9795,
    9802,  9809,  9818,  9819,  9823,  9824,  9825,  9829,  9830,  9834,
    9835,  9835,  9840,  9841
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "END_OF_INPUT", "ABORT_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "ATAN",
  "AUTO_INC", "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM",
  "BEGIN_SYM", "BENCHMARK_SYM", "BERKELEY_DB_SYM", "BIGINT", "BINARY",
  "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR", "BIT_SYM", "BIT_XOR",
  "BLOB_SYM", "BOOLEAN_SYM", "BOOL_SYM", "BOTH", "BTREE_SYM", "BY",
  "BYTE_SYM", "CACHE_SYM", "CALL_SYM", "CASCADE", "CASCADED", "CAST_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE",
  "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPRESSED_SYM", "CONCAT", "CONCAT_WS", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT", "CONTAINS_SYM",
  "CONTINUE_SYM", "CONVERT_SYM", "CONVERT_TZ_SYM", "COUNT_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL",
  "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM",
  "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM",
  "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DECODE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_DECRYPT_SYM", "DES_ENCRYPT_SYM", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSEIF_SYM",
  "ELT_FUNC", "ENABLE_SYM", "ENCLOSED", "ENCODE_SYM", "ENCRYPT", "END",
  "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM", "ERRORS",
  "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SET", "EXTENDED_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FETCH_SYM", "FIELD_FUNC", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FORMAT_SYM", "FOR_SYM", "FOUND_SYM",
  "FRAC_SECOND_SYM", "FROM", "FROM_UNIXTIME", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "FUNC_ARG0", "FUNC_ARG1", "FUNC_ARG2", "FUNC_ARG3", "GE",
  "GEOMCOLLFROMTEXT", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GEOMFROMTEXT",
  "GEOMFROMWKB", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GREATEST_SYM", "GROUP", "GROUP_CONCAT_SYM", "GROUP_UNIQUE_USERS",
  "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING", "HELP_SYM", "HEX_NUM",
  "HIGH_PRIORITY", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INNER_SYM", "INNOBASE_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT",
  "INSERT_METHOD", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_SYM", "KILL_SYM", "LABEL_SYM", "LANGUAGE_SYM",
  "LAST_INSERT_ID", "LAST_SYM", "LE", "LEADING", "LEAST_SYM", "LEAVES",
  "LEAVE_SYM", "LEFT", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEFROMTEXT", "LINES", "LINESTRING", "LOAD", "LOCAL_SYM", "LOCATE",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGS_SYM", "LOG_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MAKE_SET_SYM", "MASTER_CONNECT_RETRY_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_POS_WAIT",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SYM", "MASTER_USER_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SYM", "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MERGE_SYM",
  "MICROSECOND_SYM", "MIGRATE_SYM", "MINUTE_MICROSECOND_SYM",
  "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS", "MIN_SYM",
  "MLINEFROMTEXT", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MPOINTFROMTEXT", "MPOLYFROMTEXT", "MULTILINESTRING",
  "MULTIPOINT", "MULTIPOLYGON", "MUTEX_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEW_SYM", "NEXT_SYM", "NONE_SYM", "NOT2_SYM", "NOT_SYM",
  "NOW_SYM", "NO_SYM", "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM",
  "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM", "OJ_SYM", "OLD_PASSWORD",
  "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTION",
  "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER",
  "OUTFILE", "OUT_SYM", "PACK_KEYS_SYM", "PARTIAL", "PASSWORD",
  "PARAM_MARKER", "PHASE_SYM", "POINTFROMTEXT", "POINT_SYM",
  "POLYFROMTEXT", "POLYGON", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE", "PROCESS",
  "PROCESSLIST_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK",
  "RAID_0_SYM", "RAID_CHUNKS", "RAID_CHUNKSIZE", "RAID_STRIPED_SYM",
  "RAID_TYPE", "RAND", "READS_SYM", "READ_SYM", "REAL", "RECOVER_SYM",
  "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "RENAME",
  "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE", "REPLICATION",
  "REQUIRE_SYM", "RESET_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT",
  "RESUME_SYM", "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUND", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_COUNT_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM",
  "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM",
  "SERIAL_SYM", "SESSION_SYM", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE",
  "SMALLINT", "SNAPSHOT_SYM", "SOUNDS_SYM", "SPATIAL_SYM", "SPECIFIC_SYM",
  "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT",
  "SQL_BUFFER_RESULT", "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS",
  "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD",
  "SSL_SYM", "STARTING", "START_SYM", "STATUS_SYM", "STD_SYM",
  "STDDEV_SAMP_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBSTRING",
  "SUBSTRING_INDEX", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "TIMESTAMP", "TIMESTAMP_ADD",
  "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB", "TINYINT", "TINYTEXT",
  "TO_SYM", "TRAILING", "TRANSACTION_SYM", "TRIGGER_SYM", "TRIGGERS_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "UDF_SONAME_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM",
  "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDO_SYM", "UNICODE_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNIQUE_USERS", "UNIX_TIMESTAMP",
  "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM",
  "UPGRADE_SYM", "USAGE", "USER", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VAR_SAMP_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VIEW_SYM", "WARNINGS", "WEEK_SYM",
  "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH", "WORK_SYM", "WRITE_SYM",
  "X509_SYM", "XA_SYM", "XOR", "YEARWEEK", "YEAR_MONTH_SYM", "YEAR_SYM",
  "ZEROFILL", "TABLE_REF_PRIORITY", "ELSE", "THEN_SYM", "CASE_SYM",
  "BETWEEN_SYM", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'",
  "'~'", "NEG", "'('", "')'", "','", "'!'", "'{'", "'}'", "'@'", "'.'",
  "';'", "':'", "$accept", "query", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "@1", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "@2", "change", "@3", "master_defs", "master_def", "master_file_def",
  "create", "@4", "@5", "@6", "@7", "clear_privileges", "sp_name",
  "create_function_tail", "@8", "@9", "@10", "@11", "@12", "sp_a_chistics",
  "sp_c_chistics", "sp_chistic", "sp_c_chistic", "sp_suid", "call", "@13",
  "opt_sp_cparam_list", "opt_sp_cparams", "sp_cparams", "sp_fdparam_list",
  "sp_fdparams", "sp_init_param", "sp_fdparam", "sp_pdparam_list",
  "sp_pdparams", "sp_pdparam", "sp_opt_inout", "sp_proc_stmts",
  "sp_proc_stmts1", "sp_decls", "sp_decl", "@14", "@15", "sp_cursor_stmt",
  "@16", "sp_handler_type", "sp_hcond_list", "sp_cond", "opt_value",
  "sp_hcond", "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "@17",
  "@18", "@19", "@20", "@21", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "@22", "@23", "@24", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "@25", "@26", "searched_case_stmt", "@27",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "@28", "@29", "searched_when_clause", "@30", "@31",
  "else_clause_opt", "sp_labeled_control", "@32", "sp_opt_label",
  "sp_unlabeled_control", "@33", "@34", "@35", "@36", "trg_action_time",
  "trg_event", "create2", "create2a", "@37", "create3", "@38", "@39",
  "create_select", "@40", "@41", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "default_charset",
  "default_collation", "storage_engines", "row_types", "raid_types",
  "merge_insert_types", "opt_select_from", "udf_func_type", "udf_type",
  "field_list", "field_list_item", "column_def", "key_def",
  "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "@42", "type", "@43", "@44", "spatial_type",
  "char", "nchar", "varchar", "nvarchar", "int_type", "real_type",
  "float_options", "precision", "field_options", "field_opt_list",
  "field_option", "opt_len", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "opt_binary", "opt_bin_mod", "opt_bin_charset",
  "opt_primary", "references", "@45", "opt_ref_list", "ref_list",
  "opt_on_delete", "opt_on_delete_list", "opt_on_delete_item",
  "delete_option", "key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique_or_fulltext", "key_alg",
  "opt_btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_component", "string_list", "alter", "@46", "@47", "@48", "@49",
  "@50", "ident_or_empty", "alter_list", "add_column", "alter_list_item",
  "@51", "@52", "@53", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "@54", "@55", "start",
  "start_transaction_opts", "slave_thread_opts", "@56",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "restore", "@57", "backup", "@58", "checksum", "@59",
  "opt_checksum_type", "repair", "@60", "opt_mi_repair_type",
  "mi_repair_types", "mi_repair_type", "analyze", "@61", "check", "@62",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "@63", "opt_no_write_to_binlog", "rename", "@64", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "keycache_list",
  "assign_to_keycache", "key_cache_name", "preload", "@65", "preload_list",
  "preload_keys", "cache_keys_spec", "@66", "cache_key_list_or_empty",
  "opt_ignore_leaves", "select", "select_init", "select_paren",
  "select_init2", "@67", "select_part2", "@68", "@69", "select_into",
  "select_from", "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_item2", "select_alias", "optional_braces",
  "expr", "@70", "bool_or_expr", "bool_term", "@71", "bool_and_expr",
  "bool_factor", "bool_test", "bool_pri", "predicate", "bit_expr",
  "bit_term", "bit_factor", "value_expr", "term", "factor", "or", "and",
  "not", "not2", "comp_op", "all_or_any", "interval_expr", "simple_expr",
  "@72", "geometry_function", "fulltext_options", "udf_expr_list",
  "udf_expr_list2", "@73", "udf_expr_list3", "udf_expr", "sum_expr", "@74",
  "@75", "@76", "variable", "@77", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "@78",
  "cast_type", "opt_expr_list", "expr_list", "@79", "expr_list2",
  "ident_list_arg", "ident_list", "@80", "ident_list2", "opt_expr",
  "opt_else", "when_list", "table_ref", "join_table_list",
  "derived_table_list", "join_table", "@81", "@82", "@83", "@84", "@85",
  "@86", "@87", "normal_join", "table_factor", "@88", "@89",
  "select_derived", "@90", "select_derived2", "@91", "@92",
  "get_select_lex", "select_derived_init", "opt_outer",
  "opt_key_definition", "key_usage_list", "@93", "key_list_or_empty",
  "key_usage_list2", "using_list", "interval", "interval_time_st",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "@94", "having_clause", "@95", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "@96", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "ulonglong_num", "procedure_clause", "@97", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "@98",
  "select_var_list", "select_var_ident", "into", "@99", "into_destination",
  "@100", "do", "@101", "drop", "@102", "table_list", "table_name",
  "if_exists", "opt_temporary", "insert", "@103", "@104", "replace",
  "@105", "@106", "insert_lock_option", "replace_lock_option", "insert2",
  "insert_table", "insert_field_spec", "@107", "fields", "insert_values",
  "@108", "@109", "values_list", "ident_eq_list", "ident_eq_value",
  "equal", "opt_equal", "no_braces", "@110", "opt_values", "values",
  "expr_or_default", "opt_insert_update", "@111", "update", "@112", "@113",
  "update_list", "update_elem", "insert_update_list", "insert_update_elem",
  "opt_low_priority", "delete", "@114", "single_multi", "@115", "@116",
  "@117", "table_wild_list", "table_wild_one", "opt_wild",
  "opt_delete_options", "opt_delete_option", "truncate", "opt_table_sym",
  "show", "@118", "show_param", "@119", "@120", "show_engine_param",
  "master_or_binary", "opt_storage", "opt_db", "opt_full", "from_or_in",
  "binlog_in", "binlog_from", "wild_and_where", "describe", "@121", "@122",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "@123", "flush_options", "flush_option", "@124",
  "opt_table_list", "reset", "@125", "reset_options", "reset_option",
  "purge", "@126", "purge_options", "purge_option", "kill", "@127",
  "kill_option", "use", "load", "@128", "load_data", "@129", "@130",
  "@131", "@132", "opt_local", "load_data_lock", "opt_duplicate",
  "opt_field_term", "field_term_list", "field_term", "opt_line_term",
  "line_term_list", "line_term", "opt_ignore_lines",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "insert_ident", "table_wild",
  "order_ident", "simple_ident", "simple_ident_nospvar", "simple_ident_q",
  "field_ident", "table_ident", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "@133", "opt_option", "option_value_list", "option_type_value",
  "@134", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "@135",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "@136", "handler", "@137", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "@138",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "@139", "@140", "@141",
  "@142", "opt_and", "require_list", "require_list_element", "grant_ident",
  "user_list", "grant_list", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "grant_option_list", "grant_option", "begin", "@143", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "@144",
  "union_opt", "union_order_or_limit", "@145", "order_or_limit",
  "union_option", "subselect", "@146", "subselect_init", "subselect_start",
  "subselect_end", "view_or_trigger_or_sp", "view_or_trigger_or_sp_tail",
  "definer", "view_replace_or_algorithm", "view_replace", "view_algorithm",
  "view_algorithm_opt", "view_suid", "view_tail", "@147", "view_list_opt",
  "view_list", "view_select", "@148", "view_select_aux",
  "view_check_option", "trigger_tail", "@149", "sp_tail", "@150", "@151",
  "@152", "@153", "@154", "xa", "xid", "begin_or_start",
  "opt_join_or_resume", "opt_one_phase", "opt_suspend", "@155",
  "opt_migrate", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     124,    38,    45,    43,    42,    47,    37,    94,   126,   805,
      40,    41,    44,    33,   123,   125,    64,    46,    59,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short int yyr1[] =
{
       0,   570,   571,   571,   572,   572,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   573,   573,   573,   573,   573,   573,   573,
     573,   573,   573,   574,   575,   575,   576,   577,   577,   579,
     578,   580,   580,   581,   581,   582,   584,   583,   586,   585,
     587,   587,   588,   588,   588,   588,   588,   588,   588,   588,
     588,   588,   588,   588,   589,   589,   589,   589,   591,   590,
     592,   590,   593,   590,   594,   590,   590,   595,   596,   596,
     597,   598,   599,   600,   601,   602,   597,   603,   603,   604,
     604,   605,   605,   605,   605,   605,   605,   605,   606,   606,
     606,   607,   607,   609,   608,   610,   610,   611,   611,   612,
     612,   613,   613,   614,   614,   615,   616,   617,   617,   618,
     618,   619,   620,   620,   620,   620,   621,   621,   622,   622,
     623,   623,   625,   624,   624,   626,   624,   624,   628,   627,
     629,   629,   630,   630,   631,   631,   632,   632,   633,   633,
     633,   633,   633,   634,   634,   635,   635,   637,   636,   638,
     636,   639,   636,   636,   636,   640,   636,   636,   636,   636,
     641,   636,   636,   642,   642,   642,   643,   643,   645,   646,
     647,   644,   648,   648,   648,   649,   649,   651,   652,   650,
     654,   653,   655,   655,   656,   656,   658,   659,   657,   661,
     662,   660,   663,   663,   665,   664,   666,   666,   668,   667,
     667,   669,   670,   667,   671,   667,   672,   672,   673,   673,
     673,   674,   674,   674,   674,   675,   676,   675,   677,   678,
     677,   679,   677,   681,   682,   680,   683,   683,   684,   684,
     685,   685,   686,   686,   687,   687,   688,   688,   689,   690,
     690,   691,   691,   692,   692,   693,   693,   693,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   694,   694,   694,   694,   694,   694,   694,   694,   694,
     694,   695,   696,   697,   698,   698,   698,   698,   698,   698,
     699,   699,   699,   700,   700,   700,   701,   701,   702,   702,
     703,   703,   703,   703,   704,   704,   705,   705,   706,   706,
     707,   707,   707,   707,   707,   708,   708,   709,   710,   710,
     711,   713,   712,   714,   714,   714,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   714,   714,
     714,   714,   714,   714,   714,   714,   714,   714,   715,   714,
     716,   714,   714,   714,   717,   717,   717,   717,   717,   717,
     717,   717,   718,   719,   719,   720,   720,   721,   721,   721,
     721,   721,   722,   722,   722,   722,   722,   723,   723,   723,
     724,   724,   724,   725,   726,   726,   727,   727,   728,   728,
     728,   729,   729,   730,   730,   731,   731,   732,   732,   733,
     733,   733,   733,   733,   733,   733,   733,   733,   733,   733,
     734,   734,   735,   735,   736,   736,   737,   737,   738,   738,
     739,   739,   740,   740,   741,   742,   742,   743,   743,   744,
     744,   745,   745,   745,   745,   745,   745,   746,   746,   747,
     747,   747,   747,   748,   748,   750,   749,   751,   751,   752,
     752,   753,   753,   754,   754,   755,   755,   755,   755,   755,
     756,   756,   756,   756,   756,   757,   757,   757,   758,   758,
     759,   759,   760,   760,   761,   761,   761,   762,   762,   762,
     762,   763,   763,   763,   764,   764,   764,   765,   765,   766,
     766,   767,   767,   768,   768,   769,   769,   771,   770,   772,
     770,   773,   770,   774,   770,   775,   770,   776,   776,   777,
     777,   777,   777,   777,   778,   779,   779,   779,   780,   779,
     781,   782,   779,   779,   779,   779,   779,   779,   779,   779,
     779,   779,   779,   779,   779,   779,   783,   783,   784,   784,
     785,   785,   785,   786,   786,   786,   787,   787,   787,   787,
     789,   788,   788,   790,   788,   788,   791,   792,   792,   794,
     793,   795,   795,   796,   796,   796,   797,   797,   798,   798,
     800,   799,   802,   801,   804,   803,   805,   805,   805,   807,
     806,   808,   808,   809,   809,   810,   810,   810,   812,   811,
     814,   813,   815,   815,   816,   816,   817,   817,   817,   817,
     817,   817,   819,   818,   820,   820,   820,   822,   821,   821,
     823,   823,   824,   824,   825,   826,   827,   827,   828,   829,
     829,   831,   830,   832,   832,   833,   835,   834,   836,   836,
     837,   837,   838,   839,   839,   840,   840,   842,   841,   844,
     845,   843,   846,   846,   846,   846,   846,   847,   847,   848,
     848,   849,   849,   850,   850,   850,   850,   850,   850,   850,
     850,   850,   850,   851,   851,   851,   852,   852,   852,   853,
     854,   855,   856,   856,   857,   857,   857,   857,   857,   858,
     858,   860,   859,   861,   861,   862,   863,   862,   864,   864,
     865,   865,   866,   866,   866,   866,   866,   866,   866,   867,
     867,   867,   867,   867,   867,   868,   868,   868,   868,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   868,   869,
     869,   870,   870,   871,   871,   871,   872,   872,   872,   872,
     872,   873,   873,   873,   873,   873,   873,   874,   874,   875,
     875,   876,   876,   877,   877,   878,   878,   879,   879,   879,
     879,   879,   879,   880,   880,   881,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   883,   882,   882,   882,   882,
     882,   882,   882,   882,   882,   882,   882,   882,   882,   882,
     882,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   884,   884,
     884,   884,   884,   884,   884,   884,   884,   885,   885,   885,
     886,   886,   888,   887,   889,   889,   890,   891,   891,   891,
     891,   891,   891,   891,   892,   893,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   891,   891,   891,   894,   891,
     896,   895,   897,   897,   897,   898,   898,   899,   899,   900,
     900,   902,   901,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   904,   904,   906,   905,   907,   907,
     908,   908,   910,   909,   911,   911,   912,   912,   913,   913,
     914,   914,   915,   915,   916,   917,   917,   918,   918,   919,
     918,   920,   918,   921,   918,   918,   922,   918,   923,   918,
     918,   924,   918,   925,   918,   918,   926,   926,   926,   928,
     927,   929,   927,   927,   927,   931,   930,   933,   934,   932,
     935,   936,   937,   937,   938,   938,   938,   938,   940,   939,
     941,   941,   942,   942,   942,   943,   943,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     945,   945,   945,   945,   945,   945,   945,   945,   945,   946,
     946,   946,   946,   947,   947,   947,   948,   948,   949,   949,
     950,   951,   950,   952,   953,   952,   954,   954,   955,   955,
     956,   956,   957,   957,   957,   958,   959,   959,   960,   961,
     961,   963,   962,   964,   964,   965,   965,   965,   966,   966,
     967,   967,   968,   969,   969,   969,   970,   970,   970,   970,
     971,   971,   972,   972,   972,   972,   972,   972,   973,   973,
     973,   973,   973,   974,   975,   974,   976,   976,   977,   977,
     978,   980,   979,   981,   981,   982,   982,   984,   983,   986,
     985,   985,   985,   988,   987,   989,   990,   989,   989,   989,
     989,   989,   989,   989,   991,   991,   992,   993,   993,   994,
     994,   996,   997,   995,   999,  1000,   998,  1001,  1001,  1001,
    1001,  1002,  1002,  1003,  1003,  1004,  1005,  1005,  1005,  1006,
    1005,  1007,  1007,  1008,  1008,  1009,  1008,  1010,  1008,  1011,
    1011,  1012,  1012,  1013,  1014,  1014,  1015,  1015,  1017,  1016,
    1018,  1018,  1019,  1019,  1020,  1020,  1021,  1022,  1021,  1024,
    1025,  1023,  1026,  1026,  1027,  1028,  1028,  1029,  1030,  1030,
    1032,  1031,  1034,  1033,  1035,  1033,  1036,  1033,  1037,  1037,
    1038,  1038,  1039,  1039,  1040,  1040,  1041,  1041,  1041,  1042,
    1043,  1043,  1045,  1044,  1046,  1046,  1046,  1046,  1046,  1047,
    1046,  1046,  1046,  1046,  1046,  1048,  1046,  1046,  1046,  1046,
    1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,
    1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,
    1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1049,  1049,
    1050,  1050,  1051,  1051,  1052,  1052,  1053,  1053,  1054,  1054,
    1055,  1055,  1056,  1056,  1057,  1057,  1057,  1059,  1058,  1060,
    1058,  1061,  1061,  1062,  1062,  1063,  1063,  1063,  1065,  1064,
    1066,  1066,  1068,  1067,  1067,  1067,  1067,  1067,  1067,  1067,
    1067,  1067,  1067,  1067,  1069,  1069,  1071,  1070,  1072,  1072,
    1073,  1073,  1073,  1075,  1074,  1076,  1077,  1077,  1079,  1078,
    1080,  1080,  1080,  1081,  1083,  1082,  1082,  1085,  1086,  1087,
    1088,  1084,  1084,  1089,  1089,  1090,  1090,  1090,  1091,  1091,
    1091,  1092,  1092,  1093,  1093,  1094,  1094,  1094,  1094,  1095,
    1095,  1096,  1096,  1097,  1097,  1098,  1098,  1099,  1099,  1099,
    1100,  1100,  1101,  1101,  1102,  1102,  1103,  1103,  1103,  1103,
    1104,  1104,  1104,  1105,  1106,  1106,  1106,  1107,  1107,  1107,
    1107,  1107,  1107,  1107,  1107,  1107,  1107,  1107,  1107,  1108,
    1108,  1108,  1108,  1108,  1109,  1109,  1110,  1110,  1111,  1112,
    1112,  1113,  1113,  1114,  1114,  1114,  1115,  1115,  1115,  1115,
    1116,  1116,  1116,  1117,  1118,  1118,  1119,  1120,  1121,  1122,
    1122,  1123,  1123,  1124,  1124,  1124,  1125,  1125,  1125,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,
    1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1127,  1129,
    1128,  1130,  1130,  1131,  1131,  1133,  1132,  1134,  1134,  1134,
    1134,  1135,  1135,  1136,  1136,  1136,  1136,  1137,  1137,  1137,
    1137,  1138,  1138,  1139,  1139,  1140,  1140,  1140,  1140,  1140,
    1140,  1140,  1141,  1141,  1141,  1142,  1142,  1142,  1142,  1143,
    1143,  1143,  1144,  1144,  1144,  1144,  1144,  1146,  1145,  1147,
    1147,  1148,  1148,  1149,  1150,  1150,  1150,  1150,  1152,  1151,
    1153,  1153,  1154,  1153,  1155,  1155,  1156,  1156,  1157,  1157,
    1157,  1157,  1158,  1157,  1159,  1159,  1159,  1159,  1159,  1160,
    1161,  1161,  1161,  1161,  1162,  1163,  1163,  1163,  1164,  1164,
    1165,  1165,  1166,  1166,  1167,  1167,  1169,  1168,  1170,  1168,
    1171,  1168,  1172,  1168,  1168,  1168,  1168,  1168,  1168,  1168,
    1168,  1168,  1168,  1168,  1168,  1168,  1168,  1168,  1168,  1168,
    1168,  1168,  1168,  1168,  1168,  1168,  1168,  1173,  1173,  1174,
    1174,  1175,  1175,  1175,  1176,  1176,  1176,  1176,  1177,  1177,
    1178,  1178,  1179,  1179,  1179,  1180,  1180,  1181,  1181,  1182,
    1183,  1183,  1183,  1183,  1183,  1184,  1184,  1185,  1185,  1186,
    1186,  1186,  1186,  1186,  1188,  1187,  1189,  1189,  1190,  1190,
    1190,  1191,  1191,  1191,  1192,  1192,  1193,  1194,  1194,  1195,
    1196,  1197,  1197,  1199,  1198,  1200,  1200,  1200,  1202,  1201,
    1203,  1203,  1204,  1204,  1204,  1205,  1206,  1205,  1207,  1208,
    1209,  1210,  1210,  1211,  1211,  1211,  1212,  1212,  1213,  1213,
    1213,  1214,  1215,  1215,  1215,  1216,  1216,  1217,  1217,  1217,
    1219,  1218,  1220,  1220,  1221,  1221,  1223,  1222,  1224,  1224,
    1225,  1225,  1225,  1225,  1227,  1226,  1229,  1228,  1230,  1231,
    1232,  1233,  1228,  1234,  1234,  1234,  1234,  1234,  1234,  1235,
    1235,  1235,  1236,  1236,  1237,  1237,  1237,  1238,  1238,  1239,
    1240,  1239,  1241,  1241
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     4,     1,     2,     0,
       4,     0,     2,     3,     1,     2,     0,     3,     0,     5,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     3,     3,     3,     0,     7,
       0,    11,     0,     6,     0,     3,     4,     0,     3,     1,
       4,     0,     0,     0,     0,     0,    12,     0,     2,     0,
       2,     2,     2,     2,     2,     3,     3,     1,     1,     1,
       2,     3,     3,     0,     4,     0,     3,     0,     1,     3,
       1,     0,     1,     3,     1,     0,     3,     0,     1,     3,
       1,     4,     0,     1,     1,     1,     0,     3,     2,     3,
       0,     3,     0,     5,     5,     0,     7,     5,     0,     2,
       1,     1,     1,     3,     1,     3,     0,     1,     1,     1,
       1,     2,     1,     1,     3,     0,     2,     0,     2,     0,
       3,     0,     5,     1,     1,     0,     2,     2,     2,     2,
       0,     6,     2,     0,     2,     1,     1,     3,     0,     0,
       0,     7,     0,     2,     2,     1,     1,     0,     0,     8,
       0,     6,     1,     2,     1,     2,     0,     0,     6,     0,
       0,     6,     0,     2,     0,     5,     0,     1,     0,     5,
       4,     0,     0,     8,     0,     7,     1,     1,     1,     1,
       1,     2,     2,     2,     4,     4,     0,     4,     0,     0,
       5,     0,     7,     0,     0,     6,     0,     1,     0,     1,
       1,     2,     1,     1,     0,     1,     1,     2,     1,     0,
       3,     0,     1,     1,     2,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     5,     1,     1,     3,     4,     4,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     2,     2,
       6,     7,     8,     2,     2,     0,     1,     2,     0,     1,
       2,     0,     4,     3,     3,     3,     1,     4,     1,     1,
       5,     2,     5,     2,     4,     1,     5,     5,     4,     3,
       1,     1,     2,     1,     1,     2,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     3,     3,     3,     0,     6,
       0,     6,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     3,     1,     5,     0,     1,     2,     1,     1,     1,
       1,     0,     3,     0,     1,     0,     1,     2,     1,     1,
       2,     2,     4,     1,     3,     2,     1,     2,     2,     2,
       2,     1,     2,     1,     1,     1,     1,     1,     0,     2,
       1,     1,     1,     1,     1,     0,     2,     1,     1,     0,
       1,     0,     2,     1,     2,     3,     2,     0,     1,     0,
       1,     1,     2,     0,     1,     0,     4,     1,     4,     3,
       1,     0,     1,     2,     1,     3,     3,     2,     2,     2,
       1,     1,     2,     2,     2,     1,     2,     2,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     0,     1,     1,
       1,     0,     2,     2,     1,     1,     1,     4,     2,     1,
       4,     0,     1,     0,     2,     1,     3,     0,     6,     0,
       5,     0,     5,     0,     5,     0,    11,     0,     1,     0,
       2,     2,     1,     3,     2,     3,     2,     4,     0,     6,
       0,     0,     8,     4,     4,     3,     3,     2,     2,     6,
       5,     3,     5,     1,     1,     1,     0,     1,     0,     1,
       0,     1,     1,     0,     2,     1,     0,     1,     1,     1,
       0,     5,     3,     0,     5,     3,     3,     0,     3,     0,
       2,     1,     3,     0,     1,     1,     0,     2,     1,     3,
       0,     6,     0,     6,     0,     5,     0,     1,     1,     0,
       6,     0,     1,     1,     2,     1,     1,     1,     0,     6,
       0,     5,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     0,     6,     0,     1,     1,     0,     4,     4,
       3,     5,     1,     3,     3,     5,     1,     3,     2,     1,
       1,     0,     6,     1,     3,     3,     0,     2,     0,     4,
       0,     2,     1,     2,     4,     2,     3,     0,     3,     0,
       0,     6,     2,     1,     1,     2,     2,     8,     4,     0,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     4,     3,     1,     1,     4,
       0,     0,     1,     1,     0,     2,     2,     1,     1,     0,
       2,     0,     3,     0,     3,     3,     0,     3,     0,     3,
       2,     1,     3,     4,     3,     4,     3,     4,     1,     3,
       4,     3,     3,     6,     1,     5,     6,     5,     7,     6,
       8,     5,     6,     4,     4,     5,     3,     4,     1,     3,
       1,     3,     1,     3,     3,     1,     3,     3,     4,     4,
       1,     3,     3,     3,     3,     3,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     3,     1,     1,
       1,     1,     3,     2,     2,     2,     2,     3,     3,     5,
       6,     4,     4,     7,     4,     2,     6,     5,     6,     6,
       4,     4,     3,     4,     6,     8,     6,     8,     6,     4,
       6,     4,     6,     4,     4,     4,     4,     6,     8,     2,
       2,     4,     2,     7,     7,     3,     4,     4,     6,     6,
       4,     6,     6,     6,     4,     6,     4,     6,     8,    10,
      12,     6,     4,     6,     6,     1,     6,     4,     8,    10,
       4,     1,     3,     4,     6,     6,     8,     6,     6,     4,
       6,     6,     8,     4,     4,     6,     4,     2,     4,     4,
       4,     6,     4,     4,     3,     8,     6,     4,     6,     3,
       6,     8,     4,     8,     6,     8,     6,     8,     2,     4,
       4,     4,     6,     8,     8,     4,     7,     7,     7,     6,
       6,     6,     6,     6,     6,     0,     5,    10,     3,     4,
       3,     2,     2,     2,     4,     6,     4,     4,     6,     6,
       6,     6,     4,     6,     4,     6,     4,     4,     4,     4,
       6,     4,     6,     4,     6,     4,     4,     6,     4,     6,
       4,     6,     4,     4,     6,     4,     6,     0,     3,     3,
       0,     1,     0,     2,     1,     3,     4,     4,     5,     4,
       4,     4,     5,     4,     0,     0,     7,    10,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       1,     0,     3,     2,     3,     2,     1,     2,     1,     2,
       1,     1,     1,     2,     0,     1,     0,     2,     1,     3,
       1,     3,     0,     2,     1,     3,     0,     1,     0,     2,
       4,     5,     1,     1,     1,     1,     3,     3,     3,     0,
       6,     0,     6,     0,     8,     4,     0,     8,     0,    10,
       6,     0,     8,     0,    10,     6,     1,     2,     2,     0,
       4,     0,    11,     3,     6,     0,     3,     0,     0,     5,
       0,     1,     0,     1,     0,     2,     2,     2,     0,     5,
       0,     1,     3,     1,     1,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     0,     2,     0,     1,
       0,     0,     3,     0,     0,     3,     2,     0,     0,     4,
       4,     2,     0,     2,     2,     3,     3,     1,     2,     0,
       1,     0,     4,     4,     2,     0,     1,     1,     0,     1,
       0,     1,     2,     1,     3,     3,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     0,     6,     0,     1,     3,     1,
       2,     0,     2,     3,     1,     2,     1,     0,     3,     0,
       5,     2,     1,     0,     3,     6,     0,     6,     4,     4,
       4,     4,     5,     4,     1,     3,     1,     0,     2,     0,
       1,     0,     0,     8,     0,     0,     6,     0,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     3,     4,     0,
       3,     3,     1,     2,     2,     0,     3,     0,     5,     3,
       1,     3,     1,     3,     1,     1,     0,     1,     0,     4,
       0,     1,     3,     1,     1,     1,     0,     0,     6,     0,
       0,    11,     3,     1,     3,     3,     1,     3,     0,     1,
       0,     4,     0,     6,     0,     5,     0,     6,     1,     3,
       3,     5,     0,     2,     0,     2,     1,     1,     1,     3,
       0,     1,     0,     3,     2,     4,     4,     4,     4,     0,
       4,     6,    16,     2,     2,     0,     6,     5,     2,     2,
       2,     1,     5,     5,     2,     2,     3,     2,     2,     2,
       3,     2,     2,     2,     1,     1,     3,     4,     3,     3,
       2,     2,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     0,     1,     0,     2,     0,     1,     1,     1,
       0,     2,     0,     2,     0,     2,     2,     0,     4,     0,
       4,     1,     1,     0,     1,     0,     1,     1,     0,     4,
       3,     1,     0,     3,     4,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     3,     3,     1,
       1,     1,     2,     0,     3,     3,     2,     2,     0,     4,
       0,     1,     1,     2,     0,     4,     5,     0,     0,     0,
       0,    18,     2,     0,     1,     0,     1,     1,     0,     1,
       1,     0,     2,     2,     1,     3,     4,     3,     3,     0,
       2,     2,     1,     3,     3,     0,     3,     0,     3,     2,
       3,     1,     1,     2,     0,     2,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     3,     5,     1,     1,
       1,     1,     1,     3,     4,     5,     1,     5,     3,     2,
       1,     3,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       4,     0,     1,     1,     3,     0,     2,     1,     1,     1,
       1,     0,     1,     0,     1,     1,     1,     0,     2,     2,
       2,     1,     2,     4,     5,     4,     6,     2,     3,     3,
       3,     5,     1,     3,     3,     2,     2,     2,     1,     1,
       4,     4,     1,     1,     1,     1,     1,     0,     4,     1,
       1,     1,     3,     3,     1,     1,     2,     2,     0,     3,
       4,     3,     0,     7,     1,     2,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     1,     1,     1,     1,     3,
       6,     6,     6,     7,     3,     8,     8,     8,     0,     1,
       1,     2,     0,     1,     1,     3,     0,     3,     0,     3,
       0,     3,     0,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     3,     2,
       2,     2,     2,     2,     2,     2,     2,     0,     1,     3,
       1,     2,     2,     2,     1,     3,     3,     1,     1,     3,
       1,     3,     4,     5,     1,     0,     3,     3,     1,     1,
       0,     2,     2,     2,     2,     0,     2,     2,     1,     2,
       2,     2,     2,     2,     0,     3,     0,     1,     0,     3,
       2,     0,     1,     2,     0,     1,     4,     4,     5,     2,
       3,     0,     1,     0,     4,     0,     1,     1,     0,     2,
       2,     1,     0,     1,     1,     4,     0,     7,     1,     0,
       0,     2,     3,     1,     1,     1,     0,     3,     1,     2,
       1,     2,     3,     3,     3,     0,     1,     0,     3,     3,
       0,     8,     0,     3,     1,     3,     0,     2,     3,     5,
       0,     3,     4,     4,     0,    14,     0,     6,     0,     0,
       0,     0,    12,     4,     4,     3,     4,     3,     2,     1,
       3,     5,     1,     1,     0,     1,     1,     0,     2,     0,
       0,     3,     0,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short int yydefact[] =
{
       0,     2,  1975,   634,     0,  1924,     0,     0,     0,     0,
       0,  1926,    94,    54,  1270,  1361,  1362,  1193,  1209,     0,
     634,    97,     0,    66,  1211,  1398,     0,     0,   634,     0,
    1393,     0,     0,   634,  1214,  1386,     0,    97,  1926,     0,
     669,  1761,  1292,     0,     0,     0,  1290,  1818,  1259,     0,
       0,     0,     0,     0,     4,    15,     0,    32,    20,    24,
      10,    14,     9,     6,    46,    47,    39,     8,    12,    36,
       7,    11,    29,    35,    30,    31,    43,   662,    18,    19,
      25,    37,    50,    16,    48,    45,    17,  1363,    21,    38,
      33,    26,    51,    27,    44,    28,    49,    23,    40,    22,
       5,    13,    41,    42,    34,    52,     0,   537,     0,   569,
       0,     0,  1976,  1966,   636,   635,     0,  1810,  1809,   602,
    1926,     0,  1546,  1547,  1548,  1549,  1550,  1551,  1552,  1510,
    1553,  1554,  1555,  1511,  1512,  1556,  1557,  1558,  1560,  1559,
    1561,  1513,  1514,  1562,  1563,  1564,  1515,  1516,  1565,  1566,
    1517,  1567,  1568,  1569,  1518,  1570,  1519,  1571,  1572,  1573,
    1574,  1575,  1520,  1576,  1577,  1578,  1579,  1580,  1521,  1581,
    1582,  1583,  1584,  1599,  1585,  1522,  1586,  1587,  1588,  1600,
    1523,  1591,  1590,  1589,  1592,  1593,  1594,  1524,  1595,  1596,
    1597,  1602,  1603,  1604,  1525,  1598,  1605,  1601,  1744,  1607,
    1606,  1608,  1610,  1609,  1526,  1611,  1527,  1612,  1613,  1494,
    1614,  1495,  1616,  1617,  1620,  1621,  1615,  1618,  1619,  1528,
    1623,  1624,  1625,  1626,  1627,  1628,  1629,  1639,  1632,  1634,
    1635,  1637,  1633,  1638,  1642,  1641,  1643,  1644,  1645,  1640,
    1631,  1636,  1646,  1647,  1630,  1648,  1649,  1650,  1651,  1652,
    1653,  1654,  1655,  1657,  1656,  1658,  1659,  1660,  1661,  1662,
    1664,  1663,  1665,  1666,  1667,  1669,  1668,  1670,  1529,  1671,
    1672,  1673,  1674,  1675,  1530,  1676,  1677,  1678,  1679,  1680,
    1681,  1531,  1682,  1683,  1684,  1685,  1686,  1687,  1688,  1689,
    1690,  1691,  1692,  1693,  1694,  1695,  1696,  1697,  1622,  1698,
    1532,  1699,  1700,  1533,  1701,  1534,  1702,  1703,  1535,  1704,
    1705,  1706,  1707,  1708,  1709,  1536,  1710,  1537,  1712,  1711,
    1713,  1715,  1716,  1538,  1714,  1539,  1717,  1718,  1720,  1719,
    1721,  1722,  1540,  1723,  1541,  1724,  1725,  1726,  1727,  1728,
    1729,  1730,  1731,  1732,  1733,  1734,  1737,  1738,  1739,  1740,
    1735,  1736,  1542,  1741,  1742,  1743,  1745,  1746,  1543,  1747,
    1748,  1545,  1749,  1750,  1753,  1751,  1752,  1754,  1755,  1756,
    1757,  1544,  1758,   123,  1499,    99,  1500,  1509,     0,   604,
     620,  1927,  1928,   269,   509,   510,   268,   508,    97,  1966,
       0,   265,   266,     0,  1284,  1016,  1207,  1207,     0,  1207,
    1210,  1207,    97,  1207,     0,    59,  1368,     0,     0,     0,
       0,  1493,     0,  1217,  1400,  1404,     0,     0,  1807,     0,
       0,     0,     0,    97,   637,     0,  1268,     0,   600,     0,
    1928,  1939,   663,   667,   679,  1762,  1759,  1346,   589,   589,
     589,   587,   589,  1291,     0,     0,  1268,  1403,  2012,     0,
       0,     0,  2008,     0,  2013,     0,   669,     0,     0,     1,
       3,     0,  1596,  1359,  1357,  1490,     0,   529,   538,   533,
     531,     0,     0,  1977,   618,     0,  1925,     0,   646,   656,
     125,     0,    68,     0,     0,     0,  1931,     0,     0,     0,
       0,    95,   318,  1966,  1968,  1970,   269,   267,     0,  1288,
    1287,  1286,     0,  1284,  1194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1207,    61,     0,  1852,  1867,  1868,
    1864,  1869,  1870,  1874,     0,  1866,  1858,     0,  1873,  1862,
    1871,     0,  1856,     0,  1872,  1877,  1860,  1865,  1844,     0,
    1850,  1854,  1492,  1113,  1821,  1822,     0,  1505,  1496,  1504,
    1503,    67,  1219,  1220,  1218,   568,  1401,  1402,     0,  1415,
       0,     0,     0,   632,     0,  1341,  1340,     0,  1394,  1940,
       0,     0,   609,  1222,  1269,     0,  1221,  1391,     0,  1390,
    1387,  1389,     0,  1852,  1839,     0,  1934,  1931,  1941,   692,
     685,   684,   687,   688,   691,   689,   690,   686,   683,   700,
     680,   682,  1765,     0,     0,   443,     0,  1354,     0,     0,
       0,  1354,     0,  1148,  1347,     0,  1774,  1325,   506,   505,
       0,   504,  1775,  1324,  1340,     0,     0,     0,  1311,     0,
    1776,     0,  1343,     0,  1148,  1354,     0,  1293,     0,     0,
       0,     0,   583,   593,   585,   580,     0,   586,   582,  1289,
    1206,  1819,   568,  1452,  1451,  1497,  2009,  1450,  2017,  2019,
    2005,  2007,  2014,   665,     0,  1945,    53,     0,  1365,  1973,
    1974,  1972,   459,   107,   107,   527,     0,     0,     0,     0,
       0,  1204,     0,     0,   648,   658,   127,   124,    98,     0,
     606,   622,  1930,     0,     0,  1932,  1936,   774,   773,     0,
      92,   709,  1506,  1904,    96,  1900,  1971,   319,   700,   700,
     700,  1961,     0,  1963,  1964,  1965,  1977,  1969,     0,   511,
       0,  1271,  1274,  1278,  1282,  1285,  1547,  1510,     0,  1555,
       0,     0,  1463,     0,     0,     0,     0,  1515,     0,     0,
    1568,     0,     0,  1520,     0,     0,     0,   709,   709,   709,
       0,     0,     0,  1579,  1580,  1472,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1460,     0,  1473,     0,
       0,     0,     0,     0,     0,     0,  1607,     0,     0,  1608,
       0,     0,     0,  1462,  1613,     0,     0,     0,     0,     0,
       0,     0,  1626,     0,     0,  1470,     0,     0,  1022,     0,
    1652,  1654,     0,     0,     0,  1658,     0,     0,  1659,  1660,
    1661,  1447,   776,     0,   709,  1459,  1469,  1673,  1678,  1453,
       0,  1680,     0,  1681,     0,  1686,     0,     0,     0,     0,
       0,     0,  1708,  1710,     0,     0,  1726,     0,     0,     0,
     709,  1737,  1738,  1739,  1740,     0,  1461,  1542,  1471,     0,
       0,     0,  1749,   709,   709,   709,     0,     0,     0,  1755,
       0,  1758,  1026,     0,     0,     0,     0,   775,     0,   990,
       0,  1018,   711,   716,   721,   728,   734,   748,   750,   752,
     755,   760,   766,     0,   861,   768,   855,   791,   790,  1017,
    1457,   789,   788,  1458,   786,  1480,  1499,  1446,  1479,  1208,
    1198,  1199,     0,  1200,  1203,  1898,  1201,   570,     0,     0,
      60,  1382,  1376,  1378,  1381,  1377,     0,  1383,  1380,  1379,
    1810,  1369,  1371,  1372,  1853,  1851,  1885,  1884,     0,  1886,
    1882,  1875,  1905,  1879,  1905,  1881,  1880,  1905,  1876,  1883,
    1905,  1848,     0,  1114,  1115,     0,  1820,     0,  1491,     0,
    1399,  1416,     0,  1417,  1405,  1413,   651,     0,  1113,  1808,
    1811,     0,     0,    56,    57,     0,   639,     0,   638,   642,
       0,     0,     0,  1225,  1215,  1224,  1392,     0,     0,  1851,
    1848,  1935,     0,  1937,  1952,   668,  1942,   698,   670,   697,
       0,   681,  1760,  1763,  1771,  1323,  1350,   442,     0,     0,
    1322,  1308,     0,   269,     0,     0,     0,     0,  1294,  1299,
     303,     0,  1315,  1149,     0,  1354,     0,  1317,  1330,  1318,
       0,  1344,     0,  1354,  1304,  1331,  1344,  1309,  1314,  1321,
    1348,  1349,     0,  1303,  1310,     0,  1319,  1344,  1344,  1354,
    1354,   596,   595,   594,   590,   591,   596,     0,  1059,     0,
       0,  2006,  2020,  2004,  2015,  2016,  2003,   666,  1946,   664,
    1947,     0,  1360,  1358,  1366,  1367,   460,   530,   459,   260,
     263,   262,     0,   534,   532,   459,  1967,     0,     0,   622,
       0,     0,   650,   645,   649,   647,   501,   500,   503,     0,
     657,     0,   128,   130,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    69,
      70,    83,   608,   607,   605,   630,   629,   627,     0,   628,
     626,   621,   623,   624,  1929,  1933,   270,   459,     0,  1508,
       0,     0,     0,     0,     0,     0,     0,  1962,    88,     0,
       0,     0,  1276,  1272,  1282,     0,     0,     0,  1113,     0,
       0,     0,  1118,     0,   805,  1118,  1118,  1118,     0,     0,
    1016,  1016,     0,  1016,     0,     0,     0,     0,  1118,   829,
     832,     0,   830,     0,     0,     0,     0,     0,  1466,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1016,     0,
       0,     0,     0,   995,     0,     0,     0,     0,   785,     0,
       0,     0,     0,  1016,     0,     0,     0,     0,  1022,     0,
    1020,     0,  1118,     0,     0,  1118,     0,     0,     0,     0,
       0,  1016,  1016,  1016,   720,     0,   877,     0,     0,     0,
       0,     0,  1016,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1118,  1118,     0,     0,     0,  1118,     0,
     898,     0,  1468,     0,     0,     0,  1467,     0,     0,  1465,
    1464,  1448,     0,     0,     0,   921,   923,   922,  1118,     0,
    1118,     0,     0,     0,  1027,     0,   794,   793,   795,  1959,
       0,     0,     0,     0,     0,     0,     0,   713,   718,   777,
       0,   778,   779,     0,   780,   781,   782,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   796,  1088,  1089,  1090,
    1091,  1100,  1103,  1092,  1093,  1094,  1102,  1095,  1096,  1097,
    1104,  1105,  1106,  1098,  1107,  1101,  1099,  1108,     0,  1087,
       0,     0,     0,  1449,   915,     0,  1196,     0,   572,   571,
    1202,   570,     0,    62,    64,  1375,     0,     0,  1384,  1878,
       0,  1859,  1863,  1857,  1861,     0,     0,  1849,     0,  1855,
    1117,  1603,  1668,     0,  1120,  1824,  1212,  1412,  1414,     0,
       0,  1406,     0,     0,   622,    58,     0,     0,  1395,     0,
       0,     0,     0,   611,  1223,     0,  1388,     0,     0,     0,
       0,     0,  1938,  1954,  1953,  1943,   700,  1139,   701,   703,
     702,  1479,  1765,  1768,  1769,  1772,  1770,     0,  1767,  1766,
    1781,     0,  1352,  1355,  1356,     0,     0,  1333,  1332,  1328,
    1329,     0,  1158,  1159,  1157,  1152,  1153,  1156,  1337,  1335,
    1326,     0,  1354,     0,  1336,  1334,  1354,  1344,     0,  1354,
    1354,  1316,  1320,     0,   584,   593,   581,   588,  1071,  1070,
       0,  1035,     0,  1034,  1033,  1032,     0,  1070,  2010,  2018,
    2022,     0,  1148,  1951,  1949,   261,  1246,  1246,     0,     0,
       0,     0,     0,     0,     0,   108,   117,   566,   566,  1246,
    1246,   566,  1246,  1246,  1246,     0,     0,  1246,     0,     0,
     566,     0,  1246,   564,     0,     0,  1246,  1246,  1246,   566,
       0,  1246,  1246,  1246,  1246,  1246,   576,  1246,  1246,  1246,
     563,   273,   295,   296,   528,     0,   542,   565,  1978,  1979,
     535,   619,   603,  1205,     0,   126,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   631,   625,    93,   710,  1507,     0,  1901,
    1998,     0,     0,  1980,   271,   514,   516,   515,   513,   512,
       0,     0,  1120,     0,  1279,  1059,  1283,  1282,  1280,     0,
       0,     0,  1119,  1118,     0,  1001,  1166,  1167,  1163,  1164,
    1162,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   974,     0,  1001,     0,
     835,     0,     0,     0,     0,     0,     0,  1479,     0,     0,
       0,     0,     0,  1959,     0,     0,     0,     0,     0,     0,
     812,     0,     0,     0,     0,     0,     0,     0,  1111,  1109,
    1112,  1110,     0,     0,   996,   988,     0,     0,     0,     0,
     862,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1023,  1024,  1118,     0,     0,     0,  1118,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   884,     0,     0,
       0,     0,     0,   889,     0,     0,     0,     0,     0,     0,
       0,  1118,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   918,     0,   920,     0,     0,  1482,
    1481,     0,     0,     0,     0,     0,  1028,   669,     0,   798,
    1016,   797,     0,  1777,   991,   993,     0,   715,   712,   717,
     731,   724,   729,   722,   726,     0,   783,  1552,   732,     0,
       0,  1127,   746,     0,     0,   749,     0,     0,     0,     0,
     751,   753,   754,   757,   861,   756,   861,   764,   765,   761,
     762,   763,   767,     0,   787,   792,  1019,   962,  1483,  1197,
    1899,  1195,    65,     0,     0,  1370,  1385,  1373,  1909,     0,
    1908,  1894,  1897,  1490,     0,     0,     0,  1834,  1828,  1835,
    1837,  1831,  1836,  1838,  1829,  1830,  1825,  1832,  1121,  1150,
       0,     0,   652,   653,   656,     0,  1814,  1815,  1813,  1812,
     633,  1397,  1396,     0,   640,   643,   644,   616,   615,   617,
     610,   612,   613,   253,  1229,     0,     0,     0,  1235,  1216,
    1226,   601,     0,     0,     0,     0,     0,   696,  1059,  1187,
     693,   674,  1150,  1140,   673,   704,     0,  1764,     0,  1735,
    1792,     0,     0,     0,     0,     0,  1782,  1351,     0,  1305,
       0,  1327,  1339,  1338,  1300,     0,     0,     0,  1298,  1345,
    1297,  1120,  1344,  1295,  1296,   598,   597,   592,  1070,  1059,
       0,     0,  1056,  1072,     0,  1072,  1059,  1059,     0,  1059,
    1113,  1067,     0,     0,  2021,  1141,  1950,  1244,  1245,  1247,
       0,     0,   111,   114,   112,     0,   113,     0,     0,   567,
     521,   502,   502,   546,     0,   335,   521,   495,   544,     0,
       0,     0,     0,     0,     0,     0,     0,  1246,     0,   557,
     540,     0,     0,     0,     0,   558,     0,   541,  1246,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   579,
     578,   577,     0,     0,     0,     0,   274,   459,   338,     0,
     573,   335,   341,  1486,  1982,  1084,     0,  1083,   129,    76,
      72,    84,  1171,  1172,  1170,  1168,  1169,    85,    74,    75,
      79,    78,    80,    81,    82,    77,    73,    86,    87,    71,
       0,  1902,     0,   237,   236,     0,  1996,  1982,     0,   338,
      89,  1418,   272,   275,    90,  1059,  1139,  1282,  1120,     0,
    1113,     0,   804,   819,     0,     0,   967,     0,     0,   969,
     970,   971,     0,   823,     0,   821,   824,   825,   826,  1016,
       0,     0,     0,     0,  1016,   973,     0,   831,     0,     0,
     836,   837,     0,   810,     0,   844,     0,   846,     0,  1016,
       0,   840,     0,   801,     0,     0,  1016,     0,   852,     0,
     813,     0,     0,   953,     0,   936,   932,     0,   934,     0,
       0,  1016,  1016,     0,   857,     0,     0,   863,  1016,     0,
     955,     0,   937,     0,   869,     0,  1016,     0,  1021,     0,
       0,     0,   980,   873,   874,     0,   978,   939,     0,     0,
     876,   941,     0,   943,     0,   938,   945,   946,   878,   880,
     879,   948,     0,     0,   950,     0,   952,     0,   882,   883,
       0,     0,     0,   887,     0,  1016,   892,   982,   984,     0,
       0,     0,     0,     0,   986,   899,   901,     0,     0,     0,
     900,     0,     0,     0,     0,     0,     0,     0,   905,     0,
       0,   919,   985,   811,   983,   924,     0,   927,     0,   926,
       0,     0,     0,     0,  1958,  1960,     0,     0,   802,     0,
       0,     0,     0,     0,  1484,   770,   769,     0,   772,   771,
       0,   725,   730,   723,   727,     0,     0,     0,     0,   744,
     743,     0,     0,  1127,   747,     0,   759,   758,   860,     0,
     961,   700,  1016,     0,    63,  1374,  1906,     0,     0,     0,
       0,     0,     0,     0,     0,  1823,  1151,  1256,  1498,  1407,
       0,   660,  1816,  1817,     0,   614,   679,     0,  1248,  1233,
    1240,  1234,     0,     0,     0,  1232,  1475,  1474,  1481,  1941,
       0,     0,     0,     0,  1944,  1120,  1120,  1181,     0,     0,
     671,   676,   672,   675,     0,   699,   708,   707,  1476,  1483,
       0,     0,     0,     0,   445,   447,   446,   455,     0,   444,
       0,     0,  1777,     0,   451,   453,   452,  1787,   450,  1353,
    1148,  1313,  1312,  1155,  1154,     0,  1307,  1354,     0,  1948,
    1065,     0,  1058,  1057,  1073,     0,  1059,  1072,  1072,     0,
    1038,  1037,  1260,  1263,     0,  1036,  1074,  1063,   679,  2011,
    2023,     0,   458,   457,   302,   454,   301,   116,   115,   121,
     122,   340,   522,   496,   497,     0,     0,     0,   502,   334,
     521,   333,   336,   511,     0,   285,   282,   548,   288,   284,
     300,     0,     0,   289,   521,   555,   556,   570,   278,     0,
     314,   315,   313,   297,   280,   281,   550,  1135,  1137,  1145,
     287,   286,   283,   292,   293,   311,   310,   291,   312,   561,
     309,   307,   304,   306,   305,   308,   290,   279,     0,   543,
       0,   324,   326,   327,  1489,     0,   575,   545,     0,   328,
     329,     0,     0,     0,     0,   659,     0,  1903,  1999,   240,
     238,   239,     0,     0,     0,   243,     0,   241,     0,     0,
    1420,  1419,   242,   256,   459,   276,     0,  1120,  1160,  1275,
    1281,     0,     0,     0,   968,  1002,     0,   421,   421,  1012,
    1010,   410,   421,  1006,  1011,  1008,     0,     0,     0,     0,
       0,     0,     0,   975,   972,     0,     0,     0,  1483,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   999,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   957,  1025,   981,
     979,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   987,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1029,   807,  1955,  1956,
     799,  1778,  1779,  1780,   523,   992,   714,   719,     0,   737,
    1016,   735,  1126,   741,     0,     0,   745,     0,   916,     0,
     963,   964,     0,  1015,  1485,  1907,  1896,  1895,  1910,  1910,
    1910,     0,  1122,     0,  1213,  1418,   654,     0,   655,   641,
     700,  1230,  1242,     0,  1250,     0,     0,  1227,  1237,     0,
       0,     0,  1236,     0,  1841,  1842,  1840,  1150,  1128,     0,
       0,  1192,     0,  1188,   694,     0,   706,   705,     0,  1794,
       0,  1793,  1805,  1806,  1803,  1804,  1802,  1783,     0,  1789,
    1788,     0,     0,     0,  1799,  1790,     0,     0,  1306,     0,
    1301,   599,     0,  1059,  1072,  1059,  1045,     0,     0,  1059,
    1041,  1039,  1043,     0,  1120,     0,     0,     0,     0,  1060,
     700,  1478,  1142,  1145,   337,   521,   498,   499,   511,     0,
       0,     0,     0,   455,   298,   554,   553,   299,     0,     0,
    1146,  1147,  1138,     0,   547,   338,   574,   475,   406,   355,
     346,   421,   349,   348,   392,   363,   360,   410,   408,   378,
     410,   410,   385,   384,   402,   388,   368,   461,   461,   367,
     405,   461,   389,   387,   391,     0,   393,   410,   398,   386,
     390,   407,   383,   380,   404,   421,   421,   361,   364,   403,
     461,     0,   396,   421,   425,   366,   461,   467,     0,     0,
     421,   423,  1488,  1984,     0,  1986,  1082,   142,   700,     0,
     101,  1997,  1986,     0,   246,   271,   257,     0,   277,     0,
    1277,     0,  1273,   785,   816,   820,   929,     0,  1003,   461,
       0,  1013,   412,  1005,  1007,  1009,   806,   822,   827,   931,
     809,   808,     0,     0,     0,     0,   842,   845,   847,   838,
     843,   841,     0,   930,   854,   851,   853,   814,     0,   954,
     933,   935,   856,   867,   997,  1000,     0,     0,     0,   868,
     864,   956,   865,     0,   870,   839,   871,     0,     0,     0,
       0,   940,   875,   942,   944,   949,   947,   951,   881,   818,
       0,   886,   888,   800,   785,   890,     0,   896,   894,     0,
       0,   902,     0,     0,   911,     0,   909,     0,   910,     0,
     912,   913,     0,   925,   928,  1030,     0,  1941,     0,   994,
     733,     0,   739,  1016,   736,   742,   701,   700,   914,     0,
    1915,  1915,  1915,  1255,  1254,     0,  1253,  1257,     0,   661,
     254,     0,     0,     0,  1251,  1239,  1945,  1228,  1231,  1483,
    1843,   678,     0,  1123,  1191,  1189,     0,  1182,  1184,  1186,
       0,  1477,     0,     0,  1798,  1784,   456,     0,     0,     0,
       0,  1785,     0,  1113,  1066,     0,     0,  1032,  1059,  1059,
       0,  1032,     0,     0,     0,  1262,  1139,  1264,  1078,  1076,
    1077,  1075,  1068,     0,  1144,     0,     0,     0,   560,     0,
     573,   562,   425,  1136,   294,   325,   481,     0,     0,   365,
     414,   409,     0,   414,   414,   467,   469,   463,   467,     0,
     374,   392,   369,     0,   461,   382,   373,   394,   397,   399,
     401,   414,     0,   461,   362,   371,     0,   414,   433,     0,
       0,     0,   429,     0,   474,     0,   436,   342,   426,   428,
       0,     0,   395,     0,   351,   468,     0,   353,     0,     0,
     414,     0,   424,   414,     0,  1983,     0,  1990,     0,   145,
     143,   144,     0,   138,   140,   135,     0,   322,   323,   321,
     320,     0,   131,  1990,   244,  1945,  1418,     0,   249,     0,
    1145,   519,  1161,     0,     0,  1004,     0,     0,   976,   833,
     834,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   803,     0,     0,     0,     0,     0,     0,     0,
     908,   906,   907,     0,  1031,  1960,   524,   738,     0,   704,
     965,     0,     0,  1914,  1912,     0,  1913,  1911,  1887,     0,
    1846,  1847,  1845,  1833,     0,     0,  1408,  1150,  1241,  1243,
    1249,  1238,     0,  1124,  1139,  1421,  1185,     0,   695,  1796,
    1795,  1797,  1791,     0,     0,     0,     0,  1064,  1059,  1046,
       0,  1050,  1055,  1051,     0,  1042,  1040,     0,  1160,     0,
    1150,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
     559,  1454,   549,   551,     0,     0,     0,   476,   477,   482,
     484,     0,     0,   418,   419,   420,   375,   415,   417,     0,
     377,   345,   462,   470,   471,     0,   466,   464,   467,   370,
     400,   376,     0,   372,     0,   359,   439,   438,   709,   431,
     441,     0,     0,   437,   427,   435,   430,     0,     0,     0,
       0,   343,     0,   344,  1487,  1985,     0,   536,   700,   700,
    1987,  2000,   142,     0,     0,     0,     0,   132,   134,   135,
    1981,   247,   245,     0,  1941,    91,     0,   518,     0,   817,
     422,   411,     0,   828,   848,     0,   815,   998,   989,  1118,
     858,     0,   866,   872,   959,   958,   885,   891,   895,   893,
     897,   903,   904,  1016,  1957,   740,   966,  1893,  1892,  1891,
    1888,     0,     0,     0,     0,     0,     0,  1916,  1918,  1252,
       0,     0,   255,   693,   316,  1132,  1145,     0,  1150,     0,
    1429,  1183,  1801,  1800,  1786,     0,     0,     0,     0,     0,
       0,     0,  1085,  1261,  1080,  1069,  1143,     0,     0,   330,
    1456,  1455,   573,   487,   488,   489,     0,     0,     0,   480,
     483,   354,   347,   416,     0,   525,   472,   465,     0,   358,
     440,   709,   434,   461,   467,   461,   467,     0,     0,     0,
     669,     0,   109,   139,     0,   700,   100,   102,     0,     0,
     251,   250,  1145,     0,     0,     0,     0,     0,     0,  1889,
    1919,  1922,  1920,  1921,  1923,  1917,     0,     0,   317,     0,
       0,  1129,  1131,  1125,  1173,     0,     0,     0,     0,  1422,
    1424,     0,  1190,     0,  1061,  1047,     0,  1052,     0,  1044,
       0,     0,  1081,     0,   331,   552,   491,     0,   490,     0,
     485,   486,   481,     0,   461,     0,   461,   432,   350,   352,
     356,   357,     0,  1991,     0,  1988,     0,  2001,   141,     0,
       0,   133,   136,  1945,   517,   520,   413,   849,     0,   977,
     859,   917,  1258,  1266,     0,  1409,  1133,  1134,  1145,     0,
     677,     0,     0,     0,     0,  1423,     0,     0,  1430,  1432,
       0,     0,     0,     0,  1086,  1079,   332,   493,   494,   492,
     478,   479,   379,   526,   381,  1992,  1993,  1945,   119,   118,
     110,     0,   177,     0,   103,   252,     0,     0,     0,   448,
    1130,  1174,  1427,  1428,     0,  1425,     0,     0,  1431,     0,
       0,  1049,  1054,  1989,   120,     0,   193,   181,     0,     0,
       0,   179,   207,  2002,     0,     0,   183,   205,   206,   184,
    1501,     0,  1502,  1994,     0,   850,  1265,  1267,     0,  1410,
       0,  1426,  1434,  1433,     0,  1062,   192,   195,     0,     0,
     198,   188,   187,   189,     0,     0,     0,   178,   228,   177,
     177,   231,   186,   224,   177,   104,   449,  1421,   700,     0,
     194,     0,     0,     0,   180,   208,   219,   222,   214,   150,
     177,     0,   177,     0,     0,  1995,   109,  1429,     0,     0,
    1177,  1179,     0,   190,     0,     0,     0,     0,   177,   215,
       0,   146,     0,     0,   148,   234,     0,   226,   105,  1435,
    1180,  1175,   700,  1302,     0,   182,   199,   216,   222,   212,
     220,   177,     0,     0,   177,     0,   230,   149,     0,   232,
     225,   227,   177,     0,  1437,  1178,   191,   196,   177,     0,
     213,     0,     0,   211,   161,   160,     0,   152,   173,   229,
       0,   151,     0,   177,   106,     0,     0,  1444,     0,   177,
     217,     0,   177,     0,     0,     0,     0,     0,   147,     0,
     177,  1436,  1439,     0,     0,  1441,  1442,     0,  1411,   197,
     202,     0,   209,   177,   155,   174,   175,     0,   158,   235,
       0,  1443,  1438,     0,  1445,   198,   177,   201,   177,     0,
       0,   153,   166,   154,   164,   157,     0,   233,  1440,   203,
     177,   177,   172,   170,   177,   168,   162,     0,   169,   176,
     167,     0,   159,     0,   156,   171,   165,   163
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    52,    53,    54,    55,    56,    57,   963,    58,   515,
     910,  1363,  1364,    59,   412,    60,   689,  1109,  1110,  1111,
      61,  1574,  2436,  1127,   389,   407,   373,  2741,  3012,  3380,
    3474,  3526,  3572,  1073,  3377,  1495,  3430,  1496,    62,   480,
     687,  1091,  1092,  3186,  3187,  3183,  3188,  3002,  3003,  3004,
    3005,  3564,  3520,  3541,  3565,  3605,  3639,  3645,  3646,  3586,
    3654,  3655,  3661,  3656,  3587,  3641,  3521,  3464,  3494,  3490,
    3465,  3554,  3489,  3576,  3512,  3513,  3578,  3620,  3637,  3466,
    3467,  3495,  3536,  3468,  3496,  3558,  3517,  3559,  3579,  3621,
    3518,  3537,  3582,  3540,  3469,  3524,  3570,  3502,  3519,  3523,
    3593,  3568,  2015,  2422,  2020,  2427,  3015,  2432,  3194,  3383,
    1848,  2246,  3077,  2747,  1067,  1068,  1069,   390,   391,   392,
     488,  2021,  1530,  2022,  2023,  1532,  1533,  1009,  2396,  2387,
    2373,  3242,   710,  3011,  2400,  2401,  2402,  2403,  2351,  2352,
    1934,  1935,  1981,  2411,  2724,  2942,  2962,  2725,  2726,  2727,
    2728,  2729,  2730,  2731,  2761,  2762,  3136,  3137,  3138,  2758,
    2993,  2977,  2978,  2979,  3159,  2949,  2286,  2287,  3479,  2296,
    2297,  2333,  2619,  2334,  1072,  2950,  2987,  3146,  2980,  2410,
    2936,  3127,  3278,  3128,  3129,  3130,  3360,  1936,  2350,  1088,
    1089,   636,   393,  1141,  1578,  3019,  3020,  2341,  2849,  3284,
      63,  1075,   672,   674,   673,  1984,   467,  1534,  1535,  1536,
    2662,  2668,  3272,  1938,   111,  1360,  2407,  1972,    64,  1046,
    1041,    65,   647,   642,   643,  1044,  1045,  1464,  1896,    66,
     582,    67,   475,    68,   483,  1114,    69,   971,  1840,  1841,
    1842,    70,   679,    71,   484,  1121,  1122,  1123,    72,   961,
     116,    73,   571,   966,   968,   969,    74,   477,   478,  1083,
      75,  1390,  1822,  1823,   684,   685,  1090,  2578,    76,    77,
     458,   432,   588,   433,   434,  1417,  1860,  3243,   599,   600,
     601,  2270,   988,   989,   990,  1865,  1418,  2275,  1129,  2864,
    1297,  1748,   872,  1298,  1749,   873,   874,   875,   876,   877,
     878,   879,   880,   881,   882,  2197,  2200,  2981,   883,  1307,
    1759,   884,   885,  1787,   886,  2810,  2219,  2220,  2221,  2560,
    2561,   887,  2054,  2773,  2092,   888,  1294,  1744,  1655,  3034,
    2794,  1594,  2037,  2456,  2562,   504,   505,   889,  1219,  1220,
    1221,  1672,  1285,  2183,  1736,  1471,  1472,  1473,  1474,  2913,
    2912,  2914,  3257,  3100,  3259,  3104,  1907,  1475,  1476,  3411,
    2309,  2633,  2327,  2328,  3110,  1898,  1477,  2315,  2649,  2919,
    3109,  3351,  1986,  3261,  1348,  1349,  1652,   945,   946,  1595,
    1819,  2234,  3084,  3247,  2209,  2883,  3245,  3331,  1537,  2377,
    2378,  1862,  1863,  2331,  2652,  2672,  1012,  3244,  2236,  1445,
    1446,  2752,  3644,  1997,  3400,  3480,  3529,  3530,  3531,  2601,
    2602,  2887,  2888,  1864,  2267,  2603,  3085,    78,   395,    79,
    1789,   680,   681,   507,   404,    80,   413,  1820,    81,   426,
    1405,   555,   575,   974,   975,  1849,  2247,  2254,  1850,  2259,
    2876,  2249,  2581,  2582,  1919,  1920,  2250,  2584,  2873,  2865,
    2866,  2574,  3075,    82,   446,  2644,  2322,  2323,  3392,  3393,
     576,    83,   394,   721,  1582,  1146,  1581,   722,   723,  1148,
     502,   503,    84,   444,    85,   437,   637,  1441,  2300,  1884,
     567,   639,  1452,   640,  1453,  1432,  1879,  1000,    86,   668,
     667,    87,   463,  1063,    88,   516,   921,   922,  1368,  1797,
      89,   427,   580,   581,    90,   421,   568,  1398,    91,   414,
     558,    92,    93,   559,   954,  2575,  3241,  3439,  3507,  1389,
     955,  2433,  3250,  3339,  3340,  3342,  3408,  3409,  3574,  3597,
    3614,  3615,  3618,   890,   656,   891,  3120,   892,   893,  2255,
    2256,  2653,   894,  3394,   895,  1982,   650,   410,   896,   549,
     897,  2239,   898,  3471,   702,   703,   376,   377,    94,   602,
     436,   992,   993,   994,  1427,  1428,   641,  2192,  1429,  1430,
    1876,  1871,  2895,  2625,  2617,    95,   562,   923,   959,   960,
    1828,    96,   445,    97,   947,  1384,  1385,  1816,  2233,  1817,
      98,   584,    99,   538,  1378,   539,   925,   540,   541,   937,
     932,   940,   934,  3231,  3067,  3068,  1804,   906,   704,   705,
    1371,  1799,  1800,  2860,  3070,  3237,  3238,   100,   120,   382,
     486,   696,   982,   101,   102,   103,   104,   985,  1058,  1856,
    1059,  1060,  1061,  1484,  1415,  1292,  2847,  2185,  1738,  2538,
     491,   711,   473,   493,   494,   112,   113,   712,   713,  2017,
    2414,  2734,  2997,  2998,  3180,  3177,   714,  3504,   715,  2423,
    2012,  2737,  3302,  3432,   105,   658,   455,  1056,  1051,  1053,
    1480,  1914
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3180
static const int yypact[] =
{
    3555, -3180,   146,    66,   734, -3180,   512, 42673,    77,   734,
     734,   -39,   340, -3180, -3180, -3180, -3180, -3180,   630, 42673,
      66, -3180, 21653, -3180, -3180, -3180,   172,   734,    66, 42673,
   -3180,   345,   420,    66, -3180, -3180,   734, -3180,   -39, 42673,
   -3180,   499, -3180,   -99,   756,   471,   518, -3180, -3180, 42673,
     714,  -146,  1051,  1060, -3180, -3180,   711, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, 22193, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180,   967, 42673, 42673, -3180,
   42673,   708, -3180,  1056, -3180, -3180,   734, -3180, -3180, -3180,
     -39, 21653, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180,   631, -3180, -3180,   730, -3180,
   -3180, -3180,  1208,  1018, -3180, -3180, -3180, -3180, -3180,   393,
     766, -3180,   794,  1044,   545, -3180,  1066,  1066, 42673,  1066,
   -3180,  1066, -3180,  1066,   734, -3180, -3180,  1782, 42673,   939,
     142,   -94, 37840,   945,   165, -3180,  1064, 21653, -3180,   734,
    1111,   748, 42673, -3180, -3180,   734,   235,   784, -3180,  1904,
     123, -3180, -3180, -3180,   284, -3180, -3180,  4191, -3180, -3180,
   -3180,   754, -3180, -3180, 21653,   734,  1033, -3180, -3180,   124,
     124,   124, -3180,   124, -3180,   124, -3180,  -146,   755, -3180,
   -3180, 42673,   364, -3180, -3180,   737,   -38, -3180, -3180, -3180,
   -3180, 21653,  1178,   872, -3180, 21653, -3180,   162, -3180, -3180,
     768, 42673, -3180, 21653, 21653,   193,    10,   983, 42673, 35692,
     931, -3180,   127,  1056,  1325, -3180,  1018, -3180, 42673, -3180,
   -3180, -3180, 39451,   545, -3180, 13940,  1197, 42673, 42673,  1028,
   42673, 42673, 35692, 21653,  1066,   868,  1068,  1005,   977,   774,
   -3180, -3180, -3180, -3180,  1073, -3180, -3180,   921, -3180, -3180,
   -3180,   130, -3180,    69, -3180, -3180, -3180, -3180, -3180,  1071,
     839, -3180, -3180,   112, -3180, -3180, 42673, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180,  1195, -3180, -3180, 13940,   716,
    1364,  1254, 21653, -3180,   331, -3180, -3180,  1177, -3180, -3180,
   35692, 21653, -3180, -3180, -3180, 19483, -3180, -3180,  1390, -3180,
     876, -3180, 21653,  1005, -3180,  1113,  1029,    10,   949, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,   894,
     284, -3180, -3180,  1200,  1317, -3180,  1040,    14,   979,   908,
      97,    14, 37840,  1223, -3180,   219, -3180,  1306, -3180, -3180,
    1023, -3180, -3180, -3180,  1031,  1053,  1214,  1069, -3180,   231,
   -3180,    82, -3180,   688,  1223,    14,   970, -3180,  1274,  1397,
     190,  -148, -3180,   -57, -3180, -3180,  1464, -3180, -3180, -3180,
   -3180, -3180,  1195, -3180, -3180, -3180,   981, -3180,  1210,  1092,
   -3180, -3180,    27, -3180,   994,    30, -3180,   368, 36229, -3180,
   -3180, -3180,   114, -3180, -3180, -3180, 35692,  1152,  1055, 21653,
    -143, -3180, 39988, 21653, -3180,   139, 13940, -3180, -3180,  1553,
     145,   141, -3180,  1535,  1203, -3180, -3180, -3180, -3180,  1448,
   -3180,  1039,  1037,  1399,  1077, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180,  1084, -3180, -3180, -3180,   872, -3180, 21653,  -150,
   21653, -3180,  1091, -3180,  1048, -3180,  1058,  1075,  1097,  1101,
    1103, 16755, -3180,  1114,  1121,  1126,  1133,  1140,  1148,  1155,
    1162,  1163,  1165,  1168,  1169,  1170,  1171,  1039,  1039,  1173,
    1174,  1175,  1176,   677,  1181, -3180,  1182,  1183,  1184,  1185,
    1187,  1188,  1189,  1190,  1191,  1192, -3180,  1193, -3180,  1194,
    1198,  1201,  1202,  1206,  1207,  1209,  1212,  1213,  1215,  1216,
    1217,  1218,  1219, -3180,  1220,  1221,  1224, 13940,  1225,  1226,
    1227,  1228,  1229,  1230,  1231, -3180,  1232,  1233,  1237,  1238,
    1239,  1240,  1241,  1242,  1243,  1244,  1246,  1247,  1248,  1249,
    1252, -3180, -3180, 13940,  1253, -3180, -3180,  1255,  1258, -3180,
    1267,  1276,  1277,  1278,  1279,  1285,  1286,  1288,  1292,  1293,
    1295,  1296,  1297,  1300,  1301,  1302,  1304,  1309,  1312,  1314,
    1315,   693,  1316,  1318,   699,  1319, -3180,  1321, -3180,   166,
    1322,  1323,  1324,  1039,  1039,  1039,  1326,  1327,  1328,  1329,
    1330,  1331, 13940, 16755, 16755, 16755,  9436, -3180, 42673, -3180,
   42673, -3180,  1234, -3180, -3180,  1362, -3180,   891,  1186,   960,
     854,   181,  1074, 16755,  2342,   376, -3180, -3180, -3180,  1272,
    1172, -3180, -3180, -3180, -3180, -3180,  1333, -3180,  1196, -3180,
   -3180, -3180, 21653, -3180, -3180, -3180,  1334,    85, 21653,  1062,
   -3180, -3180, -3180, -3180, -3180, -3180,  1692, -3180, -3180, -3180,
    1222,  1335, -3180, -3180, -3180, -3180, -3180, -3180,  1290, -3180,
   -3180, -3180,  1339, -3180,  1339, -3180, -3180,  1339, -3180, -3180,
    1339,   640,  2309, -3180, -3180, 42673, -3180, 43210, -3180, 19483,
   -3180, -3180,  1474, -3180, -3180,  1516, -3180,  1489,   109,  1338,
   -3180, 21653, 37840, -3180, -3180,   111,  1340,  1298,  1341, -3180,
    1392, 21653, 21653, -3180, -3180, -3180, -3180,   784,    71,  1342,
     678, -3180, 42673, -3180,   278, -3180, -3180, -3180,  1343, -3180,
   13940, -3180,  1345, -3180,    65, -3180,  1589, -3180,  1409, 13940,
   -3180, -3180,  1356,  1018, 42673, 42673, 21653, 21653, -3180, -3180,
   -3180,   537, -3180, -3180, 42673,    14, 35692, -3180, -3180, -3180,
    1744,   970, 42673,    14, -3180, -3180,   970, -3180, -3180, -3180,
   -3180, -3180, 21653, -3180, -3180,   970, -3180,   970,   970,    14,
      14,  1408, -3180, -3180,  1357, -3180,  1408,  1483,   336,   124,
    1566, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180,    53, -3180, -3180, -3180, -3180, -3180, -3180,   117, -3180,
   -3180, -3180,  1299,   212,   212,  1606, -3180,   173, 21653,   141,
    1409, 21653, -3180, -3180, -3180, -3180, -3180, -3180, -3180,  1365,
   -3180,  1361,  1366, -3180,  1784,  1789,  1791,  1792,  1794,  1795,
    1796,  1800,  1801,  1802,  1803,  1806,  1808,  1810,  1812,  1396,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,  1412, -3180,
   -3180, -3180, -3180,   692, -3180, -3180, -3180,   114,  1400, -3180,
   37840,  1916, 35692, 42673, 42673,  1788, 21653, -3180, -3180,   319,
     319,  1627,  1091, -3180,    99, 42673,  1797, 25968,    68, 13940,
   13940, 13940,   280,   758,  1903,  1957,  1957,  1957, 13940, 13940,
   -3180, -3180, 13940, -3180, 13940, 13940, 13940, 13940,   782, -3180,
   -3180,  9999, -3180,  1413, 13940, 13940,  1497, 13940,  1172, 13940,
   13940, 22733, 13940, 13940, 13940, 13940, 13940,   429, 13940,  2342,
   13940, 13940, 13940,  1414, 13940, 13940, 13940, 13940, -3180, 13940,
   13940,   209, 13940,  1854,   -65, 13940, 13940, 13940, -3180, 10562,
   13940, 13940, 13940, -3180, 13940, 13940, 13940, 13940, -3180,  1969,
   -3180, 22733,   822, 13940, 13940,   946, 13940, 13940, 13940, 13940,
   13940, -3180, -3180, -3180, -3180,  9999, -3180, 13940, 13940, 13940,
   13940, 13940, -3180, 16755, 13940, 11125, 13940, 13940, 13940, 13940,
    1418, 13940, 13940,  1957,  1957, 13940, 13940, 13940,   956,  9999,
   -3180, 13940,  1172,   680,   680, 13940,  1172,  8310, 13940, -3180,
   -3180, -3180,   -65, 11688,  1421, -3180, -3180, -3180,  1957, 22733,
    1957, 13940, 13940, 13940, -3180,  1452,  1903,  1903,  1903, -3180,
    9436,   851,  1425, 13940, 23813,  1420, 13940, -3180, -3180, -3180,
   16755, -3180, -3180,   757, -3180, -3180, -3180, 14503,  1429, 16755,
   16755,  1745, 16755, 16755,   546, 16755, 16755, 16755, 16755, 16755,
   16755, 16755, 16755, 16755, 16755, 16755,  1903, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,  1441, -3180,
   37840, 16755, 13940, -3180, -3180, 42673, -3180, 35692, -3180, -3180,
   -3180,    85, 37840,  1434, -3180, -3180,  1618,  1068, 21653, -3180,
   42673, -3180, -3180, -3180, -3180, 20023, 20023, -3180, 20023, -3180,
   -3180,    96,   110,  1086,  1469, -3180, -3180, -3180, -3180,  1790,
   21653, -3180,   522, 21653,   141, -3180, 13940,  1409, -3180, 35692,
   35692, 21653, 21653,   200, -3180,   713, -3180,  1409,  1815, 20023,
   20023, 20023, -3180, -3180, -3180, -3180, -3180,   594, -3180, -3180,
   -3180,  1438, -3180, -3180, -3180, -3180, -3180, 40525,   132, -3180,
   -3180,  1409,  1835, -3180, -3180,  1449, 42673, -3180, -3180, -3180,
   -3180,    11, -3180, -3180, -3180, -3180,  -104, -3180, -3180, -3180,
   -3180,  1573,    14, 42673, -3180, -3180,    14,   970, 21653,    14,
      14, -3180, -3180,   845, -3180,   -57, -3180, -3180, -3180, -3180,
   42673,   877,  1583,  1451, -3180, -3180, 21653, -3180,  1453, -3180,
    1846,  1973,  1223, -3180, -3180, -3180,   283,   283,  1409,  1568,
    1570,  1571,  1572,  1574,  1604, -3180, -3180,   210,  1959,   283,
     283,  1959,   283,   283,   283,  1541,  1908,   283,  1798,  1557,
     698,  1805,   283, -3180,  1560,  1913,   283,   283,   283,  1959,
    1990,   283,   283,   283,   283,   283,   138,   283,   283,   283,
   -3180,  2858, -3180, -3180,  1478, 20563, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, 41062, -3180, 13940,   758,  1409,  1409,
     604,  1409,   758,  1409,  1409,  1409,  1409,  1409,   758,  1409,
    1409,   758,  1553, -3180, -3180, -3180, -3180, -3180,   -67, -3180,
   -3180,  1139, 42673, -3180,  1787, -3180, -3180, -3180, -3180, -3180,
   21653,  1524,  1469, 25968, -3180,   336, -3180,  1475, -3180,  1481,
    1484,   855, -3180,  1957,  1485, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180,  1486,  1488,  1490,  1492,  2029,  1493,   558,  1494,
    1495,  1499,  1500,  1502,   587,  1503, -3180,  1505,  1507,  1506,
   -3180,  1508,  1509,  1511,  1513,  1514,  1517,  1501,   857,   882,
    1515,  1518,   893, -3180,  1521,  1522,  1879,  1523,  1526,   898,
   -3180,  1525,  1527,  1528,   920,  1536,   927,   930, -3180, -3180,
   -3180, -3180,  1537,  1539, -3180, -3180,   347,  1543,  1540,  1544,
   -3180,  1546,  1548,  1549,   932,  1547,  1550,   951,  1551,  1552,
    1554,  1519,  1556, -3180,  1957,  1558,  1559,  1561,  1957,  1563,
     953,  1564,  1567,   955,   963,  1569,  1575,  1576,  1580,  1582,
    1584,   965,  1565,   968,  1585,   203,  1586, -3180,  1587,  1588,
    1590,  1591,   973, -3180,  1593,  1595,  1596,  1597,  1601,    76,
    1605,  1957,  1598,  1608,   985,  1611,  1613,  1609, 12251, 12814,
   13377,     0,  1614,   450, -3180,  1616, -3180,  1619,  1620, -3180,
    1501,  1621,   992,   996,  1622, 13940,   675, -3180,   429, -3180,
   -3180, -3180,  1504,   623, -3180,  1648, 42673, -3180,   495,  1468,
   -3180, -3180, -3180, -3180, -3180,    50, -3180,  1538, -3180,  1545,
    9436,   700,  1533, 16755,   105,  1186,  1626, 16755, 16755, 16755,
     960,   854,   854,   181,  2342,   181,  2342,  1074,  1074,  1074,
    1074,  1074,  1903, 13940, -3180,  1903, -3180,  1629,   343, -3180,
   -3180, -3180, -3180,  1062,  1865, -3180,  1617, -3180, -3180,  1008,
   -3180,  1562, -3180,  1577,  1640,  1646,  1647, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,  1223,
     713,  1657,  1625, -3180, -3180,  1651,  1882, -3180, -3180, -3180,
   -3180, -3180, -3180,  1666, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180,    61, -3180, -3180,  1631,  1631, 18398, -3180, -3180,
   -3180, -3180,  1851,  2023,  2024,  2026,   368, -3180,    49, -3180,
     902,  1976,  1223, -3180,  2028, 38377, 26507, -3180,  1634,  1978,
    1636,   283, 34081,   311, 24350, 34618, -3180, -3180,   604, -3180,
      60, -3180, -3180, -3180, -3180,   537,   537,  1671, -3180, -3180,
   -3180,  1469,   970, -3180, -3180, -3180,  1645, -3180, -3180,   336,
    1979,  1980, -3180,  1860,   650,  1860,   336,   336, 22733,   336,
    1974, -3180,   758,  1915, -3180, -3180, -3180, -3180, -3180, -3180,
   36766, 35155, -3180, -3180, -3180,  2119, -3180,  2122,   192, -3180,
   23273,  1007,  1007, -3180,   188,   202, 23273, -3180, -3180, 23273,
     604,   758, 23273,   758,  1409,  1409,  1447,   283,   758, -3180,
   -3180,  1986,  1987, 23273, 23273, -3180, 37840, -3180,   283,   696,
     604,   604, 23273, 22733,   689,  1409,   758,   758,   685, -3180,
   -3180, -3180, 21653,   725, 37840,  1667, -3180,  4349, 17858, 42673,
     267,   159, -3180,  1661,  1669, -3180,  1013, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
    1755, -3180,  1672, -3180, -3180,    70, -3180,  1669, 21653, 17318,
   -3180,   116, -3180,  1496, -3180,   336,  1889,   103,  1469,  1681,
      68, 15066, -3180, -3180, 13940,  1675, -3180, 13940, 13940, -3180,
   -3180, -3180,   164, -3180, 37303, -3180, -3180, -3180, -3180, -3180,
   13940, 37303,   164, 13940, -3180, -3180,  1677, -3180,  2018,  2018,
   -3180, -3180,  1172, -3180, 42673, -3180, 13940, -3180, 13940, -3180,
    1172, -3180, 13940, -3180, 13940, 13940, -3180,  1910, -3180, 13940,
   -3180, 13940, 13940, -3180, 13940, -3180, -3180, 13940, -3180, 13940,
   13940, -3180, -3180,  1914, -3180, 13940, 13940, -3180, -3180, 13940,
   -3180, 13940, -3180, 13940, -3180, 13940, -3180, 13940, -3180, 16755,
   22733,  1683, -3180, -3180, -3180,  1685, -3180, -3180, 13940, 13940,
   -3180, -3180, 13940, -3180, 13940, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, 13940, 13940, -3180, 13940, -3180, 13940, -3180, -3180,
   13940, 13940, 13940, -3180, 13940, -3180, -3180, -3180, -3180, 15629,
   13940, 13940, 13940,  1686, -3180, -3180, -3180, 13940, 13940, 13940,
   -3180, 13940,  2077, 13940,  2079, 13940,  2080, 13940, -3180, 13940,
    1921, -3180, -3180, -3180, -3180, -3180, 13940, -3180, 13940, -3180,
    1706, 13940, 13940,  2121, -3180, -3180,  1696,  1699, -3180,  1695,
    1697,  1698, 37840, 13940, -3180, -3180, -3180, 13940, -3180, -3180,
   13940, -3180, -3180, -3180, -3180,   429,  1016,  1702, 16755, -3180,
    1533, 16755,  9436,   700,  1533,   118, -3180, -3180, -3180,  1705,
   -3180, -3180,  1708, 42673, -3180, -3180, -3180, 42673,  1716, 27046,
   35692, 35692, 35692,  1712, 13940, -3180, -3180,  1937, -3180, -3180,
   21653,  2066, -3180, -3180, 35692, -3180,   284, 22733, -3180,  1715,
   -3180,  1715,   588,  1717,  1021, -3180, -3180, -3180,  1713,   949,
    2108, 35692, 35692, 35692, -3180,  1469,  1469,   101,  1771,  2059,
   -3180, -3180, -3180, -3180, 41599, -3180, -3180, -3180, -3180,   682,
   42673,  2041, 42673,  8873, -3180, -3180, -3180,  2223, 13940, -3180,
   35692,   569,   623,   283, -3180, -3180, -3180, -3180, -3180, -3180,
    1223, -3180, -3180, -3180, -3180,  2020, -3180,    14,   845,  -171,
   -3180,   975, -3180, -3180, -3180,  2057,   336,  1860,  1860,  2062,
    1960,   474,  1734, -3180,   283,   877,    38, -3180,   284, -3180,
   -3180, 13940, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, 13940,  2067,  2069,  1007, -3180,
   23273, -3180, -3180,  -150,   225, -3180, -3180, -3180, -3180, -3180,
   -3180, 35155,  1409, -3180, 23273, -3180, -3180,   247, -3180,  1409,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180,  1736, -3180,   888,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, 21653, -3180,
    1034, -3180, -3180, -3180, -3180, 42673, -3180, -3180, 21653, -3180,
   -3180,  2778, 42673, 42673,  2284, -3180, 42673, -3180, -3180, -3180,
   -3180, -3180,  1966,  -119,  2286, -3180, 21653, -3180,  1746,  1049,
   -3180, -3180, -3180,  2287,  3408, -3180,  1748,  1469,  2063, -3180,
   -3180, 13940,  1751,  1752, -3180, -3180,  1753,  1749,  1749, -3180,
   -3180,  1756,  1749,  2083, -3180,  2092,  1757,  1759,  1760,  1762,
    1765,  1767,  1768, -3180, -3180,  2342,  2342,  1770,  1750,  1772,
    1773,  1776,  1777,  1778,  1779,  1781,  1783,  1785,  1799,  1804,
    1786,  1809,  1813,  1814,  1816,  1817,  1889,  1793,  1807,  1811,
    1818,  1820,  1822,  1059,  1824,  1825,  1061,    -1, -3180, -3180,
   -3180,  1826,  1828,  1829,  1833,  1834,  1836,  1838,  1841,  1842,
    1845,  1843,  1849,  1850, 13940,  1852,   134,  1063,  1856, -3180,
    1853,  1858,  1861,  1855, 13940,  1863, 13940,  1864, 13940,  1867,
    1869,  1870,  1872,  1875, 13940,  1891, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180,  1859, -3180,  1234, -3180,  1878, -3180,
   -3180, -3180,   376, -3180,  1072,  1884, -3180, 16755, -3180, 13940,
    1886, -3180,  1885, -3180, -3180, -3180, -3180, -3180,  -110,  -110,
    -110, 16192, -3180,  2200, -3180,    54, -3180,  2091, -3180, -3180,
     894,  1887, -3180,   283, 16192,  1631,  1925, -3180, -3180,   588,
   22733, 26507, -3180, 35692,  1077,  1077,  1077,  1223,  2158,  1657,
    1657, -3180, 24887, -3180, -3180,  1922, -3180, -3180, 27585, -3180,
     790, -3180, -3180, 16755,  1183, -3180, -3180, -3180, 36766, -3180,
   -3180,   283,  1862,  1890, -3180, -3180, 42136, 13940, -3180,  2210,
   -3180, -3180,  1892,   336,  2005,   336, -3180,  2126,  2128,   336,
   -3180, -3180, -3180, 22733,  1469, 16192,  1007,  1007,  1007, -3180,
     894, -3180,  1894,   888, -3180, 23273, -3180, -3180,  -150,  1898,
    2251,  2253, 23273,  2223, -3180, -3180, -3180, -3180,  2778, 22733,
   -3180, -3180, -3180,  1076, -3180, 17858, -3180, -3180, -3180,  1899,
    1900,  1749, -3180, -3180, -3180, -3180, -3180,  1756,  2001, -3180,
    1756,  1756, -3180, -3180, -3180, -3180, -3180,   152,   195, -3180,
   -3180,   152, -3180, -3180, -3180,    74,   743,  1756, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180,  1749,  1749, -3180, -3180, -3180,
     152,  1901, -3180,  1749,   363, -3180,   163,    64,  1905,  1906,
    1749,  1907,  1896, -3180,  1080, -3180, -3180,   144, -3180,   591,
   -3180, -3180, -3180,  1893, -3180,  2858, -3180,   461, -3180, 42673,
   -3180,   537, -3180,  2342, -3180, -3180, -3180,  2032, -3180,   152,
    2065, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, 13940,  1911,  1912,  1917, -3180, -3180, -3180, -3180,
   -3180, -3180, 13940, -3180, -3180, -3180, -3180, -3180, 13940, -3180,
   -3180, -3180, -3180, -3180,  2042, -3180,  2081, 13940, 13940, -3180,
   -3180, -3180, -3180, 13940, -3180, -3180, -3180, 13940,  2411,  2098,
    1918, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   13940, -3180, -3180, -3180,  2342, -3180, 13940, -3180, -3180, 13940,
   13940, -3180, 13940, 13940, -3180,  1919, -3180,  1920, -3180,  1923,
   -3180, -3180,  2140, -3180, -3180, -3180, 13940,   949, 42673, -3180,
   -3180,  1924, -3180, -3180, -3180, -3180, -3180, -3180, -3180,   119,
    1939,  1939,  1939,  1183, -3180,  1083, -3180, -3180,  2264, -3180,
    1343, 22733, 16192,  1927,  1930, -3180,    30, -3180, -3180,  1926,
    1077, -3180,  2445,  2297, -3180, -3180, 37840,  1936, -3180, -3180,
    2196, -3180,   122,  2120, -3180, -3180, -3180,   569,  2025,  2027,
     283, -3180,  1409,  2240,  1451,  2272,   982,  1988,   336,   336,
    1015,  1989, 13940, 13940,  1944, -3180,  1889, -3180, -3180, -3180,
   -3180, -3180,  1343, 13940, -3180,  1948,  1953, 42673, -3180,  1009,
     267, -3180,   363, -3180, -3180, -3180,   -10,  2183,  2184, -3180,
    -120, -3180,  1956,  -120,  -120,  2485,   179, -3180,  2485, 37303,
   -3180,  1040, -3180,  1991,   152, -3180, -3180,  1992, -3180, -3180,
   -3180,  -120,  1958,   152, -3180, -3180,  2190,  -120, -3180, 37840,
    1409,   980, -3180,  2012, -3180,  2416,  2293, -3180,   363, -3180,
    2294,  2197, -3180,  2198, -3180, -3180,  2199, -3180,  2201,  2202,
    -120,  2203, -3180,  -120, 42673, -3180, 42673,  1996,   521, -3180,
   -3180, -3180,  1977,  1975, -3180, -3180, 21653, -3180, -3180, -3180,
   -3180,  2043, 42673,  1996, -3180,    30,   116,  1925, -3180,  1085,
     888,  1983, -3180,  1993,  1994, -3180,  1088,  1995, -3180, -3180,
   -3180,  1090,  1997,   124,  1998,  1999,  2002,  2000,  2003,  2006,
    2237,  2397, -3180,  2007,  2008,  2009,  2010,  2011,  2013,  2014,
   -3180, -3180, -3180,  2004, -3180, -3180, -3180, -3180,  2015, 38377,
   -3180,  2073,  2074, -3180, -3180,  2075, -3180, -3180,   148,  1046,
   -3180, -3180, -3180, -3180, 16192,  2320, -3180,   926, -3180, -3180,
   -3180, -3180, 13940, -3180,  1889,  2488, -3180, 24887, -3180, -3180,
   -3180, -3180, -3180,  2017,  2019,  8873,  2563, -3180,   336, -3180,
    2064, -3180, -3180, -3180,  2070, -3180, -3180, 42673,  2063,  2022,
     926,   888, 42673, 42673,  1094,   -65,   -65,   -65,   695,   695,
   -3180, -3180, -3180, -3180,   697,   120, 42673, -3180, -3180,   873,
   -3180,  2030,  2031, -3180, -3180, -3180, -3180,  -120, -3180,   124,
   -3180, -3180, -3180, -3180, -3180, 37303, -3180, -3180,  2485, -3180,
   -3180, -3180,   124, -3180,  2033, -3180, -3180, -3180,  1039, -3180,
   -3180,  2261,  2076, -3180, -3180, -3180, -3180,  2035,  2036,  2037,
    2039, -3180,  2045, -3180, -3180, -3180,   213, -3180, -3180, -3180,
   -3180, -3180,    46, 42673,  2421,  1409,  2044,  2046, -3180, -3180,
   -3180, -3180, -3180,  2048,   949, -3180, 42673, -3180,  2259, -3180,
   -3180, -3180,  2273, -3180, -3180, 13940, -3180, -3180, -3180,  1957,
   -3180, 13940, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180,   121,  2268,   758,   758,   758,   758,  1046, -3180, -3180,
    2101,  2141, -3180,   902, -3180,   381,   888, 13940,  1223,   175,
    2365, -3180, -3180, -3180, -3180,  2346,  1047, 13940,  2058, 13940,
    2060,  1098, -3180, -3180, 41062, -3180, -3180,  1104,  1108, -3180,
   -3180, -3180,   267, -3180, -3180, -3180,   374,   374,  1110, -3180,
   -3180, -3180, -3180, -3180,  1115, -3180, -3180, -3180,  1117, -3180,
   -3180,  1039, -3180,   152,  2485,   152,  2485,  2560,  2279,  2565,
   -3180,  -146, -3180, -3180,  2778, -3180, -3180, -3180, 42673,  2778,
   -3180, -3180,   888,  2068,  2071,  1123,  2072,  2082,  2084, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, 22733, 21653, -3180,   140,
   13940, -3180, -3180, -3180,  2257,  2580,  2581,  2491,  2583,   175,
   -3180,  -105, -3180,  2486, -3180, -3180, 42673, -3180, 42673, -3180,
   42673,  2086,  2088,  2246, -3180, -3180, -3180,  2626, -3180,   158,
   -3180, -3180,   873, 42673,   152,   124,   152, -3180, -3180, -3180,
   -3180, -3180,  2292, -3180,  2296, -3180,  2090,   987, -3180,  2504,
    2239, -3180, -3180,    30, -3180, -3180, -3180, -3180, 13940, -3180,
   -3180, -3180,  2094, -3180,   283, -3180, -3180, -3180,   888, 42673,
   -3180,   124,   124,  2600,   124, -3180,  2608,  2609,  -105, -3180,
     604, 13940,  1127,  1129, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180,    30, -3180, -3180,
   -3180,  2536, 32460,  2243, -3180, -3180,  2097, 22733, 16192,  1447,
   -3180, -3180, -3180, -3180,   124, -3180,   124,   124, -3180,  2643,
    2095, -3180, -3180, -3180, -3180, 42673,   654, -3180, 43747, 43747,
   42673, -3180,  2129, -3180,  3809,   125, -3180, -3180, -3180, -3180,
   -3180,  2096, -3180, -3180,  2778, -3180, -3180, -3180, 35155, -3180,
    2103, -3180, -3180, -3180,  2390, -3180, -3180, -3180,  2498, 42673,
   -3180, -3180, -3180, -3180, 13940, 13940,  2138, -3180, -3180, 32460,
   32460, -3180, -3180, -3180, 32460, -3180, -3180,  2488,  2110,  2530,
   -3180,  2451,  2537, 13940, -3180, -3180, -3180,   719, -3180, -3180,
   29750,  2106, 33002, 13940,   125, -3180, -3180,  2365, 13940,  2116,
    2117, -3180,   758, -3180,  2469,  2133,  2149, 13940, 32460, -3180,
    2544,  2577,  2422,  2118, -3180,  2115,  2562, 43747,   987,  2478,
   -3180, -3180, -3180, -3180, 42673, -3180, -3180, -3180,   728, -3180,
   -3180, 30292,  2142, 38914, 30834,  2123, -3180, -3180, 13940, -3180,
   -3180, -3180, 32460,  2358,  2132, -3180,  2134, -3180, 32460, 13940,
   -3180,  2556,  2148, -3180, -3180, -3180,  2502,  2136,  1087, -3180,
    2135, -3180,  2564, 32460, -3180,  2452, 18938,  2278, 42673, 28124,
   -3180,  2159, 32460,  2538, 42673,  2778,  2542,  2545, -3180,  2321,
   31376, -3180, -3180, 37840,  1135, -3180, -3180, 22733, -3180, -3180,
      89,  2167, -3180, 28666, -3180, -3180,  2610,   605, -3180, -3180,
    2182, -3180, -3180, 21108,  2094, -3180, 32460, -3180, 32460, 33544,
   13940, -3180,  2194, -3180, -3180, -3180,  3809, -3180, -3180, -3180,
   31918, 29208, -3180, -3180, 25424, -3180, -3180,  2550, -3180, -3180,
   -3180,  1172, -3180, 33544, -3180, -3180, -3180, -3180
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
   -3180, -3180, -3180, -3179, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180,   928, -3180, -3180, -3180, -3180, -3180,  1158, -1381,
   -3180, -3180, -3180, -3180, -3180,   136,    18, -3180, -3180, -3180,
   -3180, -3180, -3180,  2049,  -801, -3052, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180,  -463,  -581, -3180, -3180,  -454,
   -3180, -3180, -2260, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180,  -897, -3180,  -932, -3180, -3180, -1956, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180,  -903, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180,  -825, -3180, -3180,
    -783, -3180, -3180,  -823, -3180, -3180, -3180,  -787, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180,  -278, -3180, -3180,
   -1784, -3180, -3180, -3180,  1623, -3180,  1680, -3180,  2357, -3180,
    -378,     6,  1236, -1855, -1004,  -560,  -523,  -796, -3180, -3180,
   -3180,  -358, -3180, -3180,   735,    78,  1235,  1261,   780,   821,
   -3180, -3180,   100, -3180, -2592, -3180, -3180, -3180,    67, -3180,
      73, -3180, -3180, -3180, -1406,    32, -1376, -3180,  -373, -1527,
   -3180,  -164, -3180,  -206, -3180,  -435, -1982, -1891, -3180, -3180,
   -3180,  -195,   115,   161, -3180, -2546, -2172, -3180, -3180,  -576,
   -3180, -3180, -3180,  -582, -3180,  -348,  -495, -3180, -3180, -1446,
   -1720, -3180, -3180, -1908,  1643, -2019,  -412, -1820, -3180,  -367,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,   809,
   -3180, -3180, -3180, -1138,   285, -1295, -2721, -3180, -3180, -3180,
   -3180, -3180, -3180,   940, -3180, -3180,  1332,  1742, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,   950,
   -3180, -3180, -3180, -3180, -3180,  -848,  1668, -3180, -3180, -3180,
     346, -3180, -3180, -3180, -3180,  1393, -3180, -3180,  2112, -3180,
   -3180, -3180, -3180,   553,   972, -3180, -3180, -3180,  2131,   943,
    -456, -1706, -3180,  2344, -3180, -3180, -3180, -1276, -1869, -3180,
    2206,  -440, -1702,  1391,  -703,   -45, -3180,  -247,  -731,  4745,
   -3180, -3180, -1228, -3180, -3180,  -772, -3180, -3180, -1240, -1162,
    1510,  1498,   205,   384,    36, -3180, -3180,  -484, -3180, -3180,
   -3180, -1221,  -698, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
     -43, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -1118, -3180,   764, -3180, -1088, -3180, -3180, -3180,  1603,
   -3180, -3180, -3180, -3180, -3180, -1854, -1438,   196, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -1818, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -1318, -3180, -1677, -3180,  -943,
   -3180, -3180,  -438, -2046, -1160,   443, -3180, -3180,  -950,  1660,
   -1508, -3180, -3180, -3180,   617, -3180, -3180, -3180, -3180, -3180,
     167, -1967, -1021, -3180, -3180, -2569,  -608, -1775,  -599, -3180,
   -1792,  -277, -1140, -1829, -3180, -3180, -3180, -3180,  -720, -3180,
   -3180, -3180,  -253,   974, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180,  -436,  -355,   853, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180,  1888,  1868,  1019, -3180, -3180, -1888, -3180,
   -3180,   997, -3180,   -29, -1815, -1188,   259, -3180, -3180,   262,
   -2567, -3180, -3180, -3180, -3180, -3180, -3180,   204,  -769,  -587,
    2405, -3180, -3180, -3180, -3180, -3180, -3180,  2137,  1707, -1417,
    2350, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
    2417, -3180,  -947, -3180,  -413, -3180, -3180,  -583, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180,  1491, -3180, -3180,
   -3180, -3180, -3180,  1883, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180,   281,  -652, -3180,  -480,  -666, -3180,  -546, -3180, -3180,
   -3180,  -770, -3180,  -749,  -657,  -987,  -106, -1841, -1408,   276,
    1877, -2760, -1116, -1269, -1245, -1761,    21, -3180,    -7,  -518,
    -430,  -887,  2717, -2628,  -376,  -485, -3180,  -189, -3180, -3180,
   -3180, -3180,  1446, -3180, -3180, -3180, -3180,   577, -3180, -3180,
   -3180,   244, -3180,   -26,  -221, -3180, -3180,   742, -3180,  1487,
   -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180,  1897,  2447,  2295, -3180,  1945, -3180,
   -3180, -3180, -3180, -3180,  -345, -3180,  -115, -3180, -1279,  1758,
     404, -3180,   661,  -851, -1141, -3180,  -346, -3180, -3180,   739,
    2459,  2305, -3180, -3180, -3180, -3180, -3180, -2189,  -579, -3180,
   -2255, -3180, -3180, -3180, -3180, -1126, -3180, -3180,  1607,  -161,
   -3180, -3180,  -111, -3180, -3180,   -81, -3180,  2424,  2179, -3180,
     881, -3180,   157, -3180, -3180,  -113, -3180, -3180, -3180, -3180,
   -3180, -3180, -3180, -3180, -3180,   922, -3180, -3180, -3180, -3180,
   -3180, -3180
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1978
static const short int yytable[] =
{
     374,   664,   635,   699,  1178,  1133,  1134,  1135,  1392,   986,
    1728,  1064,   374,  1602,  1013,   374,  1169,  1170,  1172,   657,
     657,   657,   374,   657,  1447,   657,  1028,   905,  1008,  1636,
    2336,  2184,   374,  1154,  1729,  1013,   551,  1603,  1604,  1605,
    1482,  1234,   374,   409,  2235,  2311,   964,   690,   691,  2299,
    1617,  1937,  1029,  2321,  2632,  2325,  2283,  2288,  2291,  2438,
    1750,  1634,  2457,  2253,  1953,  1626,  1791,  1758,  1747,  2460,
    2592,  1531,  1608,  1609,  2026,  1611,  2932,   907,  2917,  1456,
     374,  1695,  1895,  1236,  2924,   967,   943,  2272,  2320,   649,
    1459,  1460,  1262,  2303,  2304,  1266,  2985,  1774,  1776, -1826,
     374,   374, -1490,   374,  1675,  1673, -1491,  1679,   464,  1260,
    1645,  2355,  1070, -1827,   374, -1116,  2353,  -258,   718,  -248,
    -259,  2211,  1275,  1276,  1277,  1665,   469,   943,   470,  2957,
     943,  2374,  2375,  1358,  2557,  1706,  1707,   707,  1396,   485,
    1712,  1861,   479,  1685,  1686,  1687,   978,  2028,  1762,  1071,
    1764, -1890,  2955,  3498,  1694,  2956,  1969,   106,   653,  1911,
    1727,   938,  1731,  3111,  3230,  1286,  1287,  1288,  2435,  2342,
    2030,  2167,  2945,   429,  2965,  2342,  2265,  3061,  2354,  3061,
    2984,  2357,  2419,  2945,  2946,  1326,   605,   606,  1003,   935,
    3089,  1076,  2366,  2367,  1115,  2946,  2447,  2947,  1588,  3143,
    1269,  2376,   544,  2646,  2301,  2201,   605,   606,  2947,  3122,
     944,  2343,  2344,  3025,  1837,  2945,  2345,   605,   606,  2448,
     973,  3635,  1066,  1032,  2808,  1066,  3396,  2946,  2319,  2599,
    1885,  1541,  3276,   605,   606,  2428,  1010,   107,   657, -1116,
    2947,   556,  1407,  1079,   692,  2345, -1490,  2150,  2647,   605,
    2951,   944,  1423,   811,   944,  1035,   669,  1054,  2449,  2345,
     998,  2450,  3297,  2999,  2430,   415,  3418,  -338,  1882,  2451,
    3298,  3000,  1004,  3124,   456,  2405,  1929, -1948,   492,  1488,
    1970,  1014,  1538,  1024,  2739,  3497,  2010,  2859,  1930,  2420,
    1413,  1489,  1592,  1022,  1116,  1358,   589,  1117,  1112,  1921,
    1011,  2339,  2826,  1648,  1320,  3079,  1649,  1039,   495,  1118,
    3335,  1940,  1941,  3133,  1943,  1944,  1945,  1424,   114,  1948,
    3336,   108,  3246,   654,  1956,  3429,  2430,  3125,  1959,  1960,
    1961,  1042,   984,  1964,  1965,  1966,  1967,  1968,   694,  1973,
    1974,  1975,  1080, -1826,  1139,   573, -1490,  3062,  3406,  3062,
   -1491,  2660,  1086,  1837,  2346,   438,   109, -1827,   378,   439,
    1939,  2999,  1575,  1942,  2587,  1270,   406,  1140,  -339,  3000,
    3407,  1087,  1954, -1116,   419, -1948,  -338,  2580,  1040,   425,
    2202,  1962,   716,  2306,  1931,   416,  2968,   682,  3499,  3134,
   -1945,   374,  1478,  1314,  1043,   115,  3001,  1539,  1481,   695,
    1414,   374,  1593,  1425,   106,   374,   590,  1989,  3149,  2011,
     374,   655,  1999,   717,   457,   374,  2340,  3153,  2005,  1081,
    2266,  2008,  3356,  1086,  3135,  1917,  2969,  2406,  2137,  1055,
    2970,   383,  1449,  1838,  1119,  1176,   670,   374,   561,  1350,
    1455,  2740,  1087,  3063, -1490,  2659,  1872,  1490, -1491,  2431,
    2600,  3197,  1132,  1917,   374,  1656,  1461,  1462,  1886,  2650,
    1353,   671,  1483,  1005,   374,  3299,  1883,  3662,   374,  1468,
    2663,  2971,  1361,   546,   374,  2035,   374,   374,  2627,  2290,
    1433,   374,   374,  2452,   591,  1873,  1359,  1321,  3419, -1116,
    1426,   374,   675,   708,  3001,   374,  3429,   381,  2636,   574,
     374,   374,   472,   374,   374,   374,   374,  3239,  1070,  2645,
    1891,  2431,   110,  1120,   384,  1576,  1491,  1113,  3337,  3500,
    2439,   693,   545,  1723,   489,  1394,   901,  1531,   903,   904,
    2658,  1450,  1937,   984,  2809,  1403,   557,  1025,   512,   374,
    1492,  2203,  3266,  2408,  2665,  1071,  1830,   999,  3397,  1313,
    3126,  3355,  2347,  -507,  2648,   374,  2111,  2204,  1036,   570,
    2115,  2168,  1542,   374,   374,   936,  -339,  1070,   374,  1006,
    3398,  3064,  1838,  1937,  -338,   374,  1839,   677,  2257,  2748,
    2310,  2421,  3065,   958,  3065, -1116,  1395,  2437,  2273,  2342,
    2302,  1493,   970,  2153,   973,  -473,  1397,  2453,   939,  2958,
     655,  2210,  1729,  2342,  1071,   374,  2214,  2215,   586,  1469,
    2030,  1761,  2186,  1470,  2216,   709,  2217,   973,  -568,   657,
    3090,  3081,  1458,  1971,  2986,  1436,  1007,  1782,  2657, -1826,
   -1116,  3277, -1490,  1081,  2207,  3636, -1491,  1487,  2151,  2324,
    2637,  2638,  1271, -1827,   417,  2454, -1116,  1081,  1359,  1932,
    3338,  2661,  2187,  1785,  2948,  1313, -1977,  3066,  3055,  3501,
    1037,   374,  1494,  1729, -1826,  2948,  1583, -1490,  1313,   374,
    2029, -1491,   374,  2455,  1015,   374,   374,  3332, -1827,  1038,
   -1116,  3144,  -258, -1890,  -248,  -259,  1023,  1650,   697,   698,
    1651,  2982,  2348,  2972,  2379,  2827,  3007,  2948,  1874,  -502,
    2973,  2877,  3357,  1081,   479,  -137,  -339,  1081,  1992,  1596,
    1918,   374,  3378,   374,  -338,  1839, -1890,  3382,  1729,  2952,
    2722,   396,  1351,  2983,   683,   121,  1543,  2974,   592,   593,
     594,   595,   596,   597,  1577,  1322,  1323,  1324,  1918,  1138,
     490,  1143,   448,  3384,   598,  1115,   119,  3368,  1353,  3370,
    2926,   379,   380,  1313,  1567,   499,  1468,  2597,  2598,  2362,
    3191,   422,  1081,  1350,  1929,  1858,  1993,  1597,  2872,   418,
    2369,  1766,  2329,  3142,   424,  3358,  3147,   430,   428,   385,
     565,  2906,  1331,   449, -1364,  2910,  1825,  2975,    40,  1596,
     951,  1904,  1767,  1596,  1592,  2390,  2391,  2380,  1442,   755,
    3359,  2356,  2253,  2358,  1598,   397,  2897,   548,  2363,   500,
    2189,  2641,  -264,   386,  3008,  1375,  1859,  2907,  3422,  1755,
    3424,  2911,  2881,   655,  2381,  3487,  2383,  2384,  2388,  3440,
    3491,  3492,  1353,  2392,  1592,  2925,  1353,  2465,  2466,  2195,
     949,   435,  2196,   398,   387,  1116,  2208,  1597,  1117,  1289,
    1332,  1597,   450,  1409,   388,  2393,  2370,   768,   474,   476,
    1118,   374,  1596,   374,  1951,  1994,  1599,  2976,  1443,  1888,
    3273,  3477,  1790,  1890,  1916,  2190,  1893,  1894,  2870,  1832,
    2316,  1843,  3505,  1013,  1598,  1336,  2394,   952,  1598,  1851,
     117,   819,   118,  2317,  2342,   374,  1469,   962,  1447,  1447,
    1470,   374,  1826,  2222,  1616,  2622,   442,  2670,  3114,  2093,
    2223,  1086,  1751,  1877,  1833,  1834,  3329,   501,  1745,  3571,
    1597,  2759,  2623,  1356, -1364,  2763,   655,  2631,    51,  2750,
    1087,  1768,  1796,  2371,   423,  1995,  1600,  1048,   374,  1481,
     374,  3178,   374,  3330,  1674,  2307,  1599,  2497,  2922,  3108,
    1599,  2568,  2569,  2570,   374,   374,   795,  1598,  1592,  3022,
    2326,  2458,  1900,  3018,   374,   374,  2463,  3148,  1592,  2546,
    1922,  2553,  3009,  1531,  1784,   374,  3287,  3488,  2583,  1340,
     953,  2471,  2594,  2595,  2596,  1119,  1792,  1341,  2476,  1633,
     443,  2642,   -55,  1875,  2498,   811,   399,   374,   374,   374,
     374,  2671,  1729,  2485,  2486,  3311,  1376,   374,  1843,   374,
    2490,   811,  2170,  3626,   732,   374,  1600,   811,  2495,  1599,
    1600,  3017,  1437,  1438,  2372,   374,   816,  1439,  1440,   566,
    1990,  1991,  1448,  1998,  1444,  2000,  2001,  2002,  2003,  2004,
    1454,  2006,  2007,   732,  1410,  2624,  1351,  3642,  2191,  3274,
    1342,   459,  3010,  1457,  1488,   552,  2318,  2513,  2385,  1827,
    1900,  2386,  1952,   460,  1120,   577,  1489,  1900,  1678,  2213,
    2268,   374,  2666,   461,   374,  2044,   451,  3115,  1711,  2548,
    2440,  3179,   697,   698,   755,  3095,  2555,  1752,  3121,  1600,
    3101,  3102,  1901,  3267,  3268,  1769,   452,  1858,  1344,  1540,
    1900,  1996,  1601,   400,  2051,  3428,  3115,  1902,  2395,   466,
    1845,  1846,  1377,   755,  1096,  1097,  1308,  3248,   401,  2045,
    1903,   453,  3369,   374,  3371,   374,   374,   374,  3435,   374,
    3121,  3275,  1900,  1843,  2563,   766,  2916,  1309,   374,  1844,
     374,  1030,   768,  1026,   402,   553,   514,  2013,  2586,  2052,
    1377,  1570,  1571,   655,  2939,   578,  3124,  1573,  2269,   403,
    2368,   563,  3606,  3286,   766,   472,  2014,   572,   454,   655,
    2892,   768,  3453,  1011,   374,   655,  3607,  1176,  2397,   783,
     471,  1027,  1601,  2893,   927,   911,  1601,   651,  2963,  2964,
    1901,   440,   848,  1176,  1904,  1031,  2967,  1901,   481,  1176,
    2918,  2918,  2918,  2990,   117,  1902,   118,  2181,   783,   554,
    3125,  1345,  1902,  2894,   374,   482,   697,   698,  2634,   579,
    1086,  2182,  1490,  1347,   485,  1903,  1353,   487,  1807,  1937,
    1901,  1107,  1108,  3193,  3232,  1845,  1846,  1177,   496,  1087,
    3522,   795,  2222,   441,  3256,  1902,  1808,   928,  1753,  2608,
     508,  3516,   510,  1261,   511,  1601,   513,   498,  1903,  1265,
    3557,  1805,  1901,  1806,  1754,  3538,  1809,   386,  2959,   912,
     795,  2960,   374,  1847,  3538,   506,  1310,  1902,  3561,   543,
    1810,  2940,   564,  1905,  2943,  2944,   560,   374,   929,   646,
    1903,  1491,  1904,  1353,  1853,  1854,  1855,   574,   811,  1904,
    3412,  2961,  3413,   930,   546,  2774,  2775,  3158,   697,   698,
     815,   816,   697,   698,  2880,  1492,   665,  2855,  3599,  3099,
     676,  2257,   677,  1811,  1812,   913,   706,   811,   686,  1311,
    3233,  3234,  1904,  3610,  3235,  3236,   106,  1906,  1372,   815,
     816,  1373,  3623,   374,  1374,  1729,   899,  2276,   374,   914,
     374,  1813,  3103,   605,   606,   374,  1777,  1778,  1779,  1780,
    1781,   374,  1486,   374,  1904,   902,  1493,   908,   374,   374,
     924,   374,   659,   660,  2324,   661,  3650,   662,  3651,   644,
     645,  1905,   648,   374,  3344,   909,   374,   926,  1905,  1316,
    1317,   933,   374,   374,   374,   374,  1802,  1802,  1729,  1802,
    2379,   942,   374,   374,   374,   109,  1318,  1319,   941,  1814,
     956,  1824,  1739,  1740,   958,   931,  2033,  2034,  2065,  2066,
     374,  1905,   970,  1836,  1729,   957,  2359,  2360,  2547,   374,
    1802,  1802,  1802,   915,   965,  1906,   976,  1494,   977,   916,
    1312,  1313,  1906,  2067,  2068,   981,   374,  2382,   987,  1815,
     980,   374,   984,  1905,  2071,  2072,   655,   995,  3116,  2078,
    2079,  3117,  2851,   374,   996,  2795,   997,   917,  1002,   374,
    1011,   846,  1001,  3334,  1016,  1906,  3463,   848,  1017,  1892,
     849,  2083,  2084,  2198,  2199,   655,  1018,  3116,  2086,  2087,
    3117,  2088,  2089,  2100,  2101,  1020,  2289,  1910,  2293,  2298,
     846,   605,   606,   918,  1299,  1300,   848,  1906,  1019,   849,
    2552,  2361,  2104,  2105,  2117,  2118,  2121,  2122,  2559,  1499,
    1500,  1771,  1772,   919,  2123,  2124,  2131,  2132,   374,  2134,
    2135,  1033,  3118,  3119,  2143,  2144,  1034,   374,   920,  1021,
     118,  1047,  1301,  1049,  2335,  2289,  2156,  2157,  3525,  1050,
    -459,  -459,  1502,  2175,  2176,  1057,  1302,  2177,  2178,  -459,
    1052,  3118,  3119,  1503,  3543,   374,  3543,  3140,  3141,  2226,
    2227,  1077,  1504,   374,  2415,  2416,   374,  2549,  2550,  3438,
    1010,  3449,  2589,  2590,  1078,  3151,  1124,  3506,  1303,  1506,
    2016,  3155,  1125,  3023,  3375,  2674,  2675,  1126,  1010,  1128,
    1304,  2024,  2583,  1130,  1066,  3543,  1131,  1507,  3590,  -539,
    2745,  2675,  1497,  1136,  3171,  1147,  3594,  3173,  1149,  1498,
    2802,  2803,  2806,  2807,  2828,  2829,  1729,  1305,  1362,  1499,
    1500,  1325,  2467,  2852,  2853,  1150,  1512,  2934,  1081,  1132,
    2472,  2995,  2996,  3543,  3073,  3074,  3195,  3196,   655,  3201,
    3202,  3204,  3205,  1145,  3543,  3269,  3196,  1151,  1501,  3349,
    3350,  1152,  1502,  1153,  3044,  3353,  3196,  3543,  2289,  3354,
    3196,  3362,  3363,  1503,  1155,  2289,  3364,  3365,  3366,  3365,
     986,  1156,  1504,  1306,  3387,  3388,  1157,  1505,  3451,  3350,
    3452,  3350,  2628,  1158,  3543,  3543,  3632,  3633,  3664,  1506,
    1159,  1013,  1773,  1775,  2920,  2921,  1715,  1716,  1160,  1515,
    3270,  3271,  2884,  2885,  1066,  1161,  1516,  1507,  2861,  2862,
    3071,  3072,  1162,  1163,  2630,  1164,  1508,  1509,  1165,  1166,
    1167,  1168,  1510,  1171,  1173,  1174,  1175,  1315,  1365,   374,
    1511,  1179,  1180,  1181,  1182,  1183,  1512,  1184,  1185,  1186,
    1187,  1188,  1189,  1190,  1191,  1387,  2606,  1366,  1192,  2579,
    1369,  1193,  1194,  1355,  1447,  3058,  1195,  1196,  1388,  1197,
    1391,  1513,  1198,  1199,  1296,  1200,  1201,  1202,  1203,  1204,
    1205,  1206,  1517,  1400,  1207,  1209,  1210,  1211,  1212,  1213,
    1214,  1215,  1216,  1217,   517,   518,  1518,  1218,  1222,  1223,
    1224,  1225,  1226,  1227,  1228,  2621,  1229,  1230,  1231,  1232,
    1499,  1500,  1233,  1235,  1431,  1237,  2544,  1514,  1238,  1515,
    1094,  1095,  1096,  1097,  1098,  1099,  1516,  1239,  1100,  1101,
    1102,  1103,  1104,  1105,  1352,  1106,  1240,  1241,  1242,  1243,
     374,  -459,  -459,  1502,  2664,  1244,  1245,  1521,  1246,  1522,
    -459,  2667,  1247,  1248,  1503,  1249,  1250,  1251,   374,   374,
    1252,  1253,  1254,  1504,  1255,   374,   519,   374,   374,  1256,
    1523,  1524,  1257,  1525,  1258,  1259,  1263,  1402,  1264,  1267,
    1506,  1268,  1272,  1273,  1274,   548,  1278,  1279,  1280,  1281,
    1282,  1283,  1517,  1354,   520,  1066,  1357,  1367,  1507,  1370,
    1393,   374,  1399,  1401,  1408,  1416,  1518,  1422,   521,  1527,
    1435,  1519,  1451,   374,   374,  1154,   583,   518,  1463,  1465,
    1467,  1479,  1545,   374,  1563,  1544,  1547,  1512,  1546,   374,
     522,  1548,   374,  1549,  1550,   374,  1551,  1552,  1553,  1107,
    1108,   523,  1554,  1555,  1556,  1557,   374,   374,  1558,   374,
    1559,  1520,  1560,  3097,  1561,   374,   374,  1521,  1562,  1522,
    1568,  1566,  2673,  1572,  1580,   374,  1350,   374,  1585,  1592,
     524,   374,   374,  1271,  1620,  1640,  1654, -1116,  1671,  1703,
    1523,  1524,  1726,  1525,  1735,  2289,  1741,  1746,   519,  1760,
    1528,  1763,   943,  2389,  1783,   525,  1793,  1526,  1794,  1529,
    1515,   526,  1818,  1852,  1821,  1866,  1878,  1516,  1887,  1908,
    1880,   374,   374,  1909,  1913,  1912,   520,  1915,  1923,  1527,
    1924,  1925,  1926,  1928,  1927,  1929,  1946,  1947,  1950,  1949,
     521,  1957,  1958,  2018,  1963,  3006,  1955,   374,   527,  2425,
    1977,  2025,  2029,  2031,   374,  2032,  2036,  2042,  2038,  2039,
    2075,  2040,   522,  2041,  2043,  2046,  2047,   374,  2434, -1116,
    2048,  2056,  2049,   523,  2050,  2053,  2055,  2057,  2064,  2188,
    2058,  2059,  2060,  1517,  2061,  2193,  2062,  2069,  2063,  2109,
    2070,  1729,  2073,  1313,  2074,  2076,  2080,  1518,  2077,  2081,
    2082,  3316,   524,  3321,  3322,  3323,  3324,  2085,  -784,  2090,
    1528,  2091,  2095,   374,  2094,  2205,  2096,  2097,  2102,  1529,
    2098,  2099,  2103,  2106,  2107,  2108,   944,   525,  2110,  2112,
    2113,  2225,  2114,   526,  2116,  2230,  2119,  2133,  2120,  2228,
    2125,  2231,  2232,  2238,  2243,  3318,  2126,  2127,  1521, -1116,
    1522,  2128, -1116,  2129,  2229,  2130,  2136,  2138,  2139,   528,
    2140,  2244,  2141,  2142,  2559,  2145,  2146,  2147,  2148,  2154,
     527,  1523,  1524,  2149,  1525, -1116,   529,  2152,  -539,  2155,
    2160, -1116,   530,  2158,  -539,  2159,  2169,  2171,   531,  1081,
    2172,  2173,  2174,  2179, -1116,   374,  2212,  2240,  2242, -1116,
    -960,  2248,  1729,  2260,  2261,  2262, -1116,  2263,  1859,  1858,
    1527,  2280,   532,  2282, -1116,  2281,  2305,  2308,  2314,  2312,
    2313,  2330,  2337,   533,   534,  2338,   374, -1116,  2364,  2365,
     374, -1116,   374,   374,   374,   374,  2889,  2398,  2412,  2413,
   -1116,  2417,  2418,   374,  1481,  1586,  2444,   374,  2464,   787,
     374,  2477,  2335, -1116,  2499,  2487,  2500,  2519,  2524,   535,
    2526,  2528,  2531,  2534,   374,   374,   374,  2539,   943,  2537,
    2540,  1824,  2541,  2551,  2542,  2543,  2558,   374,   986, -1014,
    2566,   528,  2571,   374,  2573,   374,  2577,  2585,  2588,  2593,
    2591,  1528,  2604,   374,  2605,  2610,  2618,  2635,   529,  2629,
    1529, -1116,  2639,   536,   530,   537,  2643,  2640,  2669,  2655,
     531,  2656,  2735,  2738,  2742,  2746,  2764,  2744,  2749,  2757,
    2751, -1116,  2754,  2755,  2756,  2765,  2760,  2223,  2766, -1116,
    2767,  2768,   518,  2769,   532, -1116,  2770,  3616,  2771,  2867,
    2772,  2776,  2869,  2777,  2778,   533,   534,  2779,  2780,  2781,
   -1116,  2782,  2783,   374,  2784,  1843,  2785,  2019,  2788,  2882,
    2890,  1729,  2902,  2905,   374,  2796,  2908,   374,  2909,  2928,
    2786,  2929,  2941,  3024,  3616,  2787,  1178,  1262,  1266,  2797,
    2789,   535,  1729,  2798,  2790,  2791,  3207,  2792,  2793,  2799,
   -1116,  2800,   944,  2801,  3096,  2804,  2805,  2811,  1729,  2812,
    2813,   374,  3553,   519,  2814,  2815,  3026,  2816,   374,  2817,
   -1116,   374,  2818,  2819,  2821,   374,   374,  2820, -1116,   374,
    2822,  2823,  3035,  2825,  2831,   536,  2834,   537,  2830,   374,
    2832,   520,  2898,  2833,  2836,  2838,  2848,  3290,  2840,  2677,
    2841, -1116,  2842,  2843, -1116,   521,  2844, -1116,  2846,  2850,
    1327,  1328,  1329,  1330,  1331,  2854,  2858,  2743,  2857,  2871,
    2899,  3040,  3157,  2903,  3014, -1116,  2923,   522,  2927,  2937,
    2938,  2966, -1116,  2994,  3033,  2988,  2989,  2991,   523,  3041,
   -1116,  3053,  3028,  3029,  3069,  3300,  3301, -1116,  3030,  3042,
    3050,  3051,  3285, -1116,  3052,  3057,  3076, -1116,  3080,  3082,
   -1116, -1116,  3074,  2608,  3083,  3285, -1116,   524,  3087,  3088,
    3091,  3093,  3098,  3094,  3107, -1048, -1053, -1116,  3112, -1116,
    3086,  3145,  1332,  3113,  3131,  3132,  3139,  2985,  3152,  2982,
    3150,  3154,   525,  3161,  3162,  3163,  3165,  3166,   526,  3167,
    3168,  3176,  3169,  3170,  3172, -1116, -1116,  3182,  3181,  3185,
    3214,  2276, -1116,  3198,  1333,  1334,  1335,  1336,  3215,  3227,
    3228,  3229,  3240,  3249,  3199,  3200,  3203, -1116,  3206,  3208,
    3367,  3209,  3211,  3210,  3212,   527,  3223,  3213,  3216,  3217,
    3218,  3219,  3220,  2289,  3221,  3222,  3225, -1116,  3252,  3255,
    3253,  3258,  3264,   374,   374, -1116,   374,  3260,  3291,  3305,
    3313,  3281,  3282,  2335,  3289,   374,  3293,  3294,  3295,  3292,
    3296,   374,  3379,   657,  3314,  3307, -1116,  3202,  3308,  3310,
    3320,   374,  3326,  3327,  3341,   986,  3343,  3372,  3346,   374,
    3348,  3373,  3374,  3399,  3401,  3402,  3403,  3404,  3410,  3385,
    2408,  3417,  3386,  3389,  3425,  3433,   374,  1337,  3426,  1338,
    1339,  1340,  3434,  3390,  3444,  3391, -1116,  3415,   374,  1341,
    2416,  3427,  3446,  3447,  3454,   374,  3437,  3473,  3475,  3484,
    3485,  -210,   374,  3508,  3509,  3503, -1116,  3306,   374,  3510,
    3516, -1176,  3532,  3533,  3544,  3534,   528,  3551,  3555,  3552,
    3556,  3557,  3562,  3563, -1748,  3566,  3567,  3569,  3573,  3595,
    3583,  3591,  3596,   529,  3601,  3602,  3598,  3603,  3604,   530,
   -1116,  3611,  3609,  3608,  3617,   531,  3624,  3622,  3423,   657,
    3627,  2889,  1342,  3628,  3638,  3629,  3647,  3660,  3640,  3665,
    2009,  2224,   657,  1074,   375,  3548,  3309,  3381,  3303,   532,
    3643,  3667,  3649,  3580,  3539,  3581,   405,  3547,  3192,   411,
     533,   534,   374, -1116,  3442,  3443,   420,  3445,  1485,   497,
    1565,  3016,  3265,  2935,  2429,  2349,   431, -1116,  1933,  1343,
    1344,  2409,  2930,  2992,  3283,  2953,   447,  1976,  3123,  2289,
    1980,  2954,  3164, -1116,  3156, -1116,   535,  3416,  2931,  2896,
    3420,  3280,  3361,  1579,  3312,  3288,  2399,  3481,  1466,  3482,
    3483,  1564,  2245,  2576,  1835,  1085,  2241,  1897,  1062,  2264,
     663, -1116, -1116,  3328,   465,  3528,   991,  1857, -1116,  2678,
    2679,  3059,  3226,  1770,  3060,  2680,  2461,  2681,  2682,  2683,
     536,  1670,   537,  1765,   468,   375,  3352,   375,  1618,  2904,
    2556,  3263,  3575,  2684,  3251,  2271,  2933,  1386,   465,  2237,
    1404,   374,  3078,  2251,  2875,  3376,  2874,  2915,  3634,  3528,
    3476,   652,  1584,   725,   638,  3527,  2868,  1142,  1795,  3405,
    1406,  3549,  3448,  3648,   374,  3160,  2878,  1420,  1867,  2626,
    2900,  3092,  2685,  1345,  3254,  2686,   585,  1411,   979,   374,
    1829,  1499,  1500,  2687,  1346,  1347,  3319,  1379,  2565,   587,
    1569,  3325,   983,  3431,  3224,  1137,  1737,   678,  2424,  3013,
    3190,     0,  2688,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -459,  -459,  1502,     0,     0,     0,     0,  2689,
     374,  -459,     0,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     0,  1504,   657,     0,     0,     0,  2690,
       0,  2691,   374,     0,     0,     0,     0,     0,     0,     0,
       0,  1506,     0,     0,     0,     0,     0,     0,     0,     0,
    2692,  2693,   374,     0,     0,     0,  1066,     0,     0,  1507,
       0,   657,   657,     0,   657,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   374,
       0,     0,     0,     0,     0,     0,     0,     0,  1512,   374,
       0,  2694,     0,     0,  3478,   374,     0,     0,     0,     0,
       0,     0,     0,     0,   657,     0,   657,   657,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3184,  2695,     0,
       0,     0,     0,     0,     0,     0,     0,  2696,  2697,     0,
    2698,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3431,     0,     0,     0,  2699,  2700,
    2701,  1515,     0,     0,     0,     0,     0,     0,  1516,     0,
     374,     0,     0,     0,     0,     0,     0,     0,  2702,  2703,
    2704,     0,     0,     0,  2705,     0,     0,  2706,     0,     0,
     374,     0,  2289,     0,     0,   374,   374,     0,     0,     0,
    2707,  2708,     0,     0,     0,   509,     0,     0,     0,   374,
       0,     0,     0,     0,     0,   542,     0,     0,     0,   550,
       0,     0,     0,     0,   465,  2709,     0,  2710,   374,   569,
       0,     0,     0,     0,  1517,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3657,     0,     0,  1518,  2711,
       0,   465,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   666,  3657,
       0,     0,     0,     0,     0,     0,     0,     0,   465,   374,
       0,     0,   465,     0,     0,     0,     0,     0,   688,     0,
     465,   465,  2712,     0,  2713,   700,   550,     0,     0,  1521,
       0,  1522,     0,     0,  2714,   719,     0,     0,     0,   724,
       0,     0,     0,     0,   900,   375,     0,   375,   375,   550,
     465,  3666,  1523,  1524,     0,  1525,     0,  3631,     0,     0,
       0,     0,     0,  3472,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2715,  2716,   374,     0,  2717,
    2718,  2719,  2720,   948,     0,     0,     0,     0,     0,  3472,
    3472,  1527,     0,     0,     0,     0,     0,     0,     0,   465,
       0,     0,     0,     0,     0,     0,     0,   550,   465,     0,
       0,     0,   465,     0,     0,     0,     0,     0,     0,   465,
       0,   374,  2721,  2722,     0,     0,     0,     0,     0,     0,
    3472,  3472,     0,     0,     0,  3472,     0,     0,     0,   374,
     374,  2723,     0,     0,     0,     0,     0,     0,     0,   550,
       0,  3472,     0,  3472,     0,     0,     0,     0,     0,   374,
       0,   374,     0,   374,     0,     0,     0,     0,  3395,  3472,
       0,     0,  1528,     0,     0,     0,   374,     0,  3472,     0,
       0,  1529,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3472,     0,     0,  3472,     0,     0,     0,     0,
       0,     0,     0,  3472,     0,  1065,     0,     0,     0,  3472,
       0,     0,   374,   550,     0,     0,   465,     0,     0,  1084,
     465,     0,     0,     0,  3472,     0,     0,     0,     0,     0,
    3472,     0,     0,  3472,     0,     0,     0,     0,     0,     0,
       0,  3472,     0,     0,     0,  3470,     0,     0,     0,     0,
     374,  1499,  1500,     0,  3472,   465,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3472,   374,  3472,
       0,  3470,  3470,   374,     0,     0,     0,     0,     0,     0,
       0,  3472,  3472,     0,  1502,  3472,     0,     0,     0,     0,
       0,   374,     0,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,   374,     0,  1504,     0,     0,     0,     0,     0,
       0,     0,  3470,  3470,     0,     0,     0,  3470,     0,     0,
       0,  1506,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3470,     0,  3470,  1066,     0,     0,  1507,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3470,     0,     0,     0,     0,     0,     0,     0,     0,
    3470,     0,     0,     0,     0,     0,     0,   374,  1512,     0,
       0,     0,     0,     0,  3470,     0,   374,  3470,     1,     0,
       0,     0,     0,     0,     0,  3470,     0,     0,     2,     3,
       0,  3470,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     5,     0,  1293,  3470,  1295,     0,   374,
       0,   374,  3470,     0,     0,  3470,     0,   374,     0,     0,
       0,     6,     7,  3470,     0,     0,   374,     8,     0,     0,
     374,     9,    10,     0,     0,     0,  3470,     0,     0,   465,
       0,  1515,     0,     0,    11,   465,   374,     0,  1516,  3470,
       0,  3470,   374,     0,     0,     0,     0,     0,     0,    12,
       0,     0,     0,  3470,  3470,     0,     0,  3470,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,    13,     0,
       0,     0,  1380,     0,  1383,     0,   465,    14,    15,    16,
       0,     0,     0,     0,     0,     0,     0,     0,   465,   550,
      17,    18,     0,     0,     0,     0,     0,     0,   465,   465,
       0,     0,     0,     0,  1517,     0,     0,     0,     0,  1412,
       0,     0,     0,    19,     0,     0,     0,  1421,  1518,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    20,
       0,   375,   375,   465,   465,     0,     0,     0,     0,     0,
       0,   375,     0,   550,     0,     0,     0,     0,     0,   375,
       0,     0,     0,    21,     0,     0,     0,     0,     0,   465,
      22,     0,     0,    23,     0,     0,     0,     0,     0,  1521,
       0,  1522,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    24,     0,     0,     0,     0,     0,
       0,     0,  1523,  1524,     0,  1525,     0,     0,    25,     0,
       0,     0,     0,     0,     0,   465,     0,     0,   465,     0,
       0,     0,     0,     0,     0,     0,    26,     0,     0,     0,
       0,    27,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1527,     2,     3,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   550,     0,   550,
     375,   375,     0,   465,     0,     6,     7,     0,     0,     0,
       0,     8,   724,     0,  1587,     9,    10,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    11,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    12,     0,     0,    28,     0,  1627,     0,
       0,     0,  1528,     0,     0,     0,     0,     0,     0,     0,
       0,  1529,    13,     0,     0,     0,     0,    29,     0,     0,
       0,    14,    15,    16,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    17,    18,     0,     0,  1627,     0,
       0,     0,     0,     0,    31,     0,    32,    33,     0,     0,
      34,     0,     0,    35,     0,    36,     0,    19,     0,     0,
      37,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,    20,     0,    40,     0,     0,     0,     0,
       0,    41,     0,     0,     0,     0,    42,     0,     0,     0,
      43,     0,     0,     0,     0,     0,  1730,    21,     0,     0,
       0,     0,     0,     0,    22,     0,     0,    23,     0,    44,
       0,   550,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    25,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      26,     0,     0,    47,     0,    27,    48,   550,     0,     0,
       0,    49,  1788,     0,   550,     0,     0,     0,     0,   550,
       0,     0,     0,     0,     0,   465,     0,  1798,     0,     0,
       0,     0,  1803,  1803,    50,  1803,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   465,     0,     0,
     465,     0,     0,     0,     0,    51,   550,   550,   465,   465,
       0,     0,     0,     0,     0,     0,  1803,  1803,  1803,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1870,     0,     0,     0,     0,     0,
      28,     0,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1889,    29,     0,     0,     0,   465,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,  1899,     0,     0,
       0,     0,     0,   465,     0,     0,     0,     0,    31,     0,
      32,    33,     0,     0,    34,     0,     0,    35,     0,    36,
       0,     0,     0,     0,    37,     0,    38,     0,     0,     0,
       0,   603,     0,   565,   604,    39,     0,     0,     0,    40,
       0,     0,     0,     0,     0,    41,     0,     0,     0,     0,
      42,     0,     0,     0,    43,   605,   606,     0,     0,     0,
       0,     0,  1983,     0,     0,   607,     0,   608,     0,     0,
       0,  1987,     0,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,   609,   610,     0,     0,     0,     0,
       0,     0,     0,   611,     0,     0,     0,     0,     0,   375,
       0,     0,     0,     0,     0,     0,     0,   465,     0,     0,
    2027,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,     0,     0,     0,     0,    49,     0,     0,     0,     0,
   -1342,   612,     0,     0,     0,   613,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,  1497,     0,     0,     0,     0,
       0,     0,  1498,     0,   614,     0,   615,     0,     0,    51,
       0,     0,  1499,  1500,     0,     0,     0,     0,   616,     0,
     617,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1501,     0,   618,   619,  1502,     0,   620,     0,     0,
       0,     0,     0,     0,     0,     0,  1503,     0,     0,     0,
       0,     0,   621,     0,     0,  1504,     0,     0,     0,     0,
    1505,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1506,   622,     0,     0,     0,     0,   623,     0,
       0,     0,     0,     0,     0,     0,     0,  1066,     0,     0,
    1507,     0,     0,  2194,     0,     0,     0,     0,     0,  1508,
       0,     0,   624,     0,     0,  1510,     0,     0,     0,     0,
       0,     0,     0,  1511,     0,     0,     0,     0,     0,  1512,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   625,     0,     0,     0,     0,     0,
       0,     0,     0,   626,  1513,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   627,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   628,   629,     0,     0,
       0,     0,  1515,     0,  2258,     0,     0,     0,     0,  1516,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2277,  2279,     0,     0,     0,     0,     0,   550,
       0,   550,   550,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   630,     0,     0,     0,
       0,     0,     0,     0,     0,  1730,   631,     0,     0,     0,
       0,     0,     0,     0,     0,  1517,     0,   550,   550,     0,
       0,     0,     0,     0,     0,     0, -1773,  1983,     0,  1518,
     632,     0,     0,  1983,  1519,     0,  1983,     0,     0,  1983,
       0,     0,     0,   633,     0,     0,     0,     0,     0,     0,
    1983,  1983,     0,   550,     0,     0,     0,     0,     0,  1983,
    1730,     0,     0,     0,     0,     0,     0,     0,     0,   465,
       0,   550,     0,     0,  1520,  1983,  2404,     0,     0,     0,
    1521,     0,  1522,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1773,     0,     0,
       0,   634,     0,  1523,  1524,     0,  1525,     0,     0,     0,
       0,     0,     0,     0,     0,   465,  1983,     0,     0,     0,
    1526,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   550,  1527,     0,     0,     0,     0,     0,   550,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2468,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1627,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1528,     0,     0,     0,     0,     0,     0,
       0,     0,  1529,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   550,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2564,     0,     0,     0,  1798,     0,   948,   550,   550,   550,
       0,     0,     0,     0,     0,     0,     0,   465,     0,     0,
       0,   550,     0,     0,  1730,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   550,   550,
     550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2607,     0,     0,     0,     0,     0,  2609,     0,  2611,
       0,     0,     0,     0,     0,     0,     0,   550,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1983,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   550,     0,
       0,  1983,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   465,     0,     0,     0,     0,
       0,     0,  2676,     0,     0,   465,     0,     0,     0,  2732,
    2733,     0,     0,  2736,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   465,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     871,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   950,     0,     0,     0,  2258,  2879,     0,
     550,     0,     0,     0,     0,     0,     0,     0,     0,   550,
       0,     0,     0,     0,     0,  2564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   550,     0,     0,     0,     0,
       0,     0,     0,  1870,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1730,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1983,     0,     0,     0,     0,     0,     0,  1983,
       0,     0,     0,     0,     0,     0,  1730,     0,     0,     0,
       0,     0,  1983,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1093,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3021,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1208,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3056,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1730,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   550,     0,     0,     0,  1284,     0,     0,
       0,  1291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3021,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   550,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   550,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3174,     0,  3175,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   465,     0,     0,     0,     0,     0,  3189,
       0,     0,     0,     0,     0,  1419,     0,     0,     0,     0,
       0,     0,     0,     0,  1434,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2277,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   550,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3262,     0,     0,     0,     0,  3021,
    3021,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3279,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   550,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1589,  1590,  1591,     0,     0,     0,
    3304,     0,     0,  1606,  1607,     0,     0,  1610,     0,  1612,
    1613,  1614,  1615,  3021,     0,     0,  1619,     0,     0,  1621,
    1622,     0,  1623,     0,  1624,  1625,     0,  1628,  1629,  1630,
    1631,  1632,     0,  1635,     0,  1637,  1638,  1639,     0,  1641,
    1642,  1643,  1644,     0,  1646,  1647,     0,  1653,     0,     0,
    1657,  1658,  1659,     0,  1661,  1662,  1663,  1664,     0,  1666,
    1667,  1668,  1669,     0,     0,     0,     0,     0,  1676,  1677,
       0,  1680,  1681,  1682,  1683,  1684,     0,     0,     0,     0,
    1688,  1987,  1689,  1690,  1691,  1692,  1693,     0,     0,  1696,
    1698,  1699,  1700,  1701,  1702,     0,  1704,  1705,     0,     0,
    1708,  1709,  1710,     0,  1713,     0,  1714,     0,     0,     0,
    1717,     0,  1721,  1722,     0,     0,     0,     0,  1725,     0,
       0,     0,     0,     0,     0,  3189,  1732,  1733,  1734,     0,
       0,     0,     0,     0,     0,  1291,     0,     0,  1742,     0,
       0,     0,     0,  1730,   465,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3262,     0,  3262,     0,  3414,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3421,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1786,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3441,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1831,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1730,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3486,     0,     0,     0,     0,  3493,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   550,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3511,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3577,     0,     0,     0,     0,     0,     0,     0,     0,
    3588,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1988,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1730,     0,  3619,     0,     0,     0,     0,
       0,  3625,     0,     0,     0,     0,     0,     0,     0,     0,
     550,     0,     0,     0,  1730,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1730,     0,     0,     0,     0,     0,  3658,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3658,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2162,  2164,  2166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2218,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2442,     0,     0,  2443,
       0,     0,  2445,  2446,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2459,     0,     0,  2462,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2469,     0,  2470,     0,     0,     0,  2473,     0,  2474,
    2475,     0,     0,     0,  2478,     0,  2479,  2480,     0,  2481,
       0,     0,  2482,     0,  2483,  2484,     0,     0,     0,     0,
    2488,  2489,     0,     0,  2491,     0,  2492,     0,  2493,     0,
    2494,     0,  2496,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2501,  2502,     0,     0,  2503,     0,  2504,
       0,     0,     0,     0,     0,     0,     0,  2505,  2506,     0,
    2507,     0,  2508,     0,     0,  2509,  2510,  2511,     0,  2512,
       0,     0,     0,     0,  2515,  2516,  2517,  2518,     0,     0,
       0,     0,  2520,  2521,  2522,     0,  2523,     0,  2525,     0,
    2527,     0,  2529,     0,  2530,     0,     0,     0,     0,     0,
       0,  2532,     0,  2533,     0,     0,  2535,  2536,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2545,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2554,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2616,     0,
       0,     0,     0,  2620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2651,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2654,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2753,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2835,
       0,  2837,     0,  2839,     0,     0,     0,     0,     0,  2845,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2856,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2901,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3027,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3031,     0,     0,
       0,     0,     0,  3032,     0,     0,     0,     0,     0,     0,
       0,     0,  3036,  3037,     0,     0,     0,     0,  3038,     0,
       0,     0,  3039,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3043,     0,     0,     0,     0,
       0,  3045,     0,     0,  3046,  3047,     0,  3048,  3049,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3054,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3105,  3106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2651,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2651,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2616,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3315,     0,     0,     0,     0,     0,  3317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3333,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3345,     0,  3347,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2651,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3436,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3450,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3514,
    3515,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3535,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3546,     0,
       0,     0,     0,  3550,     0,     0,     0,     0,     0,     0,
       0,     0,  3560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3592,     0,   122,     0,   726,   124,   125,
     126,   127,     0,     0,  3600,     0,     0,   128,     0,     0,
     727,     0,   728,   130,   131,   729,   133,     0,   134,   730,
     135,     0,   731,   136,   732,   733,   734,   137,   735,     0,
     138,   139,  1718,   140,     0,   141,   142,     0,     0,   143,
     736,   144,     0,   145,   737,   738,   147,     0,   148,   149,
     150,   739,   151,     0,   740,   153,     0,   154,   155,   156,
     157,   158,   741,   742,   159,  3659,   160,   161,     0,   743,
       0,   744,   745,   746,     0,     0,   163,   747,   748,     0,
     749,   750,     0,   164,   165,   751,   752,   753,     0,     0,
       0,     0,   754,   168,   755,     0,     0,   756,   757,   169,
       0,   170,     0,     0,     0,   758,   759,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   760,   179,     0,   761,   762,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   763,
       0,   188,   764,   189,   765,   766,   190,     0,   767,   191,
     192,   193,   768,     0,   194,     0,     0,   769,     0,   195,
     196,     0,   770,   197,     0,   198,   771,   772,   773,   774,
       0,   775,   776,   200,   777,   778,   779,   202,     0,   203,
     780,     0,   781,   782,     0,   204,   205,     0,   206,   783,
       0,   207,     0,     0,     0,   784,   209,   210,   211,   785,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   786,
     215,   787,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   788,   220,     0,  1719,
     789,   221,     0,   790,   222,     0,     0,     0,   791,     0,
     792,     0,   224,   793,     0,   225,     0,   226,   794,     0,
       0,   795,     0,     0,     0,     0,   796,   227,   228,   229,
     230,   231,   232,   797,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   798,   242,   243,   244,   799,   245,   246,
       0,     0,     0,   247,   248,   800,   250,     0,     0,   801,
     252,   802,   803,   253,     0,   254,   804,   805,   806,   807,
     808,   809,   810,   259,   260,   261,   262,     0,   811,   263,
     264,     0,   265,   266,   267,   812,   813,   814,   268,     0,
     815,   816,     0,   269,   270,     0,   817,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   818,   819,   278,   820,   821,   822,   823,
     824,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     825,   287,   288,   289,   290,   291,   292,   293,   826,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   827,   828,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   829,   308,   309,   830,
     310,   311,   831,   312,   832,   314,   315,     0,   833,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   834,   835,   334,   335,
       0,   336,   836,   338,   837,   838,   839,   339,   340,   840,
     341,   342,     0,   343,   344,     0,   655,   345,   841,   842,
     843,   844,     0,     0,     0,     0,  1720,   350,     0,   351,
     845,   846,   847,   353,   354,   355,     0,   848,   356,   357,
     849,     0,   358,     0,     0,   850,   851,   359,     0,     0,
     360,     0,   361,     0,   852,   363,     0,     0,   853,   854,
     855,   856,   857,   364,     0,     0,   365,   858,     0,   366,
     367,   859,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   860,     0,   861,     0,     0,     0,     0,   862,     0,
       0,     0,   863,   864,     0,     0,     0,     0,   865,     0,
     866,     0,     0,   867,   868,     0,   869,   870,   122,     0,
     726,   124,   125,   126,   127,  2612,     0,     0,     0,     0,
     128,     0,     0,   727,     0,   728,   130,   131,   729,   133,
       0,   134,   730,   135,     0,  2613,   136,   732,   733,   734,
     137,   735,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   736,   144,     0,   145,   737,   738,   147,
       0,   148,   149,   150,   739,   151,     0,   740,   153,     0,
     154,   155,   156,   157,   158,   741,   742,   159,     0,   160,
     161,     0,   743,     0,   744,   745,   746,     0,     0,   163,
     747,   748,     0,   749,   750,     0,   164,   165,   751,   752,
     753,     0,     0,     0,     0,   754,   168,   755,     0,     0,
     756,  2614,   169,     0,   170,     0,     0,     0,   758,   759,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   760,   179,     0,   761,
     762,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   763,     0,   188,   764,   189,   765,   766,   190,
       0,   767,   191,   192,   193,   768,     0,   194,     0,     0,
     769,     0,   195,   196,     0,   770,   197,     0,   198,   771,
     772,   773,   774,     0,   775,   776,   200,   777,   778,   779,
     202,     0,   203,   780,     0,   781,   782,     0,   204,   205,
       0,   206,   783,     0,   207,     0,     0,     0,   784,   209,
     210,   211,   785,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   786,   215,   787,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   788,
     220,     0,     0,   789,   221,     0,   790,   222,     0,     0,
       0,   791,     0,   792,     0,   224,   793,     0,   225,     0,
     226,   794,     0,     0,   795,     0,     0,     0,     0,   796,
     227,   228,   229,   230,   231,   232,   797,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   798,   242,   243,   244,
     799,   245,   246,     0,     0,     0,   247,   248,   800,   250,
       0,     0,   801,   252,   802,   803,   253,     0,   254,   804,
     805,   806,   807,   808,   809,   810,   259,   260,   261,   262,
       0,   811,   263,   264,     0,   265,   266,   267,   812,   813,
     814,   268,     0,   815,   816,     0,   269,   270,     0,   817,
    2615,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   818,   819,   278,   820,
     821,   822,   823,   824,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   825,   287,   288,   289,   290,   291,   292,
     293,   826,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   827,   828,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   829,
     308,   309,   830,   310,   311,   831,   312,   832,   314,   315,
       0,   833,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   834,
     835,   334,   335,     0,   336,   836,   338,   837,   838,   839,
     339,   340,   840,   341,   342,     0,   343,   344,     0,   655,
     345,   841,   842,   843,   844,     0,     0,     0,     0,     0,
     350,     0,   351,   845,   846,   847,   353,   354,   355,     0,
     848,   356,   357,   849,     0,   358,     0,     0,   850,   851,
     359,     0,     0,   360,     0,   361,     0,   852,   363,     0,
       0,   853,   854,   855,   856,   857,   364,     0,     0,   365,
     858,     0,   366,   367,   859,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   860,     0,   861,     0,     0,     0,
       0,   862,     0,     0,     0,   863,   864,     0,     0,     0,
       0,   865,     0,   866,     0,     0,   867,   868,     0,   869,
     870,   122,     0,   726,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   727,     0,   728,   130,
     131,   729,   133,     0,   134,   730,   135,     0,   731,   136,
     732,   733,   734,   137,   735,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   736,   144,     0,   145,
     737,   738,   147,     0,   148,   149,   150,   739,   151,     0,
     740,   153,     0,   154,   155,   156,   157,   158,   741,   742,
     159,     0,   160,   161,     0,   743,     0,   744,   745,   746,
       0,     0,   163,   747,   748,     0,   749,   750,     0,   164,
     165,   751,   752,   753,     0,     0,     0,     0,   754,   168,
     755,     0,     0,   756,   757,   169,     0,   170,     0,     0,
       0,   758,   759,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   760,
     179,     0,   761,   762,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   763,     0,   188,   764,   189,
     765,   766,   190,     0,   767,   191,   192,   193,   768,     0,
     194,     0,     0,   769,     0,   195,   196,     0,   770,   197,
       0,   198,   771,   772,   773,   774,     0,   775,   776,   200,
     777,   778,   779,   202,     0,   203,   780,     0,   781,   782,
       0,   204,   205,     0,   206,   783,     0,   207,     0,     0,
       0,   784,   209,   210,   211,   785,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   786,   215,   787,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   788,   220,     0,     0,   789,   221,     0,   790,
     222,     0,     0,     0,   791,     0,   792,     0,   224,   793,
       0,   225,     0,   226,   794,     0,     0,   795,     0,     0,
       0,     0,   796,   227,   228,   229,   230,   231,   232,   797,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   798,
     242,   243,   244,   799,   245,   246,     0,     0,     0,   247,
     248,   800,   250,     0,     0,   801,   252,   802,   803,   253,
       0,   254,   804,   805,   806,   807,   808,   809,   810,   259,
     260,   261,   262,     0,   811,   263,   264,     0,   265,   266,
     267,   812,   813,   814,   268,     0,   815,   816,     0,   269,
     270,     0,   817,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   818,
     819,   278,   820,   821,   822,   823,   824,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   825,   287,   288,   289,
     290,   291,   292,   293,   826,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     827,   828,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   829,   308,   309,   830,   310,   311,   831,   312,
     832,   314,   315,     0,   833,   317,  1289,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   834,   835,   334,   335,     0,   336,   836,   338,
     837,   838,   839,   339,   340,   840,   341,   342,     0,   343,
     344,     0,   655,   345,   841,   842,   843,   844,     0,     0,
       0,     0,     0,   350,     0,   351,   845,   846,   847,   353,
     354,   355,     0,   848,   356,   357,   849,     0,   358,     0,
       0,   850,   851,   359,     0,     0,   360,     0,   361,     0,
     852,   363,     0,     0,   853,   854,   855,   856,   857,   364,
       0,     0,   365,   858,     0,   366,   367,   859,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   860,     0,   861,
       0,     0,     0,     0,   862,     0,     0,     0,   863,   864,
       0,     0,     0,     0,   865,     0,  1290,     0,     0,   867,
     868,     0,   869,   870,   122,     0,   726,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   727,
       0,   728,   130,   131,   729,   133,     0,   134,   730,   135,
       0,   731,   136,   732,   733,   734,   137,   735,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   736,
     144,     0,   145,   737,   738,   147,     0,   148,   149,   150,
     739,   151,     0,   740,   153,     0,   154,   155,   156,   157,
     158,   741,   742,   159,     0,   160,   161,     0,   743,     0,
     744,   745,   746,     0,     0,   163,   747,   748,     0,   749,
     750,     0,   164,   165,   751,   752,   753,     0,     0,     0,
       0,   754,   168,   755,     0,     0,   756,   757,   169,     0,
     170,     0,     0,     0,   758,   759,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   760,   179,     0,   761,   762,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   763,     0,
     188,   764,   189,   765,   766,   190,     0,   767,   191,   192,
     193,   768,     0,   194,     0,     0,   769,     0,   195,   196,
       0,   770,   197,     0,   198,   771,   772,   773,   774,     0,
     775,   776,   200,   777,   778,   779,   202,     0,   203,   780,
       0,   781,   782,     0,   204,   205,     0,   206,   783,     0,
     207,     0,     0,     0,   784,   209,   210,   211,   785,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   786,   215,
     787,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   788,   220,     0,     0,   789,
     221,     0,   790,   222,     0,     0,     0,   791,     0,   792,
       0,   224,   793,     0,   225,     0,   226,   794,     0,     0,
     795,     0,     0,     0,     0,   796,   227,   228,   229,   230,
     231,   232,   797,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   798,   242,   243,   244,   799,   245,   246,     0,
       0,     0,   247,   248,   800,   250,     0,     0,   801,   252,
     802,   803,   253,     0,   254,   804,   805,   806,   807,   808,
     809,   810,   259,   260,   261,   262,     0,   811,   263,   264,
       0,   265,   266,   267,   812,   813,   814,   268,     0,   815,
     816,     0,   269,   270,     0,   817,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   818,   819,   278,   820,   821,   822,   823,   824,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   825,
     287,   288,   289,   290,   291,   292,   293,   826,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   827,   828,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   829,   308,   309,   830,   310,
     311,   831,   312,   832,   314,   315,     0,   833,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   834,   835,   334,   335,     0,
     336,   836,   338,   837,   838,   839,   339,   340,   840,   341,
     342,     0,   343,   344,     0,   655,   345,   841,   842,   843,
     844,     0,     0,     0,     0,     0,   350,     0,   351,   845,
     846,   847,   353,   354,   355,     0,   848,   356,   357,   849,
       0,   358,     0,     0,   850,   851,   359,     0,     0,   360,
       0,   361,     0,   852,   363,     0,     0,   853,   854,   855,
     856,   857,   364,     0,     0,   365,   858,     0,   366,   367,
     859,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     860,     0,   861,     0,     0,     0,     0,   862,     0,     0,
       0,   863,   864,     0,     0,     0,     0,   865,     0,   866,
    1566,     0,   867,   868,     0,   869,   870,   122,     0,   726,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   727,     0,   728,   130,   131,   729,   133,     0,
     134,   730,   135,     0,   731,   136,   732,   733,   734,   137,
     735,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   736,   144,     0,   145,   737,   738,   147,     0,
     148,   149,   150,   739,   151,     0,   740,   153,     0,   154,
     155,   156,   157,   158,   741,   742,   159,     0,   160,   161,
       0,   743,     0,   744,   745,   746,     0,     0,   163,   747,
     748,     0,   749,   750,     0,   164,   165,   751,   752,   753,
       0,     0,     0,     0,   754,   168,   755,     0,     0,   756,
     757,   169,     0,   170,     0,     0,     0,   758,   759,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   760,   179,     0,   761,   762,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   763,     0,   188,   764,   189,   765,   766,   190,     0,
     767,   191,   192,   193,   768,     0,   194,     0,     0,   769,
       0,   195,   196,     0,   770,   197,     0,   198,   771,   772,
     773,   774,     0,   775,   776,   200,   777,   778,   779,   202,
       0,   203,   780,     0,   781,   782,     0,   204,   205,     0,
     206,   783,     0,   207,     0,     0,     0,   784,   209,   210,
     211,   785,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   786,   215,   787,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   788,   220,
       0,     0,   789,   221,     0,   790,   222,     0,     0,     0,
     791,     0,   792,     0,   224,   793,     0,   225,     0,   226,
     794,     0,     0,   795,     0,     0,     0,     0,   796,   227,
     228,   229,   230,   231,   232,   797,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   798,   242,   243,   244,   799,
     245,   246,     0,     0,     0,   247,   248,   800,   250,     0,
       0,   801,   252,   802,   803,   253,     0,   254,   804,   805,
     806,   807,   808,   809,   810,   259,   260,   261,   262,     0,
     811,   263,   264,     0,   265,   266,   267,   812,   813,   814,
     268,     0,   815,   816,     0,   269,   270,     0,   817,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   818,   819,   278,   820,   821,
     822,   823,   824,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   825,   287,   288,   289,   290,   291,   292,   293,
     826,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   827,   828,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   829,   308,
     309,   830,   310,   311,   831,   312,   832,   314,   315,     0,
     833,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   834,   835,
     334,   335,     0,   336,   836,   338,   837,   838,   839,   339,
     340,   840,   341,   342,     0,   343,   344,     0,   655,   345,
     841,   842,   843,   844,     0,     0,     0,     0,     0,   350,
       0,   351,   845,   846,   847,   353,   354,   355,     0,   848,
     356,   357,   849,     0,   358,     0,     0,   850,   851,   359,
       0,     0,   360,     0,   361,     0,   852,   363,     0,     0,
     853,   854,   855,   856,   857,   364,     0,     0,   365,   858,
       0,   366,   367,   859,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   860,     0,   861,     0,     0,     0,     0,
     862,     0,     0,     0,   863,   864,     0,     0,     0,     0,
     865,     0,   866,  1660,     0,   867,   868,     0,   869,   870,
     122,     0,   726,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   727,     0,   728,   130,   131,
     729,   133,     0,   134,   730,   135,     0,   731,   136,   732,
     733,   734,   137,   735,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   736,   144,     0,   145,   737,
     738,   147,     0,   148,   149,   150,   739,   151,     0,   740,
     153,     0,   154,   155,   156,   157,   158,   741,   742,   159,
       0,   160,   161,     0,   743,     0,   744,   745,   746,     0,
       0,   163,   747,   748,     0,   749,   750,     0,   164,   165,
     751,   752,   753,     0,     0,     0,     0,   754,   168,   755,
       0,     0,   756,   757,   169,     0,   170,     0,     0,     0,
     758,   759,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   760,   179,
       0,   761,   762,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   763,     0,   188,   764,   189,   765,
     766,   190,     0,   767,   191,   192,   193,   768,     0,   194,
       0,     0,   769,     0,   195,   196,     0,   770,   197,     0,
     198,   771,   772,   773,   774,     0,   775,   776,   200,   777,
     778,   779,   202,     0,   203,   780,     0,   781,   782,     0,
     204,   205,     0,   206,   783,     0,   207,     0,     0,     0,
     784,   209,   210,   211,   785,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   786,   215,   787,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   788,   220,     0,     0,   789,   221,     0,   790,   222,
       0,     0,     0,   791,     0,   792,     0,   224,   793,     0,
     225,     0,   226,   794,     0,     0,   795,     0,     0,     0,
       0,   796,   227,   228,   229,   230,   231,   232,   797,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   798,   242,
     243,   244,   799,   245,   246,     0,     0,     0,   247,   248,
     800,   250,     0,     0,   801,   252,   802,   803,   253,     0,
     254,   804,   805,   806,   807,   808,   809,   810,   259,   260,
     261,   262,     0,   811,   263,   264,     0,   265,   266,   267,
     812,   813,   814,   268,     0,   815,   816,     0,   269,   270,
       0,   817,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   818,   819,
     278,   820,   821,   822,   823,   824,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   825,   287,   288,   289,   290,
     291,   292,   293,   826,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   827,
     828,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   829,   308,   309,   830,   310,   311,   831,   312,   832,
     314,   315,     0,   833,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   834,   835,   334,   335,     0,   336,   836,   338,   837,
     838,   839,   339,   340,   840,   341,   342,     0,   343,   344,
       0,   655,   345,   841,   842,   843,   844,     0,     0,     0,
       0,     0,   350,     0,   351,   845,   846,   847,   353,   354,
     355,     0,   848,   356,   357,   849,     0,   358,     0,     0,
     850,   851,   359,     0,     0,   360,     0,   361,     0,   852,
     363,     0,     0,   853,   854,   855,   856,   857,   364,     0,
       0,   365,   858,     0,   366,   367,   859,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   860,     0,   861,     0,
       0,     0,     0,   862,     0,     0,     0,   863,   864,     0,
       0,     0,     0,   865,     0,   866,  1697,     0,   867,   868,
       0,   869,   870,   122,     0,   726,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   727,     0,
     728,   130,   131,   729,   133,     0,   134,   730,   135,     0,
     731,   136,   732,   733,   734,   137,   735,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,   736,   144,
       0,   145,   737,   738,   147,     0,   148,   149,   150,   739,
     151,     0,   740,   153,     0,   154,   155,   156,   157,   158,
     741,   742,   159,     0,   160,   161,     0,   743,     0,   744,
     745,   746,     0,     0,   163,   747,   748,     0,   749,   750,
       0,   164,   165,   751,   752,   753,     0,     0,     0,     0,
     754,   168,   755,     0,     0,   756,   757,   169,     0,   170,
       0,     0,     0,   758,   759,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,   760,   179,     0,   761,   762,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,   763,     0,   188,
     764,   189,   765,   766,   190,     0,   767,   191,   192,   193,
     768,     0,   194,     0,     0,   769,     0,   195,   196,     0,
     770,   197,     0,   198,   771,   772,   773,   774,     0,   775,
     776,   200,   777,   778,   779,   202,     0,   203,   780,     0,
     781,   782,     0,   204,   205,     0,   206,   783,     0,   207,
       0,     0,     0,   784,   209,   210,   211,   785,     0,   212,
     213,     0,     0,     0,   214,     0,     0,   786,   215,   787,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,   788,   220,     0,     0,   789,   221,
       0,   790,   222,     0,     0,     0,   791,     0,   792,     0,
     224,   793,     0,   225,     0,   226,   794,     0,     0,   795,
       0,     0,     0,     0,   796,   227,   228,   229,   230,   231,
     232,   797,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   798,   242,   243,   244,   799,   245,   246,     0,     0,
       0,   247,   248,   800,   250,     0,     0,   801,   252,   802,
     803,   253,     0,   254,   804,   805,   806,   807,   808,   809,
     810,   259,   260,   261,   262,     0,   811,   263,   264,     0,
     265,   266,   267,   812,   813,   814,   268,     0,   815,   816,
       0,   269,   270,     0,   817,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   818,   819,   278,   820,   821,   822,   823,   824,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   825,   287,
     288,   289,   290,   291,   292,   293,   826,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,   827,   828,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,   829,   308,   309,   830,   310,   311,
     831,   312,   832,   314,   315,     0,   833,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,   834,   835,   334,   335,     0,   336,
     836,   338,   837,   838,   839,   339,   340,   840,   341,   342,
       0,   343,   344,     0,   655,   345,   841,   842,   843,   844,
       0,     0,     0,     0,     0,   350,     0,   351,   845,   846,
     847,   353,   354,   355,     0,   848,   356,   357,   849,     0,
     358,     0,     0,   850,   851,   359,     0,     0,   360,     0,
     361,     0,   852,   363,     0,     0,   853,   854,   855,   856,
     857,   364,     0,     0,   365,   858,     0,   366,   367,   859,
       0,     0,     0,     0,   369,     0,   370,   371,     0,   860,
       0,   861,     0,     0,     0,     0,   862,     0,     0,     0,
     863,   864,     0,     0,     0,     0,   865,     0,   866,  1724,
       0,   867,   868,     0,   869,   870,   122,     0,   726,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   727,     0,   728,   130,   131,   729,   133,     0,   134,
     730,   135,     0,   731,   136,   732,   733,   734,   137,   735,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,   736,   144,     0,   145,   737,   738,   147,     0,   148,
     149,   150,   739,   151,     0,   740,   153,     0,   154,   155,
     156,   157,   158,   741,   742,   159,     0,   160,   161,     0,
     743,     0,   744,   745,   746,     0,     0,   163,   747,   748,
       0,   749,   750,     0,   164,   165,   751,   752,   753,     0,
       0,     0,     0,   754,   168,   755,     0,     0,   756,   757,
     169,     0,   170,     0,     0,     0,   758,   759,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,   760,   179,     0,   761,   762,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
     763,     0,   188,   764,   189,   765,   766,   190,     0,   767,
     191,   192,   193,   768,     0,   194,     0,     0,   769,     0,
     195,   196,  2161,   770,   197,     0,   198,   771,   772,   773,
     774,     0,   775,   776,   200,   777,   778,   779,   202,     0,
     203,   780,     0,   781,   782,     0,   204,   205,     0,   206,
     783,     0,   207,     0,     0,     0,   784,   209,   210,   211,
     785,     0,   212,   213,     0,     0,     0,   214,     0,     0,
     786,   215,   787,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,   788,   220,     0,
       0,   789,   221,     0,   790,   222,     0,     0,     0,   791,
       0,   792,     0,   224,   793,     0,   225,     0,   226,   794,
       0,     0,   795,     0,     0,     0,     0,   796,   227,   228,
     229,   230,   231,   232,   797,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   798,   242,   243,   244,   799,   245,
     246,     0,     0,     0,   247,   248,   800,   250,     0,     0,
     801,   252,   802,   803,   253,     0,   254,   804,   805,   806,
     807,   808,   809,   810,   259,   260,   261,   262,     0,   811,
     263,   264,     0,   265,   266,   267,   812,   813,   814,   268,
       0,   815,   816,     0,   269,   270,     0,   817,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   818,   819,   278,   820,   821,   822,
     823,   824,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   825,   287,   288,   289,   290,   291,   292,   293,   826,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,   827,   828,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,   829,   308,   309,
     830,   310,   311,   831,   312,   832,   314,   315,     0,   833,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,   834,   835,   334,
     335,     0,   336,   836,   338,   837,   838,   839,   339,   340,
     840,   341,   342,     0,   343,   344,     0,   655,   345,   841,
     842,   843,   844,     0,     0,     0,     0,     0,   350,     0,
     351,   845,   846,   847,   353,   354,   355,     0,   848,   356,
     357,   849,     0,   358,     0,     0,   850,   851,   359,     0,
       0,   360,     0,   361,     0,   852,   363,     0,     0,   853,
     854,   855,   856,   857,   364,     0,     0,   365,   858,     0,
     366,   367,   859,     0,     0,     0,     0,   369,     0,   370,
     371,     0,   860,     0,   861,     0,     0,     0,     0,   862,
       0,     0,     0,   863,   864,     0,     0,     0,     0,   865,
       0,   866,     0,     0,   867,   868,     0,   869,   870,   122,
       0,   726,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   727,     0,   728,   130,   131,   729,
     133,     0,   134,   730,   135,     0,   731,   136,   732,   733,
     734,   137,   735,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,   736,   144,     0,   145,   737,   738,
     147,     0,   148,   149,   150,   739,   151,     0,   740,   153,
       0,   154,   155,   156,   157,   158,   741,   742,   159,     0,
     160,   161,     0,   743,     0,   744,   745,   746,     0,     0,
     163,   747,   748,     0,   749,   750,     0,   164,   165,   751,
     752,   753,     0,     0,     0,     0,   754,   168,   755,     0,
       0,   756,   757,   169,     0,   170,     0,     0,     0,   758,
     759,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,   760,   179,     0,
     761,   762,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,   763,     0,   188,   764,   189,   765,   766,
     190,     0,   767,   191,   192,   193,   768,     0,   194,     0,
       0,   769,     0,   195,   196,  2163,   770,   197,     0,   198,
     771,   772,   773,   774,     0,   775,   776,   200,   777,   778,
     779,   202,     0,   203,   780,     0,   781,   782,     0,   204,
     205,     0,   206,   783,     0,   207,     0,     0,     0,   784,
     209,   210,   211,   785,     0,   212,   213,     0,     0,     0,
     214,     0,     0,   786,   215,   787,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
     788,   220,     0,     0,   789,   221,     0,   790,   222,     0,
       0,     0,   791,     0,   792,     0,   224,   793,     0,   225,
       0,   226,   794,     0,     0,   795,     0,     0,     0,     0,
     796,   227,   228,   229,   230,   231,   232,   797,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   798,   242,   243,
     244,   799,   245,   246,     0,     0,     0,   247,   248,   800,
     250,     0,     0,   801,   252,   802,   803,   253,     0,   254,
     804,   805,   806,   807,   808,   809,   810,   259,   260,   261,
     262,     0,   811,   263,   264,     0,   265,   266,   267,   812,
     813,   814,   268,     0,   815,   816,     0,   269,   270,     0,
     817,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   818,   819,   278,
     820,   821,   822,   823,   824,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   825,   287,   288,   289,   290,   291,
     292,   293,   826,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,   827,   828,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
     829,   308,   309,   830,   310,   311,   831,   312,   832,   314,
     315,     0,   833,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
     834,   835,   334,   335,     0,   336,   836,   338,   837,   838,
     839,   339,   340,   840,   341,   342,     0,   343,   344,     0,
     655,   345,   841,   842,   843,   844,     0,     0,     0,     0,
       0,   350,     0,   351,   845,   846,   847,   353,   354,   355,
       0,   848,   356,   357,   849,     0,   358,     0,     0,   850,
     851,   359,     0,     0,   360,     0,   361,     0,   852,   363,
       0,     0,   853,   854,   855,   856,   857,   364,     0,     0,
     365,   858,     0,   366,   367,   859,     0,     0,     0,     0,
     369,     0,   370,   371,     0,   860,     0,   861,     0,     0,
       0,     0,   862,     0,     0,     0,   863,   864,     0,     0,
       0,     0,   865,     0,   866,     0,     0,   867,   868,     0,
     869,   870,   122,     0,   726,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   727,     0,   728,
     130,   131,   729,   133,     0,   134,   730,   135,     0,   731,
     136,   732,   733,   734,   137,   735,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,   736,   144,     0,
     145,   737,   738,   147,     0,   148,   149,   150,   739,   151,
       0,   740,   153,     0,   154,   155,   156,   157,   158,   741,
     742,   159,     0,   160,   161,     0,   743,     0,   744,   745,
     746,     0,     0,   163,   747,   748,     0,   749,   750,     0,
     164,   165,   751,   752,   753,     0,     0,     0,     0,   754,
     168,   755,     0,     0,   756,   757,   169,     0,   170,     0,
       0,     0,   758,   759,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
     760,   179,     0,   761,   762,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,   763,     0,   188,   764,
     189,   765,   766,   190,     0,   767,   191,   192,   193,   768,
       0,   194,     0,     0,   769,     0,   195,   196,  2165,   770,
     197,     0,   198,   771,   772,   773,   774,     0,   775,   776,
     200,   777,   778,   779,   202,     0,   203,   780,     0,   781,
     782,     0,   204,   205,     0,   206,   783,     0,   207,     0,
       0,     0,   784,   209,   210,   211,   785,     0,   212,   213,
       0,     0,     0,   214,     0,     0,   786,   215,   787,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,   788,   220,     0,     0,   789,   221,     0,
     790,   222,     0,     0,     0,   791,     0,   792,     0,   224,
     793,     0,   225,     0,   226,   794,     0,     0,   795,     0,
       0,     0,     0,   796,   227,   228,   229,   230,   231,   232,
     797,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     798,   242,   243,   244,   799,   245,   246,     0,     0,     0,
     247,   248,   800,   250,     0,     0,   801,   252,   802,   803,
     253,     0,   254,   804,   805,   806,   807,   808,   809,   810,
     259,   260,   261,   262,     0,   811,   263,   264,     0,   265,
     266,   267,   812,   813,   814,   268,     0,   815,   816,     0,
     269,   270,     0,   817,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     818,   819,   278,   820,   821,   822,   823,   824,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   825,   287,   288,
     289,   290,   291,   292,   293,   826,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,   827,   828,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,   829,   308,   309,   830,   310,   311,   831,
     312,   832,   314,   315,     0,   833,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,   834,   835,   334,   335,     0,   336,   836,
     338,   837,   838,   839,   339,   340,   840,   341,   342,     0,
     343,   344,     0,   655,   345,   841,   842,   843,   844,     0,
       0,     0,     0,     0,   350,     0,   351,   845,   846,   847,
     353,   354,   355,     0,   848,   356,   357,   849,     0,   358,
       0,     0,   850,   851,   359,     0,     0,   360,     0,   361,
       0,   852,   363,     0,     0,   853,   854,   855,   856,   857,
     364,     0,     0,   365,   858,     0,   366,   367,   859,     0,
       0,     0,     0,   369,     0,   370,   371,     0,   860,     0,
     861,     0,     0,     0,     0,   862,     0,     0,     0,   863,
     864,     0,     0,     0,     0,   865,     0,   866,     0,     0,
     867,   868,     0,   869,   870,   122,     0,   726,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     727,     0,   728,   130,   131,   729,   133,     0,   134,   730,
     135,     0,   731,   136,   732,   733,   734,   137,   735,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
     736,   144,     0,   145,   737,   738,   147,     0,   148,   149,
     150,   739,   151,     0,   740,   153,     0,   154,   155,   156,
     157,   158,   741,   742,   159,     0,   160,   161,     0,   743,
       0,   744,   745,   746,     0,     0,   163,   747,   748,     0,
     749,   750,     0,   164,   165,   751,   752,   753,     0,     0,
       0,     0,   754,   168,   755,     0,     0,   756,   757,   169,
       0,   170,     0,     0,     0,   758,   759,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,   760,   179,     0,   761,   762,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,   763,
       0,   188,   764,   189,   765,   766,   190,     0,   767,   191,
     192,   193,   768,     0,   194,     0,     0,   769,     0,   195,
     196,     0,   770,   197,     0,   198,   771,   772,   773,   774,
       0,   775,   776,   200,   777,   778,   779,   202,     0,   203,
     780,     0,   781,   782,     0,   204,   205,     0,   206,   783,
       0,   207,     0,     0,     0,   784,   209,   210,   211,   785,
       0,   212,   213,     0,     0,     0,   214,     0,     0,   786,
     215,   787,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,   788,   220,     0,     0,
     789,   221,     0,   790,   222,     0,     0,     0,   791,     0,
     792,     0,   224,   793,     0,   225,     0,   226,   794,     0,
       0,   795,     0,     0,     0,     0,   796,   227,   228,   229,
     230,   231,   232,   797,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   798,   242,   243,   244,   799,   245,   246,
       0,     0,     0,   247,   248,   800,   250,     0,     0,   801,
     252,   802,   803,   253,     0,   254,   804,   805,   806,   807,
     808,   809,   810,   259,   260,   261,   262,     0,   811,   263,
     264,     0,   265,   266,   267,   812,   813,   814,   268,     0,
     815,   816,     0,   269,   270,     0,   817,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   818,   819,   278,   820,   821,   822,   823,
     824,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     825,   287,   288,   289,   290,   291,   292,   293,   826,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,   827,   828,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,   829,   308,   309,   830,
     310,   311,   831,   312,   832,   314,   315,     0,   833,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,   834,   835,   334,   335,
       0,   336,   836,   338,   837,   838,   839,   339,   340,   840,
     341,   342,     0,   343,   344,     0,   655,   345,   841,   842,
     843,   844,     0,     0,     0,     0,     0,   350,     0,   351,
     845,   846,   847,   353,   354,   355,     0,   848,   356,   357,
     849,     0,   358,     0,     0,   850,   851,   359,     0,     0,
     360,     0,   361,     0,   852,   363,     0,     0,   853,   854,
     855,   856,   857,   364,     0,     0,   365,   858,     0,   366,
     367,   859,     0,     0,     0,     0,   369,     0,   370,   371,
       0,   860,     0,   861,     0,     0,     0,     0,   862,     0,
       0,     0,   863,   864,     0,     0,     0,     0,   865,     0,
     866,     0,     0,   867,   868,     0,   869,   870,   122,     0,
     726,   124,   125,   126,   127,  1756,     0,     0,     0,     0,
    1757,     0,     0,   727,     0,   728,   130,   131,   729,   133,
       0,   134,   730,   135,     0,   731,   136,   732,   733,   734,
     137,   735,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,   736,   144,     0,   145,   737,   738,   147,
       0,   148,   149,   150,   739,   151,     0,   740,   153,     0,
     154,   155,   156,   157,   158,   741,   742,   159,     0,   160,
     161,     0,   743,     0,   744,   745,   746,     0,     0,   163,
     747,   748,     0,   749,   750,     0,   164,   165,   751,   752,
     753,     0,     0,     0,     0,   754,   168,   755,     0,     0,
     756,   757,   169,     0,   170,     0,     0,     0,   758,   759,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,   760,   179,     0,   761,
     762,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,   763,     0,   188,   764,   189,   765,   766,   190,
       0,   767,   191,   192,   193,   768,     0,   194,     0,     0,
     769,     0,   195,   196,     0,   770,   197,     0,   198,   771,
     772,   773,   774,     0,   775,   776,   200,   777,   778,   779,
     202,     0,   203,   780,     0,   781,   782,     0,   204,   205,
       0,   206,   783,     0,   207,     0,     0,     0,   784,   209,
     210,   211,   785,     0,   212,   213,     0,     0,     0,   214,
       0,     0,   786,   215,   787,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,   788,
     220,     0,     0,   789,   221,     0,   790,   222,     0,     0,
       0,   791,     0,   792,     0,   224,   793,     0,   225,     0,
     226,   794,     0,     0,   795,     0,     0,     0,     0,   796,
     227,   228,   229,   230,   231,   232,   797,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   798,   242,   243,   244,
     799,   245,   246,     0,     0,     0,   247,   248,   800,   250,
       0,     0,   801,   252,   802,   803,   253,     0,   254,   804,
     805,   806,   807,   808,   809,   810,   259,   260,   261,   262,
       0,   811,   263,   264,     0,   265,   266,   267,   812,     0,
     814,   268,     0,   815,   816,     0,   269,   270,     0,   817,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   818,   819,   278,   820,
     821,   822,   823,   824,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   825,   287,   288,   289,   290,   291,   292,
     293,   826,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,   827,   828,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,   829,
     308,   309,   830,   310,   311,   831,   312,   832,   314,   315,
       0,   833,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,   834,
     835,   334,   335,     0,   336,   836,   338,   837,   838,   839,
     339,   340,   840,   341,   342,     0,   343,   344,     0,   655,
     345,   841,   842,   843,   844,     0,     0,     0,     0,     0,
     350,     0,   351,   845,   846,   847,   353,   354,   355,     0,
     848,   356,   357,   849,     0,   358,     0,     0,   850,   851,
     359,     0,     0,   360,     0,   361,     0,   852,   363,     0,
       0,   853,   854,   855,   856,   857,   364,     0,     0,   365,
     858,     0,   366,   367,   859,     0,     0,     0,     0,   369,
       0,   370,   371,     0,   860,     0,   861,     0,     0,     0,
       0,   862,     0,     0,     0,   863,   864,     0,     0,     0,
       0,   865,     0,   866,     0,     0,   867,   868,     0,   869,
     870,   122,     0,   726,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   727,     0,   728,   130,
     131,   729,   133,     0,   134,   730,   135,     0,   731,   136,
     732,   733,   734,   137,   735,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,   736,   144,     0,   145,
     737,   738,   147,     0,   148,   149,   150,   739,   151,     0,
     740,   153,     0,   154,   155,   156,   157,   158,   741,   742,
     159,     0,   160,   161,     0,   743,     0,   744,   745,   746,
       0,     0,   163,   747,   748,     0,   749,   750,     0,   164,
     165,   751,   752,   753,     0,     0,     0,     0,   754,   168,
     755,     0,     0,   756,   757,   169,     0,   170,     0,     0,
       0,   758,   759,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,   760,
     179,     0,   761,   762,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,   763,     0,   188,   764,   189,
     765,   766,   190,     0,   767,   191,   192,   193,   768,     0,
     194,     0,     0,   769,     0,   195,   196,     0,   770,   197,
       0,   198,   771,   772,   773,   774,     0,   775,   776,   200,
     777,   778,   779,   202,     0,   203,   780,     0,   781,   782,
       0,   204,   205,     0,   206,   783,     0,   207,     0,     0,
       0,   784,   209,   210,   211,   785,     0,   212,   213,     0,
       0,     0,   214,     0,     0,   786,   215,  2441,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,   788,   220,     0,     0,   789,   221,     0,   790,
     222,     0,     0,     0,   791,     0,   792,     0,   224,   793,
       0,   225,     0,   226,   794,     0,     0,   795,     0,     0,
       0,     0,   796,   227,   228,   229,   230,   231,   232,   797,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   798,
     242,   243,   244,   799,   245,   246,     0,     0,     0,   247,
     248,   800,   250,     0,     0,   801,   252,   802,   803,   253,
       0,   254,   804,   805,   806,   807,   808,   809,   810,   259,
     260,   261,   262,     0,   811,   263,   264,     0,   265,   266,
     267,   812,   813,   814,   268,     0,   815,   816,     0,   269,
     270,     0,   817,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   818,
     819,   278,   820,   821,   822,   823,   824,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   825,   287,   288,   289,
     290,   291,   292,   293,   826,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
     827,   828,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,   829,   308,   309,   830,   310,   311,   831,   312,
     832,   314,   315,     0,   833,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,   834,   835,   334,   335,     0,   336,   836,   338,
     837,   838,   839,   339,   340,   840,   341,   342,     0,   343,
     344,     0,   655,   345,   841,   842,   843,   844,     0,     0,
       0,     0,     0,   350,     0,   351,   845,   846,   847,   353,
     354,   355,     0,   848,   356,   357,   849,     0,   358,     0,
       0,   850,   851,   359,     0,     0,   360,     0,   361,     0,
     852,   363,     0,     0,   853,   854,   855,   856,   857,   364,
       0,     0,   365,   858,     0,   366,   367,   859,     0,     0,
       0,     0,   369,     0,   370,   371,     0,   860,     0,   861,
       0,     0,     0,     0,   862,     0,     0,     0,   863,   864,
       0,     0,     0,     0,   865,     0,   866,     0,     0,   867,
     868,     0,   869,   870,   122,     0,   726,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   727,
       0,   728,   130,   131,   729,   133,     0,   134,   730,   135,
       0,   731,   136,   732,   733,   734,   137,   735,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,   736,
     144,     0,   145,   737,   738,   147,     0,   148,   149,   150,
     739,   151,     0,   740,   153,     0,   154,   155,   156,   157,
     158,   741,   742,   159,     0,   160,   161,     0,   743,     0,
     744,   745,   746,     0,     0,   163,   747,   748,     0,   749,
     750,     0,   164,   165,   751,   752,   753,     0,     0,     0,
       0,   754,   168,   755,     0,     0,   756,   757,   169,     0,
     170,     0,     0,     0,   758,   759,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,   760,   179,     0,   761,   762,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,   763,     0,
     188,   764,   189,   765,   766,   190,     0,   767,   191,   192,
     193,   768,     0,   194,     0,     0,   769,     0,   195,   196,
       0,   770,   197,     0,   198,   771,   772,   773,   774,     0,
     775,   776,   200,   777,   778,   779,   202,     0,   203,   780,
       0,   781,   782,     0,   204,   205,     0,   206,   783,     0,
     207,     0,     0,     0,   784,   209,   210,   211,   785,     0,
     212,   213,     0,     0,     0,   214,     0,     0,   786,   215,
    2514,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,   788,   220,     0,     0,   789,
     221,     0,   790,   222,     0,     0,     0,   791,     0,   792,
       0,   224,   793,     0,   225,     0,   226,   794,     0,     0,
     795,     0,     0,     0,     0,   796,   227,   228,   229,   230,
     231,   232,   797,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   798,   242,   243,   244,   799,   245,   246,     0,
       0,     0,   247,   248,   800,   250,     0,     0,   801,   252,
     802,   803,   253,     0,   254,   804,   805,   806,   807,   808,
     809,   810,   259,   260,   261,   262,     0,   811,   263,   264,
       0,   265,   266,   267,   812,   813,   814,   268,     0,   815,
     816,     0,   269,   270,     0,   817,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   818,   819,   278,   820,   821,   822,   823,   824,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   825,
     287,   288,   289,   290,   291,   292,   293,   826,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,   827,   828,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,   829,   308,   309,   830,   310,
     311,   831,   312,   832,   314,   315,     0,   833,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,   834,   835,   334,   335,     0,
     336,   836,   338,   837,   838,   839,   339,   340,   840,   341,
     342,     0,   343,   344,     0,   655,   345,   841,   842,   843,
     844,     0,     0,     0,     0,     0,   350,     0,   351,   845,
     846,   847,   353,   354,   355,     0,   848,   356,   357,   849,
       0,   358,     0,     0,   850,   851,   359,     0,     0,   360,
       0,   361,     0,   852,   363,     0,     0,   853,   854,   855,
     856,   857,   364,     0,     0,   365,   858,     0,   366,   367,
     859,     0,     0,     0,     0,   369,     0,   370,   371,     0,
     860,     0,   861,     0,     0,     0,     0,   862,     0,     0,
       0,   863,   864,     0,     0,     0,     0,   865,     0,   866,
       0,     0,   867,   868,     0,   869,   870,   122,     0,   726,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   727,     0,   728,   130,   131,   729,   133,     0,
     134,   730,   135,     0,   731,   136,   732,   733,   734,   137,
     735,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,   736,   144,     0,   145,   737,   738,   147,     0,
     148,   149,   150,   739,   151,     0,   740,   153,     0,   154,
     155,   156,   157,   158,   741,   742,   159,     0,   160,   161,
       0,   743,     0,   744,   745,   746,     0,     0,   163,   747,
     748,     0,   749,   750,     0,   164,   165,   751,   752,   753,
       0,     0,     0,     0,   754,   168,   755,     0,     0,   756,
    2863,   169,     0,   170,     0,     0,     0,   758,   759,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,   760,   179,     0,   761,   762,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,   763,     0,   188,   764,   189,   765,   766,   190,     0,
     767,   191,   192,   193,   768,     0,   194,     0,     0,   769,
       0,   195,   196,     0,   770,   197,     0,   198,   771,   772,
     773,   774,     0,   775,   776,   200,   777,   778,   779,   202,
       0,   203,   780,     0,   781,   782,     0,   204,   205,     0,
     206,   783,     0,   207,     0,     0,     0,   784,   209,   210,
     211,   785,     0,   212,   213,     0,     0,     0,   214,     0,
       0,   786,   215,   787,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,   788,   220,
       0,     0,   789,   221,     0,   790,   222,     0,     0,     0,
     791,     0,   792,     0,   224,   793,     0,   225,     0,   226,
     794,     0,     0,   795,     0,     0,     0,     0,   796,   227,
     228,   229,   230,   231,   232,   797,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   798,   242,   243,   244,   799,
     245,   246,     0,     0,     0,   247,   248,   800,   250,     0,
       0,   801,   252,   802,   803,   253,     0,   254,   804,   805,
     806,   807,   808,   809,   810,   259,   260,   261,   262,     0,
     811,   263,   264,     0,   265,   266,   267,   812,   813,   814,
     268,     0,   815,   816,     0,   269,   270,     0,   817,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   818,   819,   278,   820,   821,
     822,   823,   824,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   825,   287,   288,   289,   290,   291,   292,   293,
     826,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,   827,   828,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,   829,   308,
     309,   830,   310,   311,   831,   312,   832,   314,   315,     0,
     833,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,   834,   835,
     334,   335,     0,   336,   836,   338,   837,   838,   839,   339,
     340,   840,   341,   342,     0,   343,   344,     0,   655,   345,
     841,   842,   843,   844,     0,     0,     0,     0,     0,   350,
       0,   351,   845,   846,   847,   353,   354,   355,     0,   848,
     356,   357,   849,     0,   358,     0,     0,   850,   851,   359,
       0,     0,   360,     0,   361,     0,   852,   363,     0,     0,
     853,   854,   855,   856,   857,   364,     0,     0,   365,   858,
       0,   366,   367,   859,     0,     0,     0,     0,   369,     0,
     370,   371,     0,   860,     0,   861,     0,     0,     0,     0,
     862,     0,     0,     0,   863,   864,     0,     0,     0,     0,
     865,     0,   866,     0,     0,   867,   868,     0,   869,   870,
     122,     0,   726,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   727,     0,   728,   130,   131,
     729,   133,     0,   134,   730,   135,     0,   731,   136,   732,
     733,   734,   137,   735,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,   736,   144,     0,   145,   737,
     738,   147,     0,   148,   149,   150,   739,   151,     0,   740,
     153,     0,   154,   155,   156,   157,   158,   741,   742,   159,
       0,   160,   161,     0,   743,     0,   744,   745,   746,     0,
       0,   163,   747,   748,     0,   749,   750,     0,   164,   165,
     751,   752,   753,     0,     0,     0,     0,   754,   168,   755,
       0,     0,   756,   757,   169,     0,   170,     0,     0,     0,
     758,   759,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,   760,   179,
       0,   761,   762,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,   763,     0,   188,   764,   189,   765,
     766,   190,     0,   767,   191,   192,   193,   768,     0,   194,
       0,     0,   769,     0,   195,   196,     0,   770,   197,     0,
     198,   771,   772,   773,   774,     0,   775,   776,   200,   777,
     778,   779,   202,     0,   203,   780,     0,   781,   782,     0,
     204,   205,     0,   206,   783,     0,   207,     0,     0,     0,
     784,   209,   210,   211,   785,     0,   212,   213,     0,     0,
       0,   214,     0,     0,   786,   215,   787,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,   788,   220,     0,     0,   789,   221,     0,   790,   222,
       0,     0,     0,   791,     0,   792,     0,   224,   793,     0,
     225,     0,   226,   794,     0,     0,   795,     0,     0,     0,
       0,   796,   227,   228,   229,   230,   231,   232,   797,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   798,   242,
     243,   244,   799,   245,   246,     0,     0,     0,   247,   248,
     800,   250,     0,     0,   801,   252,   802,   803,   253,     0,
     254,   804,   805,   806,   807,   808,   809,   810,   259,   260,
     261,   262,     0,   811,   263,   264,     0,   265,   266,   267,
     812,     0,   814,   268,     0,   815,   816,     0,   269,   270,
       0,   817,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   818,   819,
     278,   820,   821,   822,   823,   824,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   825,   287,   288,   289,   290,
     291,   292,   293,   826,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,   827,
     828,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,   829,   308,   309,   830,   310,   311,   831,   312,   832,
     314,   315,     0,   833,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,   834,   835,   334,   335,     0,   336,   836,   338,   837,
     838,   839,   339,   340,   840,   341,   342,     0,   343,   344,
       0,   655,   345,   841,   842,   843,   844,     0,     0,     0,
       0,     0,   350,     0,   351,   845,   846,   847,   353,   354,
     355,     0,   848,   356,   357,   849,     0,   358,     0,     0,
     850,   851,   359,     0,     0,   360,     0,   361,     0,   852,
     363,     0,     0,   853,   854,   855,   856,   857,   364,     0,
       0,   365,   858,     0,   366,   367,   859,     0,     0,     0,
       0,   369,     0,   370,   371,     0,   860,     0,   861,     0,
       0,     0,     0,   862,     0,     0,     0,   863,   864,     0,
       0,     0,     0,   865,     0,   866,     0,     0,   867,   868,
       0,   869,   870,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,  1930,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,  1931,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,  1086,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
    1087,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,  2426,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,  1843,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,  1932,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,  1979,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,  1930,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,  1931,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,  1086,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
    1087,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,  1932,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,  1979,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,  1843,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,  2252,
       0,   130,   131,   132,   133,   870,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,     0,     0,     0,     0,     0,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,  3612,
     128,     0,     0,   129,  3613,   870,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,   972,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     408,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,  1801,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     408,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,     0,     0,
       0,     0,     0,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,  1978,     0,   128,     0,     0,   129,     0,
    1979,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,     0,     0,     0,     0,     0,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,  3613,   870,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     408,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   462,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     408,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
     870,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,     0,   372,     0,   122,     0,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
    1979,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   547,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   548,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,  1743,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,   547,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   548,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,  2292,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,   547,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   548,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -185,  2886,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3455,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,     0,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3456,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3457,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3458,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3459,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3460,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -185,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3461,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,   360,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -185,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
       0,     0,  3462,   122,     0,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,  3663,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
       0,   372,   122,     0,   123,   124,   125,   126,   127,     0,
       0,     0,  1586,     0,   128,     0,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,     0,
     372,   122,     0,   123,   124,   125,   126,   127,     0,     0,
       0,  2278,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,     0,   372,
     122,     0,   123,   124,   125,   126,   127,     0,     0,     0,
    2567,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,     0,   372,   122,
       0,   123,   124,   125,   126,   127,     0,     0,     0,  2891,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -185,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3455,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,  -200,     0,   179,     0,
       0,     0,  -200,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3456,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3457,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3458,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3459,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3460,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -185,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3461,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,   360,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -185,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
    -200,   122,  3462,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -185,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3455,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,  -221,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3456,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3457,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3458,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3459,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -185,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3460,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -185,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3461,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,   360,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,  -221,     0,
    -185,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,  -221,   122,  3462,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3455,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,  -218,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3456,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3457,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3458,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3459,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -185,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3460,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -185,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3461,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
    -218,     0,  -185,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,  -218,   122,  3462,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -185,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
    3455,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,  3542,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,  3456,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,  3457,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,  3458,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,  3459,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,  -185,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
    3460,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,  -185,     0,   302,     0,     0,   304,
       0,     0,   306,   307,  3461,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,  -185,     0,   369,     0,   370,     0,
       0,     0,     0,   372,     0,     0,     0,   122,  3462,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
    -185,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,  3455,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
    -223,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,  3456,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,  3457,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,  3458,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,  3459,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,  -185,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,  3460,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,  -185,     0,   302,     0,
       0,   304,     0,     0,   306,   307,  3461,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,   360,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,  -185,     0,   369,     0,
     370,     0,     0,     0,     0,   372,     0,     0,     0,   122,
    3462,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,     0,     0,     0,   130,   131,   132,
       0,     0,  -185,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,     0,
       0,     0,     0,   143,     0,   144,     0,   145,     0,     0,
       0,     0,   148,   149,  3455,     0,   151,     0,   152,   153,
       0,     0,   155,     0,   157,   158,     0,     0,   159,     0,
     160,   161,     0,     0,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,     0,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,     0,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,  3589,   181,   182,   183,     0,     0,   184,     0,
     185,   186,     0,     0,     0,   188,     0,   189,     0,     0,
     190,  3456,     0,   191,   192,   193,     0,     0,     0,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,  3457,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,  3458,     0,     0,     0,     0,     0,     0,
       0,   220,     0,     0,     0,   221,  3459,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,  -185,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,     0,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,  3460,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,     0,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,     0,   301,  -185,     0,
     302,     0,     0,   304,     0,     0,   306,   307,  3461,     0,
       0,     0,   309,     0,   310,   311,     0,   312,   313,   314,
       0,     0,   316,     0,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,     0,   324,     0,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,     0,   333,
       0,     0,     0,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,     0,   353,   354,   355,
       0,     0,   356,   357,     0,     0,     0,     0,     0,     0,
       0,   359,     0,     0,   360,     0,     0,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,  -185,     0,
     369,     0,   370,     0,     0,     0,     0,   372,     0,     0,
       0,   122,  3462,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,   130,
     131,   132,     0,     0,  -185,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,     0,     0,     0,     0,   143,     0,   144,     0,   145,
       0,     0,     0,     0,   148,   149,  3455,     0,   151,     0,
     152,   153,     0,     0,   155,     0,   157,   158,     0,     0,
     159,     0,   160,   161,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,     0,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,  3630,   181,   182,   183,     0,     0,
     184,     0,   185,   186,     0,     0,     0,   188,     0,   189,
       0,     0,   190,  3456,     0,   191,   192,   193,     0,     0,
       0,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,  3457,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,  3458,     0,     0,     0,     0,
       0,     0,     0,   220,     0,     0,     0,   221,  3459,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,  -185,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,     0,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,  3460,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,     0,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,     0,   301,
    -185,     0,   302,     0,     0,   304,     0,     0,   306,   307,
    3461,     0,     0,     0,   309,     0,   310,   311,     0,   312,
     313,   314,     0,     0,   316,     0,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,     0,
     324,     0,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
       0,   333,     0,     0,     0,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,     0,   353,
     354,   355,     0,     0,   356,   357,     0,     0,     0,     0,
       0,     0,     0,   359,     0,     0,   360,     0,     0,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
    -185,     0,   369,     0,   370,     0,     0,     0,     0,   372,
       0,     0,     0,   122,  3462,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,   130,   131,   132,     0,     0,  -185,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,     0,     0,     0,     0,   143,     0,   144,
       0,   145,     0,     0,     0,     0,   148,   149,  3455,     0,
     151,     0,   152,   153,     0,     0,   155,     0,   157,   158,
       0,     0,   159,     0,   160,   161,     0,     0,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,     0,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,  -204,   181,   182,   183,
       0,     0,   184,     0,   185,   186,     0,     0,     0,   188,
       0,   189,     0,     0,   190,  3456,     0,   191,   192,   193,
       0,     0,     0,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,  3457,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,  3458,     0,     0,
       0,     0,     0,     0,     0,   220,     0,     0,     0,   221,
    3459,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,  -185,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,     0,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,  3460,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
       0,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
       0,   301,  -185,     0,   302,     0,     0,   304,     0,     0,
     306,   307,  3461,     0,     0,     0,   309,     0,   310,   311,
       0,   312,   313,   314,     0,     0,   316,     0,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,     0,   324,     0,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,     0,   333,     0,     0,     0,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
       0,   353,   354,   355,     0,     0,   356,   357,     0,     0,
       0,     0,     0,     0,     0,   359,     0,     0,   360,     0,
       0,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,  -185,     0,   369,     0,   370,     0,     0,     0,
       0,   372,     0,     0,     0,   122,  3462,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,   130,   131,   132,     0,     0,  -185,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,     0,     0,     0,     0,   143,
       0,   144,     0,   145,     0,     0,     0,     0,   148,   149,
    3455,     0,   151,     0,   152,   153,     0,     0,   155,     0,
     157,   158,     0,     0,   159,     0,   160,   161,     0,     0,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,     0,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,     0,   181,
     182,   183,     0,     0,   184,     0,   185,   186,     0,     0,
       0,   188,     0,   189,     0,     0,   190,  3456,     0,   191,
     192,   193,     0,     0,     0,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,  3457,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,  3458,
       0,     0,     0,     0,     0,     0,     0,   220,     0,     0,
       0,   221,  3459,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,  -185,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,     0,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
    3460,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,     0,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,     0,   301,  -185,     0,   302,     0,     0,   304,
       0,     0,   306,   307,  3461,     0,     0,     0,   309,     0,
     310,   311,     0,   312,   313,   314,     0,     0,   316,     0,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,     0,   324,     0,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,     0,   333,     0,     0,     0,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,     0,   353,   354,   355,     0,     0,   356,   357,
       0,     0,     0,     0,     0,     0,     0,   359,     0,     0,
     360,     0,     0,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,  -185,     0,   369,     0,   370,     0,
       0,     0,     0,   372,     0,     0,     0,   122,  3462,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,     0,     0,     0,   130,   131,   132,     0,     0,
    -185,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,     0,     0,     0,
       0,   143,     0,   144,     0,   145,     0,     0,     0,     0,
     148,   149,  3455,     0,   151,     0,   152,   153,     0,     0,
     155,     0,   157,   158,     0,     0,   159,     0,   160,   161,
       0,     0,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,     0,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
       0,   181,   182,   183,     0,     0,   184,     0,   185,   186,
       0,     0,     0,   188,     0,   189,     0,     0,   190,  3456,
       0,   191,   192,   193,     0,     0,     0,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,  3457,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,  3458,     0,     0,     0,     0,     0,     0,     0,   220,
       0,     0,     0,   221,  3459,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,  -185,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
       0,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,  3460,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,     0,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,     0,   301,  -185,     0,   302,     0,
       0,   304,     0,     0,   306,   307,  3461,     0,     0,     0,
     309,     0,   310,   311,     0,   312,   313,   314,     0,     0,
     316,     0,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,     0,   324,     0,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,     0,   333,     0,     0,
       0,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,     0,   353,   354,   355,     0,     0,
     356,   357,     0,     0,     0,     0,     0,     0,     0,   359,
       0,     0,  3545,     0,     0,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,  -185,     0,   369,     0,
     370,     0,     0,     0,     0,   372,     0,     0,     0,   122,
    3462,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,     0,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,  1596,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,     0,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,  1597,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,  1598,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,  1599,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,   697,
     698,     0,   268,     0,     0,  1600,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,  3652,  3642,  3653,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,  1601,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,  2284,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,  2285,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,  1917,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,     0,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,   547,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,  1918,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,   548,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
    2294,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,  2295,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,   547,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,   548,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,  2284,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,  2285,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
     547,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,   548,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,   350,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
     701,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,   547,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,     0,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,   548,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,   653,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,   654,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   655,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,  2332,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,   547,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,   548,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,  2284,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,   547,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,   548,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
     192,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,   547,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,   266,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,   548,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,  2274,     0,   129,     0,     0,
     130,   131,   132,   133,     0,   134,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,   141,   142,     0,     0,   143,     0,   144,     0,
     145,   146,     0,   147,     0,   148,   149,   150,     0,   151,
       0,   152,   153,     0,   154,   155,   156,   157,   158,     0,
       0,   159,     0,   160,   161,     0,   162,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,   175,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,   180,   181,   182,   183,     0,
       0,   184,     0,   185,   186,   187,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,   194,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,   204,   205,     0,   206,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,   219,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,   268,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,   274,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,   281,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,   300,
     301,     0,     0,   302,     0,   303,   304,   305,     0,   306,
     307,     0,     0,     0,   308,   309,     0,   310,   311,     0,
     312,   313,   314,   315,     0,   316,   317,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
     323,   324,   325,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,   332,   333,     0,     0,   334,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,   548,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,   352,
     353,   354,   355,     0,     0,   356,   357,     0,     0,   358,
       0,     0,     0,     0,   359,     0,     0,   360,     0,   361,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,   371,     0,     0,   122,
     372,   123,   124,   125,   126,   127,     0,     0,     0,     0,
       0,   128,     0,     0,   129,     0,     0,   130,   131,   132,
     133,     0,   134,     0,   135,     0,     0,   136,     0,     0,
       0,   137,     0,     0,   138,   139,     0,   140,     0,   141,
     142,     0,     0,   143,     0,   144,     0,   145,   146,     0,
     147,     0,   148,   149,   150,     0,   151,     0,   152,   153,
       0,   154,   155,   156,   157,   158,     0,     0,   159,     0,
     160,   161,     0,   162,  3584,     0,     0,     0,     0,     0,
     163,     0,     0,     0,     0,     0,     0,   164,   165,     0,
       0,   166,     0,     0,     0,     0,   167,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   171,     0,   172,   173,   174,     0,     0,     0,   175,
       0,     0,   176,   177,   178,     0,     0,     0,   179,     0,
       0,     0,   180,   181,   182,   183,     0,     0,   184,     0,
     185,   186,   187,     0,  3585,   188,     0,   189,     0,     0,
     190,     0,     0,   191,   192,   193,     0,     0,   194,     0,
       0,     0,     0,   195,   196,     0,     0,   197,     0,   198,
       0,     0,     0,     0,     0,     0,   199,   200,     0,     0,
     201,   202,     0,   203,     0,     0,     0,     0,     0,   204,
     205,     0,   206,     0,     0,   207,     0,     0,     0,   208,
     209,   210,   211,     0,     0,   212,   213,     0,     0,     0,
     214,     0,     0,     0,   215,     0,     0,     0,   216,     0,
       0,   217,   218,     0,     0,     0,     0,     0,     0,   219,
       0,   220,     0,     0,     0,   221,     0,     0,   222,     0,
       0,     0,     0,     0,   223,     0,   224,     0,     0,   225,
       0,   226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   227,   228,   229,   230,   231,   232,     0,   233,   234,
     235,   236,   237,   238,   239,   240,   241,     0,   242,   243,
     244,     0,   245,   246,     0,     0,     0,   247,   248,   249,
     250,     0,     0,   251,   252,     0,     0,   253,     0,   254,
       0,   255,     0,     0,   256,   257,   258,   259,   260,   261,
     262,     0,     0,   263,   264,     0,   265,   266,   267,     0,
       0,     0,   268,     0,     0,     0,     0,   269,   270,     0,
     271,     0,   272,   273,   274,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   275,   276,   277,     0,   278,
       0,   279,     0,   280,     0,     0,   281,   282,     0,   283,
       0,   284,   285,     0,   286,   287,   288,   289,   290,   291,
     292,   293,     0,     0,     0,     0,   294,   295,     0,     0,
     296,   297,   298,     0,   299,     0,   300,   301,     0,     0,
     302,     0,   303,   304,   305,     0,   306,   307,     0,     0,
       0,   308,   309,     0,   310,   311,     0,   312,   313,   314,
     315,     0,   316,   317,     0,     0,     0,   318,   319,   320,
       0,     0,   321,     0,     0,     0,   322,   323,   324,   325,
       0,   326,   327,     0,     0,     0,     0,     0,     0,   328,
     329,     0,   330,     0,     0,   331,     0,     0,   332,   333,
       0,     0,   334,   335,     0,   336,   337,   338,     0,     0,
       0,   339,   340,     0,   341,   342,     0,   343,   344,     0,
       0,   345,   346,   347,   348,   349,     0,     0,     0,     0,
       0,   350,     0,   351,     0,     0,   352,   353,   354,   355,
       0,     0,   356,   357,     0,     0,   358,     0,     0,     0,
       0,   359,     0,     0,   360,     0,   361,     0,   362,   363,
       0,     0,     0,     0,     0,     0,     0,   364,     0,     0,
     365,     0,     0,   366,   367,   368,     0,     0,     0,     0,
     369,     0,   370,   371,     0,     0,   122,   372,   123,   124,
     125,   126,   127,     0,     0,     0,     0,     0,   128,     0,
       0,   129,     0,     0,   130,   131,   132,   133,     0,   134,
       0,   135,     0,     0,   136,     0,     0,     0,   137,     0,
       0,   138,   139,     0,   140,     0,   141,   142,     0,     0,
     143,     0,   144,     0,   145,   146,     0,   147,     0,   148,
     149,   150,     0,   151,     0,   152,   153,     0,   154,   155,
     156,   157,   158,     0,     0,   159,     0,   160,   161,     0,
     162,     0,     0,     0,     0,     0,     0,   163,     0,     0,
       0,     0,     0,     0,   164,   165,     0,     0,   166,     0,
       0,     0,     0,   167,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   171,     0,
     172,   173,   174,     0,     0,     0,   175,     0,     0,   176,
     177,   178,     0,     0,     0,   179,     0,     0,     0,   180,
     181,   182,   183,     0,     0,   184,     0,   185,   186,   187,
       0,     0,   188,     0,   189,     0,     0,   190,     0,     0,
     191,   192,   193,     0,     0,   194,     0,     0,     0,     0,
     195,   196,   720,     0,   197,     0,   198,     0,     0,     0,
       0,     0,     0,   199,   200,     0,     0,   201,   202,     0,
     203,     0,     0,     0,     0,     0,   204,   205,     0,   206,
       0,     0,   207,     0,     0,     0,   208,   209,   210,   211,
       0,     0,   212,   213,     0,     0,     0,   214,     0,     0,
       0,   215,     0,     0,     0,   216,     0,     0,   217,   218,
       0,     0,     0,     0,     0,     0,   219,     0,   220,     0,
       0,     0,   221,     0,     0,   222,     0,     0,     0,     0,
       0,   223,     0,   224,     0,     0,   225,     0,   226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,   228,
     229,   230,   231,   232,     0,   233,   234,   235,   236,   237,
     238,   239,   240,   241,     0,   242,   243,   244,     0,   245,
     246,     0,     0,     0,   247,   248,   249,   250,     0,     0,
     251,   252,     0,     0,   253,     0,   254,     0,   255,     0,
       0,   256,   257,   258,   259,   260,   261,   262,     0,     0,
     263,   264,     0,   265,   266,   267,     0,     0,     0,   268,
       0,     0,     0,     0,   269,   270,     0,   271,     0,   272,
     273,   274,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   275,   276,   277,     0,   278,     0,   279,     0,
     280,     0,     0,   281,   282,     0,   283,     0,   284,   285,
       0,   286,   287,   288,   289,   290,   291,   292,   293,     0,
       0,     0,     0,   294,   295,     0,     0,   296,   297,   298,
       0,   299,     0,   300,   301,     0,     0,   302,     0,   303,
     304,   305,     0,   306,   307,     0,     0,     0,   308,   309,
       0,   310,   311,     0,   312,   313,   314,   315,     0,   316,
     317,     0,     0,     0,   318,   319,   320,     0,     0,   321,
       0,     0,     0,   322,   323,   324,   325,     0,   326,   327,
       0,     0,     0,     0,     0,     0,   328,   329,     0,   330,
       0,     0,   331,     0,     0,   332,   333,     0,     0,   334,
     335,     0,   336,   337,   338,     0,     0,     0,   339,   340,
       0,   341,   342,     0,   343,   344,     0,     0,   345,   346,
     347,   348,   349,     0,     0,     0,     0,     0,   350,     0,
     351,     0,     0,   352,   353,   354,   355,     0,     0,   356,
     357,     0,     0,   358,     0,     0,     0,     0,   359,     0,
       0,   360,     0,   361,     0,   362,   363,     0,     0,     0,
       0,     0,     0,     0,   364,     0,     0,   365,     0,     0,
     366,   367,   368,     0,     0,     0,     0,   369,     0,   370,
     371,     0,     0,   122,   372,   123,   124,   125,   126,   127,
       0,     0,     0,     0,     0,   128,     0,     0,   129,     0,
       0,   130,   131,   132,   133,     0,   134,     0,   135,     0,
       0,   136,     0,     0,     0,   137,     0,     0,   138,   139,
       0,   140,     0,   141,   142,     0,     0,   143,     0,   144,
       0,   145,   146,     0,   147,     0,   148,   149,   150,     0,
     151,     0,   152,   153,     0,   154,   155,   156,   157,   158,
       0,     0,   159,     0,   160,   161,     0,   162,     0,     0,
       0,     0,     0,     0,   163,     0,     0,     0,     0,     0,
       0,   164,   165,     0,     0,   166,     0,     0,     0,     0,
     167,   168,     0,     0,     0,     0,  1082,   169,     0,   170,
       0,     0,     0,     0,     0,   171,     0,   172,   173,   174,
       0,     0,     0,   175,     0,     0,   176,   177,   178,     0,
       0,     0,   179,     0,     0,     0,   180,   181,   182,   183,
       0,     0,   184,     0,   185,   186,   187,     0,     0,   188,
       0,   189,     0,     0,   190,     0,     0,   191,   192,   193,
       0,     0,   194,     0,     0,     0,     0,   195,   196,     0,
       0,   197,     0,   198,     0,     0,     0,     0,     0,     0,
     199,   200,     0,     0,   201,   202,     0,   203,     0,     0,
       0,     0,     0,   204,   205,     0,   206,     0,     0,   207,
       0,     0,     0,   208,   209,   210,   211,     0,     0,   212,
     213,     0,     0,     0,   214,     0,     0,     0,   215,     0,
       0,     0,   216,     0,     0,   217,   218,     0,     0,     0,
       0,     0,     0,   219,     0,   220,     0,     0,     0,   221,
       0,     0,   222,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,   225,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,   228,   229,   230,   231,
     232,     0,   233,   234,   235,   236,   237,   238,   239,   240,
     241,     0,   242,   243,   244,     0,   245,   246,     0,     0,
       0,   247,   248,   249,   250,     0,     0,   251,   252,     0,
       0,   253,     0,   254,     0,   255,     0,     0,   256,   257,
     258,   259,   260,   261,   262,     0,     0,   263,   264,     0,
     265,   266,   267,     0,     0,     0,   268,     0,     0,     0,
       0,   269,   270,     0,   271,     0,   272,   273,   274,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   275,
     276,   277,     0,   278,     0,   279,     0,   280,     0,     0,
     281,   282,     0,   283,     0,   284,   285,     0,   286,   287,
     288,   289,   290,   291,   292,   293,     0,     0,     0,     0,
     294,   295,     0,     0,   296,   297,   298,     0,   299,     0,
     300,   301,     0,     0,   302,     0,   303,   304,   305,     0,
     306,   307,     0,     0,     0,   308,   309,     0,   310,   311,
       0,   312,   313,   314,   315,     0,   316,   317,     0,     0,
       0,   318,   319,   320,     0,     0,   321,     0,     0,     0,
     322,   323,   324,   325,     0,   326,   327,     0,     0,     0,
       0,     0,     0,   328,   329,     0,   330,     0,     0,   331,
       0,     0,   332,   333,     0,     0,   334,   335,     0,   336,
     337,   338,     0,     0,     0,   339,   340,     0,   341,   342,
       0,   343,   344,     0,     0,   345,   346,   347,   348,   349,
       0,     0,     0,     0,     0,   350,     0,   351,     0,     0,
     352,   353,   354,   355,     0,     0,   356,   357,     0,     0,
     358,     0,     0,     0,     0,   359,     0,     0,   360,     0,
     361,     0,   362,   363,     0,     0,     0,     0,     0,     0,
       0,   364,     0,     0,   365,     0,     0,   366,   367,   368,
       0,     0,     0,     0,   369,     0,   370,   371,     0,     0,
     122,   372,   123,   124,   125,   126,   127,     0,     0,     0,
       0,     0,   128,     0,     0,   129,     0,     0,   130,   131,
     132,   133,     0,   134,     0,   135,     0,     0,   136,     0,
       0,     0,   137,     0,     0,   138,   139,     0,   140,     0,
     141,   142,     0,     0,   143,     0,   144,     0,   145,   146,
       0,   147,     0,   148,   149,   150,     0,   151,     0,   152,
     153,     0,   154,   155,   156,   157,   158,     0,     0,   159,
       0,   160,   161,     0,   162,     0,     0,     0,     0,     0,
       0,   163,     0,     0,     0,     0,     0,     0,   164,   165,
       0,     0,   166,     0,     0,     0,     0,   167,   168,     0,
       0,     0,     0,  1868,   169,     0,   170,     0,     0,     0,
       0,     0,   171,     0,   172,   173,   174,     0,     0,     0,
     175,     0,     0,   176,   177,   178,     0,     0,     0,   179,
       0,     0,     0,   180,   181,   182,   183,     0,     0,   184,
       0,   185,   186,   187,     0,     0,   188,     0,   189,     0,
       0,   190,     0,     0,   191,   192,   193,     0,     0,   194,
       0,     0,     0,     0,   195,   196,     0,     0,   197,     0,
     198,     0,     0,     0,     0,     0,     0,   199,   200,     0,
       0,   201,   202,     0,   203,     0,     0,     0,     0,     0,
     204,   205,     0,   206,     0,     0,   207,     0,     0,     0,
     208,   209,   210,   211,     0,     0,   212,   213,     0,     0,
       0,   214,     0,     0,     0,   215,     0,     0,     0,   216,
       0,     0,   217,   218,     0,     0,     0,     0,     0,     0,
     219,     0,   220,     0,     0,     0,   221,     0,     0,   222,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
     225,     0,   226,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,   228,   229,   230,   231,   232,     0,   233,
     234,   235,   236,   237,   238,   239,   240,   241,     0,   242,
     243,   244,     0,   245,   246,     0,     0,     0,   247,   248,
     249,   250,     0,     0,   251,   252,     0,     0,   253,     0,
     254,     0,   255,     0,     0,   256,   257,   258,   259,   260,
     261,   262,     0,     0,   263,   264,     0,   265,   266,   267,
       0,     0,     0,   268,     0,     0,     0,     0,   269,   270,
       0,   271,     0,   272,   273,   274,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   275,   276,   277,     0,
     278,     0,   279,     0,   280,     0,     0,   281,   282,     0,
     283,     0,   284,   285,     0,   286,   287,   288,   289,   290,
     291,   292,   293,     0,     0,     0,     0,   294,   295,     0,
       0,   296,   297,   298,     0,   299,     0,   300,   301,     0,
       0,   302,     0,   303,   304,   305,     0,   306,   307,     0,
       0,     0,   308,   309,     0,   310,   311,     0,   312,   313,
     314,   315,     0,   316,   317,     0,     0,     0,   318,   319,
     320,     0,     0,   321,     0,     0,     0,   322,   323,   324,
     325,     0,   326,   327,     0,     0,     0,     0,     0,     0,
     328,   329,     0,   330,     0,     0,   331,     0,     0,   332,
     333,     0,     0,   334,   335,     0,   336,   337,   338,     0,
       0,     0,   339,   340,     0,   341,   342,     0,   343,   344,
       0,     0,   345,   346,   347,   348,   349,     0,     0,     0,
       0,     0,  1869,     0,   351,     0,     0,   352,   353,   354,
     355,     0,     0,   356,   357,     0,     0,   358,     0,     0,
       0,     0,   359,     0,     0,   360,     0,   361,     0,   362,
     363,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,   365,     0,     0,   366,   367,   368,     0,     0,     0,
       0,   369,     0,   370,   371,     0,     0,   122,   372,   123,
     124,   125,   126,   127,     0,     0,     0,     0,     0,   128,
       0,     0,   129,     0,     0,   130,   131,   132,   133,     0,
     134,     0,   135,     0,     0,   136,     0,     0,     0,   137,
       0,     0,   138,   139,     0,   140,     0,   141,   142,     0,
       0,   143,     0,   144,     0,   145,   146,     0,   147,     0,
     148,   149,   150,     0,   151,     0,   152,   153,     0,   154,
     155,   156,   157,   158,     0,     0,   159,     0,   160,   161,
       0,   162,     0,     0,     0,     0,     0,     0,   163,     0,
       0,     0,     0,     0,     0,   164,   165,     0,     0,   166,
       0,     0,     0,     0,   167,   168,     0,     0,     0,     0,
       0,   169,     0,   170,     0,     0,     0,     0,     0,   171,
       0,   172,   173,   174,     0,     0,     0,   175,     0,     0,
     176,   177,   178,     0,     0,     0,   179,     0,     0,     0,
     180,   181,   182,   183,     0,     0,   184,     0,   185,   186,
     187,     0,     0,   188,     0,   189,     0,     0,   190,     0,
       0,   191,   192,   193,     0,     0,   194,     0,     0,     0,
       0,   195,   196,     0,     0,   197,     0,   198,     0,     0,
       0,     0,     0,     0,   199,   200,     0,     0,   201,   202,
       0,   203,     0,     0,     0,     0,     0,   204,   205,     0,
     206,     0,     0,   207,     0,     0,     0,   208,   209,   210,
     211,     0,     0,   212,   213,     0,     0,     0,   214,     0,
       0,     0,   215,     0,     0,     0,   216,     0,     0,   217,
     218,     0,     0,     0,     0,     0,     0,   219,     0,   220,
       0,     0,     0,   221,     0,     0,   222,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
     228,   229,   230,   231,   232,     0,   233,   234,   235,   236,
     237,   238,   239,   240,   241,     0,   242,   243,   244,     0,
     245,   246,     0,     0,     0,   247,   248,   249,   250,     0,
       0,   251,   252,     0,     0,   253,     0,   254,     0,   255,
       0,     0,   256,   257,   258,   259,   260,   261,   262,     0,
       0,   263,   264,     0,   265,   266,   267,     0,     0,     0,
     268,     0,     0,     0,     0,   269,   270,     0,   271,     0,
     272,   273,   274,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   275,   276,   277,     0,   278,     0,   279,
       0,   280,     0,     0,   281,   282,  1985,   283,     0,   284,
     285,     0,   286,   287,   288,   289,   290,   291,   292,   293,
       0,     0,     0,     0,   294,   295,     0,     0,   296,   297,
     298,     0,   299,     0,   300,   301,     0,     0,   302,     0,
     303,   304,   305,     0,   306,   307,     0,     0,     0,   308,
     309,     0,   310,   311,     0,   312,   313,   314,   315,     0,
     316,   317,     0,     0,     0,   318,   319,   320,     0,     0,
     321,     0,     0,     0,   322,   323,   324,   325,     0,   326,
     327,     0,     0,     0,     0,     0,     0,   328,   329,     0,
     330,     0,     0,   331,     0,     0,   332,   333,     0,     0,
     334,   335,     0,   336,   337,   338,     0,     0,     0,   339,
     340,     0,   341,   342,     0,   343,   344,     0,     0,   345,
     346,   347,   348,   349,     0,     0,     0,     0,     0,   350,
       0,   351,     0,     0,   352,   353,   354,   355,     0,     0,
     356,   357,     0,     0,   358,     0,     0,     0,     0,   359,
       0,     0,   360,     0,   361,     0,   362,   363,     0,     0,
       0,     0,     0,     0,     0,   364,     0,     0,   365,     0,
       0,   366,   367,   368,     0,     0,     0,     0,   369,     0,
     370,   371,     0,     0,   122,   372,   123,   124,   125,   126,
     127,     0,     0,     0,     0,     0,   128,     0,     0,   129,
       0,     0,   130,   131,   132,   133,     0,   134,     0,   135,
       0,     0,   136,     0,     0,     0,   137,     0,     0,   138,
     139,     0,   140,     0,   141,   142,     0,     0,   143,     0,
     144,     0,   145,   146,     0,   147,     0,   148,   149,   150,
       0,   151,     0,   152,   153,     0,   154,   155,   156,   157,
     158,     0,     0,   159,     0,   160,   161,     0,   162,     0,
       0,     0,     0,     0,     0,   163,     0,     0,     0,     0,
       0,     0,   164,   165,     0,     0,   166,     0,     0,     0,
       0,   167,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   171,     0,   172,   173,
     174,     0,     0,     0,   175,     0,     0,   176,   177,   178,
       0,     0,     0,   179,     0,     0,     0,   180,   181,   182,
     183,     0,     0,   184,     0,   185,   186,   187,     0,     0,
     188,     0,   189,     0,     0,   190,     0,     0,   191,   192,
     193,     0,     0,   194,     0,     0,     0,     0,   195,   196,
       0,     0,   197,     0,   198,     0,     0,     0,     0,     0,
       0,   199,   200,     0,     0,   201,   202,     0,   203,     0,
       0,     0,     0,     0,   204,   205,     0,   206,     0,     0,
     207,     0,     0,     0,   208,   209,   210,   211,     0,     0,
     212,   213,     0,     0,     0,   214,     0,     0,     0,   215,
       0,     0,     0,   216,     0,     0,   217,   218,     0,     0,
       0,     0,     0,     0,   219,     0,   220,     0,     0,     0,
     221,     0,     0,   222,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,   225,     0,   226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,   228,   229,   230,
     231,   232,     0,   233,   234,   235,   236,   237,   238,   239,
     240,   241,     0,   242,   243,   244,     0,   245,   246,     0,
       0,     0,   247,   248,   249,   250,     0,     0,   251,   252,
       0,     0,   253,     0,   254,     0,   255,     0,     0,   256,
     257,   258,   259,   260,   261,   262,     0,     0,   263,   264,
       0,   265,   266,   267,     0,     0,     0,   268,     0,     0,
       0,     0,   269,   270,     0,   271,     0,   272,   273,   274,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     275,   276,   277,     0,   278,     0,   279,     0,   280,     0,
       0,   281,   282,     0,   283,     0,   284,   285,     0,   286,
     287,   288,   289,   290,   291,   292,   293,     0,     0,     0,
       0,   294,   295,     0,     0,   296,   297,   298,     0,   299,
       0,   300,   301,     0,     0,   302,     0,   303,   304,   305,
       0,   306,   307,     0,     0,     0,   308,   309,     0,   310,
     311,     0,   312,   313,   314,   315,     0,   316,   317,     0,
       0,     0,   318,   319,   320,     0,     0,   321,     0,     0,
       0,   322,   323,   324,   325,     0,   326,   327,     0,     0,
       0,     0,     0,     0,   328,   329,     0,   330,     0,     0,
     331,     0,     0,   332,   333,     0,     0,   334,   335,     0,
     336,   337,   338,     0,     0,     0,   339,   340,     0,   341,
     342,     0,   343,   344,     0,   548,   345,   346,   347,   348,
     349,     0,     0,     0,     0,     0,   350,     0,   351,     0,
       0,   352,   353,   354,   355,     0,     0,   356,   357,     0,
       0,   358,     0,     0,     0,     0,   359,     0,     0,   360,
       0,   361,     0,   362,   363,     0,     0,     0,     0,     0,
       0,     0,   364,     0,     0,   365,     0,     0,   366,   367,
     368,     0,     0,     0,     0,   369,     0,   370,   371,     0,
       0,   122,   372,   123,   124,   125,   126,   127,     0,     0,
       0,     0,     0,   128,     0,     0,   129,     0,     0,   130,
     131,   132,   133,     0,   134,     0,   135,     0,     0,   136,
       0,     0,     0,   137,     0,     0,   138,   139,     0,   140,
       0,   141,   142,     0,     0,   143,     0,   144,     0,   145,
     146,     0,   147,     0,   148,   149,   150,     0,   151,     0,
     152,   153,     0,   154,   155,   156,   157,   158,     0,     0,
     159,     0,   160,   161,     0,   162,     0,     0,     0,     0,
       0,     0,   163,     0,     0,     0,     0,     0,     0,   164,
     165,     0,     0,   166,     0,     0,     0,     0,   167,   168,
       0,     0,     0,     0,  1868,   169,     0,   170,     0,     0,
       0,     0,     0,   171,     0,   172,   173,   174,     0,     0,
       0,   175,     0,     0,   176,   177,   178,     0,     0,     0,
     179,     0,     0,     0,   180,   181,   182,   183,     0,     0,
     184,     0,   185,   186,   187,     0,     0,   188,     0,   189,
       0,     0,   190,     0,     0,   191,   192,   193,     0,     0,
     194,     0,     0,     0,     0,   195,   196,     0,     0,   197,
       0,   198,     0,     0,     0,     0,     0,     0,   199,   200,
       0,     0,   201,   202,     0,   203,     0,     0,     0,     0,
       0,   204,   205,     0,   206,     0,     0,   207,     0,     0,
       0,   208,   209,   210,   211,     0,     0,   212,   213,     0,
       0,     0,   214,     0,     0,     0,   215,     0,     0,     0,
     216,     0,     0,   217,   218,     0,     0,     0,     0,     0,
       0,   219,     0,   220,     0,     0,     0,   221,     0,     0,
     222,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,   225,     0,   226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   227,   228,   229,   230,   231,   232,     0,
     233,   234,   235,   236,   237,   238,   239,   240,   241,     0,
     242,   243,   244,     0,   245,   246,     0,     0,     0,   247,
     248,   249,   250,     0,     0,   251,   252,     0,     0,   253,
       0,   254,     0,   255,     0,     0,   256,   257,   258,   259,
     260,   261,   262,     0,     0,   263,   264,     0,   265,   266,
     267,     0,     0,     0,   268,     0,     0,     0,     0,   269,
     270,     0,   271,     0,   272,   273,   274,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   275,   276,   277,
       0,   278,     0,   279,     0,   280,     0,     0,   281,   282,
       0,   283,     0,   284,   285,     0,   286,   287,   288,   289,
     290,   291,   292,   293,     0,     0,     0,     0,   294,   295,
       0,     0,   296,   297,   298,     0,   299,     0,   300,   301,
       0,     0,   302,     0,   303,   304,   305,     0,   306,   307,
       0,     0,     0,   308,   309,     0,   310,   311,     0,   312,
     313,   314,   315,     0,   316,   317,     0,     0,     0,   318,
     319,   320,     0,     0,   321,     0,     0,     0,   322,   323,
     324,   325,     0,   326,   327,     0,     0,     0,     0,     0,
       0,   328,   329,     0,   330,     0,     0,   331,     0,     0,
     332,   333,     0,     0,   334,   335,     0,   336,   337,   338,
       0,     0,     0,   339,   340,     0,   341,   342,     0,   343,
     344,     0,     0,   345,   346,   347,   348,   349,     0,     0,
       0,     0,     0,   350,     0,   351,     0,     0,   352,   353,
     354,   355,     0,     0,   356,   357,     0,     0,   358,     0,
       0,     0,     0,   359,     0,     0,   360,     0,   361,     0,
     362,   363,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,   365,     0,     0,   366,   367,   368,     0,     0,
       0,     0,   369,     0,   370,   371,     0,     0,   122,   372,
     123,   124,   125,   126,   127,     0,     0,     0,     0,     0,
     128,     0,     0,   129,     0,     0,   130,   131,   132,   133,
       0,   134,     0,   135,     0,     0,   136,     0,     0,     0,
     137,     0,     0,   138,   139,     0,   140,     0,   141,   142,
       0,     0,   143,     0,   144,     0,   145,   146,     0,   147,
       0,   148,   149,   150,     0,   151,     0,   152,   153,     0,
     154,   155,   156,   157,   158,     0,     0,   159,     0,   160,
     161,     0,   162,     0,     0,     0,     0,     0,     0,   163,
       0,     0,     0,     0,     0,     0,   164,   165,     0,     0,
     166,     0,     0,     0,     0,   167,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     171,     0,   172,   173,   174,     0,     0,     0,   175,     0,
       0,   176,   177,   178,     0,     0,     0,   179,     0,     0,
       0,   180,   181,   182,   183,     0,     0,   184,     0,   185,
     186,   187,     0,     0,   188,     0,   189,     0,     0,   190,
       0,     0,   191,   192,   193,     0,     0,   194,     0,     0,
       0,     0,   195,   196,     0,     0,   197,     0,   198,     0,
       0,     0,     0,     0,     0,   199,   200,     0,     0,   201,
     202,     0,   203,     0,     0,     0,     0,     0,   204,   205,
       0,   206,     0,     0,   207,     0,     0,     0,   208,   209,
     210,   211,     0,     0,   212,   213,     0,     0,     0,   214,
       0,     0,     0,   215,     0,     0,     0,   216,     0,     0,
     217,   218,     0,     0,     0,     0,     0,     0,   219,     0,
     220,     0,     0,     0,   221,     0,     0,   222,     0,     0,
       0,     0,     0,   223,     0,   224,     0,     0,   225,     0,
     226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     227,   228,   229,   230,   231,   232,     0,   233,   234,   235,
     236,   237,   238,   239,   240,   241,     0,   242,   243,   244,
       0,   245,   246,     0,     0,     0,   247,   248,   249,   250,
       0,     0,   251,   252,     0,     0,   253,     0,   254,     0,
     255,     0,     0,   256,   257,   258,   259,   260,   261,   262,
       0,     0,   263,   264,     0,   265,   266,   267,     0,     0,
       0,   268,     0,     0,     0,     0,   269,   270,     0,   271,
       0,   272,   273,   274,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   275,   276,   277,     0,   278,     0,
     279,     0,   280,     0,     0,   281,   282,     0,   283,     0,
     284,   285,     0,   286,   287,   288,   289,   290,   291,   292,
     293,     0,     0,     0,     0,   294,   295,     0,     0,   296,
     297,   298,     0,   299,     0,   300,   301,     0,     0,   302,
       0,   303,   304,   305,     0,   306,   307,     0,     0,     0,
     308,   309,     0,   310,   311,     0,   312,   313,   314,   315,
       0,   316,   317,     0,     0,     0,   318,   319,   320,     0,
       0,   321,     0,     0,     0,   322,   323,   324,   325,     0,
     326,   327,     0,     0,     0,     0,     0,     0,   328,   329,
       0,   330,     0,     0,   331,     0,     0,   332,   333,     0,
       0,   334,   335,     0,   336,   337,   338,     0,     0,     0,
     339,   340,     0,   341,   342,     0,   343,   344,     0,     0,
     345,   346,   347,   348,   349,     0,     0,     0,     0,     0,
     350,     0,   351,     0,     0,   352,   353,   354,   355,     0,
       0,   356,   357,     0,     0,   358,     0,     0,     0,     0,
     359,     0,     0,   360,     0,   361,     0,   362,   363,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,   365,
       0,     0,   366,   367,   368,     0,     0,     0,     0,   369,
       0,   370,   371,     0,     0,   122,   372,   123,   124,   125,
     126,   127,     0,     0,     0,     0,     0,   128,     0,     0,
     129,     0,     0,   130,   131,   132,   133,     0,   134,     0,
     135,     0,     0,   136,     0,     0,     0,   137,     0,     0,
     138,   139,     0,   140,     0,   141,   142,     0,     0,   143,
       0,   144,     0,   145,   146,     0,   147,     0,   148,   149,
     150,     0,   151,     0,   152,   153,     0,   154,   155,   156,
     157,   158,     0,     0,   159,     0,   160,   161,     0,   162,
       0,     0,     0,     0,     0,     0,   163,     0,     0,     0,
       0,     0,     0,   164,   165,     0,     0,   166,     0,     0,
       0,     0,   167,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   171,     0,   172,
     173,   174,     0,     0,     0,   175,     0,     0,   176,   177,
     178,     0,     0,     0,   179,     0,     0,     0,   180,   181,
     182,   183,     0,     0,   184,     0,   185,   186,   187,     0,
       0,   188,     0,   189,     0,     0,   190,     0,     0,   191,
    1381,   193,     0,     0,   194,     0,     0,     0,     0,   195,
     196,     0,     0,   197,     0,   198,     0,     0,     0,     0,
       0,     0,   199,   200,     0,     0,   201,   202,     0,   203,
       0,     0,     0,     0,     0,   204,   205,     0,   206,     0,
       0,   207,     0,     0,     0,   208,   209,   210,   211,     0,
       0,   212,   213,     0,     0,     0,   214,     0,     0,     0,
     215,     0,     0,     0,   216,     0,     0,   217,   218,     0,
       0,     0,     0,     0,     0,   219,     0,   220,     0,     0,
       0,   221,     0,     0,   222,     0,     0,     0,     0,     0,
     223,     0,   224,     0,     0,   225,     0,   226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   227,   228,   229,
     230,   231,   232,     0,   233,   234,   235,   236,   237,   238,
     239,   240,   241,     0,   242,   243,   244,     0,   245,   246,
       0,     0,     0,   247,   248,   249,   250,     0,     0,   251,
     252,     0,     0,   253,     0,   254,     0,   255,     0,     0,
     256,   257,   258,   259,   260,   261,   262,     0,     0,   263,
     264,     0,   265,  1382,   267,     0,     0,     0,   268,     0,
       0,     0,     0,   269,   270,     0,   271,     0,   272,   273,
     274,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   275,   276,   277,     0,   278,     0,   279,     0,   280,
       0,     0,   281,   282,     0,   283,     0,   284,   285,     0,
     286,   287,   288,   289,   290,   291,   292,   293,     0,     0,
       0,     0,   294,   295,     0,     0,   296,   297,   298,     0,
     299,     0,   300,   301,     0,     0,   302,     0,   303,   304,
     305,     0,   306,   307,     0,     0,     0,   308,   309,     0,
     310,   311,     0,   312,   313,   314,   315,     0,   316,   317,
       0,     0,     0,   318,   319,   320,     0,     0,   321,     0,
       0,     0,   322,   323,   324,   325,     0,   326,   327,     0,
       0,     0,     0,     0,     0,   328,   329,     0,   330,     0,
       0,   331,     0,     0,   332,   333,     0,     0,   334,   335,
       0,   336,   337,   338,     0,     0,     0,   339,   340,     0,
     341,   342,     0,   343,   344,     0,     0,   345,   346,   347,
     348,   349,     0,     0,     0,     0,     0,   350,     0,   351,
       0,     0,   352,   353,   354,   355,     0,     0,   356,   357,
       0,     0,   358,     0,     0,     0,     0,   359,     0,     0,
     360,     0,   361,     0,   362,   363,     0,     0,     0,     0,
       0,     0,     0,   364,     0,     0,   365,     0,     0,   366,
     367,   368,     0,     0,     0,     0,   369,     0,   370,   371,
       0,     0,   122,   372,   123,   124,   125,   126,   127,     0,
       0,     0,     0,     0,   128,     0,     0,     0,     0,     0,
     130,   131,   132,     0,     0,     0,     0,   135,     0,     0,
     136,     0,     0,     0,   137,     0,     0,   138,   139,     0,
     140,     0,     0,     0,     0,     0,   143,     0,   144,     0,
     145,     0,     0,     0,     0,   148,   149,     0,     0,   151,
       0,   152,   153,     0,     0,   155,     0,   157,   158,     0,
       0,   159,     0,   160,   161,     0,     0,     0,     0,     0,
       0,     0,     0,   163,     0,     0,     0,     0,     0,     0,
     164,   165,     0,     0,   166,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   171,     0,   172,   173,   174,     0,
       0,     0,     0,     0,     0,   176,   177,   178,     0,     0,
       0,   179,     0,     0,     0,     0,   181,   182,   183,     0,
       0,   184,     0,   185,   186,     0,     0,     0,   188,     0,
     189,     0,     0,   190,     0,     0,   191,   192,   193,     0,
       0,     0,     0,     0,     0,     0,   195,   196,     0,     0,
     197,     0,   198,     0,     0,     0,     0,     0,     0,   199,
     200,     0,     0,   201,   202,     0,   203,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,   207,     0,
       0,     0,   208,   209,   210,   211,     0,     0,   212,   213,
       0,     0,     0,   214,     0,     0,     0,   215,     0,     0,
       0,   216,     0,     0,   217,   218,     0,     0,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,   221,     0,
       0,   222,     0,     0,     0,     0,     0,   223,     0,   224,
       0,     0,   225,     0,   226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,   228,   229,   230,   231,   232,
       0,   233,   234,   235,   236,   237,   238,   239,   240,   241,
       0,   242,   243,   244,     0,   245,   246,     0,     0,     0,
     247,   248,   249,   250,     0,     0,   251,   252,     0,     0,
     253,     0,   254,     0,   255,     0,     0,   256,   257,   258,
     259,   260,   261,   262,     0,     0,   263,   264,     0,   265,
     266,   267,     0,     0,     0,     0,     0,     0,     0,     0,
     269,   270,     0,   271,     0,   272,   273,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   275,   276,
     277,     0,   278,     0,   279,     0,   280,     0,     0,     0,
     282,     0,   283,     0,   284,   285,     0,   286,   287,   288,
     289,   290,   291,   292,   293,     0,     0,     0,     0,   294,
     295,     0,     0,   296,   297,   298,     0,   299,     0,     0,
     301,     0,     0,   302,     0,     0,   304,     0,     0,   306,
     307,     0,     0,     0,     0,   309,     0,   310,   311,     0,
     312,   313,   314,     0,     0,   316,     0,     0,     0,     0,
     318,   319,   320,     0,     0,   321,     0,     0,     0,   322,
       0,   324,     0,     0,   326,   327,     0,     0,     0,     0,
       0,     0,   328,   329,     0,   330,     0,     0,   331,     0,
       0,     0,   333,     0,     0,     0,   335,     0,   336,   337,
     338,     0,     0,     0,   339,   340,     0,   341,   342,     0,
     343,   344,     0,     0,   345,   346,   347,   348,   349,     0,
       0,     0,     0,     0,   350,     0,   351,     0,     0,     0,
     353,   354,   355,     0,     0,   356,   357,     0,     0,     0,
       0,     0,     0,     0,   359,     0,     0,   360,     0,     0,
       0,   362,   363,     0,     0,     0,     0,     0,     0,     0,
     364,     0,     0,   365,     0,     0,   366,   367,   368,     0,
       0,     0,     0,   369,     0,   370,     0,     0,     0,     0,
     372
};

static const short int yycheck[] =
{
       7,   457,   437,   487,   753,   708,   709,   710,   958,   588,
    1279,   668,    19,  1153,   613,    22,   747,   748,   749,   449,
     450,   451,    29,   453,  1011,   455,   634,   512,   611,  1189,
    1921,  1737,    39,   731,  1279,   634,   412,  1155,  1156,  1157,
    1061,   813,    49,    22,  1819,  1899,   564,   483,   484,  1878,
    1168,  1497,   635,  1907,  2309,  1909,  1871,  1872,  1873,  2026,
    1300,  1187,  2044,  1847,  1510,  1181,  1361,  1307,  1296,  2051,
    2259,  1075,  1160,  1161,  1582,  1163,  2668,   513,  2645,  1026,
      87,  1243,  1463,   814,  2653,   570,    18,  1862,  1906,   444,
    1037,  1038,   841,  1885,  1886,   844,    32,  1318,  1319,     3,
     107,   108,     3,   110,  1222,  1221,     3,  1225,    87,   840,
    1198,  1940,   672,     3,   121,     3,  1936,     3,   496,     3,
       3,    16,   853,   854,   855,  1213,   108,    18,   110,    55,
      18,  1960,  1961,    48,    16,  1253,  1254,    10,    27,    16,
    1258,  1417,   121,  1231,  1232,  1233,   582,  1585,  1310,   672,
    1312,     3,  2698,    28,  1242,  2701,    18,    11,    34,  1477,
    1278,    92,  1280,  2923,    16,   863,   864,   865,  2023,  1930,
    1587,   171,    20,    37,  2720,  1936,   127,    58,  1939,    58,
    2726,  1942,   112,    20,    32,   883,    54,    55,    91,    59,
      68,   676,  1953,  1954,    53,    32,    32,    45,  1148,    20,
      34,  1962,    60,   165,   144,   155,    54,    55,    45,  2930,
     142,  1931,  1932,  2759,   153,    20,    57,    54,    55,    55,
     575,   132,   108,   636,   225,   108,    86,    32,  1905,   128,
     334,  1079,   112,    54,    55,  2019,   612,    91,   668,   171,
      45,    76,   171,   679,    51,    57,   340,   171,   210,    54,
      55,   142,   187,   318,   142,    65,   294,   230,    94,    57,
     246,    97,    49,   217,   210,    93,   108,    57,   257,   105,
      57,   225,   175,   283,   420,     8,    66,   247,   389,    67,
     142,    62,   109,   201,   403,  3464,   353,   397,    78,   219,
      12,    79,    12,    62,   153,    48,    12,   156,   153,  1487,
     247,   109,   168,    94,   123,  2872,    97,   455,   389,   168,
     135,  1499,  1500,   433,  1502,  1503,  1504,   252,   252,  1507,
     145,   175,  3082,   199,  1512,  3377,   210,   337,  1516,  1517,
    1518,   388,   503,  1521,  1522,  1523,  1524,  1525,   328,  1527,
    1528,  1529,   485,   247,   494,   110,   247,   228,   453,   228,
     247,   126,   213,   153,   166,   454,   210,   247,   281,   458,
    1498,   217,    43,  1501,  2252,   199,    20,   517,   166,   225,
     475,   232,  1510,   264,    28,   345,   166,  2246,   526,    33,
     330,  1519,   493,  1891,   174,   213,    23,   225,   263,   509,
     561,   398,  1049,   877,   451,   329,   350,   224,   345,   389,
     122,   408,   122,   338,    11,   412,   122,  1547,  2954,   476,
     417,   476,  1552,   494,   560,   422,   224,  2963,  1558,   562,
    1858,  1561,    48,   213,   544,   142,    63,   160,   225,   402,
      67,    91,  1015,   372,   293,   500,   474,   444,   417,    63,
    1023,   560,   232,   324,   345,  2353,   314,   235,   345,   395,
     349,  3020,   562,   142,   461,  1204,  1039,  1040,   562,  2328,
     890,   499,  1061,   366,   471,   252,   455,  3646,   475,   420,
    2361,   108,   908,   567,   481,  1593,   483,   484,  2293,   168,
     998,   488,   489,   319,   200,   353,   401,   306,   330,   380,
     425,   498,   471,   366,   350,   502,  3548,   536,  2316,   264,
     507,   508,   109,   510,   511,   512,   513,  3074,  1068,  2324,
    1457,   395,   366,   372,   174,   196,   304,   372,   343,   394,
    2028,   328,   380,  1272,   388,   961,   508,  1531,   510,   511,
    2350,  1016,  1978,   503,   535,   971,   371,   455,   402,   546,
     328,   491,  3111,   384,  2364,  1068,  1394,   533,   408,   550,
     560,  3272,   364,   213,   516,   562,  1674,   507,   368,   423,
    1678,   561,  1080,   570,   571,   435,   364,  1127,   575,   472,
    3330,   452,   372,  2019,   364,   582,   515,   450,  1847,  2434,
    1898,   511,   463,   562,   463,   517,   962,  2025,  1864,  2350,
     530,   379,   571,  1711,   949,   232,   485,   433,   529,   525,
     476,  1763,  1847,  2364,  1127,   612,  1768,  1769,   485,   560,
    2027,  1309,  1738,   564,  1774,   488,  1776,   972,   472,  1049,
     498,  2876,  1035,   485,   560,  1003,   529,  1325,  2348,   533,
     562,   511,   533,   562,  1760,   546,   533,  1072,   562,  1908,
    2317,  2318,   476,   533,   472,   481,   537,   562,   401,   439,
     475,   426,  1740,  1351,   502,   550,   529,   538,  2847,   534,
     470,   668,   450,  1908,   568,   502,   567,   568,   550,   676,
     567,   568,   679,   509,   455,   682,   683,  3246,   568,   489,
     568,   502,   568,   535,   568,   568,   455,   478,   325,   326,
     481,   528,   504,   330,  1963,   561,   105,   502,   566,   560,
     337,  2589,   328,   562,   683,   561,   504,   562,   104,   104,
     427,   718,  3304,   720,   504,   515,   568,  3309,  1963,   524,
     525,    91,   346,   560,   562,   213,  1081,   364,   444,   445,
     446,   447,   448,   449,   415,   554,   555,   556,   427,   718,
     347,   720,    28,  3312,   460,    53,     4,  3293,  1178,  3295,
    2658,     9,    10,   550,  1130,   210,   420,  2265,  2266,  1947,
    3015,   416,   562,    63,    66,   171,   162,   162,  2583,    27,
    1958,   225,  1912,  2945,    32,   401,  2948,    38,    36,   439,
      32,  2635,   102,    69,   420,  2639,   264,   424,   420,   104,
      74,   317,   246,   104,    12,    70,    71,   108,   261,   104,
     426,  1941,  2586,  1943,   199,   175,  2621,   476,  1948,   264,
     187,   337,   472,   473,   223,   175,   222,  2635,  3364,  1303,
    3366,  2639,  2597,   476,  1964,   171,  1966,  1967,  1968,  3398,
    3458,  3459,  1262,   108,    12,  2655,  1266,  2058,  2059,   344,
     555,   342,   347,   213,   504,   153,   146,   162,   156,   420,
     170,   162,   138,   175,   514,   130,   160,   162,   116,   120,
     168,   868,   104,   870,   166,   261,   261,   504,   331,  1452,
     173,  3438,  1357,  1456,  1482,   252,  1459,  1460,  2580,  1397,
     230,   420,  3474,  1482,   199,   205,   161,   171,   199,  1407,
     470,   354,   472,   243,  2655,   902,   560,   566,  1885,  1886,
     564,   908,   380,   560,   122,   336,   435,    19,  2927,   562,
     567,   213,   155,  1431,  1399,  1400,   535,   372,  1294,  3547,
     162,  2448,   353,   902,   560,  2452,   476,  2308,   560,  2437,
     232,   385,  1368,   237,   514,   331,   331,   652,   945,   345,
     947,   420,   949,   562,   122,  1892,   261,  2109,  2650,  2916,
     261,  2230,  2231,  2232,   961,   962,   261,   199,    12,  2751,
    1910,  2049,    85,  2747,   971,   972,  2054,  2949,    12,  2197,
    1488,  2211,   381,  1977,  1350,   982,  3148,   323,  2247,   299,
     264,  2069,  2261,  2262,  2263,   293,  1362,   307,  2076,   560,
     472,   517,   362,  1428,  2110,   318,   366,  1004,  1005,  1006,
    1007,   113,  2247,  2091,  2092,  3194,   366,  1014,   420,  1016,
    2098,   318,   562,  3605,    34,  1022,   331,   318,  2106,   261,
     331,   560,  1004,  1005,   328,  1032,   331,  1006,  1007,   281,
    1548,  1549,  1014,  1551,   497,  1553,  1554,  1555,  1556,  1557,
    1022,  1559,  1560,    34,   366,   476,   346,   442,   425,   352,
     370,     0,   461,  1032,    67,   110,   406,  2145,   373,   537,
      85,   376,   364,     3,   372,   281,    79,    85,   122,  1767,
     168,  1078,  2367,   362,  1081,   517,   362,    97,   122,  2205,
    2030,   560,   325,   326,   104,  2900,  2212,   330,  2929,   331,
    2908,  2909,   215,  3112,  3113,   549,   382,   171,   418,  1078,
      85,   497,   497,   473,   517,   118,    97,   230,   383,   142,
     522,   523,   472,   104,   269,   270,   225,  3084,   488,   561,
     243,   407,  3294,  1130,  3296,  1132,  1133,  1134,  3383,  1136,
    2971,   434,    85,   420,  2222,   155,  2644,   246,  1145,   426,
    1147,   171,   162,   455,   514,   200,   404,     8,   560,   562,
     472,  1133,  1134,   476,  2681,   371,   283,  1136,   256,   529,
    1956,   419,    75,  3145,   155,   109,    27,   425,   454,   476,
     380,   162,  3427,   247,  1181,   476,    89,   500,  1974,   199,
     472,   493,   497,   393,   410,   117,   497,   445,  2715,  2716,
     215,   435,   497,   500,   317,   225,  2723,   215,   567,   500,
    2646,  2647,  2648,  2730,   470,   230,   472,   532,   199,   264,
     337,   531,   230,   423,  1221,   485,   325,   326,   243,   435,
     213,   546,   235,   543,    16,   243,  1656,   209,   142,  2675,
     215,   386,   387,  3017,   188,   522,   523,   560,   472,   232,
    3500,   261,   560,   487,  3098,   230,   160,   473,   491,   567,
     397,   532,   399,   560,   401,   497,   403,   213,   243,   560,
     532,  1376,   215,  1378,   507,   546,   180,   473,   525,   201,
     261,   528,  1279,   560,   546,   209,   385,   230,  3538,   340,
     194,  2687,   171,   406,  2690,  2691,   222,  1294,   514,   535,
     243,   304,   317,  1723,  1409,  1410,  1411,   264,   318,   317,
    3346,  2707,  3348,   529,   567,  2465,  2466,   327,   325,   326,
     330,   331,   325,   326,  2593,   328,   561,  2557,  3578,   337,
     142,  2590,   450,   237,   238,   257,   395,   318,   560,   438,
     284,   285,   317,  3593,   288,   289,    11,   460,   934,   330,
     331,   937,  3602,  1350,   940,  2590,   149,  1865,  1355,   281,
    1357,   265,   337,    54,    55,  1362,  1320,  1321,  1322,  1323,
    1324,  1368,    63,  1370,   317,   337,   379,   514,  1375,  1376,
     365,  1378,   450,   451,  2643,   453,  3636,   455,  3638,   439,
     440,   406,   442,  1390,   337,   517,  1393,   410,   406,   429,
     430,   470,  1399,  1400,  1401,  1402,  1375,  1376,  2643,  1378,
    2669,   562,  1409,  1410,  1411,   210,   552,   553,   337,   323,
      46,  1390,   561,   562,  1393,   342,   561,   562,   561,   562,
    1427,   406,  1401,  1402,  2669,   171,  1944,  1945,  2200,  1436,
    1409,  1410,  1411,   365,   257,   460,    46,   450,   562,   371,
     549,   550,   460,   561,   562,   416,  1453,  1965,   554,   363,
     337,  1458,   503,   406,   561,   562,   476,   257,   478,   561,
     562,   481,  2550,  1470,   147,  2486,   426,   399,   560,  1476,
     247,   491,   493,  3248,   168,   460,  3432,   497,   455,  1458,
     500,   561,   562,    15,    16,   476,   455,   478,   561,   562,
     481,   561,   562,   561,   562,   281,  1872,  1476,  1874,  1875,
     491,    54,    55,   435,   142,   143,   497,   460,   455,   500,
    2208,  1946,   561,   562,   561,   562,   561,   562,  2221,    23,
      24,  1316,  1317,   455,   561,   562,   561,   562,  1535,   561,
     562,   257,   552,   553,   561,   562,   139,  1544,   470,   470,
     472,    77,   180,   562,  1920,  1921,   561,   562,  3504,   339,
      54,    55,    56,   561,   562,   561,   194,   561,   562,    63,
     468,   552,   553,    67,  3520,  1572,  3522,  2943,  2944,   561,
     562,   419,    76,  1580,   561,   562,  1583,   561,   562,  3394,
    1956,  3410,   561,   562,   529,  2961,    51,  3478,   226,    93,
    1572,  2967,   389,  2753,  3300,   561,   562,   149,  1974,   560,
     238,  1580,  2871,   566,   108,  3561,   207,   111,  3564,     3,
     561,   562,     6,   529,  2990,   567,  3572,  2993,   560,    13,
     561,   562,   561,   562,   561,   562,  2871,   265,   566,    23,
      24,   557,  2062,   561,   562,   560,   140,   561,   562,   562,
    2070,   561,   562,  3599,   561,   562,   561,   562,   476,   561,
     562,   561,   562,   562,  3610,   561,   562,   560,    52,   561,
     562,   560,    56,   560,  2824,   561,   562,  3623,  2044,   561,
     562,   561,   562,    67,   560,  2051,   561,   562,   561,   562,
    2259,   560,    76,   321,   561,   562,   560,    81,   561,   562,
     561,   562,  2300,   560,  3650,  3651,   561,   562,  3654,    93,
     560,  2300,  1318,  1319,  2647,  2648,  1263,  1264,   560,   213,
    3118,  3119,  2599,  2600,   108,   560,   220,   111,  2569,  2570,
    2861,  2862,   560,   560,  2307,   560,   120,   121,   560,   560,
     560,   560,   126,   560,   560,   560,   560,   551,    46,  1746,
     134,   560,   560,   560,   560,   560,   140,   560,   560,   560,
     560,   560,   560,   560,   560,   281,  2274,   535,   560,  2244,
     470,   560,   560,   567,  2751,  2853,   560,   560,   252,   560,
     281,   165,   560,   560,   540,   560,   560,   560,   560,   560,
     560,   560,   286,   485,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,    12,    13,   300,   560,   560,   560,
     560,   560,   560,   560,   560,  2290,   560,   560,   560,   560,
      23,    24,   560,   560,   225,   560,  2192,   211,   560,   213,
     267,   268,   269,   270,   271,   272,   220,   560,   275,   276,
     277,   278,   279,   280,   562,   282,   560,   560,   560,   560,
    1847,    54,    55,    56,  2362,   560,   560,   351,   560,   353,
      63,  2369,   560,   560,    67,   560,   560,   560,  1865,  1866,
     560,   560,   560,    76,   560,  1872,    84,  1874,  1875,   560,
     374,   375,   560,   377,   560,   560,   560,   485,   560,   560,
      93,   560,   560,   560,   560,   476,   560,   560,   560,   560,
     560,   560,   286,   560,   112,   108,   562,   562,   111,   560,
     562,  1908,   562,   562,   562,   562,   300,   562,   126,   413,
     554,   305,   168,  1920,  1921,  2613,    12,    13,   510,   562,
     437,   355,   561,  1930,   512,   560,   142,   140,   562,  1936,
     148,   142,  1939,   142,   142,  1942,   142,   142,   142,   386,
     387,   159,   142,   142,   142,   142,  1953,  1954,   142,  1956,
     142,   345,   142,  2903,   142,  1962,  1963,   351,   562,   353,
      44,   561,  2398,   175,   337,  1972,    63,  1974,   171,    12,
     188,  1978,  1979,   476,   561,   561,   122,     3,     9,   561,
     374,   375,   561,   377,   532,  2361,   561,   567,    84,   560,
     494,   246,    18,  1972,   553,   213,   562,   391,   380,   503,
     213,   219,   533,   188,   214,   567,   171,   220,   435,   426,
     561,  2018,  2019,   562,   168,   562,   112,    44,   450,   413,
     450,   450,   450,   419,   450,    66,   485,   119,   471,   231,
     126,   471,   119,   246,    44,  2738,   231,  2044,   256,  2018,
     562,   517,   567,   562,  2051,   561,   561,    18,   562,   561,
     171,   561,   148,   561,   561,   561,   561,  2064,   562,    85,
     561,   554,   562,   159,   562,   562,   561,   561,   567,   565,
     562,   562,   561,   286,   561,   427,   562,   562,   561,   560,
     562,  3326,   561,   550,   562,   562,   561,   300,   562,   562,
     562,  3209,   188,  3233,  3234,  3235,  3236,   561,   560,   562,
     494,   562,   562,  2110,   561,   560,   562,   561,   561,   503,
     562,   562,   562,   562,   562,   561,   142,   213,   562,   561,
     561,   256,   561,   219,   561,   485,   562,   562,   561,   567,
     561,   485,   485,   476,   252,  3223,   561,   561,   351,   165,
     353,   561,   168,   561,   567,   561,   561,   561,   561,   367,
     562,   485,   562,   562,  2857,   562,   561,   561,   561,   561,
     256,   374,   375,   562,   377,   191,   384,   562,   562,   561,
     561,   197,   390,   562,   568,   562,   562,   561,   396,   562,
     561,   561,   561,   561,   210,  2192,   560,   562,   537,   215,
     561,   560,  3437,   342,   171,   171,   222,   171,   222,   171,
     413,   567,   420,   567,   230,   227,   535,   562,   348,   230,
     230,   296,    93,   431,   432,    93,  2223,   243,   232,   232,
    2227,   247,  2229,  2230,  2231,  2232,  2602,   560,   567,   560,
     256,   476,   560,  2240,   345,   554,   561,  2244,   561,   221,
    2247,   331,  2618,     3,   561,   331,   561,   561,   171,   467,
     171,   171,   331,   547,  2261,  2262,  2263,   561,    18,   138,
     561,  2240,   567,   561,   567,   567,   561,  2274,  2847,   561,
     554,   367,   560,  2280,   337,  2282,   210,   562,   561,   171,
     567,   494,   511,  2290,   225,   244,    63,   230,   384,   269,
     503,   317,   230,   511,   390,   513,   562,   337,   562,   232,
     396,   232,    18,   337,    18,    18,   223,   561,   560,   560,
     247,   337,   561,   561,   561,   223,   560,   567,   561,   345,
     561,   561,    13,   561,   420,    85,   561,  3596,   561,   129,
     562,   561,   241,   561,   561,   431,   432,   561,   561,   561,
     366,   562,   561,  2350,   561,   420,   561,   560,   562,   191,
     428,  3596,   142,   348,  2361,   562,   230,  2364,   230,   108,
     561,   108,   361,   331,  3633,   561,  3115,  3116,  3117,   562,
     561,   467,  3617,   562,   561,   561,  3033,   561,   561,   561,
     406,   561,   142,   561,  2902,   561,   561,   561,  3633,   561,
     561,  2398,  3532,    84,   561,   561,   331,   561,  2405,   561,
     426,  2408,   561,   561,   561,  2412,  2413,   562,   168,  2416,
     561,   561,   331,   561,   561,   511,   561,   513,   562,  2426,
     562,   112,   560,   562,   561,   561,   567,  3158,   561,  2408,
     561,   191,   562,   561,   460,   126,   561,   197,   547,   561,
      98,    99,   100,   101,   102,   561,   561,  2426,   562,   562,
     560,    40,  2970,   561,   561,   215,   562,   148,   560,   560,
     560,   560,   222,   567,   422,   560,   560,   560,   159,   371,
     230,   331,   561,   561,   535,  3178,  3179,   503,   561,   561,
     561,   561,  3139,   243,   561,   561,   222,   247,   561,    44,
     516,   517,   562,   567,   197,  3152,   256,   188,   562,   303,
     380,   476,   230,   476,   560,   517,   517,   533,   560,   535,
    2886,  2946,   170,   560,   331,   331,   560,    32,   560,   528,
     528,   331,   213,   511,   108,   232,   232,   330,   219,   331,
     331,   535,   331,   331,   331,   561,   562,   562,   561,   496,
     303,  3059,   568,   560,   202,   203,   204,   205,   151,   476,
     476,   476,   232,    65,   561,   561,   561,   317,   561,   561,
    3291,   562,   562,   561,   561,   256,   562,   561,   561,   561,
     561,   561,   561,  2949,   561,   561,   561,   337,   561,    16,
     561,   517,   560,  2590,  2591,   345,  2593,   517,   327,   168,
     331,   561,   561,  2969,   561,  2602,   561,   561,   561,   523,
     561,  2608,  3305,  3033,   331,   561,   366,   562,   562,   561,
     342,  2618,   511,   472,   249,  3194,   270,    57,   560,  2626,
     560,   342,    57,   366,    44,    44,   135,    44,   142,   561,
     384,     5,   561,   561,   342,   131,  2643,   295,   342,   297,
     298,   299,   403,   561,    44,   561,   406,   561,  2655,   307,
     562,   561,    44,    44,   118,  2662,   562,   414,   561,    16,
     565,   532,  2669,   560,   274,   569,   426,  3185,  2675,   171,
     532,   561,   142,   222,   568,   138,   367,   561,   209,   562,
     547,   532,   138,   106,   569,   263,   568,   125,   210,   331,
     548,   568,   560,   384,   138,   547,   562,   195,   562,   390,
     460,   249,   138,   568,   426,   396,   168,   548,  3365,  3139,
     168,  3087,   370,   168,   547,   394,   534,   523,   108,   169,
    1562,  1793,  3152,   674,     7,  3526,  3189,  3308,  3182,   420,
    3627,  3663,  3635,  3558,  3517,  3558,    19,  3524,  3016,    22,
     431,   432,  2749,   503,  3401,  3402,    29,  3404,  1068,   392,
    1127,  2745,  3110,  2675,  2019,  1934,    39,   517,  1497,   417,
     418,  1981,  2662,  2731,  3137,  2698,    49,  1531,  2932,  3145,
    1535,  2698,  2978,   533,  2969,   535,   467,  3353,  2663,  2618,
    3362,  3129,  3277,  1140,  3196,  3152,  1977,  3444,  1046,  3446,
    3447,  1123,  1842,  2240,  1401,   683,  1824,  1465,   667,  1856,
     456,   561,   562,  3243,    87,  3508,   600,  1416,   568,    31,
      32,  2856,  3059,  1315,  2857,    37,  2052,    39,    40,    41,
     511,  1218,   513,  1313,   107,   108,  3264,   110,  1168,  2633,
    2213,  3108,  3552,    55,  3087,  1861,  2669,   949,   121,  1820,
     972,  2848,  2871,  1846,  2585,  3301,  2584,  2643,  3617,  3552,
    3437,   446,  1145,   503,   437,  3507,  2575,   720,  1367,  3339,
     977,  3527,  3408,  3633,  2871,  2971,  2590,   990,  1422,  2292,
    2626,  2897,    94,   531,  3095,    97,   429,   980,   583,  2886,
    1393,    23,    24,   105,   542,   543,  3231,   942,  2227,   430,
    1132,  3237,   587,  3377,  3055,   716,  1289,   473,  2017,  2742,
    3013,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    54,    55,    56,    -1,    -1,    -1,    -1,   141,
    2927,    63,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,  3365,    -1,    -1,    -1,   161,
      -1,   163,  2949,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,  2969,    -1,    -1,    -1,   108,    -1,    -1,   111,
      -1,  3401,  3402,    -1,  3404,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2994,    -1,  2996,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   140,  3006,
      -1,   223,    -1,    -1,  3439,  3012,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3444,    -1,  3446,  3447,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3006,   250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   259,   260,    -1,
     262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3059,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3548,    -1,    -1,    -1,   290,   291,
     292,   213,    -1,    -1,    -1,    -1,    -1,    -1,   220,    -1,
    3087,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   310,   311,
     312,    -1,    -1,    -1,   316,    -1,    -1,   319,    -1,    -1,
    3107,    -1,  3478,    -1,    -1,  3112,  3113,    -1,    -1,    -1,
     332,   333,    -1,    -1,    -1,   398,    -1,    -1,    -1,  3126,
      -1,    -1,    -1,    -1,    -1,   408,    -1,    -1,    -1,   412,
      -1,    -1,    -1,    -1,   417,   357,    -1,   359,  3145,   422,
      -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3639,    -1,    -1,   300,   381,
      -1,   444,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3183,    -1,   461,  3663,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   471,  3196,
      -1,    -1,   475,    -1,    -1,    -1,    -1,    -1,   481,    -1,
     483,   484,   424,    -1,   426,   488,   489,    -1,    -1,   351,
      -1,   353,    -1,    -1,   436,   498,    -1,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,   508,    -1,   510,   511,   512,
     513,  3661,   374,   375,    -1,   377,    -1,  3613,    -1,    -1,
      -1,    -1,    -1,  3432,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   477,   478,  3264,    -1,   481,
     482,   483,   484,   546,    -1,    -1,    -1,    -1,    -1,  3458,
    3459,   413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   562,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   570,   571,    -1,
      -1,    -1,   575,    -1,    -1,    -1,    -1,    -1,    -1,   582,
      -1,  3308,   524,   525,    -1,    -1,    -1,    -1,    -1,    -1,
    3499,  3500,    -1,    -1,    -1,  3504,    -1,    -1,    -1,  3326,
    3327,   543,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   612,
      -1,  3520,    -1,  3522,    -1,    -1,    -1,    -1,    -1,  3346,
      -1,  3348,    -1,  3350,    -1,    -1,    -1,    -1,  3327,  3538,
      -1,    -1,   494,    -1,    -1,    -1,  3363,    -1,  3547,    -1,
      -1,   503,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3561,    -1,    -1,  3564,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3572,    -1,   668,    -1,    -1,    -1,  3578,
      -1,    -1,  3399,   676,    -1,    -1,   679,    -1,    -1,   682,
     683,    -1,    -1,    -1,  3593,    -1,    -1,    -1,    -1,    -1,
    3599,    -1,    -1,  3602,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3610,    -1,    -1,    -1,  3432,    -1,    -1,    -1,    -1,
    3437,    23,    24,    -1,  3623,   718,    -1,   720,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3636,  3455,  3638,
      -1,  3458,  3459,  3460,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3650,  3651,    -1,    56,  3654,    -1,    -1,    -1,    -1,
      -1,  3478,    -1,    -1,    -1,    67,    -1,    -1,    -1,    -1,
      -1,    -1,  3489,    -1,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3499,  3500,    -1,    -1,    -1,  3504,    -1,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3520,    -1,  3522,   108,    -1,    -1,   111,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3547,    -1,    -1,    -1,    -1,    -1,    -1,  3554,   140,    -1,
      -1,    -1,    -1,    -1,  3561,    -1,  3563,  3564,     3,    -1,
      -1,    -1,    -1,    -1,    -1,  3572,    -1,    -1,    13,    14,
      -1,  3578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    26,    -1,    28,    -1,   868,  3593,   870,    -1,  3596,
      -1,  3598,  3599,    -1,    -1,  3602,    -1,  3604,    -1,    -1,
      -1,    46,    47,  3610,    -1,    -1,  3613,    52,    -1,    -1,
    3617,    56,    57,    -1,    -1,    -1,  3623,    -1,    -1,   902,
      -1,   213,    -1,    -1,    69,   908,  3633,    -1,   220,  3636,
      -1,  3638,  3639,    -1,    -1,    -1,    -1,    -1,    -1,    84,
      -1,    -1,    -1,  3650,  3651,    -1,    -1,  3654,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3663,    -1,   103,    -1,
      -1,    -1,   945,    -1,   947,    -1,   949,   112,   113,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   961,   962,
     125,   126,    -1,    -1,    -1,    -1,    -1,    -1,   971,   972,
      -1,    -1,    -1,    -1,   286,    -1,    -1,    -1,    -1,   982,
      -1,    -1,    -1,   148,    -1,    -1,    -1,   990,   300,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,
      -1,  1004,  1005,  1006,  1007,    -1,    -1,    -1,    -1,    -1,
      -1,  1014,    -1,  1016,    -1,    -1,    -1,    -1,    -1,  1022,
      -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,  1032,
     195,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,   351,
      -1,   353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   219,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   374,   375,    -1,   377,    -1,    -1,   233,    -1,
      -1,    -1,    -1,    -1,    -1,  1078,    -1,    -1,  1081,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   251,    -1,    -1,    -1,
      -1,   256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   413,    13,    14,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1130,    -1,  1132,
    1133,  1134,    -1,  1136,    -1,    46,    47,    -1,    -1,    -1,
      -1,    52,  1145,    -1,  1147,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    84,    -1,    -1,   341,    -1,  1181,    -1,
      -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   503,   103,    -1,    -1,    -1,    -1,   362,    -1,    -1,
      -1,   112,   113,   114,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   125,   126,    -1,    -1,  1221,    -1,
      -1,    -1,    -1,    -1,   389,    -1,   391,   392,    -1,    -1,
     395,    -1,    -1,   398,    -1,   400,    -1,   148,    -1,    -1,
     405,    -1,   407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   416,    -1,   164,    -1,   420,    -1,    -1,    -1,    -1,
      -1,   426,    -1,    -1,    -1,    -1,   431,    -1,    -1,    -1,
     435,    -1,    -1,    -1,    -1,    -1,  1279,   188,    -1,    -1,
      -1,    -1,    -1,    -1,   195,    -1,    -1,   198,    -1,   454,
      -1,  1294,    -1,   458,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   233,    -1,    -1,    -1,    -1,   492,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     251,    -1,    -1,   508,    -1,   256,   511,  1350,    -1,    -1,
      -1,   516,  1355,    -1,  1357,    -1,    -1,    -1,    -1,  1362,
      -1,    -1,    -1,    -1,    -1,  1368,    -1,  1370,    -1,    -1,
      -1,    -1,  1375,  1376,   539,  1378,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1390,    -1,    -1,
    1393,    -1,    -1,    -1,    -1,   560,  1399,  1400,  1401,  1402,
      -1,    -1,    -1,    -1,    -1,    -1,  1409,  1410,  1411,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1427,    -1,    -1,    -1,    -1,    -1,
     341,    -1,    -1,  1436,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1453,   362,    -1,    -1,    -1,  1458,    -1,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1470,    -1,    -1,
      -1,    -1,    -1,  1476,    -1,    -1,    -1,    -1,   389,    -1,
     391,   392,    -1,    -1,   395,    -1,    -1,   398,    -1,   400,
      -1,    -1,    -1,    -1,   405,    -1,   407,    -1,    -1,    -1,
      -1,    30,    -1,    32,    33,   416,    -1,    -1,    -1,   420,
      -1,    -1,    -1,    -1,    -1,   426,    -1,    -1,    -1,    -1,
     431,    -1,    -1,    -1,   435,    54,    55,    -1,    -1,    -1,
      -1,    -1,  1535,    -1,    -1,    64,    -1,    66,    -1,    -1,
      -1,  1544,    -1,   454,    -1,    -1,    -1,   458,    -1,    -1,
      -1,    -1,    -1,    -1,    83,    84,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    -1,    -1,    -1,  1572,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1580,    -1,    -1,
    1583,   492,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   508,    -1,    -1,
     511,    -1,    -1,    -1,    -1,   516,    -1,    -1,    -1,    -1,
     139,   140,    -1,    -1,    -1,   144,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   539,    -1,
      -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    -1,   173,    -1,   175,    -1,    -1,   560,
      -1,    -1,    23,    24,    -1,    -1,    -1,    -1,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    52,    -1,   212,   213,    56,    -1,   216,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    -1,
      -1,    -1,   231,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    93,   252,    -1,    -1,    -1,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,
     111,    -1,    -1,  1746,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,   281,    -1,    -1,   126,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,    -1,   140,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   313,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   322,   165,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   365,   366,    -1,    -1,
      -1,    -1,   213,    -1,  1847,    -1,    -1,    -1,    -1,   220,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1865,  1866,    -1,    -1,    -1,    -1,    -1,  1872,
      -1,  1874,  1875,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   425,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1908,   435,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   286,    -1,  1920,  1921,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   455,  1930,    -1,   300,
     459,    -1,    -1,  1936,   305,    -1,  1939,    -1,    -1,  1942,
      -1,    -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,    -1,
    1953,  1954,    -1,  1956,    -1,    -1,    -1,    -1,    -1,  1962,
    1963,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1972,
      -1,  1974,    -1,    -1,   345,  1978,  1979,    -1,    -1,    -1,
     351,    -1,   353,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,    -1,
      -1,   530,    -1,   374,   375,    -1,   377,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2018,  2019,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2044,   413,    -1,    -1,    -1,    -1,    -1,  2051,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2064,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   503,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2192,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2223,    -1,    -1,    -1,  2227,    -1,  2229,  2230,  2231,  2232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2240,    -1,    -1,
      -1,  2244,    -1,    -1,  2247,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2261,  2262,
    2263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2274,    -1,    -1,    -1,    -1,    -1,  2280,    -1,  2282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2290,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2350,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2361,    -1,
      -1,  2364,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2398,    -1,    -1,    -1,    -1,
      -1,    -1,  2405,    -1,    -1,  2408,    -1,    -1,    -1,  2412,
    2413,    -1,    -1,  2416,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2426,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     505,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   558,    -1,    -1,    -1,  2590,  2591,    -1,
    2593,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2602,
      -1,    -1,    -1,    -1,    -1,  2608,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2618,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2626,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2643,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2655,    -1,    -1,    -1,    -1,    -1,    -1,  2662,
      -1,    -1,    -1,    -1,    -1,    -1,  2669,    -1,    -1,    -1,
      -1,    -1,  2675,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2749,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   787,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2848,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2871,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2886,    -1,    -1,    -1,   862,    -1,    -1,
      -1,   866,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2927,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2949,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2969,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2994,    -1,  2996,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3006,    -1,    -1,    -1,    -1,    -1,  3012,
      -1,    -1,    -1,    -1,    -1,   990,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   999,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3059,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3087,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3107,    -1,    -1,    -1,    -1,  3112,
    3113,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3126,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3145,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1149,  1150,  1151,    -1,    -1,    -1,
    3183,    -1,    -1,  1158,  1159,    -1,    -1,  1162,    -1,  1164,
    1165,  1166,  1167,  3196,    -1,    -1,  1171,    -1,    -1,  1174,
    1175,    -1,  1177,    -1,  1179,  1180,    -1,  1182,  1183,  1184,
    1185,  1186,    -1,  1188,    -1,  1190,  1191,  1192,    -1,  1194,
    1195,  1196,  1197,    -1,  1199,  1200,    -1,  1202,    -1,    -1,
    1205,  1206,  1207,    -1,  1209,  1210,  1211,  1212,    -1,  1214,
    1215,  1216,  1217,    -1,    -1,    -1,    -1,    -1,  1223,  1224,
      -1,  1226,  1227,  1228,  1229,  1230,    -1,    -1,    -1,    -1,
    1235,  3264,  1237,  1238,  1239,  1240,  1241,    -1,    -1,  1244,
    1245,  1246,  1247,  1248,  1249,    -1,  1251,  1252,    -1,    -1,
    1255,  1256,  1257,    -1,  1259,    -1,  1261,    -1,    -1,    -1,
    1265,    -1,  1267,  1268,    -1,    -1,    -1,    -1,  1273,    -1,
      -1,    -1,    -1,    -1,    -1,  3308,  1281,  1282,  1283,    -1,
      -1,    -1,    -1,    -1,    -1,  1290,    -1,    -1,  1293,    -1,
      -1,    -1,    -1,  3326,  3327,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3346,    -1,  3348,    -1,  3350,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1396,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3437,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3455,    -1,    -1,    -1,    -1,  3460,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3478,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3489,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3554,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3563,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1546,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3596,    -1,  3598,    -1,    -1,    -1,    -1,
      -1,  3604,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3613,    -1,    -1,    -1,  3617,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3633,    -1,    -1,    -1,    -1,    -1,  3639,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3663,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1718,  1719,  1720,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1735,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1760,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1783,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2031,    -1,    -1,  2034,
      -1,    -1,  2037,  2038,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2050,    -1,    -1,  2053,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2066,    -1,  2068,    -1,    -1,    -1,  2072,    -1,  2074,
    2075,    -1,    -1,    -1,  2079,    -1,  2081,  2082,    -1,  2084,
      -1,    -1,  2087,    -1,  2089,  2090,    -1,    -1,    -1,    -1,
    2095,  2096,    -1,    -1,  2099,    -1,  2101,    -1,  2103,    -1,
    2105,    -1,  2107,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2118,  2119,    -1,    -1,  2122,    -1,  2124,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2132,  2133,    -1,
    2135,    -1,  2137,    -1,    -1,  2140,  2141,  2142,    -1,  2144,
      -1,    -1,    -1,    -1,  2149,  2150,  2151,  2152,    -1,    -1,
      -1,    -1,  2157,  2158,  2159,    -1,  2161,    -1,  2163,    -1,
    2165,    -1,  2167,    -1,  2169,    -1,    -1,    -1,    -1,    -1,
      -1,  2176,    -1,  2178,    -1,    -1,  2181,  2182,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2193,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2234,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2283,    -1,
      -1,    -1,    -1,  2288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2441,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2514,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2524,
      -1,  2526,    -1,  2528,    -1,    -1,    -1,    -1,    -1,  2534,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2559,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2627,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2772,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2782,    -1,    -1,
      -1,    -1,    -1,  2788,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2797,  2798,    -1,    -1,    -1,    -1,  2803,    -1,
      -1,    -1,  2807,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2820,    -1,    -1,    -1,    -1,
      -1,  2826,    -1,    -1,  2829,  2830,    -1,  2832,  2833,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2846,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2912,  2913,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2923,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3082,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3095,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3205,    -1,    -1,    -1,    -1,    -1,  3211,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3257,    -1,  3259,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3330,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3388,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3411,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3494,
    3495,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3513,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3523,    -1,
      -1,    -1,    -1,  3528,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3568,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,  3579,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    42,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,  3640,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,   239,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,   486,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
     337,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,   420,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
     561,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,   561,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,   561,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    -1,    28,    29,    30,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,    51,
      -1,    53,    54,    55,    56,    -1,    58,    59,    60,    61,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    -1,    81,
      82,    83,    -1,    -1,    86,    87,    88,    -1,    90,    91,
      -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,
     102,   103,   104,    -1,    -1,   107,   108,   109,    -1,   111,
      -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,   133,   134,    -1,   136,   137,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,   151,
     152,   153,   154,   155,   156,    -1,   158,   159,   160,   161,
     162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,    -1,
     172,   173,    -1,   175,   176,   177,   178,   179,    -1,   181,
     182,   183,   184,   185,   186,   187,    -1,   189,   190,    -1,
     192,   193,    -1,   195,   196,    -1,   198,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,
      -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,
     252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,
      -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,    -1,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,    -1,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,   394,   395,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,   406,   407,   408,   409,   410,   411,
     412,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,    -1,   461,
     462,   463,   464,   465,   466,   467,   468,   469,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,
     492,   493,   494,   495,    -1,   497,   498,   499,   500,    -1,
     502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,   518,   519,   520,   521,
     522,   523,    -1,    -1,   526,   527,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,
      -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,
     552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,   561,
      -1,   563,   564,    -1,   566,   567,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    -1,    28,
      29,    30,    -1,    32,    33,    34,    35,    36,    37,    38,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    50,    51,    -1,    53,    54,    55,    56,    -1,    58,
      59,    60,    61,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,    87,    88,
      -1,    90,    91,    -1,    93,    94,    95,    96,    97,    -1,
      -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,
     109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,   133,   134,    -1,   136,   137,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
     149,    -1,   151,   152,   153,   154,   155,   156,    -1,   158,
     159,   160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,
     169,   170,   171,   172,   173,    -1,   175,   176,   177,   178,
     179,    -1,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
     219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,
      -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,
      -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,   258,
      -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,   301,   302,   303,    -1,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,    -1,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,   378,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,    -1,   461,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,   490,   491,   492,   493,   494,   495,    -1,   497,   498,
     499,   500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,
     519,   520,   521,   522,   523,    -1,    -1,   526,   527,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,
      -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,
      -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    -1,    28,    29,    30,    -1,    32,    33,    34,    35,
      36,    37,    38,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    50,    51,    -1,    53,    54,    55,
      56,    -1,    58,    59,    60,    61,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,
      86,    87,    88,    -1,    90,    91,    -1,    93,    94,    95,
      96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,
     116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,
     136,   137,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,   149,    -1,   151,   152,   153,   154,   155,
     156,    -1,   158,   159,   160,   161,   162,    -1,   164,    -1,
      -1,   167,    -1,   169,   170,   171,   172,   173,    -1,   175,
     176,   177,   178,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,    -1,   189,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
     236,   237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,
      -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,
      -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,    -1,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,    -1,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,    -1,   461,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,    -1,   473,   474,    -1,
     476,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,   490,   491,   492,   493,   494,   495,
      -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,   505,
     506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,   518,   519,   520,   521,   522,   523,    -1,    -1,
     526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,
      -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,
     566,   567,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,
      23,    24,    25,    26,    -1,    28,    29,    30,    -1,    32,
      33,    34,    35,    36,    37,    38,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,
      53,    54,    55,    56,    -1,    58,    59,    60,    61,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    79,    -1,    81,    82,
      83,    -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,
      93,    94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,
     103,   104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,
      -1,    -1,   115,   116,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
     133,   134,    -1,   136,   137,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,   149,    -1,   151,   152,
     153,   154,   155,   156,    -1,   158,   159,   160,   161,   162,
      -1,   164,    -1,    -1,   167,    -1,   169,   170,   171,   172,
     173,    -1,   175,   176,   177,   178,   179,    -1,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,
     253,    -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,
      -1,    -1,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,    -1,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,    -1,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,   378,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,    -1,   461,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,
     493,   494,   495,    -1,   497,   498,   499,   500,    -1,   502,
      -1,    -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,   518,   519,   520,   521,   522,
     523,    -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,
     543,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,
     553,    -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,
     563,   564,    -1,   566,   567,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    -1,    28,    29,
      30,    -1,    32,    33,    34,    35,    36,    37,    38,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      50,    51,    -1,    53,    54,    55,    56,    -1,    58,    59,
      60,    61,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      -1,    81,    82,    83,    -1,    -1,    86,    87,    88,    -1,
      90,    91,    -1,    93,    94,    95,    96,    97,    -1,    -1,
      -1,    -1,   102,   103,   104,    -1,    -1,   107,   108,   109,
      -1,   111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,   133,   134,    -1,   136,   137,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,   149,
      -1,   151,   152,   153,   154,   155,   156,    -1,   158,   159,
     160,   161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,
     170,    -1,   172,   173,    -1,   175,   176,   177,   178,   179,
      -1,   181,   182,   183,   184,   185,   186,   187,    -1,   189,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,
     220,   221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,
     240,   241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,
     250,    -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,
      -1,   261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,    -1,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,    -1,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
      -1,   461,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
     490,   491,   492,   493,   494,   495,    -1,   497,   498,   499,
     500,    -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,
     520,   521,   522,   523,    -1,    -1,   526,   527,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,   541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,
      -1,    -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,
     560,    -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    22,    23,    24,    25,    26,
      -1,    28,    29,    30,    -1,    32,    33,    34,    35,    36,
      37,    38,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    50,    51,    -1,    53,    54,    55,    56,
      -1,    58,    59,    60,    61,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      87,    88,    -1,    90,    91,    -1,    93,    94,    95,    96,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,
     107,   108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,   133,   134,    -1,   136,
     137,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,   149,    -1,   151,   152,   153,   154,   155,   156,
      -1,   158,   159,   160,   161,   162,    -1,   164,    -1,    -1,
     167,    -1,   169,   170,    -1,   172,   173,    -1,   175,   176,
     177,   178,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,
     237,    -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,
      -1,   248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,
     257,   258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,   285,   286,
     287,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,    -1,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,    -1,   322,   323,   324,   325,    -1,
     327,   328,    -1,   330,   331,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,   378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,    -1,   461,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,   490,   491,   492,   493,   494,   495,    -1,
     497,   498,   499,   500,    -1,   502,    -1,    -1,   505,   506,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,   518,   519,   520,   521,   522,   523,    -1,    -1,   526,
     527,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,
      -1,   548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,
      -1,   558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,
     567,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    -1,    28,    29,    30,    -1,    32,    33,
      34,    35,    36,    37,    38,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    50,    51,    -1,    53,
      54,    55,    56,    -1,    58,    59,    60,    61,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    79,    -1,    81,    82,    83,
      -1,    -1,    86,    87,    88,    -1,    90,    91,    -1,    93,
      94,    95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,
     104,    -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,
      -1,   115,   116,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,
     134,    -1,   136,   137,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,   149,    -1,   151,   152,   153,
     154,   155,   156,    -1,   158,   159,   160,   161,   162,    -1,
     164,    -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,
      -1,   175,   176,   177,   178,   179,    -1,   181,   182,   183,
     184,   185,   186,   187,    -1,   189,   190,    -1,   192,   193,
      -1,   195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,   237,    -1,    -1,   240,   241,    -1,   243,
     244,    -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,
      -1,   255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,
      -1,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,   301,   302,   303,
      -1,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,    -1,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
     394,   395,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,   406,   407,   408,   409,   410,   411,   412,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,    -1,   461,   462,   463,
     464,   465,   466,   467,   468,   469,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,   490,   491,   492,   493,
     494,   495,    -1,   497,   498,   499,   500,    -1,   502,    -1,
      -1,   505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,   518,   519,   520,   521,   522,   523,
      -1,    -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,
      -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,
      -1,    -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,
     564,    -1,   566,   567,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    22,    23,    24,    25,    26,    -1,    28,    29,    30,
      -1,    32,    33,    34,    35,    36,    37,    38,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    50,
      51,    -1,    53,    54,    55,    56,    -1,    58,    59,    60,
      61,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    79,    -1,
      81,    82,    83,    -1,    -1,    86,    87,    88,    -1,    90,
      91,    -1,    93,    94,    95,    96,    97,    -1,    -1,    -1,
      -1,   102,   103,   104,    -1,    -1,   107,   108,   109,    -1,
     111,    -1,    -1,    -1,   115,   116,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,   133,   134,    -1,   136,   137,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,    -1,   158,   159,   160,
     161,   162,    -1,   164,    -1,    -1,   167,    -1,   169,   170,
      -1,   172,   173,    -1,   175,   176,   177,   178,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,   219,   220,
     221,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,   237,    -1,    -1,   240,
     241,    -1,   243,   244,    -1,    -1,    -1,   248,    -1,   250,
      -1,   252,   253,    -1,   255,    -1,   257,   258,    -1,    -1,
     261,    -1,    -1,    -1,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,    -1,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
      -1,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,   378,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,    -1,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,   490,
     491,   492,   493,   494,   495,    -1,   497,   498,   499,   500,
      -1,   502,    -1,    -1,   505,   506,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,   518,   519,   520,
     521,   522,   523,    -1,    -1,   526,   527,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
     541,    -1,   543,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,   553,    -1,    -1,    -1,    -1,   558,    -1,   560,
      -1,    -1,   563,   564,    -1,   566,   567,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    -1,
      28,    29,    30,    -1,    32,    33,    34,    35,    36,    37,
      38,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    50,    51,    -1,    53,    54,    55,    56,    -1,
      58,    59,    60,    61,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,    87,
      88,    -1,    90,    91,    -1,    93,    94,    95,    96,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,    -1,    -1,   107,
     108,   109,    -1,   111,    -1,    -1,    -1,   115,   116,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,   133,   134,    -1,   136,   137,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,   149,    -1,   151,   152,   153,   154,   155,   156,    -1,
     158,   159,   160,   161,   162,    -1,   164,    -1,    -1,   167,
      -1,   169,   170,    -1,   172,   173,    -1,   175,   176,   177,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
      -1,   189,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,   199,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,   219,   220,   221,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,   237,
      -1,    -1,   240,   241,    -1,   243,   244,    -1,    -1,    -1,
     248,    -1,   250,    -1,   252,   253,    -1,   255,    -1,   257,
     258,    -1,    -1,   261,    -1,    -1,    -1,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,    -1,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,    -1,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,   394,   395,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,    -1,   461,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,   490,   491,   492,   493,   494,   495,    -1,   497,
     498,   499,   500,    -1,   502,    -1,    -1,   505,   506,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
     518,   519,   520,   521,   522,   523,    -1,    -1,   526,   527,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,   541,    -1,   543,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,   552,   553,    -1,    -1,    -1,    -1,
     558,    -1,   560,    -1,    -1,   563,   564,    -1,   566,   567,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,
      25,    26,    -1,    28,    29,    30,    -1,    32,    33,    34,
      35,    36,    37,    38,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    50,    51,    -1,    53,    54,
      55,    56,    -1,    58,    59,    60,    61,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    79,    -1,    81,    82,    83,    -1,
      -1,    86,    87,    88,    -1,    90,    91,    -1,    93,    94,
      95,    96,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
      -1,    -1,   107,   108,   109,    -1,   111,    -1,    -1,    -1,
     115,   116,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,   133,   134,
      -1,   136,   137,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,   151,   152,   153,   154,
     155,   156,    -1,   158,   159,   160,   161,   162,    -1,   164,
      -1,    -1,   167,    -1,   169,   170,    -1,   172,   173,    -1,
     175,   176,   177,   178,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,   219,   220,   221,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,   236,   237,    -1,    -1,   240,   241,    -1,   243,   244,
      -1,    -1,    -1,   248,    -1,   250,    -1,   252,   253,    -1,
     255,    -1,   257,   258,    -1,    -1,   261,    -1,    -1,    -1,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,    -1,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,    -1,   322,   323,   324,
     325,    -1,   327,   328,    -1,   330,   331,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,   378,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,    -1,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,   490,   491,   492,   493,   494,
     495,    -1,   497,   498,   499,   500,    -1,   502,    -1,    -1,
     505,   506,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,   518,   519,   520,   521,   522,   523,    -1,
      -1,   526,   527,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,   541,    -1,   543,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,   552,   553,    -1,
      -1,    -1,    -1,   558,    -1,   560,    -1,    -1,   563,   564,
      -1,   566,   567,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    78,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,   174,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,   213,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,   246,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,   420,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    78,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,   174,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,   213,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
     232,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,   439,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,   420,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   561,
      -1,    23,    24,    25,    26,   567,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,   561,
      17,    -1,    -1,    20,   566,   567,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,   222,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,   554,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,   560,    -1,    17,    -1,    -1,    20,    -1,
     567,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   566,   567,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,    -1,   543,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
     567,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,   566,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,   566,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,   566,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,    -1,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
      -1,    -1,   548,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,   562,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
      -1,   543,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,   554,    -1,    17,    -1,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,
     543,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,   554,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
     554,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,    -1,   543,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,   554,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,   132,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
     546,     5,   548,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,   532,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,   546,     5,   548,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
     532,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,   546,     5,   548,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,
     548,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,
      -1,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    -1,
      -1,    -1,    -1,    49,    -1,    51,    -1,    53,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    -1,    68,    -1,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,    -1,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,    -1,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,   157,    -1,   159,   160,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,
     196,    -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,   209,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,   229,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,    -1,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,    -1,   393,   394,    -1,
     396,    -1,    -1,   399,    -1,    -1,   402,   403,   404,    -1,
      -1,    -1,   408,    -1,   410,   411,    -1,   413,   414,   415,
      -1,    -1,   418,    -1,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,    -1,   434,    -1,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,    -1,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,    -1,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,   534,    -1,
     536,    -1,   538,    -1,    -1,    -1,    -1,   543,    -1,    -1,
      -1,     5,   548,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,    53,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,   157,    -1,   159,   160,   161,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,   209,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,   229,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,   263,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,   393,
     394,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,   403,
     404,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,   413,
     414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,    -1,
     434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
      -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
     534,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,   543,
      -1,    -1,    -1,     5,   548,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,
      -1,    53,    -1,    -1,    -1,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,   157,    -1,   159,   160,   161,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,   209,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,   229,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
      -1,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
      -1,   393,   394,    -1,   396,    -1,    -1,   399,    -1,    -1,
     402,   403,   404,    -1,    -1,    -1,   408,    -1,   410,   411,
      -1,   413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,    -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
      -1,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
      -1,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,   534,    -1,   536,    -1,   538,    -1,    -1,    -1,
      -1,   543,    -1,    -1,    -1,     5,   548,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      -1,    -1,    -1,    23,    24,    25,    -1,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    -1,    -1,    -1,    -1,    49,
      -1,    51,    -1,    53,    -1,    -1,    -1,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    -1,    68,    -1,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,    -1,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,    -1,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,    -1,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,   157,    -1,   159,
     160,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,    -1,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,   229,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,   263,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,    -1,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,    -1,   393,   394,    -1,   396,    -1,    -1,   399,
      -1,    -1,   402,   403,   404,    -1,    -1,    -1,   408,    -1,
     410,   411,    -1,   413,   414,   415,    -1,    -1,   418,    -1,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,    -1,   434,    -1,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,    -1,   455,    -1,    -1,    -1,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,    -1,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,    -1,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,   534,    -1,   536,    -1,   538,    -1,
      -1,    -1,    -1,   543,    -1,    -1,    -1,     5,   548,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    -1,    -1,    -1,
      -1,    49,    -1,    51,    -1,    53,    -1,    -1,    -1,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    -1,
      68,    -1,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,    -1,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
      -1,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
      -1,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,   157,
      -1,   159,   160,   161,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
      -1,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,   263,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,    -1,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,    -1,   393,   394,    -1,   396,    -1,
      -1,   399,    -1,    -1,   402,   403,   404,    -1,    -1,    -1,
     408,    -1,   410,   411,    -1,   413,   414,   415,    -1,    -1,
     418,    -1,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,    -1,   434,    -1,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,    -1,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,    -1,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,   534,    -1,   536,    -1,
     538,    -1,    -1,    -1,    -1,   543,    -1,    -1,    -1,     5,
     548,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,   104,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,   162,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,   261,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,   325,
     326,    -1,   328,    -1,    -1,   331,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,   441,   442,   443,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,   497,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    32,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,   142,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,   427,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,   476,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      32,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,   245,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,   476,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    32,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
     245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,   476,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      88,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,   476,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    34,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,   245,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,   476,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    32,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,   245,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,   476,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,   245,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,   476,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    18,    -1,    20,    -1,    -1,
      23,    24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,
      53,    54,    -1,    56,    -1,    58,    59,    60,    -1,    62,
      -1,    64,    65,    -1,    67,    68,    69,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
     103,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,
     393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,
     403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,
     413,   414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
     433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,   476,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,
     543,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,
      26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,
      56,    -1,    58,    59,    60,    -1,    62,    -1,    64,    65,
      -1,    67,    68,    69,    70,    71,    -1,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    -1,    -1,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,
      -1,    -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,
      -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,
      -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,
      -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,
     146,   147,   148,    -1,   150,   151,    -1,   153,    -1,    -1,
     156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,
      -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,
      -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,
     186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,
     196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,
     206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,
      -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,
      -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,
      -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   267,   268,   269,   270,   271,   272,    -1,   274,   275,
     276,   277,   278,   279,   280,   281,   282,    -1,   284,   285,
     286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,
     296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,
      -1,   307,    -1,    -1,   310,   311,   312,   313,   314,   315,
     316,    -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,
      -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,
     336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,
      -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,
      -1,   367,   368,    -1,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,
     386,   387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,
     396,    -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,
      -1,   407,   408,    -1,   410,   411,    -1,   413,   414,   415,
     416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,
      -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,
      -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,
     446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,
      -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,
      -1,   467,   468,    -1,   470,   471,    -1,   473,   474,    -1,
      -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,
      -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,   495,
      -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,
      -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,
     526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,
     536,    -1,   538,   539,    -1,    -1,     5,   543,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,    28,
      -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,
      49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,
      59,    60,    -1,    62,    -1,    64,    65,    -1,    67,    68,
      69,    70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,
     109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,
     119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,
     129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,
     139,   140,   141,    -1,    -1,   144,    -1,   146,   147,   148,
      -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,
     159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,
     169,   170,   171,    -1,   173,    -1,   175,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,
     189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,
      -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,
      -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,
      -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,
      -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,
     269,   270,   271,   272,    -1,   274,   275,   276,   277,   278,
     279,   280,   281,   282,    -1,   284,   285,   286,    -1,   288,
     289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,
     299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,
      -1,   310,   311,   312,   313,   314,   315,   316,    -1,    -1,
     319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,
      -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,
     359,    -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,
      -1,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,
      -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,
     399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,
      -1,   410,   411,    -1,   413,   414,   415,   416,    -1,   418,
     419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,
      -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,   438,
      -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,
      -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,
     459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,
      -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,   478,
     479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,
     489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,
     499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,
      -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,
     529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,
     539,    -1,    -1,     5,   543,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      -1,    23,    24,    25,    26,    -1,    28,    -1,    30,    -1,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,
      -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,    51,
      -1,    53,    54,    -1,    56,    -1,    58,    59,    60,    -1,
      62,    -1,    64,    65,    -1,    67,    68,    69,    70,    71,
      -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,   103,    -1,    -1,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,
      -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,    -1,
      -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,   141,
      -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,   151,
      -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,
      -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,    -1,
      -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,
     182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,
      -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,   201,
      -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,
      -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,
      -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,   241,
      -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,
     252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,
     272,    -1,   274,   275,   276,   277,   278,   279,   280,   281,
     282,    -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,
      -1,   293,   294,   295,   296,    -1,    -1,   299,   300,    -1,
      -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,
     312,   313,   314,   315,   316,    -1,    -1,   319,   320,    -1,
     322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,    -1,
      -1,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,
     352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,
     362,   363,    -1,   365,    -1,   367,   368,    -1,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,
     382,   383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,
     392,   393,    -1,    -1,   396,    -1,   398,   399,   400,    -1,
     402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,   411,
      -1,   413,   414,   415,   416,    -1,   418,   419,    -1,    -1,
      -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,
     432,   433,   434,   435,    -1,   437,   438,    -1,    -1,    -1,
      -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,
      -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,   461,
     462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,
      -1,   473,   474,    -1,    -1,   477,   478,   479,   480,   481,
      -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,
     492,   493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,
     502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,
     512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,
      -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,    -1,
       5,   543,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,    24,
      25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,    -1,
      45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,    54,
      -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,    64,
      65,    -1,    67,    68,    69,    70,    71,    -1,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,    94,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,    -1,
      -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,    -1,
     125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,   134,
      -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,   144,
      -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,    -1,
      -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,   164,
      -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,    -1,
     175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,    -1,
      -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,    -1,
     195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,    -1,
     205,   206,   207,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,   224,
      -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,    -1,
     255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   267,   268,   269,   270,   271,   272,    -1,   274,
     275,   276,   277,   278,   279,   280,   281,   282,    -1,   284,
     285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,   294,
     295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,    -1,
     305,    -1,   307,    -1,    -1,   310,   311,   312,   313,   314,
     315,   316,    -1,    -1,   319,   320,    -1,   322,   323,   324,
      -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,    -1,
     355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,    -1,
     365,    -1,   367,   368,    -1,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,    -1,
      -1,   386,   387,   388,    -1,   390,    -1,   392,   393,    -1,
      -1,   396,    -1,   398,   399,   400,    -1,   402,   403,    -1,
      -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,   414,
     415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,   424,
     425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,   434,
     435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,    -1,
     445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,   454,
     455,    -1,    -1,   458,   459,    -1,   461,   462,   463,    -1,
      -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,   474,
      -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,    -1,
      -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,   494,
     495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,    -1,
      -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,   514,
     515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,
      -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,    -1,
      -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,    -1,
      28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,    -1,
      -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,    -1,
      58,    59,    60,    -1,    62,    -1,    64,    65,    -1,    67,
      68,    69,    70,    71,    -1,    -1,    74,    -1,    76,    77,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,    -1,
      -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,   117,
      -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,    -1,
     128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,    -1,
     138,   139,   140,   141,    -1,    -1,   144,    -1,   146,   147,
     148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,    -1,
      -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,    -1,
      -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,   187,
      -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,    -1,
     198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,   207,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,    -1,
      -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,   227,
     228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,   237,
      -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,
     268,   269,   270,   271,   272,    -1,   274,   275,   276,   277,
     278,   279,   280,   281,   282,    -1,   284,   285,   286,    -1,
     288,   289,    -1,    -1,    -1,   293,   294,   295,   296,    -1,
      -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,   307,
      -1,    -1,   310,   311,   312,   313,   314,   315,   316,    -1,
      -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,    -1,
     338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,   357,
      -1,   359,    -1,    -1,   362,   363,   364,   365,    -1,   367,
     368,    -1,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,   387,
     388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,    -1,
     398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,   407,
     408,    -1,   410,   411,    -1,   413,   414,   415,   416,    -1,
     418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,    -1,
     428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,   437,
     438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,    -1,
     448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,    -1,
     458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,   467,
     468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,   477,
     478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,   487,
      -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,    -1,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,   507,
      -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,    -1,
      -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,    -1,
     538,   539,    -1,    -1,     5,   543,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,
      -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,    30,
      -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    40,
      41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,    -1,
      51,    -1,    53,    54,    -1,    56,    -1,    58,    59,    60,
      -1,    62,    -1,    64,    65,    -1,    67,    68,    69,    70,
      71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,    -1,
      -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,    -1,
     111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,   120,
     121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,   130,
      -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,   140,
     141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,    -1,
     151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,   160,
     161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,   170,
      -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,    -1,
      -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,    -1,
      -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,    -1,
     201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,   220,
      -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,    -1,
      -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,    -1,
     241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,   250,
      -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,   270,
     271,   272,    -1,   274,   275,   276,   277,   278,   279,   280,
     281,   282,    -1,   284,   285,   286,    -1,   288,   289,    -1,
      -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,   300,
      -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,    -1,    -1,   319,   320,
      -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,    -1,
      -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     351,   352,   353,    -1,   355,    -1,   357,    -1,   359,    -1,
      -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,    -1,
      -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,   390,
      -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,   400,
      -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,   410,
     411,    -1,   413,   414,   415,   416,    -1,   418,   419,    -1,
      -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,    -1,
      -1,   432,   433,   434,   435,    -1,   437,   438,    -1,    -1,
      -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,    -1,
     451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,    -1,
     461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,   470,
     471,    -1,   473,   474,    -1,   476,   477,   478,   479,   480,
     481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,    -1,
      -1,   492,   493,   494,   495,    -1,    -1,   498,   499,    -1,
      -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,   510,
      -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,   530,
     531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,    -1,
      -1,     5,   543,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    -1,    23,
      24,    25,    26,    -1,    28,    -1,    30,    -1,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,    43,
      -1,    45,    46,    -1,    -1,    49,    -1,    51,    -1,    53,
      54,    -1,    56,    -1,    58,    59,    60,    -1,    62,    -1,
      64,    65,    -1,    67,    68,    69,    70,    71,    -1,    -1,
      74,    -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    93,
      94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
      -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,    -1,
      -1,   125,    -1,    -1,   128,   129,   130,    -1,    -1,    -1,
     134,    -1,    -1,    -1,   138,   139,   140,   141,    -1,    -1,
     144,    -1,   146,   147,   148,    -1,    -1,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,    -1,
     164,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,   173,
      -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,   183,
      -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,    -1,
      -1,   195,   196,    -1,   198,    -1,    -1,   201,    -1,    -1,
      -1,   205,   206,   207,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,    -1,
     224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,    -1,
      -1,   235,    -1,   237,    -1,    -1,    -1,   241,    -1,    -1,
     244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,    -1,
      -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   267,   268,   269,   270,   271,   272,    -1,
     274,   275,   276,   277,   278,   279,   280,   281,   282,    -1,
     284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,   293,
     294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,   303,
      -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,   313,
     314,   315,   316,    -1,    -1,   319,   320,    -1,   322,   323,
     324,    -1,    -1,    -1,   328,    -1,    -1,    -1,    -1,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,   353,
      -1,   355,    -1,   357,    -1,   359,    -1,    -1,   362,   363,
      -1,   365,    -1,   367,   368,    -1,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,   383,
      -1,    -1,   386,   387,   388,    -1,   390,    -1,   392,   393,
      -1,    -1,   396,    -1,   398,   399,   400,    -1,   402,   403,
      -1,    -1,    -1,   407,   408,    -1,   410,   411,    -1,   413,
     414,   415,   416,    -1,   418,   419,    -1,    -1,    -1,   423,
     424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,   433,
     434,   435,    -1,   437,   438,    -1,    -1,    -1,    -1,    -1,
      -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,    -1,
     454,   455,    -1,    -1,   458,   459,    -1,   461,   462,   463,
      -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,   473,
     474,    -1,    -1,   477,   478,   479,   480,   481,    -1,    -1,
      -1,    -1,    -1,   487,    -1,   489,    -1,    -1,   492,   493,
     494,   495,    -1,    -1,   498,   499,    -1,    -1,   502,    -1,
      -1,    -1,    -1,   507,    -1,    -1,   510,    -1,   512,    -1,
     514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   523,
      -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,    -1,
      -1,    -1,   536,    -1,   538,   539,    -1,    -1,     5,   543,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,    -1,    -1,    23,    24,    25,    26,
      -1,    28,    -1,    30,    -1,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    40,    41,    -1,    43,    -1,    45,    46,
      -1,    -1,    49,    -1,    51,    -1,    53,    54,    -1,    56,
      -1,    58,    59,    60,    -1,    62,    -1,    64,    65,    -1,
      67,    68,    69,    70,    71,    -1,    -1,    74,    -1,    76,
      77,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    93,    94,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,    -1,    -1,    -1,
      -1,    -1,   109,    -1,   111,    -1,    -1,    -1,    -1,    -1,
     117,    -1,   119,   120,   121,    -1,    -1,    -1,   125,    -1,
      -1,   128,   129,   130,    -1,    -1,    -1,   134,    -1,    -1,
      -1,   138,   139,   140,   141,    -1,    -1,   144,    -1,   146,
     147,   148,    -1,    -1,   151,    -1,   153,    -1,    -1,   156,
      -1,    -1,   159,   160,   161,    -1,    -1,   164,    -1,    -1,
      -1,    -1,   169,   170,    -1,    -1,   173,    -1,   175,    -1,
      -1,    -1,    -1,    -1,    -1,   182,   183,    -1,    -1,   186,
     187,    -1,   189,    -1,    -1,    -1,    -1,    -1,   195,   196,
      -1,   198,    -1,    -1,   201,    -1,    -1,    -1,   205,   206,
     207,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
      -1,    -1,    -1,   220,    -1,    -1,    -1,   224,    -1,    -1,
     227,   228,    -1,    -1,    -1,    -1,    -1,    -1,   235,    -1,
     237,    -1,    -1,    -1,   241,    -1,    -1,   244,    -1,    -1,
      -1,    -1,    -1,   250,    -1,   252,    -1,    -1,   255,    -1,
     257,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     267,   268,   269,   270,   271,   272,    -1,   274,   275,   276,
     277,   278,   279,   280,   281,   282,    -1,   284,   285,   286,
      -1,   288,   289,    -1,    -1,    -1,   293,   294,   295,   296,
      -1,    -1,   299,   300,    -1,    -1,   303,    -1,   305,    -1,
     307,    -1,    -1,   310,   311,   312,   313,   314,   315,   316,
      -1,    -1,   319,   320,    -1,   322,   323,   324,    -1,    -1,
      -1,   328,    -1,    -1,    -1,    -1,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   351,   352,   353,    -1,   355,    -1,
     357,    -1,   359,    -1,    -1,   362,   363,    -1,   365,    -1,
     367,   368,    -1,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,    -1,    -1,   382,   383,    -1,    -1,   386,
     387,   388,    -1,   390,    -1,   392,   393,    -1,    -1,   396,
      -1,   398,   399,   400,    -1,   402,   403,    -1,    -1,    -1,
     407,   408,    -1,   410,   411,    -1,   413,   414,   415,   416,
      -1,   418,   419,    -1,    -1,    -1,   423,   424,   425,    -1,
      -1,   428,    -1,    -1,    -1,   432,   433,   434,   435,    -1,
     437,   438,    -1,    -1,    -1,    -1,    -1,    -1,   445,   446,
      -1,   448,    -1,    -1,   451,    -1,    -1,   454,   455,    -1,
      -1,   458,   459,    -1,   461,   462,   463,    -1,    -1,    -1,
     467,   468,    -1,   470,   471,    -1,   473,   474,    -1,    -1,
     477,   478,   479,   480,   481,    -1,    -1,    -1,    -1,    -1,
     487,    -1,   489,    -1,    -1,   492,   493,   494,   495,    -1,
      -1,   498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,
     507,    -1,    -1,   510,    -1,   512,    -1,   514,   515,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   523,    -1,    -1,   526,
      -1,    -1,   529,   530,   531,    -1,    -1,    -1,    -1,   536,
      -1,   538,   539,    -1,    -1,     5,   543,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    -1,    23,    24,    25,    26,    -1,    28,    -1,
      30,    -1,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      40,    41,    -1,    43,    -1,    45,    46,    -1,    -1,    49,
      -1,    51,    -1,    53,    54,    -1,    56,    -1,    58,    59,
      60,    -1,    62,    -1,    64,    65,    -1,    67,    68,    69,
      70,    71,    -1,    -1,    74,    -1,    76,    77,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    93,    94,    -1,    -1,    97,    -1,    -1,
      -1,    -1,   102,   103,    -1,    -1,    -1,    -1,    -1,   109,
      -1,   111,    -1,    -1,    -1,    -1,    -1,   117,    -1,   119,
     120,   121,    -1,    -1,    -1,   125,    -1,    -1,   128,   129,
     130,    -1,    -1,    -1,   134,    -1,    -1,    -1,   138,   139,
     140,   141,    -1,    -1,   144,    -1,   146,   147,   148,    -1,
      -1,   151,    -1,   153,    -1,    -1,   156,    -1,    -1,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,   169,
     170,    -1,    -1,   173,    -1,   175,    -1,    -1,    -1,    -1,
      -1,    -1,   182,   183,    -1,    -1,   186,   187,    -1,   189,
      -1,    -1,    -1,    -1,    -1,   195,   196,    -1,   198,    -1,
      -1,   201,    -1,    -1,    -1,   205,   206,   207,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,    -1,    -1,    -1,
     220,    -1,    -1,    -1,   224,    -1,    -1,   227,   228,    -1,
      -1,    -1,    -1,    -1,    -1,   235,    -1,   237,    -1,    -1,
      -1,   241,    -1,    -1,   244,    -1,    -1,    -1,    -1,    -1,
     250,    -1,   252,    -1,    -1,   255,    -1,   257,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   267,   268,   269,
     270,   271,   272,    -1,   274,   275,   276,   277,   278,   279,
     280,   281,   282,    -1,   284,   285,   286,    -1,   288,   289,
      -1,    -1,    -1,   293,   294,   295,   296,    -1,    -1,   299,
     300,    -1,    -1,   303,    -1,   305,    -1,   307,    -1,    -1,
     310,   311,   312,   313,   314,   315,   316,    -1,    -1,   319,
     320,    -1,   322,   323,   324,    -1,    -1,    -1,   328,    -1,
      -1,    -1,    -1,   333,   334,    -1,   336,    -1,   338,   339,
     340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   351,   352,   353,    -1,   355,    -1,   357,    -1,   359,
      -1,    -1,   362,   363,    -1,   365,    -1,   367,   368,    -1,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
      -1,    -1,   382,   383,    -1,    -1,   386,   387,   388,    -1,
     390,    -1,   392,   393,    -1,    -1,   396,    -1,   398,   399,
     400,    -1,   402,   403,    -1,    -1,    -1,   407,   408,    -1,
     410,   411,    -1,   413,   414,   415,   416,    -1,   418,   419,
      -1,    -1,    -1,   423,   424,   425,    -1,    -1,   428,    -1,
      -1,    -1,   432,   433,   434,   435,    -1,   437,   438,    -1,
      -1,    -1,    -1,    -1,    -1,   445,   446,    -1,   448,    -1,
      -1,   451,    -1,    -1,   454,   455,    -1,    -1,   458,   459,
      -1,   461,   462,   463,    -1,    -1,    -1,   467,   468,    -1,
     470,   471,    -1,   473,   474,    -1,    -1,   477,   478,   479,
     480,   481,    -1,    -1,    -1,    -1,    -1,   487,    -1,   489,
      -1,    -1,   492,   493,   494,   495,    -1,    -1,   498,   499,
      -1,    -1,   502,    -1,    -1,    -1,    -1,   507,    -1,    -1,
     510,    -1,   512,    -1,   514,   515,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   523,    -1,    -1,   526,    -1,    -1,   529,
     530,   531,    -1,    -1,    -1,    -1,   536,    -1,   538,   539,
      -1,    -1,     5,   543,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    -1,    -1,    30,    -1,    -1,
      33,    -1,    -1,    -1,    37,    -1,    -1,    40,    41,    -1,
      43,    -1,    -1,    -1,    -1,    -1,    49,    -1,    51,    -1,
      53,    -1,    -1,    -1,    -1,    58,    59,    -1,    -1,    62,
      -1,    64,    65,    -1,    -1,    68,    -1,    70,    71,    -1,
      -1,    74,    -1,    76,    77,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      93,    94,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,   109,    -1,   111,    -1,
      -1,    -1,    -1,    -1,   117,    -1,   119,   120,   121,    -1,
      -1,    -1,    -1,    -1,    -1,   128,   129,   130,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,   139,   140,   141,    -1,
      -1,   144,    -1,   146,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,    -1,   156,    -1,    -1,   159,   160,   161,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   169,   170,    -1,    -1,
     173,    -1,   175,    -1,    -1,    -1,    -1,    -1,    -1,   182,
     183,    -1,    -1,   186,   187,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,   205,   206,   207,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,    -1,    -1,    -1,   220,    -1,    -1,
      -1,   224,    -1,    -1,   227,   228,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,    -1,
      -1,   244,    -1,    -1,    -1,    -1,    -1,   250,    -1,   252,
      -1,    -1,   255,    -1,   257,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   267,   268,   269,   270,   271,   272,
      -1,   274,   275,   276,   277,   278,   279,   280,   281,   282,
      -1,   284,   285,   286,    -1,   288,   289,    -1,    -1,    -1,
     293,   294,   295,   296,    -1,    -1,   299,   300,    -1,    -1,
     303,    -1,   305,    -1,   307,    -1,    -1,   310,   311,   312,
     313,   314,   315,   316,    -1,    -1,   319,   320,    -1,   322,
     323,   324,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     333,   334,    -1,   336,    -1,   338,   339,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   351,   352,
     353,    -1,   355,    -1,   357,    -1,   359,    -1,    -1,    -1,
     363,    -1,   365,    -1,   367,   368,    -1,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,    -1,    -1,   382,
     383,    -1,    -1,   386,   387,   388,    -1,   390,    -1,    -1,
     393,    -1,    -1,   396,    -1,    -1,   399,    -1,    -1,   402,
     403,    -1,    -1,    -1,    -1,   408,    -1,   410,   411,    -1,
     413,   414,   415,    -1,    -1,   418,    -1,    -1,    -1,    -1,
     423,   424,   425,    -1,    -1,   428,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,   437,   438,    -1,    -1,    -1,    -1,
      -1,    -1,   445,   446,    -1,   448,    -1,    -1,   451,    -1,
      -1,    -1,   455,    -1,    -1,    -1,   459,    -1,   461,   462,
     463,    -1,    -1,    -1,   467,   468,    -1,   470,   471,    -1,
     473,   474,    -1,    -1,   477,   478,   479,   480,   481,    -1,
      -1,    -1,    -1,    -1,   487,    -1,   489,    -1,    -1,    -1,
     493,   494,   495,    -1,    -1,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   507,    -1,    -1,   510,    -1,    -1,
      -1,   514,   515,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     523,    -1,    -1,   526,    -1,    -1,   529,   530,   531,    -1,
      -1,    -1,    -1,   536,    -1,   538,    -1,    -1,    -1,    -1,
     543
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short int yystos[] =
{
       0,     3,    13,    14,    26,    28,    46,    47,    52,    56,
      57,    69,    84,   103,   112,   113,   114,   125,   126,   148,
     164,   188,   195,   198,   219,   233,   251,   256,   341,   362,
     369,   389,   391,   392,   395,   398,   400,   405,   407,   416,
     420,   426,   431,   435,   454,   458,   492,   508,   511,   516,
     539,   560,   571,   572,   573,   574,   575,   576,   578,   583,
     585,   590,   608,   770,   788,   791,   799,   801,   803,   806,
     811,   813,   818,   821,   826,   830,   838,   839,   987,   989,
     995,   998,  1023,  1031,  1042,  1044,  1058,  1061,  1064,  1070,
    1074,  1078,  1081,  1082,  1128,  1145,  1151,  1153,  1160,  1162,
    1187,  1193,  1194,  1195,  1196,  1234,    11,    91,   175,   210,
     366,   784,  1215,  1216,   252,   329,   820,   470,   472,  1147,
    1188,   213,     5,     7,     8,     9,    10,    11,    17,    20,
      23,    24,    25,    26,    28,    30,    33,    37,    40,    41,
      43,    45,    46,    49,    51,    53,    54,    56,    58,    59,
      60,    62,    64,    65,    67,    68,    69,    70,    71,    74,
      76,    77,    79,    86,    93,    94,    97,   102,   103,   109,
     111,   117,   119,   120,   121,   125,   128,   129,   130,   134,
     138,   139,   140,   141,   144,   146,   147,   148,   151,   153,
     156,   159,   160,   161,   164,   169,   170,   173,   175,   182,
     183,   186,   187,   189,   195,   196,   198,   201,   205,   206,
     207,   208,   211,   212,   216,   220,   224,   227,   228,   235,
     237,   241,   244,   250,   252,   255,   257,   267,   268,   269,
     270,   271,   272,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   284,   285,   286,   288,   289,   293,   294,   295,
     296,   299,   300,   303,   305,   307,   310,   311,   312,   313,
     314,   315,   316,   319,   320,   322,   323,   324,   328,   333,
     334,   336,   338,   339,   340,   351,   352,   353,   355,   357,
     359,   362,   363,   365,   367,   368,   370,   371,   372,   373,
     374,   375,   376,   377,   382,   383,   386,   387,   388,   390,
     392,   393,   396,   398,   399,   400,   402,   403,   407,   408,
     410,   411,   413,   414,   415,   416,   418,   419,   423,   424,
     425,   428,   432,   433,   434,   435,   437,   438,   445,   446,
     448,   451,   454,   455,   458,   459,   461,   462,   463,   467,
     468,   470,   471,   473,   474,   477,   478,   479,   480,   481,
     487,   489,   492,   493,   494,   495,   498,   499,   502,   507,
     510,   512,   514,   515,   523,   526,   529,   530,   531,   536,
     538,   539,   543,   596,  1118,  1122,  1126,  1127,   281,  1147,
    1147,   536,  1189,    91,   174,   439,   473,   504,   514,   594,
     687,   688,   689,   762,  1032,   988,    91,   175,   213,   366,
     473,   488,   514,   529,   994,  1122,   820,   595,   567,  1116,
    1117,  1122,   584,   996,  1079,    93,   213,   472,  1147,   820,
    1122,  1075,   416,   514,  1147,   820,   999,  1071,  1147,   595,
    1189,  1122,   841,   843,   844,   342,  1130,  1045,   454,   458,
     435,   487,   435,   472,  1043,  1152,  1024,  1122,    28,    69,
     138,   362,   382,   407,   454,  1236,   420,   560,   840,     0,
       3,   362,   153,  1062,  1116,  1122,   142,   776,  1122,   596,
     596,   472,   109,  1212,  1147,   802,  1189,   827,   828,  1116,
     609,   567,   485,   804,   814,    16,  1190,   209,   690,   595,
     347,  1210,  1212,  1213,  1214,  1215,   472,   688,   213,   210,
     264,   372,  1040,  1041,   905,   906,   209,   993,   993,  1122,
     993,   993,   595,   993,  1147,   579,  1065,    12,    13,    84,
     112,   126,   148,   159,   188,   213,   219,   256,   367,   384,
     390,   396,   420,   431,   432,   467,   511,   513,  1163,  1165,
    1167,  1168,  1122,   340,    60,   380,   567,   245,   476,  1119,
    1122,  1124,   110,   200,   264,  1001,    76,   371,  1080,  1083,
     222,  1116,  1146,  1147,   171,    32,   281,  1050,  1076,  1122,
     595,   822,  1147,   110,   264,  1002,  1030,   281,   371,   435,
    1072,  1073,   800,    12,  1161,  1165,   485,  1190,   842,    12,
     122,   200,   444,   445,   446,   447,   448,   449,   460,   848,
     849,   850,  1129,    30,    33,    54,    55,    64,    66,    83,
      84,    92,   140,   144,   173,   175,   187,   189,   212,   213,
     216,   231,   252,   257,   281,   313,   322,   340,   365,   366,
     425,   435,   459,   472,   530,   735,   761,  1046,  1050,  1051,
    1053,  1136,   793,   794,   793,   793,   535,   792,   793,   992,
    1116,  1147,  1030,    34,   199,   476,  1104,  1120,  1235,  1235,
    1235,  1235,  1235,   843,   840,   561,  1122,  1060,  1059,   294,
     474,   499,   772,   774,   773,  1116,   142,   450,  1217,   812,
     991,   992,   225,   562,   834,   835,   560,   610,  1122,   586,
     991,   991,    51,   328,   328,   389,  1191,   325,   326,   877,
    1122,    88,  1124,  1125,  1178,  1179,   395,    10,   366,   488,
     702,  1211,  1217,  1218,  1226,  1228,  1212,  1215,   690,  1122,
     171,  1033,  1037,  1038,  1122,  1040,     7,    20,    22,    25,
      29,    32,    34,    35,    36,    38,    50,    54,    55,    61,
      64,    72,    73,    79,    81,    82,    83,    87,    88,    90,
      91,    95,    96,    97,   102,   104,   107,   108,   115,   116,
     133,   136,   137,   149,   152,   154,   155,   158,   162,   167,
     172,   176,   177,   178,   179,   181,   182,   184,   185,   186,
     190,   192,   193,   199,   205,   209,   219,   221,   236,   240,
     243,   248,   250,   253,   258,   261,   266,   273,   283,   287,
     295,   299,   301,   302,   306,   307,   308,   309,   310,   311,
     312,   318,   325,   326,   327,   330,   331,   336,   353,   354,
     356,   357,   358,   359,   360,   370,   378,   394,   395,   406,
     409,   412,   414,   418,   456,   457,   462,   464,   465,   466,
     469,   478,   479,   480,   481,   490,   491,   492,   497,   500,
     505,   506,   514,   518,   519,   520,   521,   522,   527,   531,
     541,   543,   548,   552,   553,   558,   560,   563,   564,   566,
     567,   859,   862,   865,   866,   867,   868,   869,   870,   871,
     872,   873,   874,   878,   881,   882,   884,   891,   895,   907,
    1103,  1105,  1107,  1108,  1112,  1114,  1118,  1120,  1122,   149,
    1122,   596,   337,   596,   596,  1125,  1177,   991,   993,   517,
     580,   117,   201,   257,   281,   365,   371,   399,   435,   455,
     470,  1066,  1067,  1147,   365,  1166,   410,   410,   473,   514,
     529,   342,  1170,   470,  1172,    59,   435,  1169,    92,   529,
    1171,   337,   562,    18,   142,   947,   948,  1154,  1122,   784,
     859,    74,   171,   264,  1084,  1090,    46,   171,  1116,  1148,
    1149,   819,   566,   577,  1119,   257,   823,  1125,   824,   825,
    1116,   807,   222,   992,  1003,  1004,    46,   562,   991,  1166,
     337,   416,  1192,  1191,   503,  1197,  1198,   554,   852,   853,
     854,   850,  1131,  1132,  1133,   257,   147,   426,   246,   533,
    1057,   493,   560,    91,   175,   366,   472,   529,  1057,   697,
    1124,   247,   966,   968,    62,   455,   168,   455,   455,   455,
     281,   470,    62,   455,   201,   455,   455,   493,   966,  1057,
     171,   225,  1054,   257,   139,    65,   368,   470,   489,   455,
     526,   790,   388,   451,   795,   796,   789,    77,   784,   562,
     339,  1238,   468,  1239,   230,   402,  1237,   561,  1198,  1200,
    1201,  1202,   838,  1063,  1104,  1122,   108,   684,   685,   686,
     695,   696,   744,   603,   603,   771,  1125,   419,   529,   991,
     485,   562,   108,   829,  1122,   828,   213,   232,   759,   760,
     836,   611,   612,   859,   267,   268,   269,   270,   271,   272,
     275,   276,   277,   278,   279,   280,   282,   386,   387,   587,
     588,   589,   153,   372,   805,    53,   153,   156,   168,   293,
     372,   815,   816,   817,    51,   389,   149,   593,   560,   858,
     566,   207,   562,   854,   854,   854,   529,  1218,  1116,   494,
     517,   763,  1037,  1116,  1122,   562,  1035,   567,  1039,   560,
     560,   560,   560,   560,   882,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   858,
     858,   560,   858,   560,   560,   560,   500,   560,  1103,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   859,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   908,
     909,   910,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   865,   560,   858,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     560,   560,   560,   560,   560,   560,   560,   560,   560,   560,
     858,   560,  1103,   560,   560,   560,  1103,   560,   560,    34,
     199,   476,   560,   560,   560,   858,   858,   858,   560,   560,
     560,   560,   560,   560,   859,   912,   882,   882,   882,   420,
     560,   859,  1205,  1122,   896,  1122,   540,   860,   863,   142,
     143,   180,   194,   226,   238,   265,   321,   879,   225,   246,
     385,   438,   549,   550,   877,   551,   429,   430,   552,   553,
     123,   306,   554,   555,   556,   557,   882,    98,    99,   100,
     101,   102,   170,   202,   203,   204,   205,   295,   297,   298,
     299,   307,   370,   417,   418,   531,   542,   543,   944,   945,
      63,   346,   562,  1120,   560,   567,  1116,   562,    48,   401,
     785,   991,   566,   581,   582,    46,   535,   562,  1068,   470,
     560,  1180,  1180,  1180,  1180,   175,   366,   472,  1164,  1168,
    1122,   160,   323,  1122,  1155,  1156,  1003,   281,   252,  1089,
     831,   281,   948,   562,   991,  1124,    27,   485,  1077,   562,
     485,   562,   485,   991,  1004,  1000,  1073,   171,   562,   175,
     366,  1164,  1122,    12,   122,  1204,   562,   845,   856,   859,
    1110,  1122,   562,   187,   252,   338,   425,  1134,  1135,  1138,
    1139,   225,  1055,  1119,   859,   554,   690,   596,   596,  1116,
    1116,  1047,   261,   331,   497,   969,   970,  1105,   596,  1057,
    1125,   168,  1052,  1054,   596,  1057,  1052,  1116,  1054,  1052,
    1052,  1057,  1057,   510,   797,   562,   797,   437,   420,   560,
     564,   915,   916,   917,   918,   927,   928,   936,  1104,   355,
    1240,   345,   962,   968,  1203,   686,    63,   735,    67,    79,
     235,   304,   328,   379,   450,   605,   607,     6,    13,    23,
      24,    52,    56,    67,    76,    81,    93,   111,   120,   121,
     126,   134,   140,   165,   211,   213,   220,   286,   300,   305,
     345,   351,   353,   374,   375,   377,   391,   413,   494,   503,
     692,   694,   695,   696,   777,   778,   779,   958,   109,   224,
    1116,   815,  1119,   992,   560,   561,   562,   142,   142,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     142,   142,   562,   512,   816,   684,   561,  1124,    44,  1179,
     596,   596,   175,  1116,   591,    43,   196,   415,   764,   764,
     337,  1036,  1034,   567,  1038,   171,   554,  1122,   948,   859,
     859,   859,    12,   122,   901,   949,   104,   162,   199,   261,
     331,   497,   972,   901,   901,   901,   859,   859,   905,   905,
     859,   905,   859,   859,   859,   859,   122,   901,   949,   859,
     561,   859,   859,   859,   859,   859,  1112,  1122,   859,   859,
     859,   859,   859,   560,  1205,   859,   944,   859,   859,   859,
     561,   859,   859,   859,   859,   905,   859,   859,    94,    97,
     478,   481,   946,   859,   122,   898,  1103,   859,   859,   859,
     561,   859,   859,   859,   859,   905,   859,   859,   859,   859,
     909,     9,   911,  1112,   122,   901,   859,   859,   122,   901,
     859,   859,   859,   859,   859,   905,   905,   905,   859,   859,
     859,   859,   859,   859,   905,   869,   859,   561,   859,   859,
     859,   859,   859,   561,   859,   859,   901,   901,   859,   859,
     859,   122,   901,   859,   859,   945,   945,   859,    42,   239,
     486,   859,   859,  1103,   561,   859,   561,   901,  1113,  1114,
    1122,   901,   859,   859,   859,   532,   914,  1208,  1208,   561,
     562,   561,   859,   566,   897,  1124,   567,   862,   861,   864,
     868,   155,   330,   491,   507,   877,    12,    17,   868,   880,
     560,   882,   869,   246,   869,   870,   225,   246,   385,   549,
     871,   872,   872,   873,   881,   873,   881,   874,   874,   874,
     874,   874,   882,   553,  1124,   882,   859,   883,  1122,   990,
    1125,   785,  1124,   562,   380,  1067,   991,  1069,  1122,  1181,
    1182,   554,  1116,  1122,  1176,  1176,  1176,   142,   160,   180,
     194,   237,   238,   265,   323,   363,  1157,  1159,   533,   950,
     997,   214,   832,   833,  1116,   264,   380,   537,  1150,  1149,
     815,   859,  1119,  1125,  1125,   825,  1116,   153,   372,   515,
     808,   809,   810,   420,   426,   522,   523,   560,   680,  1005,
    1008,  1119,   188,  1176,  1176,  1176,  1199,   853,   171,   222,
     846,   847,   961,   962,   983,   855,   567,  1132,   108,   487,
    1122,  1141,   314,   353,   566,   735,  1140,  1119,   171,  1056,
     561,  1122,   257,   455,  1049,   334,   562,   435,  1057,  1122,
    1057,  1052,  1116,  1057,  1057,   589,   798,   796,   935,  1122,
      85,   215,   230,   243,   317,   406,   460,   926,   426,   562,
    1116,   935,   562,   168,  1241,    44,   966,   142,   427,  1014,
    1015,  1015,  1119,   450,   450,   450,   450,   450,   419,    66,
      78,   174,   439,   707,   710,   711,   757,   759,   783,   783,
    1015,  1015,   783,  1015,  1015,  1015,   485,   119,  1015,   231,
     471,   166,   364,   759,   783,   231,  1015,   471,   119,  1015,
    1015,  1015,   783,    44,  1015,  1015,  1015,  1015,  1015,    18,
     142,   485,   787,  1015,  1015,  1015,   692,   562,   560,   567,
     706,   712,  1115,  1122,   775,   364,   942,  1122,   859,   972,
    1119,  1119,   104,   162,   261,   331,   497,   973,  1119,   972,
    1119,  1119,  1119,  1119,  1119,   972,  1119,  1119,   972,   588,
     353,   476,  1230,     8,    27,   672,   596,  1219,   246,   560,
     674,   691,   693,   694,  1116,   517,   950,  1122,   916,   567,
    1039,   562,   561,   561,   562,   901,   561,   902,   562,   561,
     561,   561,    18,   561,   517,   561,   561,   561,   561,   562,
     562,   517,   562,   562,   892,   561,   554,   561,   562,   562,
     561,   561,   562,   561,   567,   561,   562,   561,   562,   562,
     562,   561,   562,   561,   562,   171,   562,   562,   561,   562,
     561,   562,   562,   561,   562,   561,   561,   562,   561,   562,
     562,   562,   894,   562,   561,   562,   562,   561,   562,   562,
     561,   562,   561,   562,   561,   562,   562,   562,   561,   560,
     562,   901,   561,   561,   561,   901,   561,   561,   562,   562,
     561,   561,   562,   561,   562,   561,   561,   561,   561,   561,
     561,   561,   562,   562,   561,   562,   561,   225,   561,   561,
     562,   562,   562,   561,   562,   562,   561,   561,   561,   562,
     171,   562,   562,   901,   561,   561,   561,   562,   562,   562,
     561,   171,   859,   171,   859,   171,   859,   171,   561,   562,
     562,   561,   561,   561,   561,   561,   562,   561,   562,   561,
     859,   532,   546,   913,   841,  1207,  1205,   905,   565,   187,
     252,   425,  1137,   427,  1122,   344,   347,   875,    15,    16,
     876,   155,   330,   491,   507,   560,   859,  1205,   146,   954,
     869,    16,   560,   882,   869,   869,   944,   944,   859,   886,
     887,   888,   560,   567,   582,   256,   561,   562,   567,   567,
     485,   485,   485,  1158,   951,   967,   968,  1005,   476,  1121,
     562,   834,   537,   252,   485,   809,   681,  1006,   560,  1011,
    1016,  1011,   561,   680,  1007,  1109,  1110,  1113,  1122,  1009,
     342,   171,   171,   171,   839,   127,   916,   984,   168,   256,
     851,   983,   967,   847,    18,   857,  1119,  1122,   554,  1122,
     567,   227,   567,  1014,    32,   108,   736,   737,  1014,  1124,
     168,  1014,   566,  1124,    32,   108,   739,   740,  1124,   973,
    1048,   144,   530,   970,   970,   535,   950,  1052,   562,   930,
     935,   915,   230,   230,   348,   937,   230,   243,   406,   937,
     927,   915,  1026,  1027,  1113,   915,   948,   932,   933,   972,
     296,   963,   108,   741,   743,  1124,   737,    93,    93,   109,
     224,   767,  1115,   760,   760,    57,   166,   364,   504,   709,
     758,   708,   709,   767,  1115,   973,   972,  1115,   972,  1119,
    1119,   735,  1015,   972,   232,   232,  1115,  1115,   697,  1015,
     160,   237,   328,   700,   973,   973,  1115,   959,   960,  1113,
     108,   972,  1119,   972,   972,   373,   376,   699,   972,  1116,
      70,    71,   108,   130,   161,   383,   698,   697,   560,   779,
     704,   705,   706,   707,  1122,     8,   160,   786,   384,   708,
     749,   713,   567,   560,  1220,   561,   562,   476,   560,   112,
     219,   511,   673,  1229,  1220,  1116,   246,   675,   680,   704,
     210,   395,   677,  1091,   562,   693,   592,   916,   961,   950,
     948,   221,   859,   859,   561,   859,   859,    32,    55,    94,
      97,   105,   319,   433,   481,   509,   903,   736,   905,   859,
     736,   903,   859,   905,   561,   881,   881,  1120,  1122,   859,
     859,   905,  1120,   859,   859,   859,   905,   331,   859,   859,
     859,   859,   859,   859,   859,   905,   905,   331,   859,   859,
     905,   859,   859,   859,   859,   905,   859,   869,  1112,   561,
     561,   859,   859,   859,   859,   859,   859,   859,   859,   859,
     859,   859,   859,   905,   221,   859,   859,   859,   859,   561,
     859,   859,   859,   859,   171,   859,   171,   859,   171,   859,
     859,   331,   859,   859,   547,   859,   859,   138,  1209,   561,
     561,   567,   567,   567,  1124,   859,   862,   865,  1205,   561,
     562,   561,   882,   868,   859,  1205,   954,    16,   561,   854,
     889,   890,   904,   905,  1122,  1182,   554,   554,  1178,  1178,
    1178,   560,   859,   337,  1021,  1085,   833,   210,   837,  1125,
     848,  1012,  1013,  1113,  1017,   562,   560,  1008,   561,   561,
     562,   567,  1197,   171,  1178,  1178,  1178,   950,   950,   128,
     349,   979,   980,   985,   511,   225,  1119,  1122,   567,  1122,
     244,  1122,    12,    32,   108,   337,   859,  1144,    63,   742,
     859,  1125,   336,   353,   476,  1143,  1137,  1014,   966,   269,
    1057,   589,  1200,   931,   243,   230,   927,   937,   937,   230,
     337,   337,   517,   562,  1025,  1014,   165,   210,   516,   938,
     848,   859,   964,  1111,   859,   232,   232,   760,   767,   763,
     126,   426,   780,   737,  1119,   767,   785,  1119,   781,   562,
      19,   113,   965,   991,   561,   562,  1122,  1116,    31,    32,
      37,    39,    40,    41,    55,    94,    97,   105,   124,   141,
     161,   163,   182,   183,   223,   250,   259,   260,   262,   290,
     291,   292,   310,   311,   312,   316,   319,   332,   333,   357,
     359,   381,   424,   426,   436,   477,   478,   481,   482,   483,
     484,   524,   525,   543,   714,   717,   718,   719,   720,   721,
     722,   723,  1122,  1122,  1221,    18,  1122,  1231,   337,   403,
     560,   597,    18,  1116,   561,   561,    18,   683,   693,   560,
     950,   247,   971,   859,   561,   561,   561,   560,   729,   729,
     560,   724,   725,   729,   223,   223,   561,   561,   561,   561,
     561,   561,   562,   893,   944,   944,   561,   561,   561,   561,
     561,   561,   562,   561,   561,   561,   561,   561,   562,   561,
     561,   561,   561,   561,   900,   962,   562,   562,   562,   561,
     561,   561,   561,   562,   561,   561,   561,   562,   225,   535,
     885,   561,   561,   561,   561,   561,   561,   561,   561,   561,
     562,   561,   561,   561,   859,   561,   168,   561,   561,   562,
     562,   561,   562,   562,   561,   859,   561,   859,   561,   859,
     561,   561,   562,   561,   561,   859,   547,  1206,   567,   768,
     561,   905,   561,   562,   561,   868,   859,   562,   561,   397,
    1183,  1183,  1183,   108,   859,  1019,  1020,   129,  1091,   241,
     852,   562,  1014,  1018,  1019,  1016,  1010,  1008,  1109,  1122,
    1178,   967,   191,   955,  1121,  1121,   566,   981,   982,  1124,
     428,   554,   380,   393,   423,  1142,   743,  1014,   560,   560,
    1141,   859,   142,   561,   917,   348,   915,   927,   230,   230,
     915,   927,   920,   919,   921,  1027,   950,  1020,   759,   939,
     939,   939,   852,   562,   965,   767,   763,   560,   108,   108,
     712,   742,   714,   960,   561,   705,   750,   560,   560,   729,
     724,   361,   715,   724,   724,    20,    32,    45,   502,   735,
     745,    55,   524,   718,   720,   745,   745,    55,   525,   525,
     528,   724,   716,   729,   729,   745,   560,   729,    23,    63,
      67,   108,   330,   337,   364,   424,   504,   731,   732,   733,
     748,   877,   528,   560,   745,    32,   560,   746,   560,   560,
     729,   560,   725,   730,   567,   561,   562,  1222,  1223,   217,
     225,   350,   617,   618,   619,   620,   854,   105,   223,   381,
     461,   703,   598,  1222,   561,   676,   691,   560,   680,   765,
     766,  1122,   970,   944,   331,   745,   331,   859,   561,   561,
     561,   859,   859,   422,   899,   331,   859,   859,   859,   859,
      40,   371,   561,   859,   944,   859,   859,   859,   859,   859,
     561,   561,   561,   331,   859,  1197,  1122,   561,   905,   855,
     890,    58,   228,   324,   452,   463,   538,  1174,  1175,   535,
    1184,  1184,  1184,   561,   562,  1022,   222,   682,  1013,  1020,
     561,  1200,    44,   197,   952,   986,  1124,   562,   303,    68,
     498,   380,  1143,   476,   476,  1014,  1119,   948,   230,   337,
     923,   927,   927,   337,   925,   859,   859,   560,   961,   940,
     934,  1111,   560,   560,   765,    97,   478,   481,   552,   553,
    1106,  1107,   786,   731,   283,   337,   560,   751,   753,   754,
     755,   331,   331,   433,   509,   544,   726,   727,   728,   560,
     726,   726,   746,    20,   502,   735,   747,   746,   736,   745,
     528,   726,   560,   745,   331,   726,   741,  1119,   327,   734,
    1106,   511,   108,   232,   733,   232,   330,   331,   331,   331,
     331,   726,   331,   726,  1122,  1122,   535,  1225,   420,   560,
    1224,   561,   562,   615,  1116,   496,   613,   614,   616,  1122,
    1225,  1200,   677,   680,   678,   561,   562,   965,   560,   561,
     561,   561,   562,   561,   561,   562,   561,  1104,   561,   562,
     561,   562,   561,   561,   303,   151,   561,   561,   561,   561,
     561,   561,   561,   562,  1209,   561,   857,   476,   476,   476,
      16,  1173,   188,   284,   285,   288,   289,  1185,  1186,  1020,
     232,  1086,   701,   847,   967,   956,  1111,   953,   961,    65,
    1092,   982,   561,   561,  1144,    16,   915,   922,   517,   924,
     517,   943,  1122,   971,   560,   701,   965,   765,   765,   561,
    1108,  1108,   782,   173,   352,   434,   112,   511,   752,  1122,
     755,   561,   561,   728,   769,  1104,   736,   746,   769,   561,
     858,   327,   523,   561,   561,   561,   561,    49,    57,   252,
     854,   854,  1232,   619,  1122,   168,  1119,   561,   562,   615,
     561,  1197,   766,   331,   331,   859,   901,   859,   905,  1174,
     342,   972,   972,   972,   972,  1186,   511,   472,   851,   535,
     562,   957,   965,   859,   967,   135,   145,   343,   475,  1093,
    1094,   249,  1095,   270,   337,   859,   560,   859,   560,   561,
     562,   941,   942,   561,   561,   786,    48,   328,   401,   426,
     756,   756,   561,   562,   561,   562,   561,   858,   745,   746,
     745,   746,    57,   342,    57,   841,   840,   604,   714,   854,
     599,   616,   714,   679,   965,   561,   561,   561,   562,   561,
     561,   561,  1028,  1029,  1113,  1116,    86,   408,  1111,   366,
     974,    44,    44,   135,    44,  1094,   453,   475,  1096,  1097,
     142,   929,   943,   943,  1122,   561,   749,     5,   108,   330,
     753,  1122,   745,  1104,   745,   342,   342,   561,   118,   605,
     606,   877,  1233,   131,   403,  1200,   859,   562,  1014,  1087,
     965,  1122,  1104,  1104,    44,  1104,    44,    44,  1097,   973,
     859,   561,   561,  1200,   118,    60,   157,   209,   229,   242,
     340,   404,   548,   636,   637,   640,   649,   650,   653,   664,
    1118,  1123,  1127,   414,   600,   561,  1029,  1020,   735,   738,
     975,  1104,  1104,  1104,    16,   565,  1122,   171,   323,   642,
     639,  1123,  1123,  1122,   638,   651,   654,   573,    28,   263,
     394,   534,   667,   569,  1227,   714,   737,  1088,   560,   274,
     171,  1122,   644,   645,   859,   859,   532,   656,   660,   668,
     622,   636,   622,   669,   665,   636,   601,  1092,   854,   976,
     977,   978,   142,   222,   138,   859,   652,   661,   546,   660,
     663,   623,   138,   636,   568,   510,   859,   667,   604,  1095,
     859,   561,   562,   972,   641,   209,   547,   532,   655,   657,
     859,   622,   138,   106,   621,   624,   263,   568,   671,   125,
     666,  1123,   602,   210,  1098,   978,   643,  1122,   646,   658,
     657,   663,   662,   548,    80,   150,   629,   634,  1122,   138,
     636,   568,   859,   670,   636,   331,   560,  1099,   562,   622,
     859,   138,   547,   195,   562,   625,    75,    89,   568,   138,
     622,   249,   561,   566,  1100,  1101,  1113,   426,  1102,  1122,
     647,   659,   548,   622,   168,  1122,   714,   168,   168,   394,
     138,  1124,   561,   562,  1028,   132,   546,   648,   547,   626,
     108,   635,   442,   631,   972,   627,   628,   534,  1101,   644,
     622,   622,   441,   443,   630,   631,   633,   877,  1122,   859,
     523,   632,   573,   562,   636,   169,  1120,   633
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1202 "sql_yacc.yy"
    {
	   THD *thd= YYTHD;
	   if (!thd->bootstrap &&
	      (!(thd->lex->select_lex.options & OPTION_FOUND_COMMENT)))
	   {
	     my_message(ER_EMPTY_QUERY, ER(ER_EMPTY_QUERY), MYF(0));
	     MYSQL_YYABORT;
	   }
	   else
	   {
	     thd->lex->sql_command= SQLCOM_EMPTY_QUERY;
	   }
	}
    break;

  case 3:
#line 1215 "sql_yacc.yy"
    {}
    break;

  case 53:
#line 1275 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            my_parse_error(ER(ER_SYNTAX_ERROR));
            MYSQL_YYABORT;
          }
          lex->sql_command= SQLCOM_DEALLOCATE_PREPARE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 56:
#line 1295 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            my_parse_error(ER(ER_SYNTAX_ERROR));
            MYSQL_YYABORT;
          }
          lex->sql_command= SQLCOM_PREPARE;
          lex->prepared_stmt_name= (yyvsp[-2].lex_str);
        }
    break;

  case 57:
#line 1309 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= FALSE;
        }
    break;

  case 58:
#line 1316 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          lex->prepared_stmt_code= (yyvsp[0].lex_str);
          lex->prepared_stmt_code_is_varref= TRUE;
        }
    break;

  case 59:
#line 1325 "sql_yacc.yy"
    {
          THD *thd=YYTHD;
          LEX *lex= thd->lex;
          if (lex->stmt_prepare_mode)
          {
            my_parse_error(ER(ER_SYNTAX_ERROR));
            MYSQL_YYABORT;
          }
          lex->sql_command= SQLCOM_EXECUTE;
          lex->prepared_stmt_name= (yyvsp[0].lex_str);
        }
    break;

  case 60:
#line 1337 "sql_yacc.yy"
    {}
    break;

  case 65:
#line 1351 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          LEX_STRING *lexstr= (LEX_STRING*)sql_memdup(&(yyvsp[0].lex_str), sizeof(LEX_STRING));
          if (!lexstr || lex->prepared_stmt_params.push_back(lexstr))
              MYSQL_YYABORT;
        }
    break;

  case 66:
#line 1363 "sql_yacc.yy"
    {
         if (Lex->sphead)
         {
           my_error(ER_SP_BADSTATEMENT, MYF(0), "HELP");
           MYSQL_YYABORT;
         }
       }
    break;

  case 67:
#line 1371 "sql_yacc.yy"
    {
	  LEX *lex= Lex;
	  lex->sql_command= SQLCOM_HELP;
	  lex->help_arg= (yyvsp[0].lex_str).str;
       }
    break;

  case 68:
#line 1381 "sql_yacc.yy"
    {
	  LEX *lex = Lex;
	  lex->sql_command = SQLCOM_CHANGE_MASTER;
	  bzero((char*) &lex->mi, sizeof(lex->mi));
        }
    break;

  case 69:
#line 1387 "sql_yacc.yy"
    {}
    break;

  case 72:
#line 1396 "sql_yacc.yy"
    {
	 Lex->mi.host = (yyvsp[0].lex_str).str;
       }
    break;

  case 73:
#line 1401 "sql_yacc.yy"
    {
	 Lex->mi.user = (yyvsp[0].lex_str).str;
       }
    break;

  case 74:
#line 1406 "sql_yacc.yy"
    {
	 Lex->mi.password = (yyvsp[0].lex_str).str;
       }
    break;

  case 75:
#line 1411 "sql_yacc.yy"
    {
	 Lex->mi.port = (yyvsp[0].ulong_num);
       }
    break;

  case 76:
#line 1416 "sql_yacc.yy"
    {
	 Lex->mi.connect_retry = (yyvsp[0].ulong_num);
       }
    break;

  case 77:
#line 1420 "sql_yacc.yy"
    {
           Lex->mi.ssl= (yyvsp[0].ulong_num) ? 
               LEX_MASTER_INFO::SSL_ENABLE : LEX_MASTER_INFO::SSL_DISABLE;
         }
    break;

  case 78:
#line 1425 "sql_yacc.yy"
    {
           Lex->mi.ssl_ca= (yyvsp[0].lex_str).str;
         }
    break;

  case 79:
#line 1429 "sql_yacc.yy"
    {
           Lex->mi.ssl_capath= (yyvsp[0].lex_str).str;
         }
    break;

  case 80:
#line 1433 "sql_yacc.yy"
    {
           Lex->mi.ssl_cert= (yyvsp[0].lex_str).str;
         }
    break;

  case 81:
#line 1437 "sql_yacc.yy"
    {
           Lex->mi.ssl_cipher= (yyvsp[0].lex_str).str;
         }
    break;

  case 82:
#line 1441 "sql_yacc.yy"
    {
           Lex->mi.ssl_key= (yyvsp[0].lex_str).str;
	 }
    break;

  case 84:
#line 1450 "sql_yacc.yy"
    {
	 Lex->mi.log_file_name = (yyvsp[0].lex_str).str;
       }
    break;

  case 85:
#line 1454 "sql_yacc.yy"
    {
           Lex->mi.pos = (yyvsp[0].ulonglong_number);
           /* 
              If the user specified a value < BIN_LOG_HEADER_SIZE, adjust it
              instead of causing subsequent errors. 
              We need to do it in this file, because only there we know that 
              MASTER_LOG_POS has been explicitely specified. On the contrary
              in change_master() (sql_repl.cc) we cannot distinguish between 0
              (MASTER_LOG_POS explicitely specified as 0) and 0 (unspecified),
              whereas we want to distinguish (specified 0 means "read the binlog
              from 0" (4 in fact), unspecified means "don't change the position
              (keep the preceding value)").
           */
           Lex->mi.pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.pos);
         }
    break;

  case 86:
#line 1470 "sql_yacc.yy"
    {
           Lex->mi.relay_log_name = (yyvsp[0].lex_str).str;
         }
    break;

  case 87:
#line 1474 "sql_yacc.yy"
    {
           Lex->mi.relay_log_pos = (yyvsp[0].ulong_num);
           /* Adjust if < BIN_LOG_HEADER_SIZE (same comment as Lex->mi.pos) */
           Lex->mi.relay_log_pos = max(BIN_LOG_HEADER_SIZE, Lex->mi.relay_log_pos);
         }
    break;

  case 88:
#line 1485 "sql_yacc.yy"
    {
	  THD *thd= YYTHD;
	  LEX *lex=Lex;
	  lex->sql_command= SQLCOM_CREATE_TABLE;
	  if (!lex->select_lex.add_table_to_list(thd, (yyvsp[0].table), NULL,
						 TL_OPTION_UPDATING,
						 (using_update_log ?
						  TL_READ_NO_INSERT:
						  TL_READ)))
	    MYSQL_YYABORT;
          lex->alter_info.reset();
	  lex->col_list.empty();
	  lex->change=NullS;
	  bzero((char*) &lex->create_info,sizeof(lex->create_info));
	  lex->create_info.options=(yyvsp[-3].num) | (yyvsp[-1].num);
	  lex->create_info.db_type= (enum db_type) lex->thd->variables.table_type;
	  lex->create_info.default_table_charset= NULL;
	  lex->name=0;
	}
    break;

  case 89:
#line 1505 "sql_yacc.yy"
    { Lex->current_select= &Lex->select_lex; }
    break;

  case 90:
#line 1507 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command= SQLCOM_CREATE_INDEX;
	    if (!lex->current_select->add_table_to_list(lex->thd, (yyvsp[0].table), NULL,
							TL_OPTION_UPDATING))
	      MYSQL_YYABORT;
            lex->alter_info.reset();
            lex->alter_info.flags= ALTER_ADD_INDEX;
	    lex->col_list.empty();
	    lex->change=NullS;
	  }
    break;

  case 91:
#line 1519 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-9].key_type), (yyvsp[-7].lex_str).str, (yyvsp[-6].key_alg), 0, lex->col_list);

            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();
	  }
    break;

  case 92:
#line 1527 "sql_yacc.yy"
    {
             Lex->create_info.default_table_charset= NULL;
             Lex->create_info.used_fields= 0;
          }
    break;

  case 93:
#line 1532 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->sql_command=SQLCOM_CREATE_DB;
	    lex->name=(yyvsp[-2].lex_str).str;
            lex->create_info.options=(yyvsp[-3].num);
	  }
    break;

  case 94:
#line 1539 "sql_yacc.yy"
    {
            Lex->create_view_mode= VIEW_CREATE_NEW;
            Lex->create_view_algorithm= VIEW_ALGORITHM_UNDEFINED;
            Lex->create_view_suid= TRUE;
	  }
    break;

  case 95:
#line 1545 "sql_yacc.yy"
    {}
    break;

  case 96:
#line 1547 "sql_yacc.yy"
    {
	    Lex->sql_command = SQLCOM_CREATE_USER;
          }
    break;

  case 97:
#line 1554 "sql_yacc.yy"
    {
          LEX *lex=Lex;
          lex->users_list.empty();
          lex->columns.empty();
          lex->grant= lex->grant_tot_col= 0;
	  lex->all_privileges= 0;
          lex->select_lex.db= 0;
          lex->ssl_type= SSL_TYPE_NOT_SPECIFIED;
          lex->ssl_cipher= lex->x509_subject= lex->x509_issuer= 0;
          bzero((char *)&(lex->mqh),sizeof(lex->mqh));
        }
    break;

  case 98:
#line 1569 "sql_yacc.yy"
    {
            if (!(yyvsp[-2].lex_str).str || check_db_name((yyvsp[-2].lex_str).str))
            {
	      my_error(ER_WRONG_DB_NAME, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spname)= new sp_name((yyvsp[-2].lex_str), (yyvsp[0].lex_str));
	    (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 99:
#line 1584 "sql_yacc.yy"
    {
            THD *thd= YYTHD;
            LEX_STRING db;
	    if (check_routine_name((yyvsp[0].lex_str)))
            {
	      my_error(ER_SP_WRONG_NAME, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
            if (thd->copy_db_to(&db.str, &db.length))
              MYSQL_YYABORT;
	    (yyval.spname)= new sp_name(db, (yyvsp[0].lex_str));
            if ((yyval.spname))
	      (yyval.spname)->init_qname(YYTHD);
	  }
    break;

  case 100:
#line 1602 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            if (lex->definer != NULL)
            {
              /*
                 DEFINER is a concept meaningful when interpreting SQL code.
                 UDF functions are compiled.
                 Using DEFINER with UDF has therefore no semantic,
                 and is considered a parsing error.
              */
	      my_error(ER_WRONG_USAGE, MYF(0), "SONAME", "DEFINER");
              MYSQL_YYABORT;
            }
	    lex->sql_command = SQLCOM_CREATE_FUNCTION;
	    lex->udf.name = lex->spname->m_name;
	    lex->udf.returns=(Item_result) (yyvsp[-2].num);
	    lex->udf.dl=(yyvsp[0].lex_str).str;
	  }
    break;

  case 101:
#line 1621 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp;

            /* 
              First check if AGGREGATE was used, in that case it's a
              syntax error.
            */
            if (lex->udf.type == UDFTYPE_AGGREGATE)
            {
              my_error(ER_SP_NO_AGGREGATE, MYF(0));
              MYSQL_YYABORT;
            }

	    if (lex->sphead)
	    {
	      my_error(ER_SP_NO_RECURSIVE_CREATE, MYF(0), "FUNCTION");
	      MYSQL_YYABORT;
	    }
	    /* Order is important here: new - reset - init */
	    sp= new sp_head();
	    sp->reset_thd_mem_root(YYTHD);
	    sp->init(lex);
            sp->init_sp_name(YYTHD, lex->spname);

	    sp->m_type= TYPE_ENUM_FUNCTION;
	    lex->sphead= sp;
	    /*
	     * We have to turn of CLIENT_MULTI_QUERIES while parsing a
	     * stored procedure, otherwise yylex will chop it into pieces
	     * at each ';'.
	     */
	    sp->m_old_cmq= YYTHD->client_capabilities & CLIENT_MULTI_QUERIES;
	    YYTHD->client_capabilities &= ~CLIENT_MULTI_QUERIES;
	    lex->sphead->m_param_begin= lex->tok_start+1;
	  }
    break;

  case 102:
#line 1658 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_param_end= lex->tok_start;
	  }
    break;

  case 103:
#line 1664 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    lex->charset= NULL;
	    lex->length= lex->dec= NULL;
	    lex->interval_list.empty();
	    lex->type= 0;
	  }
    break;

  case 104:
#line 1672 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->fill_field_definition(YYTHD, lex,
                                          (enum enum_field_types) (yyvsp[0].num),
                                          &sp->m_return_field_def))
              MYSQL_YYABORT;

	    bzero((char *)&lex->sp_chistics, sizeof(st_sp_chistics));
	  }
    break;

  case 105:
#line 1684 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->m_chistics= &lex->sp_chistics;
	    lex->sphead->m_body_begin= lex->tok_start;
	  }
    break;

  case 106:
#line 1691 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            if (sp->is_not_allowed_in_function("function"))
              MYSQL_YYABORT;

	    lex->sql_command= SQLCOM_CREATE_SPFUNCTION;
	    sp->init_strings(YYTHD, lex);
            if (!(sp->m_flags & sp_head::HAS_RETURN))
            {
              my_error(ER_SP_NORETURN, MYF(0), sp->m_qname.str);
              MYSQL_YYABORT;
            }
	    /* Restore flag if it was cleared above */
	    if (sp->m_old_cmq)
	      YYTHD->client_capabilities |= CLIENT_MULTI_QUERIES;
	    sp->restore_thd_mem_root(YYTHD);
	  }
    break;

  case 107:
#line 1713 "sql_yacc.yy"
    {}
    break;

  case 108:
#line 1714 "sql_yacc.yy"
    {}
    break;

  case 109:
#line 1718 "sql_yacc.yy"
    {}
    break;

  case 110:
#line 1719 "sql_yacc.yy"
    {}
    break;

  case 111:
#line 1725 "sql_yacc.yy"
    { Lex->sp_chistics.comment= (yyvsp[0].lex_str); }
    break;

  case 112:
#line 1727 "sql_yacc.yy"
    { /* Just parse it, we only have one language for now. */ }
    break;

  case 113:
#line 1729 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_NO_SQL; }
    break;

  case 114:
#line 1731 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_CONTAINS_SQL; }
    break;

  case 115:
#line 1733 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_READS_SQL_DATA; }
    break;

  case 116:
#line 1735 "sql_yacc.yy"
    { Lex->sp_chistics.daccess= SP_MODIFIES_SQL_DATA; }
    break;

  case 117:
#line 1737 "sql_yacc.yy"
    { }
    break;

  case 118:
#line 1742 "sql_yacc.yy"
    { }
    break;

  case 119:
#line 1743 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= TRUE; }
    break;

  case 120:
#line 1744 "sql_yacc.yy"
    { Lex->sp_chistics.detistic= FALSE; }
    break;

  case 121:
#line 1749 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_SUID;
	  }
    break;

  case 122:
#line 1753 "sql_yacc.yy"
    {
	    Lex->sp_chistics.suid= SP_IS_NOT_SUID;
	  }
    break;

  case 123:
#line 1760 "sql_yacc.yy"
    {
	    LEX *lex = Lex;

	    lex->sql_command= SQLCOM_CALL;
	    lex->spname= (yyvsp[0].spname);
	    lex->value_list.empty();
	    sp_add_used_routine(lex, YYTHD, (yyvsp[0].spname), TYPE_ENUM_PROCEDURE);
	  }
    break;

  case 124:
#line 1768 "sql_yacc.yy"
    {}
    break;

  case 129:
#line 1784 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 130:
#line 1788 "sql_yacc.yy"
    {
	    Lex->value_list.push_back((yyvsp[0].item));
	  }
    break;

  case 135:
#line 1806 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->length= 0;
	    lex->dec= 0;
	    lex->type= 0;
	  
	    lex->default_value= 0;
	    lex->on_update_value= 0;
	  
	    lex->comment= null_lex_str;
	    lex->charset= NULL;
	  
	    lex->interval_list.empty();
	    lex->uint_geom_type= 0;
	  }
    break;

  case 136:
#line 1826 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-2].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-2].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-2].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     sp_param_in);

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 141:
#line 1863 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[-1].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_PARAM, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
            sp_variable_t *spvar= spc->push_variable(&(yyvsp[-1].lex_str),
                                                     (enum enum_field_types)(yyvsp[0].num),
                                                     (sp_param_mode_t)(yyvsp[-3].num));

            if (lex->sphead->fill_field_definition(YYTHD, lex,
                                                   (enum enum_field_types) (yyvsp[0].num),
                                                   &spvar->field_def))
            {
              MYSQL_YYABORT;
            }
            spvar->field_def.field_name= spvar->name.str;
            spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
	  }
    break;

  case 142:
#line 1888 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 143:
#line 1889 "sql_yacc.yy"
    { (yyval.num)= sp_param_in; }
    break;

  case 144:
#line 1890 "sql_yacc.yy"
    { (yyval.num)= sp_param_out; }
    break;

  case 145:
#line 1891 "sql_yacc.yy"
    { (yyval.num)= sp_param_inout; }
    break;

  case 146:
#line 1895 "sql_yacc.yy"
    {}
    break;

  case 148:
#line 1900 "sql_yacc.yy"
    {}
    break;

  case 150:
#line 1906 "sql_yacc.yy"
    {
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	  }
    break;

  case 151:
#line 1910 "sql_yacc.yy"
    {
	    /* We check for declarations out of (standard) order this way
	       because letting the grammar rules reflect it caused tricky
	       shift/reduce conflicts with the wrong result. (And we get
	       better error handling this way.) */
	    if (((yyvsp[-1].spblock).vars || (yyvsp[-1].spblock).conds) && ((yyvsp[-2].spblock).curs || (yyvsp[-2].spblock).hndlrs))
	    { /* Variable or condition following cursor or handler */
	      my_message(ER_SP_VARCOND_AFTER_CURSHNDLR,
                         ER(ER_SP_VARCOND_AFTER_CURSHNDLR), MYF(0));
	      MYSQL_YYABORT;
	    }
	    if ((yyvsp[-1].spblock).curs && (yyvsp[-2].spblock).hndlrs)
	    { /* Cursor following handler */
	      my_message(ER_SP_CURSOR_AFTER_HANDLER,
                         ER(ER_SP_CURSOR_AFTER_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    (yyval.spblock).vars= (yyvsp[-2].spblock).vars + (yyvsp[-1].spblock).vars;
	    (yyval.spblock).conds= (yyvsp[-2].spblock).conds + (yyvsp[-1].spblock).conds;
	    (yyval.spblock).hndlrs= (yyvsp[-2].spblock).hndlrs + (yyvsp[-1].spblock).hndlrs;
	    (yyval.spblock).curs= (yyvsp[-2].spblock).curs + (yyvsp[-1].spblock).curs;
	  }
    break;

  case 152:
#line 1936 "sql_yacc.yy"
    {
            LEX *lex= Lex;

            lex->sphead->reset_lex(YYTHD);
            lex->spcont->declare_var_boundary((yyvsp[0].num));
          }
    break;

  case 153:
#line 1944 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_pcontext *pctx= lex->spcont;
            uint num_vars= pctx->context_var_count();
            enum enum_field_types var_type= (enum enum_field_types) (yyvsp[-1].num);
            Item *dflt_value_item= (yyvsp[0].item);
            
            if (!dflt_value_item)
            {
              dflt_value_item= new Item_null();
              /* QQ Set to the var_type with null_value? */
            }
            
            for (uint i = num_vars-(yyvsp[-3].num) ; i < num_vars ; i++)
            {
              uint var_idx= pctx->var_context2runtime(i);
              sp_variable_t *spvar= pctx->find_variable(var_idx);
            
              if (!spvar)
                MYSQL_YYABORT;
            
              spvar->type= var_type;
              spvar->dflt= dflt_value_item;
            
              if (lex->sphead->fill_field_definition(YYTHD, lex, var_type,
                                                     &spvar->field_def))
              {
                MYSQL_YYABORT;
              }
            
              spvar->field_def.field_name= spvar->name.str;
              spvar->field_def.pack_flag |= FIELDFLAG_MAYBE_NULL;
            
              /* The last instruction is responsible for freeing LEX. */

              lex->sphead->add_instr(
                new sp_instr_set(lex->sphead->instructions(), pctx, var_idx,
                                 dflt_value_item, var_type, lex,
                                 (i == num_vars - 1)));
            }

            pctx->declare_var_boundary(0);
            lex->sphead->restore_lex(YYTHD);

            (yyval.spblock).vars= (yyvsp[-3].num);
            (yyval.spblock).conds= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
          }
    break;

  case 154:
#line 1992 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_cond(&(yyvsp[-3].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_COND, MYF(0), (yyvsp[-3].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    YYTHD->lex->spcont->push_cond(&(yyvsp[-3].lex_str), (yyvsp[0].spcondtype));
	    (yyval.spblock).vars= (yyval.spblock).hndlrs= (yyval.spblock).curs= 0;
	    (yyval.spblock).conds= 1;
	  }
    break;

  case 155:
#line 2006 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_instr_hpush_jump *i=
              new sp_instr_hpush_jump(sp->instructions(), ctx, (yyvsp[-2].num),
	                              ctx->current_var_count());

	    sp->add_instr(i);
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	    sp->m_flags|= sp_head::IN_HANDLER;
	  }
    break;

  case 156:
#line 2019 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *hlab= lex->spcont->pop_label(); /* After this hdlr */
	    sp_instr_hreturn *i;

	    if ((yyvsp[-5].num) == SP_HANDLER_CONTINUE)
	    {
	      i= new sp_instr_hreturn(sp->instructions(), ctx,
	                              ctx->current_var_count());
	      sp->add_instr(i);
	    }
	    else
	    {  /* EXIT or UNDO handler, just jump to the end of the block */
	      i= new sp_instr_hreturn(sp->instructions(), ctx, 0);

	      sp->add_instr(i);
	      sp->push_backpatch(i, lex->spcont->last_label()); /* Block end */
	    }
	    lex->sphead->backpatch(hlab);
	    sp->m_flags&= ~sp_head::IN_HANDLER;
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).curs= 0;
	    (yyval.spblock).hndlrs= (yyvsp[-1].num);
	    ctx->add_handlers((yyvsp[-1].num));
	  }
    break;

  case 157:
#line 2046 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint offp;
	    sp_instr_cpush *i;

	    if (ctx->find_cursor(&(yyvsp[-3].lex_str), &offp, TRUE))
	    {
	      my_error(ER_SP_DUP_CURS, MYF(0), (yyvsp[-3].lex_str).str);
	      delete (yyvsp[0].lex);
	      MYSQL_YYABORT;
	    }
            i= new sp_instr_cpush(sp->instructions(), ctx, (yyvsp[0].lex),
                                  ctx->current_cursor_count());
	    sp->add_instr(i);
	    ctx->push_cursor(&(yyvsp[-3].lex_str));
	    (yyval.spblock).vars= (yyval.spblock).conds= (yyval.spblock).hndlrs= 0;
	    (yyval.spblock).curs= 1;
	  }
    break;

  case 158:
#line 2069 "sql_yacc.yy"
    {
	    Lex->sphead->reset_lex(YYTHD);

	    /* We use statement here just be able to get a better
	       error message. Using 'select' works too, but will then
	       result in a generic "syntax error" if a non-select
	       statement is given. */
	  }
    break;

  case 159:
#line 2078 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if (lex->sql_command != SQLCOM_SELECT)
	    {
	      my_message(ER_SP_BAD_CURSOR_QUERY, ER(ER_SP_BAD_CURSOR_QUERY),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    if (lex->result)
	    {
	      my_message(ER_SP_BAD_CURSOR_SELECT, ER(ER_SP_BAD_CURSOR_SELECT),
                         MYF(0));
	      MYSQL_YYABORT;
	    }
	    lex->sp_lex_in_use= TRUE;
	    (yyval.lex)= lex;
	    lex->sphead->restore_lex(YYTHD);
	  }
    break;

  case 160:
#line 2100 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_EXIT; }
    break;

  case 161:
#line 2101 "sql_yacc.yy"
    { (yyval.num)= SP_HANDLER_CONTINUE; }
    break;

  case 162:
#line 2107 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
                (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= 1;
	    }
	  }
    break;

  case 163:
#line 2128 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

	    if (ctx->find_handler((yyvsp[0].spcondtype)))
	    {
	      my_message(ER_SP_DUP_HANDLER, ER(ER_SP_DUP_HANDLER), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_hpush_jump *i=
	        (sp_instr_hpush_jump *)sp->last_instruction();

	      i->add_condition((yyvsp[0].spcondtype));
	      ctx->push_handler((yyvsp[0].spcondtype));
	      (yyval.num)= (yyvsp[-2].num) + 1;
	    }
	  }
    break;

  case 164:
#line 2152 "sql_yacc.yy"
    {			/* mysql errno */
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::number;
	    (yyval.spcondtype)->mysqlerr= (yyvsp[0].ulong_num);
	  }
    break;

  case 165:
#line 2158 "sql_yacc.yy"
    {		/* SQLSTATE */
	    if (!sp_cond_check(&(yyvsp[0].lex_str)))
	    {
	      my_error(ER_SP_BAD_SQLSTATE, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::state;
	    memcpy((yyval.spcondtype)->sqlstate, (yyvsp[0].lex_str).str, 5);
	    (yyval.spcondtype)->sqlstate[5]= '\0';
	  }
    break;

  case 166:
#line 2172 "sql_yacc.yy"
    {}
    break;

  case 167:
#line 2173 "sql_yacc.yy"
    {}
    break;

  case 168:
#line 2178 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (yyvsp[0].spcondtype);
	  }
    break;

  case 169:
#line 2182 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= Lex->spcont->find_cond(&(yyvsp[0].lex_str));
	    if ((yyval.spcondtype) == NULL)
	    {
	      my_error(ER_SP_COND_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	  }
    break;

  case 170:
#line 2191 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::warning;
	  }
    break;

  case 171:
#line 2196 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::notfound;
	  }
    break;

  case 172:
#line 2201 "sql_yacc.yy"
    {
	    (yyval.spcondtype)= (sp_cond_type_t *)YYTHD->alloc(sizeof(sp_cond_type_t));
	    (yyval.spcondtype)->type= sp_cond_type_t::exception;
	  }
    break;

  case 173:
#line 2209 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= 1;
	  }
    break;

  case 174:
#line 2224 "sql_yacc.yy"
    {
            /* NOTE: field definition is filled in sp_decl section. */

	    LEX *lex= Lex;
	    sp_pcontext *spc= lex->spcont;

	    if (spc->find_variable(&(yyvsp[0].lex_str), TRUE))
	    {
	      my_error(ER_SP_DUP_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    spc->push_variable(&(yyvsp[0].lex_str), (enum_field_types)0, sp_param_in);
	    (yyval.num)= (yyvsp[-2].num) + 1;
	  }
    break;

  case 175:
#line 2241 "sql_yacc.yy"
    { (yyval.item) = NULL; }
    break;

  case 176:
#line 2242 "sql_yacc.yy"
    { (yyval.item) = (yyvsp[0].item); }
    break;

  case 177:
#line 2246 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->reset_lex(YYTHD);
	    lex->sphead->m_tmp_query= lex->tok_start;
	  }
    break;

  case 178:
#line 2253 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

            sp->m_flags|= sp_get_flags_for_command(lex);
	    if (lex->sql_command == SQLCOM_CHANGE_DB)
	    { /* "USE db" doesn't work in a procedure */
	      my_error(ER_SP_BADSTATEMENT, MYF(0), "USE");
	      MYSQL_YYABORT;
	    }
	    /*
              Don't add an instruction for SET statements, since all
              instructions for them were already added during processing
              of "set" rule.
	    */
            DBUG_ASSERT(lex->sql_command != SQLCOM_SET_OPTION ||
                        lex->var_list.is_empty());
            if (lex->sql_command != SQLCOM_SET_OPTION)
	    {
              sp_instr_stmt *i=new sp_instr_stmt(sp->instructions(),
                                                 lex->spcont, lex);

              /*
                Extract the query statement from the tokenizer.  The
                end is either lex->ptr, if there was no lookahead,
                lex->tok_end otherwise.
              */
              if (yychar == YYEMPTY)
                i->m_query.length= lex->ptr - sp->m_tmp_query;
              else
                i->m_query.length= lex->tok_end - sp->m_tmp_query;
              i->m_query.str= strmake_root(YYTHD->mem_root,
                                           (char *)sp->m_tmp_query,
                                           i->m_query.length);
              sp->add_instr(i);
            }
	    sp->restore_lex(YYTHD);
          }
    break;

  case 179:
#line 2292 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 180:
#line 2294 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;

	    if (sp->m_type != TYPE_ENUM_FUNCTION)
	    {
	      my_message(ER_SP_BADRETURN, ER(ER_SP_BADRETURN), MYF(0));
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_freturn *i;

	      i= new sp_instr_freturn(sp->instructions(), lex->spcont, (yyvsp[0].item),
                                      sp->m_return_field_def.sql_type, lex);
	      sp->add_instr(i);
	      sp->m_flags|= sp_head::HAS_RETURN;
	    }
	    sp->restore_lex(YYTHD);
	  }
    break;

  case 181:
#line 2315 "sql_yacc.yy"
    { Lex->sphead->new_cont_backpatch(NULL); }
    break;

  case 182:
#line 2317 "sql_yacc.yy"
    { Lex->sphead->do_cont_backpatch(); }
    break;

  case 184:
#line 2320 "sql_yacc.yy"
    {}
    break;

  case 185:
#line 2321 "sql_yacc.yy"
    { /* Unlabeled controls get a secret label. */
	    LEX *lex= Lex;

	    lex->spcont->push_label((char *)"", lex->sphead->instructions());
	  }
    break;

  case 186:
#line 2327 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 187:
#line 2333 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp = lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "LEAVE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, TRUE);  /* Exclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx);
	      sp->push_backpatch(i, lab);  /* Jumping forward */
              sp->add_instr(i);
	    }
	  }
    break;

  case 188:
#line 2362 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[0].lex_str).str);

	    if (! lab || lab->type != SP_LAB_ITER)
	    {
	      my_error(ER_SP_LILABEL_MISMATCH, MYF(0), "ITERATE", (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      sp_instr_jump *i;
	      uint ip= sp->instructions();
	      uint n;

	      n= ctx->diff_handlers(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_hpop(ip++, ctx, n));
	      n= ctx->diff_cursors(lab->ctx, FALSE);  /* Inclusive the dest. */
	      if (n)
	        sp->add_instr(new sp_instr_cpop(ip++, ctx, n));
	      i= new sp_instr_jump(ip, ctx, lab->ip); /* Jump back */
              sp->add_instr(i);
	    }
	  }
    break;

  case 189:
#line 2390 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_copen *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_copen(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 190:
#line 2405 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cfetch *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[-1].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cfetch(sp->instructions(), lex->spcont, offset);
	    sp->add_instr(i);
	  }
    break;

  case 191:
#line 2420 "sql_yacc.yy"
    { }
    break;

  case 192:
#line 2422 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint offset;
	    sp_instr_cclose *i;

	    if (! lex->spcont->find_cursor(&(yyvsp[0].lex_str), &offset))
	    {
	      my_error(ER_SP_CURSOR_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    i= new sp_instr_cclose(sp->instructions(), lex->spcont,  offset);
	    sp->add_instr(i);
	  }
    break;

  case 196:
#line 2446 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 197:
#line 2467 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *spc= lex->spcont;
	    sp_variable_t *spv;

	    if (!spc || !(spv = spc->find_variable(&(yyvsp[0].lex_str))))
	    {
	      my_error(ER_SP_UNDECLARED_VAR, MYF(0), (yyvsp[0].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      /* An SP local variable */
	      sp_instr_cfetch *i= (sp_instr_cfetch *)sp->last_instruction();

	      i->add_to_varlist(spv);
	    }
	  }
    break;

  case 198:
#line 2489 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 199:
#line 2491 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, ctx,
                                                               (yyvsp[-1].item), lex);

	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
            sp->add_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 200:
#line 2505 "sql_yacc.yy"
    {
	    sp_head *sp= Lex->sphead;
	    sp_pcontext *ctx= Lex->spcont;
	    uint ip= sp->instructions();
	    sp_instr_jump *i = new sp_instr_jump(ip, ctx);

	    sp->add_instr(i);
	    sp->backpatch(ctx->pop_label());
	    sp->push_backpatch(i, ctx->push_label((char *)"", 0));
	  }
    break;

  case 201:
#line 2516 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 207:
#line 2536 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
            lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 208:
#line 2542 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            if (case_stmt_action_expr(lex, (yyvsp[0].item)))
              MYSQL_YYABORT;

            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 209:
#line 2553 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, true);
          }
    break;

  case 210:
#line 2561 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_case(lex);
          }
    break;

  case 211:
#line 2569 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_end_case(lex, false);
          }
    break;

  case 216:
#line 2587 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 217:
#line 2591 "sql_yacc.yy"
    {
            /* Simple case: <caseval> = <whenval> */

            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), true);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 218:
#line 2600 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 219:
#line 2608 "sql_yacc.yy"
    {
            Lex->sphead->reset_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 220:
#line 2612 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_when(lex, (yyvsp[0].item), false);
            lex->sphead->restore_lex(YYTHD); /* For expr $3 */
          }
    break;

  case 221:
#line 2619 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            case_stmt_action_then(lex);
          }
    break;

  case 222:
#line 2627 "sql_yacc.yy"
    {
            LEX *lex= Lex;
            sp_head *sp= lex->sphead;
            uint ip= sp->instructions();
            sp_instr_error *i= new sp_instr_error(ip, lex->spcont,
                                                  ER_SP_CASE_NOT_FOUND);
            sp->add_instr(i);
          }
    break;

  case 224:
#line 2640 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_pcontext *ctx= lex->spcont;
	    sp_label_t *lab= ctx->find_label((yyvsp[-1].lex_str).str);

	    if (lab)
	    {
	      my_error(ER_SP_LABEL_REDEFINE, MYF(0), (yyvsp[-1].lex_str).str);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      lab= lex->spcont->push_label((yyvsp[-1].lex_str).str,
	                                   lex->sphead->instructions());
	      lab->type= SP_LAB_ITER;
	    }
	  }
    break;

  case 225:
#line 2658 "sql_yacc.yy"
    {
	    LEX *lex= Lex;

	    if ((yyvsp[0].lex_str).str)
	    {
	      sp_label_t *lab= lex->spcont->find_label((yyvsp[0].lex_str).str);

	      if (!lab ||
	          my_strcasecmp(system_charset_info, (yyvsp[0].lex_str).str, lab->name) != 0)
	      {
	        my_error(ER_SP_LABEL_MISMATCH, MYF(0), (yyvsp[0].lex_str).str);
	        MYSQL_YYABORT;
	      }
	    }
	    lex->sphead->backpatch(lex->spcont->pop_label());
	  }
    break;

  case 226:
#line 2677 "sql_yacc.yy"
    { (yyval.lex_str)= null_lex_str; }
    break;

  case 227:
#line 2678 "sql_yacc.yy"
    { (yyval.lex_str)= (yyvsp[0].lex_str); }
    break;

  case 228:
#line 2683 "sql_yacc.yy"
    { /* QQ This is just a dummy for grouping declarations and statements
	       together. No [[NOT] ATOMIC] yet, and we need to figure out how
	       make it coexist with the existing BEGIN COMMIT/ROLLBACK. */
	    LEX *lex= Lex;
	    sp_label_t *lab= lex->spcont->last_label();

	    lab->type= SP_LAB_BEGIN;
	    lex->spcont= lex->spcont->push_context();
	  }
    break;

  case 229:
#line 2695 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    sp_pcontext *ctx= lex->spcont;

  	    sp->backpatch(ctx->last_label());	/* We always have a label */
	    if ((yyvsp[-2].spblock).hndlrs)
	      sp->add_instr(new sp_instr_hpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).hndlrs));
	    if ((yyvsp[-2].spblock).curs)
	      sp->add_instr(new sp_instr_cpop(sp->instructions(), ctx,
					      (yyvsp[-2].spblock).curs));
	    lex->spcont= ctx->pop_context();
	  }
    break;

  case 230:
#line 2711 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
	  }
    break;

  case 231:
#line 2720 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 232:
#line 2722 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    sp_head *sp= lex->sphead;
	    uint ip= sp->instructions();
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
							       (yyvsp[-1].item), lex);

	    /* Jumping forward */
	    sp->push_backpatch(i, lex->spcont->last_label());
            sp->new_cont_backpatch(i);
            sp->add_instr(i);
            sp->restore_lex(YYTHD);
	  }
    break;

  case 233:
#line 2736 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump *i = new sp_instr_jump(ip, lex->spcont, lab->ip);

	    lex->sphead->add_instr(i);
            lex->sphead->do_cont_backpatch();
	  }
    break;

  case 234:
#line 2746 "sql_yacc.yy"
    { Lex->sphead->reset_lex(YYTHD); }
    break;

  case 235:
#line 2748 "sql_yacc.yy"
    {
	    LEX *lex= Lex;
	    uint ip= lex->sphead->instructions();
	    sp_label_t *lab= lex->spcont->last_label();  /* Jumping back */
	    sp_instr_jump_if_not *i = new sp_instr_jump_if_not(ip, lex->spcont,
                                                               (yyvsp[-2].item), lab->ip,
                                                               lex);
            lex->sphead->add_instr(i);
            lex->sphead->restore_lex(YYTHD);
            /* We can shortcut the cont_backpatch here */
            i->m_cont_dest= ip+1;
	  }
    break;

  case 236:
#line 2764 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_BEFORE; }
    break;

  case 237:
#line 2766 "sql_yacc.yy"
    { Lex->trg_chistics.action_time= TRG_ACTION_AFTER; }
    break;

  case 238:
#line 2771 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_INSERT; }
    break;

  case 239:
#line 2773 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_UPDATE; }
    break;

  case 240:
#line 2775 "sql_yacc.yy"
    { Lex->trg_chistics.event= TRG_EVENT_DELETE; }
    break;

  case 241:
#line 2779 "sql_yacc.yy"
    {}
    break;

  case 242:
#line 2780 "sql_yacc.yy"
    {}
    break;

  case 243:
#line 2782 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[0].table)))
              MYSQL_YYABORT;
            if ((yyvsp[0].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[0].table)->db.str), &((yyvsp[0].table)->db.length)))
            {
              MYSQL_YYABORT;
            }
          }
    break;

  case 244:
#line 2794 "sql_yacc.yy"
    {
            LEX *lex=Lex;
            THD *thd= lex->thd;
            if (!(lex->name= (char *)(yyvsp[-1].table)))
              MYSQL_YYABORT;
            if ((yyvsp[-1].table)->db.str == NULL &&
                thd->copy_db_to(&((yyvsp[-1].table)->db.str), &((yyvsp[-1].table)->db.length)))
            {
              MYSQL_YYABORT;
            }
          }
    break;

  case 245:
#line 2808 "sql_yacc.yy"
    {}
    break;

  case 246:
#line 2809 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 247:
#line 2809 "sql_yacc.yy"
    {}
    break;

  case 248:
#line 2813 "sql_yacc.yy"
    {}
    break;

  case 249:
#line 2815 "sql_yacc.yy"
    { Select->set_braces(0);}
    break;

  case 250:
#line 2815 "sql_yacc.yy"
    {}
    break;

  case 251:
#line 2817 "sql_yacc.yy"
    { Select->set_braces(1);}
    break;

  case 252:
#line 2817 "sql_yacc.yy"
    {}
    break;

  case 253:
#line 2822 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->lock_option= using_update_log ? TL_READ_NO_INSERT : TL_READ;
	    if (lex->sql_command == SQLCOM_INSERT)
	      lex->sql_command= SQLCOM_INSERT_SELECT;
	    else if (lex->sql_command == SQLCOM_REPLACE)
	      lex->sql_command= SQLCOM_REPLACE_SELECT;
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    lex->current_select->table_list.save_and_clear(&lex->save_list);
	    mysql_init_select(lex);
	    lex->current_select->parsing_place= SELECT_LIST;
          }
    break;

  case 254:
#line 2838 "sql_yacc.yy"
    {
	    Select->parsing_place= NO_MATTER;
	  }
    break;

  case 255:
#line 2842 "sql_yacc.yy"
    {
	    /*
              The following work only with the local list, the global list
              is created correctly in this case
	    */
	    Lex->current_select->table_list.push_front(&Lex->save_list);
	  }
    break;

  case 256:
#line 2852 "sql_yacc.yy"
    {}
    break;

  case 257:
#line 2853 "sql_yacc.yy"
    {}
    break;

  case 258:
#line 2856 "sql_yacc.yy"
    {}
    break;

  case 259:
#line 2857 "sql_yacc.yy"
    {}
    break;

  case 260:
#line 2860 "sql_yacc.yy"
    {}
    break;

  case 261:
#line 2861 "sql_yacc.yy"
    {}
    break;

  case 262:
#line 2864 "sql_yacc.yy"
    {}
    break;

  case 263:
#line 2865 "sql_yacc.yy"
    {}
    break;

  case 264:
#line 2868 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 265:
#line 2869 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[0].num);}
    break;

  case 266:
#line 2872 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[0].num); }
    break;

  case 267:
#line 2873 "sql_yacc.yy"
    { (yyval.num)= (yyvsp[-1].num) | (yyvsp[0].num); }
    break;

  case 268:
#line 2876 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_TMP_TABLE; }
    break;

  case 269:
#line 2879 "sql_yacc.yy"
    { (yyval.num)= 0; }
    break;

  case 270:
#line 2880 "sql_yacc.yy"
    { (yyval.num)=HA_LEX_CREATE_IF_NOT_EXISTS; }
    break;

  case 278:
#line 2896 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 279:
#line 2897 "sql_yacc.yy"
    { Lex->create_info.db_type= (yyvsp[0].db_type); WARN_DEPRECATED("TYPE=storage_engine","ENGINE=storage_engine");   Lex->create_info.used_fields|= HA_CREATE_USED_ENGINE; }
    break;

  case 280:
#line 2898 "sql_yacc.yy"
    { Lex->create_info.max_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MAX_ROWS;}
    break;

  case 281:
#line 2899 "sql_yacc.yy"
    { Lex->create_info.min_rows= (yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_MIN_ROWS;}
    break;

  case 282:
#line 2900 "sql_yacc.yy"
    { Lex->create_info.avg_row_length=(yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_AVG_ROW_LENGTH;}
    break;

  case 283:
#line 2901 "sql_yacc.yy"
    { Lex->create_info.password=(yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_PASSWORD; }
    break;

  case 284:
#line 2902 "sql_yacc.yy"
    { Lex->create_info.comment=(yyvsp[0].lex_str); Lex->create_info.used_fields|= HA_CREATE_USED_COMMENT; }
    break;

  case 285:
#line 2903 "sql_yacc.yy"
    { Lex->create_info.auto_increment_value=(yyvsp[0].ulonglong_number); Lex->create_info.used_fields|= HA_CREATE_USED_AUTO;}
    break;

  case 286:
#line 2905 "sql_yacc.yy"
    {
            switch((yyvsp[0].ulong_num)) {
            case 0:
                Lex->create_info.table_options|= HA_OPTION_NO_PACK_KEYS;
                break;
            case 1:
                Lex->create_info.table_options|= HA_OPTION_PACK_KEYS;
                break;
            default:
                my_parse_error(ER(ER_SYNTAX_ERROR));
                MYSQL_YYABORT;
            }
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 287:
#line 2920 "sql_yacc.yy"
    {
            Lex->create_info.table_options&=
              ~(HA_OPTION_PACK_KEYS | HA_OPTION_NO_PACK_KEYS);
            Lex->create_info.used_fields|= HA_CREATE_USED_PACK_KEYS;
          }
    break;

  case 288:
#line 2925 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_CHECKSUM : HA_OPTION_NO_CHECKSUM; Lex->create_info.used_fields|= HA_CREATE_USED_CHECKSUM; }
    break;

  case 289:
#line 2926 "sql_yacc.yy"
    { Lex->create_info.table_options|= (yyvsp[0].ulong_num) ? HA_OPTION_DELAY_KEY_WRITE : HA_OPTION_NO_DELAY_KEY_WRITE;  Lex->create_info.used_fields|= HA_CREATE_USED_DELAY_KEY_WRITE; }
    break;

  case 290:
#line 2927 "sql_yacc.yy"
    { Lex->create_info.row_type= (yyvsp[0].row_type);  Lex->create_info.used_fields|= HA_CREATE_USED_ROW_FORMAT; }
    break;

  case 291:
#line 2929 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_TYPE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 292:
#line 2934 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKS", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 293:
#line 2939 "sql_yacc.yy"
    {
	    my_error(ER_WARN_DEPRECATED_SYNTAX, MYF(0), "RAID_CHUNKSIZE", "PARTITION");
	    MYSQL_YYABORT;
	  }
    break;

  case 294:
#line 2944 "sql_yacc.yy"
    {
	    /* Move the union list to the merge_list */
	    LEX *lex=Lex;
	    TABLE_LIST *table_list= lex->select_lex.get_table_list();
	    lex->create_info.merge_list= lex->select_lex.table_list;
	    lex->create_info.merge_list.elements--;
	    lex->create_info.merge_list.first=
	      (byte*) (table_list->next_local);
	    lex->select_lex.table_list.elements=1;
	    lex->select_lex.table_list.next=
	      (byte**) &(table_list->next_local);
	    table_list->next_local= 0;
	    lex->create_info.used_fields|= HA_CREATE_USED_UNION;
	  }
    break;

  case 297:
#line 2960 "sql_yacc.yy"
    { Lex->create_info.merge_insert_method= (yyvsp[0].ulong_num); Lex->create_info.used_fields|= HA_CREATE_USED_INSERT_METHOD;}
    break;

  case 298:
#line 2961 "sql_yacc.yy"
    { Lex->create_info.data_file_name= (yyvsp[0].lex_str).str; Lex->create_info.used_fields|= HA_CREATE_USED_DATADIR; }
    break;

  case 299:
#line 2962 "sql_yacc.yy"
    { Lex->create_info.index_file_name= (yyvsp[0].lex_str).str;  Lex->create_info.used_fields|= HA_CREATE_USED_INDEXDIR; }
    break;

  case 300:
#line 2963 "sql_yacc.yy"
    { Lex->create_info.connect_string.str= (yyvsp[0].lex_str).str; Lex->create_info.connect_string.length= (yyvsp[0].lex_str).length;  Lex->create_info.used_fields|= HA_CREATE_USED_CONNECTION; }
    break;

  case 301:
#line 2968 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
          {
            my_error(ER_CONFLICTING_DECLARATIONS, MYF(0),
                     "CHARACTER SET ", cinfo->default_table_charset->csname,
                     "CHARACTER SET ", (yyvsp[0].charset)->csname);
            MYSQL_YYABORT;
          }
	  Lex->create_info.default_table_charset= (yyvsp[0].charset);
          Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 302:
#line 2985 "sql_yacc.yy"
    {
          HA_CREATE_INFO *cinfo= &Lex->create_info;
          if ((cinfo->used_fields & HA_CREATE_USED_DEFAULT_CHARSET) &&
               cinfo->default_table_charset && (yyvsp[0].charset) &&
               !my_charset_same(cinfo->default_table_charset,(yyvsp[0].charset)))
            {
              my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name, cinfo->default_table_charset->csname);
              MYSQL_YYABORT;
            }
            Lex->create_info.default_table_charset= (yyvsp[0].charset);
            Lex->create_info.used_fields|= HA_CREATE_USED_DEFAULT_CHARSET;
        }
    break;

  case 303:
#line 3001 "sql_yacc.yy"
    {
	  (yyval.db_type) = ha_resolve_by_name((yyvsp[0].lex_str).str,(yyvsp[0].lex_str).length);
	  if ((yyval.db_type) == DB_TYPE_UNKNOWN) {
	    my_error(ER_UNKNOWN_STORAGE_ENGINE, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 304:
#line 3010 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DEFAULT; }
    break;

  case 305:
#line 3011 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_FIXED; }
    break;

  case 306:
#line 3012 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_DYNAMIC; }
    break;

  case 307:
#line 3013 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPRESSED; }
    break;

  case 308:
#line 3014 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_REDUNDANT; }
    break;

  case 309:
#line 3015 "sql_yacc.yy"
    { (yyval.row_type)= ROW_TYPE_COMPACT; }
    break;

  case 310:
#line 3018 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 311:
#line 3019 "sql_yacc.yy"
    { (yyval.ulong_num)= RAID_TYPE_0; }
    break;

  case 312:
#line 3020 "sql_yacc.yy"
    { (yyval.ulong_num)=(yyvsp[0].ulong_num);}
    break;

  case 313:
#line 3023 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_DISABLED; }
    break;

  case 314:
#line 3024 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_FIRST; }
    break;

  case 315:
#line 3025 "sql_yacc.yy"
    { (yyval.ulong_num)= MERGE_INSERT_TO_LAST; }
    break;

  case 316:
#line 3028 "sql_yacc.yy"
    {}
    break;

  case 318:
#line 3032 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_FUNCTION; }
    break;

  case 319:
#line 3033 "sql_yacc.yy"
    { (yyval.udf_type) = UDFTYPE_AGGREGATE; }
    break;

  case 320:
#line 3036 "sql_yacc.yy"
    {(yyval.num) = (int) STRING_RESULT; }
    break;

  case 321:
#line 3037 "sql_yacc.yy"
    {(yyval.num) = (int) REAL_RESULT; }
    break;

  case 322:
#line 3038 "sql_yacc.yy"
    {(yyval.num) = (int) DECIMAL_RESULT; }
    break;

  case 323:
#line 3039 "sql_yacc.yy"
    {(yyval.num) = (int) INT_RESULT; }
    break;

  case 329:
#line 3054 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 330:
#line 3061 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            Key *key= new Key((yyvsp[-5].key_type), (yyvsp[-4].simple_string), (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);

	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 331:
#line 3069 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string):(yyvsp[-6].simple_string);
            Key *key= new Key((yyvsp[-5].key_type), key_name, (yyvsp[-3].key_alg), 0, lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 332:
#line 3077 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
            const char *key_name= (yyvsp[-4].simple_string) ? (yyvsp[-4].simple_string) : (yyvsp[-7].simple_string);
            Key *key= new foreign_key(key_name, lex->col_list,
                                      (yyvsp[0].table),
                                      lex->ref_list,
                                      lex->fk_delete_opt,
                                      lex->fk_update_opt,
                                      lex->fk_match_option);
            lex->alter_info.key_list.push_back(key);
            key= new Key(Key::MULTIPLE, key_name,
                         HA_KEY_ALG_UNDEF, 1,
                         lex->col_list);
            lex->alter_info.key_list.push_back(key);
	    lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 333:
#line 3094 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 334:
#line 3098 "sql_yacc.yy"
    {
	    Lex->col_list.empty();		/* Alloced by sql_alloc */
	  }
    break;

  case 338:
#line 3113 "sql_yacc.yy"
    { (yyval.simple_string)=(char*) 0; }
    break;

  case 339:
#line 3114 "sql_yacc.yy"
    { (yyval.simple_string)= (yyvsp[0].simple_string); }
    break;

  case 340:
#line 3118 "sql_yacc.yy"
    { (yyval.simple_string)=(yyvsp[0].simple_string); }
    break;

  case 341:
#line 3123 "sql_yacc.yy"
    {
	   LEX *lex=Lex;
	   lex->length=lex->dec=0; lex->type=0;
	   lex->default_value= lex->on_update_value= 0;
           lex->comment=null_lex_str;
	   lex->charset=NULL;
	 }
    break;

  case 342:
#line 3131 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  if (add_field_to_list(lex->thd, (yyvsp[-3].lex_str).str,
				(enum enum_field_types) (yyvsp[-1].num),
				lex->length,lex->dec,lex->type,
				lex->default_value, lex->on_update_value, 
                                &lex->comment,
				lex->change,&lex->interval_list,lex->charset,
				lex->uint_geom_type))
	    MYSQL_YYABORT;
	}
    break;

  case 343:
#line 3144 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 344:
#line 3145 "sql_yacc.yy"
    { (yyval.num)=(yyvsp[-2].num); }
    break;

  case 345:
#line 3146 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_FLOAT; }
    break;

  case 346:
#line 3147 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 347:
#line 3149 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str;
					  (yyval.num)=FIELD_TYPE_BIT; }
    break;

  case 348:
#line 3151 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 349:
#line 3153 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 350:
#line 3155 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 351:
#line 3157 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 352:
#line 3159 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 353:
#line 3162 "sql_yacc.yy"
    { Lex->length=(char*) "1";
					  (yyval.num)=FIELD_TYPE_STRING;
					  Lex->charset=national_charset_info; }
    break;

  case 354:
#line 3165 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 355:
#line 3168 "sql_yacc.yy"
    { Lex->length= (char*) "1";
					  Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_STRING; }
    break;

  case 356:
#line 3171 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 357:
#line 3173 "sql_yacc.yy"
    { Lex->length=(yyvsp[-2].lex_str).str;
					  (yyval.num)= MYSQL_TYPE_VARCHAR;
					  Lex->charset=national_charset_info; }
    break;

  case 358:
#line 3176 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str;
					  Lex->charset=&my_charset_bin;
					  (yyval.num)= MYSQL_TYPE_VARCHAR; }
    break;

  case 359:
#line 3179 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_YEAR; }
    break;

  case 360:
#line 3180 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATE; }
    break;

  case 361:
#line 3181 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TIME; }
    break;

  case 362:
#line 3183 "sql_yacc.yy"
    {
	    if (YYTHD->variables.sql_mode & MODE_MAXDB)
	      (yyval.num)=FIELD_TYPE_DATETIME;
	    else
            {
              /* 
                Unlike other types TIMESTAMP fields are NOT NULL by default.
              */
              Lex->type|= NOT_NULL_FLAG;
	      (yyval.num)=FIELD_TYPE_TIMESTAMP;
            }
	   }
    break;

  case 363:
#line 3195 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DATETIME; }
    break;

  case 364:
#line 3196 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 365:
#line 3198 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 366:
#line 3201 "sql_yacc.yy"
    {
#ifdef HAVE_SPATIAL
            Lex->charset=&my_charset_bin;
            Lex->uint_geom_type= (uint)(yyvsp[0].num);
            (yyval.num)=FIELD_TYPE_GEOMETRY;
#else
            my_error(ER_FEATURE_DISABLED, MYF(0),
                     sym_group_geom.name, sym_group_geom.needed_define);
            MYSQL_YYABORT;
#endif
          }
    break;

  case 367:
#line 3212 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 368:
#line 3214 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 369:
#line 3216 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin;
					  (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 370:
#line 3218 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 371:
#line 3219 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY_BLOB; }
    break;

  case 372:
#line 3220 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_BLOB; }
    break;

  case 373:
#line 3221 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 374:
#line 3222 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG_BLOB; }
    break;

  case 375:
#line 3224 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 376:
#line 3226 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 377:
#line 3228 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_NEWDECIMAL;}
    break;

  case 378:
#line 3229 "sql_yacc.yy"
    {Lex->interval_list.empty();}
    break;

  case 379:
#line 3230 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_ENUM; }
    break;

  case 380:
#line 3231 "sql_yacc.yy"
    { Lex->interval_list.empty();}
    break;

  case 381:
#line 3232 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SET; }
    break;

  case 382:
#line 3233 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_MEDIUM_BLOB; }
    break;

  case 383:
#line 3235 "sql_yacc.yy"
    {
	    (yyval.num)=FIELD_TYPE_LONGLONG;
	    Lex->type|= (AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNSIGNED_FLAG |
		         UNIQUE_FLAG);
	  }
    break;

  case 384:
#line 3243 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRY; }
    break;

  case 385:
#line 3244 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_GEOMETRYCOLLECTION; }
    break;

  case 386:
#line 3245 "sql_yacc.yy"
    { Lex->length= (char*)"21";
                                (yyval.num)= Field::GEOM_POINT;
                              }
    break;

  case 387:
#line 3248 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOINT; }
    break;

  case 388:
#line 3249 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_LINESTRING; }
    break;

  case 389:
#line 3250 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTILINESTRING; }
    break;

  case 390:
#line 3251 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_POLYGON; }
    break;

  case 391:
#line 3252 "sql_yacc.yy"
    { (yyval.num)= Field::GEOM_MULTIPOLYGON; }
    break;

  case 392:
#line 3256 "sql_yacc.yy"
    {}
    break;

  case 393:
#line 3260 "sql_yacc.yy"
    {}
    break;

  case 394:
#line 3261 "sql_yacc.yy"
    {}
    break;

  case 395:
#line 3265 "sql_yacc.yy"
    {}
    break;

  case 396:
#line 3266 "sql_yacc.yy"
    {}
    break;

  case 397:
#line 3270 "sql_yacc.yy"
    {}
    break;

  case 398:
#line 3271 "sql_yacc.yy"
    {}
    break;

  case 399:
#line 3272 "sql_yacc.yy"
    {}
    break;

  case 400:
#line 3273 "sql_yacc.yy"
    {}
    break;

  case 401:
#line 3274 "sql_yacc.yy"
    {}
    break;

  case 402:
#line 3278 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONG; }
    break;

  case 403:
#line 3279 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_TINY; }
    break;

  case 404:
#line 3280 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_SHORT; }
    break;

  case 405:
#line 3281 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_INT24; }
    break;

  case 406:
#line 3282 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_LONGLONG; }
    break;

  case 407:
#line 3285 "sql_yacc.yy"
    { (yyval.num)= YYTHD->variables.sql_mode & MODE_REAL_AS_FLOAT ?
			      FIELD_TYPE_FLOAT : FIELD_TYPE_DOUBLE; }
    break;

  case 408:
#line 3287 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 409:
#line 3288 "sql_yacc.yy"
    { (yyval.num)=FIELD_TYPE_DOUBLE; }
    break;

  case 410:
#line 3292 "sql_yacc.yy"
    { Lex->dec=Lex->length= (char*)0; }
    break;

  case 411:
#line 3293 "sql_yacc.yy"
    { Lex->length=(yyvsp[-1].lex_str).str; Lex->dec= (char*)0; }
    break;

  case 412:
#line 3294 "sql_yacc.yy"
    {}
    break;

  case 413:
#line 3298 "sql_yacc.yy"
    {
	  LEX *lex=Lex;
	  lex->length=(yyvsp[-3].lex_str).str; lex->dec=(yyvsp[-1].lex_str).str;
	}
    break;

  case 414:
#line 3304 "sql_yacc.yy"
    {}
    break;

  case 415:
#line 3305 "sql_yacc.yy"
    {}
    break;

  case 416:
#line 3308 "sql_yacc.yy"
    {}
    break;

  case 417:
#line 3309 "sql_yacc.yy"
    {}
    break;

  case 418:
#line 3312 "sql_yacc.yy"
    {}
    break;

  case 419:
#line 3313 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG;}
    break;

  case 420:
#line 3314 "sql_yacc.yy"
    { Lex->type|= UNSIGNED_FLAG | ZEROFILL_FLAG; }
    break;

  case 421:
#line 3317 "sql_yacc.yy"
    { Lex->length=(char*) 0; }
    break;

  case 422:
#line 3318 "sql_yacc.yy"
    { Lex->length= (yyvsp[-1].lex_str).str; }
    break;

  case 423:
#line 3321 "sql_yacc.yy"
    {}
    break;

  case 424:
#line 3322 "sql_yacc.yy"
    {}
    break;

  case 425:
#line 3325 "sql_yacc.yy"
    {}
    break;

  case 426:
#line 3326 "sql_yacc.yy"
    {}
    break;

  case 427:
#line 3329 "sql_yacc.yy"
    {}
    break;

  case 429:
#line 3333 "sql_yacc.yy"
    { Lex->type&= ~ NOT_NULL_FLAG; }
    break;

  case 430:
#line 3334 "sql_yacc.yy"
    { Lex->type|= NOT_NULL_FLAG; }
    break;

  case 431:
#line 3335 "sql_yacc.yy"
    { Lex->default_value=(yyvsp[0].item); }
    break;

  case 432:
#line 3337 "sql_yacc.yy"
    { Lex->on_update_value= new Item_func_now_local(); }
    break;

  case 433:
#line 3338 "sql_yacc.yy"
    { Lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG; }
    break;

  case 434:
#line 3340 "sql_yacc.yy"
    { 
	    LEX *lex=Lex;
	    lex->type|= AUTO_INCREMENT_FLAG | NOT_NULL_FLAG | UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 435:
#line 3346 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= PRI_KEY_FLAG | NOT_NULL_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 436:
#line 3352 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 437:
#line 3358 "sql_yacc.yy"
    {
	    LEX *lex=Lex;
	    lex->type|= UNIQUE_KEY_FLAG; 
	    lex->alter_info.flags|= ALTER_ADD_INDEX; 
	  }
    break;

  case 438:
#line 3363 "sql_yacc.yy"
    { Lex->comment= (yyvsp[0].lex_str); }
    break;

  case 439:
#line 3365 "sql_yacc.yy"
    {
	    if (Lex->charset && !my_charset_same(Lex->charset,(yyvsp[0].charset)))
	    {
	      my_error(ER_COLLATION_CHARSET_MISMATCH, MYF(0),
                       (yyvsp[0].charset)->name,Lex->charset->csname);
	      MYSQL_YYABORT;
	    }
	    else
	    {
	      Lex->charset=(yyvsp[0].charset);
	    }
	  }
    break;

  case 440:
#line 3380 "sql_yacc.yy"
    { (yyval.item)= new Item_func_now_local(); }
    break;

  case 441:
#line 3381 "sql_yacc.yy"
    { (yyval.item)=(yyvsp[0].item); }
    break;

  case 442:
#line 3385 "sql_yacc.yy"
    {}
    break;

  case 443:
#line 3386 "sql_yacc.yy"
    {}
    break;

  case 444:
#line 3391 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 445:
#line 3398 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 446:
#line 3402 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 447:
#line 3403 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 448:
#line 3406 "sql_yacc.yy"
    { (yyval.charset)= NULL; }
    break;

  case 449:
#line 3407 "sql_yacc.yy"
    { (yyval.charset)= (yyvsp[0].charset); }
    break;

  case 450:
#line 3412 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_csname((yyvsp[0].lex_str).str,MY_CS_PRIMARY,MYF(0))) &&
	      !((yyval.charset)=get_old_charset_by_name((yyvsp[0].lex_str).str)))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 451:
#line 3420 "sql_yacc.yy"
    { (yyval.charset)= &my_charset_bin; }
    break;

  case 452:
#line 3424 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 453:
#line 3425 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 454:
#line 3429 "sql_yacc.yy"
    {
	  if (!((yyval.charset)=get_charset_by_name((yyvsp[0].lex_str).str,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_COLLATION, MYF(0), (yyvsp[0].lex_str).str);
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 455:
#line 3438 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 456:
#line 3439 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset); }
    break;

  case 457:
#line 3443 "sql_yacc.yy"
    { (yyval.charset)=(yyvsp[0].charset);   }
    break;

  case 458:
#line 3444 "sql_yacc.yy"
    { (yyval.charset)=NULL; }
    break;

  case 459:
#line 3447 "sql_yacc.yy"
    {}
    break;

  case 460:
#line 3448 "sql_yacc.yy"
    {}
    break;

  case 461:
#line 3451 "sql_yacc.yy"
    { Lex->charset=NULL; }
    break;

  case 462:
#line 3452 "sql_yacc.yy"
    { Lex->charset=&my_charset_latin1; }
    break;

  case 463:
#line 3453 "sql_yacc.yy"
    { Lex->charset=&my_charset_bin; }
    break;

  case 464:
#line 3455 "sql_yacc.yy"
    {
	  if (!(Lex->charset=get_charset_by_csname("ucs2",
                                                   MY_CS_PRIMARY,MYF(0))))
	  {
	    my_error(ER_UNKNOWN_CHARACTER_SET, MYF(0), "ucs2");
	    MYSQL_YYABORT;
	  }
	}
    break;

  case 465:
#line 3463 "sql_yacc.yy"
    { Lex->charset=(yyvsp[-1].charset); }
    break;

  case 466:
#line 3