
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 24 "/export/home/pb2/build/sb_0-9537548-1371655226.21/mysql-5.5.32-release-export-5353231_gpl/sql/sql_yacc.yy"

/* thd is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Alter_table*_statement
#include "sql_truncate.h"                      // Truncate_statement
#include "sql_admin.h"                         // Analyze/Check..._table_stmt
#include "sql_partition_admin.h"               // Alter_table_*_partition_stmt
#include "sql_signal.h"
#include "event_parse_data.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label((char *)"", lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label((char *)"", 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable_t *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->dflt)
    it= spv->dflt;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_NO_WRITE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}



/* Line 189 of yacc.c  */
#line 789 "/export/home/pb2/build/sb_0-9537548-1371655226.21/dist_GPL/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYZE_SYM = 269,
     AND_AND_SYM = 270,
     AND_SYM = 271,
     ANY_SYM = 272,
     AS = 273,
     ASC = 274,
     ASCII_SYM = 275,
     ASENSITIVE_SYM = 276,
     AT_SYM = 277,
     AUTHORS_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BLOCK_SYM = 296,
     BOOLEAN_SYM = 297,
     BOOL_SYM = 298,
     BOTH = 299,
     BTREE_SYM = 300,
     BY = 301,
     BYTE_SYM = 302,
     CACHE_SYM = 303,
     CALL_SYM = 304,
     CASCADE = 305,
     CASCADED = 306,
     CASE_SYM = 307,
     CAST_SYM = 308,
     CATALOG_NAME_SYM = 309,
     CHAIN_SYM = 310,
     CHANGE = 311,
     CHANGED = 312,
     CHARSET = 313,
     CHAR_SYM = 314,
     CHECKSUM_SYM = 315,
     CHECK_SYM = 316,
     CIPHER_SYM = 317,
     CLASS_ORIGIN_SYM = 318,
     CLIENT_SYM = 319,
     CLOSE_SYM = 320,
     COALESCE = 321,
     CODE_SYM = 322,
     COLLATE_SYM = 323,
     COLLATION_SYM = 324,
     COLUMNS = 325,
     COLUMN_SYM = 326,
     COLUMN_NAME_SYM = 327,
     COMMENT_SYM = 328,
     COMMITTED_SYM = 329,
     COMMIT_SYM = 330,
     COMPACT_SYM = 331,
     COMPLETION_SYM = 332,
     COMPRESSED_SYM = 333,
     CONCURRENT = 334,
     CONDITION_SYM = 335,
     CONNECTION_SYM = 336,
     CONSISTENT_SYM = 337,
     CONSTRAINT = 338,
     CONSTRAINT_CATALOG_SYM = 339,
     CONSTRAINT_NAME_SYM = 340,
     CONSTRAINT_SCHEMA_SYM = 341,
     CONTAINS_SYM = 342,
     CONTEXT_SYM = 343,
     CONTINUE_SYM = 344,
     CONTRIBUTORS_SYM = 345,
     CONVERT_SYM = 346,
     COUNT_SYM = 347,
     CPU_SYM = 348,
     CREATE = 349,
     CROSS = 350,
     CUBE_SYM = 351,
     CURDATE = 352,
     CURRENT_USER = 353,
     CURSOR_SYM = 354,
     CURSOR_NAME_SYM = 355,
     CURTIME = 356,
     DATABASE = 357,
     DATABASES = 358,
     DATAFILE_SYM = 359,
     DATA_SYM = 360,
     DATETIME = 361,
     DATE_ADD_INTERVAL = 362,
     DATE_SUB_INTERVAL = 363,
     DATE_SYM = 364,
     DAY_HOUR_SYM = 365,
     DAY_MICROSECOND_SYM = 366,
     DAY_MINUTE_SYM = 367,
     DAY_SECOND_SYM = 368,
     DAY_SYM = 369,
     DEALLOCATE_SYM = 370,
     DECIMAL_NUM = 371,
     DECIMAL_SYM = 372,
     DECLARE_SYM = 373,
     DEFAULT = 374,
     DEFINER_SYM = 375,
     DELAYED_SYM = 376,
     DELAY_KEY_WRITE_SYM = 377,
     DELETE_SYM = 378,
     DESC = 379,
     DESCRIBE = 380,
     DES_KEY_FILE = 381,
     DETERMINISTIC_SYM = 382,
     DIRECTORY_SYM = 383,
     DISABLE_SYM = 384,
     DISCARD = 385,
     DISK_SYM = 386,
     DISTINCT = 387,
     DIV_SYM = 388,
     DOUBLE_SYM = 389,
     DO_SYM = 390,
     DROP = 391,
     DUAL_SYM = 392,
     DUMPFILE = 393,
     DUPLICATE_SYM = 394,
     DYNAMIC_SYM = 395,
     EACH_SYM = 396,
     ELSE = 397,
     ELSEIF_SYM = 398,
     ENABLE_SYM = 399,
     ENCLOSED = 400,
     END = 401,
     ENDS_SYM = 402,
     END_OF_INPUT = 403,
     ENGINES_SYM = 404,
     ENGINE_SYM = 405,
     ENUM = 406,
     EQ = 407,
     EQUAL_SYM = 408,
     ERROR_SYM = 409,
     ERRORS = 410,
     ESCAPED = 411,
     ESCAPE_SYM = 412,
     EVENTS_SYM = 413,
     EVENT_SYM = 414,
     EVERY_SYM = 415,
     EXECUTE_SYM = 416,
     EXISTS = 417,
     EXIT_SYM = 418,
     EXPANSION_SYM = 419,
     EXTENDED_SYM = 420,
     EXTENT_SIZE_SYM = 421,
     EXTRACT_SYM = 422,
     FALSE_SYM = 423,
     FAST_SYM = 424,
     FAULTS_SYM = 425,
     FETCH_SYM = 426,
     FILE_SYM = 427,
     FIRST_SYM = 428,
     FIXED_SYM = 429,
     FLOAT_NUM = 430,
     FLOAT_SYM = 431,
     FLUSH_SYM = 432,
     FORCE_SYM = 433,
     FOREIGN = 434,
     FOR_SYM = 435,
     FOUND_SYM = 436,
     FROM = 437,
     FULL = 438,
     FULLTEXT_SYM = 439,
     FUNCTION_SYM = 440,
     GE = 441,
     GENERAL = 442,
     GEOMETRYCOLLECTION = 443,
     GEOMETRY_SYM = 444,
     GET_FORMAT = 445,
     GLOBAL_SYM = 446,
     GRANT = 447,
     GRANTS = 448,
     GROUP_SYM = 449,
     GROUP_CONCAT_SYM = 450,
     GT_SYM = 451,
     HANDLER_SYM = 452,
     HASH_SYM = 453,
     HAVING = 454,
     HELP_SYM = 455,
     HEX_NUM = 456,
     HIGH_PRIORITY = 457,
     HOST_SYM = 458,
     HOSTS_SYM = 459,
     HOUR_MICROSECOND_SYM = 460,
     HOUR_MINUTE_SYM = 461,
     HOUR_SECOND_SYM = 462,
     HOUR_SYM = 463,
     IDENT = 464,
     IDENTIFIED_SYM = 465,
     IDENT_QUOTED = 466,
     IF = 467,
     IGNORE_SYM = 468,
     IGNORE_SERVER_IDS_SYM = 469,
     IMPORT = 470,
     INDEXES = 471,
     INDEX_SYM = 472,
     INFILE = 473,
     INITIAL_SIZE_SYM = 474,
     INNER_SYM = 475,
     INOUT_SYM = 476,
     INSENSITIVE_SYM = 477,
     INSERT = 478,
     INSERT_METHOD = 479,
     INSTALL_SYM = 480,
     INTERVAL_SYM = 481,
     INTO = 482,
     INT_SYM = 483,
     INVOKER_SYM = 484,
     IN_SYM = 485,
     IO_SYM = 486,
     IPC_SYM = 487,
     IS = 488,
     ISOLATION = 489,
     ISSUER_SYM = 490,
     ITERATE_SYM = 491,
     JOIN_SYM = 492,
     KEYS = 493,
     KEY_BLOCK_SIZE = 494,
     KEY_SYM = 495,
     KILL_SYM = 496,
     LANGUAGE_SYM = 497,
     LAST_SYM = 498,
     LE = 499,
     LEADING = 500,
     LEAVES = 501,
     LEAVE_SYM = 502,
     LEFT = 503,
     LESS_SYM = 504,
     LEVEL_SYM = 505,
     LEX_HOSTNAME = 506,
     LIKE = 507,
     LIMIT = 508,
     LINEAR_SYM = 509,
     LINES = 510,
     LINESTRING = 511,
     LIST_SYM = 512,
     LOAD = 513,
     LOCAL_SYM = 514,
     LOCATOR_SYM = 515,
     LOCKS_SYM = 516,
     LOCK_SYM = 517,
     LOGFILE_SYM = 518,
     LOGS_SYM = 519,
     LONGBLOB = 520,
     LONGTEXT = 521,
     LONG_NUM = 522,
     LONG_SYM = 523,
     LOOP_SYM = 524,
     LOW_PRIORITY = 525,
     LT = 526,
     MASTER_CONNECT_RETRY_SYM = 527,
     MASTER_HOST_SYM = 528,
     MASTER_LOG_FILE_SYM = 529,
     MASTER_LOG_POS_SYM = 530,
     MASTER_PASSWORD_SYM = 531,
     MASTER_PORT_SYM = 532,
     MASTER_SERVER_ID_SYM = 533,
     MASTER_SSL_CAPATH_SYM = 534,
     MASTER_SSL_CA_SYM = 535,
     MASTER_SSL_CERT_SYM = 536,
     MASTER_SSL_CIPHER_SYM = 537,
     MASTER_SSL_KEY_SYM = 538,
     MASTER_SSL_SYM = 539,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 540,
     MASTER_SYM = 541,
     MASTER_USER_SYM = 542,
     MASTER_HEARTBEAT_PERIOD_SYM = 543,
     MATCH = 544,
     MAX_CONNECTIONS_PER_HOUR = 545,
     MAX_QUERIES_PER_HOUR = 546,
     MAX_ROWS = 547,
     MAX_SIZE_SYM = 548,
     MAX_SYM = 549,
     MAX_UPDATES_PER_HOUR = 550,
     MAX_USER_CONNECTIONS_SYM = 551,
     MAX_VALUE_SYM = 552,
     MEDIUMBLOB = 553,
     MEDIUMINT = 554,
     MEDIUMTEXT = 555,
     MEDIUM_SYM = 556,
     MEMORY_SYM = 557,
     MERGE_SYM = 558,
     MESSAGE_TEXT_SYM = 559,
     MICROSECOND_SYM = 560,
     MIGRATE_SYM = 561,
     MINUTE_MICROSECOND_SYM = 562,
     MINUTE_SECOND_SYM = 563,
     MINUTE_SYM = 564,
     MIN_ROWS = 565,
     MIN_SYM = 566,
     MODE_SYM = 567,
     MODIFIES_SYM = 568,
     MODIFY_SYM = 569,
     MOD_SYM = 570,
     MONTH_SYM = 571,
     MULTILINESTRING = 572,
     MULTIPOINT = 573,
     MULTIPOLYGON = 574,
     MUTEX_SYM = 575,
     MYSQL_ERRNO_SYM = 576,
     NAMES_SYM = 577,
     NAME_SYM = 578,
     NATIONAL_SYM = 579,
     NATURAL = 580,
     NCHAR_STRING = 581,
     NCHAR_SYM = 582,
     NDBCLUSTER_SYM = 583,
     NE = 584,
     NEG = 585,
     NEW_SYM = 586,
     NEXT_SYM = 587,
     NODEGROUP_SYM = 588,
     NONE_SYM = 589,
     NOT2_SYM = 590,
     NOT_SYM = 591,
     NOW_SYM = 592,
     NO_SYM = 593,
     NO_WAIT_SYM = 594,
     NO_WRITE_TO_BINLOG = 595,
     NULL_SYM = 596,
     NUM = 597,
     NUMERIC_SYM = 598,
     NVARCHAR_SYM = 599,
     OFFSET_SYM = 600,
     OLD_PASSWORD = 601,
     ON = 602,
     ONE_SHOT_SYM = 603,
     ONE_SYM = 604,
     OPEN_SYM = 605,
     OPTIMIZE = 606,
     OPTIONS_SYM = 607,
     OPTION = 608,
     OPTIONALLY = 609,
     OR2_SYM = 610,
     ORDER_SYM = 611,
     OR_OR_SYM = 612,
     OR_SYM = 613,
     OUTER = 614,
     OUTFILE = 615,
     OUT_SYM = 616,
     OWNER_SYM = 617,
     PACK_KEYS_SYM = 618,
     PAGE_SYM = 619,
     PARAM_MARKER = 620,
     PARSER_SYM = 621,
     PARTIAL = 622,
     PARTITIONING_SYM = 623,
     PARTITIONS_SYM = 624,
     PARTITION_SYM = 625,
     PASSWORD = 626,
     PHASE_SYM = 627,
     PLUGINS_SYM = 628,
     PLUGIN_SYM = 629,
     POINT_SYM = 630,
     POLYGON = 631,
     PORT_SYM = 632,
     POSITION_SYM = 633,
     PRECISION = 634,
     PREPARE_SYM = 635,
     PRESERVE_SYM = 636,
     PREV_SYM = 637,
     PRIMARY_SYM = 638,
     PRIVILEGES = 639,
     PROCEDURE_SYM = 640,
     PROCESS = 641,
     PROCESSLIST_SYM = 642,
     PROFILE_SYM = 643,
     PROFILES_SYM = 644,
     PROXY_SYM = 645,
     PURGE = 646,
     QUARTER_SYM = 647,
     QUERY_SYM = 648,
     QUICK = 649,
     RANGE_SYM = 650,
     READS_SYM = 651,
     READ_ONLY_SYM = 652,
     READ_SYM = 653,
     READ_WRITE_SYM = 654,
     REAL = 655,
     REBUILD_SYM = 656,
     RECOVER_SYM = 657,
     REDOFILE_SYM = 658,
     REDO_BUFFER_SIZE_SYM = 659,
     REDUNDANT_SYM = 660,
     REFERENCES = 661,
     REGEXP = 662,
     RELAY = 663,
     RELAYLOG_SYM = 664,
     RELAY_LOG_FILE_SYM = 665,
     RELAY_LOG_POS_SYM = 666,
     RELAY_THREAD = 667,
     RELEASE_SYM = 668,
     RELOAD = 669,
     REMOVE_SYM = 670,
     RENAME = 671,
     REORGANIZE_SYM = 672,
     REPAIR = 673,
     REPEATABLE_SYM = 674,
     REPEAT_SYM = 675,
     REPLACE = 676,
     REPLICATION = 677,
     REQUIRE_SYM = 678,
     RESET_SYM = 679,
     RESIGNAL_SYM = 680,
     RESOURCES = 681,
     RESTORE_SYM = 682,
     RESTRICT = 683,
     RESUME_SYM = 684,
     RETURNS_SYM = 685,
     RETURN_SYM = 686,
     REVOKE = 687,
     RIGHT = 688,
     ROLLBACK_SYM = 689,
     ROLLUP_SYM = 690,
     ROUTINE_SYM = 691,
     ROWS_SYM = 692,
     ROW_FORMAT_SYM = 693,
     ROW_SYM = 694,
     RTREE_SYM = 695,
     SAVEPOINT_SYM = 696,
     SCHEDULE_SYM = 697,
     SCHEMA_NAME_SYM = 698,
     SECOND_MICROSECOND_SYM = 699,
     SECOND_SYM = 700,
     SECURITY_SYM = 701,
     SELECT_SYM = 702,
     SENSITIVE_SYM = 703,
     SEPARATOR_SYM = 704,
     SERIALIZABLE_SYM = 705,
     SERIAL_SYM = 706,
     SESSION_SYM = 707,
     SERVER_SYM = 708,
     SERVER_OPTIONS = 709,
     SET = 710,
     SET_VAR = 711,
     SHARE_SYM = 712,
     SHIFT_LEFT = 713,
     SHIFT_RIGHT = 714,
     SHOW = 715,
     SHUTDOWN = 716,
     SIGNAL_SYM = 717,
     SIGNED_SYM = 718,
     SIMPLE_SYM = 719,
     SLAVE = 720,
     SLOW = 721,
     SMALLINT = 722,
     SNAPSHOT_SYM = 723,
     SOCKET_SYM = 724,
     SONAME_SYM = 725,
     SOUNDS_SYM = 726,
     SOURCE_SYM = 727,
     SPATIAL_SYM = 728,
     SPECIFIC_SYM = 729,
     SQLEXCEPTION_SYM = 730,
     SQLSTATE_SYM = 731,
     SQLWARNING_SYM = 732,
     SQL_BIG_RESULT = 733,
     SQL_BUFFER_RESULT = 734,
     SQL_CACHE_SYM = 735,
     SQL_CALC_FOUND_ROWS = 736,
     SQL_NO_CACHE_SYM = 737,
     SQL_SMALL_RESULT = 738,
     SQL_SYM = 739,
     SQL_THREAD = 740,
     SSL_SYM = 741,
     STARTING = 742,
     STARTS_SYM = 743,
     START_SYM = 744,
     STATUS_SYM = 745,
     STDDEV_SAMP_SYM = 746,
     STD_SYM = 747,
     STOP_SYM = 748,
     STORAGE_SYM = 749,
     STRAIGHT_JOIN = 750,
     STRING_SYM = 751,
     SUBCLASS_ORIGIN_SYM = 752,
     SUBDATE_SYM = 753,
     SUBJECT_SYM = 754,
     SUBPARTITIONS_SYM = 755,
     SUBPARTITION_SYM = 756,
     SUBSTRING = 757,
     SUM_SYM = 758,
     SUPER_SYM = 759,
     SUSPEND_SYM = 760,
     SWAPS_SYM = 761,
     SWITCHES_SYM = 762,
     SYSDATE = 763,
     TABLES = 764,
     TABLESPACE = 765,
     TABLE_REF_PRIORITY = 766,
     TABLE_SYM = 767,
     TABLE_CHECKSUM_SYM = 768,
     TABLE_NAME_SYM = 769,
     TEMPORARY = 770,
     TEMPTABLE_SYM = 771,
     TERMINATED = 772,
     TEXT_STRING = 773,
     TEXT_SYM = 774,
     THAN_SYM = 775,
     THEN_SYM = 776,
     TIMESTAMP = 777,
     TIMESTAMP_ADD = 778,
     TIMESTAMP_DIFF = 779,
     TIME_SYM = 780,
     TINYBLOB = 781,
     TINYINT = 782,
     TINYTEXT = 783,
     TO_SYM = 784,
     TRAILING = 785,
     TRANSACTION_SYM = 786,
     TRIGGERS_SYM = 787,
     TRIGGER_SYM = 788,
     TRIM = 789,
     TRUE_SYM = 790,
     TRUNCATE_SYM = 791,
     TYPES_SYM = 792,
     TYPE_SYM = 793,
     UDF_RETURNS_SYM = 794,
     ULONGLONG_NUM = 795,
     UNCOMMITTED_SYM = 796,
     UNDEFINED_SYM = 797,
     UNDERSCORE_CHARSET = 798,
     UNDOFILE_SYM = 799,
     UNDO_BUFFER_SIZE_SYM = 800,
     UNDO_SYM = 801,
     UNICODE_SYM = 802,
     UNINSTALL_SYM = 803,
     UNION_SYM = 804,
     UNIQUE_SYM = 805,
     UNKNOWN_SYM = 806,
     UNLOCK_SYM = 807,
     UNSIGNED = 808,
     UNTIL_SYM = 809,
     UPDATE_SYM = 810,
     UPGRADE_SYM = 811,
     USAGE = 812,
     USER = 813,
     USE_FRM = 814,
     USE_SYM = 815,
     USING = 816,
     UTC_DATE_SYM = 817,
     UTC_TIMESTAMP_SYM = 818,
     UTC_TIME_SYM = 819,
     VALUES = 820,
     VALUE_SYM = 821,
     VARBINARY = 822,
     VARCHAR = 823,
     VARIABLES = 824,
     VARIANCE_SYM = 825,
     VARYING = 826,
     VAR_SAMP_SYM = 827,
     VIEW_SYM = 828,
     WAIT_SYM = 829,
     WARNINGS = 830,
     WEEK_SYM = 831,
     WHEN_SYM = 832,
     WHERE = 833,
     WHILE_SYM = 834,
     WITH = 835,
     WITH_CUBE_SYM = 836,
     WITH_ROLLUP_SYM = 837,
     WORK_SYM = 838,
     WRAPPER_SYM = 839,
     WRITE_SYM = 840,
     X509_SYM = 841,
     XA_SYM = 842,
     XML_SYM = 843,
     XOR = 844,
     YEAR_MONTH_SYM = 845,
     YEAR_SYM = 846,
     ZEROFILL = 847
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYZE_SYM 269
#define AND_AND_SYM 270
#define AND_SYM 271
#define ANY_SYM 272
#define AS 273
#define ASC 274
#define ASCII_SYM 275
#define ASENSITIVE_SYM 276
#define AT_SYM 277
#define AUTHORS_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CATALOG_NAME_SYM 309
#define CHAIN_SYM 310
#define CHANGE 311
#define CHANGED 312
#define CHARSET 313
#define CHAR_SYM 314
#define CHECKSUM_SYM 315
#define CHECK_SYM 316
#define CIPHER_SYM 317
#define CLASS_ORIGIN_SYM 318
#define CLIENT_SYM 319
#define CLOSE_SYM 320
#define COALESCE 321
#define CODE_SYM 322
#define COLLATE_SYM 323
#define COLLATION_SYM 324
#define COLUMNS 325
#define COLUMN_SYM 326
#define COLUMN_NAME_SYM 327
#define COMMENT_SYM 328
#define COMMITTED_SYM 329
#define COMMIT_SYM 330
#define COMPACT_SYM 331
#define COMPLETION_SYM 332
#define COMPRESSED_SYM 333
#define CONCURRENT 334
#define CONDITION_SYM 335
#define CONNECTION_SYM 336
#define CONSISTENT_SYM 337
#define CONSTRAINT 338
#define CONSTRAINT_CATALOG_SYM 339
#define CONSTRAINT_NAME_SYM 340
#define CONSTRAINT_SCHEMA_SYM 341
#define CONTAINS_SYM 342
#define CONTEXT_SYM 343
#define CONTINUE_SYM 344
#define CONTRIBUTORS_SYM 345
#define CONVERT_SYM 346
#define COUNT_SYM 347
#define CPU_SYM 348
#define CREATE 349
#define CROSS 350
#define CUBE_SYM 351
#define CURDATE 352
#define CURRENT_USER 353
#define CURSOR_SYM 354
#define CURSOR_NAME_SYM 355
#define CURTIME 356
#define DATABASE 357
#define DATABASES 358
#define DATAFILE_SYM 359
#define DATA_SYM 360
#define DATETIME 361
#define DATE_ADD_INTERVAL 362
#define DATE_SUB_INTERVAL 363
#define DATE_SYM 364
#define DAY_HOUR_SYM 365
#define DAY_MICROSECOND_SYM 366
#define DAY_MINUTE_SYM 367
#define DAY_SECOND_SYM 368
#define DAY_SYM 369
#define DEALLOCATE_SYM 370
#define DECIMAL_NUM 371
#define DECIMAL_SYM 372
#define DECLARE_SYM 373
#define DEFAULT 374
#define DEFINER_SYM 375
#define DELAYED_SYM 376
#define DELAY_KEY_WRITE_SYM 377
#define DELETE_SYM 378
#define DESC 379
#define DESCRIBE 380
#define DES_KEY_FILE 381
#define DETERMINISTIC_SYM 382
#define DIRECTORY_SYM 383
#define DISABLE_SYM 384
#define DISCARD 385
#define DISK_SYM 386
#define DISTINCT 387
#define DIV_SYM 388
#define DOUBLE_SYM 389
#define DO_SYM 390
#define DROP 391
#define DUAL_SYM 392
#define DUMPFILE 393
#define DUPLICATE_SYM 394
#define DYNAMIC_SYM 395
#define EACH_SYM 396
#define ELSE 397
#define ELSEIF_SYM 398
#define ENABLE_SYM 399
#define ENCLOSED 400
#define END 401
#define ENDS_SYM 402
#define END_OF_INPUT 403
#define ENGINES_SYM 404
#define ENGINE_SYM 405
#define ENUM 406
#define EQ 407
#define EQUAL_SYM 408
#define ERROR_SYM 409
#define ERRORS 410
#define ESCAPED 411
#define ESCAPE_SYM 412
#define EVENTS_SYM 413
#define EVENT_SYM 414
#define EVERY_SYM 415
#define EXECUTE_SYM 416
#define EXISTS 417
#define EXIT_SYM 418
#define EXPANSION_SYM 419
#define EXTENDED_SYM 420
#define EXTENT_SIZE_SYM 421
#define EXTRACT_SYM 422
#define FALSE_SYM 423
#define FAST_SYM 424
#define FAULTS_SYM 425
#define FETCH_SYM 426
#define FILE_SYM 427
#define FIRST_SYM 428
#define FIXED_SYM 429
#define FLOAT_NUM 430
#define FLOAT_SYM 431
#define FLUSH_SYM 432
#define FORCE_SYM 433
#define FOREIGN 434
#define FOR_SYM 435
#define FOUND_SYM 436
#define FROM 437
#define FULL 438
#define FULLTEXT_SYM 439
#define FUNCTION_SYM 440
#define GE 441
#define GENERAL 442
#define GEOMETRYCOLLECTION 443
#define GEOMETRY_SYM 444
#define GET_FORMAT 445
#define GLOBAL_SYM 446
#define GRANT 447
#define GRANTS 448
#define GROUP_SYM 449
#define GROUP_CONCAT_SYM 450
#define GT_SYM 451
#define HANDLER_SYM 452
#define HASH_SYM 453
#define HAVING 454
#define HELP_SYM 455
#define HEX_NUM 456
#define HIGH_PRIORITY 457
#define HOST_SYM 458
#define HOSTS_SYM 459
#define HOUR_MICROSECOND_SYM 460
#define HOUR_MINUTE_SYM 461
#define HOUR_SECOND_SYM 462
#define HOUR_SYM 463
#define IDENT 464
#define IDENTIFIED_SYM 465
#define IDENT_QUOTED 466
#define IF 467
#define IGNORE_SYM 468
#define IGNORE_SERVER_IDS_SYM 469
#define IMPORT 470
#define INDEXES 471
#define INDEX_SYM 472
#define INFILE 473
#define INITIAL_SIZE_SYM 474
#define INNER_SYM 475
#define INOUT_SYM 476
#define INSENSITIVE_SYM 477
#define INSERT 478
#define INSERT_METHOD 479
#define INSTALL_SYM 480
#define INTERVAL_SYM 481
#define INTO 482
#define INT_SYM 483
#define INVOKER_SYM 484
#define IN_SYM 485
#define IO_SYM 486
#define IPC_SYM 487
#define IS 488
#define ISOLATION 489
#define ISSUER_SYM 490
#define ITERATE_SYM 491
#define JOIN_SYM 492
#define KEYS 493
#define KEY_BLOCK_SIZE 494
#define KEY_SYM 495
#define KILL_SYM 496
#define LANGUAGE_SYM 497
#define LAST_SYM 498
#define LE 499
#define LEADING 500
#define LEAVES 501
#define LEAVE_SYM 502
#define LEFT 503
#define LESS_SYM 504
#define LEVEL_SYM 505
#define LEX_HOSTNAME 506
#define LIKE 507
#define LIMIT 508
#define LINEAR_SYM 509
#define LINES 510
#define LINESTRING 511
#define LIST_SYM 512
#define LOAD 513
#define LOCAL_SYM 514
#define LOCATOR_SYM 515
#define LOCKS_SYM 516
#define LOCK_SYM 517
#define LOGFILE_SYM 518
#define LOGS_SYM 519
#define LONGBLOB 520
#define LONGTEXT 521
#define LONG_NUM 522
#define LONG_SYM 523
#define LOOP_SYM 524
#define LOW_PRIORITY 525
#define LT 526
#define MASTER_CONNECT_RETRY_SYM 527
#define MASTER_HOST_SYM 528
#define MASTER_LOG_FILE_SYM 529
#define MASTER_LOG_POS_SYM 530
#define MASTER_PASSWORD_SYM 531
#define MASTER_PORT_SYM 532
#define MASTER_SERVER_ID_SYM 533
#define MASTER_SSL_CAPATH_SYM 534
#define MASTER_SSL_CA_SYM 535
#define MASTER_SSL_CERT_SYM 536
#define MASTER_SSL_CIPHER_SYM 537
#define MASTER_SSL_KEY_SYM 538
#define MASTER_SSL_SYM 539
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 540
#define MASTER_SYM 541
#define MASTER_USER_SYM 542
#define MASTER_HEARTBEAT_PERIOD_SYM 543
#define MATCH 544
#define MAX_CONNECTIONS_PER_HOUR 545
#define MAX_QUERIES_PER_HOUR 546
#define MAX_ROWS 547
#define MAX_SIZE_SYM 548
#define MAX_SYM 549
#define MAX_UPDATES_PER_HOUR 550
#define MAX_USER_CONNECTIONS_SYM 551
#define MAX_VALUE_SYM 552
#define MEDIUMBLOB 553
#define MEDIUMINT 554
#define MEDIUMTEXT 555
#define MEDIUM_SYM 556
#define MEMORY_SYM 557
#define MERGE_SYM 558
#define MESSAGE_TEXT_SYM 559
#define MICROSECOND_SYM 560
#define MIGRATE_SYM 561
#define MINUTE_MICROSECOND_SYM 562
#define MINUTE_SECOND_SYM 563
#define MINUTE_SYM 564
#define MIN_ROWS 565
#define MIN_SYM 566
#define MODE_SYM 567
#define MODIFIES_SYM 568
#define MODIFY_SYM 569
#define MOD_SYM 570
#define MONTH_SYM 571
#define MULTILINESTRING 572
#define MULTIPOINT 573
#define MULTIPOLYGON 574
#define MUTEX_SYM 575
#define MYSQL_ERRNO_SYM 576
#define NAMES_SYM 577
#define NAME_SYM 578
#define NATIONAL_SYM 579
#define NATURAL 580
#define NCHAR_STRING 581
#define NCHAR_SYM 582
#define NDBCLUSTER_SYM 583
#define NE 584
#define NEG 585
#define NEW_SYM 586
#define NEXT_SYM 587
#define NODEGROUP_SYM 588
#define NONE_SYM 589
#define NOT2_SYM 590
#define NOT_SYM 591
#define NOW_SYM 592
#define NO_SYM 593
#define NO_WAIT_SYM 594
#define NO_WRITE_TO_BINLOG 595
#define NULL_SYM 596
#define NUM 597
#define NUMERIC_SYM 598
#define NVARCHAR_SYM 599
#define OFFSET_SYM 600
#define OLD_PASSWORD 601
#define ON 602
#define ONE_SHOT_SYM 603
#define ONE_SYM 604
#define OPEN_SYM 605
#define OPTIMIZE 606
#define OPTIONS_SYM 607
#define OPTION 608
#define OPTIONALLY 609
#define OR2_SYM 610
#define ORDER_SYM 611
#define OR_OR_SYM 612
#define OR_SYM 613
#define OUTER 614
#define OUTFILE 615
#define OUT_SYM 616
#define OWNER_SYM 617
#define PACK_KEYS_SYM 618
#define PAGE_SYM 619
#define PARAM_MARKER 620
#define PARSER_SYM 621
#define PARTIAL 622
#define PARTITIONING_SYM 623
#define PARTITIONS_SYM 624
#define PARTITION_SYM 625
#define PASSWORD 626
#define PHASE_SYM 627
#define PLUGINS_SYM 628
#define PLUGIN_SYM 629
#define POINT_SYM 630
#define POLYGON 631
#define PORT_SYM 632
#define POSITION_SYM 633
#define PRECISION 634
#define PREPARE_SYM 635
#define PRESERVE_SYM 636
#define PREV_SYM 637
#define PRIMARY_SYM 638
#define PRIVILEGES 639
#define PROCEDURE_SYM 640
#define PROCESS 641
#define PROCESSLIST_SYM 642
#define PROFILE_SYM 643
#define PROFILES_SYM 644
#define PROXY_SYM 645
#define PURGE 646
#define QUARTER_SYM 647
#define QUERY_SYM 648
#define QUICK 649
#define RANGE_SYM 650
#define READS_SYM 651
#define READ_ONLY_SYM 652
#define READ_SYM 653
#define READ_WRITE_SYM 654
#define REAL 655
#define REBUILD_SYM 656
#define RECOVER_SYM 657
#define REDOFILE_SYM 658
#define REDO_BUFFER_SIZE_SYM 659
#define REDUNDANT_SYM 660
#define REFERENCES 661
#define REGEXP 662
#define RELAY 663
#define RELAYLOG_SYM 664
#define RELAY_LOG_FILE_SYM 665
#define RELAY_LOG_POS_SYM 666
#define RELAY_THREAD 667
#define RELEASE_SYM 668
#define RELOAD 669
#define REMOVE_SYM 670
#define RENAME 671
#define REORGANIZE_SYM 672
#define REPAIR 673
#define REPEATABLE_SYM 674
#define REPEAT_SYM 675
#define REPLACE 676
#define REPLICATION 677
#define REQUIRE_SYM 678
#define RESET_SYM 679
#define RESIGNAL_SYM 680
#define RESOURCES 681
#define RESTORE_SYM 682
#define RESTRICT 683
#define RESUME_SYM 684
#define RETURNS_SYM 685
#define RETURN_SYM 686
#define REVOKE 687
#define RIGHT 688
#define ROLLBACK_SYM 689
#define ROLLUP_SYM 690
#define ROUTINE_SYM 691
#define ROWS_SYM 692
#define ROW_FORMAT_SYM 693
#define ROW_SYM 694
#define RTREE_SYM 695
#define SAVEPOINT_SYM 696
#define SCHEDULE_SYM 697
#define SCHEMA_NAME_SYM 698
#define SECOND_MICROSECOND_SYM 699
#define SECOND_SYM 700
#define SECURITY_SYM 701
#define SELECT_SYM 702
#define SENSITIVE_SYM 703
#define SEPARATOR_SYM 704
#define SERIALIZABLE_SYM 705
#define SERIAL_SYM 706
#define SESSION_SYM 707
#define SERVER_SYM 708
#define SERVER_OPTIONS 709
#define SET 710
#define SET_VAR 711
#define SHARE_SYM 712
#define SHIFT_LEFT 713
#define SHIFT_RIGHT 714
#define SHOW 715
#define SHUTDOWN 716
#define SIGNAL_SYM 717
#define SIGNED_SYM 718
#define SIMPLE_SYM 719
#define SLAVE 720
#define SLOW 721
#define SMALLINT 722
#define SNAPSHOT_SYM 723
#define SOCKET_SYM 724
#define SONAME_SYM 725
#define SOUNDS_SYM 726
#define SOURCE_SYM 727
#define SPATIAL_SYM 728
#define SPECIFIC_SYM 729
#define SQLEXCEPTION_SYM 730
#define SQLSTATE_SYM 731
#define SQLWARNING_SYM 732
#define SQL_BIG_RESULT 733
#define SQL_BUFFER_RESULT 734
#define SQL_CACHE_SYM 735
#define SQL_CALC_FOUND_ROWS 736
#define SQL_NO_CACHE_SYM 737
#define SQL_SMALL_RESULT 738
#define SQL_SYM 739
#define SQL_THREAD 740
#define SSL_SYM 741
#define STARTING 742
#define STARTS_SYM 743
#define START_SYM 744
#define STATUS_SYM 745
#define STDDEV_SAMP_SYM 746
#define STD_SYM 747
#define STOP_SYM 748
#define STORAGE_SYM 749
#define STRAIGHT_JOIN 750
#define STRING_SYM 751
#define SUBCLASS_ORIGIN_SYM 752
#define SUBDATE_SYM 753
#define SUBJECT_SYM 754
#define SUBPARTITIONS_SYM 755
#define SUBPARTITION_SYM 756
#define SUBSTRING 757
#define SUM_SYM 758
#define SUPER_SYM 759
#define SUSPEND_SYM 760
#define SWAPS_SYM 761
#define SWITCHES_SYM 762
#define SYSDATE 763
#define TABLES 764
#define TABLESPACE 765
#define TABLE_REF_PRIORITY 766
#define TABLE_SYM 767
#define TABLE_CHECKSUM_SYM 768
#define TABLE_NAME_SYM 769
#define TEMPORARY 770
#define TEMPTABLE_SYM 771
#define TERMINATED 772
#define TEXT_STRING 773
#define TEXT_SYM 774
#define THAN_SYM 775
#define THEN_SYM 776
#define TIMESTAMP 777
#define TIMESTAMP_ADD 778
#define TIMESTAMP_DIFF 779
#define TIME_SYM 780
#define TINYBLOB 781
#define TINYINT 782
#define TINYTEXT 783
#define TO_SYM 784
#define TRAILING 785
#define TRANSACTION_SYM 786
#define TRIGGERS_SYM 787
#define TRIGGER_SYM 788
#define TRIM 789
#define TRUE_SYM 790
#define TRUNCATE_SYM 791
#define TYPES_SYM 792
#define TYPE_SYM 793
#define UDF_RETURNS_SYM 794
#define ULONGLONG_NUM 795
#define UNCOMMITTED_SYM 796
#define UNDEFINED_SYM 797
#define UNDERSCORE_CHARSET 798
#define UNDOFILE_SYM 799
#define UNDO_BUFFER_SIZE_SYM 800
#define UNDO_SYM 801
#define UNICODE_SYM 802
#define UNINSTALL_SYM 803
#define UNION_SYM 804
#define UNIQUE_SYM 805
#define UNKNOWN_SYM 806
#define UNLOCK_SYM 807
#define UNSIGNED 808
#define UNTIL_SYM 809
#define UPDATE_SYM 810
#define UPGRADE_SYM 811
#define USAGE 812
#define USER 813
#define USE_FRM 814
#define USE_SYM 815
#define USING 816
#define UTC_DATE_SYM 817
#define UTC_TIMESTAMP_SYM 818
#define UTC_TIME_SYM 819
#define VALUES 820
#define VALUE_SYM 821
#define VARBINARY 822
#define VARCHAR 823
#define VARIABLES 824
#define VARIANCE_SYM 825
#define VARYING 826
#define VAR_SAMP_SYM 827
#define VIEW_SYM 828
#define WAIT_SYM 829
#define WARNINGS 830
#define WEEK_SYM 831
#define WHEN_SYM 832
#define WHERE 833
#define WHILE_SYM 834
#define WITH 835
#define WITH_CUBE_SYM 836
#define WITH_ROLLUP_SYM 837
#define WORK_SYM 838
#define WRAPPER_SYM 839
#define WRITE_SYM 840
#define X509_SYM 841
#define XA_SYM 842
#define XML_SYM 843
#define XOR 844
#define YEAR_MONTH_SYM 845
#define YEAR_SYM 846
#define ZEROFILL 847




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 730 "/export/home/pb2/build/sb_0-9537548-1371655226.21/mysql-5.5.32-release-export-5353231_gpl/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  struct sp_cond_type *spcondtype;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2060 "/export/home/pb2/build/sb_0-9537548-1371655226.21/dist_GPL/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 779 "/export/home/pb2/build/sb_0-9537548-1371655226.21/mysql-5.5.32-release-export-5353231_gpl/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2077 "/export/home/pb2/build/sb_0-9537548-1371655226.21/dist_GPL/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  573
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   50277

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  612
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  888
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2496
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4247

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   847

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   605,     2,     2,     2,   599,   594,     2,
     602,   603,   597,   596,   604,   595,   610,   598,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   611,   608,
       2,     2,     2,     2,   609,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   600,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   606,   593,   607,   601,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   127,   129,   131,   136,   138,   141,   142,   147,
     148,   151,   155,   157,   160,   161,   165,   166,   172,   174,
     178,   182,   186,   190,   194,   198,   202,   206,   210,   214,
     218,   222,   226,   230,   236,   238,   239,   241,   245,   247,
     251,   255,   259,   263,   264,   272,   273,   286,   287,   300,
     301,   314,   315,   322,   323,   327,   332,   337,   341,   344,
     355,   357,   361,   364,   367,   370,   373,   376,   379,   382,
     383,   397,   398,   405,   408,   409,   411,   415,   417,   418,
     421,   422,   425,   426,   428,   432,   437,   438,   441,   442,
     445,   447,   449,   451,   453,   455,   457,   459,   461,   463,
     465,   467,   469,   471,   472,   476,   478,   479,   482,   483,
     486,   489,   492,   495,   498,   502,   506,   508,   510,   512,
     515,   519,   523,   524,   529,   530,   534,   535,   537,   541,
     543,   544,   546,   550,   552,   553,   557,   558,   560,   564,
     566,   571,   572,   574,   576,   578,   579,   583,   586,   590,
     591,   595,   596,   602,   608,   609,   617,   623,   624,   627,
     629,   631,   633,   637,   639,   641,   643,   647,   648,   650,
     652,   654,   656,   659,   661,   665,   667,   669,   670,   672,
     673,   676,   680,   686,   688,   690,   692,   694,   696,   698,
     700,   702,   704,   706,   708,   710,   712,   714,   716,   720,
     722,   726,   727,   730,   732,   734,   736,   738,   740,   742,
     744,   746,   748,   750,   752,   754,   756,   757,   763,   764,
     767,   768,   772,   773,   776,   779,   782,   785,   786,   793,
     796,   797,   800,   802,   804,   808,   809,   810,   811,   819,
     820,   823,   826,   828,   830,   831,   832,   841,   842,   849,
     851,   854,   856,   859,   860,   861,   868,   869,   870,   877,
     878,   881,   882,   888,   889,   891,   892,   898,   899,   902,
     903,   909,   914,   915,   916,   925,   926,   934,   936,   938,
     940,   942,   944,   947,   952,   958,   959,   964,   969,   974,
     978,   982,   985,   988,   989,   992,   994,   997,  1001,  1003,
    1005,  1007,  1009,  1011,  1014,  1018,  1020,  1022,  1024,  1026,
    1028,  1030,  1032,  1034,  1036,  1038,  1041,  1045,  1047,  1049,
    1051,  1053,  1055,  1057,  1059,  1062,  1066,  1068,  1070,  1072,
    1074,  1076,  1078,  1080,  1082,  1084,  1087,  1091,  1093,  1095,
    1097,  1100,  1103,  1106,  1108,  1110,  1112,  1114,  1117,  1121,
    1125,  1129,  1133,  1137,  1141,  1145,  1149,  1154,  1155,  1157,
    1159,  1161,  1163,  1165,  1168,  1172,  1175,  1180,  1186,  1187,
    1193,  1194,  1195,  1201,  1202,  1210,  1212,  1213,  1215,  1216,
    1221,  1222,  1223,  1227,  1233,  1240,  1241,  1246,  1249,  1252,
    1255,  1258,  1259,  1261,  1262,  1266,  1267,  1269,  1271,  1275,
    1277,  1282,  1288,  1294,  1295,  1298,  1299,  1300,  1308,  1309,
    1320,  1322,  1326,  1328,  1330,  1331,  1334,  1335,  1339,  1341,
    1345,  1346,  1353,  1355,  1356,  1357,  1363,  1364,  1369,  1371,
    1373,  1375,  1379,  1381,  1385,  1386,  1387,  1393,  1395,  1399,
    1401,  1403,  1404,  1408,  1410,  1414,  1415,  1420,  1422,  1423,
    1425,  1428,  1430,  1434,  1439,  1443,  1447,  1451,  1456,  1461,
    1465,  1466,  1467,  1474,  1475,  1477,  1478,  1480,  1482,  1485,
    1487,  1489,  1490,  1492,  1494,  1497,  1499,  1500,  1504,  1505,
    1507,  1509,  1512,  1514,  1517,  1521,  1525,  1529,  1533,  1537,
    1541,  1545,  1549,  1553,  1557,  1561,  1565,  1569,  1573,  1574,
    1581,  1583,  1585,  1589,  1594,  1599,  1602,  1605,  1608,  1612,
    1616,  1621,  1626,  1628,  1630,  1632,  1634,  1636,  1638,  1640,
    1642,  1644,  1646,  1648,  1650,  1653,  1655,  1657,  1659,  1661,
    1663,  1665,  1669,  1671,  1673,  1676,  1679,  1687,  1696,  1705,
    1714,  1723,  1726,  1727,  1729,  1734,  1735,  1737,  1740,  1741,
    1746,  1750,  1754,  1758,  1760,  1763,  1765,  1767,  1771,  1774,
    1778,  1781,  1784,  1786,  1790,  1794,  1797,  1801,  1803,  1805,
    1807,  1809,  1811,  1814,  1816,  1818,  1820,  1823,  1827,  1830,
    1834,  1837,  1840,  1844,  1848,  1852,  1853,  1860,  1861,  1868,
    1871,  1873,  1875,  1877,  1879,  1881,  1883,  1885,  1887,  1889,
    1891,  1893,  1896,  1899,  1901,  1904,  1906,  1909,  1913,  1916,
    1918,  1920,  1922,  1924,  1926,  1928,  1930,  1933,  1934,  1936,
    1938,  1944,  1945,  1947,  1950,  1952,  1954,  1956,  1958,  1962,
    1966,  1970,  1974,  1975,  1977,  1978,  1980,  1981,  1983,  1986,
    1988,  1990,  1993,  1996,  2001,  2003,  2007,  2010,  2012,  2015,
    2018,  2021,  2024,  2027,  2029,  2032,  2034,  2036,  2038,  2040,
    2042,  2043,  2046,  2048,  2050,  2052,  2054,  2056,  2057,  2060,
    2062,  2064,  2065,  2067,  2069,  2072,  2075,  2077,  2080,  2083,
    2084,  2086,  2088,  2090,  2094,  2096,  2100,  2101,  2103,  2104,
    2106,  2112,  2113,  2117,  2121,  2123,  2124,  2127,  2130,  2133,
    2134,  2138,  2142,  2149,  2156,  2158,  2160,  2163,  2166,  2169,
    2171,  2174,  2177,  2179,  2181,  2182,  2184,  2186,  2188,  2190,
    2191,  2193,  2195,  2197,  2198,  2200,  2203,  2204,  2206,  2207,
    2209,  2210,  2212,  2214,  2217,  2219,  2222,  2224,  2227,  2230,
    2233,  2237,  2240,  2242,  2244,  2246,  2248,  2252,  2254,  2256,
    2258,  2263,  2266,  2268,  2273,  2274,  2276,  2277,  2280,  2282,
    2286,  2287,  2294,  2295,  2301,  2309,  2310,  2316,  2317,  2323,
    2324,  2330,  2331,  2336,  2337,  2348,  2352,  2357,  2361,  2365,
    2373,  2374,  2378,  2380,  2385,  2386,  2390,  2391,  2394,  2395,
    2397,  2398,  2401,  2404,  2407,  2410,  2412,  2414,  2416,  2420,
    2425,  2426,  2433,  2438,  2439,  2445,  2446,  2453,  2458,  2462,
    2464,  2467,  2469,  2471,  2472,  2478,  2479,  2483,  2486,  2487,
    2493,  2494,  2495,  2502,  2504,  2508,  2510,  2512,  2516,  2519,
    2523,  2526,  2531,  2532,  2539,  2540,  2541,  2550,  2555,  2560,
    2564,  2568,  2571,  2574,  2581,  2587,  2591,  2597,  2599,  2601,
    2603,  2604,  2606,  2607,  2609,  2610,  2612,  2614,  2615,  2618,
    2620,  2621,  2623,  2625,  2627,  2628,  2634,  2638,  2639,  2645,
    2649,  2653,  2654,  2658,  2659,  2662,  2664,  2668,  2669,  2671,
    2673,  2674,  2677,  2679,  2683,  2684,  2690,  2691,  2693,  2695,
    2696,  2703,  2704,  2706,  2708,  2711,  2713,  2715,  2717,  2718,
    2724,  2727,  2728,  2734,  2735,  2737,  2739,  2742,  2744,  2746,
    2748,  2750,  2752,  2755,  2756,  2762,  2763,  2765,  2767,  2768,
    2773,  2778,  2782,  2788,  2790,  2794,  2798,  2799,  2806,  2808,
    2810,  2812,  2816,  2819,  2823,  2825,  2827,  2828,  2835,  2837,
    2839,  2841,  2845,  2849,  2854,  2855,  2862,  2863,  2866,  2867,
    2872,  2873,  2876,  2878,  2881,  2886,  2889,  2893,  2896,  2900,
    2901,  2905,  2906,  2907,  2914,  2917,  2919,  2921,  2924,  2927,
    2936,  2941,  2942,  2944,  2947,  2949,  2951,  2953,  2955,  2956,
    2959,  2964,  2968,  2970,  2972,  2976,  2981,  2982,  2983,  2984,
    2987,  2990,  2992,  2994,  2995,  2998,  3002,  3006,  3010,  3013,
    3017,  3022,  3026,  3031,  3035,  3040,  3042,  3046,  3051,  3055,
    3059,  3066,  3068,  3074,  3081,  3087,  3095,  3102,  3111,  3117,
    3124,  3129,  3134,  3140,  3144,  3149,  3151,  3155,  3159,  3163,
    3167,  3171,  3175,  3181,  3187,  3191,  3195,  3199,  3203,  3207,
    3211,  3213,  3215,  3217,  3219,  3221,  3223,  3225,  3227,  3229,
    3231,  3233,  3235,  3237,  3239,  3241,  3243,  3245,  3247,  3249,
    3251,  3253,  3255,  3259,  3261,  3263,  3265,  3267,  3271,  3274,
    3277,  3280,  3283,  3287,  3291,  3297,  3304,  3309,  3314,  3322,
    3325,  3332,  3338,  3345,  3352,  3357,  3362,  3368,  3373,  3380,
    3383,  3388,  3393,  3398,  3409,  3416,  3425,  3432,  3437,  3442,
    3449,  3454,  3459,  3464,  3471,  3476,  3484,  3492,  3500,  3507,
    3514,  3521,  3528,  3532,  3537,  3544,  3553,  3556,  3559,  3564,
    3573,  3582,  3589,  3596,  3599,  3604,  3611,  3618,  3627,  3636,
    3643,  3652,  3659,  3662,  3667,  3676,  3685,  3688,  3691,  3694,
    3699,  3704,  3709,  3714,  3718,  3727,  3732,  3739,  3744,  3749,
    3754,  3761,  3770,  3777,  3782,  3789,  3791,  3798,  3803,  3808,
    3813,  3818,  3823,  3830,  3835,  3836,  3842,  3849,  3852,  3856,
    3857,  3862,  3863,  3867,  3868,  3870,  3872,  3876,  3881,  3886,
    3892,  3897,  3902,  3907,  3913,  3918,  3919,  3920,  3928,  3933,
    3939,  3944,  3950,  3955,  3960,  3965,  3970,  3975,  3981,  3982,
    3991,  3992,  3996,  4000,  4002,  4007,  4008,  4010,  4011,  4014,
    4015,  4016,  4021,  4026,  4029,  4030,  4034,  4037,  4041,  4044,
    4046,  4049,  4051,  4054,  4056,  4058,  4060,  4063,  4064,  4066,
    4068,  4072,  4074,  4078,  4080,  4084,  4085,  4087,  4088,  4091,
    4096,  4102,  4104,  4106,  4108,  4110,  4115,  4117,  4121,  4125,
    4129,  4130,  4137,  4138,  4145,  4146,  4155,  4160,  4161,  4170,
    4171,  4182,  4189,  4190,  4199,  4200,  4211,  4218,  4220,  4223,
    4226,  4227,  4232,  4236,  4242,  4245,  4246,  4247,  4255,  4257,
    4258,  4259,  4266,  4267,  4271,  4272,  4273,  4279,  4280,  4282,
    4283,  4285,  4286,  4289,  4293,  4297,  4299,  4301,  4302,  4310,
    4311,  4319,  4321,  4324,  4325,  4326,  4329,  4330,  4333,  4334,
    4336,  4338,  4340,  4342,  4346,  4348,  4352,  4354,  4356,  4358,
    4360,  4362,  4364,  4366,  4368,  4370,  4372,  4374,  4376,  4378,
    4380,  4382,  4384,  4386,  4388,  4390,  4392,  4394,  4396,  4398,
    4400,  4402,  4403,  4405,  4407,  4408,  4411,  4412,  4414,  4415,
    4416,  4420,  4421,  4422,  4426,  4429,  4430,  4431,  4436,  4441,
    4444,  4445,  4447,  4449,  4453,  4457,  4459,  4462,  4463,  4465,
    4466,  4471,  4476,  4479,  4480,  4482,  4484,  4485,  4487,  4488,
    4490,  4493,  4495,  4499,  4503,  4505,  4507,  4509,  4511,  4513,
    4514,  4517,  4519,  4521,  4523,  4525,  4527,  4529,  4531,  4533,
    4535,  4537,  4539,  4541,  4543,  4545,  4547,  4549,  4551,  4553,
    4555,  4557,  4559,  4561,  4563,  4564,  4565,  4572,  4573,  4575,
    4579,  4581,  4585,  4586,  4589,  4593,  4595,  4598,  4600,  4601,
    4605,  4606,  4607,  4615,  4618,  4620,  4621,  4625,  4626,  4634,
    4635,  4642,  4647,  4654,  4659,  4664,  4669,  4670,  4677,  4682,
    4687,  4693,  4700,  4705,  4707,  4711,  4713,  4715,  4719,  4721,
    4722,  4725,  4726,  4728,  4729,  4730,  4739,  4740,  4741,  4748,
    4749,  4751,  4753,  4755,  4757,  4759,  4762,  4764,  4766,  4768,
    4772,  4777,  4778,  4782,  4786,  4788,  4791,  4794,  4795,  4799,
    4800,  4806,  4810,  4812,  4816,  4818,  4822,  4824,  4826,  4827,
    4829,  4830,  4835,  4836,  4838,  4842,  4844,  4846,  4848,  4849,
    4850,  4857,  4858,  4859,  4871,  4875,  4877,  4881,  4885,  4887,
    4891,  4892,  4894,  4895,  4900,  4901,  4908,  4909,  4915,  4916,
    4923,  4925,  4929,  4932,  4937,  4938,  4941,  4942,  4945,  4947,
    4949,  4951,  4952,  4957,  4958,  4960,  4961,  4963,  4965,  4969,
    4971,  4973,  4976,  4979,  4982,  4984,  4986,  4988,  4990,  4991,
    4995,  4996,  5000,  5003,  5008,  5013,  5017,  5022,  5027,  5029,
    5033,  5037,  5044,  5047,  5050,  5051,  5058,  5059,  5066,  5072,
    5075,  5077,  5079,  5081,  5087,  5093,  5096,  5099,  5101,  5106,
    5110,  5113,  5117,  5120,  5123,  5125,  5129,  5134,  5138,  5142,
    5145,  5148,  5152,  5156,  5160,  5164,  5168,  5172,  5176,  5180,
    5182,  5184,  5186,  5188,  5190,  5191,  5193,  5194,  5197,  5198,
    5200,  5202,  5204,  5205,  5208,  5209,  5212,  5213,  5216,  5219,
    5220,  5225,  5226,  5231,  5233,  5235,  5236,  5238,  5240,  5241,
    5243,  5245,  5246,  5251,  5252,  5253,  5259,  5261,  5262,  5266,
    5270,  5272,  5275,  5278,  5281,  5284,  5287,  5290,  5293,  5295,
    5297,  5299,  5301,  5303,  5305,  5307,  5309,  5310,  5312,  5313,
    5317,  5321,  5323,  5324,  5328,  5330,  5333,  5334,  5336,  5337,
    5341,  5345,  5348,  5351,  5355,  5356,  5358,  5360,  5363,  5364,
    5365,  5366,  5367,  5389,  5391,  5393,  5394,  5396,  5397,  5399,
    5401,  5402,  5404,  5406,  5407,  5410,  5413,  5415,  5419,  5424,
    5428,  5432,  5433,  5436,  5439,  5441,  5445,  5449,  5450,  5455,
    5456,  5460,  5462,  5464,  5465,  5469,  5472,  5476,  5478,  5480,
    5483,  5484,  5487,  5491,  5493,  5499,  5501,  5503,  5506,  5509,
    5511,  5513,  5515,  5517,  5519,  5522,  5525,  5527,  5529,  5531,
    5533,  5535,  5537,  5539,  5542,  5545,  5548,  5551,  5554,  5556,
    5558,  5560,  5562,  5564,  5566,  5568,  5572,  5578,  5580,  5582,
    5584,  5586,  5588,  5592,  5597,  5603,  5605,  5611,  5615,  5618,
    5620,  5624,  5627,  5630,  5635,  5637,  5639,  5641,  5643,  5645,
    5647,  5649,  5651,  5653,  5655,  5657,  5659,  5661,  5663,  5667,
    5670,  5672,  5674,  5676,  5678,  5680,  5682,  5684,  5686,  5688,
    5690,  5692,  5694,  5696,  5698,  5700,  5702,  5704,  5706,  5708,
    5710,  5712,  5714,  5716,  5718,  5720,  5722,  5724,  5726,  5728,
    5730,  5732,  5734,  5736,  5738,  5740,  5742,  5744,  5746,  5748,
    5750,  5752,  5754,  5756,  5758,  5760,  5762,  5764,  5766,  5768,
    5770,  5772,  5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,
    5790,  5792,  5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,
    5810,  5812,  5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,
    5830,  5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,
    5850,  5852,  5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,
    5870,  5872,  5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,
    5890,  5892,  5894,  5896,  5898,  5900,  5902,  5904,  5906,  5908,
    5910,  5912,  5914,  5916,  5918,  5920,  5922,  5924,  5926,  5928,
    5930,  5932,  5934,  5936,  5938,  5940,  5942,  5944,  5946,  5948,
    5950,  5952,  5954,  5956,  5958,  5960,  5962,  5964,  5966,  5968,
    5970,  5972,  5974,  5976,  5978,  5980,  5982,  5984,  5986,  5988,
    5990,  5992,  5994,  5996,  5998,  6000,  6002,  6004,  6006,  6008,
    6010,  6012,  6014,  6016,  6018,  6020,  6022,  6024,  6026,  6028,
    6030,  6032,  6034,  6036,  6038,  6040,  6042,  6044,  6046,  6048,
    6050,  6052,  6054,  6056,  6058,  6060,  6062,  6064,  6066,  6068,
    6070,  6072,  6074,  6076,  6078,  6080,  6082,  6084,  6086,  6088,
    6090,  6092,  6094,  6096,  6098,  6100,  6102,  6104,  6106,  6108,
    6110,  6112,  6114,  6116,  6118,  6120,  6122,  6124,  6126,  6128,
    6130,  6132,  6134,  6136,  6138,  6140,  6142,  6144,  6146,  6148,
    6150,  6152,  6154,  6156,  6158,  6160,  6162,  6164,  6166,  6168,
    6170,  6172,  6174,  6176,  6178,  6180,  6182,  6184,  6186,  6188,
    6190,  6192,  6194,  6196,  6198,  6200,  6202,  6204,  6206,  6208,
    6210,  6212,  6214,  6216,  6218,  6220,  6222,  6224,  6226,  6228,
    6230,  6232,  6234,  6236,  6238,  6240,  6242,  6244,  6246,  6248,
    6250,  6252,  6254,  6256,  6258,  6260,  6262,  6264,  6266,  6268,
    6270,  6272,  6274,  6276,  6278,  6280,  6282,  6284,  6286,  6288,
    6290,  6292,  6294,  6296,  6298,  6300,  6302,  6304,  6306,  6308,
    6310,  6312,  6314,  6316,  6318,  6320,  6322,  6324,  6326,  6327,
    6332,  6333,  6335,  6337,  6341,  6342,  6345,  6347,  6349,  6351,
    6353,  6354,  6356,  6357,  6359,  6361,  6363,  6364,  6367,  6370,
    6373,  6375,  6378,  6383,  6389,  6394,  6401,  6404,  6408,  6412,
    6416,  6422,  6424,  6428,  6432,  6435,  6438,  6441,  6443,  6445,
    6450,  6455,  6457,  6459,  6461,  6463,  6465,  6466,  6471,  6473,
    6475,  6477,  6481,  6485,  6487,  6489,  6492,  6495,  6496,  6500,
    6505,  6509,  6510,  6518,  6520,  6523,  6525,  6527,  6529,  6531,
    6533,  6535,  6536,  6542,  6544,  6546,  6548,  6550,  6552,  6556,
    6563,  6570,  6577,  6585,  6591,  6595,  6604,  6613,  6622,  6629,
    6630,  6632,  6634,  6637,  6638,  6640,  6642,  6646,  6647,  6651,
    6652,  6656,  6657,  6661,  6662,  6666,  6668,  6670,  6672,  6674,
    6676,  6678,  6680,  6682,  6684,  6686,  6688,  6691,  6694,  6696,
    6700,  6703,  6706,  6709,  6712,  6715,  6718,  6721,  6724,  6726,
    6728,  6731,  6732,  6734,  6738,  6740,  6743,  6746,  6749,  6751,
    6755,  6759,  6761,  6763,  6767,  6769,  6773,  6778,  6784,  6789,
    6796,  6798,  6799,  6803,  6807,  6809,  6811,  6812,  6815,  6818,
    6821,  6824,  6825,  6828,  6829,  6833,  6836,  6838,  6841,  6844,
    6847,  6850,  6853,  6854,  6858,  6859,  6861,  6862,  6866,  6869,
    6870,  6872,  6875,  6876,  6878,  6883,  6888,  6894,  6897,  6901,
    6902,  6904,  6905,  6910,  6911,  6913,  6915,  6916,  6918,  6919,
    6922,  6925,  6927,  6928,  6930,  6932,  6935,  6939,  6942,  6943,
    6950,  6954,  6955,  6956,  6957,  6959,  6962,  6964,  6966,  6968,
    6970,  6972,  6974,  6976,  6978,  6980,  6983,  6986,  6990,  6992,
    6994,  6996,  6998,  7000,  7002,  7004,  7006,  7008,  7010,  7012,
    7014,  7016,  7017,  7021,  7023,  7026,  7028,  7031,  7035,  7039,
    7043,  7044,  7048,  7052,  7053,  7061,  7062,  7066,  7068,  7072,
    7073,  7077,  7080,  7085,  7086,  7090,  7095,  7100,  7101,  7102,
    7103,  7120,  7129,  7137,  7138,  7139,  7140,  7141,  7142,  7158,
    7159,  7160,  7161,  7162,  7175,  7180,  7185,  7189,  7194,  7198,
    7201,  7203,  7207,  7213,  7215,  7217,  7218,  7220,  7222,  7223,
    7226,  7227,  7228,  7232,  7233,  7236,  7242
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     613,     0,    -1,   148,    -1,    -1,   616,   614,   608,   615,
      -1,   616,   148,    -1,    -1,   148,    -1,   617,    -1,  1428,
      -1,   960,    -1,  1017,    -1,  1019,    -1,   666,    -1,   629,
      -1,  1020,    -1,  1009,    -1,  1434,    -1,   636,    -1,   618,
      -1,  1258,    -1,  1290,    -1,  1210,    -1,  1212,    -1,   622,
      -1,  1296,    -1,  1402,    -1,  1393,    -1,   627,    -1,  1222,
      -1,  1498,    -1,  1315,    -1,  1318,    -1,  1385,    -1,  1025,
      -1,  1033,    -1,   809,    -1,  1040,    -1,   620,    -1,  1311,
      -1,  1437,    -1,  1028,    -1,  1012,    -1,  1225,    -1,  1305,
      -1,   701,    -1,  1400,    -1,  1435,    -1,  1436,    -1,  1052,
      -1,  1368,    -1,   694,    -1,  1276,    -1,   998,    -1,  1001,
      -1,  1269,    -1,  1499,    -1,  1391,    -1,  1250,    -1,  1317,
      -1,  1490,    -1,   619,   380,  1362,    -1,   115,    -1,   136,
      -1,   380,  1362,   182,   621,    -1,  1359,    -1,   609,  1364,
      -1,    -1,   161,  1362,   623,   624,    -1,    -1,   561,   625,
      -1,   625,   604,   626,    -1,   626,    -1,   609,  1364,    -1,
      -1,   200,   628,  1364,    -1,    -1,    56,   286,   529,   630,
     631,    -1,   632,    -1,   631,   604,   632,    -1,   273,   152,
    1359,    -1,   287,   152,  1359,    -1,   276,   152,  1359,    -1,
     277,   152,  1190,    -1,   272,   152,  1190,    -1,   284,   152,
    1190,    -1,   280,   152,  1359,    -1,   279,   152,  1359,    -1,
     281,   152,  1359,    -1,   282,   152,  1359,    -1,   283,   152,
    1359,    -1,   285,   152,  1190,    -1,   288,   152,  1347,    -1,
     214,   152,   602,   633,   603,    -1,   635,    -1,    -1,   634,
      -1,   633,   604,   634,    -1,  1190,    -1,   274,   152,  1359,
      -1,   275,   152,  1192,    -1,   410,   152,  1359,    -1,   411,
     152,  1190,    -1,    -1,    94,   861,   512,   864,  1355,   637,
     798,    -1,    -1,    94,   938,   217,  1362,   942,   347,  1355,
     638,   602,   955,   603,   943,    -1,    -1,    94,   939,   217,
    1362,   941,   347,  1355,   639,   602,   955,   603,   944,    -1,
      -1,    94,   940,   217,  1362,   941,   347,  1355,   640,   602,
     955,   603,   945,    -1,    -1,    94,   102,   864,  1362,   641,
     858,    -1,    -1,    94,   642,  1456,    -1,    94,   558,   659,
    1418,    -1,    94,   263,   194,   761,    -1,    94,   510,   758,
      -1,    94,   643,    -1,   453,  1364,   179,   105,   584,  1364,
     352,   602,   644,   603,    -1,   645,    -1,   644,   604,   645,
      -1,   558,  1359,    -1,   203,  1359,    -1,   102,  1359,    -1,
     362,  1359,    -1,   371,  1359,    -1,   469,  1359,    -1,   377,
    1190,    -1,    -1,  1069,   159,   864,   660,   647,   347,   442,
     648,   653,   650,   655,   135,   656,    -1,    -1,   160,  1073,
    1162,   649,   651,   652,    -1,    22,  1073,    -1,    -1,   144,
      -1,   129,   347,   465,    -1,   129,    -1,    -1,   488,  1073,
      -1,    -1,   147,  1073,    -1,    -1,   654,    -1,   347,    77,
     381,    -1,   347,    77,   336,   381,    -1,    -1,    73,  1359,
      -1,    -1,   657,   658,    -1,   707,    -1,   709,    -1,   705,
      -1,   726,    -1,   744,    -1,   746,    -1,   741,    -1,   711,
      -1,   713,    -1,   714,    -1,   715,    -1,   716,    -1,   718,
      -1,    -1,  1362,   610,  1362,    -1,  1362,    -1,    -1,   661,
     663,    -1,    -1,   662,   664,    -1,    73,  1359,    -1,   242,
     484,    -1,   338,   484,    -1,    87,   484,    -1,   396,   484,
     105,    -1,   313,   484,   105,    -1,   665,    -1,   663,    -1,
     127,    -1,  1079,   127,    -1,   484,   446,   120,    -1,   484,
     446,   229,    -1,    -1,    49,   660,   667,   668,    -1,    -1,
     602,   669,   603,    -1,    -1,   670,    -1,   670,   604,  1073,
      -1,  1073,    -1,    -1,   672,    -1,   672,   604,   674,    -1,
     674,    -1,    -1,  1362,   673,   910,    -1,    -1,   676,    -1,
     676,   604,   677,    -1,   677,    -1,   678,   673,  1362,   910,
      -1,    -1,   230,    -1,   361,    -1,   221,    -1,    -1,   679,
     704,   608,    -1,   704,   608,    -1,   680,   704,   608,    -1,
      -1,   681,   682,   608,    -1,    -1,   118,   702,   683,   910,
     703,    -1,   118,  1362,    80,   180,   690,    -1,    -1,   118,
     687,   197,   180,   684,   688,   704,    -1,   118,  1362,    99,
     180,   685,    -1,    -1,   686,  1052,    -1,   163,    -1,    89,
      -1,   689,    -1,   688,   604,   689,    -1,   693,    -1,  1190,
      -1,   691,    -1,   476,   692,  1360,    -1,    -1,   566,    -1,
     690,    -1,  1362,    -1,   477,    -1,  1079,   181,    -1,   475,
      -1,   462,   695,   697,    -1,  1362,    -1,   691,    -1,    -1,
     695,    -1,    -1,   455,   698,    -1,   700,   152,   699,    -1,
     698,   604,   700,   152,   699,    -1,  1346,    -1,  1100,    -1,
    1351,    -1,    63,    -1,   497,    -1,    84,    -1,    86,    -1,
      85,    -1,    54,    -1,   443,    -1,   514,    -1,    72,    -1,
     100,    -1,   304,    -1,   321,    -1,   425,   696,   697,    -1,
    1362,    -1,   702,   604,  1362,    -1,    -1,   119,  1073,    -1,
     707,    -1,   709,    -1,   705,    -1,   726,    -1,   744,    -1,
     746,    -1,   741,    -1,   711,    -1,   713,    -1,   714,    -1,
     715,    -1,   716,    -1,   718,    -1,    -1,   212,   706,   721,
     146,   212,    -1,    -1,   708,   617,    -1,    -1,   431,   710,
    1073,    -1,    -1,   712,   750,    -1,   247,  1363,    -1,   236,
    1363,    -1,   350,  1362,    -1,    -1,   171,   719,  1362,   227,
     717,   720,    -1,    65,  1362,    -1,    -1,   332,   182,    -1,
     182,    -1,  1362,    -1,   720,   604,  1362,    -1,    -1,    -1,
      -1,   722,  1073,   521,   723,   680,   724,   725,    -1,    -1,
     143,   721,    -1,   142,   680,    -1,   727,    -1,   730,    -1,
      -1,    -1,    52,   728,  1073,   729,   732,   740,   146,    52,
      -1,    -1,    52,   731,   733,   740,   146,    52,    -1,   734,
      -1,   732,   734,    -1,   737,    -1,   733,   737,    -1,    -1,
      -1,   577,   735,  1073,   736,   521,   680,    -1,    -1,    -1,
     577,   738,  1073,   739,   521,   680,    -1,    -1,   142,   680,
      -1,    -1,  1363,   611,   742,   750,   743,    -1,    -1,  1363,
      -1,    -1,  1363,   611,   745,   748,   743,    -1,    -1,   747,
     748,    -1,    -1,    30,   749,   681,   679,   146,    -1,   269,
     680,   146,   269,    -1,    -1,    -1,   579,   751,  1073,   135,
     752,   680,   146,   579,    -1,    -1,   420,   680,   554,   753,
    1073,   146,   420,    -1,    29,    -1,     8,    -1,   223,    -1,
     555,    -1,   123,    -1,   783,   785,    -1,   783,    56,   780,
     764,    -1,   783,     6,   780,   759,   768,    -1,    -1,   560,
     263,   194,  1362,    -1,   783,     6,   780,   771,    -1,   783,
     136,   780,   771,    -1,   784,   763,   774,    -1,   784,   763,
     777,    -1,     6,   781,    -1,     6,   782,    -1,    -1,   765,
     766,    -1,   767,    -1,   766,   767,    -1,   766,   604,   767,
      -1,   786,    -1,   787,    -1,   788,    -1,   769,    -1,   770,
      -1,   769,   770,    -1,   769,   604,   770,    -1,   786,    -1,
     787,    -1,   788,    -1,   789,    -1,   792,    -1,   794,    -1,
     796,    -1,   793,    -1,   772,    -1,   773,    -1,   772,   773,
      -1,   772,   604,   773,    -1,   786,    -1,   787,    -1,   788,
      -1,   794,    -1,   796,    -1,   775,    -1,   776,    -1,   775,
     776,    -1,   775,   604,   776,    -1,   786,    -1,   790,    -1,
     791,    -1,   792,    -1,   794,    -1,   796,    -1,   793,    -1,
     778,    -1,   779,    -1,   778,   779,    -1,   778,   604,   779,
      -1,   786,    -1,   794,    -1,   796,    -1,   104,  1359,    -1,
     544,  1359,    -1,   403,  1359,    -1,  1362,    -1,  1362,    -1,
     397,    -1,   399,    -1,   336,     4,    -1,   219,  1242,   797,
      -1,    24,  1242,   797,    -1,   293,  1242,   797,    -1,   166,
    1242,   797,    -1,   545,  1242,   797,    -1,   404,  1242,   797,
      -1,   333,  1242,  1191,    -1,    73,  1242,  1359,    -1,  1283,
     150,  1242,   872,    -1,    -1,   796,    -1,   574,    -1,   339,
      -1,  1191,    -1,   209,    -1,   602,   799,    -1,   865,   804,
     801,    -1,   252,  1355,    -1,   602,   252,  1355,   603,    -1,
     878,   603,   865,   804,   801,    -1,    -1,   804,   854,   603,
     800,  1441,    -1,    -1,    -1,  1326,   857,   854,   802,  1438,
      -1,    -1,  1326,   857,   602,   854,   603,   803,  1441,    -1,
     805,    -1,    -1,   806,    -1,    -1,   370,   808,   807,   811,
      -1,    -1,    -1,   370,   810,   811,    -1,    46,   812,   822,
     823,   830,    -1,   814,   240,   815,   602,   816,   603,    -1,
      -1,   814,   198,   813,   820,    -1,   395,   820,    -1,   395,
     819,    -1,   257,   820,    -1,   257,   819,    -1,    -1,   254,
      -1,    -1,    11,   152,  1191,    -1,    -1,   817,    -1,   818,
      -1,   817,   604,   818,    -1,  1362,    -1,    70,   602,   816,
     603,    -1,   602,  1069,   828,  1070,   603,    -1,   602,  1069,
     828,  1070,   603,    -1,    -1,   369,  1191,    -1,    -1,    -1,
     501,    46,   814,   198,   821,   824,   829,    -1,    -1,   501,
      46,   814,   240,   815,   602,   826,   603,   825,   829,    -1,
     827,    -1,   826,   604,   827,    -1,  1362,    -1,  1076,    -1,
      -1,   500,  1191,    -1,    -1,   602,   831,   603,    -1,   832,
      -1,   831,   604,   832,    -1,    -1,   370,   833,   834,   835,
     851,   846,    -1,  1362,    -1,    -1,    -1,   565,   249,   520,
     836,   838,    -1,    -1,   565,   230,   837,   839,    -1,   297,
      -1,   841,    -1,   841,    -1,   602,   840,   603,    -1,   841,
      -1,   840,   604,   841,    -1,    -1,    -1,   602,   842,   844,
     843,   603,    -1,   845,    -1,   844,   604,   845,    -1,   297,
      -1,  1076,    -1,    -1,   602,   847,   603,    -1,   848,    -1,
     847,   604,   848,    -1,    -1,   501,   849,   850,   851,    -1,
    1364,    -1,    -1,   852,    -1,   852,   853,    -1,   853,    -1,
     510,  1242,  1364,    -1,  1283,   150,  1242,   872,    -1,   333,
    1242,  1191,    -1,   292,  1242,  1193,    -1,   310,  1242,  1193,
      -1,   105,   128,  1242,  1359,    -1,   217,   128,  1242,  1359,
      -1,    73,  1242,  1359,    -1,    -1,    -1,   447,   855,  1063,
    1067,   856,   876,    -1,    -1,    18,    -1,    -1,   859,    -1,
     860,    -1,   859,   860,    -1,   871,    -1,   870,    -1,    -1,
     862,    -1,   863,    -1,   863,   862,    -1,   515,    -1,    -1,
     212,  1079,   162,    -1,    -1,   867,    -1,   868,    -1,   868,
     866,    -1,   868,    -1,   868,   867,    -1,   868,   604,   867,
      -1,   150,  1242,   872,    -1,   292,  1242,  1192,    -1,   310,
    1242,  1192,    -1,    26,  1242,  1190,    -1,   371,  1242,  1359,
      -1,    73,  1242,  1359,    -1,    25,  1242,  1192,    -1,   363,
    1242,  1190,    -1,   363,  1242,   119,    -1,    60,  1242,  1190,
      -1,   513,  1242,  1190,    -1,   122,  1242,  1190,    -1,   438,
    1242,   874,    -1,    -1,   549,  1242,   869,   602,  1304,   603,
      -1,   870,    -1,   871,    -1,   224,  1242,   875,    -1,   105,
     128,  1242,  1359,    -1,   217,   128,  1242,  1359,    -1,   510,
    1362,    -1,   494,   131,    -1,   494,   302,    -1,    81,  1242,
    1359,    -1,   239,  1242,  1190,    -1,   921,   912,  1242,   914,
      -1,   921,    68,  1242,   920,    -1,  1364,    -1,  1364,    -1,
     119,    -1,   174,    -1,   140,    -1,    78,    -1,   405,    -1,
      76,    -1,   338,    -1,   173,    -1,   243,    -1,  1185,    -1,
    1062,  1066,    -1,   496,    -1,   400,    -1,   117,    -1,   228,
      -1,   879,    -1,   880,    -1,   879,   604,   880,    -1,   881,
      -1,   882,    -1,   887,   883,    -1,   887,   927,    -1,   933,
     957,   942,   602,   955,   603,   943,    -1,   939,   936,   957,
     941,   602,   955,   603,   944,    -1,   940,   936,   957,   941,
     602,   955,   603,   945,    -1,   885,   934,   957,   942,   602,
     955,   603,   943,    -1,   885,   179,   240,   957,   602,   955,
     603,   927,    -1,   885,   884,    -1,    -1,   884,    -1,    61,
     602,  1073,   603,    -1,    -1,   886,    -1,    83,   957,    -1,
      -1,  1354,   888,   889,   907,    -1,   897,   905,   901,    -1,
     898,   906,   901,    -1,   176,   899,   901,    -1,    38,    -1,
      38,   904,    -1,    43,    -1,    42,    -1,   893,   904,   924,
      -1,   893,   924,    -1,   894,   904,   925,    -1,   894,   925,
      -1,    33,   904,    -1,    33,    -1,   895,   904,   924,    -1,
     896,   904,   925,    -1,   567,   904,    -1,   591,   905,   901,
      -1,   109,    -1,   525,    -1,   522,    -1,   106,    -1,   526,
      -1,    40,   905,    -1,   892,    -1,   298,    -1,   265,    -1,
     268,   567,    -1,   268,   895,   924,    -1,   528,   924,    -1,
     519,   905,   924,    -1,   300,   924,    -1,   266,   924,    -1,
     117,   899,   901,    -1,   343,   899,   901,    -1,   174,   899,
     901,    -1,    -1,   151,   890,   602,   959,   603,   924,    -1,
      -1,   455,   891,   602,   959,   603,   924,    -1,   268,   924,
      -1,   451,    -1,   189,    -1,   188,    -1,   375,    -1,   318,
      -1,   256,    -1,   317,    -1,   376,    -1,   319,    -1,    59,
      -1,   327,    -1,   324,    59,    -1,   893,   571,    -1,   568,
      -1,   324,   568,    -1,   344,    -1,   327,   568,    -1,   324,
      59,   571,    -1,   327,   571,    -1,   228,    -1,   527,    -1,
     467,    -1,   299,    -1,    32,    -1,   400,    -1,   134,    -1,
     134,   379,    -1,    -1,   904,    -1,   900,    -1,   602,   342,
     604,   342,   603,    -1,    -1,   902,    -1,   902,   903,    -1,
     903,    -1,   463,    -1,   553,    -1,   592,    -1,   602,   267,
     603,    -1,   602,   540,   603,    -1,   602,   116,   603,    -1,
     602,   342,   603,    -1,    -1,   904,    -1,    -1,   900,    -1,
      -1,   908,    -1,   908,   909,    -1,   909,    -1,   341,    -1,
    1079,   341,    -1,   119,   911,    -1,   347,   555,   337,  1072,
      -1,    25,    -1,   451,   119,   566,    -1,   926,   240,    -1,
     550,    -1,   550,   240,    -1,    73,  1359,    -1,    68,   918,
      -1,   889,   919,    -1,   337,  1072,    -1,  1345,    -1,    59,
     455,    -1,    58,    -1,  1364,    -1,    33,    -1,   913,    -1,
     119,    -1,    -1,   912,   914,    -1,  1364,    -1,    33,    -1,
     916,    -1,   119,    -1,  1364,    -1,    -1,    68,   920,    -1,
     918,    -1,   119,    -1,    -1,   119,    -1,    20,    -1,    33,
      20,    -1,    20,    33,    -1,   547,    -1,   547,    33,    -1,
      33,   547,    -1,    -1,   922,    -1,   923,    -1,    47,    -1,
     912,   913,   925,    -1,    33,    -1,    33,   912,   913,    -1,
      -1,    33,    -1,    -1,   383,    -1,   406,  1355,   928,   930,
     931,    -1,    -1,   602,   929,   603,    -1,   929,   604,  1362,
      -1,  1362,    -1,    -1,   289,   183,    -1,   289,   367,    -1,
     289,   464,    -1,    -1,   347,   555,   932,    -1,   347,   123,
     932,    -1,   347,   555,   932,   347,   123,   932,    -1,   347,
     123,   932,   347,   555,   932,    -1,   428,    -1,    50,    -1,
     455,   341,    -1,   338,     5,    -1,   455,   119,    -1,   935,
      -1,   383,   240,    -1,   550,   936,    -1,   240,    -1,   217,
      -1,    -1,   935,    -1,   238,    -1,   217,    -1,   216,    -1,
      -1,   550,    -1,   184,    -1,   473,    -1,    -1,   941,    -1,
     941,   949,    -1,    -1,   946,    -1,    -1,   948,    -1,    -1,
     947,    -1,   951,    -1,   946,   951,    -1,   952,    -1,   947,
     952,    -1,   953,    -1,   948,   953,    -1,   561,   954,    -1,
     538,   954,    -1,   239,  1242,  1190,    -1,    73,  1359,    -1,
     950,    -1,   949,    -1,   950,    -1,   950,    -1,   580,   366,
    1358,    -1,    45,    -1,   440,    -1,   198,    -1,   955,   604,
     956,  1183,    -1,   956,  1183,    -1,  1362,    -1,  1362,   602,
     342,   603,    -1,    -1,  1354,    -1,    -1,   610,  1362,    -1,
    1343,    -1,   959,   604,  1343,    -1,    -1,    13,   994,   512,
    1355,   961,   972,    -1,    -1,    13,   102,   971,   962,   859,
      -1,    13,   102,  1362,   556,   105,   128,   323,    -1,    -1,
      13,   385,   660,   963,   661,    -1,    -1,    13,   185,   660,
     964,   661,    -1,    -1,    13,  1464,  1459,   965,  1466,    -1,
      -1,    13,  1459,   966,  1466,    -1,    -1,    13,  1459,   159,
     660,   967,   968,   969,   650,   655,   970,    -1,    13,   510,
     760,    -1,    13,   263,   194,   762,    -1,    13,   510,   757,
      -1,    13,   510,   756,    -1,    13,   453,  1364,   352,   602,
     644,   603,    -1,    -1,   347,   442,   648,    -1,   654,    -1,
     347,   442,   648,   654,    -1,    -1,   416,   529,   660,    -1,
      -1,   135,   656,    -1,    -1,  1362,    -1,    -1,   130,   510,
      -1,   215,   510,    -1,   987,   805,    -1,   987,   976,    -1,
     976,    -1,   806,    -1,   978,    -1,   136,   370,   985,    -1,
     401,   370,  1027,   977,    -1,    -1,   351,   370,  1027,   977,
     973,  1027,    -1,    14,   370,  1027,   977,    -1,    -1,    61,
     370,   977,   974,  1022,    -1,    -1,   418,   370,  1027,   977,
     975,  1014,    -1,    66,   370,  1027,  1191,    -1,   536,   370,
     977,    -1,   981,    -1,   415,   368,    -1,    12,    -1,   985,
      -1,    -1,     6,   370,  1027,   979,   980,    -1,    -1,   602,
     831,   603,    -1,   369,  1191,    -1,    -1,   417,   370,  1027,
     982,   983,    -1,    -1,    -1,   985,   984,   227,   602,   831,
     603,    -1,   986,    -1,   985,   604,   986,    -1,  1362,    -1,
     989,    -1,   987,   604,   989,    -1,     6,   993,    -1,   988,
     881,   996,    -1,     6,   882,    -1,   988,   602,   878,   603,
      -1,    -1,    56,   993,  1354,   990,   887,   996,    -1,    -1,
      -1,   314,   993,  1354,   991,   889,   907,   992,   996,    -1,
     136,   993,  1354,   995,    -1,   136,   179,   240,   957,    -1,
     136,   383,   240,    -1,   136,   935,  1354,    -1,   129,   238,
      -1,   144,   238,    -1,    13,   993,  1354,   455,   119,  1345,
      -1,    13,   993,  1354,   136,   119,    -1,   416,   997,  1355,
      -1,    91,   529,   912,   914,   919,    -1,   866,    -1,   178,
      -1,  1176,    -1,    -1,    71,    -1,    -1,   213,    -1,    -1,
     428,    -1,    50,    -1,    -1,     8,  1362,    -1,   173,    -1,
      -1,   529,    -1,   152,    -1,    18,    -1,    -1,   489,   465,
    1003,   999,  1007,    -1,   493,   465,  1003,    -1,    -1,   465,
     489,  1003,  1000,  1007,    -1,   465,   493,  1003,    -1,   489,
     531,  1002,    -1,    -1,   580,    82,   468,    -1,    -1,  1004,
    1005,    -1,  1006,    -1,  1005,   604,  1006,    -1,    -1,   485,
      -1,   412,    -1,    -1,   554,  1008,    -1,   635,    -1,  1008,
     604,   635,    -1,    -1,    60,  1387,  1010,  1216,  1011,    -1,
      -1,   394,    -1,   165,    -1,    -1,   418,  1027,  1387,  1013,
    1216,  1014,    -1,    -1,  1015,    -1,  1016,    -1,  1016,  1015,
      -1,   394,    -1,   165,    -1,   559,    -1,    -1,    14,  1027,
    1387,  1018,  1216,    -1,    34,  1359,    -1,    -1,    61,  1387,
    1021,  1216,  1022,    -1,    -1,  1023,    -1,  1024,    -1,  1024,
    1023,    -1,   394,    -1,   169,    -1,   301,    -1,   165,    -1,
      57,    -1,   180,   556,    -1,    -1,   351,  1027,  1387,  1026,
    1216,    -1,    -1,   340,    -1,   259,    -1,    -1,   416,  1387,
    1029,  1031,    -1,   416,   558,   659,  1030,    -1,  1365,   529,
    1365,    -1,  1030,   604,  1365,   529,  1365,    -1,  1032,    -1,
    1031,   604,  1032,    -1,  1355,   529,  1355,    -1,    -1,    48,
     217,  1034,  1035,   230,  1039,    -1,  1036,    -1,  1038,    -1,
    1037,    -1,  1036,   604,  1037,    -1,  1355,  1048,    -1,  1355,
    1046,  1048,    -1,  1362,    -1,   119,    -1,    -1,   258,   217,
     227,    48,  1041,  1042,    -1,  1045,    -1,  1043,    -1,  1044,
      -1,  1043,   604,  1044,    -1,  1355,  1048,  1051,    -1,  1355,
    1046,  1048,  1051,    -1,    -1,   370,   808,  1047,   602,   977,
     603,    -1,    -1,  1049,  1050,    -1,    -1,   935,   602,  1158,
     603,    -1,    -1,   213,   246,    -1,  1053,    -1,   447,  1056,
      -1,   602,  1054,   603,  1441,    -1,   447,  1058,    -1,   602,
    1054,   603,    -1,   447,  1137,    -1,   602,  1055,   603,    -1,
      -1,  1058,  1057,  1438,    -1,    -1,    -1,  1059,  1063,  1067,
    1060,  1061,  1066,    -1,  1179,  1185,    -1,  1205,    -1,  1062,
      -1,  1205,  1062,    -1,  1062,  1205,    -1,   182,  1119,  1168,
    1173,  1170,  1179,  1185,  1196,    -1,   182,   137,  1168,  1185,
      -1,    -1,  1064,    -1,  1064,  1065,    -1,  1065,    -1,  1455,
      -1,   482,    -1,   480,    -1,    -1,   180,   555,    -1,   262,
     230,   457,   312,    -1,  1067,   604,  1068,    -1,  1068,    -1,
     597,    -1,  1069,  1349,  1070,    -1,  1069,  1073,  1070,  1071,
      -1,    -1,    -1,    -1,    18,  1362,    -1,    18,  1359,    -1,
    1362,    -1,  1359,    -1,    -1,   602,   603,    -1,  1073,  1077,
    1073,    -1,  1073,   589,  1073,    -1,  1073,  1078,  1073,    -1,
     336,  1073,    -1,  1074,   233,   535,    -1,  1074,   233,  1079,
     535,    -1,  1074,   233,   168,    -1,  1074,   233,  1079,   168,
      -1,  1074,   233,   551,    -1,  1074,   233,  1079,   551,    -1,
    1074,    -1,  1074,   233,   341,    -1,  1074,   233,  1079,   341,
      -1,  1074,   153,  1075,    -1,  1074,  1081,  1075,    -1,  1074,
    1081,  1082,   602,  1450,   603,    -1,  1075,    -1,  1076,   230,
     602,  1450,   603,    -1,  1076,  1079,   230,   602,  1450,   603,
      -1,  1076,   230,   602,  1073,   603,    -1,  1076,   230,   602,
    1073,   604,  1112,   603,    -1,  1076,  1079,   230,   602,  1073,
     603,    -1,  1076,  1079,   230,   602,  1073,   604,  1112,   603,
      -1,  1076,    31,  1076,    16,  1075,    -1,  1076,  1079,    31,
    1076,    16,  1075,    -1,  1076,   471,   252,  1076,    -1,  1076,
     252,  1083,  1172,    -1,  1076,  1079,   252,  1083,  1172,    -1,
    1076,   407,  1076,    -1,  1076,  1079,   407,  1076,    -1,  1076,
      -1,  1076,   593,  1076,    -1,  1076,   594,  1076,    -1,  1076,
     458,  1076,    -1,  1076,   459,  1076,    -1,  1076,   596,  1076,
      -1,  1076,   595,  1076,    -1,  1076,   596,   226,  1073,  1162,
      -1,  1076,   595,   226,  1073,  1162,    -1,  1076,   597,  1076,
      -1,  1076,   598,  1076,    -1,  1076,   599,  1076,    -1,  1076,
     133,  1076,    -1,  1076,   315,  1076,    -1,  1076,   600,  1076,
      -1,  1083,    -1,   358,    -1,   355,    -1,    16,    -1,    15,
      -1,   336,    -1,   335,    -1,   605,    -1,   335,    -1,   152,
      -1,   186,    -1,   196,    -1,   244,    -1,   271,    -1,   329,
      -1,    12,    -1,    17,    -1,  1351,    -1,  1084,    -1,  1085,
      -1,  1088,    -1,  1086,    -1,  1083,    68,  1364,    -1,  1346,
      -1,  1344,    -1,  1100,    -1,  1096,    -1,  1083,   357,  1083,
      -1,   596,  1083,    -1,   595,  1083,    -1,   601,  1083,    -1,
    1080,  1083,    -1,   602,  1450,   603,    -1,   602,  1073,   603,
      -1,   602,  1073,   604,  1112,   603,    -1,   439,   602,  1073,
     604,  1112,   603,    -1,   162,   602,  1450,   603,    -1,   606,
    1362,  1073,   607,    -1,   289,  1113,     9,   602,  1076,  1090,
     603,    -1,    33,  1083,    -1,    53,   602,  1073,    18,  1110,
     603,    -1,    52,  1115,  1117,  1116,   146,    -1,    91,   602,
    1073,   604,  1110,   603,    -1,    91,   602,  1073,   561,   913,
     603,    -1,   119,   602,  1351,   603,    -1,   565,   602,  1352,
     603,    -1,   226,  1073,  1162,   596,  1073,    -1,    59,   602,
    1112,   603,    -1,    59,   602,  1112,   561,   913,   603,    -1,
      98,  1072,    -1,   109,   602,  1073,   603,    -1,   114,   602,
    1073,   603,    -1,   208,   602,  1073,   603,    -1,   223,   602,
    1073,   604,  1073,   604,  1073,   604,  1073,   603,    -1,   226,
     602,  1073,   604,  1073,   603,    -1,   226,   602,  1073,   604,
    1073,   604,  1112,   603,    -1,   248,   602,  1073,   604,  1073,
     603,    -1,   309,   602,  1073,   603,    -1,   316,   602,  1073,
     603,    -1,   433,   602,  1073,   604,  1073,   603,    -1,   445,
     602,  1073,   603,    -1,   525,   602,  1073,   603,    -1,   522,
     602,  1073,   603,    -1,   522,   602,  1073,   604,  1073,   603,
      -1,   534,   602,  1073,   603,    -1,   534,   602,   245,  1073,
     182,  1073,   603,    -1,   534,   602,   530,  1073,   182,  1073,
     603,    -1,   534,   602,    44,  1073,   182,  1073,   603,    -1,
     534,   602,   245,   182,  1073,   603,    -1,   534,   602,   530,
     182,  1073,   603,    -1,   534,   602,    44,   182,  1073,   603,
      -1,   534,   602,  1073,   182,  1073,   603,    -1,   558,   602,
     603,    -1,   591,   602,  1073,   603,    -1,     7,   602,  1073,
     604,  1073,   603,    -1,     7,   602,  1073,   604,   226,  1073,
    1162,   603,    -1,    97,  1072,    -1,   101,  1072,    -1,   101,
     602,  1073,   603,    -1,   107,   602,  1073,   604,   226,  1073,
    1162,   603,    -1,   108,   602,  1073,   604,   226,  1073,  1162,
     603,    -1,   167,   602,  1162,   182,  1073,   603,    -1,   190,
     602,  1164,   604,  1073,   603,    -1,   337,  1072,    -1,   337,
     602,  1073,   603,    -1,   378,   602,  1076,   230,  1073,   603,
      -1,   498,   602,  1073,   604,  1073,   603,    -1,   498,   602,
    1073,   604,   226,  1073,  1162,   603,    -1,   502,   602,  1073,
     604,  1073,   604,  1073,   603,    -1,   502,   602,  1073,   604,
    1073,   603,    -1,   502,   602,  1073,   182,  1073,   180,  1073,
     603,    -1,   502,   602,  1073,   182,  1073,   603,    -1,   508,
    1072,    -1,   508,   602,  1073,   603,    -1,   523,   602,  1163,
     604,  1073,   604,  1073,   603,    -1,   524,   602,  1163,   604,
    1073,   604,  1073,   603,    -1,   562,  1072,    -1,   564,  1072,
      -1,   563,  1072,    -1,    20,   602,  1073,   603,    -1,    58,
     602,  1073,   603,    -1,    66,   602,  1112,   603,    -1,    69,
     602,  1073,   603,    -1,   102,   602,   603,    -1,   212,   602,
    1073,   604,  1073,   604,  1073,   603,    -1,   305,   602,  1073,
     603,    -1,   315,   602,  1073,   604,  1073,   603,    -1,   346,
     602,  1073,   603,    -1,   371,   602,  1073,   603,    -1,   392,
     602,  1073,   603,    -1,   420,   602,  1073,   604,  1073,   603,
      -1,   421,   602,  1073,   604,  1073,   604,  1073,   603,    -1,
     536,   602,  1073,   604,  1073,   603,    -1,   576,   602,  1073,
     603,    -1,   576,   602,  1073,   604,  1073,   603,    -1,  1087,
      -1,    87,   602,  1073,   604,  1073,   603,    -1,   188,   602,
    1112,   603,    -1,   256,   602,  1112,   603,    -1,   317,   602,
    1112,   603,    -1,   318,   602,  1112,   603,    -1,   319,   602,
    1112,   603,    -1,   375,   602,  1073,   604,  1073,   603,    -1,
     376,   602,  1112,   603,    -1,    -1,  1358,   602,  1089,  1093,
     603,    -1,  1362,   610,  1362,   602,  1111,   603,    -1,  1091,
    1092,    -1,   230,    42,   312,    -1,    -1,   230,   325,   242,
     312,    -1,    -1,   580,   393,   164,    -1,    -1,  1094,    -1,
    1095,    -1,  1094,   604,  1095,    -1,  1069,  1073,  1070,  1071,
      -1,    27,   602,  1108,   603,    -1,    27,   602,   132,  1108,
     603,    -1,    36,   602,  1108,   603,    -1,    37,   602,  1108,
     603,    -1,    39,   602,  1108,   603,    -1,    92,   602,  1167,
     597,   603,    -1,    92,   602,  1108,   603,    -1,    -1,    -1,
      92,   602,   132,  1097,  1112,  1098,   603,    -1,   311,   602,
    1108,   603,    -1,   311,   602,   132,  1108,   603,    -1,   294,
     602,  1108,   603,    -1,   294,   602,   132,  1108,   603,    -1,
     492,   602,  1108,   603,    -1,   570,   602,  1108,   603,    -1,
     491,   602,  1108,   603,    -1,   572,   602,  1108,   603,    -1,
     503,   602,  1108,   603,    -1,   503,   602,   132,  1108,   603,
      -1,    -1,   195,   602,  1103,  1099,  1112,  1105,  1104,   603,
      -1,    -1,   609,  1101,  1102,    -1,  1364,   456,  1073,    -1,
    1364,    -1,   609,  1377,  1364,   958,    -1,    -1,   132,    -1,
      -1,   449,  1343,    -1,    -1,    -1,   356,    46,  1106,  1107,
      -1,  1107,   604,  1350,  1183,    -1,  1350,  1183,    -1,    -1,
    1167,  1109,  1073,    -1,    33,   905,    -1,    59,   905,   924,
      -1,   327,   905,    -1,   463,    -1,   463,   228,    -1,   553,
      -1,   553,   228,    -1,   109,    -1,   525,    -1,   106,    -1,
     117,   899,    -1,    -1,  1112,    -1,  1073,    -1,  1112,   604,
    1073,    -1,  1114,    -1,   602,  1114,   603,    -1,  1351,    -1,
    1114,   604,  1351,    -1,    -1,  1073,    -1,    -1,   142,  1073,
      -1,   577,  1073,   521,  1073,    -1,  1117,   577,  1073,   521,
    1073,    -1,  1131,    -1,  1122,    -1,  1121,    -1,  1118,    -1,
     606,  1362,  1118,   607,    -1,  1120,    -1,  1121,   604,  1120,
      -1,  1118,  1130,  1118,    -1,  1118,   495,  1131,    -1,    -1,
    1118,  1130,  1118,   347,  1123,  1073,    -1,    -1,  1118,   495,
    1131,   347,  1124,  1073,    -1,    -1,  1118,  1130,  1118,   561,
    1125,   602,  1161,   603,    -1,  1118,   325,   237,  1131,    -1,
      -1,  1118,   248,  1147,   237,  1118,   347,  1126,  1073,    -1,
      -1,  1118,   248,  1147,   237,  1131,  1127,   561,   602,  1161,
     603,    -1,  1118,   325,   248,  1147,   237,  1131,    -1,    -1,
    1118,   433,  1147,   237,  1118,   347,  1128,  1073,    -1,    -1,
    1118,   433,  1147,   237,  1131,  1129,   561,   602,  1161,   603,
      -1,  1118,   325,   433,  1147,   237,  1131,    -1,   237,    -1,
     220,   237,    -1,    95,   237,    -1,    -1,  1132,  1355,  1166,
    1156,    -1,  1146,  1145,  1142,    -1,   602,  1145,  1133,   603,
    1166,    -1,  1140,  1442,    -1,    -1,    -1,  1133,   549,  1446,
    1134,  1447,  1135,  1442,    -1,  1137,    -1,    -1,    -1,  1138,
    1453,  1067,  1139,   876,  1066,    -1,    -1,  1145,  1141,  1121,
      -1,    -1,    -1,  1143,  1063,  1067,  1144,   876,    -1,    -1,
     447,    -1,    -1,   359,    -1,    -1,   180,   237,    -1,   180,
     356,    46,    -1,   180,   194,    46,    -1,   178,    -1,   213,
      -1,    -1,  1149,   935,  1148,  1151,   602,  1160,   603,    -1,
      -1,   560,   935,  1148,  1152,   602,  1158,   603,    -1,  1150,
      -1,  1153,  1150,    -1,    -1,    -1,  1155,  1153,    -1,    -1,
    1157,  1154,    -1,    -1,  1160,    -1,  1362,    -1,   383,    -1,
    1159,    -1,  1160,   604,  1159,    -1,  1362,    -1,  1161,   604,
    1362,    -1,  1163,    -1,   110,    -1,   111,    -1,   112,    -1,
     113,    -1,   205,    -1,   206,    -1,   207,    -1,   307,    -1,
     308,    -1,   444,    -1,   590,    -1,   114,    -1,   576,    -1,
     208,    -1,   309,    -1,   316,    -1,   392,    -1,   445,    -1,
     305,    -1,   591,    -1,   109,    -1,   525,    -1,   106,    -1,
     522,    -1,    -1,    18,    -1,   152,    -1,    -1,  1165,  1362,
      -1,    -1,    12,    -1,    -1,    -1,   578,  1169,  1073,    -1,
      -1,    -1,   199,  1171,  1073,    -1,   157,  1083,    -1,    -1,
      -1,   194,    46,  1174,  1175,    -1,  1174,   604,  1350,  1183,
      -1,  1350,  1183,    -1,    -1,   581,    -1,   582,    -1,   356,
      46,  1177,    -1,  1177,   604,  1178,    -1,  1178,    -1,  1352,
    1183,    -1,    -1,  1180,    -1,    -1,   356,    46,  1181,  1182,
      -1,  1182,   604,  1350,  1183,    -1,  1350,  1183,    -1,    -1,
      19,    -1,   124,    -1,    -1,  1186,    -1,    -1,  1186,    -1,
     253,  1187,    -1,  1188,    -1,  1188,   604,  1188,    -1,  1188,
     345,  1188,    -1,  1362,    -1,  1344,    -1,   540,    -1,   267,
      -1,   342,    -1,    -1,   253,  1188,    -1,   342,    -1,   201,
      -1,   267,    -1,   540,    -1,   116,    -1,   175,    -1,   342,
      -1,   201,    -1,   267,    -1,   540,    -1,  1194,    -1,   342,
      -1,   540,    -1,   267,    -1,   116,    -1,   175,    -1,   342,
      -1,   540,    -1,   267,    -1,  1194,    -1,  1195,    -1,   116,
      -1,   175,    -1,    -1,    -1,   385,  1362,  1197,   602,  1198,
     603,    -1,    -1,  1199,    -1,  1199,   604,  1200,    -1,  1200,
      -1,  1069,  1073,  1070,    -1,    -1,  1202,  1203,    -1,  1203,
     604,  1204,    -1,  1204,    -1,   609,  1364,    -1,  1364,    -1,
      -1,   227,  1206,  1207,    -1,    -1,    -1,   360,  1361,  1208,
     915,  1209,  1327,  1330,    -1,   138,  1361,    -1,  1201,    -1,
      -1,   135,  1211,  1112,    -1,    -1,   136,  1221,  1387,  1220,
    1213,  1216,   995,    -1,    -1,   136,   217,  1362,   347,  1355,
    1214,    -1,   136,   102,  1220,  1362,    -1,   136,   185,  1220,
    1362,   610,  1362,    -1,   136,   185,  1220,  1362,    -1,   136,
     385,  1220,   660,    -1,   136,   558,   659,  1417,    -1,    -1,
     136,   573,  1220,  1215,  1216,   995,    -1,   136,   159,  1220,
     660,    -1,   136,   533,  1220,   660,    -1,   136,   510,   783,
     794,   795,    -1,   136,   263,   194,   784,   794,   795,    -1,
     136,   453,  1220,  1364,    -1,  1217,    -1,  1216,   604,  1217,
      -1,  1355,    -1,  1219,    -1,  1218,   604,  1219,    -1,  1356,
      -1,    -1,   212,   162,    -1,    -1,   515,    -1,    -1,    -1,
     223,  1223,  1228,   994,  1230,  1224,  1232,  1248,    -1,    -1,
      -1,   421,  1226,  1229,  1230,  1227,  1232,    -1,    -1,   270,
      -1,   121,    -1,   202,    -1,  1257,    -1,   121,    -1,   227,
    1231,    -1,  1231,    -1,  1217,    -1,  1235,    -1,   602,   603,
    1235,    -1,   602,  1234,   603,  1235,    -1,    -1,   455,  1233,
    1239,    -1,  1234,   604,  1348,    -1,  1348,    -1,   565,  1238,
      -1,   566,  1238,    -1,    -1,   854,  1236,  1438,    -1,    -1,
     602,   854,   603,  1237,  1441,    -1,  1238,   604,  1243,    -1,
    1243,    -1,  1239,   604,  1240,    -1,  1240,    -1,  1352,  1241,
    1247,    -1,   152,    -1,   456,    -1,    -1,  1241,    -1,    -1,
     602,  1244,  1245,   603,    -1,    -1,  1246,    -1,  1246,   604,
    1247,    -1,  1247,    -1,  1073,    -1,   119,    -1,    -1,    -1,
     347,   139,  1249,   240,   555,  1255,    -1,    -1,    -1,   555,
    1251,  1257,   994,  1119,   455,  1253,  1252,  1168,  1179,  1189,
      -1,  1253,   604,  1254,    -1,  1254,    -1,  1352,  1241,  1247,
      -1,  1255,   604,  1256,    -1,  1256,    -1,  1352,  1241,  1247,
      -1,    -1,   270,    -1,    -1,   123,  1259,  1267,  1260,    -1,
      -1,   182,  1355,  1261,  1168,  1179,  1189,    -1,    -1,  1264,
    1262,   182,  1119,  1168,    -1,    -1,   182,  1218,  1263,   561,
    1119,  1168,    -1,  1265,    -1,  1264,   604,  1265,    -1,  1362,
    1266,    -1,  1362,   610,  1362,  1266,    -1,    -1,   610,   597,
      -1,    -1,  1268,  1267,    -1,   394,    -1,   270,    -1,   213,
      -1,    -1,   536,  1271,  1270,  1217,    -1,    -1,   512,    -1,
      -1,  1273,    -1,  1274,    -1,  1273,   604,  1274,    -1,    93,
      -1,   302,    -1,    41,   231,    -1,    88,   507,    -1,   364,
     170,    -1,   232,    -1,   506,    -1,   472,    -1,    12,    -1,
      -1,   180,   393,   342,    -1,    -1,   460,  1277,  1278,    -1,
     103,  1289,    -1,  1285,   509,  1284,  1289,    -1,  1285,   532,
    1284,  1289,    -1,   158,  1284,  1289,    -1,   512,   490,  1284,
    1289,    -1,   350,   509,  1284,  1289,    -1,   373,    -1,   150,
     873,  1281,    -1,   150,    12,  1281,    -1,  1285,    70,  1286,
    1355,  1284,  1289,    -1,  1282,   264,    -1,   465,   204,    -1,
      -1,    34,   158,  1287,  1288,  1279,  1184,    -1,    -1,   409,
     158,  1287,  1288,  1280,  1184,    -1,   937,  1286,  1355,  1284,
    1168,    -1,  1283,   149,    -1,    23,    -1,    90,    -1,   384,
      -1,    92,   602,   597,   603,   575,    -1,    92,   602,   597,
     603,   155,    -1,   575,  1184,    -1,   155,  1184,    -1,   389,
      -1,   388,  1272,  1275,  1184,    -1,  1376,   490,  1289,    -1,
    1285,   387,    -1,  1376,   569,  1289,    -1,   912,  1289,    -1,
      69,  1289,    -1,   193,    -1,   193,   180,  1365,    -1,    94,
     102,   864,  1362,    -1,    94,   512,  1355,    -1,    94,   573,
    1355,    -1,   286,   490,    -1,   465,   490,    -1,    94,   385,
     660,    -1,    94,   185,   660,    -1,    94,   533,   660,    -1,
     385,   490,  1289,    -1,   185,   490,  1289,    -1,   385,    67,
     660,    -1,   185,    67,   660,    -1,    94,   159,   660,    -1,
     490,    -1,   320,    -1,   264,    -1,   286,    -1,    33,    -1,
      -1,   494,    -1,    -1,  1286,  1362,    -1,    -1,   183,    -1,
     182,    -1,   230,    -1,    -1,   230,  1359,    -1,    -1,   182,
    1192,    -1,    -1,   252,  1359,    -1,   578,  1073,    -1,    -1,
    1293,  1355,  1291,  1295,    -1,    -1,  1293,  1294,  1292,  1052,
      -1,   124,    -1,   125,    -1,    -1,   165,    -1,   369,    -1,
      -1,  1343,    -1,  1362,    -1,    -1,   177,  1027,  1297,  1298,
      -1,    -1,    -1,  1387,  1299,  1304,  1300,  1301,    -1,  1302,
      -1,    -1,   580,   398,   262,    -1,  1302,   604,  1303,    -1,
    1303,    -1,   154,   264,    -1,   150,   264,    -1,   187,   264,
      -1,   466,   264,    -1,    33,   264,    -1,   408,   264,    -1,
     393,    48,    -1,   204,    -1,   384,    -1,   264,    -1,   490,
      -1,   465,    -1,   286,    -1,   126,    -1,   426,    -1,    -1,
    1216,    -1,    -1,   424,  1306,  1307,    -1,  1307,   604,  1308,
      -1,  1308,    -1,    -1,   465,  1309,  1310,    -1,   286,    -1,
     393,    48,    -1,    -1,    12,    -1,    -1,   391,  1312,  1313,
      -1,  1282,   264,  1314,    -1,   529,  1359,    -1,    29,  1073,
      -1,   241,  1316,  1073,    -1,    -1,    81,    -1,   393,    -1,
     560,  1362,    -1,    -1,    -1,    -1,    -1,   258,  1323,  1319,
    1325,  1324,   218,  1361,  1320,  1326,   227,   512,  1355,  1321,
     915,  1322,  1333,  1327,  1330,  1334,  1336,  1339,    -1,   105,
      -1,   588,    -1,    -1,   259,    -1,    -1,    79,    -1,   270,
      -1,    -1,   421,    -1,   213,    -1,    -1,    70,  1328,    -1,
    1328,  1329,    -1,  1329,    -1,   517,    46,  1343,    -1,   354,
     145,    46,  1343,    -1,   145,    46,  1343,    -1,   156,    46,
    1343,    -1,    -1,   255,  1331,    -1,  1331,  1332,    -1,  1332,
      -1,   517,    46,  1343,    -1,   487,    46,  1343,    -1,    -1,
     437,   210,    46,  1343,    -1,    -1,   213,   342,  1335,    -1,
     255,    -1,   437,    -1,    -1,   602,  1337,   603,    -1,   602,
     603,    -1,  1337,   604,  1338,    -1,  1338,    -1,  1352,    -1,
     609,  1364,    -1,    -1,   455,  1340,    -1,  1340,   604,  1341,
      -1,  1341,    -1,  1352,  1241,  1069,  1247,  1070,    -1,   518,
      -1,   326,    -1,   543,   518,    -1,  1342,  1360,    -1,  1360,
      -1,   201,    -1,    35,    -1,   365,    -1,  1346,    -1,   596,
    1347,    -1,   595,  1347,    -1,  1342,    -1,  1347,    -1,   341,
      -1,   168,    -1,   535,    -1,   201,    -1,    35,    -1,   543,
     201,    -1,   543,    35,    -1,   109,  1342,    -1,   525,  1342,
      -1,   522,  1342,    -1,   342,    -1,   267,    -1,   540,    -1,
     116,    -1,   175,    -1,  1352,    -1,  1349,    -1,  1362,   610,
     597,    -1,  1362,   610,  1362,   610,   597,    -1,  1073,    -1,
    1362,    -1,  1353,    -1,  1362,    -1,  1353,    -1,  1362,   610,
    1362,    -1,   610,  1362,   610,  1362,    -1,  1362,   610,  1362,
     610,  1362,    -1,  1362,    -1,  1362,   610,  1362,   610,  1362,
      -1,  1362,   610,  1362,    -1,   610,  1362,    -1,  1362,    -1,
    1362,   610,  1362,    -1,   610,  1362,    -1,  1362,  1266,    -1,
    1362,   610,  1362,  1266,    -1,  1362,    -1,   209,    -1,   211,
      -1,   518,    -1,   518,    -1,   518,    -1,  1358,    -1,  1366,
      -1,  1358,    -1,  1367,    -1,  1362,    -1,  1359,    -1,   251,
      -1,  1364,    -1,  1364,   609,  1364,    -1,    98,  1072,    -1,
    1367,    -1,    20,    -1,    28,    -1,    30,    -1,    47,    -1,
      48,    -1,    58,    -1,    60,    -1,    65,    -1,    73,    -1,
      75,    -1,    87,    -1,   115,    -1,   135,    -1,   146,    -1,
     161,    -1,   177,    -1,   197,    -1,   200,    -1,   203,    -1,
     225,    -1,   242,    -1,   338,    -1,   350,    -1,   352,    -1,
     362,    -1,   366,    -1,   370,    -1,   377,    -1,   380,    -1,
     415,    -1,   418,    -1,   424,    -1,   427,    -1,   434,    -1,
     441,    -1,   446,    -1,   453,    -1,   463,    -1,   469,    -1,
     465,    -1,   470,    -1,   489,    -1,   493,    -1,   536,    -1,
     547,    -1,   548,    -1,   584,    -1,   587,    -1,   556,    -1,
       5,    -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,
      11,    -1,    17,    -1,    22,    -1,    23,    -1,    25,    -1,
      24,    -1,    26,    -1,    27,    -1,    34,    -1,    38,    -1,
      41,    -1,    43,    -1,    42,    -1,    45,    -1,    51,    -1,
      54,    -1,    55,    -1,    57,    -1,    62,    -1,    64,    -1,
      63,    -1,    66,    -1,    67,    -1,    69,    -1,    72,    -1,
      70,    -1,    74,    -1,    76,    -1,    77,    -1,    78,    -1,
      79,    -1,    81,    -1,    82,    -1,    84,    -1,    86,    -1,
      85,    -1,    88,    -1,    90,    -1,    93,    -1,    96,    -1,
     100,    -1,   105,    -1,   104,    -1,   106,    -1,   109,    -1,
     114,    -1,   120,    -1,   122,    -1,   126,    -1,   128,    -1,
     129,    -1,   130,    -1,   131,    -1,   138,    -1,   139,    -1,
     140,    -1,   147,    -1,   151,    -1,   150,    -1,   149,    -1,
     154,    -1,   155,    -1,   157,    -1,   159,    -1,   158,    -1,
     160,    -1,   164,    -1,   165,    -1,   166,    -1,   170,    -1,
     169,    -1,   181,    -1,   144,    -1,   183,    -1,   172,    -1,
     173,    -1,   174,    -1,   187,    -1,   189,    -1,   188,    -1,
     190,    -1,   193,    -1,   191,    -1,   198,    -1,   204,    -1,
     208,    -1,   210,    -1,   214,    -1,   229,    -1,   215,    -1,
     216,    -1,   219,    -1,   231,    -1,   232,    -1,   234,    -1,
     235,    -1,   224,    -1,   239,    -1,   243,    -1,   246,    -1,
     249,    -1,   250,    -1,   256,    -1,   257,    -1,   259,    -1,
     261,    -1,   263,    -1,   264,    -1,   292,    -1,   286,    -1,
     288,    -1,   273,    -1,   277,    -1,   274,    -1,   275,    -1,
     287,    -1,   276,    -1,   278,    -1,   272,    -1,   284,    -1,
     280,    -1,   279,    -1,   281,    -1,   282,    -1,   283,    -1,
     290,    -1,   291,    -1,   293,    -1,   295,    -1,   296,    -1,
     301,    -1,   302,    -1,   303,    -1,   304,    -1,   305,    -1,
     306,    -1,   309,    -1,   310,    -1,   314,    -1,   312,    -1,
     316,    -1,   317,    -1,   318,    -1,   319,    -1,   320,    -1,
     321,    -1,   323,    -1,   322,    -1,   324,    -1,   327,    -1,
     328,    -1,   332,    -1,   331,    -1,   339,    -1,   333,    -1,
     334,    -1,   344,    -1,   345,    -1,   346,    -1,   348,    -1,
     349,    -1,   363,    -1,   364,    -1,   367,    -1,   368,    -1,
     369,    -1,   371,    -1,   372,    -1,   374,    -1,   373,    -1,
     375,    -1,   376,    -1,   381,    -1,   382,    -1,   384,    -1,
     386,    -1,   387,    -1,   388,    -1,   389,    -1,   390,    -1,
     392,    -1,   393,    -1,   394,    -1,   397,    -1,   401,    -1,
     402,    -1,   404,    -1,   403,    -1,   405,    -1,   408,    -1,
     409,    -1,   410,    -1,   411,    -1,   412,    -1,   414,    -1,
     417,    -1,   419,    -1,   422,    -1,   426,    -1,   429,    -1,
     430,    -1,   435,    -1,   436,    -1,   437,    -1,   438,    -1,
     439,    -1,   440,    -1,   442,    -1,   443,    -1,   445,    -1,
     451,    -1,   450,    -1,   452,    -1,   464,    -1,   457,    -1,
     461,    -1,   466,    -1,   468,    -1,   471,    -1,   472,    -1,
     480,    -1,   479,    -1,   482,    -1,   485,    -1,   488,    -1,
     490,    -1,   494,    -1,   496,    -1,   497,    -1,   498,    -1,
     499,    -1,   501,    -1,   500,    -1,   504,    -1,   505,    -1,
     506,    -1,   507,    -1,   514,    -1,   509,    -1,   513,    -1,
     510,    -1,   515,    -1,   516,    -1,   519,    -1,   520,    -1,
     531,    -1,   532,    -1,   522,    -1,   523,    -1,   524,    -1,
     525,    -1,   537,    -1,   538,    -1,   539,    -1,   185,    -1,
     541,    -1,   542,    -1,   545,    -1,   544,    -1,   551,    -1,
     554,    -1,   558,    -1,   559,    -1,   569,    -1,   573,    -1,
     566,    -1,   575,    -1,   574,    -1,   576,    -1,   583,    -1,
     586,    -1,   588,    -1,   591,    -1,    -1,   455,  1370,  1369,
    1371,    -1,    -1,   353,    -1,  1372,    -1,  1371,   604,  1372,
      -1,    -1,  1373,  1378,    -1,  1375,    -1,   191,    -1,   259,
      -1,   452,    -1,    -1,   348,    -1,    -1,   191,    -1,   259,
      -1,   452,    -1,    -1,   191,   610,    -1,   259,   610,    -1,
     452,   610,    -1,  1379,    -1,  1375,  1380,    -1,  1374,  1381,
    1241,  1384,    -1,  1374,   531,   234,   250,  1382,    -1,   609,
    1364,  1241,  1073,    -1,   609,   609,  1377,  1381,  1241,  1384,
      -1,   912,   917,    -1,   322,  1241,  1073,    -1,   322,   914,
     919,    -1,   371,  1241,  1383,    -1,   371,   180,  1365,  1241,
    1383,    -1,  1362,    -1,  1362,   610,  1362,    -1,   119,   610,
    1362,    -1,   398,   541,    -1,   398,    74,    -1,   419,   398,
      -1,   450,    -1,   518,    -1,   371,   602,   518,   603,    -1,
     346,   602,   518,   603,    -1,  1073,    -1,   119,    -1,   347,
      -1,    12,    -1,    33,    -1,    -1,   262,  1387,  1386,  1388,
      -1,   512,    -1,   509,    -1,  1389,    -1,  1388,   604,  1389,
      -1,  1355,  1166,  1390,    -1,   398,    -1,   585,    -1,   270,
     585,    -1,   398,   259,    -1,    -1,   552,  1392,  1387,    -1,
     197,  1355,   350,  1166,    -1,   197,  1357,    65,    -1,    -1,
     197,  1357,   398,  1394,  1395,  1168,  1185,    -1,  1396,    -1,
    1362,  1397,    -1,   173,    -1,   332,    -1,   173,    -1,   332,
      -1,   382,    -1,   243,    -1,    -1,  1399,  1398,   602,  1246,
     603,    -1,   152,    -1,   186,    -1,   244,    -1,   196,    -1,
     271,    -1,   432,   659,  1401,    -1,  1405,   347,  1404,  1416,
     182,  1418,    -1,  1405,   347,   185,  1416,   182,  1418,    -1,
    1405,   347,   385,  1416,   182,  1418,    -1,    12,  1406,   604,
     192,   353,   182,  1418,    -1,   390,   347,  1365,   182,  1418,
      -1,   192,   659,  1403,    -1,  1405,   347,  1404,  1416,   529,
    1418,  1423,  1424,    -1,  1405,   347,   185,  1416,   529,  1418,
    1423,  1424,    -1,  1405,   347,   385,  1416,   529,  1418,  1423,
    1424,    -1,   390,   347,  1365,   529,  1418,  1425,    -1,    -1,
     512,    -1,  1407,    -1,    12,  1406,    -1,    -1,   384,    -1,
    1408,    -1,  1407,   604,  1408,    -1,    -1,   447,  1409,  1420,
      -1,    -1,   223,  1410,  1420,    -1,    -1,   555,  1411,  1420,
      -1,    -1,   406,  1412,  1420,    -1,   123,    -1,   557,    -1,
     217,    -1,    13,    -1,    94,    -1,   136,    -1,   161,    -1,
     414,    -1,   461,    -1,   386,    -1,   172,    -1,   192,   353,
      -1,   460,   103,    -1,   504,    -1,    94,   515,   509,    -1,
     262,   509,    -1,   422,   465,    -1,   422,    64,    -1,    94,
     573,    -1,   460,   573,    -1,    94,   436,    -1,    13,   436,
      -1,    94,   558,    -1,   159,    -1,   533,    -1,    94,   510,
      -1,    -1,    16,    -1,  1415,  1413,  1414,    -1,  1415,    -1,
     499,   518,    -1,   235,   518,    -1,    62,   518,    -1,   597,
      -1,  1362,   610,   597,    -1,   597,   610,   597,    -1,  1355,
      -1,  1365,    -1,  1417,   604,  1365,    -1,  1419,    -1,  1418,
     604,  1419,    -1,  1365,   210,    46,   518,    -1,  1365,   210,
      46,   371,   518,    -1,  1365,   210,   580,  1364,    -1,  1365,
     210,   580,  1364,    18,  1359,    -1,  1365,    -1,    -1,   602,
    1421,   603,    -1,  1421,   604,  1422,    -1,  1422,    -1,  1362,
      -1,    -1,   423,  1414,    -1,   423,   486,    -1,   423,   586,
      -1,   423,   334,    -1,    -1,   580,  1426,    -1,    -1,   580,
     192,   353,    -1,  1426,  1427,    -1,  1427,    -1,   192,   353,
      -1,   291,  1190,    -1,   295,  1190,    -1,   290,  1190,    -1,
     296,  1190,    -1,    -1,    30,  1429,  1430,    -1,    -1,   583,
      -1,    -1,    16,   338,    55,    -1,    16,    55,    -1,    -1,
     413,    -1,   338,   413,    -1,    -1,   441,    -1,    75,  1430,
    1431,  1432,    -1,   434,  1430,  1431,  1432,    -1,   434,  1430,
     529,  1433,  1362,    -1,   441,  1362,    -1,   413,   441,  1362,
      -1,    -1,  1439,    -1,    -1,   549,  1446,  1440,  1053,    -1,
      -1,  1439,    -1,  1443,    -1,    -1,  1443,    -1,    -1,  1444,
    1445,    -1,  1180,  1184,    -1,  1186,    -1,    -1,   132,    -1,
      12,    -1,   447,  1136,    -1,   602,  1055,   603,    -1,  1447,
    1442,    -1,    -1,  1448,   549,  1446,  1449,  1447,  1442,    -1,
    1451,  1448,  1452,    -1,    -1,    -1,    -1,  1454,    -1,  1454,
    1455,    -1,  1455,    -1,   495,    -1,   202,    -1,   132,    -1,
     483,    -1,   478,    -1,   479,    -1,   481,    -1,    12,    -1,
    1461,  1457,    -1,  1460,  1458,    -1,  1462,  1459,  1466,    -1,
    1466,    -1,  1474,    -1,  1485,    -1,  1479,    -1,   646,    -1,
    1466,    -1,  1474,    -1,  1485,    -1,  1479,    -1,  1478,    -1,
     646,    -1,  1460,    -1,  1461,    -1,    -1,   120,   152,  1365,
      -1,  1463,    -1,  1463,  1464,    -1,  1464,    -1,   358,   421,
      -1,    11,   152,   542,    -1,    11,   152,   303,    -1,    11,
     152,   516,    -1,    -1,   484,   446,   120,    -1,   484,   446,
     229,    -1,    -1,  1465,   573,  1355,  1467,  1468,    18,  1470,
      -1,    -1,   602,  1469,   603,    -1,  1362,    -1,  1469,   604,
    1362,    -1,    -1,  1471,  1472,  1473,    -1,   447,  1056,    -1,
     602,  1054,   603,  1441,    -1,    -1,   580,    61,   353,    -1,
     580,    51,    61,   353,    -1,   580,   259,    61,   353,    -1,
      -1,    -1,    -1,   533,  1069,   660,   754,   755,   347,  1069,
    1475,  1355,   180,  1069,  1476,   141,   439,  1477,   704,    -1,
      10,  1069,   185,  1362,   430,   877,   470,  1359,    -1,  1069,
     185,  1362,   430,   877,   470,  1359,    -1,    -1,    -1,    -1,
      -1,    -1,  1069,   185,   660,   602,  1480,   671,   603,  1481,
     430,  1482,   910,  1483,   662,  1484,   704,    -1,    -1,    -1,
      -1,    -1,   385,  1069,   660,  1486,   602,  1487,   675,   603,
    1488,   662,  1489,   704,    -1,   587,  1492,  1491,  1493,    -1,
     587,   146,  1491,  1495,    -1,   587,   380,  1491,    -1,   587,
      75,  1491,  1494,    -1,   587,   434,  1491,    -1,   587,   402,
      -1,  1343,    -1,  1343,   604,  1343,    -1,  1343,   604,  1343,
     604,  1190,    -1,    30,    -1,   489,    -1,    -1,   237,    -1,
     429,    -1,    -1,   349,   372,    -1,    -1,    -1,   505,  1496,
    1497,    -1,    -1,   180,   306,    -1,   225,   374,  1362,   470,
    1359,    -1,   548,   374,  1362,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1660,  1660,  1673,  1672,  1697,  1704,  1706,  1710,  1711,
    1716,  1717,  1718,  1719,  1720,  1721,  1722,  1723,  1724,  1725,
    1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,  1735,
    1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,  1745,
    1746,  1747,  1748,  1749,  1750,  1751,  1752,  1753,  1754,  1755,
    1756,  1757,  1758,  1759,  1760,  1761,  1762,  1763,  1764,  1765,
    1766,  1770,  1780,  1781,  1785,  1795,  1802,  1813,  1812,  1823,
    1825,  1829,  1830,  1834,  1847,  1846,  1866,  1865,  1879,  1880,
    1884,  1888,  1892,  1896,  1900,  1904,  1909,  1913,  1917,  1921,
    1925,  1929,  1935,  1966,  1971,  1974,  1976,  1977,  1981,  1995,
    1999,  2015,  2019,  2031,  2030,  2072,  2071,  2083,  2081,  2094,
    2092,  2104,  2103,  2116,  2115,  2123,  2127,  2131,  2135,  2142,
    2155,  2156,  2160,  2164,  2168,  2172,  2176,  2180,  2184,  2192,
    2191,  2223,  2222,  2229,  2236,  2237,  2243,  2249,  2259,  2265,
    2271,  2273,  2280,  2281,  2285,  2291,  2300,  2301,  2309,  2309,
    2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,  2375,  2376,
    2377,  2378,  2379,  2384,  2398,  2414,  2433,  2434,  2438,  2439,
    2444,  2446,  2448,  2450,  2452,  2454,  2456,  2462,  2463,  2464,
    2468,  2472,  2480,  2479,  2492,  2494,  2497,  2499,  2503,  2507,
    2514,  2516,  2520,  2521,  2526,  2545,  2571,  2573,  2577,  2578,
    2582,  2608,  2609,  2610,  2611,  2615,  2616,  2620,  2621,  2626,
    2629,  2656,  2655,  2720,  2736,  2735,  2789,  2815,  2815,  2838,
    2839,  2844,  2846,  2851,  2874,  2887,  2891,  2908,  2909,  2913,
    2917,  2926,  2933,  2940,  2950,  2965,  2988,  2994,  2995,  3001,
    3004,  3008,  3016,  3036,  3038,  3056,  3062,  3064,  3066,  3068,
    3070,  3072,  3074,  3076,  3078,  3080,  3082,  3084,  3089,  3104,
    3119,  3137,  3138,  3142,  3143,  3144,  3145,  3146,  3147,  3148,
    3149,  3150,  3151,  3152,  3153,  3154,  3159,  3158,  3165,  3165,
    3222,  3221,  3250,  3250,  3264,  3317,  3360,  3381,  3380,  3402,
    3421,  3423,  3424,  3428,  3448,  3471,  3473,  3489,  3471,  3508,
    3510,  3511,  3515,  3516,  3521,  3527,  3520,  3548,  3547,  3563,
    3564,  3568,  3569,  3574,  3578,  3573,  3599,  3603,  3598,  3622,
    3632,  3637,  3636,  3672,  3673,  3678,  3677,  3710,  3710,  3725,
    3724,  3760,  3772,  3774,  3771,  3801,  3800,  3821,  3823,  3828,
    3830,  3832,  3849,  3854,  3860,  3867,  3868,  3876,  3882,  3891,
    3897,  3903,  3904,  3908,  3908,  3913,  3914,  3915,  3919,  3920,
    3921,  3925,  3929,  3930,  3931,  3935,  3936,  3937,  3938,  3939,
    3940,  3941,  3942,  3946,  3950,  3951,  3952,  3956,  3957,  3958,
    3959,  3960,  3964,  3968,  3969,  3970,  3974,  3975,  3976,  3977,
    3978,  3979,  3980,  3984,  3988,  3989,  3990,  3994,  3995,  3996,
    4001,  4009,  4017,  4025,  4037,  4049,  4054,  4059,  4067,  4075,
    4083,  4091,  4099,  4107,  4115,  4128,  4141,  4154,  4156,  4160,
    4165,  4178,  4179,  4230,  4231,  4234,  4249,  4267,  4272,  4270,
    4277,  4279,  4278,  4282,  4281,  4287,  4324,  4325,  4330,  4329,
    4348,  4367,  4366,  4383,  4387,  4395,  4394,  4397,  4399,  4401,
    4403,  4408,  4409,  4415,  4416,  4433,  4434,  4438,  4439,  4443,
    4462,  4472,  4483,  4492,  4493,  4509,  4511,  4510,  4515,  4513,
    4524,  4525,  4529,  4547,  4563,  4564,  4580,  4595,  4617,  4618,
    4623,  4622,  4646,  4656,  4678,  4677,  4695,  4694,  4714,  4736,
    4740,  4769,  4781,  4782,  4787,  4798,  4786,  4823,  4824,  4828,
    4841,  4862,  4875,  4901,  4902,  4907,  4906,  4943,  4948,  4949,
    4953,  4954,  4958,  4960,  4966,  4968,  4970,  4972,  4974,  4976,
    4986,  5001,  4985,  5015,  5016,  5020,  5021,  5025,  5026,  5030,
    5031,  5035,  5036,  5040,  5041,  5045,  5049,  5050,  5053,  5055,
    5059,  5060,  5064,  5065,  5066,  5070,  5075,  5080,  5085,  5090,
    5095,  5100,  5105,  5120,  5126,  5131,  5136,  5141,  5147,  5146,
    5172,  5173,  5174,  5179,  5184,  5189,  5191,  5193,  5195,  5201,
    5209,  5227,  5244,  5267,  5281,  5282,  5283,  5284,  5285,  5286,
    5290,  5291,  5292,  5296,  5297,  5301,  5302,  5303,  5304,  5309,
    5316,  5317,  5321,  5322,  5326,  5327,  5334,  5339,  5345,  5351,
    5357,  5375,  5381,  5383,  5387,  5391,  5392,  5396,  5401,  5400,
    5423,  5424,  5425,  5426,  5431,  5435,  5440,  5445,  5449,  5454,
    5459,  5465,  5470,  5476,  5480,  5485,  5490,  5508,  5510,  5512,
    5525,  5527,  5532,  5537,  5549,  5554,  5559,  5564,  5566,  5568,
    5570,  5572,  5574,  5576,  5578,  5581,  5580,  5585,  5584,  5588,
    5590,  5599,  5600,  5601,  5606,  5607,  5608,  5609,  5610,  5614,
    5618,  5619,  5623,  5624,  5628,  5629,  5630,  5631,  5632,  5636,
    5637,  5638,  5639,  5640,  5644,  5649,  5651,  5657,  5658,  5660,
    5665,  5674,  5675,  5679,  5680,  5684,  5685,  5686,  5690,  5691,
    5692,  5693,  5696,  5697,  5701,  5702,  5706,  5707,  5711,  5712,
    5716,  5717,  5718,  5719,  5726,  5727,  5733,  5739,  5745,  5751,
    5752,  5769,  5790,  5796,  5801,  5802,  5806,  5814,  5818,  5819,
    5823,  5824,  5828,  5837,  5841,  5842,  5846,  5857,  5858,  5862,
    5863,  5867,  5868,  5873,  5874,  5878,  5885,  5894,  5902,  5913,
    5914,  5915,  5916,  5917,  5918,  5923,  5931,  5932,  5936,  5938,
    5942,  5954,  5955,  5959,  5966,  5979,  5980,  5982,  5984,  5990,
    5995,  6001,  6007,  6014,  6024,  6025,  6026,  6027,  6028,  6032,
    6036,  6037,  6041,  6042,  6046,  6047,  6051,  6052,  6053,  6057,
    6058,  6062,  6066,  6079,  6091,  6092,  6096,  6097,  6101,  6102,
    6106,  6107,  6111,  6112,  6116,  6117,  6121,  6122,  6126,  6127,
    6131,  6133,  6137,  6138,  6142,  6146,  6147,  6160,  6161,  6162,
    6166,  6167,  6171,  6177,  6191,  6192,  6196,  6197,  6201,  6202,
    6210,  6209,  6248,  6247,  6261,  6273,  6272,  6291,  6290,  6309,
    6308,  6327,  6321,  6341,  6340,  6373,  6378,  6383,  6388,  6393,
    6403,  6404,  6405,  6406,  6410,  6411,  6423,  6424,  6428,  6429,
    6432,  6434,  6435,  6436,  6438,  6440,  6441,  6450,  6451,  6455,
    6464,  6462,  6476,  6490,  6489,  6503,  6501,  6515,  6522,  6533,
    6537,  6544,  6548,  6553,  6552,  6568,  6570,  6575,  6583,  6582,
    6598,  6602,  6601,  6613,  6614,  6618,  6633,  6634,  6638,  6647,
    6651,  6656,  6661,  6660,  6671,  6680,  6670,  6695,  6704,  6708,
    6717,  6726,  6732,  6738,  6747,  6756,  6775,  6796,  6806,  6810,
    6818,  6819,  6823,  6824,  6828,  6829,  6830,  6834,  6835,  6836,
    6840,  6841,  6842,  6843,  6852,  6851,  6862,  6870,  6869,  6879,
    6888,  6897,  6898,  6905,  6905,  6911,  6912,  6916,  6917,  6918,
    6922,  6923,  6939,  6940,  6945,  6944,  6956,  6957,  6958,  6963,
    6962,  6984,  6985,  6989,  6990,  6994,  6995,  6996,  7001,  7000,
    7022,  7031,  7030,  7057,  7058,  7062,  7063,  7067,  7068,  7069,
    7070,  7071,  7072,  7077,  7076,  7098,  7099,  7100,  7105,  7104,
    7110,  7117,  7122,  7130,  7131,  7135,  7149,  7148,  7161,  7162,
    7166,  7167,  7171,  7181,  7191,  7192,  7197,  7196,  7207,  7208,
    7212,  7213,  7217,  7227,  7238,  7237,  7245,  7245,  7256,  7257,
    7262,  7263,  7272,  7281,  7282,  7286,  7291,  7296,  7301,  7306,
    7305,  7325,  7333,  7325,  7340,  7341,  7342,  7343,  7344,  7348,
    7355,  7362,  7364,  7375,  7376,  7380,  7381,  7409,  7439,  7441,
    7447,  7457,  7458,  7459,  7474,  7481,  7507,  7513,  7519,  7520,
    7521,  7522,  7523,  7527,  7528,  7533,  7584,  7591,  7634,  7640,
    7646,  7652,  7658,  7664,  7670,  7676,  7680,  7686,  7692,  7698,
    7704,  7710,  7714,  7720,  7730,  7736,  7744,  7750,  7760,  7766,
    7775,  7785,  7791,  7801,  7807,  7816,  7820,  7826,  7832,  7838,
    7844,  7850,  7856,  7862,  7868,  7874,  7880,  7886,  7892,  7898,
    7904,  7908,  7909,  7913,  7914,  7918,  7919,  7923,  7924,  7928,
    7929,  7930,  7931,  7932,  7933,  7937,  7938,  7942,  7943,  7944,
    7945,  7946,  7947,  7959,  7960,  7961,  7962,  7963,  7969,  7973,
    7979,  7985,  7991,  7997,  7999,  8006,  8013,  8019,  8021,  8030,
    8037,  8045,  8051,  8058,  8064,  8078,  8085,  8101,  8107,  8113,
    8121,  8127,  8133,  8139,  8145,  8160,  8172,  8178,  8184,  8190,
    8196,  8202,  8208,  8214,  8220,  8226,  8232,  8238,  8244,  8250,
    8256,  8262,  8268,  8276,  8297,  8304,  8310,  8317,  8324,  8331,
    8338,  8345,  8351,  8357,  8364,  8371,  8377,  8384,  8390,  8396,
    8402,  8408,  8414,  8432,  8442,  8448,  8454,  8461,  8468,  8483,
    8489,  8495,  8501,  8507,  8514,  8520,  8526,  8532,  8538,  8550,
    8556,  8562,  8568,  8574,  8586,  8592,  8608,  8614,  8621,  8628,
    8635,  8642,  8649,  8653,  8673,  8672,  8745,  8787,  8789,  8794,
    8795,  8799,  8800,  8804,  8805,  8809,  8816,  8824,  8850,  8856,
    8862,  8868,  8874,  8880,  8889,  8896,  8898,  8895,  8905,  8916,
    8922,  8928,  8934,  8940,  8946,  8952,  8958,  8964,  8971,  8970,
    8990,  8989,  9004,  9014,  9022,  9038,  9039,  9044,  9049,  9052,
    9055,  9054,  9071,  9073,  9079,  9078,  9095,  9097,  9099,  9101,
    9103,  9105,  9107,  9109,  9111,  9113,  9115,  9120,  9121,  9125,
    9132,  9140,  9141,  9145,  9152,  9160,  9161,  9165,  9166,  9170,
    9178,  9189,  9190,  9199,  9210,  9211,  9217,  9218,  9238,  9240,
    9244,  9242,  9259,  9257,  9275,  9273,  9280,  9289,  9287,  9305,
    9304,  9314,  9325,  9323,  9342,  9341,  9352,  9363,  9364,  9365,
    9377,  9377,  9391,  9431,  9503,  9514,  9519,  9511,  9538,  9558,
    9566,  9558,  9575,  9574,  9597,  9614,  9597,  9621,  9625,  9651,
    9652,  9657,  9660,  9661,  9662,  9666,  9667,  9672,  9671,  9677,
    9676,  9684,  9685,  9688,  9690,  9690,  9694,  9694,  9699,  9700,
    9704,  9706,  9711,  9712,  9716,  9727,  9740,  9741,  9742,  9743,
    9744,  9745,  9746,  9747,  9748,  9749,  9750,  9751,  9755,  9756,
    9757,  9758,  9759,  9760,  9761,  9762,  9763,  9767,  9768,  9769,
    9770,  9773,  9775,  9776,  9780,  9781,  9789,  9791,  9795,  9797,
    9796,  9810,  9813,  9812,  9827,  9833,  9848,  9850,  9854,  9856,
    9861,  9862,  9882,  9907,  9911,  9912,  9916,  9929,  9931,  9936,
    9935,  9970,  9972,  9977,  9978,  9979,  9984,  9990,  9994,  9995,
    9999, 10006, 10013, 10020, 10030, 10064, 10068, 10074, 10080, 10090,
   10094, 10104, 10105, 10106, 10107, 10108, 10109, 10113, 10114, 10115,
   10116, 10117, 10121, 10122, 10123, 10124, 10125, 10129, 10130, 10131,
   10132, 10136, 10141, 10142, 10145, 10148, 10147, 10178, 10179, 10183,
   10184, 10188, 10200, 10200, 10210, 10211, 10215, 10234, 10267, 10266,
   10279, 10287, 10278, 10289, 10301, 10313, 10312, 10330, 10329, 10340,
   10340, 10356, 10363, 10386, 10407, 10419, 10424, 10423, 10433, 10439,
   10446, 10451, 10456, 10466, 10467, 10471, 10482, 10483, 10487, 10498,
   10499, 10503, 10504, 10512, 10520, 10511, 10530, 10537, 10529, 10547,
   10559, 10560, 10568, 10572, 10573, 10584, 10585, 10589, 10598, 10599,
   10600, 10602, 10601, 10612, 10613, 10617, 10618, 10620, 10619, 10623,
   10622, 10628, 10629, 10633, 10634, 10638, 10648, 10649, 10653, 10654,
   10659, 10658, 10672, 10673, 10677, 10682, 10690, 10691, 10699, 10701,
   10701, 10709, 10717, 10708, 10739, 10740, 10744, 10752, 10753, 10757,
   10767, 10768, 10775, 10774, 10790, 10789, 10801, 10800, 10812, 10811,
   10825, 10826, 10830, 10843, 10859, 10860, 10864, 10865, 10869, 10870,
   10871, 10876, 10875, 10897, 10899, 10902, 10904, 10907, 10908, 10911,
   10915, 10919, 10923, 10927, 10931, 10935, 10939, 10943, 10951, 10954,
   10964, 10963, 10978, 10985, 10993, 11001, 11009, 11017, 11025, 11032,
   11034, 11036, 11045, 11049, 11054, 11053, 11059, 11058, 11063, 11072,
   11079, 11088, 11097, 11102, 11104, 11106, 11108, 11110, 11112, 11119,
   11127, 11129, 11137, 11144, 11151, 11161, 11168, 11174, 11183, 11191,
   11195, 11199, 11206, 11213, 11219, 11226, 11233, 11238, 11243, 11251,
   11253, 11255, 11260, 11261, 11264, 11266, 11270, 11271, 11275, 11276,
   11280, 11281, 11285, 11286, 11290, 11291, 11294, 11296, 11303, 11314,
   11313, 11329, 11328, 11338, 11339, 11343, 11344, 11345, 11349, 11350,
   11351, 11366, 11365, 11378, 11387, 11377, 11389, 11393, 11394, 11408,
   11409, 11414, 11416, 11418, 11420, 11422, 11424, 11426, 11428, 11430,
   11432, 11434, 11436, 11441, 11443, 11445, 11450, 11451, 11456, 11455,
   11465, 11466, 11470, 11470, 11472, 11473, 11477, 11478, 11483, 11482,
   11493, 11497, 11501, 11513, 11523, 11524, 11525, 11531, 11543, 11555,
   11565, 11575, 11542, 11583, 11584, 11588, 11589, 11593, 11594, 11606,
   11610, 11611, 11612, 11615, 11617, 11621, 11622, 11626, 11631, 11638,
   11643, 11650, 11652, 11656, 11657, 11661, 11666, 11674, 11675, 11678,
   11680, 11688, 11690, 11694, 11695, 11696, 11700, 11702, 11707, 11708,
   11717, 11718, 11722, 11723, 11727, 11740, 11764, 11776, 11787, 11806,
   11814, 11826, 11841, 11862, 11863, 11864, 11872, 11873, 11874, 11881,
   11887, 11893, 11899, 11905, 11934, 11962, 11963, 11964, 11968, 11978,
   11988, 11994, 12003, 12018, 12019, 12023, 12032, 12048, 12052, 12099,
   12103, 12121, 12125, 12204, 12229, 12260, 12261, 12277, 12287, 12291,
   12297, 12303, 12313, 12319, 12328, 12338, 12339, 12369, 12385, 12401,
   12418, 12419, 12430, 12431, 12442, 12443, 12444, 12448, 12465, 12487,
   12502, 12503, 12504, 12505, 12506, 12507, 12508, 12509, 12510, 12511,
   12512, 12513, 12514, 12515, 12516, 12517, 12518, 12519, 12520, 12521,
   12522, 12523, 12524, 12525, 12526, 12527, 12528, 12529, 12530, 12531,
   12532, 12533, 12534, 12535, 12536, 12537, 12538, 12539, 12540, 12541,
   12542, 12543, 12544, 12545, 12546, 12547, 12548, 12549, 12550, 12551,
   12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568, 12569, 12570,
   12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578, 12579, 12580,
   12581, 12582, 12583, 12584, 12585, 12586, 12587, 12588, 12589, 12590,
   12591, 12592, 12593, 12594, 12595, 12596, 12597, 12598, 12599, 12600,
   12601, 12602, 12603, 12604, 12605, 12606, 12607, 12608, 12609, 12610,
   12611, 12612, 12613, 12614, 12615, 12616, 12617, 12618, 12619, 12620,
   12621, 12622, 12623, 12624, 12625, 12626, 12627, 12628, 12629, 12630,
   12631, 12632, 12633, 12634, 12635, 12636, 12637, 12638, 12639, 12640,
   12641, 12642, 12643, 12644, 12645, 12646, 12647, 12648, 12649, 12650,
   12651, 12652, 12653, 12654, 12655, 12656, 12657, 12658, 12659, 12660,
   12661, 12662, 12663, 12664, 12665, 12666, 12667, 12668, 12669, 12670,
   12671, 12672, 12673, 12674, 12675, 12676, 12677, 12678, 12679, 12680,
   12681, 12682, 12683, 12684, 12685, 12686, 12687, 12688, 12689, 12690,
   12691, 12692, 12693, 12694, 12695, 12696, 12697, 12698, 12699, 12700,
   12701, 12702, 12703, 12704, 12705, 12706, 12707, 12708, 12709, 12710,
   12711, 12712, 12713, 12714, 12715, 12716, 12717, 12718, 12719, 12720,
   12721, 12722, 12723, 12724, 12725, 12726, 12727, 12728, 12729, 12730,
   12731, 12732, 12733, 12734, 12735, 12736, 12737, 12738, 12739, 12740,
   12741, 12742, 12743, 12744, 12745, 12746, 12747, 12748, 12749, 12750,
   12751, 12752, 12753, 12754, 12755, 12756, 12757, 12758, 12759, 12760,
   12761, 12762, 12763, 12764, 12765, 12766, 12767, 12768, 12769, 12770,
   12771, 12772, 12773, 12774, 12775, 12776, 12777, 12778, 12779, 12780,
   12781, 12782, 12783, 12784, 12785, 12786, 12787, 12788, 12789, 12790,
   12791, 12792, 12793, 12794, 12795, 12796, 12797, 12798, 12799, 12800,
   12801, 12802, 12803, 12804, 12805, 12806, 12807, 12808, 12809, 12810,
   12811, 12812, 12813, 12814, 12815, 12816, 12817, 12818, 12819, 12820,
   12821, 12822, 12823, 12824, 12825, 12826, 12827, 12828, 12829, 12830,
   12831, 12832, 12833, 12834, 12835, 12836, 12837, 12838, 12845, 12844,
   12859, 12860, 12864, 12865, 12869, 12869, 12951, 12952, 12953, 12954,
   12958, 12959, 12963, 12964, 12965, 12966, 12970, 12971, 12972, 12973,
   12977, 12978, 12982, 13024, 13043, 13054, 13067, 13081, 13096, 13115,
   13142, 13155, 13182, 13225, 13239, 13240, 13241, 13242, 13246, 13247,
   13256, 13268, 13269, 13270, 13276, 13282, 13294, 13293, 13309, 13310,
   13314, 13315, 13319, 13332, 13333, 13334, 13335, 13340, 13339, 13359,
   13371, 13384, 13383, 13416, 13417, 13421, 13422, 13426, 13427, 13428,
   13429, 13431, 13430, 13443, 13444, 13445, 13446, 13447, 13453, 13458,
   13464, 13475, 13486, 13490, 13500, 13505, 13512, 13524, 13536, 13545,
   13547, 13551, 13552, 13559, 13561, 13565, 13566, 13571, 13570, 13574,
   13573, 13577, 13576, 13580, 13579, 13582, 13583, 13584, 13585, 13586,
   13587, 13588, 13589, 13590, 13591, 13592, 13593, 13594, 13595, 13596,
   13597, 13598, 13599, 13600, 13601, 13602, 13603, 13604, 13605, 13606,
   13607, 13611, 13612, 13616, 13617, 13621, 13631, 13641, 13654, 13669,
   13682, 13695, 13707, 13712, 13720, 13725, 13733, 13762, 13769, 13777,
   13785, 13791, 13795, 13799, 13800, 13804, 13831, 13833, 13837, 13841,
   13845, 13852, 13853, 13857, 13858, 13862, 13863, 13867, 13868, 13874,
   13880, 13886, 13896, 13895, 13905, 13906, 13911, 13912, 13913, 13918,
   13919, 13920, 13924, 13925, 13929, 13941, 13950, 13960, 13969, 13983,
   13984, 13989, 13988, 14004, 14005, 14006, 14010, 14011, 14015, 14015,
   14039, 14040, 14044, 14045, 14046, 14050, 14054, 14061, 14064, 14062,
   14078, 14085, 14106, 14123, 14125, 14129, 14130, 14134, 14135, 14143,
   14144, 14145, 14146, 14152, 14158, 14168, 14170, 14172, 14177, 14178,
   14179, 14180, 14181, 14185, 14186, 14187, 14188, 14189, 14190, 14200,
   14201, 14206, 14219, 14232, 14234, 14236, 14241, 14246, 14248, 14250,
   14256, 14257, 14259, 14265, 14264, 14282, 14283, 14287, 14292, 14300,
   14300, 14325, 14326, 14331, 14332, 14334, 14336, 14354, 14360, 14365,
   14347, 14427, 14445, 14470, 14502, 14506, 14514, 14537, 14466, 14602,
   14626, 14635, 14643, 14601, 14664, 14668, 14672, 14676, 14680, 14684,
   14691, 14698, 14705, 14715, 14716, 14720, 14721, 14722, 14726, 14727,
   14732, 14734, 14733, 14739, 14740, 14744, 14754
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM",
  "ANY_SYM", "AS", "ASC", "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM",
  "AUTHORS_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM", "CHECKSUM_SYM",
  "CHECK_SYM", "CIPHER_SYM", "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_SYM", "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM",
  "CONTRIBUTORS_SYM", "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE",
  "CROSS", "CUBE_SYM", "CURDATE", "CURRENT_USER", "CURSOR_SYM",
  "CURSOR_NAME_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFINER_SYM", "DELAYED_SYM",
  "DELAY_KEY_WRITE_SYM", "DELETE_SYM", "DESC", "DESCRIBE", "DES_KEY_FILE",
  "DETERMINISTIC_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD",
  "DISK_SYM", "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP",
  "DUAL_SYM", "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM",
  "ELSE", "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXECUTE_SYM", "EXISTS", "EXIT_SYM",
  "EXPANSION_SYM", "EXTENDED_SYM", "EXTENT_SIZE_SYM", "EXTRACT_SYM",
  "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM", "FILE_SYM",
  "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM", "FLUSH_SYM",
  "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM", "FROM", "FULL",
  "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL", "GEOMETRYCOLLECTION",
  "GEOMETRY_SYM", "GET_FORMAT", "GLOBAL_SYM", "GRANT", "GRANTS",
  "GROUP_SYM", "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM",
  "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED",
  "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES",
  "INDEX_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM", "INOUT_SYM",
  "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM",
  "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM", "LINES",
  "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM",
  "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM",
  "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM",
  "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMERIC_SYM", "NVARCHAR_SYM", "OFFSET_SYM",
  "OLD_PASSWORD", "ON", "ONE_SHOT_SYM", "ONE_SYM", "OPEN_SYM", "OPTIMIZE",
  "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM",
  "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM",
  "PACK_KEYS_SYM", "PAGE_SYM", "PARAM_MARKER", "PARSER_SYM", "PARTIAL",
  "PARTITIONING_SYM", "PARTITIONS_SYM", "PARTITION_SYM", "PASSWORD",
  "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM", "POLYGON",
  "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM", "PRESERVE_SYM",
  "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM", "PROCESS",
  "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM", "PURGE",
  "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVOKE", "RIGHT", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM",
  "STRAIGHT_JOIN", "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM",
  "SUBJECT_SYM", "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING",
  "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM",
  "SYSDATE", "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "ULONGLONG_NUM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM", "UNICODE_SYM", "UNINSTALL_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED",
  "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM", "USAGE", "USER", "USE_FRM",
  "USE_SYM", "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "VIEW_SYM", "WAIT_SYM",
  "WARNINGS", "WEEK_SYM", "WHEN_SYM", "WHERE", "WHILE_SYM", "WITH",
  "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM", "WRAPPER_SYM",
  "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR", "YEAR_MONTH_SYM",
  "YEAR_SYM", "ZEROFILL", "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'",
  "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'",
  "'.'", "':'", "$accept", "query", "$@1", "opt_end_of_input",
  "verb_clause", "statement", "deallocate", "deallocate_or_drop",
  "prepare", "prepare_src", "execute", "$@2", "execute_using",
  "execute_var_list", "execute_var_ident", "help", "$@3", "change", "$@4",
  "master_defs", "master_def", "ignore_server_id_list", "ignore_server_id",
  "master_file_def", "create", "$@5", "$@6", "$@7", "$@8", "$@9", "$@10",
  "server_def", "server_options_list", "server_option", "event_tail",
  "$@11", "ev_schedule_time", "$@12", "opt_ev_status", "ev_starts",
  "ev_ends", "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@13", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@14", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@15", "$@16", "sp_cursor_stmt", "$@17",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@18", "sp_proc_stmt_statement", "$@19", "sp_proc_stmt_return", "$@20",
  "sp_proc_stmt_unlabeled", "$@21", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@22", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@23", "$@24", "$@25", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@26", "$@27", "searched_case_stmt", "$@28",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@29", "$@30", "searched_when_clause", "$@31",
  "$@32", "else_clause_opt", "sp_labeled_control", "$@33", "sp_opt_label",
  "sp_labeled_block", "$@34", "sp_unlabeled_block", "$@35",
  "sp_block_content", "$@36", "sp_unlabeled_control", "$@37", "$@38",
  "$@39", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@40", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create2",
  "create2a", "$@41", "create3", "$@42", "$@43", "opt_create_partitioning",
  "opt_partitioning", "partitioning", "$@44", "have_partitioning",
  "partition_entry", "$@45", "partition", "part_type_def", "$@46",
  "opt_linear", "opt_key_algo", "part_field_list", "part_field_item_list",
  "part_field_item", "part_column_list", "part_func", "sub_part_func",
  "opt_num_parts", "opt_sub_part", "$@47", "$@48", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_num_subparts", "part_defs",
  "part_def_list", "part_definition", "$@49", "part_name",
  "opt_part_values", "$@50", "$@51", "part_func_max", "part_values_in",
  "part_value_list", "part_value_item", "$@52", "$@53",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@54", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@55", "$@56", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@57", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@58", "type", "$@59", "$@60",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "field_length", "opt_field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@61", "$@62", "$@63", "$@64", "$@65", "$@66",
  "$@67", "ev_alter_on_schedule_completion", "opt_ev_rename_to",
  "opt_ev_sql_stmt", "ident_or_empty", "alter_commands", "$@68", "$@69",
  "$@70", "remove_partitioning", "all_or_alt_part_name_list",
  "add_partition_rule", "$@71", "add_part_extra", "reorg_partition_rule",
  "$@72", "reorg_parts_rule", "$@73", "alt_part_name_list",
  "alt_part_name_item", "alter_list", "add_column", "alter_list_item",
  "$@74", "$@75", "$@76", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@77", "$@78", "start",
  "start_transaction_opts", "slave_thread_opts", "$@79",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@80", "opt_checksum_type", "repair",
  "$@81", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@82", "binlog_base64_event", "check", "$@83",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@84", "opt_no_write_to_binlog", "rename", "$@85", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@86",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@87",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@88", "cache_keys_spec", "$@89",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@90",
  "select_part2", "$@91", "$@92", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@93", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@94", "$@95", "$@96",
  "variable", "$@97", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@98", "gorder_list",
  "in_sum_expr", "$@99", "cast_type", "opt_expr_list", "expr_list",
  "ident_list_arg", "ident_list", "opt_expr", "opt_else", "when_list",
  "table_ref", "join_table_list", "esc_table_ref", "derived_table_list",
  "join_table", "$@100", "$@101", "$@102", "$@103", "$@104", "$@105",
  "$@106", "normal_join", "table_factor", "$@107", "select_derived_union",
  "$@108", "$@109", "select_init2_derived", "select_part2_derived",
  "$@110", "$@111", "select_derived", "$@112", "select_derived2", "$@113",
  "$@114", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@115",
  "$@116", "index_hints_list", "opt_index_hints_list", "$@117",
  "opt_key_definition", "$@118", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@119", "having_clause", "$@120", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@121", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_clause", "$@122", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@123",
  "select_var_list", "select_var_ident", "into", "$@124",
  "into_destination", "$@125", "$@126", "do", "$@127", "drop", "$@128",
  "$@129", "$@130", "table_list", "table_name", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "insert", "$@131",
  "$@132", "replace", "$@133", "$@134", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@135", "fields", "insert_values", "$@136", "$@137", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@138", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@139", "update", "$@140", "$@141", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@142", "single_multi", "$@143", "$@144", "$@145", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@146", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@147", "show_param",
  "$@148", "$@149", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@150", "$@151", "describe_command",
  "opt_extended_describe", "opt_describe_column", "flush", "$@152",
  "flush_options", "$@153", "$@154", "opt_with_read_lock",
  "flush_options_list", "flush_option", "opt_table_list", "reset", "$@155",
  "reset_options", "reset_option", "$@156", "slave_reset_options", "purge",
  "$@157", "purge_options", "purge_option", "kill", "kill_option", "use",
  "load", "$@158", "$@159", "$@160", "$@161", "data_or_xml", "opt_local",
  "load_data_lock", "opt_duplicate", "opt_field_term", "field_term_list",
  "field_term", "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "insert_ident", "table_wild", "order_ident",
  "simple_ident", "simple_ident_nospvar", "simple_ident_q", "field_ident",
  "table_ident", "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user", "keyword", "keyword_sp",
  "set", "$@162", "opt_option", "option_value_list", "option_type_value",
  "$@163", "option_type", "option_type2", "opt_var_type",
  "opt_var_ident_type", "ext_option_value", "sys_option_value",
  "option_value", "internal_variable_name", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@164",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@165", "handler", "$@166", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@167",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@168", "$@169", "$@170",
  "$@171", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "grant_user",
  "opt_column_list", "column_list", "column_list_id", "require_clause",
  "grant_options", "opt_grant_option", "grant_option_list", "grant_option",
  "begin", "$@172", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "$@173", "union_opt",
  "opt_union_order_or_limit", "union_order_or_limit", "$@174",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@175", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@176",
  "view_list_opt", "view_list", "view_select", "$@177", "view_select_aux",
  "view_check_option", "trigger_tail", "$@178", "$@179", "$@180",
  "udf_tail", "sf_tail", "$@181", "$@182", "$@183", "$@184", "$@185",
  "sp_tail", "$@186", "$@187", "$@188", "$@189", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@190", "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   124,    38,    45,    43,    42,    47,    37,
      94,   126,    40,    41,    44,    33,   123,   125,    59,    64,
      46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   612,   613,   614,   613,   613,   615,   615,   616,   616,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   617,   617,   617,   617,   617,   617,   617,   617,   617,
     617,   618,   619,   619,   620,   621,   621,   623,   622,   624,
     624,   625,   625,   626,   628,   627,   630,   629,   631,   631,
     632,   632,   632,   632,   632,   632,   632,   632,   632,   632,
     632,   632,   632,   632,   632,   633,   633,   633,   634,   635,
     635,   635,   635,   637,   636,   638,   636,   639,   636,   640,
     636,   641,   636,   642,   636,   636,   636,   636,   636,   643,
     644,   644,   645,   645,   645,   645,   645,   645,   645,   647,
     646,   649,   648,   648,   650,   650,   650,   650,   651,   651,
     652,   652,   653,   653,   654,   654,   655,   655,   657,   656,
     658,   658,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   659,   660,   660,   661,   661,   662,   662,
     663,   663,   663,   663,   663,   663,   663,   664,   664,   664,
     665,   665,   667,   666,   668,   668,   669,   669,   670,   670,
     671,   671,   672,   672,   673,   674,   675,   675,   676,   676,
     677,   678,   678,   678,   678,   679,   679,   680,   680,   681,
     681,   683,   682,   682,   684,   682,   682,   686,   685,   687,
     687,   688,   688,   689,   690,   690,   691,   692,   692,   693,
     693,   693,   693,   693,   694,   695,   695,   696,   696,   697,
     697,   698,   698,   699,   699,   699,   700,   700,   700,   700,
     700,   700,   700,   700,   700,   700,   700,   700,   701,   702,
     702,   703,   703,   704,   704,   704,   704,   704,   704,   704,
     704,   704,   704,   704,   704,   704,   706,   705,   708,   707,
     710,   709,   712,   711,   713,   714,   715,   717,   716,   718,
     719,   719,   719,   720,   720,   722,   723,   724,   721,   725,
     725,   725,   726,   726,   728,   729,   727,   731,   730,   732,
     732,   733,   733,   735,   736,   734,   738,   739,   737,   740,
     740,   742,   741,   743,   743,   745,   744,   747,   746,   749,
     748,   750,   751,   752,   750,   753,   750,   754,   754,   755,
     755,   755,   756,   757,   758,   759,   759,   760,   760,   761,
     762,   763,   763,   765,   764,   766,   766,   766,   767,   767,
     767,   768,   769,   769,   769,   770,   770,   770,   770,   770,
     770,   770,   770,   771,   772,   772,   772,   773,   773,   773,
     773,   773,   774,   775,   775,   775,   776,   776,   776,   776,
     776,   776,   776,   777,   778,   778,   778,   779,   779,   779,
     780,   781,   782,   783,   784,   785,   785,   785,   786,   787,
     788,   789,   790,   791,   792,   793,   794,   795,   795,   796,
     796,   797,   797,   798,   798,   798,   798,   799,   800,   799,
     801,   802,   801,   803,   801,   804,   805,   805,   807,   806,
     808,   810,   809,   811,   812,   813,   812,   812,   812,   812,
     812,   814,   814,   815,   815,   816,   816,   817,   817,   818,
     819,   820,   821,   822,   822,   823,   824,   823,   825,   823,
     826,   826,   827,   828,   829,   829,   830,   830,   831,   831,
     833,   832,   834,   835,   836,   835,   837,   835,   838,   838,
     839,   839,   840,   840,   842,   843,   841,   844,   844,   845,
     845,   846,   846,   847,   847,   849,   848,   850,   851,   851,
     852,   852,   853,   853,   853,   853,   853,   853,   853,   853,
     855,   856,   854,   857,   857,   858,   858,   859,   859,   860,
     860,   861,   861,   862,   862,   863,   864,   864,   865,   865,
     866,   866,   867,   867,   867,   868,   868,   868,   868,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   869,   868,
     868,   868,   868,   868,   868,   868,   868,   868,   868,   868,
     870,   871,   872,   873,   874,   874,   874,   874,   874,   874,
     875,   875,   875,   876,   876,   877,   877,   877,   877,   878,
     879,   879,   880,   880,   881,   881,   882,   882,   882,   882,
     882,   882,   883,   883,   884,   885,   885,   886,   888,   887,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   889,   889,   889,   889,   889,
     889,   889,   889,   889,   889,   890,   889,   891,   889,   889,
     889,   892,   892,   892,   892,   892,   892,   892,   892,   893,
     894,   894,   895,   895,   896,   896,   896,   896,   896,   897,
     897,   897,   897,   897,   898,   898,   898,   899,   899,   899,
     900,   901,   901,   902,   902,   903,   903,   903,   904,   904,
     904,   904,   905,   905,   906,   906,   907,   907,   908,   908,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   910,   911,   911,   912,   912,   913,   913,   914,   914,
     915,   915,   916,   916,   917,   917,   918,   919,   919,   920,
     920,   921,   921,   922,   922,   922,   923,   923,   923,   924,
     924,   924,   924,   924,   924,   924,   925,   925,   926,   926,
     927,   928,   928,   929,   929,   930,   930,   930,   930,   931,
     931,   931,   931,   931,   932,   932,   932,   932,   932,   933,
     934,   934,   935,   935,   936,   936,   937,   937,   937,   938,
     938,   939,   940,   941,   942,   942,   943,   943,   944,   944,
     945,   945,   946,   946,   947,   947,   948,   948,   949,   949,
     950,   950,   951,   951,   952,   953,   953,   954,   954,   954,
     955,   955,   956,   956,   957,   957,   958,   958,   959,   959,
     961,   960,   962,   960,   960,   963,   960,   964,   960,   965,
     960,   966,   960,   967,   960,   960,   960,   960,   960,   960,
     968,   968,   968,   968,   969,   969,   970,   970,   971,   971,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     973,   972,   972,   974,   972,   975,   972,   972,   972,   972,
     976,   977,   977,   979,   978,   980,   980,   980,   982,   981,
     983,   984,   983,   985,   985,   986,   987,   987,   988,   989,
     989,   989,   990,   989,   991,   992,   989,   989,   989,   989,
     989,   989,   989,   989,   989,   989,   989,   989,   989,   989,
     993,   993,   994,   994,   995,   995,   995,   996,   996,   996,
     997,   997,   997,   997,   999,   998,   998,  1000,   998,   998,
    1001,  1002,  1002,  1004,  1003,  1005,  1005,  1006,  1006,  1006,
    1007,  1007,  1008,  1008,  1010,  1009,  1011,  1011,  1011,  1013,
    1012,  1014,  1014,  1015,  1015,  1016,  1016,  1016,  1018,  1017,
    1019,  1021,  1020,  1022,  1022,  1023,  1023,  1024,  1024,  1024,
    1024,  1024,  1024,  1026,  1025,  1027,  1027,  1027,  1029,  1028,
    1028,  1030,  1030,  1031,  1031,  1032,  1034,  1033,  1035,  1035,
    1036,  1036,  1037,  1038,  1039,  1039,  1041,  1040,  1042,  1042,
    1043,  1043,  1044,  1045,  1047,  1046,  1049,  1048,  1050,  1050,
    1051,  1051,  1052,  1053,  1053,  1054,  1054,  1055,  1055,  1057,
    1056,  1059,  1060,  1058,  1061,  1061,  1061,  1061,  1061,  1062,
    1062,  1063,  1063,  1064,  1064,  1065,  1065,  1065,  1066,  1066,
    1066,  1067,  1067,  1067,  1068,  1068,  1069,  1070,  1071,  1071,
    1071,  1071,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1074,  1074,  1074,  1074,
    1074,  1074,  1075,  1075,  1075,  1075,  1075,  1075,  1075,  1075,
    1075,  1075,  1075,  1075,  1075,  1075,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1077,  1077,  1078,  1078,  1079,  1079,  1080,  1080,  1081,
    1081,  1081,  1081,  1081,  1081,  1082,  1082,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,  1083,
    1083,  1083,  1083,  1083,  1083,  1083,  1083,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,  1084,
    1084,  1084,  1084,  1084,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,  1086,
    1086,  1086,  1086,  1086,  1086,  1086,  1087,  1087,  1087,  1087,
    1087,  1087,  1087,  1087,  1089,  1088,  1088,  1090,  1090,  1091,
    1091,  1092,  1092,  1093,  1093,  1094,  1094,  1095,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1097,  1098,  1096,  1096,  1096,
    1096,  1096,  1096,  1096,  1096,  1096,  1096,  1096,  1099,  1096,
    1101,  1100,  1102,  1102,  1102,  1103,  1103,  1104,  1104,  1105,
    1106,  1105,  1107,  1107,  1109,  1108,  1110,  1110,  1110,  1110,
    1110,  1110,  1110,  1110,  1110,  1110,  1110,  1111,  1111,  1112,
    1112,  1113,  1113,  1114,  1114,  1115,  1115,  1116,  1116,  1117,
    1117,  1118,  1118,  1119,  1120,  1120,  1121,  1121,  1122,  1122,
    1123,  1122,  1124,  1122,  1125,  1122,  1122,  1126,  1122,  1127,
    1122,  1122,  1128,  1122,  1129,  1122,  1122,  1130,  1130,  1130,
    1132,  1131,  1131,  1131,  1133,  1134,  1135,  1133,  1136,  1138,
    1139,  1137,  1141,  1140,  1143,  1144,  1142,  1145,  1146,  1147,
    1147,  1148,  1148,  1148,  1148,  1149,  1149,  1151,  1150,  1152,
    1150,  1153,  1153,  1154,  1155,  1154,  1157,  1156,  1158,  1158,
    1159,  1159,  1160,  1160,  1161,  1161,  1162,  1162,  1162,  1162,
    1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,  1163,  1163,
    1163,  1163,  1163,  1163,  1163,  1163,  1163,  1164,  1164,  1164,
    1164,  1165,  1165,  1165,  1166,  1166,  1167,  1167,  1168,  1169,
    1168,  1170,  1171,  1170,  1172,  1172,  1173,  1173,  1174,  1174,
    1175,  1175,  1175,  1176,  1177,  1177,  1178,  1179,  1179,  1181,
    1180,  1182,  1182,  1183,  1183,  1183,  1184,  1184,  1185,  1185,
    1186,  1187,  1187,  1187,  1188,  1188,  1188,  1188,  1188,  1189,
    1189,  1190,  1190,  1190,  1190,  1190,  1190,  1191,  1191,  1191,
    1191,  1191,  1192,  1192,  1192,  1192,  1192,  1193,  1193,  1193,
    1193,  1194,  1195,  1195,  1196,  1197,  1196,  1198,  1198,  1199,
    1199,  1200,  1202,  1201,  1203,  1203,  1204,  1204,  1206,  1205,
    1208,  1209,  1207,  1207,  1207,  1211,  1210,  1213,  1212,  1214,
    1212,  1212,  1212,  1212,  1212,  1212,  1215,  1212,  1212,  1212,
    1212,  1212,  1212,  1216,  1216,  1217,  1218,  1218,  1219,  1220,
    1220,  1221,  1221,  1223,  1224,  1222,  1226,  1227,  1225,  1228,
    1228,  1228,  1228,  1229,  1229,  1230,  1230,  1231,  1232,  1232,
    1232,  1233,  1232,  1234,  1234,  1235,  1235,  1236,  1235,  1237,
    1235,  1238,  1238,  1239,  1239,  1240,  1241,  1241,  1242,  1242,
    1244,  1243,  1245,  1245,  1246,  1246,  1247,  1247,  1248,  1249,
    1248,  1251,  1252,  1250,  1253,  1253,  1254,  1255,  1255,  1256,
    1257,  1257,  1259,  1258,  1261,  1260,  1262,  1260,  1263,  1260,
    1264,  1264,  1265,  1265,  1266,  1266,  1267,  1267,  1268,  1268,
    1268,  1270,  1269,  1271,  1271,  1272,  1272,  1273,  1273,  1274,
    1274,  1274,  1274,  1274,  1274,  1274,  1274,  1274,  1275,  1275,
    1277,  1276,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1279,  1278,  1280,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,
    1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1278,  1281,
    1281,  1281,  1282,  1282,  1283,  1283,  1284,  1284,  1285,  1285,
    1286,  1286,  1287,  1287,  1288,  1288,  1289,  1289,  1289,  1291,
    1290,  1292,  1290,  1293,  1293,  1294,  1294,  1294,  1295,  1295,
    1295,  1297,  1296,  1299,  1300,  1298,  1298,  1301,  1301,  1302,
    1302,  1303,  1303,  1303,  1303,  1303,  1303,  1303,  1303,  1303,
    1303,  1303,  1303,  1303,  1303,  1303,  1304,  1304,  1306,  1305,
    1307,  1307,  1309,  1308,  1308,  1308,  1310,  1310,  1312,  1311,
    1313,  1314,  1314,  1315,  1316,  1316,  1316,  1317,  1319,  1320,
    1321,  1322,  1318,  1323,  1323,  1324,  1324,  1325,  1325,  1325,
    1326,  1326,  1326,  1327,  1327,  1328,  1328,  1329,  1329,  1329,
    1329,  1330,  1330,  1331,  1331,  1332,  1332,  1333,  1333,  1334,
    1334,  1335,  1335,  1336,  1336,  1336,  1337,  1337,  1338,  1338,
    1339,  1339,  1340,  1340,  1341,  1342,  1342,  1342,  1342,  1343,
    1343,  1343,  1344,  1345,  1345,  1345,  1346,  1346,  1346,  1346,
    1346,  1346,  1346,  1346,  1346,  1346,  1346,  1346,  1347,  1347,
    1347,  1347,  1347,  1348,  1348,  1349,  1349,  1350,  1351,  1351,
    1352,  1352,  1353,  1353,  1353,  1354,  1354,  1354,  1354,  1355,
    1355,  1355,  1356,  1356,  1357,  1358,  1358,  1359,  1360,  1361,
    1362,  1362,  1363,  1363,  1364,  1364,  1364,  1365,  1365,  1365,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,  1366,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,
    1367,  1367,  1367,  1367,  1367,  1367,  1367,  1367,  1369,  1368,
    1370,  1370,  1371,  1371,  1373,  1372,  1374,  1374,  1374,  1374,
    1375,  1375,  1376,  1376,  1376,  1376,  1377,  1377,  1377,  1377,
    1378,  1378,  1379,  1379,  1380,  1380,  1380,  1380,  1380,  1380,
    1380,  1381,  1381,  1381,  1382,  1382,  1382,  1382,  1383,  1383,
    1383,  1384,  1384,  1384,  1384,  1384,  1386,  1385,  1387,  1387,
    1388,  1388,  1389,  1390,  1390,  1390,  1390,  1392,  1391,  1393,
    1393,  1394,  1393,  1395,  1395,  1396,  1396,  1397,  1397,  1397,
    1397,  1398,  1397,  1399,  1399,  1399,  1399,  1399,  1400,  1401,
    1401,  1401,  1401,  1401,  1402,  1403,  1403,  1403,  1403,  1404,
    1404,  1405,  1405,  1406,  1406,  1407,  1407,  1409,  1408,  1410,
    1408,  1411,  1408,  1412,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,  1408,
    1408,  1413,  1413,  1414,  1414,  1415,  1415,  1415,  1416,  1416,
    1416,  1416,  1417,  1417,  1418,  1418,  1419,  1419,  1419,  1419,
    1419,  1420,  1420,  1421,  1421,  1422,  1423,  1423,  1423,  1423,
    1423,  1424,  1424,  1425,  1425,  1426,  1426,  1427,  1427,  1427,
    1427,  1427,  1429,  1428,  1430,  1430,  1431,  1431,  1431,  1432,
    1432,  1432,  1433,  1433,  1434,  1435,  1435,  1436,  1437,  1438,
    1438,  1440,  1439,  1441,  1441,  1441,  1442,  1442,  1444,  1443,
    1445,  1445,  1446,  1446,  1446,  1447,  1447,  1448,  1449,  1448,
    1450,  1451,  1452,  1453,  1453,  1454,  1454,  1455,  1455,  1455,
    1455,  1455,  1455,  1455,  1455,  1456,  1456,  1456,  1457,  1457,
    1457,  1457,  1457,  1458,  1458,  1458,  1458,  1458,  1458,  1459,
    1459,  1460,  1461,  1462,  1462,  1462,  1463,  1464,  1464,  1464,
    1465,  1465,  1465,  1467,  1466,  1468,  1468,  1469,  1469,  1471,
    1470,  1472,  1472,  1473,  1473,  1473,  1473,  1475,  1476,  1477,
    1474,  1478,  1478,  1480,  1481,  1482,  1483,  1484,  1479,  1486,
    1487,  1488,  1489,  1485,  1490,  1490,  1490,  1490,  1490,  1490,
    1491,  1491,  1491,  1492,  1492,  1493,  1493,  1493,  1494,  1494,
    1495,  1496,  1495,  1497,  1497,  1498,  1499
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     4,     1,     2,     0,     4,     0,
       2,     3,     1,     2,     0,     3,     0,     5,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     5,     1,     0,     1,     3,     1,     3,
       3,     3,     3,     0,     7,     0,    12,     0,    12,     0,
      12,     0,     6,     0,     3,     4,     4,     3,     2,    10,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     0,
      13,     0,     6,     2,     0,     1,     3,     1,     0,     2,
       0,     2,     0,     1,     3,     4,     0,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     0,     2,     0,     2,
       2,     2,     2,     2,     3,     3,     1,     1,     1,     2,
       3,     3,     0,     4,     0,     3,     0,     1,     3,     1,
       0,     1,     3,     1,     0,     3,     0,     1,     3,     1,
       4,     0,     1,     1,     1,     0,     3,     2,     3,     0,
       3,     0,     5,     5,     0,     7,     5,     0,     2,     1,
       1,     1,     3,     1,     1,     1,     3,     0,     1,     1,
       1,     1,     2,     1,     3,     1,     1,     0,     1,     0,
       2,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       3,     0,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     0,     2,
       0,     3,     0,     2,     2,     2,     2,     0,     6,     2,
       0,     2,     1,     1,     3,     0,     0,     0,     7,     0,
       2,     2,     1,     1,     0,     0,     8,     0,     6,     1,
       2,     1,     2,     0,     0,     6,     0,     0,     6,     0,
       2,     0,     5,     0,     1,     0,     5,     0,     2,     0,
       5,     4,     0,     0,     8,     0,     7,     1,     1,     1,
       1,     1,     2,     4,     5,     0,     4,     4,     4,     3,
       3,     2,     2,     0,     2,     1,     2,     3,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     3,     1,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     0,     1,     1,
       1,     1,     1,     2,     3,     2,     4,     5,     0,     5,
       0,     0,     5,     0,     7,     1,     0,     1,     0,     4,
       0,     0,     3,     5,     6,     0,     4,     2,     2,     2,
       2,     0,     1,     0,     3,     0,     1,     1,     3,     1,
       4,     5,     5,     0,     2,     0,     0,     7,     0,    10,
       1,     3,     1,     1,     0,     2,     0,     3,     1,     3,
       0,     6,     1,     0,     0,     5,     0,     4,     1,     1,
       1,     3,     1,     3,     0,     0,     5,     1,     3,     1,
       1,     0,     3,     1,     3,     0,     4,     1,     0,     1,
       2,     1,     3,     4,     3,     3,     3,     4,     4,     3,
       0,     0,     6,     0,     1,     0,     1,     1,     2,     1,
       1,     0,     1,     1,     2,     1,     0,     3,     0,     1,
       1,     2,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     0,     6,
       1,     1,     3,     4,     4,     2,     2,     2,     3,     3,
       4,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     2,     2,     7,     8,     8,     8,
       8,     2,     0,     1,     4,     0,     1,     2,     0,     4,
       3,     3,     3,     1,     2,     1,     1,     3,     2,     3,
       2,     2,     1,     3,     3,     2,     3,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     2,     3,     2,     3,
       2,     2,     3,     3,     3,     0,     6,     0,     6,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     2,     1,     2,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       5,     0,     1,     2,     1,     1,     1,     1,     3,     3,
       3,     3,     0,     1,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     2,     2,     1,     2,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     0,     1,     1,     2,     2,     1,     2,     2,     0,
       1,     1,     1,     3,     1,     3,     0,     1,     0,     1,
       5,     0,     3,     3,     1,     0,     2,     2,     2,     0,
       3,     3,     6,     6,     1,     1,     2,     2,     2,     1,
       2,     2,     1,     1,     0,     1,     1,     1,     1,     0,
       1,     1,     1,     0,     1,     2,     0,     1,     0,     1,
       0,     1,     1,     2,     1,     2,     1,     2,     2,     2,
       3,     2,     1,     1,     1,     1,     3,     1,     1,     1,
       4,     2,     1,     4,     0,     1,     0,     2,     1,     3,
       0,     6,     0,     5,     7,     0,     5,     0,     5,     0,
       5,     0,     4,     0,    10,     3,     4,     3,     3,     7,
       0,     3,     1,     4,     0,     3,     0,     2,     0,     1,
       0,     2,     2,     2,     2,     1,     1,     1,     3,     4,
       0,     6,     4,     0,     5,     0,     6,     4,     3,     1,
       2,     1,     1,     0,     5,     0,     3,     2,     0,     5,
       0,     0,     6,     1,     3,     1,     1,     3,     2,     3,
       2,     4,     0,     6,     0,     0,     8,     4,     4,     3,
       3,     2,     2,     6,     5,     3,     5,     1,     1,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     2,     1,
       0,     1,     1,     1,     0,     5,     3,     0,     5,     3,
       3,     0,     3,     0,     2,     1,     3,     0,     1,     1,
       0,     2,     1,     3,     0,     5,     0,     1,     1,     0,
       6,     0,     1,     1,     2,     1,     1,     1,     0,     5,
       2,     0,     5,     0,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     0,     5,     0,     1,     1,     0,     4,
       4,     3,     5,     1,     3,     3,     0,     6,     1,     1,
       1,     3,     2,     3,     1,     1,     0,     6,     1,     1,
       1,     3,     3,     4,     0,     6,     0,     2,     0,     4,
       0,     2,     1,     2,     4,     2,     3,     2,     3,     0,
       3,     0,     0,     6,     2,     1,     1,     2,     2,     8,
       4,     0,     1,     2,     1,     1,     1,     1,     0,     2,
       4,     3,     1,     1,     3,     4,     0,     0,     0,     2,
       2,     1,     1,     0,     2,     3,     3,     3,     2,     3,
       4,     3,     4,     3,     4,     1,     3,     4,     3,     3,
       6,     1,     5,     6,     5,     7,     6,     8,     5,     6,
       4,     4,     5,     3,     4,     1,     3,     3,     3,     3,
       3,     3,     5,     5,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     3,     2,     2,
       2,     2,     3,     3,     5,     6,     4,     4,     7,     2,
       6,     5,     6,     6,     4,     4,     5,     4,     6,     2,
       4,     4,     4,    10,     6,     8,     6,     4,     4,     6,
       4,     4,     4,     6,     4,     7,     7,     7,     6,     6,
       6,     6,     3,     4,     6,     8,     2,     2,     4,     8,
       8,     6,     6,     2,     4,     6,     6,     8,     8,     6,
       8,     6,     2,     4,     8,     8,     2,     2,     2,     4,
       4,     4,     4,     3,     8,     4,     6,     4,     4,     4,
       6,     8,     6,     4,     6,     1,     6,     4,     4,     4,
       4,     4,     6,     4,     0,     5,     6,     2,     3,     0,
       4,     0,     3,     0,     1,     1,     3,     4,     4,     5,
       4,     4,     4,     5,     4,     0,     0,     7,     4,     5,
       4,     5,     4,     4,     4,     4,     4,     5,     0,     8,
       0,     3,     3,     1,     4,     0,     1,     0,     2,     0,
       0,     4,     4,     2,     0,     3,     2,     3,     2,     1,
       2,     1,     2,     1,     1,     1,     2,     0,     1,     1,
       3,     1,     3,     1,     3,     0,     1,     0,     2,     4,
       5,     1,     1,     1,     1,     4,     1,     3,     3,     3,
       0,     6,     0,     6,     0,     8,     4,     0,     8,     0,
      10,     6,     0,     8,     0,    10,     6,     1,     2,     2,
       0,     4,     3,     5,     2,     0,     0,     7,     1,     0,
       0,     6,     0,     3,     0,     0,     5,     0,     1,     0,
       1,     0,     2,     3,     3,     1,     1,     0,     7,     0,
       7,     1,     2,     0,     0,     2,     0,     2,     0,     1,
       1,     1,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     2,     0,     1,     0,     0,
       3,     0,     0,     3,     2,     0,     0,     4,     4,     2,
       0,     1,     1,     3,     3,     1,     2,     0,     1,     0,
       4,     4,     2,     0,     1,     1,     0,     1,     0,     1,
       2,     1,     3,     3,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     0,     6,     0,     1,     3,
       1,     3,     0,     2,     3,     1,     2,     1,     0,     3,
       0,     0,     7,     2,     1,     0,     3,     0,     7,     0,
       6,     4,     6,     4,     4,     4,     0,     6,     4,     4,
       5,     6,     4,     1,     3,     1,     1,     3,     1,     0,
       2,     0,     1,     0,     0,     8,     0,     0,     6,     0,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     3,
       4,     0,     3,     3,     1,     2,     2,     0,     3,     0,
       5,     3,     1,     3,     1,     3,     1,     1,     0,     1,
       0,     4,     0,     1,     3,     1,     1,     1,     0,     0,
       6,     0,     0,    11,     3,     1,     3,     3,     1,     3,
       0,     1,     0,     4,     0,     6,     0,     5,     0,     6,
       1,     3,     2,     4,     0,     2,     0,     2,     1,     1,
       1,     0,     4,     0,     1,     0,     1,     1,     3,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     0,     3,
       0,     3,     2,     4,     4,     3,     4,     4,     1,     3,
       3,     6,     2,     2,     0,     6,     0,     6,     5,     2,
       1,     1,     1,     5,     5,     2,     2,     1,     4,     3,
       2,     3,     2,     2,     1,     3,     4,     3,     3,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     0,     1,     0,     2,     0,     1,
       1,     1,     0,     2,     0,     2,     0,     2,     2,     0,
       4,     0,     4,     1,     1,     0,     1,     1,     0,     1,
       1,     0,     4,     0,     0,     5,     1,     0,     3,     3,
       1,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     3,
       3,     1,     0,     3,     1,     2,     0,     1,     0,     3,
       3,     2,     2,     3,     0,     1,     1,     2,     0,     0,
       0,     0,    21,     1,     1,     0,     1,     0,     1,     1,
       0,     1,     1,     0,     2,     2,     1,     3,     4,     3,
       3,     0,     2,     2,     1,     3,     3,     0,     4,     0,
       3,     1,     1,     0,     3,     2,     3,     1,     1,     2,
       0,     2,     3,     1,     5,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     3,     5,     1,     1,     1,
       1,     1,     3,     4,     5,     1,     5,     3,     2,     1,
       3,     2,     2,     4,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
       0,     1,     1,     3,     0,     2,     1,     1,     1,     1,
       0,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       1,     2,     4,     5,     4,     6,     2,     3,     3,     3,
       5,     1,     3,     3,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     5,     3,     8,     8,     8,     6,     0,
       1,     1,     2,     0,     1,     1,     3,     0,     3,     0,
       3,     0,     3,     0,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     1,
       2,     0,     1,     3,     1,     2,     2,     2,     1,     3,
       3,     1,     1,     3,     1,     3,     4,     5,     4,     6,
       1,     0,     3,     3,     1,     1,     0,     2,     2,     2,
       2,     0,     2,     0,     3,     2,     1,     2,     2,     2,
       2,     2,     0,     3,     0,     1,     0,     3,     2,     0,
       1,     2,     0,     1,     4,     4,     5,     2,     3,     0,
       1,     0,     4,     0,     1,     1,     0,     1,     0,     2,
       2,     1,     0,     1,     1,     2,     3,     2,     0,     6,
       3,     0,     0,     0,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     1,     2,     1,     2,     3,     3,     3,
       0,     3,     3,     0,     7,     0,     3,     1,     3,     0,
       3,     2,     4,     0,     3,     4,     4,     0,     0,     0,
      16,     8,     7,     0,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    12,     4,     4,     3,     4,     3,     2,
       1,     3,     5,     1,     1,     0,     1,     1,     0,     2,
       0,     0,     3,     0,     2,     5,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  2431,   975,  2362,     0,     0,     0,     0,     0,     0,
    2364,   113,    62,  1582,  1693,  1694,  1495,  1521,     2,     0,
     975,   163,     0,    74,  1523,     0,  1744,     0,     0,   975,
     441,     0,  1738,     0,     0,   975,  1526,  1728,   237,   163,
    2364,     0,  1021,  2190,  1620,     0,     0,     0,     0,  1603,
       0,  2247,  1571,     0,     0,     0,     0,     3,     8,    19,
       0,    38,    24,    28,    14,    18,    13,    51,    45,    36,
      10,    53,    54,    16,    42,    11,    12,    15,    34,    41,
      35,    37,    49,  1012,    22,    23,    29,    43,    58,    20,
      55,    52,    21,  1695,    25,    44,    39,    31,    59,    32,
      50,    33,    57,    27,    46,    26,     9,    17,    47,    48,
      40,    60,    30,    56,     0,   848,     0,     0,   913,     0,
       0,     0,     0,     0,   831,  2429,  2430,  2431,   977,   976,
       0,  2364,  1847,   960,   986,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1861,  1917,  1918,  1920,  1919,  1921,  1922,  1862,
    1863,  1923,  1924,  1925,  1927,  1926,  1928,  1864,  1865,  1929,
    1930,  1931,  1932,  1866,  1867,  1933,  1935,  1934,  1868,  1936,
    1937,  1938,  1940,  1939,  1869,  1941,  1870,  1942,  1943,  1944,
    1945,  1946,  1947,  1948,  1950,  1949,  1871,  1951,  1952,  1953,
    1954,  1955,  1957,  1956,  1958,  1959,  1960,  1872,  1961,  1962,
    1963,  1964,  1965,  1966,  1967,  1873,  1968,  1969,  1970,  1987,
    1874,  1971,  1974,  1973,  1972,  1975,  1976,  1977,  1979,  1978,
    1980,  1875,  1981,  1982,  1983,  1985,  1984,  1989,  1990,  1991,
    1876,  1986,  1988,  2169,  1992,  1994,  1993,  1995,  1997,  1996,
    1877,  1998,  1878,  1879,  1999,  2000,  1845,  2001,  1846,  2002,
    2004,  2005,  2006,  2011,  1880,  2003,  2007,  2008,  2009,  2010,
    2012,  1881,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2021,  2022,  2033,  2026,  2028,  2029,  2031,  2027,  2032,  2036,
    2035,  2037,  2038,  2039,  2034,  2024,  2030,  2025,  2040,  2041,
    2023,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,
    2051,  2052,  2054,  2053,  2055,  2056,  2057,  2058,  2059,  2060,
    2062,  2061,  2063,  2064,  2065,  2067,  2066,  2069,  2070,  1882,
    2068,  2071,  2072,  2073,  2074,  2075,  1883,  1884,  1885,  2076,
    2077,  1886,  2078,  2079,  2080,  1887,  2081,  2082,  2084,  2083,
    2085,  2086,  1888,  1889,  2087,  2088,  2089,  2090,  2091,  2092,
    2093,  2094,  2095,  2096,  2097,  2098,  2099,  2100,  2102,  2101,
    2103,  2104,  2105,  2106,  2107,  2108,  2109,  1890,  2110,  1891,
    2111,  2112,  1892,  2113,  1893,  2114,  2115,  1894,  2116,  2117,
    2118,  2119,  2120,  2121,  1895,  2122,  2123,  2124,  1896,  2126,
    2125,  2127,  1897,  2129,  2130,  1898,  2128,  1900,  2131,  2132,
    1899,  1901,  2133,  2134,  2136,  2135,  2137,  2138,  2139,  1902,
    2140,  1903,  2141,  2142,  2143,  2144,  2145,  2147,  2146,  2148,
    2149,  2150,  2151,  2153,  2155,  2154,  2152,  2156,  2157,  2158,
    2159,  2162,  2163,  2164,  2165,  2160,  2161,  1904,  2166,  2167,
    2168,  2170,  2171,  2173,  2172,  1905,  1906,  2174,  2175,  1909,
    2176,  2177,  2180,  2178,  2179,  2182,  2181,  2183,  2184,  1907,
    2185,  1908,  2186,  2187,   182,  1850,   165,  1851,  1860,     0,
    2239,  2238,   944,   961,  2365,  2366,   536,   781,     0,     0,
     782,     0,   535,   780,   163,  2431,   118,     0,   532,   533,
       0,     0,     0,  1596,     0,  1519,  1519,  1519,     0,     0,
    1519,  1519,     0,  1522,  1519,   163,  1519,     0,    67,  1701,
       0,     0,     0,     0,  1844,     0,  1529,     0,  1745,  1746,
       0,  1753,     0,  1754,  1748,  2236,     0,     0,     0,     0,
       0,   163,   978,     0,  1580,     0,   227,   236,   238,   239,
     235,     0,  2366,  2377,  1013,  1019,  1031,  2191,  2188,  1678,
     239,   933,   933,   933,   931,   933,  1604,  1601,     0,     0,
    1580,  1747,  2483,     0,     0,     0,  2479,     0,  2484,     0,
    1021,     0,     0,     1,     5,     0,     0,  1982,  2080,  1691,
    1689,  1839,     0,   822,   849,     0,   827,     0,   825,  1856,
    1855,  1854,     0,   838,   837,   835,     0,   403,     0,     0,
    2440,   829,   958,  2363,     0,   184,     0,    76,     0,     0,
       0,  2369,     0,     0,     0,     0,   117,     0,     0,     0,
     114,  1046,  1046,  2431,  2433,  2435,   536,   534,     0,     0,
       0,  1600,  1599,  1598,     0,  1596,  1911,  1861,  1922,     0,
    1812,     0,     0,     0,  1295,     0,  1866,     0,  1936,  1938,
    1871,     0,     0,  1053,  1053,  1053,     0,     0,     0,  1959,
    1960,  1821,     0,     0,     0,  1809,  1822,  1994,  1995,     0,
    1811,  2000,     0,     0,     0,     0,  2017,  1819,     0,     0,
    2049,  2051,     0,     0,  2055,  2056,  2057,  2058,  1796,  1108,
       0,  1053,  1808,  1818,  2073,  1802,  2081,  2085,  2086,     0,
    2095,     0,     0,     0,  2120,  2124,     0,     0,  2144,     0,
       0,  1053,  1795,  2162,  2163,  2164,  2165,     0,  1810,  1904,
    1820,     0,  2176,  1053,  1053,  1053,     0,     0,     0,  2183,
    2187,     0,     0,     0,  2401,  1107,     0,  1260,     0,  1289,
    1065,  1071,  1085,     0,  1100,  1118,  1119,  1121,  1215,  1120,
    1126,  1125,  1496,  1806,  1124,  1123,  1807,  1117,  1829,  1850,
    1828,     0,     0,     0,     0,     0,     0,     0,     0,  1674,
       0,     0,  1506,  1519,    69,     0,  2283,  2298,  2299,  2295,
    2300,  2318,  2301,  2305,     0,  2297,  2289,     0,  2304,     0,
    2293,  2302,     0,  2287,     0,  2303,  2308,  2319,  2291,  2296,
    2274,     0,  2281,  2285,  1841,  1401,  2250,  2251,     0,    75,
    1531,  1532,  1530,   912,     0,  1743,     0,  1757,     0,   973,
     451,   442,     0,  1673,  1672,     0,  1739,  2378,     0,     0,
     949,  1534,  1581,     0,  1533,  1734,     0,  1732,  1729,  1731,
     228,     0,     0,   258,  2283,     0,  2268,     0,  2372,  2369,
    2379,  2414,  2409,  2408,  2411,  2412,  1037,  2413,  1036,  2410,
    2407,  1046,  1032,  1034,  1035,  2194,  1640,     0,   715,     0,
    1686,  1641,     0,     0,  1686,     0,  1436,  1676,  1679,     0,
    2203,  1654,   778,   777,   776,  2204,  1672,     0,  1628,  1642,
       0,  1605,  1647,     0,  2205,     0,  1675,     0,  1436,  1686,
       0,  1621,     0,     0,     0,     0,   234,   927,   937,   929,
     924,     0,   930,   926,     0,  2496,  2248,   912,  1801,  1800,
    1848,  2480,  1799,  2488,  2490,  2476,  2478,  2485,  1015,     0,
    2383,     6,    61,     0,  1698,  2438,  2439,  2437,   731,     0,
    1053,  1857,  2432,   166,   836,     0,   404,   166,     0,     0,
       0,     0,     0,   405,   406,   342,   820,   833,     0,     0,
     832,  2440,     0,     0,   988,   990,   989,  1006,   186,   183,
     164,     0,   946,  1513,  1515,   963,  2368,     0,     0,  2370,
    2374,  1106,  1105,     0,   111,   116,     0,     0,     0,  2340,
     115,  2334,  2436,  1046,  1046,  1046,  2428,     0,  2416,  2423,
    2424,  2427,  2426,  2425,  2422,     0,  2415,  2418,  2419,  2421,
    2420,  2440,  2434,     0,   783,   783,   783,     0,  1583,  1586,
    1590,  1594,  1597,     0,     0,  1406,  1139,  1406,  1406,  1406,
    1296,     0,     0,     0,     0,     0,     0,     0,     0,  1406,
       0,  1176,  1149,     0,  1177,     0,     0,     0,     0,     0,
    1815,     0,     0,  2401,     0,     0,     0,  1265,     0,     0,
       0,  2401,     0,     0,     0,     0,     0,  1291,  1293,  1828,
    1406,     0,     0,  1406,     0,     0,     0,     0,     0,  1058,
       0,  1183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1406,  1406,     0,     0,  1406,     0,  1192,
       0,  1817,     0,     0,     0,  1816,     0,     0,  1814,  1813,
    1797,     0,  1196,  1198,  1197,     0,  1406,  1406,     0,     0,
    1129,  1128,  1130,     0,     0,     0,     0,     0,     0,  1104,
    1103,  1102,  1101,     0,     0,     0,  1109,     0,  1110,  1111,
       0,  1112,  1113,  1114,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1131,     0,     0,     0,  1798,  1224,     0,
    1520,  1501,  1508,  1503,     0,  1674,  1504,  1512,   417,     0,
    1509,  2332,  1505,     0,  1497,     0,    68,     0,  1724,     0,
       0,     0,  1718,  1720,  1723,  1719,     0,     0,  1725,  1722,
       0,  1721,  1702,  1706,  1710,  1703,  2284,  2282,  2316,  2315,
    2320,     0,  2317,  2313,  2306,  2341,  2310,     0,  2341,  2312,
    2311,  2341,  2307,  2314,  2341,  2279,     0,  1402,  1403,     0,
    2249,     0,  1840,     0,     0,   996,  1758,  1759,  1755,  1401,
    2237,  2240,     0,   452,     0,     0,   463,     0,     0,    64,
      65,     0,   980,     0,   979,   983,     0,     0,     0,  1537,
    1527,  1536,  1735,  1736,     0,   226,   251,   246,   254,   248,
     250,   249,   255,   256,   257,   252,   247,   253,   240,     0,
    2282,     0,  2279,  2373,     0,  2375,  2392,  1020,  2380,  1043,
    1022,  1042,     0,  1033,  2189,  2192,  2200,  1682,   714,     0,
       0,  1653,     0,   536,     0,     0,     0,     0,     0,     0,
    1622,     0,     0,   573,     0,  1646,  1437,  1680,  1681,  1686,
       0,     0,  1686,     0,  1659,  1676,     0,  1686,  1617,     0,
       0,  1609,  1614,  1610,     0,  1616,  1615,  1618,  1606,  1607,
    1682,  1633,  1660,  1676,  1645,  1652,     0,  1632,  1639,     0,
    1650,  1676,  1676,  1686,  1686,   940,   939,   938,   934,   935,
     940,     0,  1602,  1330,     0,     0,  2477,  2491,  2475,  2486,
    2487,  2474,  1016,  2384,  1014,  2385,     0,     7,     4,  1692,
    1690,  1699,  1700,   732,   731,   527,   530,   529,     0,     0,
    1859,     0,   828,     0,  1674,   826,     0,     0,  1674,   353,
    1674,   407,   731,   840,     0,     0,   830,   959,     0,     0,
     440,  1006,   992,  1008,     0,   187,   189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    77,    78,    94,   948,   947,
       0,   945,   971,   970,   968,     0,   969,   967,   962,   964,
     965,  2367,  2371,   537,   731,  1674,     0,   345,     0,     0,
       0,     0,     0,   536,     0,     0,  2417,   103,   784,     0,
       0,     0,  1588,  1516,  1584,  1518,  1839,     0,     0,     0,
    1592,     0,     0,  1407,  1406,     0,  1274,     0,     0,     0,
       0,  1297,     0,     0,     0,     0,     0,     0,     0,  1245,
       0,  1274,  1054,     0,  1203,     0,     0,     0,     0,     0,
       0,  1377,  1378,  1379,  1380,  1388,  1381,  1382,  1383,  1390,
    1395,  1384,  1385,  1391,  1392,  1393,  1386,  1394,  1389,  1387,
    1396,     0,  1376,     0,  1399,  1397,  1400,  1398,     0,  1266,
    1258,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1406,     0,     0,     0,  1406,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1406,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1172,     0,  1831,  1830,     0,     0,     0,     0,  1133,
       0,  1132,  1339,     0,  2386,  2402,     0,  2206,  1261,  1263,
       0,  1056,  1055,  1057,  1068,  1061,  1066,  1059,  1063,     0,
    1115,  1916,  1069,     0,     0,  1097,  2401,  1415,  1098,  1083,
    1088,  1089,     0,  1086,  1087,     0,  1091,     0,  1090,  1094,
    1095,  1096,  1099,     0,     0,     0,     0,  1122,  1127,  1290,
    1046,  1832,     0,  1499,   417,   420,   419,  1510,   418,  1558,
       0,   914,     0,     0,    70,    72,  1715,  1712,  1711,  1713,
    1717,  1716,  1714,     0,  1726,  2309,     0,  2290,     0,  2294,
    2288,  2292,     0,     0,  2280,     0,  2286,  1405,  1990,  2066,
       0,  1408,  2253,  1524,  2495,     0,  1756,     0,     0,     0,
     974,     0,  1046,   450,   449,   448,   447,     0,   465,   445,
     453,    66,     0,     0,  1740,     0,     0,     0,     0,   951,
    1535,     0,  1737,  1733,  1730,     0,     0,     0,     0,     0,
       0,     0,  2376,  2394,  2393,  2381,  1046,  1427,  1047,  1047,
    1828,  2194,  2197,  2198,  2201,  2199,     0,  2196,  2195,  2210,
       0,  1684,  1687,  1688,     0,     0,  1668,  1662,  1661,  1657,
    1663,  1658,  1671,  1670,  1669,  1630,  1629,  1447,  1448,  1446,
    1440,  1441,  1445,  1444,  1625,  1677,  1667,  1665,  1655,  1686,
    1666,  1664,  1611,  1612,  1613,     0,  1436,     0,  1684,  1686,
    1676,     0,  1686,  1686,  1649,  1651,     0,   928,   937,   925,
     932,  1348,  1347,     0,  1304,     0,  1306,  1303,  1302,  1301,
       0,  1347,  2481,  2489,  2493,     0,  1436,  2391,  2389,   528,
    1558,  1558,     0,  1858,     0,     0,     0,     0,     0,     0,
       0,   167,   176,     0,     0,   351,   352,  1558,   350,   393,
     394,   397,   398,   399,     0,     0,     0,     0,     0,     0,
       0,     0,   120,   400,  1558,  1558,   347,   373,   374,   377,
     378,   379,   380,   381,   343,     0,   348,   910,   910,     0,
    1558,  1558,   910,  1558,     0,     0,  1558,  1558,     0,     0,
    1558,     0,     0,   910,     0,  1558,   908,     0,     0,  1558,
    1558,  1558,  1558,   910,     0,     0,  1558,   440,  1558,     0,
       0,   920,     0,     0,  1558,     0,     0,  1558,     0,  1558,
     856,   907,   540,   560,   561,   821,   855,   857,   869,   436,
       0,   886,   909,     0,   842,   844,  2441,  2442,  2443,   995,
     987,   994,   991,  1006,  1004,   993,   773,   772,     0,  1007,
     185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1514,   972,   966,   112,   731,  1558,  1558,  1558,  1558,
     349,   382,   383,   386,   387,   388,   389,   392,   390,   391,
       0,     0,  1674,     0,     0,  2335,     0,  2469,     0,     0,
       0,   165,   538,     0,     0,   785,     0,     0,     0,     0,
       0,  1408,     0,  1842,  1591,  1330,  1595,  1594,     0,  1199,
       0,  1238,     0,  1240,  1241,  1242,     0,     0,     0,     0,
       0,  1200,     0,  1147,  1201,  1202,     0,     0,     0,     0,
    1244,     0,  1178,     0,     0,  1150,  1151,  1144,  1136,     0,
    1217,     0,     0,  1152,     0,     0,     0,     0,     0,  1218,
    1292,     0,  1294,  1832,     0,  1250,  1205,  1157,     0,  1248,
       0,  1158,  1219,  1220,  1221,  1184,  1207,  1208,     0,  1223,
       0,  1209,     0,     0,     0,     0,  1160,  1254,  1252,     0,
       0,     0,     0,  1256,  1193,  1162,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,  1164,     0,  1145,
    1253,  1255,  1213,     0,  1173,     0,  2395,  1338,  2403,  1339,
       0,     0,  2397,  2387,  2392,  2400,  1137,     0,     0,     0,
       0,     0,  1833,  1062,  1067,  1060,  1064,  2401,     0,     0,
       0,     0,  1081,  1080,     0,     0,     0,  2401,  1415,  1084,
       0,     0,  1234,  1235,  1287,     0,  1502,  1500,  1511,  1556,
    1557,  1559,     0,  2333,   916,   915,  1507,   914,    73,     0,
    1709,  1727,  1704,  2345,     0,  2344,     0,  2328,  2331,  1839,
       0,     0,     0,  2263,  2257,  2264,  2266,  2260,  2265,  2267,
    2258,  2259,  2254,  2261,  1409,  1438,     0,   997,   999,  1000,
     998,  1006,     0,     0,  2243,  2244,  2242,  2241,   455,     0,
    1472,  1473,  1458,  1459,  1457,  1460,   464,  1461,  1471,     0,
     476,     0,     0,     0,  1742,  1741,     0,   981,   984,   985,
     956,   955,   957,   950,   952,   953,   520,  1541,     0,     0,
       0,  1547,  1528,  1538,     0,  1959,  2162,  2165,   241,   244,
     243,   245,     0,     0,     0,     0,     0,     0,  1041,  1330,
    1488,  1038,  1026,  1438,  1428,  1025,  1048,  1044,     0,  2193,
       0,  2160,  2221,     0,     0,     0,     0,     0,  2211,  1683,
       0,  1634,     0,  1656,     0,     0,  1627,     0,  1648,  1608,
    1636,  1626,  1408,  1676,  1623,  1624,   942,   941,   936,  1347,
    1330,     0,     0,  1327,  1349,     0,  1349,  1330,  1330,     0,
    1330,  1401,  1344,     0,     0,  2492,  1429,  2390,     0,     0,
     824,   170,   173,   171,     0,   172,     0,     0,   402,   401,
       0,  1674,   395,   124,   123,   125,   126,  1455,  1456,  1452,
    1453,  1451,  1454,   128,   127,   122,   839,     0,     0,     0,
    1674,   375,   354,   355,   358,   359,   360,   911,   814,   975,
     890,     0,   606,   814,   769,   774,   774,   888,     0,   975,
       0,     0,     0,     0,     0,   975,     0,     0,     0,  1558,
       0,   901,   851,     0,     0,     0,     0,     0,   902,     0,
     852,  1558,     0,     0,     0,     0,     0,   975,     0,     0,
     438,     0,   975,   870,   923,   922,   921,     0,   975,   975,
       0,   566,   567,   565,     0,     0,   558,   541,   731,   853,
     437,   854,   605,     0,   917,   602,   608,  1835,     0,     0,
       0,   134,  2445,     0,  1368,   188,    95,    84,    80,    99,
    1465,  1466,  1464,  1462,  1463,   100,    82,    83,    87,    86,
      88,    89,    90,    85,    91,    81,    92,   101,   102,    79,
       0,     0,     0,     0,  1674,   384,     0,     0,  1558,   344,
     361,   362,   365,   366,   367,   368,   369,   372,   370,   371,
       0,  2336,  2338,     0,     0,   338,   337,     0,   129,  2463,
       0,     0,   605,   104,   436,   539,   542,   807,   809,   808,
     799,   798,   105,   107,   109,  1517,  1594,  1330,  1427,  1840,
    1408,     0,  1593,     0,     0,  1239,  1275,     0,  1298,     0,
    1141,   692,   692,  1285,  1283,   677,   692,  1279,  1284,  1281,
       0,   717,     0,   716,     0,     0,     0,  1246,  1243,     0,
       0,     0,     0,  1269,     0,     0,     0,  1146,     0,  1229,
    1251,  1249,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1134,  1046,  2404,  2406,
    1017,     0,  2396,  2398,  2207,  2208,  2209,   816,  1262,     0,
    1078,  1074,     0,  1072,  1414,  1093,  1092,     0,     0,     0,
    1082,  1047,  1225,  1046,     0,  1288,  1834,   416,   572,  1498,
      71,  1707,  2342,     0,  2353,     0,     0,     0,     0,     0,
       0,     0,  2252,  1439,  1568,     0,  1006,  1010,  1849,  1749,
    2245,  2246,     0,   456,   457,   459,  1047,   473,   451,     0,
     443,   446,     0,   455,     0,   954,  1031,     0,  1560,  1545,
    1552,  1546,     0,     0,     0,  1544,  1824,  1823,  1830,  2379,
       0,     0,  2273,     0,     0,     0,  2382,  1408,  1408,  1482,
       0,     0,  1023,  1028,  1024,  1027,     0,  1045,  1052,  1051,
    1825,  1832,     0,     0,     0,     0,   719,   718,   727,     0,
       0,     0,  2206,     0,   723,   725,   724,  2216,   722,  1685,
    1436,  1644,  1643,  1443,  1442,  1619,  1436,  1638,  1686,     0,
       0,  2386,  1342,     0,  1329,  1328,  1350,     0,  1330,  1349,
    1349,     0,  1309,  1308,  1572,  1575,     0,  1307,  1366,  1332,
    1031,  2482,  2494,     0,   730,   729,   571,   726,   570,   175,
     174,   180,   181,   422,   408,   421,   396,   121,   409,   410,
     376,     0,   356,   607,   815,   873,     0,     0,     0,   774,
     601,   814,   783,   775,   814,   814,     0,     0,   551,   548,
     892,   554,   871,   863,   872,   883,   885,     0,   550,   568,
       0,     0,   556,   814,   858,   899,   900,   914,   545,     0,
     581,   582,   580,   562,   569,   546,   547,   894,     0,  1423,
    1425,  1433,   553,   552,     0,   549,     0,   905,   878,     0,
     579,   577,   574,   576,   575,   578,   557,   555,   868,     0,
     910,   910,   887,     0,   589,   590,   592,   593,  1838,     0,
     919,   889,     0,   594,   603,   595,     0,     0,     0,   144,
       0,     0,   841,     0,   137,   135,   146,     0,     0,     0,
    1371,     0,  1372,  1369,  1370,     0,    96,    98,   415,   414,
     413,   412,   385,     0,     0,     0,  1674,   363,  2337,     0,
       0,  2470,   341,   339,   340,     0,     0,   190,   587,   588,
     586,   585,     0,   425,     0,  1887,   423,     0,   435,     0,
    1760,   731,   543,     0,     0,     0,     0,  1408,  1449,  1843,
    1587,     0,  1174,  1299,     0,     0,   693,  1276,   739,     0,
    1286,   679,   678,  1278,  1280,  1282,  1140,  1148,  1216,  1143,
    1142,     0,     0,     0,  1181,  1182,     0,  1267,     0,     0,
    1154,     0,  1156,     0,     0,  1231,  1206,  1222,  1185,  1210,
       0,  1159,  1135,     0,  1186,     0,  1191,  1189,     0,  1163,
       0,     0,  1170,     0,  1168,     0,  1169,     0,  1171,  1212,
    1214,  1340,  2405,  1018,     0,     0,  1264,  1070,     0,  1079,
    1076,     0,  1073,  1048,  1236,  1226,     0,  1705,  2343,     0,
    2278,  2330,  2329,  2346,  2346,  2346,     0,  1410,     0,  1525,
    1001,  1006,  1010,     0,  1002,  1760,   460,     0,     0,     0,
     480,     0,   478,   454,     0,   982,  1046,  1542,  1554,     0,
    1562,     0,     0,  1539,  1549,     0,     0,     0,  1548,   242,
       0,  2270,  2271,  2269,  1438,  1416,     0,     0,  1494,     0,
    1489,  1039,     0,  1050,  1049,     0,  2223,     0,  2222,  2234,
    2235,  2232,  2233,  2231,  2212,     0,  2218,  2217,     0,     0,
       0,  2228,  2219,     0,     0,  1635,  1637,  1631,   943,  2392,
    1401,  1334,  1330,  1305,  1330,  1316,     0,     0,  1330,  1312,
    1310,  1314,     0,  1408,     0,  1331,  1363,  1046,  1827,  1430,
    1433,   357,   875,     0,   814,   770,   771,   783,     0,   783,
     783,     0,     0,   862,     0,   963,     0,   867,   727,   563,
     898,   897,   564,     0,   860,     0,  1434,  1435,  1426,   439,
     859,   880,   865,  1726,   891,   605,   918,   751,   673,   622,
     613,   692,   616,   615,   659,   630,   627,   677,   675,   645,
     677,   677,   652,   651,   669,   655,   635,   739,   739,   634,
     672,   739,   656,   654,   658,     0,   660,   677,   665,   653,
     657,   674,   650,   647,   671,   692,   629,   628,   631,   670,
     739,     0,   663,   692,   696,   633,   739,   746,     0,     0,
     692,   694,  1837,   145,   133,     0,     0,   843,   845,     0,
       0,   846,  2447,     0,  2449,     0,  1009,     0,    93,     0,
       0,   346,   411,   364,  2339,     0,   201,  1046,     0,     0,
     191,   193,   194,     0,     0,     0,   538,  1762,  1761,   424,
     523,   544,     0,     0,     0,  1594,  1589,     0,  1585,     0,
    1300,     0,     0,     0,     0,   733,   744,   742,   736,     0,
     740,   741,  1277,     0,  1247,     0,     0,  1270,     0,     0,
       0,     0,     0,     0,     0,  1138,     0,  1227,     0,     0,
       0,     0,     0,     0,  1167,  1165,  1166,  1438,  2386,   817,
    1075,     0,  1237,     0,     0,     0,  2351,  2351,  2351,  1567,
    1566,     0,  1565,  1569,  1003,  1011,     0,   458,   461,     0,
     453,     0,   477,     0,   444,   521,     0,     0,     0,  1563,
    1551,  2383,  1540,  1543,  1832,  2272,  1030,     0,  1411,  1493,
    1490,     0,  1483,  1485,  1487,     0,  1826,     0,     0,  2227,
    2213,   728,     0,     0,     0,     0,  2214,  1335,  1333,  1343,
       0,  1301,  1330,  1330,     0,  1301,     0,     0,     0,  1574,
    1427,  1576,  1367,     0,  1345,     0,  1432,     0,     0,   874,
       0,     0,     0,     0,     0,     0,   904,     0,   917,   864,
     884,   906,   696,   975,  1424,   879,   881,   951,     0,   591,
       0,   755,   621,   614,   632,   681,   676,     0,   681,   681,
     641,   659,   636,     0,   739,   649,   640,   661,   664,   666,
     668,   681,     0,   739,   638,   625,   681,   704,     0,     0,
       0,   700,     0,   749,     0,   707,   609,   697,   699,     0,
       0,   662,   739,   618,   747,   746,   620,   739,   746,   681,
       0,   695,   681,     0,   131,   136,   147,   148,   834,  2446,
       0,  2444,     0,  1005,  1373,    97,     0,     0,   204,   202,
     203,     0,   197,   199,   194,  2457,     0,  2464,     0,     0,
    2462,   426,   428,   436,   524,     0,     0,  1433,   812,     0,
       0,  1450,  1175,   690,   688,   691,   689,   735,   734,   738,
       0,   737,   746,     0,  1179,  1180,     0,  1268,  1259,  1204,
       0,  1155,  1228,     0,     0,  1211,  1187,  1190,  1188,  1194,
    1195,  1038,  1038,   583,  2399,  1077,  1708,  2354,     0,     0,
    2350,  2348,     0,  2349,  2347,  2321,     0,  2276,  2277,  2275,
    2262,     0,     0,     0,  1046,   466,     0,   483,   482,   479,
    1438,  1553,  1555,  1561,  1550,     0,  1412,  1427,   720,  1486,
       0,  1040,  2225,  2224,  2226,  2220,     0,     0,     0,     0,
    1317,     0,  1321,  1326,  1322,     0,  1313,  1311,     0,  1449,
    1355,  1356,     0,     0,  1361,  1365,  1438,  1433,   877,     0,
     604,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   903,  1803,   893,   895,   861,     0,   866,   559,     0,
     754,     0,   759,   685,   686,   687,   642,   682,   684,     0,
     644,   612,   637,   667,   643,     0,   639,   626,   710,   709,
    1053,   702,   713,     0,     0,   708,   698,   706,   701,   617,
     619,   623,   624,   610,     0,   611,  1836,   138,   847,   278,
    2448,  1021,     0,  2453,   119,  2461,  2471,   201,     0,     0,
     142,     0,   192,   727,   195,  2383,  1760,     0,   431,   786,
       0,   811,     0,   788,   790,   745,   743,     0,  1271,  1433,
       0,  1230,  1232,  1341,   584,  2327,  2326,  2325,  2322,     0,
       0,     0,     0,     0,     0,  2352,  2356,  1564,     0,     0,
       0,   474,     0,     0,   508,   522,  1420,  1433,     0,  1438,
       0,  1491,  1484,  2230,  2229,  2215,  1336,     0,     0,     0,
       0,     0,  1374,  1573,  1351,  1351,  1362,  1346,  1431,   876,
       0,     0,   786,     0,     0,  1805,  1804,   917,     0,   752,
       0,   756,   757,   758,     0,   750,   683,     0,   818,     0,
     712,  1053,   705,     0,   140,   304,     0,   290,   276,     0,
       0,     0,   280,   149,   152,   150,     0,   151,   157,     0,
     158,   159,   160,   161,   162,   153,   302,   303,   156,   154,
     155,     0,  1852,     0,  1853,  2451,     0,     0,  2450,   168,
     198,     0,     0,   134,   143,  2465,   711,   429,   427,     0,
    2379,     0,  1558,   106,   787,   803,   802,   792,  1433,     0,
       0,   108,   789,   805,   796,   110,   791,   804,   794,   680,
       0,  1273,  1153,  2323,  2357,  2360,  2358,  2359,  2361,  2355,
       0,  1750,  1047,     0,   467,     0,   470,   472,   486,     0,
    1558,     0,     0,  1558,  1558,  1558,  1558,   501,   509,   511,
       0,  1421,  1422,     0,  1417,  1419,  1413,  1474,   721,  1763,
    2386,  1318,     0,  1323,     0,  1315,     0,     0,  1359,  1357,
       0,   786,   596,   788,   790,   896,     0,   753,     0,     0,
     739,     0,   739,   703,   139,     0,   132,     0,     0,   289,
     292,     0,     0,   295,   285,   284,   286,     0,   279,   278,
     278,   332,   283,   329,   328,   321,  2383,     0,     0,     0,
    2472,   200,  1046,   146,     0,   433,   432,   801,     0,   793,
     810,   813,     0,   797,   795,  1433,  1570,  1578,     0,   720,
       0,   475,   468,     0,     0,   484,     0,  1558,  1558,     0,
       0,     0,     0,     0,   481,   510,  1558,  1433,     0,  1029,
       0,  1771,  1337,     0,     0,  1375,     0,  1352,     0,     0,
       0,   600,   599,   597,   598,     0,   765,     0,   764,     0,
     761,   760,   646,   819,   648,   141,   305,   316,   319,   311,
     291,     0,     0,     0,   281,   278,     0,   265,   263,   264,
     270,   271,   272,   273,   274,   275,   266,   269,   267,   268,
     278,     0,   209,     0,     0,  2452,     0,  2454,     0,   178,
     177,   169,     0,   278,  2458,     0,  2466,  2383,   800,   806,
    1272,     0,     0,  1751,   462,   474,   471,   494,   487,   490,
       0,   519,     0,     0,  1469,  1467,  1468,   515,  1470,   516,
     514,   512,   505,     0,   503,     0,  1418,  1475,     0,     0,
       0,     0,  1764,  1766,     0,  1492,  1320,  1325,  1354,  1353,
    1368,     0,   882,   767,   768,   766,     0,     0,     0,     0,
     278,   312,     0,   287,     0,     0,     0,     0,   207,   335,
       0,   205,   323,   323,  2455,  2456,   179,  2473,     0,   148,
     168,   434,  1577,  1579,  1777,   469,   494,     0,   492,     0,
     488,   485,   489,   517,   518,     0,   502,     0,   513,     0,
       0,     0,     0,     0,  1765,     0,     0,  1772,  1774,     0,
       0,     0,     0,   313,   319,   309,   317,   278,     0,     0,
     277,   296,   331,   208,     0,   333,     0,   278,     0,   322,
     324,   326,     0,   130,  2467,     0,  1763,   491,     0,   499,
     495,   497,   500,   508,   507,   504,  1046,  1769,  1770,     0,
    1767,     0,     0,  1773,  1360,  1358,   763,   762,     0,   310,
       0,     0,   308,   288,   293,   278,     0,   278,   220,   219,
       0,   211,   259,   330,     0,   210,  2459,   278,     0,  1771,
     493,     0,     0,   506,     0,     0,  1478,  1480,  1768,  1776,
    1775,   314,     0,   278,     0,   278,     0,   278,     0,     0,
       0,     0,     0,   206,   278,  2468,     0,  1779,   498,   496,
    1047,  1476,  1046,     0,   306,   278,   294,   299,   336,     0,
     214,   260,   261,     0,   217,  2460,  1778,     0,  1783,  1481,
    1479,   278,   278,   295,   298,   334,     0,     0,   212,   213,
     225,   224,   216,     0,     0,     0,  1790,   278,   278,   300,
     233,   231,   278,   221,   229,   223,     0,   230,   262,   218,
    1781,  1782,  1780,  1785,     0,     0,  1787,  1788,     0,  1752,
       0,   215,   232,  1789,  1784,     0,  1791,  1793,     0,   222,
    1786,     0,  1046,  1792,     0,  1047,  1794
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    56,   575,  1378,    57,    58,    59,    60,    61,  1249,
      62,   774,  1186,  1664,  1665,    63,   515,    64,   971,  1435,
    1436,  2845,  2846,  1437,    65,  1992,  2883,  2884,  2885,  1454,
     485,   486,  1851,  1852,   996,  2866,  2832,  3597,  2836,  3704,
    3836,  3743,  1924,  3171,  3598,  3599,  3713,   510,  1990,  1392,
    3860,  1831,  3961,  1832,    66,   605,   969,  1414,  1415,  3189,
    3190,  3429,  3191,  3421,  3422,  3423,  3424,  4087,  3935,  4031,
    4088,  4160,  4196,  4202,  4203,  4130,  4212,  4213,  4214,  4200,
     841,  4215,    67,   538,   539,   843,  1278,  2238,  1279,    68,
    4131,  4198,  3936,  3937,  3843,  3938,  3716,  3939,  3847,  3940,
    3719,  3941,  3942,  3943,  3944,  4079,  3945,  3842,  4123,  3932,
    3933,  4125,  4177,  4194,  3946,  3726,  3837,  4018,  3727,  3838,
    4074,  3928,  4075,  4118,  4173,  3929,  4019,  4121,  4022,  3947,
    3953,  4089,  3948,  3954,  3949,  3731,  3854,  3952,  3852,  3951,
    4127,  4084,  2477,  2865,   593,   594,   616,  1982,   595,   985,
     944,  1394,  1864,  1865,  2342,  2343,  2459,  2460,  2461,  1856,
    1857,  1858,  1970,  1971,  1972,  1838,  1839,  1840,  1398,  1835,
    1836,   596,   945,   955,  1859,  1860,  1861,  2465,  1974,  1975,
    1976,  1977,  1862,  1657,  1863,  2734,  2483,  2876,  3615,  3199,
    3750,  3967,  2877,  2878,  2410,  2794,  2390,    69,   527,   821,
    1246,  2211,  1247,  2213,  2622,  2623,  2624,  1703,  1704,  3495,
    1708,  2210,  3651,  3975,  3785,  3786,  2626,  3784,  2630,  2991,
    2992,  3271,  3497,  3654,  3980,  3884,  4051,  3978,  4047,  3979,
    4049,  4142,  4100,  4101,  3894,  3993,  3994,  4055,  4103,  3797,
    3798,  3799,  2231,  2636,  3500,  3435,  1964,  1384,  1385,   487,
     488,   489,   613,  2484,  1911,  2485,  2486,  2809,  1913,  1914,
    2597,  1312,  2806,  2783,  3471,  2872,  2813,  2814,  2815,  2816,
    2817,  2823,  2750,  2351,  2352,  2415,  2826,  3613,  3357,  3372,
    3155,  3156,  3157,  3158,  3159,  3160,  3161,  2900,  2901,  3566,
    3567,  3568,  2896,  2897,  3402,  3386,  3387,  3388,  3614,  3581,
    3219,  2677,  2678,  3661,  2686,  2687,  2725,  3036,  2726,  1388,
    3220,  3221,  3222,  3396,  3389,  2825,  3351,  3559,  3562,  3695,
    3920,  2353,  2751,  2354,  2754,   900,   490,  2355,  2356,  1468,
    1469,  3753,  3761,  3765,  3754,  3766,  3762,  3755,  3756,  3757,
    3768,  3764,  2490,  3436,  3437,  2743,  2956,  3697,    70,  1402,
     938,   947,   943,   961,   600,  1403,  1925,  2421,  3408,   583,
    1915,  3343,  3085,  3347,  1916,  2763,  1917,  3072,  3329,  1918,
    3101,  3345,  3556,  2764,  2765,  1919,  1920,  1921,  3084,  3093,
    3687,  2357,   123,  2156,  2821,  2397,    71,  1360,  1355,    72,
     912,   907,   908,  1358,  1359,  1797,  2287,    73,   608,  1441,
      74,  1257,  2223,  2224,  2225,    75,   962,    76,    77,   609,
    1448,  1449,  1450,    78,  1242,   130,    79,   829,  1252,  1254,
    1255,    80,   604,   963,   964,   965,   966,  1930,    81,  1695,
    2187,  2188,  2189,  2190,  1411,  2423,  1412,  1413,  1939,  2984,
      82,    83,   572,  2111,   544,   850,   545,   546,  1737,  2251,
    3472,   861,   862,   863,  2662,  1290,  1291,  1292,  2256,  2667,
    1041,   739,   740,   741,   742,  1134,  1135,  3390,   743,  1144,
    1623,   744,   745,   746,   747,   748,   749,  1650,  2924,  2925,
    3237,  2141,  2142,  2143,   750,  2029,  2911,  2042,   751,  1127,
    1608,  1540,  3229,  2917,  3456,  3628,  1485,  2012,  2520,  2594,
    2105,  1066,  1067,  1031,  2019,  1491,  1804,  1805,  1806,  1807,
    1808,  3317,  3316,  3318,  3667,  3521,  3669,  3525,  2298,  1809,
    1810,  2700,  3519,  3810,  2106,  2107,  2108,  3247,  2701,  3052,
    2719,  2720,  3536,  2289,  1811,  2707,  3818,  3533,  3534,  3910,
    3909,  3535,  3322,  3323,  3065,  3066,  2841,  2842,  2843,  3671,
    1531,  1532,  1538,  1229,  1230,  1486,  2185,  2611,  3507,  3658,
    2132,  3288,  3656,  3804,  1922,  2789,  2790,  2253,  2254,  2723,
    3069,  3098,  1315,  3473,  2613,  1770,  1771,  3208,  4201,  2735,
    2435,  3987,  2207,  2208,  3899,  4059,  4145,  4146,  4147,  3018,
    3019,  3292,  3293,  2255,  2659,  3020,  3508,  3809,    84,   494,
      85,  1662,  2147,  1183,  2161,   973,  1472,  1473,   762,   507,
      86,   516,  2186,    87,   534,  1721,   813,   833,  1260,  1261,
    2232,  2637,  2644,  2233,  2649,  3281,  2639,  2997,  2998,  2151,
    2152,  2640,  3000,  3278,  3261,  3262,  2979,  3492,    88,   560,
    3063,  2714,  2715,  3876,  3877,   834,    89,   493,  1018,  2001,
    1478,  2000,  1019,  1020,  2003,   634,   635,    90,   914,   557,
    1337,  1338,  1339,  1786,    91,   549,   901,  2690,  2696,  1765,
     825,  1179,  1319,   904,  1320,  1751,  2271,  1301,    92,   934,
     933,    93,   579,  1380,    94,   775,  1202,  1674,  2601,  2967,
    1203,  1204,  2162,    95,   535,   838,   839,  1263,  1723,    96,
     529,   826,  1714,    97,   520,    98,    99,   817,  2985,  3879,
    4044,   524,  1697,  1238,  3200,  3901,  4002,  4003,  4005,  4067,
    4068,  4096,  4188,  4222,  4206,  4225,  4226,  4229,  4236,  4237,
     753,   921,   754,  3551,   755,   756,  2645,  2646,  3070,   757,
    2647,   758,  2744,   974,  1475,   513,   465,   590,   922,  2619,
     760,  3733,   941,   989,   467,   468,   100,   865,   548,  1294,
    1295,  1296,  1746,  1747,   905,  2120,  1748,  1749,  2268,  2263,
    3300,  3042,  3034,   101,   818,   472,  1240,  1241,  2196,   102,
     559,   103,  1231,  1691,  1692,  2182,  2610,  2183,   104,   846,
     105,   800,  1685,   801,  1207,   802,   803,  1221,  1215,  1224,
    1218,  3639,  3484,  3485,  2170,  1182,   990,   991,  1677,  2164,
    2165,  3256,  3487,  2970,  3645,  3646,   106,   131,   475,   611,
     980,  1284,   107,   108,   109,   110,  1287,  1373,  2247,  1374,
    2112,  1375,  1376,  1818,  1735,  1604,  1605,  2954,  1124,  1125,
    2115,  2567,  2568,   864,   620,  1006,   998,   124,   125,   126,
     623,   624,   127,   959,   960,  2422,  2838,  3173,  3411,  3412,
    3603,  3738,  1000,  3609,  4038,  4164,  1001,  1002,  2867,  3611,
    3864,  4040,  4137,  1003,  2474,  3186,  3739,  3963,   111,   923,
     569,  1371,  1366,  1368,  1814,  2305,   112,   113
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3646
static const int yypact[] =
{
    4367,  2190,    95, -3646,  -107,   226, 42666,   570,  1196,  1196,
     379,  2881, -3646, -3646, -3646, -3646, -3646,  2699, -3646, 42666,
      95, -3646, 23336, -3646, -3646,   541,   175,    86,  1196,    95,
   -3646, 42666, -3646,   480,  1304,    95, -3646, -3646, 37986, -3646,
     379, 42666, -3646,   615, -3646, 37986,  -100,   -94,   560,   630,
     796, -3646, -3646, 42666,  1575,  -124,  1287,  1186, -3646, -3646,
     967, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, 23925, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,  1288, 42666,  1297, 42666, -3646,  1266,
   42666, 36231, 42666,  1013,  1391, -3646, -3646,  1438, -3646, -3646,
    1196,   379, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646,   991, -3646, -3646,  1077,
   -3646, -3646, -3646, -3646, -3646,  1619,  1432, -3646,  1458, 36231,
   -3646, 42666, -3646, -3646, -3646,  1090, -3646,  1157, -3646,  1202,
    1538,  1548,  1564,  1199, 11378,  1529,  1529,  1529, 42666,  1565,
    1529,  1529, 42666, -3646,  1529, -3646,  1529,  1196, -3646, -3646,
    3753, 42666,  1395,   186,   -87, 36231,  1364, 42666, -3646, -3646,
   11378, -3646,  1562, -3646, -3646, -3646,  1196,  1752,  1651,   215,
   42666, -3646, -3646,  1196,   263,    15,  1283, -3646, -3646,  1423,
   -3646,  4111,   144, -3646, -3646, -3646,  1854, -3646, -3646,  4848,
    1423, -3646, -3646, -3646,  1300, -3646, -3646, -3646, 42666,  1196,
    1566, -3646, -3646,   145,   145,   145, -3646,   145, -3646,   145,
   -3646,  -124,  1295, -3646, -3646,  1279, 42666,  -117,   703, -3646,
   -3646,  1280,   968, -3646,  1351, 33306, -3646, 42666, -3646, -3646,
   -3646, -3646,  1571, -3646, -3646, -3646,  1431, -3646, 23336, 42666,
    1443, -3646, -3646, -3646, 23336,  1327, 42666, -3646, 23336, 23336,
     799,  1093,  1628, 42666, 42666,  1766, -3646,  1929, 33306,  1532,
   -3646,   707,  1331,  1438,  1950, -3646,  1432, -3646, 42666, 42666,
   42666, -3646, -3646, -3646, 38571,  1199,  1380,  1383,  1385, 15620,
   -3646,  1392,  1398,  1405, 11378,  1437,  1441,  1445,  1472,  1482,
    1502,  1504,  1521,  1546,  1546,  1554,  1582,  1587,  1598,   806,
    1601, -3646,  1612,  1620,  1625, -3646, -3646,  1633,  1636,  1655,
   -3646,  1680,  1689,  1697, 11984,  1707,  1722, -3646, 20387,  1742,
    1776,  1779,  1788,  1791,  1803,  1806,  1811,  1815, -3646, -3646,
   11378,  1817, -3646, -3646,  1822, -3646,  1838,  1850,  1852,  1860,
    1862,  1866,  1872,  1878,  1886,  1889,  1891,  1898,  1900,  1903,
    1905,  1908, -3646,  1094,  1914,  1916,  1374,  1918, -3646,  1921,
   -3646,   146,  1924,  1546,  1546,  1546,  1930,  1932,  1935,  1946,
    1953, 15620, 15620, 15620, 11378, -3646, 42666, -3646, 42666,  1915,
    2735, -3646,  2120, 15620,   228, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646,  1426,  1570, -3646, -3646, -3646, -3646, -3646,  1956,
    1450,  1958, 42666, 42666, 42666,  1729, 42666, 42666, 36231,  1632,
   42666, 33306, -3646,  1529,  1574,  2668,  1769,  1714,  1657, -3646,
   -3646, -3646, -3646, -3646,  1813, -3646, -3646,  1668, -3646,  1834,
   -3646, -3646,   139, -3646,   177, -3646, -3646, -3646, -3646, -3646,
   -3646,  1967,  1560, -3646, -3646,   117, -3646, -3646, 42666, -3646,
   -3646, -3646, -3646,  2264,  2028,  1915,  2512,   189, 23336, -3646,
      67, -3646,  -177, -3646, -3646,  2330, -3646, -3646, 33306, 23336,
   -3646, -3646, -3646, 20976, -3646, -3646,  2548, -3646,  1994, -3646,
   -3646,  1570,  2810, -3646,  1769,  2271, -3646,  2273,  2183,  1093,
    2088, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  2058,  1854, -3646, -3646, -3646, -3646,  2498, -3646,  2202,
     -21, -3646,  2059,  2010,   -21, 33891,  2410,   200, -3646,   106,
   -3646,  2490, -3646, -3646, -3646, -3646,  2182,  2164, -3646, -3646,
     179,  2445, -3646,  2521, -3646,    73, -3646,  2188,  2410,   -21,
     200, -3646,  2417,  2533,   445,   412, -3646, -3646,   -43, -3646,
   -3646,  2601, -3646, -3646, 23336, -3646, -3646,  2264, -3646, -3646,
   -3646,  2081, -3646,  2347,  2203, -3646, -3646,    38, -3646,  2104,
     764,  2555, -3646,   895, 34476, -3646, -3646, -3646,  2593,  2618,
    1546,  2115, -3646, -3646, -3646,  2726, -3646, -3646,  2133,  2632,
    2632,  2632,  2738, -3646, -3646, -3646, -3646, -3646,  2297,  2173,
   -3646,  1443, 23336,  2528,  2146, -3646, -3646,  2396, 11378, -3646,
   -3646,  3904,    45, -3646, -3646,   221, -3646,  2715,  2358, -3646,
   -3646, -3646, -3646,  2612, -3646, -3646,  2726,  2672,  2632,  2568,
    2176, -3646, -3646, -3646, -3646, -3646, -3646,   211, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646,  1481, -3646, -3646, -3646, -3646,
   -3646,  1443, -3646, 23336, -3646, -3646, -3646, 23336, -3646,  2177,
   -3646,  2174, -3646, 11378, 11378,  1073,  2717,  2774,  2774,  2774,
    1915,  2210, 11378, 11378, 11378, 11378, 11378, 11378, 11378,  1128,
    2185, -3646, -3646,  8954, -3646,  2186, 11378, 11378,  2274, 11378,
    1570, 11378, 24514, -3646,  3625, 11378,   289,  2659, 11378, 11378,
   11378, 11378,  4044, 11378, 11378, 24514,  2786,  2192, -3646,  2187,
    1284, 11378, 11378,  1394, 11378, 11378, 11378, 11378, 11378, -3646,
    8954, -3646, 11378, 11378, 11378, 11378, 15620, 11378, 11378, 11378,
   11378, 11378, 11378,  2774,  2774, 11378, 11378,  1528,  8954, -3646,
   11378,  1570,  1874,  1874, 11378,  1570,  7742, 11378, -3646, -3646,
   -3646,  2197, -3646, -3646, -3646, 24514,  2774,  2774, 11378, 11378,
    2717,  2717,  2717,   204,  2201,   920, 11378, 25692,  2200, -3646,
   -3646, -3646, -3646, 11378, 11378, 11378, -3646, 15620, -3646, -3646,
    1048, -3646, -3646, -3646, 12590, 15620, 15620,  2206, 15620, 15620,
   15620, 15620, 15620,  2560, 15620, 15620, 16226, 16832, 15620, 15620,
   15620, 15620,   899,  2717, 36231, 15620, 11378, -3646, -3646, 42666,
   -3646, -3646, -3646,  2204, 23336,  1632, -3646, -3646,   545,  2667,
   -3646, -3646,  2215, 23336, -3646,  2211, -3646,  2559, -3646,  2561,
    2562,  2564, -3646, -3646, -3646, -3646,  2781,  2566, -3646, -3646,
    2570, -3646, -3646,  2228, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  2326, -3646, -3646, -3646,  2234, -3646, 33306,  2234, -3646,
   -3646,  2234, -3646, -3646,  2234,   714,  4071, -3646, -3646, 42666,
   -3646, 43251, -3646, 20976,  -107, -3646, -3646, -3646,  2578,   158,
    2235, -3646, 23336, -3646,   116,   116,  2469,   946, 36231, -3646,
   -3646,   160,  2239,  2315,  2249, -3646,  2327, 23336, 23336, -3646,
   -3646, -3646, -3646,  2847,    15, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,  2256,  2710,
    2261, 33306,   733, -3646, 42666, -3646,  1542, -3646, -3646, -3646,
    2265, -3646, 11378, -3646,  2266, -3646,  1489,  2644, -3646,  -107,
   11378, -3646,  2281,  1432, 42666, 42666, 42666, 23336, 42666, 23336,
   -3646,   888,   888, -3646, 31551, -3646, -3646, -3646, -3646,   -21,
   42666, 42666,   -21, 33306, -3646,   200, 42666,   -21, -3646,  2648,
    2374, -3646, -3646, -3646,  2719, -3646, -3646,  2711,  2286, -3646,
    2644, -3646, -3646,   200, -3646, -3646, 23336, -3646, -3646,   200,
   -3646,   200,   200,   -21,   -21,  2344, -3646, -3646,  2296, -3646,
    2344,  2443, -3646,   600,   145,  2541, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646,  1024, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,   166, -3646, -3646, -3646,  1888,  2787,
   -3646, 36231,  2275,   844,   756,  2275,   877,  -107,  1555, -3646,
    1555, -3646,  3345,  2567,  1097, 23336, -3646,  2314, 39156, 23336,
   -3646, -3646, -3646,   157,  2316,  2320,  1915,  2776,  2777,  2778,
    2784,  2785,  2788,  2790,  2791,  2795,  2803,  2804,  2807,  2808,
    2811,  2812,  2814,  2817,  2821,  2334, -3646, -3646, -3646, -3646,
   23336, -3646, -3646, -3646, -3646,  2418, -3646, -3646, -3646, -3646,
    1338, -3646, -3646, -3646,   230,  1600,  2391,  2416,   111, 33306,
    2792, 42666, 42666,  1432, 42666, 42666, -3646, -3646,  -147,  2631,
    2633,  2641,  2386, -3646, -3646, -3646,  -195, 42666,  2809, 28041,
   -3646,   300,   348, -3646,  2774,  2389, -3646,  2392,  2393,  2394,
   11378,    53,   293,   411,  1399,  1409,   879,   342,   149, -3646,
    2402,  2397, -3646,   911, -3646,   439,   461,   926,   974,  2406,
    2407, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  2829, -3646,  1448, -3646, -3646, -3646, -3646,  2395, -3646,
   -3646,   993,   466,   473,   206,  2421,   479,  1477,  1492,  2412,
   24514, 42666,  2774,  2419,  1018,  1038,  2774,  2420,   502,  1042,
    1505,  1534,  1583,  1096,  1150,  1158,   558,  1595,  2716,  1165,
     664,   666,   672,   706,  1169,  2422,  2423,   708,   274,  2774,
    2425,  1173,   340,  2426,  2432,  1177,  9560, 10166, 10772,   891,
     783, -3646,  2436, -3646,  2187,  2437,  2446,   344,  1181, -3646,
   11378, -3646, -3646,   958,  1161,  2471,   184,    58, -3646,  2565,
   42666,  2019,   151, -3646, -3646, -3646, -3646, -3646, -3646,   831,
   -3646,  2448, -3646,  2449,  1968,  2434, 11378,   971,  2434,  2526,
    1848,  1848, 15620,  2902,  2447, 11984,   989, 11984,   989,  2434,
    2434,  2434, -3646, 15620,  2451, 15620, 15620, -3646,  2717,  1915,
    2452,  1081, 42666, -3646,   545, -3646, -3646, -3646, -3646,    81,
   33306,   132, 23336, 36231,  2444, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646,  4112, 23336, -3646, 42666, -3646,  2529, -3646,
   -3646, -3646, 21565, 21565, -3646, 21565, -3646, -3646,   729,   763,
    2910,  2479, -3646, -3646, -3646, 23336, -3646,  2841,   961, 23336,
    2314,  2458, -3646, -3646, -3646, -3646, -3646,  1551,  2572, -3646,
    3056, -3646, 11378,  -107, -3646, 33306, 33306, 23336, 23336,    42,
   -3646,  1403, -3646, -3646, -3646,  2810, 17438,  2877,  2889, 21565,
   21565, 21565, -3646, -3646, -3646, -3646, -3646,   109,  1915, -3646,
    2464, -3646, -3646, -3646, -3646, -3646, 39741,   126, -3646, -3646,
    -107,  2893, -3646,  1915,  2474, 42666, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,   -63, -3646, -3646, -3646, -3646, -3646, -3646, -3646,   -21,
   -3646, -3646, -3646, -3646, -3646,  2689,  2410,  2445,  2893,   -21,
     200, 23336,   -21,   -21, -3646, -3646,  1627, -3646,   -43, -3646,
   -3646, -3646, -3646, 42666,  2517,  2630, -3646,  2482, -3646, -3646,
   23336, -3646,  2483, -3646,  2911,  3044,  2410, -3646, -3646, -3646,
      81,    81,  2779, -3646,  -107,  2616,  2619,  2624,  2627,  2628,
    2669, -3646, -3646,  -107,  -107, -3646, -3646,    81, -3646,   837,
   -3646, -3646, -3646, -3646,  -107,  -107,  -107,  -107,  1602,  -107,
    -107,  1603, -3646, -3646,    81,    81, -3646,   294, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646,   916, -3646,  2255,  3042,  2746,
      81,    81,  3042,    81,  2747,  2757,    81,    81,  2600,  3008,
      81,  2905,  2636,  1368,  2909,    81, -3646,  2638,  3021,    81,
      81,    81,    81,  3042,  2780,  3105,    81, -3646,    81,  2789,
    2793,   187,  2794,  2798,    81,   156, 42666,    81,  2799,    81,
   -3646, -3646,  5031, -3646, -3646, -3646, -3646, -3646, -3646,   948,
   22156, -3646, -3646,   202, -3646,  2739, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,  2554, -3646,
   -3646, 11378,  2558,  1602,  -107,  -107,  1843,  -107,  1602,  -107,
    -107,  -107,  -107,  -107,  1602,  1602,  -107,  2125,  -107,  1602,
    3904, -3646, -3646, -3646, -3646,   254,    81,    81,    81,    81,
   -3646,  1753, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   36231,  2894,  2076,   -44, 36231, -3646, 42666, -3646,   371, 42666,
    2563,   471,  3357,   338,   338, -3646, 23336, 23336, 23336, 42666,
    2602,  2479, 28041, -3646, -3646,   600, -3646,  2552, 13196, -3646,
    2569, -3646, 11378, -3646, -3646, -3646,  1060, 11378, 11378,  3024,
    1996, -3646, 35061, -3646, -3646, -3646, 11378, 35061,  1996, 11378,
   -3646,  2573, -3646,  2947,  2956, -3646, -3646, -3646, -3646, 11378,
   -3646, 11378, 11378, -3646, 11378, 11378, 11378, 11378, 11378, -3646,
   -3646, 15620, -3646,  2574,  2580, -3646, -3646, -3646,  2582, -3646,
   11378, -3646, -3646, -3646, -3646, -3646, -3646, -3646, 11378, -3646,
   11378, -3646, 11378, 11378, 11378, 11378, -3646, -3646, -3646, 13802,
   11378, 11378,  2587, -3646, -3646, -3646, 11378, 11378, 11378, -3646,
   11378,  1109, 11378,  1428, 11378,  1807, 11378, -3646, 11378, -3646,
   -3646, -3646, -3646, 11378, -3646,  1606, -3646, -3646,  2011, -3646,
     958,  2588, -3646, -3646,  1542, -3646, -3646,  2583,  2584,  2585,
   36231, 11378, -3646, -3646, -3646, -3646, -3646, -3646, 15620,   346,
    2589, 15620, -3646,  2526,  4044,  4044,  2095, 11378,   971,  2526,
   11378,  2596,  2598, -3646, 11378, 42666, -3646, -3646, -3646, -3646,
   -3646, -3646, 36231, -3646, -3646, -3646, -3646,   132, -3646,  2211,
   -3646,  2314, -3646, -3646,  1616, -3646, 33306,  2595, -3646,  2597,
    2674,  2675,  2677, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646,  2410,  1403, -3646,  2604, -3646,
   -3646,  2396,  2692,  2626,  2953, -3646, -3646, -3646, 42666, 15620,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,  3169,
    2617,  2620,  3066,  2623,  1915, -3646,  2697, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646,    93, -3646, -3646,  2625,  2625,
   19207, -3646, -3646, -3646,  3068,   -72,   -72,   -72, -3646, -3646,
   -3646, -3646,  2868, 33306,  3046,  3047,  3048,   895, -3646,   332,
   -3646,  1003,  3006,  2410, -3646,  3053, 36816, -3646, 28626, -3646,
    2629,  3002,  2637,    81, 30966,   700, 26280, 32136, -3646, -3646,
    1843, -3646,    46, -3646, 31551, 31551, -3646,  2895, -3646, -3646,
   -3646, -3646,  2479,   200, -3646, -3646, -3646,  2642, -3646, -3646,
     976,  3004,  3011, -3646,  2891,    65,  2891,   976,   976, 24514,
     600,  2126, -3646,  1602,  2946, -3646, -3646, -3646, 35646, 32721,
   -3646, -3646, -3646, -3646,  3146, -3646,  3150,  1270, -3646, -3646,
    2229,   756, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646,   877,  2229,  2229,
    1555, -3646,   123, -3646, -3646, -3646, -3646, -3646, 25103,    95,
   -3646,   231, -3646, 25103, -3646,   157,   157, -3646, 25103,    95,
    1843,  1602, 25103,  1602, 40326,    95,  -107,  -107,  2100,    81,
    1602, -3646, -3646,  3016, 42666,  3019, 25103, 25103, -3646, 36231,
   -3646,    81,  1143,  1602,  1843,  1843, 25103,    95, 24514,  2431,
   -3646,  -107,    95, -3646, -3646, -3646, -3646, 23336,    95,    95,
    1479, -3646, -3646, -3646,  1602, 40326, -3646, -3646,  5949, -3646,
   -3646, -3646, 18618, 42666,   311,   182, -3646,  2650,    52,  1104,
    2733,  1559,  2661,  2662, 40911,  1915,  1602, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
    -107,  1551,  2229,  2229,  1600, -3646,  2915,  3075,    81, -3646,
    1739, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
    2753, -3646,  3255,  2844,  2676, -3646, -3646,   249, -3646, -3646,
     885, 23336, 18029, -3646,  2907, -3646,  2514, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646,  2678,   600,  2923,  1235,
    2479,  2687, -3646, 11984,  1198, -3646,  1915, 11378,  1915,  1476,
   -3646,  2684,  2684, -3646, -3646,  2688,  2684,  3061, -3646,  3063,
    2690, -3646,  2693, -3646,  1204,  2694,  2696,  1426, -3646, 11378,
   11378,  1206,  1217,   -56,   790,   820,   389, -3646,  1258,  3154,
   -3646, -3646,  1267,  1274,  1278,  1329,   824,  1337,  1640, 11984,
    1339,   849,   391, -3646,  1349,   832,   843,  1376, 11378,  1447,
   11378,  1459, 11378,  1474,  1480,  1486, -3646,  2058,  2011, -3646,
   -3646,  2698, -3646, -3646, -3646, -3646, -3646,  2685,  1915,  2700,
   -3646, -3646, 11378, -3646,   228, -3646, -3646, 15620,   434,  2701,
   -3646,  1915, -3646, -3646,  2714,  1426, -3646, -3646, -3646, -3646,
   -3646,  2720, -3646, 42666,  1058,  2705, 29211, 33306, 33306, 33306,
    2718, 11378, -3646, -3646,  2971, 23336, -3646,  3106, -3646, -3646,
   -3646, -3646,  2723,  2724, -3646, -3646, -3646,  2526,  3067,  2952,
   -3646, -3646,  1551, 42666, 33306, -3646,  1854, 24514, -3646,  2725,
   -3646,  2725,  1171,  2727,  1645, -3646, -3646, -3646,  2721,  2088,
   17438,  3151,  2176, 33306, 33306, 33306, -3646,  2479,  2479,   691,
    2782,  3109, -3646, -3646, -3646, -3646, 41496, -3646, -3646, -3646,
   -3646,  1120, 42666,  3085, 42666,  8348, -3646, -3646,  3268, 11378,
   33306,  1079,    58,    81, -3646, -3646, -3646, -3646, -3646, -3646,
    2410, -3646, -3646, -3646, -3646, -3646,  2410, -3646,   -21,  1627,
    -184,  1161, -3646,  1992, -3646, -3646, -3646,  3103,   976,  2891,
    2891,  3110,  2995,   808,  2742, -3646,    81, -3646, -3646, -3646,
    1854, -3646, -3646, 11378, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,   916, -3646, -3646, -3646, -3646,  2741,  3115,  3116,   157,
   -3646, 25103, -3646, -3646, 25103, 25103,    77, 40326, -3646, -3646,
   -3646, -3646, -3646, -3646,  2758, -3646, -3646,  1551, -3646, -3646,
   32721,  -107, -3646, 25103,  2758, -3646, -3646,   390, -3646,  -107,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, 40326,  2759,
   -3646,   321, -3646, -3646,  1752, -3646, 40326, -3646, -3646, 40326,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,  2748,
    2543,  1386, -3646,  2762,  2763, -3646, -3646, -3646, -3646, 42666,
   -3646, -3646, 23336, -3646, -3646, -3646,  5684, 42666,  2985, -3646,
   11378, 11378,  3022, 42666,  3026, -3646,  3295, 42666,  3358, 40326,
   -3646,  2772, -3646,  2773, -3646,  1652, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646,  2783, 42666,  2229,  2076, -3646, -3646,  -107,
     885, -3646, -3646, -3646, -3646,  3031,  3032, 42666, -3646, -3646,
   -3646, -3646,  2916, -3646, 23336,  3334, -3646,  2934, -3646,  2796,
     174,  5095, -3646,  2800,  2801,  2805, 28041,  2479,  3134, -3646,
   -3646,  4044, -3646,  1915, 11378,   882, -3646, -3646,   239,   902,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  2797,  4044,  4044, -3646, -3646,  3342,  2940, 11378, 11378,
   -3646, 11378, -3646,   870,  2806,  2815, -3646, -3646, -3646, -3646,
   11378, -3646, -3646,  4044, -3646, 11378, -3646, -3646, 11378, -3646,
   11378, 11378, -3646,  1496, -3646,  1518, -3646,  1527, -3646, -3646,
   -3646,  2265, -3646, -3646,   920, 42666, -3646, -3646,  1659, -3646,
   -3646, 11378, -3646, 36816, -3646, -3646,  2994, -3646, -3646,  3202,
   -3646, -3646, -3646,   542,   542,   542, 14408,  1915,  3269, -3646,
   -3646, -3646,  3106,  3164, -3646,    47, -3646, 42666,  2816,  1137,
   -3646,  1661, -3646, -3646,  2818, -3646,  2058,  2819, -3646,    81,
   14408,  2625,  2934, -3646, -3646,  1171, 24514, 28626, -3646, -3646,
   33306,  2176,  2176,  2176,  2410,  3218,  2692,  2692, -3646, 26868,
   -3646, -3646,  2957, -3646, -3646, 29796, -3646,  1232, -3646, -3646,
   15620,  1612, -3646,  1915, -3646, 35646, -3646,  1915,    81,  2822,
    2825, -3646, -3646, 42081, 11378, -3646, -3646, -3646, -3646,  1542,
    2745, -3646,   600, -3646,   976, -3646,  3176,  3183,   976, -3646,
   -3646, -3646, 24514,  2479, 14408, -3646,   253,  2058,  1915,  2824,
     321, -3646,   505, 11378, 25103, -3646, -3646, -3646,  2830, -3646,
   -3646,  3315,  3316, -3646, 25103,  1338, 42666, -3646,  3268, -3646,
   -3646, -3646, -3646,  5684, -3646, 24514, -3646, -3646, -3646, -3646,
   -3646, 42666, -3646, 23336, -3646, 18618, -3646,  2835, -3646,  2684,
    2684,  2684, -3646, -3646, -3646, -3646, -3646,  2688,  3062, -3646,
    2688,  2688, -3646, -3646, -3646, -3646, -3646,   239,  2158, -3646,
   -3646,   239, -3646, -3646, -3646,   115,  1256,  2688, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646,  2684, -3646, -3646, -3646, -3646,
     239,  2684, -3646,  2684,  2516, -3646,   279,   137,  2684,  2684,
    2684,  2838,  2833, -3646,  1915,  4044,  3368, -3646, -3646,  2981,
    -107,  3312, -3646,  1683, -3646,  2848, -3646, 40911, -3646,  1602,
     877, -3646, -3646, -3646, -3646,  2982,   217, -3646,  3013,  2850,
    2853, -3646, -3646,  -107,  2855,  2856,  5031, -3646, -3646, -3646,
    3442, -3646, 42666, 42666, 42666,  2552, -3646, 31551, -3646,  1154,
    1915,  2858,  2860,  2862,  2863,  3437,   212, -3646,  3438, 35061,
   -3646, -3646, -3646,  1693, -3646,  2869,  2870, -3646,   145,  2874,
    1533,   857,  1718,  3166,  3238, -3646,  3089, -3646,  1558,  1168,
    1579,  1599,  1643,  1656, -3646, -3646, -3646,   168,  1161, -3646,
   -3646,  1726, -3646,  3222,  3132,  1732,  2906,  2906,  2906,  1612,
    1915,  1751, -3646, -3646, -3646, -3646,  3260, -3646, -3646,  2888,
    3056, 42666, -3646,  2952, -3646,  2265, 24514, 14408,  2900,  2887,
   -3646,   764, -3646, -3646,  2884,  2176, -3646,  3459,  3307, -3646,
   -3646, 36231,  2904, -3646, -3646,  3197, -3646,   259,  3112, -3646,
   -3646, -3646,  1079,  2993,  2996,    81,  1915, -3646, -3646,  2482,
    2414,  2951,   976,   976,  2520,  2955, 11378, 11378,  2917, -3646,
    2923, -3646, -3646,   301,  2265, 11378, -3646,  1551,  2952, -3646,
    1686,  2918,  2919, 42666,  2922,  2925, -3646,  3107,   311, -3646,
   -3646, -3646,  2516,    95, -3646, -3646,  2758,    93,  2914, -3646,
   42666,  3224, -3646, -3646, -3646,  -129, -3646,  2926,  -129,  -129,
   -3646,  2202, -3646,  2954,   239, -3646, -3646,  2958, -3646, -3646,
   -3646,  -129,  2930,   239, -3646, -3646,  -129, -3646, 36231,  -107,
    3189, -3646,  2963, -3646,  3414,  3294, -3646,  2516, -3646,  3297,
    3199, -3646,   239, -3646, -3646,  3508, -3646,   239,  3508,  -129,
    3200, -3646,  -129, 42666, -3646, -3646, -3646, -3646, -3646, -3646,
   42666, -3646,  1046, -3646, -3646, -3646,  1756,  -107, -3646, -3646,
   -3646,  2941,  2939, -3646, -3646, -3646,  1104, -3646, 42666,  5684,
   -3646, -3646, -3646,  2907, -3646,  1062,  1762,   321,  2943,  1781,
    1783, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   35061, -3646,  3508,  3204, -3646, -3646, 11378, -3646, -3646, -3646,
   11378, -3646, -3646,  3235,  3385, -3646, -3646, -3646, -3646, -3646,
   -3646,  1003,  1003, -3646, -3646, -3646, -3646, -3646,  3033,  3034,
   -3646, -3646,  3035, -3646, -3646,   140,  1981, -3646, -3646, -3646,
   -3646, 14408,  3310,  3043, -3646, -3646,  2959,  2991, -3646, -3646,
     168, -3646, -3646, -3646, -3646, 11378, -3646,  2923,  2100, -3646,
   26868, -3646, -3646, -3646, -3646, -3646,  2960,  2961,  8348,   920,
   -3646,  2997, -3646, -3646, -3646,  3005,  1915,  1915, 42666,  3134,
   -3646, -3646,   157,   157, -3646,   301,   168,   321, -3646,  1794,
   -3646, 42666, 42666,  1819, 42666, 42666,   -72,   -72,   -72,  2125,
    2125, -3646, -3646, -3646, -3646, -3646,  3330, -3646, -3646,  1825,
   -3646,   572,  3220, -3646, -3646, -3646, -3646,  -129, -3646,   145,
   -3646, -3646, -3646, -3646, -3646,   145, -3646, -3646, -3646, -3646,
    1546, -3646, -3646,  3228,  3007, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,  2964, -3646, -3646,  3082, -3646, 48516,
   -3646, -3646,  -124,  2992, -3646, -3646, -3646,  1381, 42666, 23336,
    3022,  3145, -3646,  3268, -3646,   764,   174,  2934, -3646,   105,
   42666, -3646,  3234,   129,   222, -3646, -3646,  2974,  2975,   321,
    1712, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,   318,
    3225,  1602,  1602,  1602,  1602,  1981, -3646, -3646,  3025, 23336,
   15620,  3083, 42666,  1126,  2594, -3646,  1464,   321, 11378,  2410,
   32721, -3646, -3646, -3646, -3646, -3646, -3646, 11378,  2980, 11378,
    2986,  1829, -3646, -3646,  3409,  3409, -3646, -3646, -3646, -3646,
    1833,  1857,   105,  1875,  1880, -3646, -3646,   311,  2988, -3646,
   42666, -3646, -3646, -3646,    71, -3646, -3646,  1909, -3646,  1911,
   -3646,  1546, -3646, 11378,  3444,  3017, 42666,   138, -3646, 49686,
   49686, 42666, -3646, -3646, -3646, -3646,  5049, -3646, -3646,   -28,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  3563, -3646,  2984, -3646, -3646,  2998,  1103, -3646, -3646,
   -3646,  5684,  3417,  1559, -3646, -3646, -3646, -3646, -3646,  3001,
    2088,  -107,    81, -3646,   105, -3646, -3646, -3646,   321,  3003,
    3232, -3646,   129, -3646, -3646, -3646,   222, -3646, -3646, -3646,
   11378, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   24514, -3646, -3646,  1551, -3646,  1925, -3646, -3646, -3646,  3080,
      81,  3477,  3479,    81,    81,    81,    81,  3009,  2594, -3646,
    3458, -3646, -3646, 11378, -3646, -3646,  1915,  3230, -3646,  3540,
    1161,  1915, 42666,  1915, 42666, -3646, 42666,   873, -3646, -3646,
    3210,   105, -3646,   129,   222, -3646,  2952, -3646,   504,   504,
     239,   145,   239, -3646,  1915, 11378, -3646, 11378,  3040, -3646,
   -3646,  3436, 42666, -3646, -3646, -3646, -3646, 11378, -3646, 48516,
   48516, -3646, -3646, -3646, -3646,  3590,   764,  3560,  3270,  3565,
    2945, -3646, -3646,  3295,  5684, -3646, -3646, -3646,  1602, -3646,
   -3646, -3646,  1524, -3646, -3646,   321,  3023, -3646,    81,  2100,
    3027, -3646, -3646, 42666,  3029, -3646,  -107,    81,    81,  2430,
    2430,  1551, 36231,  3127, -3646, -3646,    81,   321, 42666, -3646,
    1111,  3378, -3646,  1927,  1941, -3646,  3588, -3646,  3589,  3037,
    3038, -3646, -3646, -3646, -3646,  1973, -3646,  3631, -3646,   774,
    3298,  3301, -3646, -3646, -3646,  1915,  1915, -3646,    54, -3646,
   -3646,  3424,  3495, 11378,  1915, 45591,  3036, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   49101, 11378, -3646,   -28,  3563, -3646,  3299, -3646,  3300, -3646,
   -3646, -3646,  3529, 48516, -3646,  3522, -3646,   764, -3646, -3646,
   -3646, 24514, 14408, -3646, -3646,  3083, -3646,  3058, -3646, -3646,
     -53, -3646,  -107,  -107, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646,  1982, -3646, 36231, -3646, -3646,  3612,  3615,
    3517,  3617,  1111, -3646,  1051, -3646, -3646, -3646, -3646, -3646,
   40911, 40911, -3646, -3646, -3646, -3646,  3111,  3541,  3088, 11378,
   48516, -3646,  3523, -3646,  3456,  1881,  3402,  3064, -3646,  3065,
     981,  3555, 49686, 49686, -3646, -3646, -3646, -3646,  3533, -3646,
   -3646, -3646, -3646, -3646,  3240, -3646, -3646,  1989, -3646, 15014,
   -3646, -3646, -3646, -3646, -3646, 36231, -3646,  3127, -3646,  3073,
     145,   145,  3632,   145, -3646,  3637,  3639,  1051, -3646,  3084,
    2004,   504,   504, -3646,    98, -3646,  1915, 46176,  3634, 42666,
   -3646, -3646, -3646, -3646, 11378, -3646, 37401, 46761,  3081, -3646,
   -3646, -3646,  3249, -3646,  2945,  3480,  3540, -3646,  3058, -3646,
    3090, -3646,  2526,  2594, -3646, -3646,  3092, -3646, -3646,   145,
   -3646,   145,   145, -3646, -3646, -3646, -3646, -3646, 11378, -3646,
    3546,  3172, -3646,  3093, -3646, 48516,  1896, 48516, -3646, -3646,
    3501,  3095,  1318, -3646,  3096, -3646, -3646, 48516,  3660,  3378,
   -3646, 15014,  3114, -3646, 11378,  3118,  3108, -3646, -3646, -3646,
   -3646,  1915,  3657, 48516, 42666, 43836,  3302, 47346,  3538, 42666,
    5684,  3539,  3545, -3646, 48516, -3646,   145,  3513, -3646, -3646,
    1915, -3646, -3646,  3206, -3646, 44421, -3646,  2198, -3646,  3152,
   -3646, -3646,  3611,  2691, -3646, -3646, -3646,  3391,  3138, -3646,
   -3646, 48516, 48516, -3646, -3646, -3646, 30381, 11378, -3646, -3646,
   -3646, -3646, -3646,   895,   546, 19796,  3279, 45006, 47931, -3646,
   -3646, -3646, 27456, -3646, -3646, -3646,  3561, -3646,  1915, -3646,
   -3646, -3646, -3646, -3646, 36231,  2007, -3646, -3646, 24514, -3646,
   30381, -3646, -3646, -3646, -3646, 22745,  3137, -3646,    81, -3646,
   -3646, 24514, -3646, -3646, 14408, -3646, -3646
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3646, -3646, -3646, -3646, -3646,    27, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,  1585, -3646, -3646, -3646, -3646, -3646,
    1785, -3646,   576, -1686, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646,   577,  1419,  3136, -3646,   333, -3646,    21, -3646,
   -3646, -3646, -2719,   -96,  -271, -3646, -3646,   383,    17,  2823,
    -269, -3608, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,   345,   347, -3646, -3646,   165, -3646, -3646, -1205, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646,  -454,  -406,  1737,
   -3646, -3646, -3646,  3733, -3646,  3229, -3646,  1131,  2057, -3646,
   -3646, -3646,  -364,   188, -3646,   190, -3646,   191, -3646,   193,
   -3646,   195,   197,   198,   199, -3646,   203, -3646, -3646,  -407,
   -3646, -3646, -3646, -3646,   205, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646,  -286, -3646, -3646,  -127, -3646, -3646,  -275,   208,
   -3646,  -230,   210, -3646,   213, -3646,  -149, -3646,  -140, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  2828, -3646, -3646, -3646, -2130, -3646, -3646, -2221,  2415,
   -3646, -1573, -3646, -3646, -1677, -3646, -3646, -1667,  1220, -3646,
   -3646,   -82,  -283, -3646, -1337, -1784, -1729, -3646, -3646, -3646,
   -1870, -1855,  -741,  2162, -1127, -2101, -3646, -3646, -3646,   201,
   -3646, -3646, -2391,  1899,  2427, -3646,  2409, -3646, -3646,  1026,
   -3646, -3646,  1193,   552,  1190, -3646,   838,  2579, -1163, -3646,
   -3646, -3646, -3646, -3646, -3646,   -55,   185,  -148, -3646, -3165,
     561, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3645,
   -3646, -3646, -3646,  -304, -3646, -3646,  -219, -3646, -3646,  -263,
   -3646,    43, -2172, -3646, -3646, -3646, -3646,  2388, -1231, -3646,
    3356, -3646,  -518,   650,  1937, -2282, -1318, -3646,  -865,  -863,
   -2330, -3646, -3646, -3646, -3119,   990,  1370, -3646,   748,  1934,
   -1761, -3646,  1442, -3646, -3646,   772, -3646, -1865, -3646, -3646,
   -3646,   731, -3646,   732, -3646, -3646, -3646,  -809,   701, -1516,
   -3646,   296, -2234, -2370, -3646,   522, -3646,   474, -3535, -3646,
    -547, -1962, -2250,   -14, -3646, -3646,   488, -2919,   833, -3646,
   -3646, -3646, -2979, -2426, -3646,    49, -3646, -3646, -3646, -3646,
   -3546, -3646, -3646, -1392, -2132, -3646, -3646,  3860,  3861,  -982,
   -2495, -3357,    50,    51, -3646, -3646, -3646,  2411,  -821,   120,
     112,   118,  1890, -2115,   262, -2208, -3646,   310, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,  1969, -1438, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -2255,   801, -3646, -3646,  1483, -3646, -3646,
   -3646, -1742,  -465, -2032, -3112, -3646, -3646, -3646, -3646, -3646,
   -3646,  1418, -3646, -3646,  2092,  2535, -3646, -3646, -3646, -3646,
   -3646, -3646,   549,  1672, -3646, -3646, -3646, -3646, -3646, -3646,
     813,  2450, -3646, -3646, -3646,     2, -3646, -3646, -3646, -3646,
    2184, -3646, -3646, -3646, -3646,  2484, -3646, -3646, -3646, -3646,
   -3646, -3646,  1289, -3646,  1708, -3646, -1358, -3646, -3646,   921,
    -927,  1658,  -561,  1792,   306, -3646,  3338, -3646, -3646, -3646,
   -1547, -2291, -3646,  3049,  -855, -2224,  2179,  -618, -1721,   947,
    -647,  3616, -3646, -1083, -1060, -3646, -3646,  -611, -3646, -3646,
   -3646,  -610, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646,  1316, -3646, -3646, -3646, -3646, -1619, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646,  1682, -3646,  1885, -3646,
    -458, -3646,  2852, -3646, -3646, -3646, -2158, -1826,  1618,   867,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -2209,
   -3646, -3646, -3646, -3646, -3646,  1812, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -1576, -3646, -1790,   245, -3646,   387, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646,   -86,   746,   -85, -2004,
   -1038,  1520, -3646, -3646, -1193,  2890, -1929, -3646, -3646, -3646,
    1789, -3646, -3646, -3646, -3646, -3646,   836, -2428,  2571, -3646,
   -3646, -2887,  -850, -2129,  -831, -3646, -2136,   399, -1693, -1680,
    -670,    48, -1260, -3646, -3646, -3646, -3646, -3646,  -237, -3646,
   -3646, -3646,   426,  1685, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,  -505,  -689, -3646,  1940,  1784, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,  2707,  2686,
    1760, -3646, -3646, -2425, -3646, -3646,  1713, -3646,   673, -2223,
   -1662,   949, -3646, -3646,   951, -3001, -3646, -3646, -3646, -3646,
   -3646, -3646,   886, -3646,   -19,  3394, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646,  2478, -1001,  3321, -3646, -3646, -3646, -3646,
   -3646, -3646,  2170, -3646, -3646, -3646, -3646, -3646, -3646,  2646,
    3411,  -544, -1223, -3646,  -712,  2622,  2175,  -819, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646,  2291,   863, -3646, -3646, -3646,  2703, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646, -3646, -3646,   983,  -123, -3646,   -33,  -165, -3646,
     -92, -3646, -3646, -3646, -3646, -3646,  -258, -3646, -3646,  -262,
    -645,  -923, -1271,   598, -1674, -1907,   982,  2695, -2194,  -640,
   -1096, -1100, -1846,    61, -3646, -3646,  2948,    75,   519,  -377,
      -6, -2233,  -112,  -555, -3646, -1656, -3646, -3646, -3646, -3646,
    2251, -3646, -3646, -3646, -3646,  1308, -3646, -3646, -3646,   950,
   -3646,   694,   482, -3646, -3646,   134, -3646,  2299, -3646, -3646,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646,  2728,  3460,  3158, -3646,  2827, -3646, -3646, -3646,
   -3646, -3646,   374, -3646,   388, -3646, -1969,  2557,   457, -3646,
    1411,  -333,  -604, -3646, -3646,   373, -3646, -3646,   913,  3485,
    3180, -3646, -3646, -3646, -3646, -3646, -2583,  -838, -3646, -3164,
   -2639, -1587, -3646, -3646, -2009, -2804, -3646, -3646,  -984, -3646,
   -3646, -3646, -3646, -1921, -3646, -3646, -3646,    34,  3536,  3556,
   -3646, -3646,   535, -3646,   472, -3646, -3646, -3646, -3646, -3646,
   -3646, -3646,  3420, -3646, -3646, -3646, -3646,  3423, -3646, -3646,
   -3646, -3646, -3646,  3425, -3646, -3646, -3646, -3646, -3646,  1847,
   -3646, -3646, -3646, -3646, -3646, -3646, -3646, -3646
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2441
static const yytype_int16 yytable[] =
{
     466,   983,   899,   997,  1005,   903,  1379,  1042,  1044,   592,
     929,  1381,  1288,   508,  1050,  1593,   514,  2113,  2257,  1592,
    1480,  1938,   509,   464,  1545,   528,  1568,  2206,  1178,  1026,
     942,   526,   540,  1470,  1471,   543,   752,   533,  1068,   540,
    2675,  2679,  2681,  1772,  1081,  1316,  1698,   561,  1344,  2778,
    2446,  1658,  2240,  1935,  1614,  1310,  2612,  1841,  2643,  2728,
    2522,  1622,  3051,  3321,  1099,  2525,  3008,  1316,  1101,  1510,
    2888,  1105,  2498,  1386,  2416,  1387,  1112,  1113,  1114,   133,
    1345,  2345,  1706,   512,  1912,  1624,  1625,   581,  2712,  1628,
    1629,  1630,  1631,  2880,  1633,  1634,  1636,  1638,  1639,  1640,
    1641,  1642,  1779,   972,   975,  2573,  2350,  2239,  1013,   584,
    2286,   466,  2466,  3167,   466,   591,   597,  3504,  1973,  2774,
    1789,  1120,  1121,  1122,  2664,  2599,  2358,  2467,  1792,  1793,
    2362,  1162,  2703,  1163,   586,  1227,  2346,   588,  2693,  2694,
    2713,  2377,  2898,   473,  1259,  2752,  2903,  1854,  3360,  3365,
    3248,  2386,  3366,  1819,   580,  2333,  3638,  1983,  2308,  2309,
     610,   601,   525,  3539,  1129,  1130,  1129,  1130,   532,  3341,
    3394,  3374,  2322,  1321,  3367,  2320,  1227,  3393,  3751,  2500,
     918,  1108,  2154,  3326,   868,   869,  1701,  2569,  1346,  1712,
    2252,   521,  2338,  2339,  3828,  2017,  4020,  2604,  2463,  1129,
    1130,  2691,  3751,  1219,  2882,  2394,  3861,  2220,  2360,  2361,
    1438,  2363,  2742,  3081,  2366,  2367,  1181,  3003,  2370,  1129,
    1130,  1129,  1130,  2379,  2755,  1362,  3553,  2382,  2383,  2384,
    2385,  1299,  3448,  2149,  2389,  2302,  2391,  2738,  2739,  2857,
    4020,  3849,  2400,  2746,  4050,  2404,  1326,  2406,   823,  2117,
    2427,   806,  3960,  2464,   688,  2437,   518,  3078,  2220,  3215,
    3197,  2443,  2444, -1839,   602, -1404,  2448,  1843,  1236,  1228,
     868,   869,  3216,  1253,  2652,  1369,  3502,  1341,  1442,  2418,
    1222,  2902,  2274,  3921,  2341,  1383,  3217,  2401, -2324,  1129,
    1130,  2249,  2746,  1390,  2455,  3751,  1164,   868,   869,  3215,
    2916,   835,  2708,   522,  2450,  2451,  2452,  2453,  1129,  1130,
    1228,  2020,  3216,  2709,  -823,  1129,  1130,  2118,  1854,  2819,
    3840,  1243,  -430,   570,  1244,  3822,  3217,  2470,  1979,  3966,
   -1696,   986,  4048,  3512,  3563,  4052,  2250,   868,   869,  2395,
    3096,   132,  1837,  2951,  3752,  2996,   919,  1109,  1233,  1383,
    2249,  2850,  2851,  2697,   128,  1129,  1130,  1129,  1130,  1129,
    1130,  1129,  1130,  1129,  1130,  3049, -1594,   615,  3752,  1356,
    1463,   553,  2862,  1383,  1936,  1460,  1461,  1462,  -525,  2475,
    3478,  3655,  1317,  2487,   831,  3572,  1443,  3197,  2828,   551,
    1444,  1993,  3850,   552,  3576,  1534,  1464,  1937,  1535,   617,
    2476,  1445,  -526,   809,  1129,  1130,  1129,  1130,   836, -1594,
    2747,   132,  1509,  3589,  1994,  2002,  1855,  3677,  3591,  3050,
     769,  1314,   541,  2658,  3564,  1068,  1129,  1130, -1404,  3067,
    1318, -1364,  1248,  2829,  1654,   129,  2221,   554,  3418,  1439,
    2154,  1812,  1357,   134, -1674,  3097,   712,  3419,  2264,  1129,
    1130,  3747,  1363,  4140,  1129,  1130,  2080,  1407,  2402,  1237,
    3044,  3752,  1245,  3565,  3912,  1815, -1364,  1370,  3198,  2657,
    3841,  1048,  2863,   591,  2471,   597,  1129,  1130,   571,  3530,
     837,  1129,  1130,  1175,  2820, -1696,  3960,  2221,  1129,  1130,
    3647,  2376,   765,  3064,  1129,  1130,   597,  2265,  2710,  3055,
    1774,   824,  1841,  1777,  1131,   804,  2711,  1132,  1781,   591,
    2119,   814,  2756,  1837,  3531,  1349,  2760,  1129,  1130,  1386,
    3088,  1387,  1446,   808,   827,  4116,  4117,  1658,  2344,  1619,
    2776,  2777,  3082,   832,  1794,  1795,  2488,  2150,  1627,  1131,
    2787,  2275,  1132,  3077,  1259,  1817,  3079,  3080,  1166,  4046,
    3621,  3851,   915,  3479,  3916,  1648, -1404,  1300,  2345,  1131,
    2155,  1131,  1132,  1342,  1132,  3090,  2416,  2282,   519,  1259,
     932,  2890,  2133,  1129,  1130,  3825,  1494,  1495,  3420,   591,
    3282,   946,  3332,  2136,   807,  1165,  2139,  1855,  2822,  1386,
    2466,  1387,   581,   466,  1912,  3198,  1322,  1533,   581,  3201,
     970,  2222,   581,   581,  1220,  2467,  1547,   984,   946,  3474,
    2721,  3071,   591,  2346,  2748,  1447,   957,  3076,  1560,  1561,
    1562,  2692,  1014,  1015,  1016,  4182,  3829,  1567,  1021,  1131,
    2018,  3927,  1132,  1655,  1973,  3183,  2416,  1791,  2973,  2974,
    2975,   773,  2130,  1993,  2419,  2462,  1440,  2952,  1131,  1440,
    3678,  1132,  2222,  1842,  2736,  1131,  1177,  1011,  1132,   956,
     819,  3915,  1678,   920,  1110,   967,  1994,   830,  2759,  1327,
    2761,  2887,  1069,   848,   523,  4073,  2463,  2772,  1661,  1129,
    1130,  1129,  1130,  3368,  3011,  3012,  3013,  1129,  1130,  1713,
    2784,  1984,  3955,   916,  3746,  1131,  2793,  1131,  1132,  1131,
    1132,  1131,  1132,  1131,  1132,  3195,  1132,  2771,  2665,  3760,
    2027,  2807,  1843,  2702,  1978,  3666,  2396,   993,  1702,  2779,
   -2324,  1129,  1130,  1129,  1130, -1404,  1728,  2741,  3014,  3015,
    1126,  2464,  1128,  2847,  1819,  2266,  1440,  1700,  1133,  2895,
    1133,  3354,  3771, -1404,  1131,  3091,  1131,  1132, -2324,  1132,
    1223,  1961,  1719,  2028,  3182,  3691,  1171,   466,  1173,  3449,
     946,   466,   591,  1313,   466,   591,  1131,  2740,  1778,  1132,
    3805,  2849,  3275,  1133,  -823,  3373,  3277,  2852,  2489,  1801,
    1172,  2749,  -430,  3376,  1176,  1755,  3218,  1180,   896,  1131,
    3399,  2116,  1132,  1133,  1131,  1133,  2855,  1132,  1129,  1130,
    3513,  4220,  1232,  4041,  2864,  1129,  1130,  1599,  1600,  1599,
    2046,  1536,   581, -1364,  1537,  3302,  1131,  3482,  2155,  1132,
    -196,  1131,   591,   581,  1132,  1440,  3218,   581,  1131,  3016,
    2643,  1132,  1350,  2617,  1131,  1129,  1130,  1132,  -525,  1129,
    1130,  1821,  3917,  3324,  1979,  3311,  3346,  1129,  1130,  3315,
    3391,  3922,  2149,  3924,   976,  2469,   469,  1131,  1129,  1130,
    1132,  3532,  -526,  1133,  1129,  1130,  3331,   618,  1656,   591,
    2963,  3870,  1129,  1130,  3327,  3352,  3353, -2255,  2081,  1239,
    2680,  2895,  1133,  2902,  1655,  3286,  2902,  2902,   771,  1133,
    1256,  3744,  3529,  4014,  1129,  1130,  3310,  1250,  2340,  1682,
    3314,  2480,  1353,  2902,  2008,  2988,  1129,  1130,   581,  1205,
    2052, -2256,  3233,  1131,   828,   517,  1132,  3375,  1729,  3056,
    3057,   530,  3392,  3395,  3397,  3398,  1129,  1130,  1382,  1133,
    1643,  1133,  3918,  1133,  1802,  1133,  2278,  1133,  1803,  3692,
    1854,  1129,  1130,  2085,  2086,  1989,  2026,  2102,  2103,  2581,
    2582,  2009,  2993,   542,  1351,  1316,   581,  2345,  3206,  3919,
    2276,  3154,   474,  2753,  2753,  3255,  2307,  2808,   547,  3590,
    2281,  4043,  3592,  2284,  2285,  1837,  2240,  1352,  1133,  1844,
    1133,  1354, -2255,  4221,  1841,  1316,  2466, -1674,  3970,  1129,
    1130,  2539,  2920,  2921,  2937,  2938,  1129,  1130,  3211,  2123,
    1133,  2467,  2868,  1772,  1772,  2344,  2502,   581,  1129,  1130,
    3996,  1476,  2346,  3048,  2021,  1609, -2256, -2388,  3211,  1131,
     625,  1131,  1132,  1133,  1132,   555,  3626,  1131,  1133,  2935,
    1132,  2239,  2140,  1129,  1130,  2138,  3693,  2960,  2961,  1164,
    3307,  3285,  3616,  2033,   603,  2580,  1069,  1801,  2631,  2350,
    1133,  3017,  1647,  1129,  1130,  1133,  1837,  1129,  1130,  1069,
    2698,  1131,  1133,  1131,  1132,  2034,  1132,  3906,  1133,  2377,
    2044,  3441,  2463,  2096,  1467,  1129,  1130,  2045,  1474,  3659,
    1845,   606,  3518,  2048,  2199,  1483,  2241,  3087,  3439,  3440,
    1912,  1133,   994,   999,  1007,  1655,  2585,  2586,  1842,  1683,
    1386,   114,  1387,  3522,  3523,  2153,  2060,  3328,  2718,  1594,
    3907,  1129,  1130,  2869,  2113,  4015,  4085,  1973,  1730,  1656,
   -2388,   591,  1146,  2462,  1129,  1130,  2830,  2464,  2131,  1644,
    1593,  3537,   688,  2295,  3320,  1837,  1711,   977,  1131,  2627,
    1483,  1132,   556,  2579,  1709,  1131,  1459,  1133,  1132,  3212,
   -1697,  1645,  1762,  2589,  3857,  3060,  2150,  2157,   591,  1012,
    2216,  2217,  2068,  1651,  3858,  1129,  1130,  3866,   581,  3212,
     558,  3902,  2124,  1129,  1130,  1131,  1655,   581,  1132,  1131,
    1129,  1130,  1132,  2660,  1129,  1130,  1710,  1131,  1129,  1130,
    1132,   958,  1129,  1130,  1843,  3234,  1129,  1130,  1131,  1593,
    2267,  1132,  1802,  2716,  1131,  1484,  1803,  1132,  1763,  1855,
     116,   591,  1131,  1129,  1130,  1132,  1615,  1926,  3543,  1129,
    1130,  1129,  1130,  1687,  3213,  1690,  1684,   581,  3342,  3908,
    1978,  2193,  1129,  1130,  1131,  1653,   581,  1132,  2416,  1846,
     995,  2468,   591,  4245,  3223,  1684,  1131,  1833,  1847,  1132,
     896,   581,   581,  1133,  1848,  1133,  3998,  3452,  2982,  2416,
    1499,  1133,  3629,  3618,  2831,  2661,  1131,  3999,  2072,  1132,
    2073,   935,  1167,  1129,  1130,   591,  2074,  1314,  1732,  1823,
   -2440,  1131,  1129,  1130,  1132,  2870,  1740,   573,  1593,  1129,
    1130,  2558,  2791,  1129,  1130,  1133,  1483,  1133,   466,   466,
     466,   581,   466,   581,  1149, -1697,  1646, -2255,  1773,  1694,
    2075,  3657,  2079,  1286,  1775,   466,  2780,   591,  1897,  3083,
     466,  1756,  1757,  1758,   712,  1760,  1927,  1979,  1165,  1131,
    1656,   896,  1132,  2469,   574,  3269,  1131, -2255,  1776,  1132,
     581, -2256,    42,  1780,  1129,  1130,  1849,   576,  1131,  1048,
    3094,  1132,  1129,  1130,  1129,  1130,  3788,  2753,  3100,  2194,
    1265,  3102,  3859,  1900,  1129,  1130,  2125,  1602,  1759,  3061,
    1761, -2256,  1133,  1131,  1752,  3789,  1132,  3270,  1764,  1133,
    1815,  2871,  2126,   981,   982,   591,  2781,  2098,  1834,  1616,
    2731,  1129,  1130,  1131,  2918,  1442,  1132,  1131,  4161,   581,
    1132,  3175,  1931,   581,  2344,  2109,  1483,  1790,  1049,  1133,
    3808,  1656,   631,  1133, -2388,  1131,  1552,  4162,  1132,  2376,
     688,  1133,  3214,  1801,  2919,  3039,  3680,  3681,  2930,  3683,
    3684,   978,  1133,  1406,   581,  1850,  2940,   949,  1133,  2347,
     582,  2321,  3214,  1129,  1130,  3749,  1133,  2941,   619,   585,
    3040,  1131,  2936,   591,  1132,   466,   466,  2347,  1991,   466,
     587,  3460,  1129,  1130,  1131,  4000,  1928,  1132,  1133,   632,
    1933,  1021,  1853,  2007,  1129,  1130,  3844,  3845,  1987,  1988,
    1133,  2782,  2025,  1466,   936,   810,  2847,   950,  3625,  1129,
    1130,  1129,  1130,  3601,  2097,  1129,  1130,    55,  2889,  2732,
    1133,  1129,  1130,  1443,  2959,  1131,   979,  1444,  1132,  2226,
     937,  1129,  1130,  1131,  2032,  1133,  1132, -2388,  1445,  2462,
    1131,  2584,  1603,  1132,  1131,   598,  1556,  1132,  1131,  2035,
    3807,  1132,  1131,  1129,  1130,  1132,  1131,  1593,  4065,  1132,
    1483,  2999,  1129,  1130,  1069,  2053,  2195,  2373,  1129,  1130,
     599,  2158,  2408,  1131,  1733,  2800,  1132,  2801,   116,  1131,
    2110,  1131,  1132,  1133,  1132,  2373,   811,   951,  4066,  1167,
    1133,  2527,  1131,  1129,  1130,  1132,  3875,  2036,  1802,  1854,
    1842,  2507,  1133,  1617,  2533,  1936,  1158,  1159,  1160,  1161,
    1050,  1101,  1105,   633,  1129,  1130,  2043,  3041,  2802,  1618,
    2689,   606,  3418,  1936,  2122,   562,   607,  1133,  1937,  3897,
    2560,  3419,   712,  1131,  1129,  1130,  1132,  2548,  2226,  2803,
    1167,  2056,  1131,  2617,  1167,  1132,  1937,  1133,  4001,  1131,
    3297,  1133,  1132,  1131,   812,   610,  1132,  1048,  2969,  1446,
    1463,  2057,  3685,  3686,   612,  2061,  2146,  3538,  3602,  1133,
     563,  3298,   614,  2804,   591,  3972,   581,   591,  1129,  1130,
    1579,  2113,  1459,  3552,  3617,  4058,  1465,  2200,   581,   626,
    2163,  1129,  1130,  1966,  1734,  1679,  2169,  2169,  1680,  2169,
    1742,  1681,  3299,  2144,  1131,  1133,  2595,  1132,  2834,   581,
    2758,  2145,  1131,   581,  1131,  1132,  1100,  1132,  1133,  2065,
     688,  1129,  1130,  2835,  1131,   470,  3552,  1132,   471,   591,
     591,   581,   581,  1978,  2785,  2786,   994,   482,  2327,  2468,
    1069,   564,  2144,  2169,  2169,  2169,  2201,  1129,  1130,  2469,
    3025,  1131,  1447,   246,  1132,   248,  2228,  2229,  2374,  1133,
    2262,   761,  3420,  2168,  2168,   805,  2168,  1133,  1743,  2273,
    2047,  2375,  2202,  2066,  1133,   628,  2191,  3442,  1133,   766,
    1239,  2067,  1133,  1854,  2047,   629,  1133,   952,  2071,  2375,
    1133,  3466,  2076,  3002,  1837,   537,  2084,  2328,  1256,  2219,
    2089,   630,   537,  1131,  2104,   581,  1132,  1133,  2215,   816,
    2168,  2168,  2168,  1133,  3478,  1133, -1594,  2290,   820,  4090,
    4090,  2892,  1131,  2329,   581,  1132,  1133,  2908,  3903,  2914,
    3904,  1288,  1966,   470,  1131,   958,   471,  1132,  2203,  1837,
    2915,  2770,  1129,  1130,  3369,  2269,  1966,  3370,   953,  1131,
     954,  1131,  1132,   822,  1132,  1131,   832,  1744,  1132, -1594,
    3045,  1131,  3570,  3571,  1132,  2501,  3046,  1133,  1855,   840,
    2226,  1131,  2283,  3209,  1132,  3574,  1133,  3308,  2227,  1316,
    3577,  2922,   531,  1133,   995,  1316,   851,  1133,  2456,  2330,
    2926,  2301,  2472,  1131,  3225,  3226,  1132,  2927,   842,  3047,
     911,  2928,  1131,  3593,  2805,  1132,  3595,   931,  1131, -1674,
     808,  1132,   712,  2204,  1655,  3239,  1129,  1130,   930,  2311,
    2403,  1420,  1421, -1674, -2440,  2458,  1593,   939,  2318,  2319,
    2523,  1129,  1130,  1131,  2417,  2523,  1132,  1048,  1133,  2323,
    2324,  2325,  2326,   948,  2334,  2335,  1133,   958,  1133,   968,
    1129,  1130,  2929,  1967,  1131,   988,  1772,  1132,  1133,  1655,
    2931,  1745,  2934,  3734,  2331,   987,   868,   869,  3775,  3776,
    3777,  3778,  2939,   992,  1131,   565,  1820,  1132,  1837,  2430,
    2022,   114,  1593,   981,   982,  1133,  2716,  3479,  2228,  2229,
     909,   910,  1837,   913,   591,  2140,  1104,   566,   591,  2942,
    2473,  1146,  1023,   466,  2128,  1024,   852,  1025,  1515,  2562,
     581,   581,   581,  2496,  1027,  1593,  2499,  2894,  1131,  2791,
    1028,  1132,  2023,  1166,  1968,  2230,  2478,  1029,  2577,   567,
    2241,  1131,  2024,  1166,  1132,  4242,   591,  1133,  2431,  2428,
    2429,   591,  2436,   851,  2438,  2439,  2440,  2441,  2442,  2511,
    1166,  2445,  1855,  2447,  1129,  1130,  1133,  1433,  1434,  1032,
    2598,  1131,  4156,  1033,  1132,  3801,  3802,  1034,  1133,   896,
    2944,  2040,  1166,  3734,  3734,  2512,   853,  2492,  2493,  2494,
    1169,  3880,  2946,  1133,   568,  1133,  3480,  1131,  3803,  1133,
    1132,  2171,  1967,  2172,  1035,  1133,  1174,  2948,  1655,  2995,
    2049,  1166,  1519,  2949,  1036,  1133,  1967,  2291,   920,  2950,
    3868,  2205,  1655,  1209,   896,  2050,  1550,  3334,  3335,  3244,
    1854,  1146,  2513,  3881,  1037,  2514,  1038,  1133,  2062,  1166,
    2432,  2587,  1303,  2515,   591,  2468,  1133,  2244,  2245,  2246,
    1170,  3245,  1133,  1039,  2958,  3038,   896,  3404,  3886,  1656,
    3246,  3889,  3890,  3891,  3892,  1185,  3459,  2063,  1166,  2596,
    3674,  3675,  2332,   852,  1227,  1969,   591,  1133,  1040,  1966,
    1208,  1145,  2523,  1206,  2683,  2688,  1043,  1968,   868,   869,
     591,  3465,  1131,  1149,  1226,  1132,  1214,  1210,  1133,  1304,
    1399,  1400,  1211,  3640,  1656,  3968,  1593,  1216,  3215,  1520,
    2999,  1217,  3467,  1523,  1045,  2433,  2064,  1166,  1133,  1046,
    1524,  3216,  2625,  3734,  3734,  1305,  2727,  2523,  2069,  1166,
    1047,   114,  3468,  1051,  2889,  3217,  2336,  2337,  1457,  2566,
    1166,  3990,  2292,   853,  1052,  1212,   868,  3361,  3481,  2602,
    2603, -1404,  1053,  2113,  2648,  3982,  3983,  1054,  1146,  2293,
    1213,  3482,  1133,   896,  3995,  1055,  1131,   591,  1056,  1132,
    2294,   661,  2458,  2932,  1166,  1133,  3469,   896,  3005,  3006,
    2669,  1131,  2671,  1146,  1132,  3178,  3179,  1057,   591,  3470,
     591,   591,  3250,  1166,  3272,  3273,  1525,  2598,  1773,  1773,
    1131,  3641,  3642,  1132, -1404,  1133,  3643,  3644,  1228,  3734,
     763,   764,  1058,  1149,   767,   768,  3409,  3410,   770,  3540,
     772,  1059,   115,  1594,  3734,  1837,  3445,  3453,  1969,  1060,
     666,  1133,   591,   591, -1404,  3457, -1404,  3734,  3355,  1063,
     116,  3358,  3359,  1656,  1225,  3772,  -605,  2295,  3483,  1527,
   -1404,  3461,  1166,  2516,  1064, -1404,  2347,  1656,  3371,  3475,
    1166,  2668,   854,   855,   856,   857,   858,   859,  2348, -1404,
    4192,  4193,  2417,  2856,  1070,  2200, -1404,  2417,  1824,   860,
    1147,  2745,  2417, -1404,  3490,  3491,  2417,  2454,  2766,  3604,
    2337,  2757,  1825, -1404,  3734,  3619,  3620,  2767,  2766,  1855,
    2417,  2417,  1148,   591, -1404,   117,  3734,  3734,  1071, -1404,
    2417,  1072,  1594,  2434,  3623,  3620,  3624,  3620, -1404,  2788,
    1073,   581,   677,  1074,  2796,  1306,  1133,  3679,  3273,  2766,
    2798,  2799,  4081,   118,  2201,  1075,  2417,  2818,  1076,  1967,
    1149,   924,   925,  1077,   926,  1655,   927,  1078,  2844,  1080,
    1026,  3734,  3682,  3620,  1082,  2296,  1151,  1152,  3689,  3690,
    2202,  3734,  3815,  3816,  -605,  1149,  3820,  3620,  2733,   477,
    1083,  2768,  2769,  1156,  1157,  1158,  1159,  1160,  1161,  4189,
    1528, -1404,  1084,   119,  1085,   981,   982,  1328,  2797,  2517,
    3821,  3620,  1086,  3232,  1087,  1530,  2795,   693,  1088,  3734,
    1133,  3734,  1936, -1404,  1089,   581,  2417,   118,  3823,  3620,
    1090,  3734, -1404,  3824,  3620,  1133,  1329,  2297,  1091,   854,
     855,  1092,   857,  1093,   859,  1937,  2203,  3734,  1234,  3734,
    1094,  3734,  1095,  3251,  1133,  1096,   860,  1097,  3734,  2291,
    1098, -1404,  3830,  3831,  3832,  3831,  1102,  1826,  1103,  3734,
    1106,  2518,  1307,  1107,  4246,  2848,  1111,  1150,  3882,  3883,
    4006,  3816,  1115,  1330,  1116,  3734,  3734,  1117,  1331,  1870,
    1871,  3377,  2873,  1308,  4007,  3816,  2200,  2327,  1118,  2519,
    2792,  3734,  3734,  1151,  1152,  1119,  3734,  1184,  1168, -1404,
    1235,  1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,  3425,
     896,  2204,  -731,  -731,  1873,   120,  4012,  3273,  1151,  1152,
    1146, -1404,  -731,  1309,  3378,  4056,  4057,  1876,  1827,  3379,
    2627,  1153,  4097,  4098,  1251,  1877,  1262,  2163,  1264,  3053,
    1232,   591,   591,   591,  -605,  2201,  2328,  4115,  3177,   581,
    4234,  4235,  2291,  1828,  2347,  2291,  3633,  3634,  1281,  1879,
    1282, -1404,  1583,  1584,  1283,  2349,  2348,  2625,   591,  3988,
    3988,  1594,  2329,  1383,  2292,  3380,  1880,  1286,  -605,  3289,
    3290,  3257,  3258,   121,  1069,  3950,  3698,   591,   591,   591,
    1656,  2293,  3698,  3488,  3489,  1289,  1297,  1298,  2523,  1146,
    3024,  1302,  2294,  1314,  1885,   720,  3026,  3790,  3028,  3450,
    1323,  1829,  1324,  1325,   591, -1404,  2981,  1332,  1343,  1340,
    1593,  1347,  1348,  1361,  3878,  1364, -1404, -1404,  1154,  1155,
    1156,  1157,  1158,  1159,  1160,  1161,  1365,  3984,  2330,  3791,
     122,  1187,  -912,  1377, -1404,  3218, -1404,  1372,  1367,  1487,
    1488,  1489,  1383,  1154,  1155,  1156,  1157,  1158,  1159,  1160,
    1161,  1500,  -605,  1389,  1391,  3362,  3152,   477,   480, -1404,
   -1404,  1888,  1393, -1404, -1404,  1396,  1397,  2292,  1889,  2295,
    2292,  3023,  1401,  1404, -1674,  2417,  1405,  1333,  2417,  2417,
    1409,  2766,  1553,  1890,  2293,  1557,  -748,  2293,  1408,  1830,
    1936,  3520,  1149,  1227,   591,  2294,  1410,  2417,  2294,  2205,
    1451,  1452,  3985,  2331,  1453,  1575,  1576,  1456,  1458,  1580,
    1459,  1477,  2766,  1937,  1479,  1164,  1483,  1490,  1502,  1504,
    2766,  1539,  1110,  2766,  1188,  1549,  1550,  1551,  1595,  1596,
    1591,   495,  3763,  3767,  1601,  -605,  1891,  2327,  1626,  1334,
    1610,  3792,  1632,  3106,  1652,  4077,   581,  1659,  1189,  1660,
    1663,  3162,  1190,  1666,  1892,  1667,  1668,   466,  1669,  1670,
    1671,  3172,  1673,  2766,  1672,  1675,  1676,  1696,  1707,  1699,
   -1404,  1149,  2295,  1715,  1716,  2295,  3089,  2296,  3181,  1146,
    3168,   981,   982,  1717,  3092,  1191,  1718,  3381,   496,  1722,
    1725,  3192,  1726,  3382,  1266,  1727,  2328,  3524,   581,  1736,
    1741,  1593,  1192,  1267,  1750,  3878,  3650,  1896,  1754,  1782,
    3205,  1783,  1268,  3107,   497,  1898,  3793,  1136,  1137,  1784,
    1787,  1785,  2329, -1404,  1269,  1270,  1271,  1228,  1796,  3383,
    1798,  1050,  1101,  1105,  3794,  1151,  1152,  3294,  3923,  2297,
    1272,  1800,  1288,  1813,  1923,  1822,   498,  1335,  1440,  1940,
    4155,  1138,  4157,  2727,  1941, -1404,  -605,  3795,  1942,  1943,
    1944,  1139,  1193,  3700,  3184,  3194,  1945,  1946,  1960, -1404,
    1947,  3763,  1948,  1949, -1404,  3767,  2070,  1950,  4175,  3249,
    2296,  1336,  1904,  2296,  1194,  1951,  1952,  2669,  2330,  1953,
    1954,  3660,   499,  1955,  1956, -1404,  1957,  3384,  1140,  1958,
    3986,  2332, -1404,  1959,  1962,  1980,  1981,  1986,  1996,  1141,
    1997,  2625, -1404,   476,  1151,  1152,  4207,  4208,  1998,  4102,
    1999,  2005,  2011, -1404,  2031,  2013,  2014,  2015, -1404,  2041,
    2648,  3284,  3763,  3767,   591,  2030,  1142, -1404,  1905,  2037,
    2038,  2039,  2297,   591,  2051,  2297,   480,  2047,  1824,  2596,
    2114,  2121,  2055,  2059,  1906,  2077,  2078,  1907,  2083,   591,
    2087,  1149,  1825,  2331,  1161,  1146,  2088,  2262,  2668,  2099,
    2100,  3736,  1156,  1157,  1158,  1159,  1160,  1161,  2159,  2101,
   -1116,  2127,  1195,  2137,  3833, -1233,  1594,  2184,  2166,  2192,
    2198,  1196,  2173,  1909,  1143,   477,  3385,  2212,  2417,  2242,
   -1404,  2243,  3959,  2209,  2258,  2270,  1197,  2272,  2417,   -63,
    2766,  4102,  2277,  2174,   500,  2299,  2300,  2303,   896,  1594,
    2306,  2304, -1404,  -605,  1198,  2766,  2175,   581,  -779,  2417,
    2312, -1404,  2310,  2313,  3796,  1593,  2176,  2523,  2314,  4227,
    3800,  2315,  2316,  2347,  1273,  2317,  2359,  2364,  2881,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  2365,  1593,  2368,
   -1404,  1274,  4238,  1199,  1200,  1593,  2369,  4107,  4108,  4227,
    4110,  1593,   640,  2371,   478,  4238,  2372,  2378,  2380,  2381,
    2387,  2388,   501,  2177,  2178,  2420,  2424,  2457,  1201,  2392,
    2426,  2393,  2501,  2497,  2398,  2479,  2010,   536,  2399,  2405,
    2510,  2844,  2505,  2529,  1151,  1152,  2528,   470, -1404,  3509,
     471,  2179,  2530,  2540,  2145,  2541,  4148,  1826,  4149,  4150,
    2553,  2572,  2583,  2574,  2575,  2576,  3438,  3438,  3438,  2592,
   -1404,  1773,  2593,  2607,  2608,  2605,  2609,  2606,  2615,   502,
    2618,  2620,  2621,   591,   503,  2628,  3546,  1149,  2632,  2629,
    2650,  2651,  1702,   661,   640,  2633,  2634,  2638,  2653,  2654,
    2655,  2332,   504,  2250,  2054,  2249,  2673,  2695,  2058,  2672,
   -1404,  2704,  2180,  4186,  3964,  3406,  2699,  2674,  2705,  3962,
    2706,  2729,  2722,  1275,  3800,  2730,  2773,   505,  1827,  2775,
    2827,  2082,  2833,  2837,  2839,  3498,  2727,  2853,  3430,  2854,
    1594,  2858,   506,  2859,  2860,   665,  4219,  1897,  2861,  1815,
     981,   982,   666,  1828,  2006,   591,  2895,  1146,  2886,  2904,
    2899,  2905,  2181,  2906, -1404,  2955,  2907,  2909,  3546,  2910,
    2966,  2953,  2971,  2957,  2962,   661, -1404,  1276,   670,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  2965,  2978,  2983,
    2976,  1243,  2990, -1404,  1277, -1404,  2986,  3438,  2987,  3001,
    3004,  3007,  3660,  3010,   479,  3027,  3035,  3021,  2523,  3022,
    3054,  1829,  3059,  3073,  3560,  3555,  3062,  3058, -1404, -1404,
    3103,  1867, -1404, -1404,   480,  3074,  3075,   665,  1868,  1869,
    1151,  1152,  3086,  3095,   666,  3104,  3163,  3105,  3170,  3166,
    1870,  1871,   591,  3169,   677,  3176,  3174,  3177,  3187,  3188,
    -440,  2226,  1870,  1871,  2923,  3180,  3193,  3207,  3227,  3228,
     670,   481,  3253,  -531,  3254,  3236,   482,  3596,  3294,  3196,
    3224,  1872,  3202,  3203,  3600,  1873,  1874,  3204,  3263,  3235,
    3265,  1875,  3287,  3312,  3295,  -731,  -731,  1873,  1876,  3268,
    3313,  3274,  3192,  3276,  3303,  -731,  1877,  3304,  3325,  1830,
    1876,   483,  3333,   688,  3336,  3337,  1878,  3350,  1877,   484,
    3400,  3356,   759,  3403,   591,  2418,  3405,  3407,   692,   693,
    1879,  3413,  3417,  3427,  3579,  3426,   677,  3428,  3431,  3432,
    3434,  3443,  1879,  3444,  1383,  3445,  3446,  1880,   759,  1149,
    3447,  3451,  3454,  3455,  1881,  1882,  1383,  3458,  3462,  1880,
    3463,  1883,  3464,  3962,  3476,  3477,  3486,  3493,  4144,  1884,
    3494,  3491,  3605,  -850,  3025,  1885,  1155,  1156,  1157,  1158,
    1159,  1160,  1161,  3503,   591,  3505,  3506,  1885,  3510,  3511,
    3514,  3516, -1319,  3561,  3517,   688, -1324,  3558,  3583,  3528,
    3541,  3542,  3672,  1886,  3544,  3391,  3580,  3545,  3569,  3573,
     692,   693,  3575,  3584,  3585,  3438,  3438,  3587,  3438,  3438,
    3588,  3394,  3594,  3607,  3606,  3622,  3627,  3631,  2523,  3632,
    3648,  3635,  3636,  3637,  4144,  3649,  3653,  3688,  3668,  3800,
    1887,  3652,  1888,  3663,  3664,  3701,  3670,  3694,  3453,  1889,
    3703,  4027,  3737,  3702,  1888,  3745,  3759,  3769,  3774,  3770,
    3780,  1889,  3812,  3783,  1890,  4216,  4027,   759,  3814,  3817,
    3826,  3835,   759,  3853,  -307,  3855,  1890,  3862,  3872,  4037,
    3885,  3856,  3741,   581,  3865,  3887,  3871,  3888,  3896,  2481,
    3900,  3893,  1151,  1152,  3438,  3898,  2822,  3927,  3930,  4216,
    -325,  3956,   759,  3957,  4244,   712,  3958,  3971,  3992,  3547,
    3974,  3977,  3548,  4004,  4008,  4009,  4013,  1891,   759,  4010,
    4011,  4024,   718,   581,  4028,  4016,  3787,   720,  4017,  1891,
     721,  4023,  4034,  4035,   591,  1892,  4036,  4039,  4060,  1893,
    4046,  4061,  4062,  4063,  4072,  4073,  4071,  1892,  4080,  4078,
    3742,  4082,  4083,  4086,  4092,  4106, -2175,  4095,  4109,   759,
     759,   759,   759,  4111,  3827,  4112,  4122,  4114,  4136,  4135,
    4138,   759,  4152,  4153,  4141, -1477,  1894,  4154,  4158,  4159,
    3839,  1895,  3549,  3550,  4163,  3846,  4166,   712,  1896,  4174,
    3781,  3547,  4172,  4027,  3548,  1897,  1898,  4169,  4180,  4183,
    1896,  4171,  4178,  4134,   718,  4184,  4187,  4191,  1898,   720,
    4197,  4195,   721,  4204,  4228,  1511,  1512,  1513,  1514,  1515,
    4205,  4241,  4232,  3848,  2600,  2449,  1899,  1154,  1155,  1156,
    1157,  1158,  1159,  1160,  1161,  3415,  2737,  3416,  1004,  3610,
    1900,  1901,  1902,  1903,  3863,   776,   777,  3965,  4093,  3608,
    1395,  4094,  3740,  4165,  1594,  3612,  4239,  4199,   550,   906,
    3991,  3009,  2234,  1904,  3549,  3550,  4209,  3714,  4119,  3715,
    3717,  4027,  3718,  4027,  3720,  1904,  3721,  3722,  3723,  4120,
    4185,  4021,  3724,  4091,  3725,  4033,  3672,  3728,  3672,  3729,
    3905,  4027,  3730,  4032,  1455,  1866,  2148,  3748,  2409,  1934,
    3099,  2989,  3496,  2994,  1705,  3267,  3867,  4045,  3976,  1910,
    1516,  1517,  1518,  1519,  3499,  3782,  3931,  4168,  4105,  1905,
    4143,  3895,  1965,  4027,  4027,   627,  3433,   778,  4231,  2407,
    3185,  1905,  2879,  3349,  2414,  1906,  3338,  2824,  1907,  3363,
    3364,  3586,  3401,  3696,  3554,  3973,  3578,  1906,  3301,  3911,
    1907,   491,   492,  3913,  3869,  3914,   779,  3787,  3874,  1995,
    3873,  1908,  3758,  2598,  2491,  3699,   591,  3340,  2411,   780,
    2288,  2812,  3997,  1932,  1909,  1799,  3557,  2635,  3339,  2616,
    1963,  2218,  2571,  3264,  2980,  2656,  1909,  3735,   928,  2964,
    3252,  1293,   781,  2526,   782,  2248,   759,  1548,  2717,  3309,
    3819,  2570,  3676,  3414,  4069,   783,  4070,  2590,  3673,  1501,
    1520,  3344,  1521,  1522,  1523,  4190,  3662,  2663,  3989,  2495,
    1693,  1524,  2641,  4104,  1720,   784,  2614,  1816,  3319,  3501,
    3280,  3279,  4042,  -850,   917,  2004,  1022,  2279,  1766,  2482,
     902,  3981,  1788,  2280,  2160,  1594,  3348,  1724,  3266,  4064,
     785,   759,   759,  4139,  4167,  4113,   786,  4240,  3582,  4243,
     759,   759,   759,   759,   759,   759,   759,  1739,  3283,   591,
    3043,   759,  2259,  3305,   759,   759,  3515,   759,  2197,   759,
    3665,   847,  1280,   759,  2844,  2844,   759,   759,   759,   759,
    1731,   759,   759,  3773,  2968,   787,  1985,  1525,  3779,   759,
     759,   621,   759,   759,   759,   759,   759,   849,   759,  1285,
     759,   759,   759,   759,   759,   759,   759,   759,   759,   759,
     759,   622,  1008,   759,   759,  1009,   759,  1010,   759,   591,
       0,     0,   759,  1686,   759,   759,     0,  4053,  4054,  1129,
    1130,     0,     0,     0,     0,     0,   759,   759,     0,  1526,
    1527,     0,     0,  4124,   759,     0,     0,     0,     0,     0,
    4132,   759,   759,   759,   777,   759,     0,     0,     0,     0,
       0,     0,   759,   759,   759,     0,   759,   759,   759,   759,
     759,     0,   759,   759,   759,   759,   759,   759,   759,   759,
       0,     0,  4233,   759,   759,     0,     0,     0,  1417,     0,
       0,     0,     0,   844,   777,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   815,     0,     0,   788,
       0,     0,     0,   789,     0,  1187,     0,     0,  4176,     0,
       0,     0,     0,  4181,  1511,  1512,  1513,  1514,  1515,   790,
       0,     0,     0,     0,     0,   778,     0,   791,     0,     0,
       0,     0,     0,     0,     0,   792,  1418,  1419,  1420,  1421,
    1422,  1423,     0,  1424,  1425,  1426,  1427,  1428,  1429,  1430,
    4217,  1431,  1432,     0,   779,     0,     0,     0,     0,  1594,
     793,  1528,     0,     0,     0,   778,     0,   780,     0,     0,
       0,     0,     0,   794,   795,  1529,  1530,     0,   591,     0,
       0,     0,  1594,     0,  4217,     0,     0,     0,     0,  1594,
     781,     0,   782,     0,   779,  1594,     0,     0,  1188,     0,
     759,     0,     0,   783,     0,     0,     0,   780,   759,  1516,
    1517,  1518,  1519,     0,     0,     0,     0,   796,     0,     0,
    1030,     0,  1189,   784,     0,     0,  1190,     0,     0,     0,
     781,     0,   782,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   783,     0,     0,   797,     0,   785,     0,
    1062,     0,     0,     0,   786,     0,     0,     0,     0,  1191,
       0,     0,     0,   784,     0,     0,  1079,     0,   798,     0,
     799,     0,     0,     0,  1433,  1434,  1192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   785,     0,
       0,     0,     0,   787,   786,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1520,
    1123,  1521,  1522,  1523,     0,     0,     0,     0,     0,     0,
    1524,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   787,     0,     0,  1193,     0,     0,     0,
       1,     2,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     3,  1194,  1131,
       0,     4,  1132,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     6,     0,     0,     0,
       0,     0,     0,     7,     0,     0,     0,     8,     9,     0,
       0,     0,     0,     0,     0,     0,  1525,     0,   759,     0,
       0,     0,    10,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   788,     0,     0,
       0,    11,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   790,     0,     0,
       0,     0,    12,     0,     0,   791,     0,     0,  1526,  1527,
      13,    14,    15,   792,     0,     0,  1195,   788,     0,     0,
       0,   845,    16,    17,     0,  1196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    18,     0,   790,   793,     0,
    1197,     0,     0,     0,     0,   791,     0,     0,    19,     0,
       0,   794,   795,   792,   759,   759,   759,     0,  1198,     0,
       0,     0,     0,     0,    20,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   793,    21,
       0,     0,     0,     0,    22,     0,     0,    23,     0,     0,
       0,   794,   795,     0,   759,   796,     0,  1199,  1200,     0,
     759,     0,     0,   759,  1416,   759,     0,     0,     0,     0,
      24,   759,    25,   759,   759,     0,     0,     0,     0,     0,
       0,     0,  1201,     0,   797,     0,     0,     0,    26,     0,
       0,     0,     0,     0,     0,   796,     0,     0,     0,     0,
    1528,     0,     0,     0,     0,    27,   798,     0,   799,    28,
       0,     0,     0,  1133,  1529,  1530,     0,     0,     0,  1481,
    1482,     0,     0,     0,   797,     0,     0,     0,  1492,  1493,
       0,     0,  1496,  1497,  1498,     0,     0,     0,     0,  1503,
     759,     0,  1505,  1506,     0,  1507,   798,  1508,   799,     0,
       0,     0,     0,     0,  1541,  1542,  1543,  1544,     0,  1546,
       0,     0,     0,     0,     0,     0,     0,  1554,  1555,     0,
    1558,  1559,     0,     0,     0,     0,  1563,     0,  1564,  1565,
    1566,     0,     0,  1569,  1570,  1571,  1572,  1573,  1574,     0,
       0,  1577,  1578,     0,  1581,     0,  1582,     0,    29,     0,
    1585,     0,  1589,  1590,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1597,  1598,     0,    30,     0,     0,
       0,     0,  1606,     0,     0,     0,     0,    31,     0,  1611,
    1612,  1613,     0,     0,     0,     0,     0,     0,    32,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,     0,  1649,    34,     0,    35,     0,     0,    36,     0,
       0,    37,    38,     0,     0,     0,     0,     0,     0,    39,
       0,    40,     0,     0,     0,     0,     0,     0,    41,     0,
       0,     0,     0,     0,    42,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,    44,     0,    45,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   866,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   823,   867,     0,     0,     0,     0,     0,     0,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,     0,     0,   868,   869,  1738,     0,
       0,     0,     0,     0,     0,    50,  1753,   870,     0,    51,
       0,     0,    52,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   871,     0,
     872,     0,   873,     0,     0,     0,     0,     0,     0,     0,
       0,   874,     0,     0,    54,     0,   759,     0,     0,     0,
     759,     0,     0,     0,     0,   759,   759,     0,     0,    55,
       0,     0,     0,     0,   759,     0,     0,   759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,     0,   759,
     759,     0,   759,   759,   759,   759,   759, -1674,   875,   759,
       0,     0,     0,   876,     0,     0,   877,     0,   759,     0,
       0,     0,     0,     0,     0,     0,   759,     0,   759,     0,
     759,   759,   759,   759,     0,     0,     0,   759,   759,   759,
       0,   878,     0,   879,   759,   759,   759,     0,   759,   880,
     759,   881,   759,     0,   759,     0,   759,     0,     0,     0,
       0,   759,     0,     0,     0,     0,  1870,  1871,     0,     0,
       0,     0,     1,     2,   882,   883,     0,     0,     0,   759,
       0,     0,     0,     0,     0,     0,   759,     0,     0,   759,
       0,     0,     0,     4,     0,   759,   884,     0,   759,  -731,
    -731,  1873,   759,     0,     0,     0,     0,     5,     6,  -731,
       0,     0,     0,     0,  1876,     7,  2016,   885,     0,     8,
       9,     0,  1877,     0,     0,     0,     0,     0,     0,     0,
    1870,  1871,     0,     0,    10,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   886,     0,  1879,     0,     0,     0,
       0,     0,     0,    11,     0,     0,     0,   759,     0,     0,
    1383,     0,     0,  1880,     0,  1873,     0,     0,     0,     0,
       0,     0,     0,     0,    12,     0,     0,     0,  1876,     0,
       0,     0,    13,    14,    15,     0,  1877,     0,     0,     0,
       0,  1885,     0,     0,    16,    17,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   887,     0,
    1879,     0,  2091,  2093,  2095,     0,     0,     0,     0,     0,
      19,     0,     0,     0,  1383,     0,     0,  1880,     0,     0,
       0,   888,     0,     0,     0,     0,    20,     0,     0,     0,
       0,     0,   889,   890,     0,     0,   891,   892,     0,     0,
       0,    21,  2129,     0,     0,  1885,    22,     0,  1888,    23,
       0,  2134,     0,  2135,     0,  1889,     0,   893,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1890,     0,    24,     0,    25,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      26,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     894,     0,     0,     0,     0,     0,     0,    27,     0,     0,
       0,    28,  1888,   895,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,  1891,     0,     0,     0,     0,  2214,     0,
       0,     0,     0,     0,  1890,     0,     0,     0, -2202,     0,
       0,  1892,   896,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     897,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1891,     0,     0,
       0,     0,     0,     0,  1896,     0,     0,     0,     0,     0,
      29,     0,  1898,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2202,     0,    30,
       0,     0,     0,   898,     0,     0,     0,     0,     0,    31,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      32,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   759,     0,     0,     0,   759,     0,     0,  1896,     0,
       0,     0,    33,     0,     0,    34,  1898,    35,     0,  1904,
      36,     0,     0,    37,    38,     0,     0,   759,   759,     0,
       0,    39,     0,    40,     0,     0,     0,     0,     0,     0,
      41,     0,     0,     0,     0,     0,    42,   759,     0,     0,
       0,     0,     0,     0,    43,     0,   759,     0,   759,    44,
     759,    45,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1905,     0,     0,     0,     0,
     759,     0,     0,  1904,     0,   759,     0,     0,    47,     0,
       0,  1906,    48,     0,  1907,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2425,     0,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1909,     0,     0,     0,     0,    49,     0,     0,     0,  1905,
       0,     0,     0,     0,     0,     0,     0,    50,     0,     0,
       0,    51,     0,     0,    52,  1906,     0,     0,  1907,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   759,  2504,     0,     0,   759,  2506,     0,
       0,     0,     0,  2508,  2509,     0,    54,     0,     0,     0,
       0,     0,  2524,     0,  1909,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,  2531,     0,  2532,     0,     0,
    2534,  2535,  2536,  2537,  2538,     0,     0,     0,     0,     0,
       0,   759,     0,     0,     0,     0,  2542,     0,     0,     0,
       0,     0,     0,     0,  2543,     0,  2544,     0,  2545,  2546,
    2547,     0,     0,     0,     0,  2550,  2551,  2552,     0,     0,
       0,     0,  2554,  2555,  2556,     0,  2557,     0,  2559,     0,
    2561,     0,  2563,     0,  2564,     0,  3108,  3109,     0,  2565,
       0,     0,  3110,     0,  3111,     0,  3112,  3113,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2578,     0,     0,
       0,     0,     0,  3114,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2588,     0,     0,  2591,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   759,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3115,     0,     0,  3116,     0,     0,     0,     0,     0,     0,
       0,  3117,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3118,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3119,     0,     0,     0,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3120,     0,
    3121,     0,     0,     0,     0,     0,   759,   759,     0,   759,
       0,     0,  3122,  3123,     0,     0,     0,     0,   759,     0,
       0,     0,     0,   759,     0,     0,   759,     0,   759,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   759,
       0,     0,  3124,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3125,     0,     0,     0,     0,     0,     0,     0,   759,  3126,
    3127,     0,  3128,     0,     0,  2810,     0,     0,     0,     0,
       0,     0,  1868,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1870,  1871,     0,     0,   759,     0,
       0,     0,  3129,  3130,  3131,     0,     0,     0,     0,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,  3132,  3133,  3134,     0,  1872,     0,     0,  3135,  1873,
       0,  3136,   759,     0,     0,     0,     0,     0,     0,     0,
       0,   759,  1876,     0,     0,     0,     0,  3137,  3138,     0,
    1877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1878,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1879,     0,     0,     0,     0,  3139,
    3140,     0,     0,     0,     0,     0,     0,     0,  1383,     0,
       0,  1880,     0,     0,     0,     0,     0,     0,  1881,     0,
       0,     0,     0,     0,  3141,  2811,     0,     0,     0,     0,
       0,     0,     0,  1884,     0,     0,     0,     0,     0,  1885,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2891,
       0,     0,     0,  2893,     0,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,     0,  3142,     0,     0,     0,  3143,
       0,     0,     0,     0,     0,  2912,  2913,     0,     0,     0,
       0,  3144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2933,  1888,     0,     0,     0,
       0,     0,     0,  1889,  2943,     0,  2945,     0,  2947,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3145,     0,     0,  3146,     0,     0,  3147,
    3148,  3149,  3150,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,  2977,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1891,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3151,  3152,     0,     0,     0,     0,     0,     0,  1892,
       0,     0,     0,  1893,   759,   759,     0,     0,     0,     0,
       0,     0,     0,   759,     0,  3153,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3033,     0,     0,     0,  3037,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1895,     0,     0,     0,     0,
       0,     0,  1896,     0,     0,     0,     0,     0,     0,     0,
    1898,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3068,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1901,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1904,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   759,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   759,
       0,     0,     0,  1905,     0,     0,  3164,  3165,     0,     0,
       0,     0,     0,   759,     0,     0,     0,     0,     0,  1906,
       0,     0,  1907,     0,     0,     0,   759,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1909,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3230,  3231,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3238,  3732,     0,     0,
       0,  3240,     0,     0,  3241,     0,  3242,  3243,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3260,     0,     0,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,   759,     0,     0,     0,
       0,     0,     0,     0,     0,   759,  3260,   759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   759,     0,     0,     0,     0,     0,  3732,  3732,     0,
    3306,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3260,     0,     0,     0,     0,     0,     0,     0,     0,  3330,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   759,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   759,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   759,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   759,     0,  3732,  3732,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3969,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   759,     0,  3732,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3260,     0,     0,     0,     0,  3732,   759,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3732,     0,     0,     0,     0,     0,     0,     0,     0,
     759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3526,  3527,     0,     0,     0,     0,     0,     0,
       0,  3068,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,  3732,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3732,  3732,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3732,     0,     0,     0,     0,
       0,     0,   759,     0,     0,  3732,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   759,     0,     0,     0,
       0,     0,  3068,  3732,     0,  3732,  3630,     0,     0,     0,
       0,     0,     0,     0,     0,  3732,     0,     0,     0,   759,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,  3732,     0,  3732,     0,  3732,     0,  3260,     0,     0,
       0,     0,  3732,     0,     0,     0,     0,     0,     0,     0,
       0,  3068,     0,  3732,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3033,     0,     0,     0,     0,  3732,
    3732,     0,     0,     0,     0,   759,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3732,  3732,     0,     0,     0,
    3732,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   759,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3806,     0,     0,     0,     0,     0,
       0,     0,     0,  3811,     0,  3813,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3834,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3068,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3068,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3925,     0,  3926,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3934,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4025,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4030,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3260,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4076,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
    4170,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,  1586,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,  4218,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
    3260,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,  1587,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,  1588,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
    3029,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,  3030,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,  3031,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,  3032,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,  1502,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,  2090,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,   690,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,  2092,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,   674,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,   690,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,  2094,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,   674,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,   662,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
     690,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,  1061,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,  1620,     0,     0,     0,     0,  1621,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,     0,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,  2503,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,   690,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,  2549,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,   690,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   636,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   637,     0,
     143,   144,   145,   146,   147,   638,   149,     0,   150,     0,
       0,   639,   151,   640,   641,   642,   152,   643,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
     644,   645,   160,   161,     0,   162,   646,   647,   164,     0,
     165,   166,   167,   168,   648,   170,     0,   649,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   650,   187,     0,   188,   651,
     652,   189,     0,     0,   190,   653,   654,     0,   191,   655,
     656,     0,   192,   193,   194,   657,   658,   659,     0,     0,
       0,     0,   660,   197,   661,     0,     0,  3259,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
     663,     0,   222,   223,   224,   664,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   667,   236,   668,   238,
       0,   239,     0,   669,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   671,   246,   247,   248,
     672,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,   673,   253,   254,   674,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,   675,   264,   265,     0,
       0,     0,     0,     0,   676,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,   678,   288,   289,
     290,   291,   679,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   680,   299,     0,     0,   681,   301,   682,
     302,     0,   303,   683,   684,   685,   686,   687,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,   689,   690,   691,   319,   320,     0,   692,
     693,     0,   321,   322,   694,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,   695,   331,   332,   333,   334,   335,   696,
     337,   338,   339,   697,   698,   342,   699,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     700,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,   701,   702,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,   703,   377,   378,   379,   380,   381,   704,   383,   384,
     385,   386,     0,   705,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,   706,
     707,   411,   412,     0,   413,   414,   708,   416,   417,   418,
     709,   710,   419,   420,   421,   422,   711,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
     713,   714,   715,   716,     0,     0,     0,     0,     0,   435,
     436,     0,   717,   718,   719,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   722,   451,     0,     0,
     723,   724,   725,   726,   452,     0,     0,   453,   727,     0,
     728,   454,   455,   456,   729,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   730,
       0,     0,     0,   731,   732,     0,     0,     0,     0,   733,
     734,     0,     0,   735,   736,     0,     0,   737,   738,   135,
       0,   636,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   637,     0,   143,   144,   145,   146,
     147,   638,   149,     0,   150,     0,     0,   639,   151,   640,
     641,   642,   152,   643,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,   644,   645,   160,   161,
       0,   162,   646,   647,   164,     0,   165,   166,   167,   168,
     648,   170,     0,   649,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   650,   187,     0,   188,   651,   652,   189,     0,     0,
     190,   653,   654,     0,   191,   655,   656,     0,   192,   193,
     194,   657,   658,   659,     0,     0,     0,     0,   660,   197,
     661,     0,     0,   662,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,   663,     0,   222,   223,
     224,   664,   665,   225,   226,     0,   227,   228,   229,   666,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   667,   236,   668,   238,     0,   239,     0,   669,
       0,   240,   241,     0,   242,   670,     0,   243,   244,     0,
       0,     0,   671,   246,   247,   248,   672,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,   673,   253,   254,
     674,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,   675,   264,   265,     0,     0,     0,     0,     0,
     676,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,   677,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,   678,   288,   289,   290,   291,   679,   292,
     293,  4099,     0,     0,     0,   294,   295,   296,   297,   680,
     299,     0,     0,   681,   301,   682,   302,     0,   303,   683,
     684,   685,   686,   687,   308,   309,   310,   311,   312,     0,
     688,   313,   314,     0,     0,   315,   316,   317,   318,   689,
       0,   691,   319,   320,     0,   692,   693,     0,   321,   322,
     694,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,   695,
     331,   332,   333,   334,   335,   696,   337,   338,   339,   697,
     698,   342,   699,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   700,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,   701,   702,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,   703,   377,   378,
     379,   380,   381,   704,   383,   384,   385,   386,     0,   705,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,   706,   707,   411,   412,     0,
     413,   414,   708,   416,   417,   418,   709,   710,   419,   420,
     421,   422,   711,   423,   424,     0,     0,   425,   426,   427,
     428,     0,   712,   429,   430,     0,   713,   714,   715,   716,
       0,     0,     0,     0,     0,   435,   436,     0,   717,   718,
     719,   438,   439,   440,   720,   441,   442,   721,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   722,   451,     0,     0,   723,   724,   725,   726,
     452,     0,     0,   453,   727,     0,   728,   454,   455,   456,
     729,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   730,     0,     0,     0,   731,
     732,     0,     0,     0,     0,   733,   734,     0,     0,   735,
     736,     0,     0,   737,   738,   135,     0,   636,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     637,     0,   143,   144,   145,   146,   147,   638,   149,     0,
     150,     0,     0,   639,   151,   640,   641,   642,   152,   643,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,   644,   645,   160,   161,     0,   162,   646,   647,
     164,     0,   165,   166,   167,   168,   648,   170,     0,   649,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   650,   187,     0,
     188,   651,   652,   189,     0,     0,   190,   653,   654,     0,
     191,   655,   656,     0,   192,   193,   194,   657,   658,   659,
       0,     0,     0,     0,   660,   197,   661,     0,     0,   662,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,   663,     0,   222,   223,   224,   664,   665,   225,
     226,     0,   227,   228,   229,   666,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   667,   236,
     668,   238,     0,   239,     0,   669,     0,   240,   241,     0,
     242,   670,     0,   243,   244,     0,     0,     0,   671,   246,
     247,   248,   672,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,   673,   253,   254,   674,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,   675,   264,
     265,     0,     0,     0,     0,     0,   676,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,   677,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,   678,
     288,   289,   290,   291,   679,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   680,   299,     0,     0,   681,
     301,   682,   302,     0,   303,   683,   684,   685,   686,   687,
     308,   309,   310,   311,   312,     0,   688,   313,   314,     0,
       0,   315,   316,   317,   318,   689,     0,   691,   319,   320,
       0,   692,   693,     0,   321,   322,   694,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,   695,   331,   332,   333,   334,
     335,   696,   337,   338,   339,   697,   698,   342,   699,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   700,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
     701,   702,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,   703,   377,   378,   379,   380,   381,   704,
     383,   384,   385,   386,     0,   705,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,   706,   707,   411,   412,     0,   413,   414,   708,   416,
     417,   418,   709,   710,   419,   420,   421,   422,   711,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   712,   429,
     430,     0,   713,   714,   715,   716,     0,     0,     0,     0,
       0,   435,   436,     0,   717,   718,   719,   438,   439,   440,
     720,   441,   442,   721,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   722,   451,
       0,     0,   723,   724,   725,   726,   452,     0,     0,   453,
     727,     0,   728,   454,   455,   456,   729,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   730,     0,     0,     0,   731,   732,     0,     0,     0,
       0,   733,   734,     0,     0,   735,   736,     0,     0,   737,
     738,   135,     0,   636,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   637,     0,   143,   144,
     145,   146,   147,   638,   149,     0,   150,     0,     0,   639,
     151,   640,   641,   642,   152,   643,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,   644,   645,
     160,   161,     0,   162,   646,   647,   164,     0,   165,   166,
     167,   168,   648,   170,     0,   649,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   650,   187,     0,   188,   651,   652,   189,
       0,     0,   190,   653,   654,     0,   191,   655,   656,     0,
     192,   193,   194,   657,   658,   659,     0,     0,     0,     0,
     660,   197,   661,     0,     0,   662,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,   663,     0,
     222,   223,   224,   664,   665,   225,   226,     0,   227,   228,
     229,   666,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   667,   236,   668,   238,     0,   239,
       0,   669,     0,   240,   241,     0,   242,   670,     0,   243,
     244,     0,     0,     0,   671,   246,   247,   248,   672,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,   673,
     253,   254,  1635,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,   675,   264,   265,     0,     0,     0,
       0,     0,   676,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,   677,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,   678,   288,   289,   290,   291,
     679,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   680,   299,     0,     0,   681,   301,   682,   302,     0,
     303,   683,   684,   685,   686,   687,   308,   309,   310,   311,
     312,     0,   688,   313,   314,     0,     0,   315,   316,   317,
     318,   689,     0,   691,   319,   320,     0,   692,   693,     0,
     321,   322,   694,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,   695,   331,   332,   333,   334,   335,   696,   337,   338,
     339,   697,   698,   342,   699,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   700,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,   701,   702,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,   703,
     377,   378,   379,   380,   381,   704,   383,   384,   385,   386,
       0,   705,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,   706,   707,   411,
     412,     0,   413,   414,   708,   416,   417,   418,   709,   710,
     419,   420,   421,   422,   711,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   712,   429,   430,     0,   713,   714,
     715,   716,     0,     0,     0,     0,     0,   435,   436,     0,
     717,   718,   719,   438,   439,   440,   720,   441,   442,   721,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   722,   451,     0,     0,   723,   724,
     725,   726,   452,     0,     0,   453,   727,     0,   728,   454,
     455,   456,   729,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   730,     0,     0,
       0,   731,   732,     0,     0,     0,     0,   733,   734,     0,
       0,   735,   736,     0,     0,   737,   738,   135,     0,   636,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   637,     0,   143,   144,   145,   146,   147,   638,
     149,     0,   150,     0,     0,   639,   151,   640,   641,   642,
     152,   643,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,   644,   645,   160,   161,     0,   162,
     646,   647,   164,     0,   165,   166,   167,   168,   648,   170,
       0,   649,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   650,
     187,     0,   188,   651,   652,   189,     0,     0,   190,   653,
     654,     0,   191,   655,   656,     0,   192,   193,   194,   657,
     658,   659,     0,     0,     0,     0,   660,   197,   661,     0,
       0,   662,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,   663,     0,   222,   223,   224,   664,
     665,   225,   226,     0,   227,   228,   229,   666,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     667,   236,   668,   238,     0,   239,     0,   669,     0,   240,
     241,     0,   242,   670,     0,   243,   244,     0,     0,     0,
     671,   246,   247,   248,   672,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,   673,   253,   254,  1637,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
     675,   264,   265,     0,     0,     0,     0,     0,   676,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,   677,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,   678,   288,   289,   290,   291,   679,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   680,   299,     0,
       0,   681,   301,   682,   302,     0,   303,   683,   684,   685,
     686,   687,   308,   309,   310,   311,   312,     0,   688,   313,
     314,     0,     0,   315,   316,   317,   318,   689,     0,   691,
     319,   320,     0,   692,   693,     0,   321,   322,   694,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,   695,   331,   332,
     333,   334,   335,   696,   337,   338,   339,   697,   698,   342,
     699,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   700,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,   701,   702,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,   703,   377,   378,   379,   380,
     381,   704,   383,   384,   385,   386,     0,   705,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,   706,   707,   411,   412,     0,   413,   414,
     708,   416,   417,   418,   709,   710,   419,   420,   421,   422,
     711,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     712,   429,   430,     0,   713,   714,   715,   716,     0,     0,
       0,     0,     0,   435,   436,     0,   717,   718,   719,   438,
     439,   440,   720,   441,   442,   721,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     722,   451,     0,     0,   723,   724,   725,   726,   452,     0,
       0,   453,   727,     0,   728,   454,   455,   456,   729,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   730,     0,     0,     0,   731,   732,     0,
       0,     0,     0,   733,   734,     0,     0,   735,   736,     0,
       0,   737,   738,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,     0,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,   640,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,  2235,     0,     0,
       0,     0,   196,   197,   661,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,   665,   225,   226,     0,
     227,   228,   229,   666,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,   670,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,   677,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,   688,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,   692,
     693,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   712,   429,   430,     0,
    2236,   432,   433,  2237,     0,     0,     0,     0,     0,   435,
     436,     0,     0,   718,   437,   438,   439,   440,   720,   441,
     442,   721,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,     0,     0,   135,     0,   136,   137,   138,   139,
     140,     0,     0,     0,     0,     0,   141,   737,   738,   142,
       0,   143,   144,   145,   146,   147,   148,   149,     0,   150,
       0,     0,     0,   151,     0,     0,     0,   152,     0,     0,
     153,   154,   155,     0,   156,     0,   157,   158,     0,     0,
     159,     0,     0,   160,   161,     0,   162,   163,     0,   164,
       0,   165,   166,   167,   168,   169,   170,     0,   171,   172,
       0,   173,   174,   175,   176,   177,   178,   179,   180,     0,
     181,   182,  2348,   183,   184,   185,   186,   187,     0,   188,
       0,     0,   189,     0,     0,   190,     0,     0,     0,   191,
       0,     0,     0,   192,   193,   194,     0,     0,   195,     0,
       0,     0,     0,   196,   197,     0,     0,     0,     0,   198,
       0,   199,     0,     0,     0,   200,     0,   201,   202,   203,
     204,     0,     0,     0,   205,     0,     0,   206,   207,   208,
       0,     0,     0,   209,     0,   210,   211,     0,   212,   213,
     214,     0,     0,   215,   216,     0,   217,   218,   219,   220,
     221,     0,     0,   222,   223,   224,     0,     0,   225,   226,
       0,   227,   228,   229,     0,     0,   230,     0,     0,     0,
     231,     0,   232,   477,   233,     0,   234,   235,   236,   237,
     238,     0,   239,     0,     0,     0,   240,   241,     0,   242,
       0,     0,   243,   244,     0,     0,     0,   245,   246,   247,
     248,     0,     0,   249,   250,   251,  1936,     0,   252,     0,
       0,     0,     0,   253,   254,     0,     0,     0,   255,     0,
     256,   257,     0,   258,   259,     0,     0,     0,   260,  1937,
       0,   261,   262,     0,     0,   263,     0,     0,   264,   265,
       0,  2874,     0,     0,     0,   266,   267,     0,   268,     0,
     269,     0,   270,   271,     0,     0,     0,     0,     0,     0,
       0,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,     0,   285,   286,   287,     0,   288,
     289,   290,   291,     0,   292,   293,     0,     0,     0,     0,
     294,   295,   296,   297,   298,   299,     0,     0,   300,   301,
       0,   302,     0,   303,     0,   304,   305,   306,   307,   308,
     309,   310,   311,   312,     0,     0,   313,   314,     0,     0,
     315,   316,   317,   318,     0,     0,     0,   319,   320,     0,
       0,     0,     0,   321,   322,   323,     0,   324,   325,   326,
       0,   327,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   328,   329,   330,     0,   331,   332,   333,   334,  2875,
     336,   337,   338,   339,   340,   341,   342,     0,     0,   343,
     344,   345,     0,   346,     0,   347,   348,   349,   350,   351,
       0,   352,   353,   354,     0,     0,   355,     0,     0,     0,
     356,   357,   358,   359,   360,     0,     0,   361,   362,   363,
     364,   365,     0,   366,   367,     0,   368,   369,   370,     0,
       0,   371,     0,   372,     0,   373,   374,     0,   375,   376,
       0,     0,     0,   377,   378,   379,   380,   381,   382,   383,
     384,   385,   386,     0,   387,   388,  -436,     0,     0,   389,
     390,   391,   392,     0,     0,     0,   393,     0,     0,     0,
     394,     0,   395,   396,   397,   398,     0,   399,   400,   401,
     402,   403,   480,     0,     0,     0,     0,     0,   404,   405,
       0,   406,     0,     0,   407,     0,     0,   408,   409,   410,
       0,     0,   411,   412,     0,   413,   414,   415,   416,   417,
     418,     0,     0,   419,   420,   421,   422,     0,   423,   424,
       0,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,   433,   434,     0,     0,     0,     0,     0,
     435,   436,     0,     0,     0,   437,   438,   439,   440,     0,
     441,   442,     0,   443,   444,     0,   445,   446,     0,     0,
     447,     0,     0,   448,     0,   449,     0,   450,   451,     0,
       0,     0,     0,     0,     0,   452,     0,     0,   453,     0,
       0,     0,   454,   455,   456,   457,     0,     0,     0,     0,
       0,     0,   458,   459,     0,   460,   461,   462,     0,     0,
     463,     0,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,  2413,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,  2348,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,   477,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,  1936,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,  1937,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,     0,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,   480,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,     0,   135,     0,   136,   137,   138,   139,   140,     0,
       0,     0,     0,     0,   141,     0,     0,   142,  2413,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   223,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,  2226,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
    2642,     0,     0,   141,     0,     0,   142,   738,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
       0,     0,   135,     0,   136,   137,   138,   139,   140,  4223,
       0,     0,     0,     0,   141,  4224,   738,   142,     0,   143,
     144,   145,   146,   147,   148,   149,     0,   150,     0,     0,
       0,   151,     0,     0,     0,   152,     0,     0,   153,   154,
     155,     0,   156,     0,   157,   158,     0,     0,   159,     0,
       0,   160,   161,     0,   162,   163,     0,   164,     0,   165,
     166,   167,   168,   169,   170,     0,   171,   172,     0,   173,
     174,   175,   176,   177,   178,   179,   180,     0,   181,   182,
       0,   183,   184,   185,   186,   187,     0,   188,     0,     0,
     189,     0,     0,   190,     0,     0,     0,   191,     0,     0,
       0,   192,   193,   194,     0,     0,   195,     0,     0,     0,
       0,   196,   197,     0,     0,     0,     0,   198,     0,   199,
       0,     0,     0,   200,     0,   201,   202,   203,   204,     0,
       0,     0,   205,     0,     0,   206,   207,   208,     0,     0,
       0,   209,     0,   210,   211,     0,   212,   213,   214,     0,
       0,   215,   216,     0,   217,   218,   219,   220,   221,     0,
       0,   222,   223,   224,     0,     0,   225,   226,     0,   227,
     228,   229,     0,     0,   230,     0,     0,     0,   231,     0,
     232,     0,   233,     0,   234,   235,   236,   237,   238,     0,
     239,     0,     0,     0,   240,   241,     0,   242,     0,     0,
     243,   244,     0,     0,     0,   245,   246,   247,   248,     0,
       0,   249,   250,   251,     0,     0,   252,     0,     0,     0,
       0,   253,   254,     0,     0,     0,   255,     0,   256,   257,
       0,   258,   259,     0,     0,     0,   260,     0,     0,   261,
     262,     0,     0,   263,     0,     0,   264,   265,     0,     0,
       0,     0,     0,   266,   267,     0,   268,     0,   269,     0,
     270,   271,     0,     0,     0,     0,     0,     0,     0,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,     0,   285,   286,   287,     0,   288,   289,   290,
     291,     0,   292,   293,     0,     0,     0,     0,   294,   295,
     296,   297,   298,   299,     0,     0,   300,   301,     0,   302,
       0,   303,     0,   304,   305,   306,   307,   308,   309,   310,
     311,   312,     0,     0,   313,   314,     0,     0,   315,   316,
     317,   318,     0,     0,     0,   319,   320,     0,     0,     0,
       0,   321,   322,   323,     0,   324,   325,   326,     0,   327,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   328,
     329,   330,     0,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,     0,     0,   343,   344,   345,
       0,   346,     0,   347,   348,   349,   350,   351,     0,   352,
     353,   354,     0,     0,   355,     0,     0,     0,   356,   357,
     358,   359,   360,     0,     0,   361,   362,   363,   364,   365,
       0,   366,   367,     0,   368,   369,   370,     0,     0,   371,
       0,   372,     0,   373,   374,     0,   375,   376,     0,     0,
       0,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,     0,   387,   388,     0,     0,     0,   389,   390,   391,
     392,     0,     0,     0,   393,     0,     0,     0,   394,     0,
     395,   396,   397,   398,     0,   399,   400,   401,   402,   403,
       0,     0,     0,     0,     0,     0,   404,   405,     0,   406,
       0,     0,   407,     0,     0,   408,   409,   410,     0,     0,
     411,   412,     0,   413,   414,   415,   416,   417,   418,     0,
       0,   419,   420,   421,   422,     0,   423,   424,     0,     0,
     425,   426,   427,   428,     0,     0,   429,   430,     0,   431,
     432,   433,   434,     0,     0,     0,     0,     0,   435,   436,
       0,     0,     0,   437,   438,   439,   440,     0,   441,   442,
       0,   443,   444,     0,   445,   446,     0,     0,   447,     0,
       0,   448,     0,   449,     0,   450,   451,     0,     0,     0,
       0,     0,     0,   452,     0,     0,   453,     0,     0,     0,
     454,   455,   456,   457,     0,     0,     0,     0,     0,     0,
     458,   459,     0,   460,   461,   462,     0,     0,   463,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,  1065,
       0,     0,     0,   141,     0,     0,   142,   738,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,  1258,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,     0,     0,
       0,     0,   141,     0,     0,   142,   511,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     223,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,     0,
       0,   135,  2167,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,   511,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,  2412,     0,
       0,     0,   141,     0,     0,   142,  2413,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     223,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,     0,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,  4224,   738,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,     0,   463,     0,     0,
     135,     0,   136,   137,   138,   139,   140,     0,     0,     0,
       0,     0,   141,     0,     0,   142,   511,   143,   144,   145,
     146,   147,   148,   149,     0,   150,     0,     0,     0,   151,
       0,     0,     0,   152,     0,     0,   153,   154,   155,     0,
     156,     0,   157,   158,     0,     0,   159,     0,     0,   160,
     161,     0,   162,   163,     0,   164,     0,   165,   166,   167,
     168,   169,   170,     0,   171,   172,     0,   173,   174,   175,
     176,   177,   178,   179,   180,     0,   181,   182,     0,   183,
     184,   185,   186,   187,     0,   188,     0,     0,   189,     0,
       0,   190,     0,     0,     0,   191,     0,     0,     0,   192,
     193,   194,     0,     0,   195,     0,     0,     0,     0,   196,
     197,     0,     0,     0,     0,   198,     0,   199,     0,     0,
       0,   200,     0,   201,   202,   203,   204,     0,     0,     0,
     205,     0,     0,   206,   207,   208,     0,     0,     0,   209,
       0,   210,   211,     0,   212,   213,   214,     0,     0,   215,
     216,     0,   217,   218,   219,   220,   221,     0,     0,   222,
     577,   224,     0,     0,   225,   226,     0,   227,   228,   229,
       0,     0,   230,     0,     0,     0,   231,     0,   232,     0,
     233,     0,   234,   235,   236,   237,   238,     0,   239,     0,
       0,     0,   240,   241,     0,   242,     0,     0,   243,   244,
       0,     0,     0,   245,   246,   247,   248,     0,     0,   249,
     250,   251,     0,     0,   252,     0,     0,     0,     0,   253,
     254,     0,     0,     0,   255,     0,   256,   257,     0,   258,
     259,     0,     0,     0,   260,     0,     0,   261,   262,     0,
       0,   263,     0,     0,   264,   265,     0,     0,     0,     0,
       0,   266,   267,     0,   268,     0,   269,     0,   270,   271,
       0,     0,     0,     0,     0,     0,     0,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
       0,   285,   286,   287,     0,   288,   289,   290,   291,     0,
     292,   293,     0,     0,     0,     0,   294,   295,   296,   297,
     298,   299,     0,     0,   300,   301,     0,   302,     0,   303,
       0,   304,   305,   306,   307,   308,   309,   310,   311,   312,
       0,     0,   313,   314,     0,     0,   315,   316,   317,   318,
       0,     0,     0,   319,   320,     0,     0,     0,     0,   321,
     322,   323,     0,   324,   325,   326,     0,   327,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   328,   329,   330,
       0,   331,   332,   333,   578,   335,   336,   337,   338,   339,
     340,   341,   342,     0,     0,   343,   344,   345,     0,   346,
       0,   347,   348,   349,   350,   351,     0,   352,   353,   354,
       0,     0,   355,     0,     0,     0,   356,   357,   358,   359,
     360,     0,     0,   361,   362,   363,   364,   365,     0,   366,
     367,     0,   368,   369,   370,     0,     0,   371,     0,   372,
       0,   373,   374,     0,   375,   376,     0,     0,     0,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,     0,
     387,   388,     0,     0,     0,   389,   390,   391,   392,     0,
       0,     0,   393,     0,     0,     0,   394,     0,   395,   396,
     397,   398,     0,   399,   400,   401,   402,   403,     0,     0,
       0,     0,     0,     0,   404,   405,     0,   406,     0,     0,
     407,     0,     0,   408,   409,   410,     0,     0,   411,   412,
       0,   413,   414,   415,   416,   417,   418,     0,     0,   419,
     420,   421,   422,     0,   423,   424,     0,     0,   425,   426,
     427,   428,     0,     0,   429,   430,     0,   431,   432,   433,
     434,     0,     0,     0,     0,     0,   435,   436,     0,     0,
       0,   437,   438,   439,   440,     0,   441,   442,     0,   443,
     444,     0,   445,   446,     0,     0,   447,     0,     0,   448,
       0,   449,     0,   450,   451,     0,     0,     0,     0,     0,
       0,   452,     0,     0,   453,     0,     0,     0,   454,   455,
     456,   457,     0,     0,     0,     0,     0,     0,   458,   459,
       0,   460,   461,   462,     0,     0,   463,     0,     0,   135,
       0,   136,   137,   138,   139,   140,     0,     0,     0,     0,
       0,   141,     0,     0,   142,   511,   143,   144,   145,   146,
     147,   148,   149,     0,   150,     0,     0,     0,   151,     0,
       0,     0,   152,     0,     0,   153,   154,   155,     0,   156,
       0,   157,   158,     0,     0,   159,     0,     0,   160,   161,
       0,   162,   163,     0,   164,     0,   165,   166,   167,   168,
     169,   170,     0,   171,   172,     0,   173,   174,   175,   176,
     177,   178,   179,   180,     0,   181,   182,     0,   183,   184,
     185,   186,   187,     0,   188,     0,     0,   189,     0,     0,
     190,     0,     0,     0,   191,     0,     0,     0,   192,   193,
     194,     0,     0,   195,     0,     0,     0,     0,   196,   197,
       0,     0,     0,     0,   198,     0,   199,     0,     0,     0,
     200,     0,   201,   202,   203,   204,     0,     0,     0,   205,
       0,     0,   206,   207,   208,     0,     0,     0,   209,     0,
     210,   211,     0,   212,   213,   214,     0,     0,   215,   216,
       0,   217,   218,   219,   220,   221,     0,     0,   222,   223,
     224,     0,     0,   225,   226,     0,   227,   228,   229,     0,
       0,   230,     0,     0,     0,   231,     0,   232,     0,   233,
       0,   234,   235,   236,   237,   238,     0,   239,     0,     0,
       0,   240,   241,     0,   242,     0,     0,   243,   244,     0,
       0,     0,   245,   246,   247,   248,     0,     0,   249,   250,
     251,     0,     0,   252,     0,     0,     0,     0,   253,   254,
       0,     0,     0,   255,     0,   256,   257,     0,   258,   259,
       0,     0,     0,   260,     0,     0,   261,   262,     0,     0,
     263,     0,     0,   264,   265,     0,     0,     0,     0,     0,
     266,   267,     0,   268,     0,   269,     0,   270,   271,     0,
       0,     0,     0,     0,     0,     0,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,     0,
     285,   286,   287,     0,   288,   289,   290,   291,     0,   292,
     293,     0,     0,     0,     0,   294,   295,   296,   297,   298,
     299,     0,     0,   300,   301,     0,   302,     0,   303,     0,
     304,   305,   306,   307,   308,   309,   310,   311,   312,     0,
       0,   313,   314,     0,     0,   315,   316,   317,   318,     0,
       0,     0,   319,   320,     0,     0,     0,     0,   321,   322,
     323,     0,   324,   325,   326,     0,   327,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   328,   329,   330,     0,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,     0,     0,   343,   344,   345,     0,   346,     0,
     347,   348,   349,   350,   351,     0,   352,   353,   354,     0,
       0,   355,     0,     0,     0,   356,   357,   358,   359,   360,
       0,     0,   361,   362,   363,   364,   365,     0,   366,   367,
       0,   368,   369,   370,     0,     0,   371,     0,   372,     0,
     373,   374,     0,   375,   376,     0,     0,     0,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,     0,   387,
     388,     0,     0,     0,   389,   390,   391,   392,     0,     0,
       0,   393,     0,     0,     0,   394,     0,   395,   396,   397,
     398,     0,   399,   400,   401,   402,   403,     0,     0,     0,
       0,     0,     0,   404,   405,     0,   406,     0,     0,   407,
       0,     0,   408,   409,   410,     0,     0,   411,   412,     0,
     413,   414,   415,   416,   417,   418,     0,     0,   419,   420,
     421,   422,     0,   423,   424,     0,     0,   425,   426,   427,
     428,     0,     0,   429,   430,     0,   431,   432,   433,   434,
       0,     0,     0,     0,     0,   435,   436,     0,     0,     0,
     437,   438,   439,   440,     0,   441,   442,     0,   443,   444,
       0,   445,   446,     0,     0,   447,     0,     0,   448,     0,
     449,     0,   450,   451,     0,     0,     0,     0,     0,     0,
     452,     0,     0,   453,     0,     0,     0,   454,   455,   456,
     457,     0,     0,     0,     0,     0,     0,   458,   459,     0,
     460,   461,   462,     0,     0,   463,     0,     0,   135,     0,
     136,   137,   138,   139,   140,     0,     0,     0,     0,     0,
     141,     0,     0,   142,   738,   143,   144,   145,   146,   147,
     148,   149,     0,   150,     0,     0,     0,   151,     0,     0,
       0,   152,     0,     0,   153,   154,   155,     0,   156,     0,
     157,   158,     0,     0,   159,     0,     0,   160,   161,     0,
     162,   163,     0,   164,     0,   165,   166,   167,   168,   169,
     170,     0,   171,   172,     0,   173,   174,   175,   176,   177,
     178,   179,   180,     0,   181,   182,     0,   183,   184,   185,
     186,   187,     0,   188,     0,     0,   189,     0,     0,   190,
       0,     0,     0,   191,     0,     0,     0,   192,   193,   194,
       0,     0,   195,     0,     0,     0,     0,   196,   197,     0,
       0,     0,     0,   198,     0,   199,     0,     0,     0,   200,
       0,   201,   202,   203,   204,     0,     0,     0,   205,     0,
       0,   206,   207,   208,     0,     0,     0,   209,     0,   210,
     211,     0,   212,   213,   214,     0,     0,   215,   216,     0,
     217,   218,   219,   220,   221,     0,     0,   222,   223,   224,
       0,     0,   225,   226,     0,   227,   228,   229,     0,     0,
     230,     0,     0,     0,   231,     0,   232,     0,   233,     0,
     234,   235,   236,   237,   238,     0,   239,     0,     0,     0,
     240,   241,     0,   242,     0,     0,   243,   244,     0,     0,
       0,   245,   246,   247,   248,     0,     0,   249,   250,   251,
       0,     0,   252,     0,     0,     0,     0,   253,   254,     0,
       0,     0,   255,     0,   256,   257,     0,   258,   259,     0,
       0,     0,   260,     0,     0,   261,   262,     0,     0,   263,
       0,     0,   264,   265,     0,     0,     0,     0,     0,   266,
     267,     0,   268,     0,   269,     0,   270,   271,     0,     0,
       0,     0,     0,     0,     0,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,     0,   285,
     286,   287,     0,   288,   289,   290,   291,     0,   292,   293,
       0,     0,     0,     0,   294,   295,   296,   297,   298,   299,
       0,     0,   300,   301,     0,   302,     0,   303,     0,   304,
     305,   306,   307,   308,   309,   310,   311,   312,     0,     0,
     313,   314,     0,     0,   315,   316,   317,   318,     0,     0,
       0,   319,   320,     0,     0,     0,     0,   321,   322,   323,
       0,   324,   325,   326,     0,   327,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   328,   329,   330,     0,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,     0,     0,   343,   344,   345,     0,   346,     0,   347,
     348,   349,   350,   351,     0,   352,   353,   354,     0,     0,
     355,     0,     0,     0,   356,   357,   358,   359,   360,     0,
       0,   361,   362,   363,   364,   365,     0,   366,   367,     0,
     368,   369,   370,     0,     0,   371,     0,   372,     0,   373,
     374,     0,   375,   376,     0,     0,     0,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,     0,   387,   388,
       0,     0,     0,   389,   390,   391,   392,     0,     0,     0,
     393,     0,     0,     0,   394,     0,   395,   396,   397,   398,
       0,   399,   400,   401,   402,   403,     0,     0,     0,     0,
       0,     0,   404,   405,     0,   406,     0,     0,   407,     0,
       0,   408,   409,   410,     0,     0,   411,   412,     0,   413,
     414,   415,   416,   417,   418,     0,     0,   419,   420,   421,
     422,     0,   423,   424,     0,     0,   425,   426,   427,   428,
       0,     0,   429,   430,     0,   431,   432,   433,   434,     0,
       0,     0,     0,     0,   435,   436,     0,     0,     0,   437,
     438,   439,   440,     0,   441,   442,     0,   443,   444,     0,
     445,   446,     0,     0,   447,     0,     0,   448,     0,   449,
       0,   450,   451,     0,     0,     0,     0,     0,     0,   452,
       0,     0,   453,     0,     0,     0,   454,   455,   456,   457,
       0,     0,     0,     0,     0,     0,   458,   459,     0,   460,
     461,   462,     0,     0,   463,     0,     0,   135,     0,   136,
     137,   138,   139,   140,     0,     0,     0,     0,     0,   141,
       0,     0,   142,  2413,   143,   144,   145,   146,   147,   148,
     149,     0,   150,     0,     0,     0,   151,     0,     0,     0,
     152,     0,     0,   153,   154,   155,     0,   156,     0,   157,
     158,     0,     0,   159,     0,     0,   160,   161,     0,   162,
     163,     0,   164,     0,   165,   166,   167,   168,   169,   170,
       0,   171,   172,     0,   173,   174,   175,   176,   177,   178,
     179,   180,     0,   181,   182,     0,   183,   184,   185,   186,
     187,     0,   188,     0,     0,   189,     0,     0,   190,     0,
       0,     0,   191,     0,     0,     0,   192,   193,   194,     0,
       0,   195,     0,     0,     0,     0,   196,   197,     0,     0,
       0,     0,   198,     0,   199,     0,     0,     0,   200,     0,
     201,   202,   203,   204,     0,     0,     0,   205,     0,     0,
     206,   207,   208,     0,     0,     0,   209,     0,   210,   211,
       0,   212,   213,   214,     0,     0,   215,   216,     0,   217,
     218,   219,   220,   221,     0,     0,   222,   223,   224,     0,
       0,   225,   226,     0,   227,   228,   229,     0,     0,   230,
       0,     0,     0,   231,     0,   232,     0,   233,     0,   234,
     235,   236,   237,   238,     0,   239,     0,     0,     0,   240,
     241,     0,   242,     0,     0,   243,   244,     0,     0,     0,
     245,   246,   247,   248,     0,     0,   249,   250,   251,     0,
       0,   252,     0,     0,     0,     0,   253,   254,     0,     0,
       0,   255,     0,   256,   257,     0,   258,   259,     0,     0,
       0,   260,     0,     0,   261,   262,     0,     0,   263,     0,
       0,   264,   265,   589,     0,     0,     0,     0,   266,   267,
       0,   268,     0,   269,     0,   270,   271,     0,     0,     0,
       0,     0,     0,     0,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,     0,   285,   286,
     287,     0,   288,   289,   290,   291,     0,   292,   293,     0,
       0,     0,     0,   294,   295,   296,   297,   298,   299,     0,
       0,   300,   301,     0,   302,     0,   303,     0,   304,   305,
     306,   307,   308,   309,   310,   311,   312,     0,     0,   313,
     314,     0,     0,   315,   316,   317,   318,     0,     0,     0,
     319,   320,     0,     0,     0,     0,   321,   322,   323,     0,
     324,   325,   326,     0,   327,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   328,   329,   330,     0,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
       0,     0,   343,   344,   345,     0,   346,     0,   347,   348,
     349,   350,   351,     0,   352,   353,   354,     0,     0,   355,
       0,     0,     0,   356,   357,   358,   359,   360,     0,     0,
     361,   362,   363,   364,   365,     0,   366,   367,     0,   368,
     369,   370,     0,     0,   371,     0,   372,     0,   373,   374,
       0,   375,   376,     0,     0,     0,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,     0,   387,   388,     0,
       0,     0,   389,   390,   391,   392,     0,     0,     0,   393,
       0,     0,     0,   394,     0,   395,   396,   397,   398,     0,
     399,   400,   401,   402,   403,     0,     0,     0,     0,     0,
       0,   404,   405,     0,   406,     0,     0,   407,     0,     0,
     408,   409,   410,     0,     0,   411,   412,     0,   413,   414,
     415,   416,   417,   418,     0,     0,   419,   420,   421,   422,
       0,   423,   424,     0,     0,   425,   426,   427,   428,     0,
     132,   429,   430,     0,   431,   432,   433,   434,     0,     0,
       0,     0,     0,   435,   436,     0,     0,     0,   437,   438,
     439,   440,     0,   441,   442,     0,   443,   444,     0,   445,
     446,     0,     0,   447,     0,     0,   448,     0,   449,     0,
     450,   451,     0,     0,     0,     0,     0,     0,   452,     0,
       0,   453,     0,     0,     0,   454,   455,   456,   457,     0,
       0,     0,     0,     0,     0,   458,   459,     0,   460,   461,
     462,     0,     0,   463,     0,   135,     0,   136,   137,   138,
     139,   140,     0,     0,     0,     0,     0,   141,     0,     0,
     142,  1607,   143,   144,   145,   146,   147,   148,   149,     0,
     150,     0,     0,     0,   151,     0,     0,     0,   152,     0,
       0,   153,   154,   155,     0,   156,     0,   157,   158,     0,
       0,   159,     0,     0,   160,   161,     0,   162,   163,     0,
     164,     0,   165,   166,   167,   168,   169,   170,     0,   171,
     172,     0,   173,   174,   175,   176,   177,   178,   179,   180,
       0,   181,   182,     0,   183,   184,   185,   186,   187,     0,
     188,     0,     0,   189,     0,     0,   190,     0,     0,     0,
     191,     0,     0,     0,   192,   193,   194,     0,     0,   195,
       0,     0,     0,     0,   196,   197,     0,     0,     0,     0,
     198,     0,   199,     0,     0,     0,   200,     0,   201,   202,
     203,   204,     0,     0,     0,   205,     0,     0,   206,   207,
     208,     0,     0,     0,   209,     0,   210,   211,     0,   212,
     213,   214,     0,     0,   215,   216,     0,   217,   218,   219,
     220,   221,     0,     0,   222,   223,   224,     0,     0,   225,
     226,     0,   227,   228,   229,     0,     0,   230,     0,     0,
       0,   231,     0,   232,     0,   233,     0,   234,   235,   236,
     237,   238,     0,   239,     0,     0,     0,   240,   241,     0,
     242,     0,     0,   243,   244,     0,     0,     0,   245,   246,
     247,   248,     0,     0,   249,   250,   251,     0,     0,   252,
       0,     0,     0,     0,   253,   254,     0,     0,     0,   255,
       0,   256,   257,     0,   258,   259,     0,     0,     0,   260,
       0,     0,   261,   262,     0,     0,   263,     0,     0,   264,
     265,   589,     0,     0,     0,     0,   266,   267,     0,   268,
       0,   269,     0,   270,   271,     0,     0,     0,     0,     0,
       0,     0,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,     0,   285,   286,   287,     0,
     288,   289,   290,   291,     0,   292,   293,     0,     0,     0,
       0,   294,   295,   296,   297,   298,   299,     0,     0,   300,
     301,     0,   302,     0,   303,     0,   304,   305,   306,   307,
     308,   309,   310,   311,   312,     0,     0,   313,   314,     0,
       0,   315,   316,   317,   318,     0,     0,     0,   319,   320,
       0,     0,     0,     0,   321,   322,   323,     0,   324,   325,
     326,     0,   327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   328,   329,   330,     0,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,     0,     0,
     343,   344,   345,     0,   346,     0,   347,   348,   349,   350,
     351,     0,   352,   353,   354,     0,     0,   355,     0,     0,
       0,   356,   357,   358,   359,   360,     0,     0,   361,   362,
     363,   364,   365,     0,   366,   367,     0,   368,   369,   370,
       0,     0,   371,     0,   372,     0,   373,   374,     0,   375,
     376,     0,     0,     0,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,     0,   387,   388,     0,     0,     0,
     389,   390,   391,   392,     0,     0,     0,   393,     0,     0,
       0,   394,     0,   395,   396,   397,   398,     0,   399,   400,
     401,   402,   403,     0,     0,     0,     0,     0,     0,   404,
     405,     0,   406,     0,     0,   407,     0,     0,   408,   409,
     410,     0,     0,   411,   412,     0,   413,   414,   415,   416,
     417,   418,     0,     0,   419,   420,   421,   422,     0,   423,
     424,     0,     0,   425,   426,   427,   428,     0,   132,   429,
     430,     0,   431,   432,   433,   434,     0,     0,     0,     0,
       0,   435,   436,     0,     0,     0,   437,   438,   439,   440,
       0,   441,   442,     0,   443,   444,     0,   445,   446,     0,
       0,   447,     0,     0,   448,     0,   449,     0,   450,   451,
       0,     0,     0,     0,     0,     0,   452,     0,     0,   453,
       0,     0,     0,   454,   455,   456,   457,     0,     0,     0,
       0,     0,     0,   458,   459,     0,   460,   461,   462,     0,
       0,   463,     0,   135,     0,   136,   137,   138,   139,   140,
       0,     0,     0,     0,     0,   141,     0,     0,   142,  2682,
     143,   144,   145,   146,   147,   148,   149,     0,   150,     0,
       0,     0,   151,     0,     0,     0,   152,     0,     0,   153,
     154,   155,     0,   156,     0,   157,   158,     0,     0,   159,
       0,     0,   160,   161,     0,   162,   163,     0,   164,     0,
     165,   166,   167,   168,   169,   170,     0,   171,   172,     0,
     173,   174,   175,   176,   177,   178,   179,   180,     0,   181,
     182,     0,   183,   184,   185,   186,   187,     0,   188,     0,
       0,   189,     0,     0,   190,     0,     0,     0,   191,     0,
       0,     0,   192,   193,   194,     0,     0,   195,     0,     0,
       0,     0,   196,   197,     0,     0,     0,     0,   198,     0,
     199,     0,     0,     0,   200,     0,   201,   202,   203,   204,
       0,     0,     0,   205,     0,     0,   206,   207,   208,     0,
       0,     0,   209,     0,   210,   211,     0,   212,   213,   214,
       0,     0,   215,   216,     0,   217,   218,   219,   220,   221,
       0,     0,   222,   223,   224,     0,     0,   225,   226,     0,
     227,   228,   229,     0,     0,   230,     0,     0,     0,   231,
       0,   232,     0,   233,     0,   234,   235,   236,   237,   238,
       0,   239,     0,     0,     0,   240,   241,     0,   242,     0,
       0,   243,   244,     0,     0,     0,   245,   246,   247,   248,
       0,     0,   249,   250,   251,     0,     0,   252,     0,     0,
       0,     0,   253,   254,     0,     0,     0,   255,     0,   256,
     257,     0,   258,   259,     0,     0,     0,   260,     0,     0,
     261,   262,     0,     0,   263,     0,     0,   264,   265,   589,
       0,     0,     0,     0,   266,   267,     0,   268,     0,   269,
       0,   270,   271,     0,     0,     0,     0,     0,     0,     0,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,     0,   285,   286,   287,     0,   288,   289,
     290,   291,     0,   292,   293,     0,     0,     0,     0,   294,
     295,   296,   297,   298,   299,     0,     0,   300,   301,     0,
     302,     0,   303,     0,   304,   305,   306,   307,   308,   309,
     310,   311,   312,     0,     0,   313,   314,     0,     0,   315,
     316,   317,   318,     0,     0,     0,   319,   320,     0,     0,
       0,     0,   321,   322,   323,     0,   324,   325,   326,     0,
     327,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     328,   329,   330,     0,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,     0,     0,   343,   344,
     345,     0,   346,     0,   347,   348,   349,   350,   351,     0,
     352,   353,   354,     0,     0,   355,     0,     0,     0,   356,
     357,   358,   359,   360,     0,     0,   361,   362,   363,   364,
     365,     0,   366,   367,     0,   368,   369,   370,     0,     0,
     371,     0,   372,     0,   373,   374,     0,   375,   376,     0,
       0,     0,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,     0,   387,   388,     0,     0,     0,   389,   390,
     391,   392,     0,     0,     0,   393,     0,     0,     0,   394,
       0,   395,   396,   397,   398,     0,   399,   400,   401,   402,
     403,     0,     0,     0,     0,     0,     0,   404,   405,     0,
     406,     0,     0,   407,     0,     0,   408,   409,   410,     0,
       0,   411,   412,     0,   413,   414,   415,   416,   417,   418,
       0,     0,   419,   420,   421,   422,     0,   423,   424,     0,
       0,   425,   426,   427,   428,     0,   132,   429,   430,     0,
     431,   432,   433,   434,     0,     0,     0,     0,     0,   435,
     436,     0,     0,     0,   437,   438,   439,   440,     0,   441,
     442,     0,   443,   444,     0,   445,   446,     0,     0,   447,
       0,     0,   448,     0,   449,     0,   450,   451,     0,     0,
       0,     0,     0,     0,   452,     0,     0,   453,     0,     0,
       0,   454,   455,   456,   457,     0,     0,     0,     0,     0,
       0,   458,   459,     0,   460,   461,   462,     0,     0,   463,
       0,   135,     0,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,  3291,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3705,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3706,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,     0,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3707,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3708,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3709,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3710,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3711,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3712,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
    4230,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,  2006,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,  2670,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,  2972,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,  3296,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,  2327,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,  2328,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,  2329,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,  2330,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,   981,   982,     0,   319,
     320,     0,     0,  2331,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,  4210,   536,  4211,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,  2332,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,  2521,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  2676,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,  2149,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,  2150,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,  1767,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,  1768,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,   695,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,  1769,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,  2684,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  2685,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,  2521,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
    2676,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,   940,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,  1311,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,   918,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,   919,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   920,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,  2521,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  2724,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,   589,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,   589,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,   132,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,  2666,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
    4128,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,  4129,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,   536,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,  1017,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,  1929,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
    2260,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,  2261,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,  2762,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,  2840,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,   132,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
    2260,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,   228,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,   149,     0,   150,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,   157,   158,     0,     0,   159,     0,     0,
     160,   161,     0,   162,   163,     0,   164,     0,   165,   166,
     167,   168,   169,   170,     0,   171,   172,     0,   173,   174,
     175,   176,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,   186,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,   197,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,   205,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,   210,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,   221,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,   230,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,   240,   241,     0,   242,     0,     0,   243,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,   254,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,   261,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,   319,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,   326,     0,   327,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   328,   329,
     330,     0,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,     0,     0,   343,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,   367,     0,   368,   369,   370,     0,     0,   371,     0,
     372,     0,   373,   374,     0,   375,   376,     0,     0,     0,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
       0,   387,   388,     0,     0,     0,   389,   390,   391,   392,
       0,     0,     0,   393,     0,     0,     0,   394,     0,   395,
     396,   397,   398,     0,   399,   400,   401,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,   409,   410,     0,     0,   411,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,   437,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,   445,   446,     0,     0,   447,     0,     0,
     448,     0,   449,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
     459,     0,   460,   461,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,   149,
       0,   150,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,   157,   158,
       0,     0,   159,     0,     0,   160,   161,     0,   162,   163,
       0,   164,     0,   165,   166,   167,   168,   169,   170,     0,
     171,   172,     0,   173,   174,   175,   176,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,   186,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,   197,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,   205,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,   210,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,   221,     0,     0,   222,   223,   224,     0,     0,
     225,   226,     0,   227,  1688,   229,     0,     0,   230,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,   240,   241,
       0,   242,     0,     0,   243,   244,     0,     0,     0,   245,
     246,   247,   248,     0,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,   254,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,     0,     0,     0,
     260,     0,     0,   261,   262,     0,     0,   263,     0,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
       0,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,  1689,   317,   318,     0,     0,     0,   319,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,   326,     0,   327,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   328,   329,   330,     0,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,     0,
       0,   343,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,   367,     0,   368,   369,
     370,     0,     0,   371,     0,   372,     0,   373,   374,     0,
     375,   376,     0,     0,     0,   377,   378,   379,   380,   381,
     382,   383,   384,   385,   386,     0,   387,   388,     0,     0,
       0,   389,   390,   391,   392,     0,     0,     0,   393,     0,
       0,     0,   394,     0,   395,   396,   397,   398,     0,   399,
     400,   401,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
     409,   410,     0,     0,   411,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,   437,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,   445,   446,
       0,     0,   447,     0,     0,   448,     0,   449,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
       0,     0,     0,     0,   458,   459,     0,   460,   461,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3705,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3706,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,  -297,  -297,
     209,     0,  -297,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3707,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3708,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3709,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3710,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3711,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3712,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3705,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3706,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,  -318,     0,   209,     0,  -318,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3707,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3708,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3709,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3710,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3711,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3712,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,  -318,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3705,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3706,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,  -315,     0,
     209,     0,  -315,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3707,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3708,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3709,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3710,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3711,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3712,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,  -315,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3705,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3706,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,  4026,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3707,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3708,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3709,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3710,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3711,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3712,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3705,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3706,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,  -320,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3707,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3708,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3709,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3710,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3711,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3712,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3705,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3706,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,  4133,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3707,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3708,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3709,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3710,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3711,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3712,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3705,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3706,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,  4179,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3707,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3708,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3709,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3710,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3711,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3712,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3705,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3706,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,  -301,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3707,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3708,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3709,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3710,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3711,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3712,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,   448,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,  -327,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,  3705,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,  3706,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,     0,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,  3707,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,  3708,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,  3709,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,  3710,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,  -282,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,  3711,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,  -282,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,  3712,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,  -282,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,   135,   463,   136,   137,
     138,   139,   140,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,   143,   144,   145,   146,   147,   148,     0,
       0,  -327,     0,     0,     0,   151,     0,     0,     0,   152,
       0,     0,   153,   154,   155,     0,   156,     0,     0,     0,
       0,     0,   159,  3705,     0,   160,   161,     0,   162,     0,
       0,     0,     0,   165,   166,   167,  3706,   169,   170,     0,
     171,   172,     0,   173,     0,   175,     0,   177,   178,   179,
     180,     0,   181,   182,     0,   183,   184,   185,     0,   187,
       0,   188,     0,     0,   189,     0,     0,   190,     0,     0,
       0,   191,     0,     0,     0,   192,   193,   194,     0,     0,
     195,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,   198,     0,   199,     0,     0,     0,   200,     0,   201,
     202,   203,   204,     0,     0,     0,     0,     0,     0,   206,
     207,   208,     0,     0,     0,   209,     0,     0,   211,     0,
     212,   213,   214,     0,     0,   215,   216,     0,   217,   218,
     219,   220,     0,     0,     0,   222,   223,   224,     0,     0,
     225,   226,  3707,   227,   228,   229,     0,     0,     0,     0,
       0,     0,   231,     0,   232,     0,   233,     0,   234,   235,
     236,   237,   238,     0,   239,     0,     0,     0,     0,   241,
       0,     0,     0,     0,     0,   244,     0,     0,     0,   245,
     246,   247,   248,  3708,     0,   249,   250,   251,     0,     0,
     252,     0,     0,     0,     0,   253,     0,     0,     0,     0,
     255,     0,   256,   257,     0,   258,   259,  3709,     0,     0,
     260,     0,     0,     0,   262,     0,     0,   263,  3710,     0,
     264,   265,     0,     0,     0,     0,     0,   266,   267,     0,
     268,     0,   269,     0,   270,   271,     0,     0,     0,     0,
    -282,     0,     0,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,     0,   285,   286,   287,
       0,   288,   289,   290,   291,     0,   292,   293,     0,     0,
       0,     0,   294,   295,   296,   297,   298,   299,     0,     0,
     300,   301,     0,   302,     0,   303,     0,   304,   305,   306,
     307,   308,   309,   310,   311,   312,     0,     0,   313,   314,
       0,     0,   315,   316,   317,   318,     0,     0,     0,     0,
     320,     0,     0,     0,     0,   321,   322,   323,     0,   324,
     325,  3711,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   329,   330,     0,     0,   332,   333,
     334,     0,   336,   337,   338,   339,   340,   341,     0,     0,
       0,     0,   344,   345,     0,   346,     0,   347,   348,   349,
     350,   351,     0,   352,   353,   354,     0,     0,   355,     0,
       0,     0,   356,   357,   358,   359,   360,     0,     0,   361,
     362,   363,   364,   365,     0,   366,     0,     0,   368,     0,
     370,  -282,     0,   371,     0,     0,     0,   373,     0,     0,
     375,   376,  3712,     0,     0,     0,   378,   379,   380,   381,
     382,   383,     0,   385,   386,     0,   387,     0,     0,     0,
       0,   389,   390,   391,     0,     0,     0,     0,   393,     0,
       0,     0,   394,     0,     0,   396,     0,   398,     0,   399,
       0,     0,   402,   403,     0,     0,     0,     0,     0,     0,
     404,   405,     0,   406,     0,     0,   407,     0,     0,   408,
       0,   410,     0,     0,     0,   412,     0,   413,   414,   415,
     416,   417,   418,     0,     0,   419,   420,   421,   422,     0,
     423,   424,     0,     0,   425,   426,   427,   428,     0,     0,
     429,   430,     0,   431,   432,   433,   434,     0,     0,     0,
       0,     0,   435,   436,     0,     0,     0,     0,   438,   439,
     440,     0,   441,   442,     0,   443,   444,     0,     0,     0,
       0,     0,   447,     0,     0,  4029,     0,     0,     0,   450,
     451,     0,     0,     0,     0,     0,     0,   452,     0,     0,
     453,     0,     0,     0,   454,   455,   456,   457,     0,     0,
    -282,     0,     0,     0,   458,     0,     0,   460,     0,   462,
       0,   135,   463,   136,   137,   138,   139,   140,     0,     0,
       0,     0,     0,   141,     0,     0,     0,     0,   143,   144,
     145,   146,   147,   148,     0,     0,     0,     0,     0,     0,
     151,     0,     0,     0,   152,     0,     0,   153,   154,   155,
       0,   156,     0,     0,     0,     0,     0,   159,     0,     0,
     160,   161,     0,   162,     0,     0,     0,     0,   165,   166,
     167,     0,   169,   170,     0,   171,   172,     0,   173,     0,
     175,     0,   177,   178,   179,   180,     0,   181,   182,     0,
     183,   184,   185,     0,   187,     0,   188,     0,     0,   189,
       0,     0,   190,     0,     0,     0,   191,     0,     0,     0,
     192,   193,   194,     0,     0,   195,     0,     0,     0,     0,
     196,     0,     0,     0,     0,     0,   198,     0,   199,     0,
       0,     0,   200,     0,   201,   202,   203,   204,     0,     0,
       0,     0,     0,     0,   206,   207,   208,     0,     0,     0,
     209,     0,     0,   211,     0,   212,   213,   214,     0,     0,
     215,   216,     0,   217,   218,   219,   220,     0,     0,     0,
     222,   223,   224,     0,     0,   225,   226,     0,   227,   228,
     229,     0,     0,     0,     0,     0,     0,   231,     0,   232,
       0,   233,     0,   234,   235,   236,   237,   238,     0,   239,
       0,     0,     0,     0,   241,     0,     0,     0,     0,     0,
     244,     0,     0,     0,   245,   246,   247,   248,     0,     0,
     249,   250,   251,     0,     0,   252,     0,     0,     0,     0,
     253,     0,     0,     0,     0,   255,     0,   256,   257,     0,
     258,   259,     0,     0,     0,   260,     0,     0,     0,   262,
       0,     0,   263,     0,     0,   264,   265,     0,     0,     0,
       0,     0,   266,   267,     0,   268,     0,   269,     0,   270,
     271,     0,     0,     0,     0,     0,     0,     0,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,     0,   285,   286,   287,     0,   288,   289,   290,   291,
       0,   292,   293,     0,     0,     0,     0,   294,   295,   296,
     297,   298,   299,     0,     0,   300,   301,     0,   302,     0,
     303,     0,   304,   305,   306,   307,   308,   309,   310,   311,
     312,     0,     0,   313,   314,     0,     0,   315,   316,   317,
     318,     0,     0,     0,     0,   320,     0,     0,     0,     0,
     321,   322,   323,     0,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   329,
     330,     0,     0,   332,   333,   334,     0,   336,   337,   338,
     339,   340,   341,     0,     0,     0,     0,   344,   345,     0,
     346,     0,   347,   348,   349,   350,   351,     0,   352,   353,
     354,     0,     0,   355,     0,     0,     0,   356,   357,   358,
     359,   360,     0,     0,   361,   362,   363,   364,   365,     0,
     366,     0,     0,   368,     0,   370,     0,     0,   371,     0,
       0,     0,   373,     0,     0,   375,   376,     0,     0,     0,
       0,   378,   379,   380,   381,   382,   383,     0,   385,   386,
       0,   387,     0,     0,     0,     0,   389,   390,   391,     0,
       0,     0,     0,   393,     0,     0,     0,   394,     0,     0,
     396,     0,   398,     0,   399,     0,     0,   402,   403,     0,
       0,     0,     0,     0,     0,   404,   405,     0,   406,     0,
       0,   407,     0,     0,   408,     0,   410,     0,     0,     0,
     412,     0,   413,   414,   415,   416,   417,   418,     0,     0,
     419,   420,   421,   422,     0,   423,   424,     0,     0,   425,
     426,   427,   428,     0,     0,   429,   430,     0,   431,   432,
     433,   434,     0,     0,     0,     0,     0,   435,   436,     0,
       0,     0,     0,   438,   439,   440,     0,   441,   442,     0,
     443,   444,     0,     0,     0,     0,     0,   447,     0,     0,
     448,     0,     0,     0,   450,   451,     0,     0,     0,     0,
       0,     0,   452,     0,     0,   453,     0,     0,     0,   454,
     455,   456,   457,     0,     0,     0,     0,     0,     0,   458,
       0,     0,   460,     0,   462,     0,     0,   463
};

static const yytype_int16 yycheck[] =
{
       6,   612,   549,   621,   622,   549,   933,   654,   655,   121,
     571,   934,   850,    19,   659,  1115,    22,  1604,  1739,  1115,
    1021,  1413,    20,     6,  1062,    31,  1086,  1707,   769,   639,
     585,    29,    38,  1015,  1016,    41,   494,    35,   678,    45,
    2263,  2264,  2265,  1314,   691,   876,  1239,    53,   898,  2379,
    1957,  1178,  1726,  1411,  1137,   874,  2185,  1394,  2230,  2309,
    2022,  1144,  2701,  3064,   711,  2027,  2649,   898,   713,  1053,
    2498,   716,  2001,   938,  1920,   938,   723,   724,   725,     4,
     899,  1865,  1245,    22,  1402,  1145,  1146,    93,  2297,  1149,
    1150,  1151,  1152,  2484,  1154,  1155,  1156,  1157,  1158,  1159,
    1160,  1161,  1325,   608,   609,  2114,  1867,  1726,   626,   115,
    1796,   117,  1982,  2832,   120,   121,   122,  3281,  1455,  2374,
    1343,   731,   732,   733,  2253,  2157,  1868,  1982,  1351,  1352,
    1872,   742,  2290,   743,   117,    18,  1865,   120,  2274,  2275,
    2298,  1883,  2512,     9,   833,  2353,  2516,    24,  3127,  3128,
    2954,  1893,  3131,  1384,    93,  1848,    16,    46,  1820,  1821,
      16,   127,    28,  3328,    15,    16,    15,    16,    34,  3088,
      33,  3150,  1839,    67,    59,  1837,    18,  3156,    73,  2005,
      35,    35,    50,  3070,    58,    59,    70,  2108,   900,    29,
    1737,   105,  1854,  1855,   123,   142,   142,  2166,  1982,    15,
      16,   155,    73,    64,  2486,    18,  3741,   165,  1870,  1871,
     165,  1873,  2342,   136,  1876,  1877,   771,  2642,  1880,    15,
      16,    15,    16,  1885,  2356,   914,  3338,  1889,  1890,  1891,
    1892,   252,    20,   152,  1896,  1811,  1898,  2338,  2339,  2460,
     142,   269,  1904,    61,   297,  1907,    67,  1909,    33,   191,
    1943,    65,  3860,  1982,   326,  1948,    81,  2752,   165,    20,
     213,  1954,  1955,   350,   130,   148,  1959,  1394,    79,   152,
      58,    59,    33,   828,  2243,   237,  3277,   204,    57,    77,
     103,  2515,   345,  3829,  1857,   119,    47,   131,   148,    15,
      16,   182,    61,   940,  1971,    73,    68,    58,    59,    20,
     356,   286,   237,   217,  1966,  1967,  1968,  1969,    15,    16,
     152,    18,    33,   248,   148,    15,    16,   259,    24,     8,
     182,   254,   148,   447,   257,  3682,    47,   371,  1455,  3864,
     447,   614,  3977,    74,   463,  3980,   227,    58,    59,   152,
      19,   518,   219,  2567,   239,  2636,   201,   201,   813,   119,
     182,  2452,  2453,  2282,   259,    15,    16,    15,    16,    15,
      16,    15,    16,    15,    16,   549,   561,   479,   239,   412,
     159,   465,   123,   119,   217,   993,   994,   995,   148,     8,
      62,  3500,   182,    45,   121,  3364,   165,   213,   336,   489,
     169,   538,   420,   493,  3373,   106,   185,   240,   109,   481,
      29,   180,   148,   515,    15,    16,    15,    16,   393,   604,
     179,   518,  1052,  3392,   561,   610,   293,  3536,  3397,   603,
     502,   253,    39,  2249,   553,  1065,    15,    16,   270,  2720,
     230,   178,   609,   381,  1175,   340,   394,   531,   221,   394,
      50,  1364,   485,   217,   150,   124,   518,   230,   322,    15,
      16,  3615,   917,  4098,    15,    16,   182,   962,   302,   270,
    2683,   239,   395,   592,  3821,   356,   213,   429,   421,   137,
     332,   543,   223,   479,   518,   481,    15,    16,   602,   178,
     465,    15,    16,   766,   173,   602,  4094,   394,    15,    16,
    3491,  1883,   498,  2716,    15,    16,   502,   371,   433,  2708,
    1319,   286,  1839,  1322,   355,   511,  2296,   358,  1327,   515,
     452,   517,  2358,   219,   213,    70,  2362,    15,    16,  1384,
    2770,  1384,   301,   610,   530,  4071,  4072,  1654,  1865,  1140,
    2376,  2377,   455,   270,  1353,  1354,   198,   456,  1148,   355,
    2386,   604,   358,  2751,  1233,  1376,  2754,  2755,   604,   602,
    3437,   579,   558,   235,    50,  1165,   398,   578,  2342,   355,
     428,   355,   358,   490,   358,  2773,  2412,  1790,   393,  1258,
     576,  2500,  1632,    15,    16,  3687,  1034,  1035,   361,   585,
    3005,   587,  3077,  1643,   398,   357,  1646,   293,   406,  1454,
    2460,  1454,   598,   599,  1912,   421,   490,  1055,   604,  2881,
     606,   559,   608,   609,   465,  2460,  1064,   613,   614,  3248,
    2303,  2741,   618,  2342,   383,   394,   599,  2749,  1076,  1077,
    1078,   575,   628,   629,   630,  4160,   555,  1085,   634,   355,
     577,   577,   358,   339,  1971,  2856,  2482,  1349,  2607,  2608,
    2609,   507,  1626,   538,   442,  1982,   604,  2568,   355,   604,
    3537,   358,   559,  1394,  2321,   355,   768,   623,   358,   598,
     526,  3826,  1217,   518,   518,   604,   561,   533,  2361,   490,
    2363,  2497,   678,   529,   588,   577,  2460,  2370,  1183,    15,
      16,    15,    16,   568,  2653,  2654,  2655,    15,    16,   529,
    2383,   580,  3856,   559,  3613,   355,  2389,   355,   358,   355,
     358,   355,   358,   355,   358,  2877,   358,  2369,  2255,   580,
     561,  2404,  1839,  2289,  1455,  3519,   529,    10,   602,  2381,
     580,    15,    16,    15,    16,   608,  1281,   604,  2657,  2658,
     736,  2460,   738,  2426,  1965,   609,   604,  1242,   589,   602,
     589,  3111,  3629,   585,   355,  2777,   355,   358,   608,   358,
     573,  1440,  1257,   604,  2855,   183,   762,   763,   764,   547,
     766,   767,   768,   875,   770,   771,   355,  2340,  1323,   358,
    3657,  2451,  2996,   589,   608,  3145,  2999,  2454,   440,   447,
     763,   550,   608,  3153,   767,  1303,   547,   770,   494,   355,
    3160,   607,   358,   589,   355,   589,  2458,   358,    15,    16,
     541,   255,   808,  3967,   555,    15,    16,   603,   604,   603,
     604,   522,   818,   560,   525,  3038,   355,   499,   428,   358,
     603,   355,   828,   829,   358,   604,   547,   833,   355,   138,
    3002,   358,   387,  2191,   355,    15,    16,   358,   608,    15,
      16,  1388,   338,  3067,  1971,  3054,  3101,    15,    16,  3058,
     571,  3830,   152,  3832,    55,  1982,   286,   355,    15,    16,
     358,   560,   608,   589,    15,    16,  3074,   484,   574,   875,
    2591,  3758,    15,    16,   369,  3109,  3110,   148,   604,   818,
     180,   602,   589,  3117,   339,  3014,  3120,  3121,   505,   589,
     829,  3610,  3320,   119,    15,    16,  3054,   822,   604,   185,
    3058,   430,   490,  3137,   604,  2626,    15,    16,   914,   775,
    1550,   148,    42,   355,   531,   374,   358,  3151,   185,  2709,
    2710,   441,  3156,  3157,  3158,  3159,    15,    16,   934,   589,
      31,   589,   428,   589,   602,   589,  1786,   589,   606,   367,
      24,    15,    16,   603,   604,  1463,   604,   603,   604,   603,
     604,   603,  2632,    40,   509,  1786,   962,  2741,  2887,   455,
    1779,  2826,   583,  2355,  2356,   423,  1816,  2405,   353,  3395,
    1789,  3972,  3398,  1792,  1793,   219,  2650,   532,   589,   102,
     589,   569,   253,   437,  2321,  1816,  2856,   150,  3875,    15,
      16,  2051,   603,   604,   603,   604,    15,    16,   116,   168,
     589,  2856,   117,  2274,  2275,  2342,  2007,  1013,    15,    16,
    3897,  1017,  2741,  2699,   603,  1127,   253,   253,   116,   355,
     485,   355,   358,   589,   358,   465,  3452,   355,   589,   180,
     358,  2650,  1650,    15,    16,  1645,   464,   603,   604,    68,
    3049,  3010,  3433,   604,   131,  2128,  1052,   447,  2211,  2810,
     589,   360,  1164,    15,    16,   589,   219,    15,    16,  1065,
    2283,   355,   589,   355,   358,   604,   358,   194,   589,  2811,
     604,  3207,  2856,   182,  1013,    15,    16,   604,  1017,  3507,
     203,   610,  3305,   604,  1702,    12,  1726,  2767,  3203,  3204,
    2408,   589,   385,   621,   622,   339,  2134,  2135,  1839,   385,
    1965,    11,  1965,  3312,  3313,  1660,   604,   602,  2301,  1115,
     237,    15,    16,   228,  2701,   341,   135,  2454,   385,   574,
     356,  1127,   133,  2460,    15,    16,    22,  2856,   157,   230,
    2230,  3325,   326,   325,  3063,   219,  1248,   338,   355,  2199,
      12,   358,   512,  2127,   198,   355,   604,   589,   358,   267,
     447,   252,   264,  2137,    51,   347,   456,  1662,  1164,   624,
    1715,  1716,   604,  1169,    61,    15,    16,  3750,  1174,   267,
     374,  3810,   341,    15,    16,   355,   339,  1183,   358,   355,
      15,    16,   358,   180,    15,    16,   240,   355,    15,    16,
     358,   484,    15,    16,  2321,   325,    15,    16,   355,  2299,
    1747,   358,   602,  2299,   355,   132,   606,   358,   320,   293,
     120,  1217,   355,    15,    16,   358,   168,   120,  3333,    15,
      16,    15,    16,  1229,   342,  1231,   512,  1233,  3093,   356,
    1971,   270,    15,    16,   355,  1174,  1242,   358,  3084,   362,
     533,  1982,  1248,  4244,   342,   512,   355,   403,   371,   358,
     494,  1257,  1258,   589,   377,   589,   145,  3219,  2616,  3105,
     132,   589,  3456,  3435,   160,   262,   355,   156,   604,   358,
     604,   303,   753,    15,    16,  1281,   604,   253,  1284,  1391,
     573,   355,    15,    16,   358,   400,  1292,     0,  2388,    15,
      16,   182,  2388,    15,    16,   589,    12,   589,  1304,  1305,
    1306,  1307,  1308,  1309,   315,   602,   407,   578,  1314,  1234,
     604,  3505,   604,   549,  1320,  1321,   173,  1323,   370,  2757,
    1326,  1304,  1305,  1306,   518,  1308,   229,  2454,   357,   355,
     574,   494,   358,  2460,   148,   198,   355,   608,  1321,   358,
    1346,   578,   447,  1326,    15,    16,   469,   380,   355,   543,
    2788,   358,    15,    16,    15,    16,   230,  2749,  2796,   398,
     841,  2799,   259,   415,    15,    16,   535,   447,  1307,   561,
    1309,   608,   589,   355,  1299,   249,   358,   240,   490,   589,
     356,   496,   551,   335,   336,  1391,   243,   604,   544,   341,
     120,    15,    16,   355,   604,    57,   358,   355,    80,  1405,
     358,  2839,  1408,  1409,  2741,   447,    12,  1346,   602,   589,
    3660,   574,   213,   589,   253,   355,   132,    99,   358,  2811,
     326,   589,   540,   447,   604,   346,  3541,  3542,   604,  3544,
    3545,   338,   589,   961,  1440,   558,   604,     6,   589,    71,
     152,   604,   540,    15,    16,  3617,   589,   604,   358,   152,
     371,   355,   603,  1459,   358,  1461,  1462,    71,  1464,  1465,
     194,   604,    15,    16,   355,   354,  1405,   358,   589,   270,
    1409,  1477,  1397,  1479,    15,    16,  3709,  3710,  1461,  1462,
     589,   338,   603,  1011,   516,   121,  3179,    56,  3450,    15,
      16,    15,    16,   447,   603,    15,    16,   602,  2499,   229,
     589,    15,    16,   165,  2587,   355,   413,   169,   358,   447,
     542,    15,    16,   355,   603,   589,   358,   356,   180,  2856,
     355,  2131,   602,   358,   355,   512,   132,   358,   355,   603,
    3659,   358,   355,    15,    16,   358,   355,  2637,   487,   358,
      12,  2637,    15,    16,  1550,  1551,   585,   179,    15,    16,
     159,  1663,   604,   355,    12,    76,   358,    78,   120,   355,
     602,   355,   358,   589,   358,   179,   202,   136,   517,  1050,
     589,  2029,   355,    15,    16,   358,  3770,   603,   602,    24,
    2321,   521,   589,   535,  2042,   217,   597,   598,   599,   600,
    2235,  2236,  2237,   394,    15,    16,   603,   518,   119,   551,
    2270,   610,   221,   217,  1610,    30,   529,   589,   240,  3803,
     182,   230,   518,   355,    15,    16,   358,  2075,   447,   140,
    1101,   603,   355,  2981,  1105,   358,   240,   589,   517,   355,
     398,   589,   358,   355,   270,    16,   358,   543,   580,   301,
     159,   603,  3549,  3550,   212,   603,  1652,  3327,   602,   589,
      75,   419,   194,   174,  1660,  3878,  1662,  1663,    15,    16,
     132,  3248,   604,  3337,   602,  3995,   185,   116,  1674,   512,
    1676,    15,    16,    73,   132,  1218,  1682,  1683,  1221,  1685,
     191,  1224,   450,   602,   355,   589,  2144,   358,   129,  1695,
    2360,   610,   355,  1699,   355,   358,   602,   358,   589,   603,
     326,    15,    16,   144,   355,   509,  3380,   358,   512,  1715,
    1716,  1717,  1718,  2454,  2384,  2385,   385,   515,   116,  2460,
    1726,   146,   602,  1729,  1730,  1731,   175,    15,    16,  2856,
     610,   355,   394,   209,   358,   211,   565,   566,   370,   589,
    1746,   212,   361,  1682,  1683,   350,  1685,   589,   259,  1755,
     596,   383,   201,   603,   589,   217,  1695,   603,   589,   194,
    1699,   603,   589,    24,   596,   217,   589,   336,   603,   383,
     589,   603,   603,   602,   219,    38,   603,   175,  1717,  1718,
     603,   217,    45,   355,   603,  1791,   358,   589,  1713,   227,
    1729,  1730,  1731,   589,    62,   589,   561,  1803,    46,  4032,
    4033,   603,   355,   201,  1810,   358,   589,   603,  3812,   603,
    3814,  2649,    73,   509,   355,   484,   512,   358,   267,   219,
     603,  2368,    15,    16,   568,  1750,    73,   571,   397,   355,
     399,   355,   358,   182,   358,   355,   270,   348,   358,   604,
    2690,   355,  3358,  3359,   358,   610,  2696,   589,   293,   566,
     447,   355,  1791,  2891,   358,  3371,   589,  3050,   455,  2690,
    3376,   603,   558,   589,   533,  2696,    12,   589,  1980,   267,
     603,  1810,  1984,   355,  2912,  2913,   358,   603,   455,  2698,
     580,   603,   355,  3399,   405,   358,  3402,   608,   355,   150,
     610,   358,   518,   342,   339,  2933,    15,    16,   603,  1824,
    1906,   274,   275,   150,   573,   166,  3006,   556,  1833,  1834,
    2022,    15,    16,   355,  1920,  2027,   358,   543,   589,  1844,
    1845,  1846,  1847,   352,  1849,  1850,   589,   484,   589,   602,
      15,    16,   603,   333,   355,     6,  3207,   358,   589,   339,
     603,   452,   603,  3599,   342,   179,    58,    59,  3641,  3642,
    3643,  3644,   603,   421,   355,   380,    68,   358,   219,   116,
     561,    11,  3062,   335,   336,   589,  3062,   235,   565,   566,
     552,   553,   219,   555,  1980,  2593,   602,   402,  1984,   603,
    1986,   133,   602,  1989,    16,   602,   132,   602,   114,   182,
    1996,  1997,  1998,  1999,   602,  3095,  2002,   521,   355,  3095,
     602,   358,   603,   604,   404,   602,  1989,   602,  2120,   434,
    2650,   355,   603,   604,   358,  4238,  2022,   589,   175,  1944,
    1945,  2027,  1947,    12,  1949,  1950,  1951,  1952,  1953,    33,
     604,  1956,   293,  1958,    15,    16,   589,   410,   411,   602,
    2152,   355,   146,   602,   358,   581,   582,   602,   589,   494,
     603,   603,   604,  3709,  3710,    59,   202,  1996,  1997,  1998,
     610,  3782,   603,   589,   489,   589,   334,   355,   604,   589,
     358,  1683,   333,  1685,   602,   589,   347,   603,   339,  2634,
     603,   604,   208,   603,   602,   589,   333,    95,   518,   603,
    3752,   540,   339,   436,   494,   603,   604,  3079,  3080,   603,
      24,   133,   106,  3783,   602,   109,   602,   589,   603,   604,
     267,    16,   102,   117,  2120,  2856,   589,  1729,  1730,  1731,
     162,   603,   589,   602,  2582,  2680,   494,  3165,  3790,   574,
     603,  3793,  3794,  3795,  3796,   561,   603,   603,   604,  2145,
    3532,  3533,   540,   132,    18,   545,  2152,   589,   602,    73,
     436,    31,  2264,   384,  2266,  2267,   602,   404,    58,    59,
    2166,   603,   355,   315,   604,   358,   353,   510,   589,   159,
     950,   951,   515,   192,   574,  3868,  3276,   509,    20,   305,
    3276,   347,   603,   309,   602,   342,   603,   604,   589,   602,
     316,    33,  2198,  3849,  3850,   185,  2308,  2309,   603,   604,
     602,    11,   603,   602,  3205,    47,   603,   604,   988,   603,
     604,  3891,   220,   202,   602,   558,    58,    59,   486,   603,
     604,    95,   602,  3810,  2230,  3887,  3888,   602,   133,   237,
     573,   499,   589,   494,  3896,   602,   355,  2243,   602,   358,
     248,   116,   166,   603,   604,   589,   603,   494,   603,   604,
    2256,   355,  2258,   133,   358,   603,   604,   602,  2264,   603,
    2266,  2267,   603,   604,   603,   604,   392,  2379,  2274,  2275,
     355,   290,   291,   358,   148,   589,   295,   296,   152,  3935,
     496,   497,   602,   315,   500,   501,   603,   604,   504,   603,
     506,   602,   102,  2299,  3950,   219,   603,   604,   545,   602,
     175,   589,  2308,  2309,   178,  3228,   180,  3963,  3117,   602,
     120,  3120,  3121,   574,   347,   603,    61,   325,   586,   445,
     194,   603,   604,   327,   602,   199,    71,   574,  3137,   603,
     604,  2256,   478,   479,   480,   481,   482,   483,    83,   213,
     142,   143,  2348,   604,   602,   116,   220,  2353,    73,   495,
     230,  2349,  2358,   227,   603,   604,  2362,   604,  2364,   603,
     604,  2359,    87,   237,  4020,   603,   604,  2365,  2374,   293,
    2376,  2377,   252,  2379,   248,   185,  4032,  4033,   602,   253,
    2386,   602,  2388,   540,   603,   604,   603,   604,   262,  2387,
     602,  2397,   267,   602,  2392,   385,   589,   603,   604,  2405,
    2398,  2399,   521,   213,   175,   602,  2412,  2413,   602,   333,
     315,   564,   565,   602,   567,   339,   569,   602,  2424,   602,
    3030,  4077,   603,   604,   602,   433,   458,   459,   603,   604,
     201,  4087,   603,   604,   179,   315,   603,   604,   209,   184,
     602,  2366,  2367,   595,   596,   597,   598,   599,   600,  4170,
     576,   325,   602,   263,   602,   335,   336,    12,  2397,   463,
     603,   604,   602,  2921,   602,   591,  2391,   342,   602,  4125,
     589,  4127,   217,   347,   602,  2481,  2482,   213,   603,   604,
     602,  4137,   356,   603,   604,   589,    41,   495,   602,   478,
     479,   602,   481,   602,   483,   240,   267,  4153,   470,  4155,
     602,  4157,   602,  2961,   589,   602,   495,   602,  4164,    95,
     602,   385,   603,   604,   603,   604,   602,   242,   602,  4175,
     602,   525,   512,   602,  4245,  2450,   602,   407,   603,   604,
     603,   604,   602,    88,   602,  4191,  4192,   602,    93,    25,
      26,    25,  2481,   533,   603,   604,   116,   116,   602,   553,
     119,  4207,  4208,   458,   459,   602,  4212,   773,   602,   433,
      48,   593,   594,   595,   596,   597,   598,   599,   600,  3187,
     494,   342,    58,    59,    60,   385,   603,   604,   458,   459,
     133,   455,    68,   573,    68,   603,   604,    73,   313,    73,
    3650,   471,   603,   604,   264,    81,    48,  2603,   604,   607,
    2606,  2607,  2608,  2609,    61,   175,   175,   603,   604,  2615,
     603,   604,    95,   338,    71,    95,  3471,  3472,   347,   105,
     347,   495,  1102,  1103,   441,   370,    83,  2633,  2634,  3889,
    3890,  2637,   201,   119,   220,   119,   122,   549,   383,  3016,
    3017,  2974,  2975,   453,  2650,  3850,  3569,  2653,  2654,  2655,
     574,   237,  3575,  3257,  3258,   597,   158,   455,  2770,   133,
    2666,   602,   248,   253,   150,   540,  2672,    73,  2674,  3216,
     180,   396,   490,   509,  2680,   549,  2615,   232,   490,   158,
    3780,   264,   149,    82,  3780,   604,   560,   561,   593,   594,
     595,   596,   597,   598,   599,   600,   349,   267,   267,   105,
     510,    33,   512,   148,   578,   547,   580,   603,   505,  1027,
    1028,  1029,   119,   593,   594,   595,   596,   597,   598,   599,
     600,  1039,   179,   105,   609,   567,   568,   184,   473,   603,
     604,   217,     6,   607,   608,   602,   104,   220,   224,   325,
     220,  2666,     4,   446,   150,  2751,   573,   302,  2754,  2755,
     604,  2757,  1070,   239,   237,  1073,   240,   237,   230,   484,
     217,   347,   315,    18,  2770,   248,   370,  2773,   248,   540,
      55,   413,   342,   342,   162,  1093,  1094,   105,   210,  1097,
     604,   604,  2788,   240,   610,    68,    12,   577,   603,   603,
    2796,   132,   518,  2799,   126,     9,   604,   610,  1116,  1117,
     603,   102,  3623,  3624,   603,   550,   292,   116,   602,   364,
     610,   217,   252,  2819,   610,  4020,  2822,   150,   150,   604,
     609,  2827,   154,   264,   310,   264,   264,  2833,   264,    48,
     264,  2837,   604,  2839,   264,   509,   602,   259,   369,   604,
      95,   315,   325,   604,   529,   325,  2771,   433,  2854,   133,
    2833,   335,   336,   604,  2779,   187,   529,   341,   159,    12,
     604,  2867,   152,   347,    54,   604,   175,   347,  2874,   604,
     604,  3971,   204,    63,   230,  3971,  3494,   363,   597,   231,
    2886,   507,    72,  2822,   185,   371,   292,   152,   153,   170,
     604,   180,   201,   148,    84,    85,    86,   152,   554,   383,
     604,  3546,  3547,  3548,   310,   458,   459,  3019,  3831,   495,
     100,   468,  3750,   372,   347,   128,   217,   472,   604,   603,
    4125,   186,  4127,  3035,   604,   180,   383,   333,   152,   152,
     152,   196,   264,  3580,  2859,  2874,   152,   152,   604,   194,
     152,  3762,   152,   152,   199,  3766,   230,   152,  4153,  2955,
     433,   506,   438,   433,   286,   152,   152,  2963,   267,   152,
     152,  3508,   263,   152,   152,   220,   152,   451,   233,   152,
     540,   540,   227,   152,   556,   584,   560,   185,   347,   244,
     347,  2987,   237,   102,   458,   459,  4191,  4192,   347,  4049,
     604,   182,   603,   248,   597,   603,   603,   603,   253,   604,
    3006,  3007,  3823,  3824,  3010,   603,   271,   262,   494,   603,
     603,   182,   495,  3019,   602,   495,   473,   596,    73,  3025,
     549,   456,   603,   603,   510,   603,   603,   513,   603,  3035,
     604,   315,    87,   342,   600,   133,   604,  3043,  2963,   603,
     603,  3602,   595,   596,   597,   598,   599,   600,   604,   603,
     602,   602,   384,   602,  3701,   603,  3062,   578,   529,   218,
     602,   393,   152,   549,   329,   184,   550,    11,  3074,   192,
     325,   182,   127,   501,   610,   182,   408,   603,  3084,   380,
    3086,  4141,   393,   173,   385,   455,   604,   604,   494,  3095,
      46,   180,   347,   550,   426,  3101,   186,  3103,   217,  3105,
     484,   356,   323,   484,   510,  4205,   196,  3219,   484,  4205,
    3654,   484,   484,    71,   304,   446,   370,   370,   604,   593,
     594,   595,   596,   597,   598,   599,   600,   370,  4228,   529,
     385,   321,  4228,   465,   466,  4235,   128,  4060,  4061,  4235,
    4063,  4241,    35,   238,   263,  4241,   510,   238,   510,   128,
     370,    46,   453,   243,   244,   416,   602,   263,   490,   370,
     602,   368,   610,   561,   370,   602,  1484,   476,   370,   370,
     146,  3177,   603,   226,   458,   459,   603,   509,   433,  3291,
     512,   271,   226,   603,   610,   603,  4109,   242,  4111,  4112,
     603,   603,   603,   610,   610,   610,  3202,  3203,  3204,   603,
     455,  3207,   604,   529,   529,   610,   529,   610,   604,   510,
     518,   585,   259,  3219,   515,    46,   109,   315,   152,   602,
     152,   353,   602,   116,    35,   602,   529,   602,   182,   182,
     182,   540,   533,   227,  1552,   182,   234,   342,  1556,   610,
     495,   237,   332,  4166,  3862,  3170,   604,   610,   237,  3860,
     359,   105,   306,   443,  3798,   105,   240,   558,   313,   240,
     610,  1579,   529,   602,   602,  3271,  3378,   352,  3193,   194,
    3276,   518,   573,    18,   430,   168,  4203,   370,   602,   356,
     335,   336,   175,   338,   597,  3291,   602,   133,   610,   228,
     602,   228,   382,   603,   549,   610,   603,   603,   109,   603,
     580,   603,   597,   603,   603,   116,   561,   497,   201,   593,
     594,   595,   596,   597,   598,   599,   600,   603,   347,   213,
     602,   254,   370,   578,   514,   580,   603,  3333,   604,   604,
     603,   610,  3879,   182,   453,   250,    68,   555,  3450,   230,
     237,   396,   347,   602,  3350,  3343,   604,   237,   603,   604,
     602,     6,   607,   608,   473,   240,   240,   168,    13,    14,
     458,   459,   604,   604,   175,   603,   381,   604,    73,   347,
      25,    26,  3378,   347,   267,   603,    18,   604,   347,   347,
      46,   447,    25,    26,   230,   602,   470,   253,    46,   449,
     201,   510,   398,   512,   192,   580,   515,  3403,  3510,   603,
     603,    56,   602,   602,  3410,    60,    61,   602,   139,   603,
     246,    66,   194,   237,   457,    58,    59,    60,    73,   603,
     237,   603,  3428,   604,   602,    68,    81,   602,   604,   484,
      73,   550,   602,   326,   119,   119,    91,   602,    81,   558,
     602,   379,   494,   610,  3450,    77,   465,   135,   341,   342,
     105,   603,   470,   603,  3379,   442,   267,   604,   603,   603,
      18,   603,   105,   603,   119,   603,   603,   122,   520,   315,
      33,    33,   603,   603,   129,   130,   119,   603,   312,   122,
     242,   136,   393,  4094,   262,   353,   580,   227,  4106,   144,
     602,   604,  3417,   148,   610,   150,   594,   595,   596,   597,
     598,   599,   600,   603,  3510,    46,   199,   150,   604,   312,
     398,   518,   561,   289,   518,   326,   561,   603,   555,   602,
     602,   602,  3528,   178,   602,   571,   337,   602,   602,   571,
     341,   342,   602,   119,   240,  3541,  3542,   240,  3544,  3545,
     341,    33,   342,   604,   603,   602,   342,   312,  3660,   164,
     240,   518,   518,   518,  4172,   512,   565,   227,   561,  4103,
     215,   602,   217,   603,   603,   337,   561,   347,   604,   224,
     488,  3935,   580,   566,   217,   430,   342,   603,   353,   604,
     555,   224,   602,   500,   239,  4196,  3950,   639,   602,   180,
     602,   147,   644,    30,   577,   611,   239,   180,   366,  3963,
     520,   603,  3608,  3609,   603,   128,   603,   128,   150,   252,
      70,   602,   458,   459,  3620,   385,   406,   577,   182,  4230,
      30,    61,   674,   353,  4242,   518,    61,   604,   501,   522,
     603,   602,   525,   255,    46,    46,     5,   292,   690,   602,
     602,   146,   535,  3649,   608,   347,  3652,   540,   347,   292,
     543,   227,   353,   353,  3660,   310,   127,   135,    46,   314,
     602,    46,   145,    46,   123,   577,   555,   310,   212,   146,
    3609,   269,   608,   118,   141,   602,   611,   437,    46,   731,
     732,   733,   734,    46,  3690,    46,    52,   603,   439,   608,
     210,   743,   146,   521,   604,   603,   351,   604,   197,   604,
    3706,   356,   595,   596,   608,  3711,    46,   518,   363,    52,
    3649,   522,   604,  4077,   525,   370,   371,   603,   180,   180,
     363,   603,   420,  4087,   535,   180,   213,   521,   371,   540,
     119,   579,   543,   342,   455,   110,   111,   112,   113,   114,
     602,   604,   181,  3716,  2159,  1960,   401,   593,   594,   595,
     596,   597,   598,   599,   600,  3179,  2337,  3180,   622,  3426,
     415,   416,   417,   418,  3743,    12,    13,  3863,  4039,  3424,
     947,  4040,  3607,  4137,  3780,  3428,  4230,  4183,    45,   550,
    3892,  2650,  1725,   438,   595,   596,  4193,  3599,  4074,  3599,
    3599,  4155,  3599,  4157,  3599,   438,  3599,  3599,  3599,  4074,
    4164,  3928,  3599,  4033,  3599,  3954,  3812,  3599,  3814,  3599,
    3816,  4175,  3599,  3953,   986,  1400,  1654,  3616,  1919,  1410,
    2794,  2628,  3270,  2633,  1245,  2987,  3751,  3975,  3883,  1402,
     205,   206,   207,   208,  3273,  3650,  3842,  4141,  4057,   494,
    4103,  3798,  1454,  4207,  4208,   489,  3196,    94,  4212,  1912,
    2860,   494,  2482,  3105,  1920,   510,  3084,  2415,   513,  3128,
    3128,  3387,  3161,  3567,  3342,  3879,  3378,   510,  3035,  3820,
     513,    11,    11,  3823,  3754,  3824,   123,  3883,  3766,  1468,
    3762,   536,  3620,  3995,  1994,  3575,  3892,  3086,  1919,   136,
    1798,  2408,  3898,  1409,   549,  1360,  3347,  2225,  3085,  2191,
    1450,  1717,  2110,  2982,  2615,  2247,   549,  3601,   570,  2593,
    2963,   862,   159,  2028,   161,  1736,   968,  1065,  2300,  3052,
    3675,  2109,  3535,  3177,  4010,   172,  4011,  2138,  3529,  1039,
     305,  3095,   307,   308,   309,  4172,  3510,  2252,  3890,  1999,
    1233,   316,  2229,  4055,  1258,   192,  2186,  1376,  3062,  3276,
    3001,  3000,  3971,   608,   560,  1477,   635,  1787,  1312,   602,
     549,  3886,  1340,  1788,  1673,  3971,  3103,  1264,  2985,  4002,
     217,  1023,  1024,  4096,  4139,  4067,   223,  4235,  3380,  4241,
    1032,  1033,  1034,  1035,  1036,  1037,  1038,  1292,  3006,  3995,
    2682,  1043,  1741,  3043,  1046,  1047,  3302,  1049,  1699,  1051,
    3518,   541,   844,  1055,  4010,  4011,  1058,  1059,  1060,  1061,
    1282,  1063,  1064,  3639,  2603,   262,  1459,   392,  3645,  1071,
    1072,   485,  1074,  1075,  1076,  1077,  1078,   542,  1080,   849,
    1082,  1083,  1084,  1085,  1086,  1087,  1088,  1089,  1090,  1091,
    1092,   485,   622,  1095,  1096,   622,  1098,   622,  1100,  4055,
      -1,    -1,  1104,  1226,  1106,  1107,    -1,  3982,  3983,    15,
      16,    -1,    -1,    -1,    -1,    -1,  1118,  1119,    -1,   444,
     445,    -1,    -1,  4079,  1126,    -1,    -1,    -1,    -1,    -1,
    4086,  1133,  1134,  1135,    13,  1137,    -1,    -1,    -1,    -1,
      -1,    -1,  1144,  1145,  1146,    -1,  1148,  1149,  1150,  1151,
    1152,    -1,  1154,  1155,  1156,  1157,  1158,  1159,  1160,  1161,
      -1,    -1,  4224,  1165,  1166,    -1,    -1,    -1,   214,    -1,
      -1,    -1,    -1,    12,    13,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,   386,
      -1,    -1,    -1,   390,    -1,    33,    -1,    -1,  4154,    -1,
      -1,    -1,    -1,  4159,   110,   111,   112,   113,   114,   406,
      -1,    -1,    -1,    -1,    -1,    94,    -1,   414,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   422,   272,   273,   274,   275,
     276,   277,    -1,   279,   280,   281,   282,   283,   284,   285,
    4196,   287,   288,    -1,   123,    -1,    -1,    -1,    -1,  4205,
     447,   576,    -1,    -1,    -1,    94,    -1,   136,    -1,    -1,
      -1,    -1,    -1,   460,   461,   590,   591,    -1,  4224,    -1,
      -1,    -1,  4228,    -1,  4230,    -1,    -1,    -1,    -1,  4235,
     159,    -1,   161,    -1,   123,  4241,    -1,    -1,   126,    -1,
    1292,    -1,    -1,   172,    -1,    -1,    -1,   136,  1300,   205,
     206,   207,   208,    -1,    -1,    -1,    -1,   504,    -1,    -1,
     644,    -1,   150,   192,    -1,    -1,   154,    -1,    -1,    -1,
     159,    -1,   161,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   172,    -1,    -1,   533,    -1,   217,    -1,
     674,    -1,    -1,    -1,   223,    -1,    -1,    -1,    -1,   187,
      -1,    -1,    -1,   192,    -1,    -1,   690,    -1,   555,    -1,
     557,    -1,    -1,    -1,   410,   411,   204,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,    -1,
      -1,    -1,    -1,   262,   223,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   305,
     734,   307,   308,   309,    -1,    -1,    -1,    -1,    -1,    -1,
     316,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   262,    -1,    -1,   264,    -1,    -1,    -1,
      13,    14,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,   286,   355,
      -1,    34,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,
      -1,    -1,    -1,    56,    -1,    -1,    -1,    60,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,  1490,    -1,
      -1,    -1,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   386,    -1,    -1,
      -1,    94,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   406,    -1,    -1,
      -1,    -1,   115,    -1,    -1,   414,    -1,    -1,   444,   445,
     123,   124,   125,   422,    -1,    -1,   384,   386,    -1,    -1,
      -1,   390,   135,   136,    -1,   393,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   148,    -1,   406,   447,    -1,
     408,    -1,    -1,    -1,    -1,   414,    -1,    -1,   161,    -1,
      -1,   460,   461,   422,  1586,  1587,  1588,    -1,   426,    -1,
      -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,  1600,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,   192,
      -1,    -1,    -1,    -1,   197,    -1,    -1,   200,    -1,    -1,
      -1,   460,   461,    -1,  1626,   504,    -1,   465,   466,    -1,
    1632,    -1,    -1,  1635,   968,  1637,    -1,    -1,    -1,    -1,
     223,  1643,   225,  1645,  1646,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   490,    -1,   533,    -1,    -1,    -1,   241,    -1,
      -1,    -1,    -1,    -1,    -1,   504,    -1,    -1,    -1,    -1,
     576,    -1,    -1,    -1,    -1,   258,   555,    -1,   557,   262,
      -1,    -1,    -1,   589,   590,   591,    -1,    -1,    -1,  1023,
    1024,    -1,    -1,    -1,   533,    -1,    -1,    -1,  1032,  1033,
      -1,    -1,  1036,  1037,  1038,    -1,    -1,    -1,    -1,  1043,
    1712,    -1,  1046,  1047,    -1,  1049,   555,  1051,   557,    -1,
      -1,    -1,    -1,    -1,  1058,  1059,  1060,  1061,    -1,  1063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1071,  1072,    -1,
    1074,  1075,    -1,    -1,    -1,    -1,  1080,    -1,  1082,  1083,
    1084,    -1,    -1,  1087,  1088,  1089,  1090,  1091,  1092,    -1,
      -1,  1095,  1096,    -1,  1098,    -1,  1100,    -1,   351,    -1,
    1104,    -1,  1106,  1107,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1118,  1119,    -1,   370,    -1,    -1,
      -1,    -1,  1126,    -1,    -1,    -1,    -1,   380,    -1,  1133,
    1134,  1135,    -1,    -1,    -1,    -1,    -1,    -1,   391,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     413,    -1,  1166,   416,    -1,   418,    -1,    -1,   421,    -1,
      -1,   424,   425,    -1,    -1,    -1,    -1,    -1,    -1,   432,
      -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,   441,    -1,
      -1,    -1,    -1,    -1,   447,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   455,    -1,    -1,    -1,    -1,   460,    -1,   462,
      -1,    -1,   465,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   489,    -1,    -1,    -1,
     493,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    23,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    33,    34,    -1,    -1,    -1,    -1,    -1,    -1,  1941,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   536,    -1,    -1,    58,    59,  1292,    -1,
      -1,    -1,    -1,    -1,    -1,   548,  1300,    69,    -1,   552,
      -1,    -1,   555,    -1,    -1,    -1,    -1,   560,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      92,    -1,    94,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   103,    -1,    -1,   587,    -1,  2008,    -1,    -1,    -1,
    2012,    -1,    -1,    -1,    -1,  2017,  2018,    -1,    -1,   602,
      -1,    -1,    -1,    -1,  2026,    -1,    -1,  2029,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2039,    -1,  2041,
    2042,    -1,  2044,  2045,  2046,  2047,  2048,   149,   150,  2051,
      -1,    -1,    -1,   155,    -1,    -1,   158,    -1,  2060,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2068,    -1,  2070,    -1,
    2072,  2073,  2074,  2075,    -1,    -1,    -1,  2079,  2080,  2081,
      -1,   183,    -1,   185,  2086,  2087,  2088,    -1,  2090,   191,
    2092,   193,  2094,    -1,  2096,    -1,  2098,    -1,    -1,    -1,
      -1,  2103,    -1,    -1,    -1,    -1,    25,    26,    -1,    -1,
      -1,    -1,    13,    14,   216,   217,    -1,    -1,    -1,  2121,
      -1,    -1,    -1,    -1,    -1,    -1,  2128,    -1,    -1,  2131,
      -1,    -1,    -1,    34,    -1,  2137,   238,    -1,  2140,    58,
      59,    60,  2144,    -1,    -1,    -1,    -1,    48,    49,    68,
      -1,    -1,    -1,    -1,    73,    56,  1490,   259,    -1,    60,
      61,    -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      25,    26,    -1,    -1,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   286,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    94,    -1,    -1,    -1,  2199,    -1,    -1,
     119,    -1,    -1,   122,    -1,    60,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   115,    -1,    -1,    -1,    73,    -1,
      -1,    -1,   123,   124,   125,    -1,    81,    -1,    -1,    -1,
      -1,   150,    -1,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   350,    -1,
     105,    -1,  1586,  1587,  1588,    -1,    -1,    -1,    -1,    -1,
     161,    -1,    -1,    -1,   119,    -1,    -1,   122,    -1,    -1,
      -1,   373,    -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,
      -1,    -1,   384,   385,    -1,    -1,   388,   389,    -1,    -1,
      -1,   192,  1626,    -1,    -1,   150,   197,    -1,   217,   200,
      -1,  1635,    -1,  1637,    -1,   224,    -1,   409,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     239,    -1,   223,    -1,   225,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     241,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     452,    -1,    -1,    -1,    -1,    -1,    -1,   258,    -1,    -1,
      -1,   262,   217,   465,    -1,    -1,    -1,    -1,    -1,   224,
      -1,    -1,    -1,   292,    -1,    -1,    -1,    -1,  1712,    -1,
      -1,    -1,    -1,    -1,   239,    -1,    -1,    -1,   490,    -1,
      -1,   310,   494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     512,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   292,    -1,    -1,
      -1,    -1,    -1,    -1,   363,    -1,    -1,    -1,    -1,    -1,
     351,    -1,   371,    -1,    -1,   310,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   569,    -1,   370,
      -1,    -1,    -1,   575,    -1,    -1,    -1,    -1,    -1,   380,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2503,    -1,    -1,    -1,  2507,    -1,    -1,   363,    -1,
      -1,    -1,   413,    -1,    -1,   416,   371,   418,    -1,   438,
     421,    -1,    -1,   424,   425,    -1,    -1,  2529,  2530,    -1,
      -1,   432,    -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,
     441,    -1,    -1,    -1,    -1,    -1,   447,  2549,    -1,    -1,
      -1,    -1,    -1,    -1,   455,    -1,  2558,    -1,  2560,   460,
    2562,   462,    -1,    -1,   465,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,    -1,    -1,
    2582,    -1,    -1,   438,    -1,  2587,    -1,    -1,   489,    -1,
      -1,   510,   493,    -1,   513,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1941,    -1,  2611,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     549,    -1,    -1,    -1,    -1,   536,    -1,    -1,    -1,   494,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,
      -1,   552,    -1,    -1,   555,   510,    -1,    -1,   513,   560,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2675,  2008,    -1,    -1,  2679,  2012,    -1,
      -1,    -1,    -1,  2017,  2018,    -1,   587,    -1,    -1,    -1,
      -1,    -1,  2026,    -1,   549,    -1,    -1,    -1,    -1,    -1,
      -1,   602,    -1,    -1,    -1,  2039,    -1,  2041,    -1,    -1,
    2044,  2045,  2046,  2047,  2048,    -1,    -1,    -1,    -1,    -1,
      -1,  2723,    -1,    -1,    -1,    -1,  2060,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2068,    -1,  2070,    -1,  2072,  2073,
    2074,    -1,    -1,    -1,    -1,  2079,  2080,  2081,    -1,    -1,
      -1,    -1,  2086,  2087,  2088,    -1,  2090,    -1,  2092,    -1,
    2094,    -1,  2096,    -1,  2098,    -1,    32,    33,    -1,  2103,
      -1,    -1,    38,    -1,    40,    -1,    42,    43,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2121,    -1,    -1,
      -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2137,    -1,    -1,  2140,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2830,  2831,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     106,    -1,    -1,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,
      -1,    -1,  2894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,    -1,
     176,    -1,    -1,    -1,    -1,    -1,  2918,  2919,    -1,  2921,
      -1,    -1,   188,   189,    -1,    -1,    -1,    -1,  2930,    -1,
      -1,    -1,    -1,  2935,    -1,    -1,  2938,    -1,  2940,  2941,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2961,
      -1,    -1,   228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2976,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     256,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3000,   265,
     266,    -1,   268,    -1,    -1,     6,    -1,    -1,    -1,    -1,
      -1,    -1,    13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    25,    26,    -1,    -1,  3030,    -1,
      -1,    -1,   298,   299,   300,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3044,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   317,   318,   319,    -1,    56,    -1,    -1,   324,    60,
      -1,   327,  3064,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3073,    73,    -1,    -1,    -1,    -1,   343,   344,    -1,
      81,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,    -1,   375,
     376,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,
      -1,   122,    -1,    -1,    -1,    -1,    -1,    -1,   129,    -1,
      -1,    -1,    -1,    -1,   400,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,    -1,    -1,    -1,    -1,    -1,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2503,
      -1,    -1,    -1,  2507,    -1,    -1,    -1,   178,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   451,    -1,    -1,    -1,   455,
      -1,    -1,    -1,    -1,    -1,  2529,  2530,    -1,    -1,    -1,
      -1,   467,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2549,   217,    -1,    -1,    -1,
      -1,    -1,    -1,   224,  2558,    -1,  2560,    -1,  2562,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   239,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   519,    -1,    -1,   522,    -1,    -1,   525,
     526,   527,   528,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3277,    -1,  2611,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   567,   568,    -1,    -1,    -1,    -1,    -1,    -1,   310,
      -1,    -1,    -1,   314,  3316,  3317,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3325,    -1,   591,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2675,    -1,    -1,    -1,  2679,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,
      -1,    -1,   363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2723,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   438,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3456,    -1,    -1,    -1,  3460,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3491,
      -1,    -1,    -1,   494,    -1,    -1,  2830,  2831,    -1,    -1,
      -1,    -1,    -1,  3505,    -1,    -1,    -1,    -1,    -1,   510,
      -1,    -1,   513,    -1,    -1,    -1,  3518,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   549,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2918,  2919,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2930,  3599,    -1,    -1,
      -1,  2935,    -1,    -1,  2938,    -1,  2940,  2941,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2976,    -1,    -1,    -1,    -1,    -1,  3650,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3658,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3667,  3000,  3669,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3703,    -1,    -1,    -1,    -1,    -1,  3709,  3710,    -1,
    3044,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3064,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3073,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3770,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3803,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3835,    -1,  3837,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3847,    -1,  3849,  3850,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3933,    -1,  3935,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3277,    -1,    -1,    -1,    -1,  3950,  3951,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3963,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3316,  3317,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4019,  4020,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4032,  4033,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4049,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4077,    -1,    -1,    -1,    -1,
      -1,    -1,  4084,    -1,    -1,  4087,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4118,    -1,    -1,    -1,
      -1,    -1,  3456,  4125,    -1,  4127,  3460,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4137,    -1,    -1,    -1,  4141,
      -1,    -1,  4144,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4153,    -1,  4155,    -1,  4157,    -1,  3491,    -1,    -1,
      -1,    -1,  4164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3505,    -1,  4175,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3518,    -1,    -1,    -1,    -1,  4191,
    4192,    -1,    -1,    -1,    -1,  4197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4207,  4208,    -1,    -1,    -1,
    4212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3658,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3667,    -1,  3669,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3703,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3770,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3803,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3835,    -1,  3837,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3847,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3933,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3972,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4019,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4084,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
    4144,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    44,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,  4197,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
    4244,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,   245,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,   530,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,   347,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,   603,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,   182,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,   336,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,   182,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
     336,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,   336,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,   336,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    33,    34,    35,    36,    37,    38,    39,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      52,    53,    54,    55,    -1,    57,    58,    59,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    93,    -1,    -1,    96,    97,    98,    -1,   100,   101,
     102,    -1,   104,   105,   106,   107,   108,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,   119,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
     162,    -1,   164,   165,   166,   167,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,   195,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
     212,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,   223,   224,   225,   226,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,   248,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,   335,   336,   337,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,   365,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,   378,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,   420,   421,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,   433,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,   491,
     492,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
     502,   503,   504,   505,   506,   507,   508,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,   534,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
     562,   563,   564,   565,   566,    -1,    -1,   569,   570,    -1,
     572,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,   595,   596,    -1,    -1,    -1,    -1,   601,
     602,    -1,    -1,   605,   606,    -1,    -1,   609,   610,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    33,    34,    35,
      36,    37,    38,    39,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    59,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    93,    -1,    -1,
      96,    97,    98,    -1,   100,   101,   102,    -1,   104,   105,
     106,   107,   108,   109,    -1,    -1,    -1,    -1,   114,   115,
     116,    -1,    -1,   119,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,   162,    -1,   164,   165,
     166,   167,   168,   169,   170,    -1,   172,   173,   174,   175,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,   195,
      -1,   197,   198,    -1,   200,   201,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,   212,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,   223,   224,   225,
     226,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,   248,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,   267,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
     326,   327,   328,    -1,    -1,   331,   332,   333,   334,   335,
      -1,   337,   338,   339,    -1,   341,   342,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,   420,   421,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,   433,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,   491,   492,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,   502,   503,   504,   505,
     506,   507,   508,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,   518,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,   534,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,   562,   563,   564,   565,
     566,    -1,    -1,   569,   570,    -1,   572,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,   595,
     596,    -1,    -1,    -1,    -1,   601,   602,    -1,    -1,   605,
     606,    -1,    -1,   609,   610,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    33,    34,    35,    36,    37,    38,    39,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    52,    53,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    93,    -1,    -1,    96,    97,    98,    -1,
     100,   101,   102,    -1,   104,   105,   106,   107,   108,   109,
      -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,   119,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,   162,    -1,   164,   165,   166,   167,   168,   169,
     170,    -1,   172,   173,   174,   175,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,   195,    -1,   197,   198,    -1,
     200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,   212,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,   223,   224,   225,   226,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,   248,   249,
     250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,   326,   327,   328,    -1,
      -1,   331,   332,   333,   334,   335,    -1,   337,   338,   339,
      -1,   341,   342,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
     420,   421,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,   433,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,   491,   492,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,   502,   503,   504,   505,   506,   507,   508,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,   534,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,   562,   563,   564,   565,   566,    -1,    -1,   569,
     570,    -1,   572,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,    -1,    -1,   595,   596,    -1,    -1,    -1,
      -1,   601,   602,    -1,    -1,   605,   606,    -1,    -1,   609,
     610,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    35,    36,    37,    38,    39,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    59,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    93,
      -1,    -1,    96,    97,    98,    -1,   100,   101,   102,    -1,
     104,   105,   106,   107,   108,   109,    -1,    -1,    -1,    -1,
     114,   115,   116,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,    -1,
     164,   165,   166,   167,   168,   169,   170,    -1,   172,   173,
     174,   175,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,   195,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,   223,
     224,   225,   226,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,   248,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,   267,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,   326,   327,   328,    -1,    -1,   331,   332,   333,
     334,   335,    -1,   337,   338,   339,    -1,   341,   342,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,   365,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,   378,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,   420,   421,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,   433,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,   491,   492,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,   502,   503,
     504,   505,   506,   507,   508,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,   562,   563,
     564,   565,   566,    -1,    -1,   569,   570,    -1,   572,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,   595,   596,    -1,    -1,    -1,    -1,   601,   602,    -1,
      -1,   605,   606,    -1,    -1,   609,   610,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    35,    36,    37,
      38,    39,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    52,    53,    54,    55,    -1,    57,
      58,    59,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    93,    -1,    -1,    96,    97,
      98,    -1,   100,   101,   102,    -1,   104,   105,   106,   107,
     108,   109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,
      -1,   119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,   162,    -1,   164,   165,   166,   167,
     168,   169,   170,    -1,   172,   173,   174,   175,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,   195,    -1,   197,
     198,    -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,   212,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,   223,   224,   225,   226,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
     248,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,   326,   327,
     328,    -1,    -1,   331,   332,   333,   334,   335,    -1,   337,
     338,   339,    -1,   341,   342,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,   420,   421,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,   433,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,   491,   492,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,   502,   503,   504,   505,   506,   507,
     508,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,   534,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,   562,   563,   564,   565,   566,    -1,
      -1,   569,   570,    -1,   572,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,    -1,    -1,   595,   596,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,   605,   606,    -1,
      -1,   609,   610,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,   116,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,   168,   169,   170,    -1,
     172,   173,   174,   175,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,   201,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,   267,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,   326,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,   341,
     342,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    17,   609,   610,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    -1,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,
      -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,
      -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,
      -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,
      -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,
     151,    -1,    -1,   154,   155,    -1,   157,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,
      -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,
     181,    -1,   183,   184,   185,    -1,   187,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,
      -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,
     211,    -1,    -1,   214,   215,   216,   217,    -1,   219,    -1,
      -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,
     231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,   240,
      -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,
      -1,   252,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,
     261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,    -1,   290,
     291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,
     301,   302,   303,   304,   305,   306,    -1,    -1,   309,   310,
      -1,   312,    -1,   314,    -1,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,
     331,   332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,
      -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,   350,
      -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   362,   363,   364,    -1,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,    -1,    -1,   380,
     381,   382,    -1,   384,    -1,   386,   387,   388,   389,   390,
      -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,
     401,   402,   403,   404,   405,    -1,    -1,   408,   409,   410,
     411,   412,    -1,   414,   415,    -1,   417,   418,   419,    -1,
      -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,   430,
      -1,    -1,    -1,   434,   435,   436,   437,   438,   439,   440,
     441,   442,   443,    -1,   445,   446,   447,    -1,    -1,   450,
     451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,
     461,    -1,   463,   464,   465,   466,    -1,   468,   469,   470,
     471,   472,   473,    -1,    -1,    -1,    -1,    -1,   479,   480,
      -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,
      -1,    -1,   493,   494,    -1,   496,   497,   498,   499,   500,
     501,    -1,    -1,   504,   505,   506,   507,    -1,   509,   510,
      -1,    -1,   513,   514,   515,   516,    -1,    -1,   519,   520,
      -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,
     531,   532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,
     541,   542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,
     551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,
      -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,
      -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,
      -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,
     591,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,   184,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,   217,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,   240,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,   473,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,    -1,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,   447,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
     603,    -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,   603,
      -1,    -1,    -1,    -1,    17,   609,   610,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    -1,    81,    82,
      -1,    84,    85,    86,    87,    88,    -1,    90,    -1,    -1,
      93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,
      -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,
      -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,
      -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,
      -1,   144,    -1,   146,   147,    -1,   149,   150,   151,    -1,
      -1,   154,   155,    -1,   157,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,   172,
     173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,
     183,    -1,   185,    -1,   187,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,
     203,   204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,
      -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,
      -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,
      -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,
     243,    -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,
      -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,   286,   287,   288,    -1,   290,   291,   292,
     293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,
     303,   304,   305,   306,    -1,    -1,   309,   310,    -1,   312,
      -1,   314,    -1,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,
     333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   348,   349,   350,    -1,   352,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,
     363,   364,    -1,   366,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,   377,    -1,    -1,   380,   381,   382,
      -1,   384,    -1,   386,   387,   388,   389,   390,    -1,   392,
     393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,
     403,   404,   405,    -1,    -1,   408,   409,   410,   411,   412,
      -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,   422,
      -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,
      -1,   434,   435,   436,   437,   438,   439,   440,   441,   442,
     443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,
     453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,
     463,   464,   465,   466,    -1,   468,   469,   470,   471,   472,
      -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,
      -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,
     493,   494,    -1,   496,   497,   498,   499,   500,   501,    -1,
      -1,   504,   505,   506,   507,    -1,   509,   510,    -1,    -1,
     513,   514,   515,   516,    -1,    -1,   519,   520,    -1,   522,
     523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,
      -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,   542,
      -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,
      -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,
     573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,
     583,   584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,   602,
      -1,    -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,   227,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,
      -1,     5,   597,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,   610,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,   602,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,   609,   610,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,    20,   610,    22,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    -1,    81,    82,    -1,    84,
      85,    86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,
      -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,
     105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,
     115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,
      -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,
      -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,   154,
     155,    -1,   157,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,    -1,    -1,   169,   170,    -1,   172,   173,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,
     185,    -1,   187,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,
      -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,
     215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,
     235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,
      -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,
      -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,   286,   287,   288,    -1,   290,   291,   292,   293,    -1,
     295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,
     305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,
      -1,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,   334,
      -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,
     345,   346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,
      -1,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,    -1,    -1,   380,   381,   382,    -1,   384,
      -1,   386,   387,   388,   389,   390,    -1,   392,   393,   394,
      -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,
     405,    -1,    -1,   408,   409,   410,   411,   412,    -1,   414,
     415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,
      -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,    -1,
     445,   446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,
      -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,
     465,   466,    -1,   468,   469,   470,   471,   472,    -1,    -1,
      -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,
     485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,
      -1,   496,   497,   498,   499,   500,   501,    -1,    -1,   504,
     505,   506,   507,    -1,   509,   510,    -1,    -1,   513,   514,
     515,   516,    -1,    -1,   519,   520,    -1,   522,   523,   524,
     525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,
      -1,   536,   537,   538,   539,    -1,   541,   542,    -1,   544,
     545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,
      -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,
      -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,
     575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,
      -1,   586,   587,   588,    -1,    -1,   591,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    -1,    20,   610,    22,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    -1,    81,    82,    -1,    84,    85,
      86,    87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,
      96,    -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,
     106,    -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,
      -1,    -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,
     126,    -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,
     146,   147,    -1,   149,   150,   151,    -1,    -1,   154,   155,
      -1,   157,   158,   159,   160,   161,    -1,    -1,   164,   165,
     166,    -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,
      -1,   177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,
      -1,   187,   188,   189,   190,   191,    -1,   193,    -1,    -1,
      -1,   197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,
      -1,    -1,   208,   209,   210,   211,    -1,    -1,   214,   215,
     216,    -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,
      -1,    -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,
     246,    -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,
     256,   257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
     286,   287,   288,    -1,   290,   291,   292,   293,    -1,   295,
     296,    -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,
     306,    -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,
     316,   317,   318,   319,   320,   321,   322,   323,   324,    -1,
      -1,   327,   328,    -1,    -1,   331,   332,   333,   334,    -1,
      -1,    -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,
     346,    -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,
     386,   387,   388,   389,   390,    -1,   392,   393,   394,    -1,
      -1,   397,    -1,    -1,    -1,   401,   402,   403,   404,   405,
      -1,    -1,   408,   409,   410,   411,   412,    -1,   414,   415,
      -1,   417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,
     426,   427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,
     436,   437,   438,   439,   440,   441,   442,   443,    -1,   445,
     446,    -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,
      -1,   457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,
     466,    -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,
      -1,    -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,
      -1,    -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,
     496,   497,   498,   499,   500,   501,    -1,    -1,   504,   505,
     506,   507,    -1,   509,   510,    -1,    -1,   513,   514,   515,
     516,    -1,    -1,   519,   520,    -1,   522,   523,   524,   525,
      -1,    -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,
     536,   537,   538,   539,    -1,   541,   542,    -1,   544,   545,
      -1,   547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,
     556,    -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,
     566,    -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,
     576,    -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,
     586,   587,   588,    -1,    -1,   591,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
      17,    -1,    -1,    20,   610,    22,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    -1,    81,    82,    -1,    84,    85,    86,
      87,    88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,
      -1,    -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,
      -1,    -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,
      -1,    -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,
      -1,   128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,
     147,    -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,
     157,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
      -1,    -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,
     177,    -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,
     187,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,
      -1,   208,   209,   210,   211,    -1,    -1,   214,   215,   216,
      -1,    -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,
      -1,    -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,
      -1,    -1,   249,   250,    -1,    -1,    -1,    -1,    -1,   256,
     257,    -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,   286,
     287,   288,    -1,   290,   291,   292,   293,    -1,   295,   296,
      -1,    -1,    -1,    -1,   301,   302,   303,   304,   305,   306,
      -1,    -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
     327,   328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,
      -1,   338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,
      -1,   348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
     377,    -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,
     387,   388,   389,   390,    -1,   392,   393,   394,    -1,    -1,
     397,    -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,
      -1,   408,   409,   410,   411,   412,    -1,   414,   415,    -1,
     417,   418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,
     427,    -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,
     437,   438,   439,   440,   441,   442,   443,    -1,   445,   446,
      -1,    -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,
     457,    -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,
      -1,   468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,
      -1,    -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,
      -1,   488,   489,   490,    -1,    -1,   493,   494,    -1,   496,
     497,   498,   499,   500,   501,    -1,    -1,   504,   505,   506,
     507,    -1,   509,   510,    -1,    -1,   513,   514,   515,   516,
      -1,    -1,   519,   520,    -1,   522,   523,   524,   525,    -1,
      -1,    -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,
     537,   538,   539,    -1,   541,   542,    -1,   544,   545,    -1,
     547,   548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,
      -1,   558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,
      -1,    -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,
      -1,    -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,
     587,   588,    -1,    -1,   591,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,
      -1,    -1,    20,   610,    22,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    -1,    81,    82,    -1,    84,    85,    86,    87,
      88,    -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,
      -1,    -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,
      -1,   109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,
      -1,    -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,
     128,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,   139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,
      -1,   149,   150,   151,    -1,    -1,   154,   155,    -1,   157,
     158,   159,   160,   161,    -1,    -1,   164,   165,   166,    -1,
      -1,   169,   170,    -1,   172,   173,   174,    -1,    -1,   177,
      -1,    -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,
     188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,
     198,    -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,
     208,   209,   210,   211,    -1,    -1,   214,   215,   216,    -1,
      -1,   219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,
      -1,   229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,
      -1,   239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,
      -1,   249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,
      -1,   259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,   286,   287,
     288,    -1,   290,   291,   292,   293,    -1,   295,   296,    -1,
      -1,    -1,    -1,   301,   302,   303,   304,   305,   306,    -1,
      -1,   309,   310,    -1,   312,    -1,   314,    -1,   316,   317,
     318,   319,   320,   321,   322,   323,   324,    -1,    -1,   327,
     328,    -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,
     338,   339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,
     348,   349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
      -1,    -1,   380,   381,   382,    -1,   384,    -1,   386,   387,
     388,   389,   390,    -1,   392,   393,   394,    -1,    -1,   397,
      -1,    -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,
     408,   409,   410,   411,   412,    -1,   414,   415,    -1,   417,
     418,   419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,
      -1,   429,   430,    -1,    -1,    -1,   434,   435,   436,   437,
     438,   439,   440,   441,   442,   443,    -1,   445,   446,    -1,
      -1,    -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,
      -1,    -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,
     468,   469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,
      -1,   479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,
     488,   489,   490,    -1,    -1,   493,   494,    -1,   496,   497,
     498,   499,   500,   501,    -1,    -1,   504,   505,   506,   507,
      -1,   509,   510,    -1,    -1,   513,   514,   515,   516,    -1,
     518,   519,   520,    -1,   522,   523,   524,   525,    -1,    -1,
      -1,    -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,
     538,   539,    -1,   541,   542,    -1,   544,   545,    -1,   547,
     548,    -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,
     558,   559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,
      -1,   569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,
      -1,    -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,
     588,    -1,    -1,   591,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,
      20,   609,    22,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      -1,    81,    82,    -1,    84,    85,    86,    87,    88,    -1,
      90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,    -1,
     100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,   109,
      -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,    -1,
     120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,   139,
     140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,   149,
     150,   151,    -1,    -1,   154,   155,    -1,   157,   158,   159,
     160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,   169,
     170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,    -1,
      -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,   189,
     190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,    -1,
     200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,   209,
     210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,   219,
      -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
      -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,   239,
      -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,   249,
     250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,   259,
      -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,    -1,   286,   287,   288,    -1,
     290,   291,   292,   293,    -1,   295,   296,    -1,    -1,    -1,
      -1,   301,   302,   303,   304,   305,   306,    -1,    -1,   309,
     310,    -1,   312,    -1,   314,    -1,   316,   317,   318,   319,
     320,   321,   322,   323,   324,    -1,    -1,   327,   328,    -1,
      -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,   339,
      -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,   349,
     350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   362,   363,   364,    -1,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,    -1,    -1,
     380,   381,   382,    -1,   384,    -1,   386,   387,   388,   389,
     390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,    -1,
      -1,   401,   402,   403,   404,   405,    -1,    -1,   408,   409,
     410,   411,   412,    -1,   414,   415,    -1,   417,   418,   419,
      -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,   429,
     430,    -1,    -1,    -1,   434,   435,   436,   437,   438,   439,
     440,   441,   442,   443,    -1,   445,   446,    -1,    -1,    -1,
     450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,    -1,
      -1,   461,    -1,   463,   464,   465,   466,    -1,   468,   469,
     470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,   479,
     480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,   489,
     490,    -1,    -1,   493,   494,    -1,   496,   497,   498,   499,
     500,   501,    -1,    -1,   504,   505,   506,   507,    -1,   509,
     510,    -1,    -1,   513,   514,   515,   516,    -1,   518,   519,
     520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,    -1,
      -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,   539,
      -1,   541,   542,    -1,   544,   545,    -1,   547,   548,    -1,
      -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,   559,
      -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,   569,
      -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,    -1,
      -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,    -1,
      -1,   591,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    17,    -1,    -1,    20,   609,
      22,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    -1,    81,
      82,    -1,    84,    85,    86,    87,    88,    -1,    90,    -1,
      -1,    93,    -1,    -1,    96,    -1,    -1,    -1,   100,    -1,
      -1,    -1,   104,   105,   106,    -1,    -1,   109,    -1,    -1,
      -1,    -1,   114,   115,    -1,    -1,    -1,    -1,   120,    -1,
     122,    -1,    -1,    -1,   126,    -1,   128,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,   139,   140,    -1,
      -1,    -1,   144,    -1,   146,   147,    -1,   149,   150,   151,
      -1,    -1,   154,   155,    -1,   157,   158,   159,   160,   161,
      -1,    -1,   164,   165,   166,    -1,    -1,   169,   170,    -1,
     172,   173,   174,    -1,    -1,   177,    -1,    -1,    -1,   181,
      -1,   183,    -1,   185,    -1,   187,   188,   189,   190,   191,
      -1,   193,    -1,    -1,    -1,   197,   198,    -1,   200,    -1,
      -1,   203,   204,    -1,    -1,    -1,   208,   209,   210,   211,
      -1,    -1,   214,   215,   216,    -1,    -1,   219,    -1,    -1,
      -1,    -1,   224,   225,    -1,    -1,    -1,   229,    -1,   231,
     232,    -1,   234,   235,    -1,    -1,    -1,   239,    -1,    -1,
     242,   243,    -1,    -1,   246,    -1,    -1,   249,   250,   251,
      -1,    -1,    -1,    -1,   256,   257,    -1,   259,    -1,   261,
      -1,   263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,   286,   287,   288,    -1,   290,   291,
     292,   293,    -1,   295,   296,    -1,    -1,    -1,    -1,   301,
     302,   303,   304,   305,   306,    -1,    -1,   309,   310,    -1,
     312,    -1,   314,    -1,   316,   317,   318,   319,   320,   321,
     322,   323,   324,    -1,    -1,   327,   328,    -1,    -1,   331,
     332,   333,   334,    -1,    -1,    -1,   338,   339,    -1,    -1,
      -1,    -1,   344,   345,   346,    -1,   348,   349,   350,    -1,
     352,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     362,   363,   364,    -1,   366,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,   377,    -1,    -1,   380,   381,
     382,    -1,   384,    -1,   386,   387,   388,   389,   390,    -1,
     392,   393,   394,    -1,    -1,   397,    -1,    -1,    -1,   401,
     402,   403,   404,   405,    -1,    -1,   408,   409,   410,   411,
     412,    -1,   414,   415,    -1,   417,   418,   419,    -1,    -1,
     422,    -1,   424,    -1,   426,   427,    -1,   429,   430,    -1,
      -1,    -1,   434,   435,   436,   437,   438,   439,   440,   441,
     442,   443,    -1,   445,   446,    -1,    -1,    -1,   450,   451,
     452,   453,    -1,    -1,    -1,   457,    -1,    -1,    -1,   461,
      -1,   463,   464,   465,   466,    -1,   468,   469,   470,   471,
     472,    -1,    -1,    -1,    -1,    -1,    -1,   479,   480,    -1,
     482,    -1,    -1,   485,    -1,    -1,   488,   489,   490,    -1,
      -1,   493,   494,    -1,   496,   497,   498,   499,   500,   501,
      -1,    -1,   504,   505,   506,   507,    -1,   509,   510,    -1,
      -1,   513,   514,   515,   516,    -1,   518,   519,   520,    -1,
     522,   523,   524,   525,    -1,    -1,    -1,    -1,    -1,   531,
     532,    -1,    -1,    -1,   536,   537,   538,   539,    -1,   541,
     542,    -1,   544,   545,    -1,   547,   548,    -1,    -1,   551,
      -1,    -1,   554,    -1,   556,    -1,   558,   559,    -1,    -1,
      -1,    -1,    -1,    -1,   566,    -1,    -1,   569,    -1,    -1,
      -1,   573,   574,   575,   576,    -1,    -1,    -1,    -1,    -1,
      -1,   583,   584,    -1,   586,   587,   588,    -1,    -1,   591,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,   609,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    -1,
      74,    -1,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    -1,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,    -1,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,    -1,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,   171,   172,   173,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,   269,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,    -1,    -1,    -1,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,   419,   420,    -1,   422,    -1,
      -1,    -1,   426,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,   442,   443,
      -1,   445,    -1,    -1,    -1,    -1,   450,   451,   452,    -1,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,    -1,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,    -1,   490,    -1,    -1,    -1,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,    -1,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,    -1,    -1,    -1,    -1,   551,    -1,    -1,
     554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,   579,    -1,    -1,    -1,   583,
      -1,    -1,   586,    -1,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
     604,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,   597,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,   597,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,   597,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,   597,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,   116,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,   175,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,   201,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,    -1,    -1,   342,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,   475,   476,   477,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,   540,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,   152,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,   456,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,   267,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,   342,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,   540,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
     119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    35,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,   201,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,   251,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,   251,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,   518,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      89,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,   163,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,   476,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,   182,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,   119,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
     119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,   518,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
     119,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    87,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,   115,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,   139,   140,    -1,    -1,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,    -1,   172,   173,
     174,    -1,    -1,   177,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,   197,   198,    -1,   200,    -1,    -1,   203,
     204,    -1,    -1,    -1,   208,   209,   210,   211,    -1,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,    -1,    -1,    -1,   239,    -1,    -1,   242,   243,
      -1,    -1,   246,    -1,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,   338,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,   352,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   362,   363,
     364,    -1,   366,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,   377,    -1,    -1,   380,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,   415,    -1,   417,   418,   419,    -1,    -1,   422,    -1,
     424,    -1,   426,   427,    -1,   429,   430,    -1,    -1,    -1,
     434,   435,   436,   437,   438,   439,   440,   441,   442,   443,
      -1,   445,   446,    -1,    -1,    -1,   450,   451,   452,   453,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,   463,
     464,   465,   466,    -1,   468,   469,   470,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,   489,   490,    -1,    -1,   493,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,   536,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,   547,   548,    -1,    -1,   551,    -1,    -1,
     554,    -1,   556,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,    -1,    -1,    -1,    -1,   583,
     584,    -1,   586,   587,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    87,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,   115,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,    -1,   172,   173,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
      -1,   200,    -1,    -1,   203,   204,    -1,    -1,    -1,   208,
     209,   210,   211,    -1,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,    -1,    -1,    -1,
     239,    -1,    -1,   242,   243,    -1,    -1,   246,    -1,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,   338,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,   352,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   362,   363,   364,    -1,   366,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,   377,    -1,
      -1,   380,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,   415,    -1,   417,   418,
     419,    -1,    -1,   422,    -1,   424,    -1,   426,   427,    -1,
     429,   430,    -1,    -1,    -1,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,    -1,   445,   446,    -1,    -1,
      -1,   450,   451,   452,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,   463,   464,   465,   466,    -1,   468,
     469,   470,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
     489,   490,    -1,    -1,   493,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,   536,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,   547,   548,
      -1,    -1,   551,    -1,    -1,   554,    -1,   556,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,    -1,    -1,
      -1,    -1,    -1,    -1,   583,   584,    -1,   586,   587,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    -1,
      74,    -1,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    -1,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,    -1,   142,   143,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,    -1,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,   171,   172,   173,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,   269,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,    -1,    -1,    -1,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,   419,   420,    -1,   422,    -1,
      -1,    -1,   426,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,   442,   443,
      -1,   445,    -1,    -1,    -1,    -1,   450,   451,   452,    -1,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,    -1,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,    -1,   490,    -1,    -1,    -1,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,    -1,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,    -1,    -1,    -1,    -1,   551,    -1,    -1,
     554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,    -1,    -1,   579,    -1,    -1,    -1,   583,
      -1,    -1,   586,    -1,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    22,    23,    24,    25,    26,    27,    -1,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    -1,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,    -1,    -1,    -1,   138,
     139,   140,    -1,   142,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,    -1,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,   171,   172,   173,   174,    -1,    -1,    -1,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,   198,
      -1,    -1,    -1,    -1,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,   211,   212,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,   236,    -1,    -1,
     239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
     269,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,    -1,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,    -1,    -1,   367,   368,
     369,    -1,   371,   372,   373,   374,   375,   376,    -1,    -1,
      -1,    -1,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,
     419,   420,    -1,   422,    -1,    -1,    -1,   426,    -1,    -1,
     429,   430,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,   443,    -1,   445,    -1,    -1,    -1,
      -1,   450,   451,   452,    -1,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,    -1,   464,    -1,   466,    -1,   468,
      -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
      -1,   490,    -1,    -1,    -1,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,   515,   516,    -1,    -1,
     519,   520,    -1,   522,   523,   524,   525,    -1,    -1,    -1,
      -1,    -1,   531,   532,    -1,    -1,    -1,    -1,   537,   538,
     539,    -1,   541,   542,    -1,   544,   545,    -1,    -1,    -1,
      -1,    -1,   551,    -1,    -1,   554,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,    -1,    -1,    -1,   566,    -1,    -1,
     569,    -1,    -1,    -1,   573,   574,   575,   576,   577,    -1,
     579,    -1,    -1,    -1,   583,    -1,    -1,   586,    -1,   588,
      -1,     5,   591,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    17,    -1,    -1,    -1,    -1,    22,    23,
      24,    25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,
      54,    55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    -1,
      74,    -1,    76,    77,    78,    79,    -1,    81,    82,    -1,
      84,    85,    86,    -1,    88,    -1,    90,    -1,    -1,    93,
      -1,    -1,    96,    -1,    -1,    -1,   100,    -1,    -1,    -1,
     104,   105,   106,    -1,    -1,   109,    -1,    -1,    -1,    -1,
     114,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,    -1,
      -1,    -1,   126,    -1,   128,   129,   130,   131,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,   140,    -1,   142,    -1,
     144,    -1,   146,   147,    -1,   149,   150,   151,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,    -1,    -1,    -1,
     164,   165,   166,    -1,    -1,   169,   170,   171,   172,   173,
     174,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,   183,
      -1,   185,    -1,   187,   188,   189,   190,   191,    -1,   193,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,    -1,    -1,
     204,    -1,    -1,    -1,   208,   209,   210,   211,   212,    -1,
     214,   215,   216,    -1,    -1,   219,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,   229,    -1,   231,   232,    -1,
     234,   235,   236,    -1,    -1,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,    -1,   249,   250,    -1,    -1,    -1,
      -1,    -1,   256,   257,    -1,   259,    -1,   261,    -1,   263,
     264,    -1,    -1,    -1,    -1,   269,    -1,    -1,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,    -1,   286,   287,   288,    -1,   290,   291,   292,   293,
      -1,   295,   296,    -1,    -1,    -1,    -1,   301,   302,   303,
     304,   305,   306,    -1,    -1,   309,   310,    -1,   312,    -1,
     314,    -1,   316,   317,   318,   319,   320,   321,   322,   323,
     324,    -1,    -1,   327,   328,    -1,    -1,   331,   332,   333,
     334,    -1,    -1,    -1,    -1,   339,    -1,    -1,    -1,    -1,
     344,   345,   346,    -1,   348,   349,   350,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,    -1,    -1,   367,   368,   369,    -1,   371,   372,   373,
     374,   375,   376,    -1,    -1,    -1,    -1,   381,   382,    -1,
     384,    -1,   386,   387,   388,   389,   390,    -1,   392,   393,
     394,    -1,    -1,   397,    -1,    -1,    -1,   401,   402,   403,
     404,   405,    -1,    -1,   408,   409,   410,   411,   412,    -1,
     414,    -1,    -1,   417,    -1,   419,   420,    -1,   422,    -1,
      -1,    -1,   426,    -1,    -1,   429,   430,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,   440,    -1,   442,   443,
      -1,   445,    -1,    -1,    -1,    -1,   450,   451,   452,    -1,
      -1,    -1,    -1,   457,    -1,    -1,    -1,   461,    -1,    -1,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,    -1,
      -1,    -1,    -1,    -1,    -1,   479,   480,    -1,   482,    -1,
      -1,   485,    -1,    -1,   488,    -1,   490,    -1,    -1,    -1,
     494,    -1,   496,   497,   498,   499,   500,   501,    -1,    -1,
     504,   505,   506,   507,    -1,   509,   510,    -1,    -1,   513,
     514,   515,   516,    -1,    -1,   519,   520,    -1,   522,   523,
     524,   525,    -1,    -1,    -1,    -1,    -1,   531,   532,    -1,
      -1,    -1,    -1,   537,   538,   539,    -1,   541,   542,    -1,
     544,   545,    -1,    -1,    -1,    -1,    -1,   551,    -1,    -1,
     554,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,
      -1,    -1,   566,    -1,    -1,   569,    -1,    -1,    -1,   573,
     574,   575,   576,   577,    -1,   579,    -1,    -1,    -1,   583,
      -1,    -1,   586,    -1,   588,    -1,     5,   591,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    17,    -1,
      -1,    -1,    -1,    22,    23,    24,    25,    26,    27,    -1,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    51,    52,    -1,    54,    55,    -1,    57,    -1,
      -1,    -1,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    -1,    74,    -1,    76,    77,    78,
      79,    -1,    81,    82,    -1,    84,    85,    86,    -1,    88,
      -1,    90,    -1,    -1,    93,    -1,    -1,    96,    -1,    -1,
      -1,   100,    -1,    -1,    -1,   104,   105,   106,    -1,    -1,
     109,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,
      -1,   120,    -1,   122,    -1,    -1,    -1,   126,    -1,   128,
     129,   130,   131,    -1,    -1,    -1,    -1,    -1,    -1,   138,
     139,   140,    -1,    -1,    -1,   144,    -1,   146,   147,    -1,
     149,   150,   151,    -1,    -1,   154,   155,    -1,   157,   158,
     159,   160,    -1,    -1,    -1,   164,   165,   166,    -1,    -1,
     169,   170,   171,   172,   173,   174,    -1,    -1,    -1,    -1,
      -1,    -1,   181,    -1,   183,    -1,   185,    -1,   187,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,    -1,   198,
      -1,    -1,    -1,    -1,    -1,   204,    -1,    -1,    -1,   208,
     209,   210,   211,   212,    -1,   214,   215,   216,    -1,    -1,
     219,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,    -1,
     229,    -1,   231,   232,    -1,   234,   235,   236,    -1,    -1,
     239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,    -1,
     249,   250,    -1,    -1,    -1,    -1,    -1,   256,   257,    -1,
     259,    -1,   261,    -1,   263,   264,    -1,    -1,    -1,    -1,
     269,    -1,    -1,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,   286,   287,   288,
      -1,   290,   291,   292,   293,    -1,   295,   296,    -1,    -1,
      -1,    -1,   301,   302,   303,   304,   305,   306,    -1,    -1,
     309,   310,    -1,   312,    -1,   314,    -1,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,   327,   328,
      -1,    -1,   331,   332,   333,   334,    -1,    -1,    -1,    -1,
     339,    -1,    -1,    -1,    -1,   344,   345,   346,    -1,   348,
     349,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,    -1,    -1,   367,   368,
     369,    -1,   371,   372,   373,   374,   375,   376,    -1,    -1,
      -1,    -1,   381,   382,    -1,   384,    -1,   386,   387,   388,
     389,   390,    -1,   392,   393,   394,    -1,    -1,   397,    -1,
      -1,    -1,   401,   402,   403,   404,   405,    -1,    -1,   408,
     409,   410,   411,   412,    -1,   414,    -1,    -1,   417,    -1,
     419,   420,    -1,   422,    -1,    -1,    -1,   426,    -1,    -1,
     429,   430,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,   443,    -1,   445,    -1,    -1,    -1,
      -1,   450,   451,   452,    -1,    -1,    -1,    -1,   457,    -1,
      -1,    -1,   461,    -1,    -1,   464,    -1,   466,    -1,   468,
      -1,    -1,   471,   472,    -1,    -1,    -1,    -1,    -1,    -1,
     479,   480,    -1,   482,    -1,    -1,   485,    -1,    -1,   488,
      -1,   490,    -1,    -1,    -1,   494,    -1,   496,   497,   498,
     499,   500,   501,    -1,    -1,   504,   505,   506,   507,    -1,
     509,   510,    -1,    -1,   513,   514,  