#!/bin/sh
#
# sift through /proc/bus/input/devices and return either a straight listing
# of all event devices, or a map of eventX->physical device.

usage () {
	echo "Usage: $0 (map|list|phys) [arg]"
	echo "	map: display a list of all event devices and associated"
	echo "		physical devices of type [arg]"
	echo "  list: display a list of all event devices of type [arg]"
	echo "	phys: displays the physical device for event device [arg]"
	exit 1
}


CMD=$1
ARG=${2#/dev/input/}

if [ -z "$CMD" ]; then
	usage
elif [ "$CMD" = "phys" ] && [ -z "$ARG" ]; then
	usage
elif ! [ "$CMD" = "map" ] && ! [ "$CMD" = "list" ] && \
     ! [ "$CMD" = "phys" ]; then
	usage
fi

exec < /proc/bus/input/devices
while read line; do
	case $line in
	     "H: Handlers="*)
	        handlers=${line#"H: Handlers="}
		for i in $handlers; do
			case $i in
			  event*)
				EVENT=$i
				;;
			  $ARG*)
			  	[ -z "$PRINT" ] && PRINT="yes"
				;;
			esac
		done
		;;
	     "P: Phys="*)
		PHYS=${line#"P: Phys="}
		;;
	     "N: Name="*)
		name=${line#"N: Name="}
		# while handled by the kbd driver, it is uninteresting to us as
		# an actual input device.
		[ "x$name" = 'x"PC Speaker"' ] && PRINT="no"
		;;
	     "")
		if [ "$CMD" = "map" ] && [ "x$PRINT" = "xyes" ]; then
			echo "$EVENT $PHYS"
		fi
		if [ "$CMD" = "list" ] && [ "x$PRINT" = "xyes" ]; then
			echo $EVENT
		fi
		if [ "$CMD" = "phys" ] && [ "$EVENT" = "$ARG" ]; then
			echo $PHYS
		fi
		PRINT=""
		;;
	esac
done
