# -*- mode: makefile; coding: utf-8 -*-

# Copyright (c) 2008 Canonical Ltd.
# Author(s): Alexander Sack <asac@ubuntu.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.


# arguments: MOZ_TRANSLATION_TARGET_DIRS - application names that this xpi is suitable for
#            MOZ_TRANSLATION_TARGET_IDS  - application IDS that this xpi can be hosted on
#            MOZ_TRANSLATION_TARGET_MAX_VERSION_$(ID) - max version for the target application with ID
#            MOZ_TRANSLATION_TARGET_MIN_VERSION_($ID) - min version for the target application with ID
#
#            MOZ_TRANSLATION_AUTO_XPI_LOCALE - locales you want to generate xpis automatically for
#            MOZ_TRANSLATION_AUTO_XPI_SEARCHDIRS - directories you want to inspect for install manifests
#                                                  and extract locale content from
#            MOZ_TRANSLATION_AUTO_XPI_OUTDIR
#


MOZ_TRANSLATION_AUTO_XPI_LOCALE ?= en-US
MOZ_TRANSLATION_TARGET_IDS ?= {firefox-id}
MOZ_TRANSLATION_TARGET_DIRS ?= firefox-addons
MOZ_TRANSLATION_AUTO_XPI_OUTDIR ?= debian/lp-export-xpis/
#MOZ_TRANSLATION_TARGET_MAX_VERSION_{firefox-id} = 3.0.*
#MOZ_TRANSLATION_TARGET_MIN_VERSION_{firefox-id} = 3.0b3

# ----  define $(call ...) functions

MOZCALL_all_manifests = \
	$(shell \
		find $(MOZ_TRANSLATION_AUTO_XPI_SEARCHDIRS) -name \*.manifest \
	)

MOZCALL_filter_manifest_locales_by_lang_to_norm = \
	$(shell \
		cat $(1) | grep "^locale " | grep " $(2) " >> $(3) \
	)

MOZCALL_manifest_locale_files_to_outdir = \
	$(shell \
		if test `grep -c ^locale $(1)` -gt 0; then \
			localefiles=`cat $(1) | \
				grep "^locale[[:space:]]" | \
				grep "[[:space:]]$(2)[[:space:]]" | \
				sed -e 's/^.*[[:space:]][[:space:]]*$(2)[[:space:]][[:space:]]*jar:\(.*\)!.*$$/\1/' | \
				sed -e 's/^.*[[:space:]][[:space:]]*$(2)[[:space:]][[:space:]]*\(.*\)$$/\1/' \
			`; \
			echo "tar -c -C `dirname $(1)`/ -f - $$localefiles \| \
			tar -C $(3) -x -f - " > /tmp/cmd; \
			tar -c -C `dirname $(1)`/ -f - $$localefiles | \
			tar -C $(3) -x -f -; \
		 fi \
	)


# ---- define generic targets

%.mkdir:
	mkdir -p $*


# create xpi in 3 steps:
#   1. mkdir flat directory
#   2. fill directory with locale files
#   3. generate manifest

$(MOZ_TRANSLATION_AUTO_XPI_OUTDIR)%.xpi: \
	$(MOZ_TRANSLATION_AUTO_XPI_OUTDIR)%.xpi-flat.mkdir

	# extract locale filenames from $$(MOZCALL_all_manifests) and
	# move the files to $$(MOZCALL_manifest_locale_files_to_outdir)
	$(foreach manifest,$(MOZCALL_all_manifests), \
		$(call MOZCALL_manifest_locale_files_to_outdir, \
			$(manifest),$*,$@-flat/))

	# produce chrome.manifest for all locale entries
	$(foreach manifest,$(MOZCALL_all_manifests), \
		$(call MOZCALL_filter_manifest_locales_by_lang_to_norm, \
			$(manifest),$*,$@-flat/chrome.manifest))

	@sh -c "cd $@-flat/; zip -r ../$*.xpi ."
	rm -rf $@-flat/


# translate
auto-locale-xpi.mk/translate : \
	$(foreach l,$(MOZ_TRANSLATION_AUTO_XPI_LOCALE),$(MOZ_TRANSLATION_AUTO_XPI_OUTDIR)$(l).xpi)


auto-locale-xpi.mk/clean:
	rm -rf $(MOZ_TRANSLATION_AUTO_XPI_OUTDIR)*.xpi $(MOZ_TRANSLATION_AUTO_XPI_OUTDIR)*.xpi-flat


# ---- hook in cdbs

# run this in binary-post-install
binary-post-install/%:: auto-locale-xpi.mk/translate

clean::
	rm -rf $(MOZ_TRANSLATION_AUTO_XPI_OUTDIR)/

