//
// System.Web.UI.WebControls.TreeViewTest.cs
//	- Unit tests for System.Web.UI.Webcontrols.TreeView
// 
//
// Authors:
//	Chris Toshok (toshok@ximian.com)
//  Hagit Yidov (hagity@mainsoft.com
//
// (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//

#if NET_2_0
using System;
using System.IO;
using System.Globalization;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using MonoTests.stand_alone.WebHarness;
using MonoTests.SystemWeb.Framework;
using System.Xml;
using System.Collections.Specialized;
using System.Threading;

using NUnit.Framework;

namespace MonoTests.System.Web.UI.WebControls {
	public class TreeViewPoker : TreeView {
	}
	class PokerTreeView : TreeView {
		// View state Stuff
		public PokerTreeView () {
			TrackViewState ();
		}
		public object SaveState () {
			return SaveViewState ();
		}
		public void LoadState (object o) {
			LoadViewState (o);
		}
		public StateBag StateBag {
			get { return base.ViewState; }
		}

		public HtmlTextWriterTag TagKeyFromBase {
			get { return base.TagKey; }
		}

		// Protected Methods
		public void DataBindFromBase (bool raiseOnDataBinding) {
			base.DataBind (raiseOnDataBinding);
		}
		public void AddAttributesToRenderBase (HtmlTextWriter writer) {
			base.AddAttributesToRender (writer);
		}
		public ControlCollection CreateControlCollectionBase () {
			return (base.CreateControlCollection ());
		}
		public TreeNode CreateNodeBase () {
			TreeNode tn = base.CreateNode ();
			tn.Text = "New Tree Node";
			return (tn);
		}
		public void RaiseCallbackEventBase (string eventArgument) {
			base.RaiseCallbackEvent (eventArgument);
		}
		public string GetCallbackResultBase () {
			return (base.GetCallbackResult ());
		}
		public void SetNodeDataBoundBase (TreeNode node, bool dataBound) {
			base.SetNodeDataBound (node, dataBound);
		}
		public void SetNodeDataItemBase (TreeNode node, object dataItem) {
			base.SetNodeDataItem (node, dataItem);
		}
		public void SetNodeDataPathBase (TreeNode node, string dataPath) {
			base.SetNodeDataPath (node, dataPath);
		}
		public void PerformDataBindingBase () {
			base.PerformDataBinding ();
		}

		// Events
		public void OnInitBase (EventArgs e) { base.OnInit (e); }
		public void OnPreRenderBase (EventArgs e) { base.OnPreRender (e); }
		public void OnSelectedNodeChangedBase (EventArgs e) { base.OnSelectedNodeChanged (e); }
		public void OnTreeNodeCheckChangedBase (TreeNodeEventArgs e) { base.OnTreeNodeCheckChanged (e); }
		public void OnTreeNodeCollapsedBase (TreeNodeEventArgs e) { base.OnTreeNodeCollapsed (e); }
		public void OnTreeNodeDataBoundBase (TreeNodeEventArgs e) { base.OnTreeNodeDataBound (e); }
		public void OnTreeNodeExpandedBase (TreeNodeEventArgs e) { base.OnTreeNodeExpanded (e); }
		public void OnTreeNodePopulateBase (TreeNodeEventArgs e) { base.OnTreeNodePopulate (e); }
		public void OnBubbleEventBase (Object o, EventArgs e) { base.OnBubbleEvent (o, e); }
	}

	[TestFixture]
	public class TreeViewTest {

		[TestFixtureSetUp]
		public void SetUp ()
		{
#if DOT_NET
			WebTest.CopyResource (GetType (), "MonoTests.System.Web.UI.WebControls.Resources.NoEventValidation.aspx", "NoEventValidation.aspx");
#else
			WebTest.CopyResource (GetType (), "NoEventValidation.aspx", "NoEventValidation.aspx");
#endif
		}

		[Test]
		public void Defaults () {
			TreeViewPoker p = new TreeViewPoker ();

			Assert.AreEqual ("Collapse {0}", p.CollapseImageToolTip, "A1");
			Assert.IsTrue (p.AutoGenerateDataBindings, "A2");
			Assert.AreEqual ("", p.CollapseImageUrl, "A3");
			Assert.IsNotNull (p.DataBindings, "A4");
			Assert.AreEqual (0, p.DataBindings.Count, "A4.1");
			Assert.IsTrue (p.EnableClientScript, "A5");
			Assert.AreEqual (-1, p.ExpandDepth, "A6");
			Assert.AreEqual ("Expand {0}", p.ExpandImageToolTip, "A7");
			Assert.AreEqual ("", p.ExpandImageUrl, "A8");
			Assert.IsNotNull (p.HoverNodeStyle, "A9");
			Assert.AreEqual (TreeViewImageSet.Custom, p.ImageSet, "A10");
			Assert.IsNotNull (p.LeafNodeStyle, "A11");
			Assert.IsNotNull (p.LevelStyles, "A12");
			Assert.AreEqual (0, p.LevelStyles.Count, "A12.1");
			Assert.AreEqual ("", p.LineImagesFolder, "A13");
			Assert.AreEqual (-1, p.MaxDataBindDepth, "A14");
			Assert.AreEqual (20, p.NodeIndent, "A15");
			Assert.IsNotNull (p.Nodes, "A16");
			Assert.AreEqual (0, p.Nodes.Count, "A16.1");
			Assert.IsNotNull (p.NodeStyle, "A17");
			Assert.IsFalse (p.NodeWrap, "A18");
			Assert.AreEqual ("", p.NoExpandImageUrl, "A19");
			Assert.IsNotNull (p.ParentNodeStyle, "A20");
			Assert.AreEqual ('/', p.PathSeparator, "A21");
			Assert.IsTrue (p.PopulateNodesFromClient, "A22");
			Assert.IsNotNull (p.RootNodeStyle, "A23");
			Assert.IsNotNull (p.SelectedNodeStyle, "A24");
			Assert.AreEqual (TreeNodeTypes.None, p.ShowCheckBoxes, "A25");
			Assert.IsTrue (p.ShowExpandCollapse, "A26");
			Assert.AreEqual ("Skip Navigation Links.", p.SkipLinkText, "A27");
			Assert.IsNull (p.SelectedNode, "A28");
			Assert.AreEqual ("", p.SelectedValue, "A29");
			Assert.AreEqual ("", p.Target, "A30");
			Assert.IsTrue (p.Visible, "A31");
		}

		[Test]
		public void TreeView_DefaultProperties () {
			PokerTreeView tv = new PokerTreeView ();
			Assert.AreEqual (0, tv.StateBag.Count, "ViewState.Count");
			// Public Properties
			Assert.AreEqual (true, tv.AutoGenerateDataBindings, "AutoGenerateDataBindings");
			Assert.AreEqual (0, tv.CheckedNodes.Count, "CheckedNodes");
			Assert.AreEqual ("Collapse {0}", tv.CollapseImageToolTip, "CollapseImageToolTip");
			Assert.AreEqual (string.Empty, tv.CollapseImageUrl, "CollapseImageUrl");
			Assert.AreEqual (0, tv.DataBindings.Count, "DataBindings");
			Assert.AreEqual (true, tv.EnableClientScript, "EnableClientScript");
			Assert.AreEqual (-1, tv.ExpandDepth, "ExpandDepth");
			Assert.AreEqual ("Expand {0}", tv.ExpandImageToolTip, "ExpandImageToolTip");
			Assert.AreEqual (string.Empty, tv.ExpandImageUrl, "ExpandImageUrl");
			Assert.AreEqual (TreeViewImageSet.Custom, tv.ImageSet, "ImageSet");
			Assert.AreEqual (0, tv.LevelStyles.Count, "LevelStyles");
			Assert.AreEqual (string.Empty, tv.LineImagesFolder, "LineImagesFolder");
			Assert.AreEqual (-1, tv.MaxDataBindDepth, "MaxDataBindDepth");
			Assert.AreEqual (20, tv.NodeIndent, "NodeIndent");
			Assert.AreEqual (0, tv.Nodes.Count, "Nodes");
			Assert.AreEqual (false, tv.NodeWrap, "NodeWrap");
			Assert.AreEqual (string.Empty, tv.NoExpandImageUrl, "NoExpandImageUrl");
			Assert.AreEqual (true, tv.PopulateNodesFromClient, "PopulateNodesFromClient");
			Assert.AreEqual (null, tv.SelectedNode, "SelectedNode");
			Assert.AreEqual (string.Empty, tv.SelectedValue, "SelectedValue");
			Assert.AreEqual (TreeNodeTypes.None, tv.ShowCheckBoxes, "ShowCheckBoxes");
			Assert.AreEqual (true, tv.ShowExpandCollapse, "ShowExpandCollapse");
			Assert.AreEqual (false, tv.ShowLines, "ShowLines");
			Assert.AreEqual ("Skip Navigation Links.", tv.SkipLinkText, "SkipLinkText");
			Assert.AreEqual (string.Empty, tv.Target, "Target");
			Assert.AreEqual (true, tv.Visible, "Visible");
			// Protected Properties
			Assert.AreEqual (HtmlTextWriterTag.Div, tv.TagKeyFromBase, "TagKey");
		}

		[Test]
		public void Treeview_AssignToDefaultProperties () {
			PokerTreeView tv = new PokerTreeView ();
			Assert.AreEqual (0, tv.StateBag.Count, "ViewState.Count");

			tv.AutoGenerateDataBindings = true;
			Assert.AreEqual (true, tv.AutoGenerateDataBindings, "AutoGenerateDataBindings");
			Assert.AreEqual (1, tv.StateBag.Count, "ViewState.Count-1");

			//tv.CheckedNodes.Add (new TreeNode ());
			//Assert.AreEqual (1, tv.CheckedNodes.Count, "CheckedNodes");
			//Assert.AreEqual (1, tv.StateBag.Count, "ViewState.Count-2");

			tv.CollapseImageToolTip = "Collapse {0}";
			Assert.AreEqual ("Collapse {0}", tv.CollapseImageToolTip, "CollapseImageToolTip");
			Assert.AreEqual (2, tv.StateBag.Count, "ViewState.Count-3");

			tv.CollapseImageUrl = string.Empty;
			Assert.AreEqual (string.Empty, tv.CollapseImageUrl, "CollapseImageUrl");
			Assert.AreEqual (3, tv.StateBag.Count, "ViewState.Count-4");

			tv.DataBindings.Add (new TreeNodeBinding ());
			Assert.AreEqual (1, tv.DataBindings.Count, "DataBindings");
			Assert.AreEqual (3, tv.StateBag.Count, "ViewState.Count-5");

			tv.EnableClientScript = true;
			Assert.AreEqual (true, tv.EnableClientScript, "EnableClientScript");
			Assert.AreEqual (4, tv.StateBag.Count, "ViewState.Count-6");

			tv.ExpandDepth = -1;
			Assert.AreEqual (-1, tv.ExpandDepth, "ExpandDepth");
			Assert.AreEqual (5, tv.StateBag.Count, "ViewState.Count-7");

			tv.ExpandImageToolTip = "Expand {0}";
			Assert.AreEqual ("Expand {0}", tv.ExpandImageToolTip, "ExpandImageToolTip");
			Assert.AreEqual (6, tv.StateBag.Count, "ViewState.Count-8");

			tv.ExpandImageUrl = string.Empty;
			Assert.AreEqual (string.Empty, tv.ExpandImageUrl, "ExpandImageUrl");
			Assert.AreEqual (7, tv.StateBag.Count, "ViewState.Count-9");

			tv.ImageSet = TreeViewImageSet.Custom;
			Assert.AreEqual (TreeViewImageSet.Custom, tv.ImageSet, "ImageSet");
			Assert.AreEqual (8, tv.StateBag.Count, "ViewState.Count-10");

			tv.LevelStyles.Add (new TreeNodeStyle ());
			Assert.AreEqual (1, tv.LevelStyles.Count, "LevelStyles");
			Assert.AreEqual (8, tv.StateBag.Count, "ViewState.Count-11");

			tv.LineImagesFolder = string.Empty;
			Assert.AreEqual (string.Empty, tv.LineImagesFolder, "LineImagesFolder");
			Assert.AreEqual (9, tv.StateBag.Count, "ViewState.Count-12");

			tv.MaxDataBindDepth = -1;
			Assert.AreEqual (-1, tv.MaxDataBindDepth, "MaxDataBindDepth");
			Assert.AreEqual (10, tv.StateBag.Count, "ViewState.Count-13");

			tv.NodeIndent = 20;
			Assert.AreEqual (20, tv.NodeIndent, "NodeIndent");
			Assert.AreEqual (11, tv.StateBag.Count, "ViewState.Count-14");

			tv.Nodes.Add (new TreeNode ());
			Assert.AreEqual (1, tv.Nodes.Count, "Nodes");
			Assert.AreEqual (11, tv.StateBag.Count, "ViewState.Count-15");

			tv.NodeWrap = false;
			Assert.AreEqual (false, tv.NodeWrap, "NodeWrap");
			Assert.AreEqual (12, tv.StateBag.Count, "ViewState.Count-16");

			tv.NoExpandImageUrl = string.Empty;
			Assert.AreEqual (string.Empty, tv.NoExpandImageUrl, "NoExpandImageUrl");
			Assert.AreEqual (13, tv.StateBag.Count, "ViewState.Count-17");

			tv.PopulateNodesFromClient = true;
			Assert.AreEqual (true, tv.PopulateNodesFromClient, "PopulateNodesFromClient");
			Assert.AreEqual (14, tv.StateBag.Count, "ViewState.Count-18");

			tv.ShowCheckBoxes = TreeNodeTypes.None;
			Assert.AreEqual (TreeNodeTypes.None, tv.ShowCheckBoxes, "ShowCheckBoxes");
			Assert.AreEqual (15, tv.StateBag.Count, "ViewState.Count-19");

			tv.ShowExpandCollapse = true;
			Assert.AreEqual (true, tv.ShowExpandCollapse, "ShowExpandCollapse");
			Assert.AreEqual (16, tv.StateBag.Count, "ViewState.Count-20");

			tv.ShowLines = false;
			Assert.AreEqual (false, tv.ShowLines, "ShowLines");
			Assert.AreEqual (17, tv.StateBag.Count, "ViewState.Count-21");

			tv.SkipLinkText = "Skip Navigation Links.";
			Assert.AreEqual ("Skip Navigation Links.", tv.SkipLinkText, "SkipLinkText");
			Assert.AreEqual (18, tv.StateBag.Count, "ViewState.Count-22");

			tv.Target = string.Empty;
			Assert.AreEqual (string.Empty, tv.Target, "Target");
			Assert.AreEqual (19, tv.StateBag.Count, "ViewState.Count-23");

			tv.Visible = true;
			Assert.AreEqual (true, tv.Visible, "Visible");
			Assert.AreEqual (19, tv.StateBag.Count, "ViewState.Count-24");
		}

		[Test]
		public void Treeview_ViewState () {
			PokerTreeView tv = new PokerTreeView ();
			tv.AutoGenerateDataBindings = true;
			Assert.AreEqual (true, tv.AutoGenerateDataBindings, "AutoGenerateDataBindings-beforecopy");
			TreeNode node = new TreeNode ();
			node.Checked = true;
			tv.Nodes.Add (node);
			tv.Nodes.Add (new TreeNode ());
			Assert.AreEqual (2, tv.Nodes.Count, "Nodes-beforecopy");
			Assert.AreEqual (1, tv.CheckedNodes.Count, "CheckedNodes-beforecopy");
			tv.CollapseImageToolTip = "Collapse {0}";
			Assert.AreEqual ("Collapse {0}", tv.CollapseImageToolTip, "CollapseImageToolTip-beforecopy");
			tv.CollapseImageUrl = string.Empty;
			Assert.AreEqual (string.Empty, tv.CollapseImageUrl, "CollapseImageUrl-beforecopy");
			tv.DataBindings.Add (new TreeNodeBinding ());
			Assert.AreEqual (1, tv.DataBindings.Count, "DataBindings-beforecopy");
			tv.EnableClientScript = true;
			Assert.AreEqual (true, tv.EnableClientScript, "EnableClientScript-beforecopy");
			tv.ExpandDepth = -1;
			Assert.AreEqual (-1, tv.ExpandDepth, "ExpandDepth-beforecopy");
			tv.ExpandImageToolTip = "Expand {0}";
			Assert.AreEqual ("Expand {0}", tv.ExpandImageToolTip, "ExpandImageToolTip-beforecopy");
			tv.ExpandImageUrl = string.Empty;
			Assert.AreEqual (string.Empty, tv.ExpandImageUrl, "ExpandImageUrl-beforecopy");
			tv.ImageSet = TreeViewImageSet.Custom;
			Assert.AreEqual (TreeViewImageSet.Custom, tv.ImageSet, "ImageSet-beforecopy");
			tv.LevelStyles.Add (new TreeNodeStyle ());
			Assert.AreEqual (1, tv.LevelStyles.Count, "LevelStyles-beforecopy");
			tv.LineImagesFolder = string.Empty;
			Assert.AreEqual (string.Empty, tv.LineImagesFolder, "LineImagesFolder-beforecopy");
			tv.MaxDataBindDepth = -1;
			Assert.AreEqual (-1, tv.MaxDataBindDepth, "MaxDataBindDepth-beforecopy");
			tv.NodeIndent = 20;
			Assert.AreEqual (20, tv.NodeIndent, "NodeIndent-beforecopy");
			tv.NodeWrap = false;
			Assert.AreEqual (false, tv.NodeWrap, "NodeWrap-beforecopy");
			tv.NoExpandImageUrl = string.Empty;
			Assert.AreEqual (string.Empty, tv.NoExpandImageUrl, "NoExpandImageUrl-beforecopy");
			tv.PopulateNodesFromClient = true;
			Assert.AreEqual (true, tv.PopulateNodesFromClient, "PopulateNodesFromClient-beforecopy");
			tv.ShowCheckBoxes = TreeNodeTypes.None;
			Assert.AreEqual (TreeNodeTypes.None, tv.ShowCheckBoxes, "ShowCheckBoxes-beforecopy");
			tv.ShowExpandCollapse = true;
			Assert.AreEqual (true, tv.ShowExpandCollapse, "ShowExpandCollapse-beforecopy");
			tv.ShowLines = false;
			Assert.AreEqual (false, tv.ShowLines, "ShowLines-beforecopy");
			tv.SkipLinkText = "Skip Navigation Links.";
			Assert.AreEqual ("Skip Navigation Links.", tv.SkipLinkText, "SkipLinkText-beforecopy");
			tv.Target = string.Empty;
			Assert.AreEqual (string.Empty, tv.Target, "Target-beforecopy");
			tv.Visible = true;
			Assert.AreEqual (true, tv.Visible, "Visible-beforecopy");
			object state = tv.SaveState ();
			PokerTreeView copy = new PokerTreeView ();
			copy.LoadState (state);
			Assert.AreEqual (true, copy.AutoGenerateDataBindings, "AutoGenerateDataBindings-aftercopy");
			Assert.AreEqual ("Collapse {0}", copy.CollapseImageToolTip, "CollapseImageToolTip-aftercopy");
			Assert.AreEqual (string.Empty, copy.CollapseImageUrl, "CollapseImageUrl-aftercopy");
			Assert.AreEqual (true, copy.EnableClientScript, "EnableClientScript-aftercopy");
			Assert.AreEqual (-1, copy.ExpandDepth, "ExpandDepth-aftercopy");
			Assert.AreEqual ("Expand {0}", copy.ExpandImageToolTip, "ExpandImageToolTip-aftercopy");
			Assert.AreEqual (string.Empty, copy.ExpandImageUrl, "ExpandImageUrl-aftercopy");
			Assert.AreEqual (TreeViewImageSet.Custom, copy.ImageSet, "ImageSet-aftercopy");
			Assert.AreEqual (1, copy.LevelStyles.Count, "LevelStyles-aftercopy");
			Assert.AreEqual (string.Empty, copy.LineImagesFolder, "LineImagesFolder-aftercopy");
			Assert.AreEqual (-1, copy.MaxDataBindDepth, "MaxDataBindDepth-aftercopy");
			Assert.AreEqual (20, copy.NodeIndent, "NodeIndent-aftercopy");
			Assert.AreEqual (2, copy.Nodes.Count, "Nodes-aftercopy");
			Assert.AreEqual (false, copy.NodeWrap, "NodeWrap-aftercopy");
			Assert.AreEqual (string.Empty, copy.NoExpandImageUrl, "NoExpandImageUrl-aftercopy");
			Assert.AreEqual (true, copy.PopulateNodesFromClient, "PopulateNodesFromClient-aftercopy");
			Assert.AreEqual (TreeNodeTypes.None, copy.ShowCheckBoxes, "ShowCheckBoxes-aftercopy");
			Assert.AreEqual (true, copy.ShowExpandCollapse, "ShowExpandCollapse-aftercopy");
			Assert.AreEqual (false, copy.ShowLines, "ShowLines-aftercopy");
			Assert.AreEqual ("Skip Navigation Links.", copy.SkipLinkText, "SkipLinkText-aftercopy");
			Assert.AreEqual (string.Empty, copy.Target, "Target-aftercopy");
			Assert.AreEqual (true, copy.Visible, "Visible-aftercopy");
		}

		[Test]
		public void TreeView_ViewStateNodes () {
			PokerTreeView tv = new PokerTreeView ();
			TreeNode R = new TreeNode ("root", "value-root");
			TreeNode N1 = new TreeNode ("node1", "value-node1");
			TreeNode N2 = new TreeNode ("node2", "value-node2");
			R.ChildNodes.Add (N1);
			R.ChildNodes.Add (N2);
			tv.Nodes.Add (R);
			PokerTreeView copy = new PokerTreeView ();
			object state = tv.SaveState ();
			copy.LoadState (state);
			Assert.AreEqual (1, tv.Nodes.Count, "ViewStateNodes-1");
			Assert.AreEqual (2, tv.Nodes[0].ChildNodes.Count, "ViewStateNodes-1");
			Assert.AreEqual (0, tv.Nodes[0].ChildNodes[0].ChildNodes.Count, "ViewStateNodes-2");
			Assert.AreEqual ("node1", tv.Nodes[0].ChildNodes[0].Text, "ViewStateNodes-3");
			Assert.AreEqual ("value-node1", tv.Nodes[0].ChildNodes[0].Value, "ViewStateNodes-4");
			Assert.AreEqual (false, tv.Nodes[0].ChildNodes[0].DataBound, "ViewStateNodes-5");
			Assert.AreEqual ("", tv.Nodes[0].ChildNodes[0].DataPath, "ViewStateNodes-6");
		}

		private static string xmlDataBind = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><Book Title=\"Book Title\"><Chapter Heading=\"Chapter 1\"><Section Heading=\"Section 1\"></Section><Section Heading=\"Section 2\"></Section></Chapter><Chapter Heading=\"Chapter 2\"><Section Heading=\"Section 1\"></Section></Chapter></Book>";
		private static string xmlDataBindSmall = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><Book Title=\"Book Title\"></Book>";

		[Test]
		public void TreeView_ViewStateDataBoundNodes () {
			PokerTreeView b = new PokerTreeView ();
			SetDataBindings (b);
			b.DataSource = CreateXmlDataSource ();
			b.DataBind ();
			PokerTreeView copy = new PokerTreeView ();
			object state = b.SaveState ();
			copy.LoadState (state);
			CheckTreeNodes (copy);
		}

		private static void CheckTreeNodes (TreeView m) {
			Assert.AreEqual (1, m.Nodes.Count, "CheckTreeNodes#1");
			Assert.AreEqual (10, m.Nodes[0].ChildNodes.Count, "CheckTreeNodes#2");
			Assert.AreEqual (0, m.Nodes[0].ChildNodes[0].ChildNodes.Count, "CheckTreeNodes#3");
			Assert.AreEqual (true, m.Nodes[0].ChildNodes[0].DataBound, "CheckTreeNodes#4");
			Assert.AreEqual ("/*[position()=1]/*[position()=1]", m.Nodes[0].ChildNodes[0].DataPath, "CheckTreeNodes#5");

			Assert.AreEqual ("img#root", m.Nodes[0].ImageUrl, "CheckTreeNodes_ImageUrl#1");
			Assert.AreEqual ("img#1", m.Nodes[0].ChildNodes[0].ImageUrl, "CheckTreeNodes_ImageUrl#2");
			Assert.AreEqual ("img#2", m.Nodes[0].ChildNodes[1].ImageUrl, "CheckTreeNodes_ImageUrl#3");
			Assert.AreEqual ("img#default", m.Nodes[0].ChildNodes[2].ImageUrl, "CheckTreeNodes_ImageUrl#4");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[2].ChildNodes[0].ImageUrl, "CheckTreeNodes_ImageUrl#5");

			Assert.AreEqual ("url#root", m.Nodes[0].NavigateUrl, "CheckTreeNodes_NavigateUrl#1");
			Assert.AreEqual ("url#1", m.Nodes[0].ChildNodes[0].NavigateUrl, "CheckTreeNodes_NavigateUrl#2");
			Assert.AreEqual ("url#2", m.Nodes[0].ChildNodes[1].NavigateUrl, "CheckTreeNodes_NavigateUrl#3");
			Assert.AreEqual ("url#default", m.Nodes[0].ChildNodes[2].NavigateUrl, "CheckTreeNodes_NavigateUrl#4");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[2].ChildNodes[0].NavigateUrl, "CheckTreeNodes_NavigateUrl#5");

			Assert.AreEqual ("target#root", m.Nodes[0].Target, "CheckTreeNodes_Target#1");
			Assert.AreEqual ("target#1", m.Nodes[0].ChildNodes[0].Target, "CheckTreeNodes_Target#2");
			Assert.AreEqual ("target#2", m.Nodes[0].ChildNodes[1].Target, "CheckTreeNodes_Target#3");
			Assert.AreEqual ("target#default", m.Nodes[0].ChildNodes[2].Target, "CheckTreeNodes_Target#4");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[2].ChildNodes[0].Target, "CheckTreeNodes_Target#5");

			Assert.AreEqual ("text#root", m.Nodes[0].Text, "CheckTreeNodes_Text#1");
			Assert.AreEqual ("text#1", m.Nodes[0].ChildNodes[0].Text, "CheckTreeNodes_Text#2");
			Assert.AreEqual ("text#2", m.Nodes[0].ChildNodes[1].Text, "CheckTreeNodes_Text#3");
			Assert.AreEqual ("text#", m.Nodes[0].ChildNodes[2].Text, "CheckTreeNodes_Text#4");
			Assert.AreEqual ("subnode", m.Nodes[0].ChildNodes[2].ChildNodes[0].Text, "CheckTreeNodes_Text#5");

			Assert.AreEqual ("tooltip#root", m.Nodes[0].ToolTip, "CheckTreeNodes_ToolTip#1");
			Assert.AreEqual ("tooltip#1", m.Nodes[0].ChildNodes[0].ToolTip, "CheckTreeNodes_ToolTip#2");
			Assert.AreEqual ("tooltip#2", m.Nodes[0].ChildNodes[1].ToolTip, "CheckTreeNodes_ToolTip#3");
			Assert.AreEqual ("tooltip#default", m.Nodes[0].ChildNodes[2].ToolTip, "CheckTreeNodes_ToolTip#4");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[2].ChildNodes[0].ToolTip, "CheckTreeNodes_ToolTip#5");

			Assert.AreEqual ("imagetooltip#root", m.Nodes[0].ImageToolTip, "CheckTreeNodes_ImageToolTip#1");
			Assert.AreEqual ("imagetooltip#1", m.Nodes[0].ChildNodes[0].ImageToolTip, "CheckTreeNodes_ImageToolTip#2");
			Assert.AreEqual ("imagetooltip#2", m.Nodes[0].ChildNodes[1].ImageToolTip, "CheckTreeNodes_ImageToolTip#3");
			Assert.AreEqual ("imagetooltip#default", m.Nodes[0].ChildNodes[2].ImageToolTip, "CheckTreeNodes_ImageToolTip#4");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[2].ChildNodes[0].ImageToolTip, "CheckTreeNodes_ImageToolTip#5");

			Assert.AreEqual ("value#root", m.Nodes[0].Value, "CheckTreeNodes_Value#1");
			Assert.AreEqual ("value#1", m.Nodes[0].ChildNodes[0].Value, "CheckTreeNodes_Value#2");
			Assert.AreEqual ("value#2", m.Nodes[0].ChildNodes[1].Value, "CheckTreeNodes_Value#3");
			Assert.AreEqual ("value#default", m.Nodes[0].ChildNodes[2].Value, "CheckTreeNodes_Value#4");
			Assert.AreEqual ("subnode", m.Nodes[0].ChildNodes[2].ChildNodes[0].Value, "CheckTreeNodes_Value#5");

			Assert.AreEqual ("text#extra1", m.Nodes[0].ChildNodes[3].Text, "CheckTreeNodes_Extra1#1");
			Assert.AreEqual ("text#extra1", m.Nodes[0].ChildNodes[3].Value, "CheckTreeNodes_Extra1#2");

			Assert.AreEqual ("value#extra2", m.Nodes[0].ChildNodes[4].Text, "CheckTreeNodes_Extra2#1");
			Assert.AreEqual ("value#extra2", m.Nodes[0].ChildNodes[4].Value, "CheckTreeNodes_Extra2#2");

			Assert.AreEqual ("text#extra3", m.Nodes[0].ChildNodes[5].Text, "CheckTreeNodes_Extra3#1");
			Assert.AreEqual ("text#extra3", m.Nodes[0].ChildNodes[5].Value, "CheckTreeNodes_Extra3#2");
			Assert.AreEqual ("value#extra3", m.Nodes[0].ChildNodes[6].Text, "CheckTreeNodes_Extra3#3");
			Assert.AreEqual ("value#extra3", m.Nodes[0].ChildNodes[6].Value, "CheckTreeNodes_Extra3#4");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[7].Text, "CheckTreeNodes_Extra3#5");
			Assert.AreEqual ("", m.Nodes[0].ChildNodes[7].Value, "CheckTreeNodes_Extra3#6");

			Assert.AreEqual ("text#extra4", m.Nodes[0].ChildNodes[8].Text, "CheckTreeNodes_Extra4#1");
			Assert.AreEqual ("text#default", m.Nodes[0].ChildNodes[8].Value, "CheckTreeNodes_Extra4#2");

			Assert.AreEqual ("value#default", m.Nodes[0].ChildNodes[9].Text, "CheckTreeNodes_Extra5#1");
			Assert.AreEqual ("value#extra5", m.Nodes[0].ChildNodes[9].Value, "CheckTreeNodes_Extra5#2");
		}

		void SetDataBindings (TreeView tv) {
			TreeNodeBinding b = new TreeNodeBinding ();
			b.DataMember = "node";
			b.ImageUrlField = "img";
			b.ImageUrl = "img#default";
			b.NavigateUrlField = "url";
			b.NavigateUrl = "url#default";
			b.TargetField = "target";
			b.Target = "target#default";
			b.FormatString = "text#{0}";
			b.TextField = "text";
			b.Text = "text#default";
			b.ToolTipField = "tooltip";
			b.ToolTip = "tooltip#default";
			b.ImageToolTipField = "imagetooltip";
			b.ImageToolTip = "imagetooltip#default";
			b.ValueField = "value";
			b.Value = "value#default";
			tv.DataBindings.Add (b);

			b = new TreeNodeBinding ();
			b.DataMember = "root";
			b.ImageUrl = "img#root";
			b.NavigateUrl = "url#root";
			b.Target = "target#root";
			b.Text = "text#root";
			b.ToolTip = "tooltip#root";
			b.ImageToolTip = "imagetooltip#root";
			b.Value = "value#root";
			tv.DataBindings.Add (b);

			b = new TreeNodeBinding ();
			b.DataMember = "extra1";
			b.Text = "text#extra1";
			tv.DataBindings.Add (b);

			b = new TreeNodeBinding ();
			b.DataMember = "extra2";
			b.Value = "value#extra2";
			tv.DataBindings.Add (b);

			b = new TreeNodeBinding ();
			b.DataMember = "extra3";
			b.TextField = "text";
			b.ValueField = "value";
			tv.DataBindings.Add (b);

			b = new TreeNodeBinding ();
			b.DataMember = "extra4";
			b.TextField = "text";
			b.Text = "text#default";
			b.ValueField = "value";
			tv.DataBindings.Add (b);

			b = new TreeNodeBinding ();
			b.DataMember = "extra5";
			b.TextField = "text";
			b.Value = "value#default";
			b.ValueField = "value";
			tv.DataBindings.Add (b);
		}

		XmlDataSource CreateXmlDataSource () {
			XmlDataSource xmlDs = new XmlDataSource ();
			xmlDs.EnableCaching = false;
			xmlDs.ID = "XmlDataSource";
			xmlDs.Data = "<root>" +
				"<node url=\"url#1\" img=\"img#1\" selectable=\"true\" popoutimg=\"popoutimg#1\" separatorimg=\"separatorimg#1\" target=\"target#1\" text=\"1\" tooltip=\"tooltip#1\" imagetooltip=\"imagetooltip#1\" value=\"value#1\" />" +
				"<node url=\"url#2\" img=\"img#2\" selectable=\"false\" popoutimg=\"popoutimg#2\" separatorimg=\"separatorimg#2\" target=\"target#2\" text=\"2\" tooltip=\"tooltip#2\" imagetooltip=\"imagetooltip#2\" value=\"value#2\" />" +
				"<node url=\"\" img=\"\" selectable=\"\" popoutimg=\"\" separatorimg=\"\" target=\"\" text=\"\" tooltip=\"\" imagetooltip=\"\" value=\"\">" +
				"<subnode url=\"url#unreachable\" img=\"img#unreachable\" selectable=\"false\" popoutimg=\"popoutimg#unreachable\" separatorimg=\"separatorimg#unreachable\" target=\"target#unreachable\" text=\"text#unreachable\" tooltip=\"tooltip#unreachable\" imagetooltip=\"imagetooltip#unreachable\" value=\"value#unreachable\" />" +
				"<subnode /></node>" +
				"<extra1 /><extra2 />" +
				"<extra3 text=\"text#extra3\" value=\"\" />" +
				"<extra3 text=\"\" value=\"value#extra3\" />" +
				"<extra3 text=\"\" value=\"\" />" +
				"<extra4 text=\"text#extra4\" value=\"\" />" +
				"<extra5 text=\"\" value=\"value#extra5\" />" +
				"</root>";
			return xmlDs;
		}

		[Test]
		[ExpectedException (typeof (ArgumentOutOfRangeException))]
		public void TreeView_Exp_ImageSet () {
			// The specified image set is not one of the TreeViewImageSet values.
			PokerTreeView tv = new PokerTreeView ();
			tv.ImageSet = (TreeViewImageSet) 16;
		}

		[Test]
		[ExpectedException (typeof (ArgumentOutOfRangeException))]
		public void TreeView_Exp_ShowCheckBoxes () {
			// The bitwise combination value is outside the range of the TreeNodeTypes enumeration.
			PokerTreeView tv = new PokerTreeView ();
			tv.ShowCheckBoxes = (TreeNodeTypes) 8;
		}

		[Test]
		[ExpectedException (typeof (ArgumentOutOfRangeException))]
		public void TreeView_Exp_Nodes () {
			// Trying to access nonexisting node.
			PokerTreeView tv = new PokerTreeView ();
			int depth = tv.Nodes[1].Depth;
		}

		[Test]
		public void TreeView_Method_DataBindDataSource () {
			PokerTreeView tv = new PokerTreeView ();
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			_TreeNodeDataBoundCount = 0;
			tv.TreeNodeDataBound += new TreeNodeEventHandler (TreeView_TreeNodeDataBound);
			Assert.AreEqual (0, tv.Nodes.Count, "BeforeDataBind1");
			tv.DataBind ();
			Assert.AreEqual (1, tv.Nodes.Count, "AfterDataBind1-a");
			Assert.AreEqual ("Book", tv.Nodes[0].Text, "AfterDataBind1-b");
			Assert.AreEqual (2, tv.Nodes[0].ChildNodes.Count, "AfterDataBind1-c");
			Assert.AreEqual (2, tv.Nodes [0].ChildNodes [0].ChildNodes.Count, "AfterDataBind1-d");
			Assert.AreEqual (6, _TreeNodeDataBoundCount, "AfterDataBind1-TreeNodeDataBoundCount");
		}

		[Test]
		public void TreeView_MaxDataBindDepth () {
			TreeView tv = new TreeView ();
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.MaxDataBindDepth = 1;
			_TreeNodeDataBoundCount = 0;
			tv.TreeNodeDataBound += new TreeNodeEventHandler (TreeView_TreeNodeDataBound);
			Assert.AreEqual (0, tv.Nodes.Count, "BeforeDataBind1");
			tv.DataBind ();
			Assert.AreEqual (1, tv.Nodes.Count, "AfterDataBind1-a");
			Assert.AreEqual ("Book", tv.Nodes [0].Text, "AfterDataBind1-b");
			Assert.AreEqual (2, tv.Nodes [0].ChildNodes.Count, "AfterDataBind1-c");
			Assert.AreEqual (0, tv.Nodes [0].ChildNodes [0].ChildNodes.Count, "AfterDataBind1-d");
			Assert.AreEqual (3, _TreeNodeDataBoundCount, "AfterDataBind1-TreeNodeDataBoundCount");
		}

		int _TreeNodeDataBoundCount;
		private void TreeView_TreeNodeDataBound (object sender, TreeNodeEventArgs e) {
			_TreeNodeDataBoundCount++;
		}

		[Test]
		public void TreeView_Method_DataBindStatic () {
			PokerTreeView tv = new PokerTreeView ();
			TreeNode R = new TreeNode ("root", "value-root");
			TreeNode N1 = new TreeNode ("node1", "value-node1");
			TreeNode N2 = new TreeNode ("node2", "value-node2");
			R.ChildNodes.Add (N1);
			R.ChildNodes.Add (N2);
			tv.Nodes.Add (R);
			tv.DataBind ();
			Assert.AreEqual (1, tv.Nodes.Count, "DataBindStatic-1");
			Assert.AreEqual (2, tv.Nodes[0].ChildNodes.Count, "DataBindStatic-1");
			Assert.AreEqual (0, tv.Nodes[0].ChildNodes[0].ChildNodes.Count, "DataBindStatic-2");
			Assert.AreEqual ("node1", tv.Nodes[0].ChildNodes[0].Text, "DataBindStatic-3");
			Assert.AreEqual ("value-node1", tv.Nodes[0].ChildNodes[0].Value, "DataBindStatic-4");
			Assert.AreEqual (false, tv.Nodes[0].ChildNodes[0].DataBound, "DataBindStatic-5");
			Assert.AreEqual ("", tv.Nodes[0].ChildNodes[0].DataPath, "DataBindStatic-6");
		}

		[Test]
		public void TreeView_Method_DataBind () {
			PokerTreeView tv = new PokerTreeView ();
			SetDataBindings (tv);
			tv.DataSource = CreateXmlDataSource ();
			tv.DataBind ();
			CheckTreeNodes (tv);
		}

		[Test]
		public void TreeView_Method_FindNode () {
			PokerTreeView tv = new PokerTreeView ();
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			TreeNode tn = new TreeNode ();
			Assert.AreEqual (0, tn.ChildNodes.Count, "BeforeFindNode");
			tn = tv.FindNode ("Book" + tv.PathSeparator + "Chapter");
			Assert.AreEqual ("Chapter", tn.Text, "AfterFindNode1");
			Assert.AreEqual (2, tn.ChildNodes.Count, "AfterFindNode2");
			Assert.AreEqual ("Section", tn.ChildNodes[0].Text, "AfterFindNode3");
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Defaults () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadRenderDefaults));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderDefaults");
		}
		public static void pageLoadRenderDefaults (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_RenderTags () {
			new WebTest (PageInvoker.CreateOnLoad (pageLoadRenderTags)).Run ();
		}
		public static void pageLoadRenderTags (Page page) {
			TreeView tv = new TreeView ();
			tv.ID = "treeview1";
			page.Form.Controls.Add (tv);
			StringWriter sw = new StringWriter ();
			HtmlTextWriter tw = new HtmlTextWriter (sw);
			tv.RenderBeginTag (tw);
			tv.RenderEndTag (tw);
			string str = sw.ToString ();
			string strTarget = "<a href=\"#treeview1_SkipLink\"><img alt=\"Skip Navigation Links.\" src=\"/NunitWeb/WebResource.axd?d=kffkK8wYLPknq-W8AKNdNQ2&amp;t=632883840303269703\" width=\"0\" height=\"0\" style=\"border-width:0px;\" /></a><div id=\"treeview1\">\r\n\r\n</div><a id=\"treeview1_SkipLink\"></a>";
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderTags");
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_ExpandAll () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadExpandAll));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "ExpandAll");
		}
		public static void pageLoadExpandAll (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.ExpandAll ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_NodeExpand () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeExpand));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeExpand");
		}
		public static void pageLoadNodeExpand (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.CollapseAll ();
			tv.Nodes[0].Expand ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_NodeExpandAll () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeExpandAll));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeExpandAll");
		}
		public static void pageLoadNodeExpandAll (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.CollapseAll ();
			tv.Nodes[0].ChildNodes[0].ExpandAll ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_CollapseAll () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadCollapseAll));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "CollapseAll");
		}
		public static void pageLoadCollapseAll (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.CollapseAll ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_NodeCollapse () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeCollapse));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeCollapse");
		}
		public static void pageLoadNodeCollapse (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].Collapse ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_NodeCollapseAll () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeCollapseAll));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeCollapseAll");
		}
		public static void pageLoadNodeCollapseAll (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].ChildNodes[0].CollapseAll ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_NodeToggleExpandState1 () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeToggleExpandState1));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeToggleExpandState1");
		}
		public static void pageLoadNodeToggleExpandState1 (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.ExpandAll ();
			tv.Nodes[0].ChildNodes[1].ToggleExpandState ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Method_NodeToggleExpandState2 () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeToggleExpandState2));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeToggleExpandState2");
		}
		public static void pageLoadNodeToggleExpandState2 (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.CollapseAll ();
			tv.Nodes [0].ChildNodes [0].ToggleExpandState ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_PopulateNode () {
			PageDelegates delegates = new PageDelegates ();
			delegates.Load = new PageDelegate (TreeView_PopulateNode_Load);
			delegates.PreRender = new PageDelegate (TreeView_PopulateNode_PreRender);
			delegates.PreRenderComplete = new PageDelegate (TreeView_PopulateNode_PreRenderComplete);
			PageInvoker invoker = new PageInvoker (delegates);
			WebTest test = new WebTest (invoker);
			test.Run ();
		}

		public static void TreeView_PopulateNode_Load (Page page) {
			TreeView tv = new TreeView ();
			tv.ID = "TreeView";
			tv.TreeNodePopulate += new TreeNodeEventHandler (tv_TreeNodePopulate);
			tv.ExpandDepth = 3;
			TreeNode rootNode = new TreeNode ("root");
			rootNode.PopulateOnDemand = true;
			tv.Nodes.Add (rootNode);
			page.Form.Controls.Add (tv);

			// root node still not populated
			Assert.AreEqual (null, rootNode.Expanded, "TreeView_PopulateNode_Load#1");
			Assert.AreEqual (0, rootNode.ChildNodes.Count, "TreeView_PopulateNode_Load#2");
			
			// root node was populated after set Expanded=true
			rootNode.Expanded = true;
			Assert.AreEqual (1, rootNode.ChildNodes.Count, "TreeView_PopulateNode_Load#3");
			
			// node1 was populated because was added with Expanded=true whan root was populated
			Assert.AreEqual (true, rootNode.ChildNodes [0].Expanded, "TreeView_PopulateNode_Load#4");
			Assert.AreEqual (1, rootNode.ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_Load#5");
			
			// node2 not populated because Expanded not set
			Assert.AreEqual (null, rootNode.ChildNodes [0].ChildNodes [0].Expanded, "TreeView_PopulateNode_Load#6");
			Assert.AreEqual (0, rootNode.ChildNodes [0].ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_Load#7");
		}

		public static void TreeView_PopulateNode_PreRender (Page page) {
			TreeView tv = (TreeView) page.Form.FindControl ("TreeView");
			TreeNode rootNode = tv.Nodes [0];

			// state of nodes remain the same
			// root
			Assert.AreEqual (true, rootNode.Expanded, "TreeView_PopulateNode_PreRender#1");
			Assert.AreEqual (1, rootNode.ChildNodes.Count, "TreeView_PopulateNode_PreRender#3");
			// node1
			Assert.AreEqual (true, rootNode.ChildNodes [0].Expanded, "TreeView_PopulateNode_PreRender#4");
			Assert.AreEqual (1, rootNode.ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_PreRender#5");
			// node2
			Assert.AreEqual (null, rootNode.ChildNodes [0].ChildNodes [0].Expanded, "TreeView_PopulateNode_PreRender#6");
			Assert.AreEqual (0, rootNode.ChildNodes [0].ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_PreRender#7");
		}

		public static void TreeView_PopulateNode_PreRenderComplete (Page page) {
			TreeView tv = (TreeView) page.Form.FindControl ("TreeView");
			TreeNode rootNode = tv.Nodes [0];

			// All nodes were expanded and populated up to ExpandDepth
			// root
			Assert.AreEqual (true, rootNode.Expanded, "TreeView_PopulateNode_PreRenderComplete#1");
			Assert.AreEqual (1, rootNode.ChildNodes.Count, "TreeView_PopulateNode_PreRenderComplete#3");
			// node1
			Assert.AreEqual (true, rootNode.ChildNodes [0].Expanded, "TreeView_PopulateNode_PreRenderComplete#4");
			Assert.AreEqual (1, rootNode.ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_PreRenderComplete#5");
			// node2
			Assert.AreEqual (true, rootNode.ChildNodes [0].ChildNodes [0].Expanded, "TreeView_PopulateNode_PreRenderComplete#6");
			Assert.AreEqual (1, rootNode.ChildNodes [0].ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_PreRenderComplete#7");
			// node3
			Assert.AreEqual (null, rootNode.ChildNodes [0].ChildNodes [0].ChildNodes [0].Expanded, "TreeView_PopulateNode_PreRenderComplete#6");
			Assert.AreEqual (0, rootNode.ChildNodes [0].ChildNodes [0].ChildNodes [0].ChildNodes.Count, "TreeView_PopulateNode_PreRenderComplete#7");
		}

		static void tv_TreeNodePopulate (object sender, TreeNodeEventArgs e) {
			TreeNode node = new TreeNode ("node" + (e.Node.Depth + 1));
			node.PopulateOnDemand = true;
			if (e.Node.Depth < 1)
				node.Expanded = true;
			e.Node.ChildNodes.Add (node);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_ExpandDepth () {
			PageDelegates delegates = new PageDelegates ();
			delegates.Init = pageInitExpandDepth;
			delegates.Load = pageLoadExpandDepth;
			PageInvoker invoker = new PageInvoker (delegates);
			WebTest t = new WebTest (invoker);
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "NodeToggleExpandState2");
		}
		public static void pageInitExpandDepth (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.ExpandDepth = 1;
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}
		public static void pageLoadExpandDepth (Page page) {
			TreeView tv = (TreeView)page.Form.FindControl("treeview1");
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
		}

		[Test]
		public void TreeView_Method_CreateControlCollection () {
			PokerTreeView tv = new PokerTreeView ();
			ControlCollection cc = tv.CreateControlCollectionBase ();
			Assert.AreEqual (0, cc.Count, "AfterCreateControlCollection");
		}
		[Test]
		public void TreeView_Method_CreateNode () {
			PokerTreeView tv = new PokerTreeView ();
			TreeNode tn = tv.CreateNodeBase ();
			Assert.AreEqual ("New Tree Node", tn.Text, "AfterCreateNode");
		}

		[Test]
		public void TreeView_Method_PerformDataBinding () {
			PokerTreeView tv = new PokerTreeView ();
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			Assert.AreEqual (0, tv.Nodes.Count, "BeforePerformDataBinding");
			tv.PerformDataBindingBase ();
			Assert.AreEqual (1, tv.Nodes.Count, "AfterPerformDataBinding-a");
			Assert.AreEqual ("Book", tv.Nodes[0].Text, "AfterPerformDataBinding-b");
			Assert.AreEqual (2, tv.Nodes[0].ChildNodes.Count, "AfterPerformDataBinding-c");
		}

		// Render Bindings
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Bindings () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadBindings));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook Title')""><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvPWfVVXMf-ioilxt_CauIRc1&amp;t=632900536532114160"" alt=""Collapse Book Title"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook Title')"" id=""treeview1t0"">Book Title</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvNJinrRt8LmxJBdwpNumnBQ1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook Title\\Chapter 1')"" id=""treeview1t1"">Chapter 1</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvNJinrRt8LmxJBdwpNumnBQ1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook Title\\Chapter 2')"" id=""treeview1t2"">Chapter 2</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderBindings");
		}
		public static void pageLoadBindings (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.ImageSet = TreeViewImageSet.Arrows;
			tv.AutoGenerateDataBindings = false;
			tv.MaxDataBindDepth = 1;
			tv.DataBindings.Add (new TreeNodeBinding ());
			tv.DataBindings[0].DataMember = "Book";
			tv.DataBindings[0].TextField = "Title";
			tv.DataBindings.Add (new TreeNodeBinding ());
			tv.DataBindings[1].DataMember = "Chapter";
			tv.DataBindings[1].TextField = "Heading";
			tv.DataBindings.Add (new TreeNodeBinding ());
			tv.DataBindings[2].DataMember = "Section";
			tv.DataBindings[2].TextField = "Heading";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		// Render Navigate
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Navigate () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNavigate));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tmyNode0')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse myNode0"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""myUrl0"" target=""myTarget"" id=""treeview1t0"">myNode0</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""myUrl00"" target=""myTarget"" id=""treeview1t1"">myNode00</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""myUrl1"" target=""myTarget"" id=""treeview1t2"">myNode1</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderNavigate");
		}
		public static void pageLoadNavigate (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.Target = "myTarget";
			tv.Nodes.Add (new TreeNode ());
			tv.Nodes[0].NavigateUrl = "myUrl0";
			tv.Nodes[0].Text = "myNode0";
			tv.Nodes[0].ChildNodes.Add (new TreeNode ());
			tv.Nodes[0].ChildNodes[0].NavigateUrl = "myUrl00";
			tv.Nodes[0].ChildNodes[0].Text = "myNode00";
			tv.Nodes.Add (new TreeNode ());
			tv.Nodes[1].NavigateUrl = "myUrl1";
			tv.Nodes[1].Text = "myNode1";
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		// Render Checkboxes
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Checkboxes () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadCheckboxes));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n0CheckBox"" id=""treeview1n0CheckBox"" title=""Book"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n1CheckBox"" id=""treeview1n1CheckBox"" title=""Chapter"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n2CheckBox"" id=""treeview1n2CheckBox"" title=""Section"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n3CheckBox"" id=""treeview1n3CheckBox"" title=""Section"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n4CheckBox"" id=""treeview1n4CheckBox"" title=""Chapter"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n5CheckBox"" id=""treeview1n5CheckBox"" title=""Section"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderCheckboxes");
		}
		public static void pageLoadCheckboxes (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.ShowCheckBoxes = TreeNodeTypes.All;
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		// Render Values
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Values () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadValues));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""mySkipLinkText"" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvPWfVVXMf-ioilxt_CauIRc1&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:30px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvPWfVVXMf-ioilxt_CauIRc1&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:30px;height:1px""></div></td><td><div style=""width:30px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvNJinrRt8LmxJBdwpNumnBQ1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:30px;height:1px""></div></td><td><div style=""width:30px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvNJinrRt8LmxJBdwpNumnBQ1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:30px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvPWfVVXMf-ioilxt_CauIRc1&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:30px;height:1px""></div></td><td><div style=""width:30px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=tM_G_fTuPrZTezUsMMFtvNJinrRt8LmxJBdwpNumnBQ1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderValues");
		}
		public static void pageLoadValues (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.ImageSet = TreeViewImageSet.Arrows;
			tv.SkipLinkText = "mySkipLinkText";
			tv.NodeIndent = 30;
			tv.ExpandDepth = 3;
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		// Render Images
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_ImagesOn () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadImagesOn));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""Test666/dashminus.gif"" alt=""Test111"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""Test666/tminus.gif"" alt=""Test111"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""><img src=""Test666/i.gif"" alt="""" /></div></td><td><img src=""Test666/t.gif"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""><img src=""Test666/i.gif"" alt="""" /></div></td><td><img src=""Test666/l.gif"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""Test666/lminus.gif"" alt=""Test111"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""Test666/l.gif"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderImagesOn");
		}
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_ImagesOff () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadImagesOff));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1n0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1n1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1n2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1n3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1n4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1n5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderImagesOff");
		}
		public static void pageLoadImagesOn (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.CollapseImageToolTip = "Test111";
			tv.ExpandImageToolTip = "Test222";
			tv.CollapseImageUrl = "Test333";
			tv.ExpandImageUrl = "Test444";
			tv.NoExpandImageUrl = "Test555";
			tv.LineImagesFolder = "Test666";
			tv.ShowLines = true;
			tv.ShowExpandCollapse = true;
			tv.ImageSet = TreeViewImageSet.Custom;
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}
		public static void pageLoadImagesOff (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			tv.ShowLines = false;
			tv.ShowExpandCollapse = false;
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		//Render Wrap
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_WrapOn () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadWrapOn));
			string strTarget =
@"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=kffkK8wYLPknq-W8AKNdNQ2&amp;t=632883840303269703"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><img src=""/NunitWeb/WebResource.axd?d=edXX1vkoy5lI0CekgaZ5zZhMbc1ZCZv4nlS9J-l53l41&amp;t=632883840303269703"" alt="""" /></td><td><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sTreeNode1')"" onclick=""TreeView_SelectNode(treeview1_Data, this,'treeview1t0');"" id=""treeview1t0"">TreeNode1</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderWrapOn");
		}
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_WrapOff () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadWrapOff));
			string strTarget =
@"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=kffkK8wYLPknq-W8AKNdNQ2&amp;t=632883840303269703"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><img src=""/NunitWeb/WebResource.axd?d=edXX1vkoy5lI0CekgaZ5zZhMbc1ZCZv4nlS9J-l53l41&amp;t=632883840303269703"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sTreeNode1')"" onclick=""TreeView_SelectNode(treeview1_Data, this,'treeview1t0');"" id=""treeview1t0"">TreeNode1</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderWrapOff");
		}
		public static void pageLoadWrapOn (Page page) {
			TreeView tv = new TreeView ();
			tv.ID = "treeview1";
			tv.NodeWrap = true;
			tv.Nodes.Add (new TreeNode ("TreeNode1"));
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}
		public static void pageLoadWrapOff (Page page) {
			TreeView tv = new TreeView ();
			tv.ID = "treeview1";
			tv.NodeWrap = false;
			tv.Nodes.Add (new TreeNode ("TreeNode1"));
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		// Render Client
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Client () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadClient));
			string strTarget = "<a href=\"#treeview1_SkipLink\"><img alt=\"Skip Navigation Links.\" src=\"/NunitWeb/WebResource.axd?d=kffkK8wYLPknq-W8AKNdNQ2&amp;t=632883840303269703\" width=\"0\" height=\"0\" style=\"border-width:0px;\" /></a><div id=\"treeview1\">\r\n\r\n</div><a id=\"treeview1_SkipLink\"></a>";
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderClient");
		}
		public static void pageLoadClient (Page page) {
			TreeView tv = new TreeView ();
			tv.ID = "treeview1";
			tv.EnableClientScript = false;
			tv.PopulateNodesFromClient = false;
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		//Render Invisible
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_Invisible () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadInvisible));
			string strTarget = "";
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			Assert.AreEqual (strTarget, str, "RenderInvisible");
		}
		public static void pageLoadInvisible (Page page) {
			TreeView tv = new TreeView ();
			tv.ID = "treeview1";
			tv.Visible = false;
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBindSmall;
			tv.DataSource = xmlds;
			tv.DataBind ();
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		//Render Node Strings
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_NodeStrings () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeStrings));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" title=""string1"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td><a href=""string4"" id=""treeview1t1i""><img src=""string3"" alt="""" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""string4"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\string6')"" id=""treeview1t3"">string6</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\string7')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\string7')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\string7\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderNodeStrings");
		}
		public static void pageLoadNodeStrings (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].ToolTip = "string1";
			tv.Nodes[0].ImageToolTip = "string2";
			tv.Nodes[0].ChildNodes[0].ImageUrl = "string3";
			tv.Nodes[0].ChildNodes[0].NavigateUrl = "string4";
			tv.Nodes[0].ChildNodes[0].ChildNodes[0].Target = "string5";
			tv.Nodes[0].ChildNodes[0].ChildNodes[1].Text = "string6";
			tv.Nodes[0].ChildNodes[1].Value = "string7";
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		//Render Node States
		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_NodeStates1 () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeStates1));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t2"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><input type=""checkbox"" name=""treeview1n3CheckBox"" id=""treeview1n3CheckBox"" title=""Section"" /><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t3"">Section</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderNodeStates1");
		}
		public static void pageLoadNodeStates1 (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].Checked = true;
			tv.Nodes[0].ChildNodes[0].Selected = false;
			tv.Nodes[0].ChildNodes[0].Expanded = true;
			tv.Nodes[0].ChildNodes[0].ChildNodes[0].PopulateOnDemand = false;
			tv.Nodes[0].ChildNodes[0].ChildNodes[1].ShowCheckBox = true;
			tv.Nodes[0].ChildNodes[1].SelectAction = TreeNodeSelectAction.SelectExpand;
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		public void TreeView_Render_NodeStates2 () {
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (pageLoadNodeStates2));
			#region HTML
			string strTarget = @"<a href=""#treeview1_SkipLink""><img alt=""Skip Navigation Links."" src=""/NunitWeb/WebResource.axd?d=QxfUEifeQdL5PTiZOF8HlA2&amp;t=632900536532114160"" width=""0"" height=""0"" style=""border-width:0px;"" /></a><div id=""treeview1"">
	<table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><a href=""javascript:__doPostBack('treeview1','tBook')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Book"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook')"" id=""treeview1t0"">Book</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKww7ErebG7jw1jueqPriNXg1&amp;t=632900536532114160"" alt=""Expand Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t1"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><a href=""javascript:__doPostBack('treeview1','tBook\\Chapter')""><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCKx8id-JMenwfEutsU_5Jl881&amp;t=632900536532114160"" alt=""Collapse Chapter"" style=""border-width:0;"" /></a></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter')"" id=""treeview1t4"">Chapter</a></td>
		</tr>
	</table><table cellpadding=""0"" cellspacing=""0"" style=""border-width:0;"">
		<tr>
			<td><div style=""width:20px;height:1px""></div></td><td><div style=""width:20px;height:1px""></div></td><td><img src=""/NunitWeb/WebResource.axd?d=FFvd_97uOAs_RkkFT_hCK1PXgyMDQIACCdOOfDo560o1&amp;t=632900536532114160"" alt="""" /></td><td style=""white-space:nowrap;""><a class=""treeview1_0"" href=""javascript:__doPostBack('treeview1','sBook\\Chapter\\Section')"" id=""treeview1t5"">Section</a></td>
		</tr>
	</table>
</div><a id=""treeview1_SkipLink""></a>";
			#endregion
			string str = HtmlDiff.GetControlFromPageHtml (t.Run ());
			HtmlDiff.AssertAreEqual (strTarget, str, "RenderNodeStates2");
		}
		public static void pageLoadNodeStates2 (Page page) {
			TreeView tv = new TreeView ();
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].Checked = false;
			tv.Nodes[0].ChildNodes[0].Selected = true;
			tv.Nodes[0].ChildNodes[0].Expanded = false;
			tv.Nodes[0].ChildNodes[0].ChildNodes[0].PopulateOnDemand = true;
			tv.Nodes[0].ChildNodes[0].ChildNodes[1].ShowCheckBox = false;
			tv.Nodes[0].ChildNodes[1].SelectAction = TreeNodeSelectAction.Expand;
			LiteralControl lcb = new LiteralControl (HtmlDiff.BEGIN_TAG);
			LiteralControl lce = new LiteralControl (HtmlDiff.END_TAG);
			page.Form.Controls.Add (lcb);
			page.Form.Controls.Add (tv);
			page.Form.Controls.Add (lce);
		}

		[Test]
		[Category ("NunitWeb")]
		[Category ("NotWorking")] // Implementation details for mono  
		public void TreeView_PostBackFireEvents_1 ()
		{
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (PostBackFireEvents_1));
			String html = t.Run ();
			if (t.UserData == null)
				Assert.Fail ("Event not fired fail");
			Assert.AreEqual ("TreeNodeDataBound", t.UserData.ToString (), "PostBackFireEvents_1");
		}

		#region PostBackFireEvents_1
		public static void PostBackFireEvents_1 (Page p)
		{
			TreeView tv = new TreeView ();
			tv.TreeNodeDataBound += new TreeNodeEventHandler (tv_TreeNodeDataBound);
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].Checked = true;
			tv.Nodes[0].ChildNodes[0].Selected = false;
			tv.Nodes[0].ChildNodes[0].Expanded = true;
			tv.Nodes[0].ChildNodes[0].ChildNodes[0].PopulateOnDemand = false;
			tv.Nodes[0].ChildNodes[0].ChildNodes[1].ShowCheckBox = true;
			tv.Nodes[0].ChildNodes[1].SelectAction = TreeNodeSelectAction.SelectExpand;
			p.Form.Controls.Add (tv);
		}

		public static void tv_TreeNodeDataBound (object sender, TreeNodeEventArgs e)
		{
			WebTest.CurrentTest.UserData = "TreeNodeDataBound";	
		}
		#endregion

		[Test]
		[Category ("NunitWeb")]
		[Category ("NotWorking")] // Implementation details for mono  
		public void TreeView_PostBackFireEvents_2 ()
		{
			WebTest t = new WebTest ("NoEventValidation.aspx");
			t.Invoker = PageInvoker.CreateOnLoad (PostBackFireEvents_2);
			t.Run ();
			FormRequest fr = new FormRequest (t.Response, "form1");
			
			fr.Controls.Add ("__EVENTTARGET");
			fr.Controls.Add ("__EVENTARGUMENT");
			fr.Controls.Add ("treeview1_ExpandState");
			fr.Controls.Add ("treeview1_SelectedNode");
			fr.Controls.Add ("treeview1_PopulateLog");
			fr.Controls.Add ("treeview1n0CheckBox");

			fr.Controls["__EVENTTARGET"].Value = "treeview1";
			fr.Controls["__EVENTARGUMENT"].Value = "sroot";
			fr.Controls["treeview1_ExpandState"].Value = "n";
			fr.Controls["treeview1_SelectedNode"].Value = "treeview1t0";
			fr.Controls["treeview1_PopulateLog"].Value = "";
			fr.Controls["treeview1n0CheckBox"].Value = "on";

			t.Request = fr;
			t.Run ();

			Assert.AreEqual ("TreeNodeCheckChanged", t.UserData.ToString (), "PostBackFireEvents");
		}

		#region PostBackFireEvents_2
		public static void PostBackFireEvents_2 (Page p)
		{
			TreeView tv = new TreeView ();
			tv.TreeNodeCheckChanged+=new TreeNodeEventHandler(tv_TreeNodeCheckChanged);
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			TreeNode root = new TreeNode ("root", "root");
			root.ShowCheckBox = true;
			root.Checked = false;
			tv.Nodes.Add (root);
			p.Form.Controls.Add (tv);
		}

		static void tv_TreeNodeCheckChanged (object sender, TreeNodeEventArgs e)
		{
			WebTest.CurrentTest.UserData = "TreeNodeCheckChanged";
		}
		#endregion

		[Test]
		[Category ("NunitWeb")]
		[Category ("NotWorking")] // Implementation details for mono  
		public void TreeView_PostBackFireEvents_3 ()
		{
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (PostBackFireEvents_3));
			String html = t.Run ();
			if (t.UserData == null)
				Assert.Fail ("Event not fired fail");
			Assert.AreEqual ("TreeNodeExpanded", t.UserData.ToString (), "PostBackFireEvents#1");

			FormRequest fr = new FormRequest (t.Response, "form1");
			fr.Controls.Add ("__EVENTTARGET");
			fr.Controls.Add ("__EVENTARGUMENT");
			fr.Controls["__EVENTTARGET"].Value = "treeview1";
			fr.Controls["__EVENTARGUMENT"].Value = "tBook";
			t.Request = fr;
			t.Run ();
			Assert.AreEqual ("TreeNodeCollapsed", t.UserData.ToString (), "PostBackFireEvents#2");

		}

		#region PostBackFireEvents_3
		public static void PostBackFireEvents_3 (Page p)
		{
			TreeView tv = new TreeView ();
			tv.TreeNodeCollapsed += new TreeNodeEventHandler (tv_TreeNodeCollapsed);
			tv.TreeNodeExpanded +=new TreeNodeEventHandler(tv_TreeNodeExpanded);
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			XmlDataSource xmlds = new XmlDataSource ();
			xmlds.EnableCaching = false;
			xmlds.Data = xmlDataBind;
			tv.DataSource = xmlds;
			tv.DataBind ();
			tv.Nodes[0].Checked = true;
			tv.Nodes[0].ChildNodes[0].Selected = false;
			tv.Nodes[0].ChildNodes[0].Expanded = true;
			tv.Nodes[0].ChildNodes[0].ChildNodes[0].PopulateOnDemand = false;
			tv.Nodes[0].ChildNodes[0].ChildNodes[1].ShowCheckBox = true;
			tv.Nodes[0].ChildNodes[1].SelectAction = TreeNodeSelectAction.SelectExpand;
			p.Form.Controls.Add (tv);

			
		}

		public static void tv_TreeNodeCollapsed (object sender, TreeNodeEventArgs e)
		{
			WebTest.CurrentTest.UserData = "TreeNodeCollapsed";
		}

		static void tv_TreeNodeExpanded (object sender, TreeNodeEventArgs e)
		{
			WebTest.CurrentTest.UserData = "TreeNodeExpanded";
		}
		#endregion

		[Test]
		[Category ("NunitWeb")]
		[Category ("NotWorking")] // Implementation details for mono  
		public void TreeView_PostBackFireEvents_4 ()
		{
			WebTest t = new WebTest (PageInvoker.CreateOnLoad (PostBackFireEvents_4));
		        String html = t.Run ();
			Assert.AreEqual ("TreeNodePopulate", t.UserData.ToString (), "PostBackFireEvents");
		}

		#region PostBackFireEvents_4
		public static void PostBackFireEvents_4 (Page p)
		{
			TreeView tv = new TreeView ();
			tv.TreeNodePopulate += new TreeNodeEventHandler (tv_TreeNodePopulate_1);
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			TreeNode root = new TreeNode ("Root", "Root");
			root.PopulateOnDemand = true;
			root.Expanded = true;
			tv.Nodes.Add (root);
			p.Form.Controls.Add (tv);
		}

		public static void tv_TreeNodePopulate_1 (object sender, TreeNodeEventArgs e)
		{
			WebTest.CurrentTest.UserData = "TreeNodePopulate";
		}
		#endregion

		[Test]
		[Category ("NunitWeb")]
		[Category ("NotWorking")] // Implementation details for mono  
		public void TreeView_PostBackFireEvents_5 ()
		{
			WebTest t = new WebTest ("NoEventValidation.aspx");
			t.Invoker = PageInvoker.CreateOnLoad (PostBackFireEvents_5);
			t.Run ();
			FormRequest fr = new FormRequest (t.Response, "form1");
			fr.Controls.Add ("__EVENTTARGET");
			fr.Controls.Add ("__EVENTARGUMENT");
			fr.Controls.Add ("TreeView2_ExpandState");
			fr.Controls.Add ("TreeView2_SelectedNode");
			
			fr.Controls["__EVENTTARGET"].Value = "treeview1";
			fr.Controls["__EVENTARGUMENT"].Value = "snode";
			fr.Controls["TreeView2_ExpandState"].Value = "nn";
			fr.Controls["TreeView2_SelectedNode"].Value = "treeview1t1";
			t.Request = fr;
			t.Run ();
			Assert.AreEqual ("SelectedNodeChanged", t.UserData.ToString (), "PostBackFireEvents");
		}

		#region PostBackFireEvents_5
		public static void PostBackFireEvents_5 (Page p)
		{
			TreeView tv = new TreeView ();
			tv.SelectedNodeChanged += new EventHandler (tv_SelectedNodeChanged);
			tv.EnableClientScript = false;
			tv.ID = "treeview1";
			TreeNode root = new TreeNode ("root", "root");
			root.Selected = true;
			tv.Nodes.Add (root);
			TreeNode node = new TreeNode ("node", "node");
			tv.Nodes.Add (node);
			node.Selected = false;
			p.Form.Controls.Add (tv);
		}

		static void tv_SelectedNodeChanged (object sender, EventArgs e)
		{
			WebTest.CurrentTest.UserData = "SelectedNodeChanged";
		}
		#endregion

		[Test]
		[Category("NotWorking")]
		public void TreeView_NullDS ()
		{
			TreeView tv = new TreeView ();
			tv.DataSource = null;
			tv.DataBind ();
			Assert.AreEqual (0, tv.Nodes.Count, "NullDS");
		}


		// Events Stuff
		private bool eventDone = false;
		private string treeNodeName = string.Empty;
		private void TreeViewEventHandler1 (object sender, EventArgs e) {
			eventDone = true;
		}
		private void TreeViewEventHandler2 (object sender, TreeNodeEventArgs e) {
			eventDone = true;
			treeNodeName = e.Node.Text;
		}
		private void ResetEvents () {
			eventDone = false;
			treeNodeName = string.Empty;
		}

		[Test]
		public void TreeView_Event_Init () {
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			Page p = new Page ();
			p.Controls.Add (tv);
			tv.Init += new EventHandler (TreeViewEventHandler1);
			Assert.AreEqual (false, eventDone, "BeforeInit");
			tv.OnInitBase (new EventArgs ());
			Assert.AreEqual (true, eventDone, "AfterInit");
		}
		[Test]
		public void TreeView_Event_SelectedNodeChanged () {
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			tv.SelectedNodeChanged += new EventHandler (TreeViewEventHandler1);
			Assert.AreEqual (false, eventDone, "BeforeSelectedNodeChanged");
			tv.OnSelectedNodeChangedBase (new EventArgs ());
			Assert.AreEqual (true, eventDone, "AfterSelectedNodeChanged");
		}
		[Test]
		public void TreeView_Event_TreeNodeCheckChanged () {
			string methodName = "TreeNodeCheckChanged";
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			tv.TreeNodeCheckChanged += new TreeNodeEventHandler (TreeViewEventHandler2);
			Assert.AreEqual (false, eventDone, "Before1 " + methodName);
			Assert.AreEqual (string.Empty, treeNodeName, "Before2 " + methodName);
			tv.OnTreeNodeCheckChangedBase (new TreeNodeEventArgs (new TreeNode (methodName)));
			Assert.AreEqual (true, eventDone, "After1 " + methodName);
			Assert.AreEqual (methodName, treeNodeName, "After2 " + methodName);
		}
		[Test]
		public void TreeView_Event_TreeNodeCollapsed () {
			string methodName = "TreeNodeCollapsed";
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			tv.TreeNodeCollapsed += new TreeNodeEventHandler (TreeViewEventHandler2);
			Assert.AreEqual (false, eventDone, "Before1 " + methodName);
			Assert.AreEqual (string.Empty, treeNodeName, "Before2 " + methodName);
			tv.OnTreeNodeCollapsedBase (new TreeNodeEventArgs (new TreeNode (methodName)));
			Assert.AreEqual (true, eventDone, "After1 " + methodName);
			Assert.AreEqual (methodName, treeNodeName, "After2 " + methodName);
		}
		[Test]
		public void TreeView_Event_TreeNodeDataBound () {
			string methodName = "TreeNodeDataBound";
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			tv.TreeNodeDataBound += new TreeNodeEventHandler (TreeViewEventHandler2);
			Assert.AreEqual (false, eventDone, "Before1 " + methodName);
			Assert.AreEqual (string.Empty, treeNodeName, "Before2 " + methodName);
			tv.OnTreeNodeDataBoundBase (new TreeNodeEventArgs (new TreeNode (methodName)));
			Assert.AreEqual (true, eventDone, "After1 " + methodName);
			Assert.AreEqual (methodName, treeNodeName, "After2 " + methodName);
		}
		[Test]
		public void TreeView_Event_TreeNodeExpanded () {
			string methodName = "TreeNodeExpanded";
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			tv.TreeNodeExpanded += new TreeNodeEventHandler (TreeViewEventHandler2);
			Assert.AreEqual (false, eventDone, "Before1 " + methodName);
			Assert.AreEqual (string.Empty, treeNodeName, "Before2 " + methodName);
			tv.OnTreeNodeExpandedBase (new TreeNodeEventArgs (new TreeNode (methodName)));
			Assert.AreEqual (true, eventDone, "After1 " + methodName);
			Assert.AreEqual (methodName, treeNodeName, "After2 " + methodName);
		}
		[Test]
		public void TreeView_Event_TreeNodePopulate () {
			string methodName = "TreeNodePopulate";
			PokerTreeView tv = new PokerTreeView ();
			ResetEvents ();
			tv.TreeNodePopulate += new TreeNodeEventHandler (TreeViewEventHandler2);
			Assert.AreEqual (false, eventDone, "Before1 " + methodName);
			Assert.AreEqual (string.Empty, treeNodeName, "Before2 " + methodName);
			tv.OnTreeNodePopulateBase (new TreeNodeEventArgs (new TreeNode (methodName)));
			Assert.AreEqual (true, eventDone, "After1 " + methodName);
			Assert.AreEqual (methodName, treeNodeName, "After2 " + methodName);
		}

		[TestFixtureTearDown]
		public void TearDown () {
			WebTest.Unload ();
		}
	}
}

#endif
