/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from pointer-constraints-unstable-v1.xml
 * To regenerate, run the “refresh-wayland-wrapper” target.
 */

#include "pointer-constraints-unstable-v1_wrapper.h"

#include <boost/throw_exception.hpp>
#include <boost/exception/diagnostic_information.hpp>

#include <wayland-server-core.h>

#include "mir/log.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const wl_pointer_interface_data;
extern struct wl_interface const wl_region_interface_data;
extern struct wl_interface const wl_surface_interface_data;
extern struct wl_interface const zwp_confined_pointer_v1_interface_data;
extern struct wl_interface const zwp_locked_pointer_v1_interface_data;
extern struct wl_interface const zwp_pointer_constraints_v1_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// PointerConstraintsV1

struct mw::PointerConstraintsV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "PointerConstraintsV1::destroy()");
        }
    }

    static void lock_pointer_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface, struct wl_resource* pointer, struct wl_resource* region, uint32_t lifetime)
    {
        wl_resource* id_resolved{
            wl_resource_create(client, &zwp_locked_pointer_v1_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        std::experimental::optional<struct wl_resource*> region_resolved;
        if (region != nullptr)
        {
            region_resolved = {region};
        }
        try
        {
            auto me = static_cast<PointerConstraintsV1*>(wl_resource_get_user_data(resource));
            me->lock_pointer(id_resolved, surface, pointer, region_resolved, lifetime);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "PointerConstraintsV1::lock_pointer()");
        }
    }

    static void confine_pointer_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface, struct wl_resource* pointer, struct wl_resource* region, uint32_t lifetime)
    {
        wl_resource* id_resolved{
            wl_resource_create(client, &zwp_confined_pointer_v1_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        std::experimental::optional<struct wl_resource*> region_resolved;
        if (region != nullptr)
        {
            region_resolved = {region};
        }
        try
        {
            auto me = static_cast<PointerConstraintsV1*>(wl_resource_get_user_data(resource));
            me->confine_pointer(id_resolved, surface, pointer, region_resolved, lifetime);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "PointerConstraintsV1::confine_pointer()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<PointerConstraintsV1*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<PointerConstraintsV1::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &zwp_pointer_constraints_v1_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "PointerConstraintsV1 global bind");
        }
    }

    static struct wl_interface const* lock_pointer_types[];
    static struct wl_interface const* confine_pointer_types[];
    static struct wl_message const request_messages[];
    static void const* request_vtable[];
};

int const mw::PointerConstraintsV1::Thunks::supported_version = 1;

mw::PointerConstraintsV1::PointerConstraintsV1(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::PointerConstraintsV1::~PointerConstraintsV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

bool mw::PointerConstraintsV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_pointer_constraints_v1_interface_data, Thunks::request_vtable);
}

mw::PointerConstraintsV1::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &zwp_pointer_constraints_v1_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::PointerConstraintsV1::Global::interface_name() const -> char const*
{
    return PointerConstraintsV1::interface_name;
}

struct wl_interface const* mw::PointerConstraintsV1::Thunks::lock_pointer_types[] {
    &zwp_locked_pointer_v1_interface_data,
    &wl_surface_interface_data,
    &wl_pointer_interface_data,
    &wl_region_interface_data,
    nullptr};

struct wl_interface const* mw::PointerConstraintsV1::Thunks::confine_pointer_types[] {
    &zwp_confined_pointer_v1_interface_data,
    &wl_surface_interface_data,
    &wl_pointer_interface_data,
    &wl_region_interface_data,
    nullptr};

struct wl_message const mw::PointerConstraintsV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"lock_pointer", "noo?ou", lock_pointer_types},
    {"confine_pointer", "noo?ou", confine_pointer_types}};

void const* mw::PointerConstraintsV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::lock_pointer_thunk,
    (void*)Thunks::confine_pointer_thunk};

mw::PointerConstraintsV1* mw::PointerConstraintsV1::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_pointer_constraints_v1_interface_data, PointerConstraintsV1::Thunks::request_vtable))
    {
        return static_cast<PointerConstraintsV1*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

// LockedPointerV1

struct mw::LockedPointerV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "LockedPointerV1::destroy()");
        }
    }

    static void set_cursor_position_hint_thunk(struct wl_client* client, struct wl_resource* resource, wl_fixed_t surface_x, wl_fixed_t surface_y)
    {
        double surface_x_resolved{wl_fixed_to_double(surface_x)};
        double surface_y_resolved{wl_fixed_to_double(surface_y)};
        try
        {
            auto me = static_cast<LockedPointerV1*>(wl_resource_get_user_data(resource));
            me->set_cursor_position_hint(surface_x_resolved, surface_y_resolved);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "LockedPointerV1::set_cursor_position_hint()");
        }
    }

    static void set_region_thunk(struct wl_client* client, struct wl_resource* resource, struct wl_resource* region)
    {
        std::experimental::optional<struct wl_resource*> region_resolved;
        if (region != nullptr)
        {
            region_resolved = {region};
        }
        try
        {
            auto me = static_cast<LockedPointerV1*>(wl_resource_get_user_data(resource));
            me->set_region(region_resolved);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "LockedPointerV1::set_region()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<LockedPointerV1*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* set_region_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::LockedPointerV1::Thunks::supported_version = 1;

mw::LockedPointerV1::LockedPointerV1(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::LockedPointerV1::~LockedPointerV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::LockedPointerV1::send_locked_event() const
{
    wl_resource_post_event(resource, Opcode::locked);
}

void mw::LockedPointerV1::send_unlocked_event() const
{
    wl_resource_post_event(resource, Opcode::unlocked);
}

bool mw::LockedPointerV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_locked_pointer_v1_interface_data, Thunks::request_vtable);
}

struct wl_interface const* mw::LockedPointerV1::Thunks::set_region_types[] {
    &wl_region_interface_data};

struct wl_message const mw::LockedPointerV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"set_cursor_position_hint", "ff", all_null_types},
    {"set_region", "?o", set_region_types}};

struct wl_message const mw::LockedPointerV1::Thunks::event_messages[] {
    {"locked", "", all_null_types},
    {"unlocked", "", all_null_types}};

void const* mw::LockedPointerV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::set_cursor_position_hint_thunk,
    (void*)Thunks::set_region_thunk};

mw::LockedPointerV1* mw::LockedPointerV1::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_locked_pointer_v1_interface_data, LockedPointerV1::Thunks::request_vtable))
    {
        return static_cast<LockedPointerV1*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

// ConfinedPointerV1

struct mw::ConfinedPointerV1::Thunks
{
    static int const supported_version;

    static void destroy_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ConfinedPointerV1::destroy()");
        }
    }

    static void set_region_thunk(struct wl_client* client, struct wl_resource* resource, struct wl_resource* region)
    {
        std::experimental::optional<struct wl_resource*> region_resolved;
        if (region != nullptr)
        {
            region_resolved = {region};
        }
        try
        {
            auto me = static_cast<ConfinedPointerV1*>(wl_resource_get_user_data(resource));
            me->set_region(region_resolved);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "ConfinedPointerV1::set_region()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ConfinedPointerV1*>(wl_resource_get_user_data(resource));
    }

    static struct wl_interface const* set_region_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::ConfinedPointerV1::Thunks::supported_version = 1;

mw::ConfinedPointerV1::ConfinedPointerV1(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::ConfinedPointerV1::~ConfinedPointerV1()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::ConfinedPointerV1::send_confined_event() const
{
    wl_resource_post_event(resource, Opcode::confined);
}

void mw::ConfinedPointerV1::send_unconfined_event() const
{
    wl_resource_post_event(resource, Opcode::unconfined);
}

bool mw::ConfinedPointerV1::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &zwp_confined_pointer_v1_interface_data, Thunks::request_vtable);
}

struct wl_interface const* mw::ConfinedPointerV1::Thunks::set_region_types[] {
    &wl_region_interface_data};

struct wl_message const mw::ConfinedPointerV1::Thunks::request_messages[] {
    {"destroy", "", all_null_types},
    {"set_region", "?o", set_region_types}};

struct wl_message const mw::ConfinedPointerV1::Thunks::event_messages[] {
    {"confined", "", all_null_types},
    {"unconfined", "", all_null_types}};

void const* mw::ConfinedPointerV1::Thunks::request_vtable[] {
    (void*)Thunks::destroy_thunk,
    (void*)Thunks::set_region_thunk};

mw::ConfinedPointerV1* mw::ConfinedPointerV1::from(struct wl_resource* resource)
{
    if (wl_resource_instance_of(resource, &zwp_confined_pointer_v1_interface_data, ConfinedPointerV1::Thunks::request_vtable))
    {
        return static_cast<ConfinedPointerV1*>(wl_resource_get_user_data(resource));
    }
    return nullptr;
}

namespace mir
{
namespace wayland
{

struct wl_interface const zwp_pointer_constraints_v1_interface_data {
    mw::PointerConstraintsV1::interface_name,
    mw::PointerConstraintsV1::Thunks::supported_version,
    3, mw::PointerConstraintsV1::Thunks::request_messages,
    0, nullptr};

struct wl_interface const zwp_locked_pointer_v1_interface_data {
    mw::LockedPointerV1::interface_name,
    mw::LockedPointerV1::Thunks::supported_version,
    3, mw::LockedPointerV1::Thunks::request_messages,
    2, mw::LockedPointerV1::Thunks::event_messages};

struct wl_interface const zwp_confined_pointer_v1_interface_data {
    mw::ConfinedPointerV1::interface_name,
    mw::ConfinedPointerV1::Thunks::supported_version,
    2, mw::ConfinedPointerV1::Thunks::request_messages,
    2, mw::ConfinedPointerV1::Thunks::event_messages};

}
}
