#! /bin/sh
#
# $Id: autogen.sh,v 1.12 2006/07/30 10:48:03 al-guest Exp $

AUTOMAKEVER=1.9

set -x

aclocal-$AUTOMAKEVER
[ "$?" != 0 ] && echo "aclocal-$AUTOMAKEVER not available or failed!" && exit 1
autoheader
automake-$AUTOMAKEVER --add-missing --gnu
autoconf

# the next one is quite a bit hacky
# recent automakes (such as 1.9) do not use the mkinstalldirs script anymore
# but use 'install -d' instead but gettext still uses mkinstalldirs but
# automake will not copy it anymore. So we copy it instead... *sigh*
if [ -x /usr/share/gettext/mkinstalldirs ]; then
  cp -a /usr/share/gettext/mkinstalldirs .
else
  echo "/usr/share/gettext/mkinstalldirs missing"
  echo "but I need a mkinstalldirs script. HELP!"
  exit 1
fi
