# Copyright 2012-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Node user-data for cloud-init's use."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'NodeUserData',
    ]


from django.db.models import (
    Model,
    OneToOneField,
)
from maasserver.models.cleansave import CleanSave
from metadataserver import DefaultMeta
from metadataserver.fields import BinaryField


class NodeUserData(CleanSave, Model):
    """User-data portion of a node's metadata.

    When cloud-init sets up a node, it retrieves specific data for that node
    from the metadata service.  One portion of that is the "user-data" binary
    blob.

    :ivar node: Node that this is for.
    :ivar data: base64-encoded data.
    """

    class Meta(DefaultMeta):
        """Needed for South to recognize this model."""

    node = OneToOneField(
        'maasserver.Node', null=False, editable=False)
    data = BinaryField(null=False)
