# -*- coding: utf-8 -*-
#
# MAAS documentation build configuration file, created by
# sphinx-quickstart on Thu Jan 19 14:48:25 2012.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# Import maas' settings.
from os import environ


environ.setdefault("DJANGO_SETTINGS_MODULE", "maas.settings")

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.

import sys, os
# Include '.' in the path so that our custom extension, 'versions', can
# be found.
sys.path.insert(0, os.path.abspath('.'))

# -- Multiple documentation options.

# Add a widget to switch between different versions of the documentation to
# each generated page.
add_version_switcher = False

# In order for the version widget to be able to redirect correctly to the
# other versions of the documentation, each version of the documentation
# has to be accessible at the following addresses:
# /<doc_prefix>/ -> documentation for trunk.
# /<doc_prefix>1.4/ ->  documentation for 1.4.
# etc.
doc_prefix = 'docs'

# Path of the JSON document, relative to homepage of the documentation for trunk
# (i.e. '/<doc_prefix>/'), with the list of the versions to include in the
# version switcher widget.
versions_path = '_static/versions.js'

# Versions to include in the version switcher.
# Note that the version switcher fetches the list of the documentation versions
# from the list published by the trunk documentation (i.e. in '/<doc_prefix>/').
# This means the following list is meaningful only for trunk.   
# The first item should be the development version.
from collections import OrderedDict
doc_versions = OrderedDict([
    ('dev', 'Development trunk'),
    ('1.7', 'MAAS 1.7'),
    ('1.6', 'MAAS 1.6'),
    ('1.5', 'MAAS 1.5'),
    ('1.4', 'MAAS 1.4'),
    ('1.3', 'MAAS 1.3'),
    ('1.2', 'MAAS 1.2'),
])

# -- General configuration -----------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.pngmath',
    'sphinx.ext.viewcode',
    'versions',
    ]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'MAAS'
copyright = u'2012-2014, MAAS Developers'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = doc_versions.items()[0][0]
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build', '_templates']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# AutoDoc <http://sphinx.pocoo.org/ext/autodoc.html>
autodoc_default_flags = ['members', 'show-inheritance']
autodoc_member_order = 'bysource'
autodoc_docstring_signature = True

# AutoSummary <http://sphinx.pocoo.org/ext/autosummary.html>
autosummary_generate = True

# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'maas'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

html_theme_path = ['_templates']

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = 'media/maas-logo-200.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'media/maas.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'MAASdoc'


# -- Options for LaTeX output --------------------------------------------------

# The paper size ('letter' or 'a4').
latex_paper_size = 'a4'

# The font size ('10pt', '11pt' or '12pt').
#latex_font_size = '10pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('index', 'MAAS.tex', u'MAAS Documentation',
   u'MAAS Developers', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Additional stuff for the LaTeX preamble.
#latex_preamble = ''

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True


# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('man/maas.8', 'maas', u'MAAS API commandline utility',
     [u'Canonical 2013-2014'], 8),
    ('man/maas-import-pxe-files.8', 'maas-import-pxe-files', u'MAAS helper script',
     [u'Canonical 2013'], 8),
    ('man/maas-region-admin.8', 'maas-region-admin', u'MAAS administration tool',
     [u'Canonical 2013-2014'], 8)
]


# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'http://docs.python.org/': None}

# Gather information about the branch and the build date.
from subprocess import check_output
bzr_last_revision_number = check_output(['bzr', 'revno'])
bzr_last_revision_date = check_output(['bzr', 'version-info', '--template={date}', '--custom'])
bzr_build_date = check_output(['bzr', 'version-info', '--template={build_date}', '--custom'])

# Populate html_context with the variables used in the templates.
html_context = {
    'add_version_switcher': 'true' if add_version_switcher else 'false',
    'versions_json_path': '/'.join(['', doc_prefix, versions_path]),
    'doc_prefix': doc_prefix,
    'bzr_last_revision_date': bzr_last_revision_date,
    'bzr_last_revision_number': bzr_last_revision_number,
    'bzr_build_date': bzr_build_date,
}
