/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 */

namespace Zeitgeist
{
  public interface EggZeitgeistMonitor: GLib.Object
  {
  }

  public interface ResultSet: GLib.Object
  {
    [CCode (cname = "_vala_zeitgeist_result_set_next_value")]
    public unowned Event? next_value ();
    [CCode (cname = "_vala_zeitgeist_result_set_iterator")]
    public ResultSet iterator ();
  }
}

namespace Zeitgeist.Symbol
{
  [CCode (cheader_filename = "zeitgeist.h")]
  public static GLib.List<weak string> get_all_children (string symbol);
  [CCode (cheader_filename = "zeitgeist.h")]
  public static GLib.List<weak string> get_children (string symbol);
  [CCode (cheader_filename = "zeitgeist.h")]
  public static GLib.List<weak string> get_parents (string symbol);
  [CCode (cheader_filename = "zeitgeist.h")]
  public static bool is_a (string symbol, string parent);
}

namespace Zeitgeist.Timestamp
{
  [CCode (cname = "ZEITGEIST_TIMESTAMP_SECOND", cheader_filename = "zeitgeist.h")]
  public int64 SECOND;

  [CCode (cname = "ZEITGEIST_TIMESTAMP_MINUTE", cheader_filename = "zeitgeist.h")]
  public int64 MINUTE;

  [CCode (cname = "ZEITGEIST_TIMESTAMP_HOUR", cheader_filename = "zeitgeist.h")]
  public int64 HOUR;

  [CCode (cname = "ZEITGEIST_TIMESTAMP_DAY", cheader_filename = "zeitgeist.h")]
  public int64 DAY;

  [CCode (cname = "ZEITGEIST_TIMESTAMP_WEEK", cheader_filename = "zeitgeist.h")]
  public int64 WEEK;

  [CCode (cname = "ZEITGEIST_TIMESTAMP_YEAR", cheader_filename = "zeitgeist.h")]
  public int64 YEAR;

  [CCode (cname = "zeitgeist_timestamp_for_now", cheader_filename = "zeitgeist.h")]
  public int64 now ();

  [CCode (cname = "zeitgeist_timestamp_from_timeval", cheader_filename = "zeitgeist.h")]
  public int64 from_timeval (GLib.TimeVal tv);

  [CCode (cname = "zeitgeist_timestamp_to_timeval", cheader_filename = "zeitgeist.h")]
  public int64 to_timeval (int64 timestamp, out GLib.TimeVal tv);

  [CCode (cname = "zeitgeist_timestamp_from_iso8601", cheader_filename = "zeitgeist.h")]
  public int64 from_iso8601 (string datetime);

  [CCode (cname = "zeitgeist_timestamp_to_iso8601", cheader_filename = "zeitgeist.h")]
  public string to_iso8601 (int64 timestamp);

  [CCode (cname = "zeitgeist_timestamp_from_date", cheader_filename = "zeitgeist.h")]
  public int64 from_date (GLib.Date date);

  [CCode (cname = "zeitgeist_timestamp_from_dmy", cheader_filename = "zeitgeist.h")]
  public int64 from_dmy (GLib.DateDay day, GLib.DateMonth month, GLib.DateYear year);

  [CCode (cname = "zeitgeist_timestamp_to_date", cheader_filename = "zeitgeist.h")]
  public int64 to_date (int64 timestamp, out GLib.Date date);
  
  [CCode (cname = "zeitgeist_timestamp_next_midnight", cheader_filename = "zeitgeist.h")]
  public static int64 next_midnight (int64 timestamp);
  
  [CCode (cname = "zeitgeist_timestamp_prev_midnight", cheader_filename = "zeitgeist.h")]
  public static int64 prev_midnight (int64 timestamp);
}

// vim:et:ai:cindent:ts=2 sts=2 sw=2:
