#include <config.h>
#include <libssh/libssh.h>

#define LPAR_EXEC_ERR -1
#define SSH_CONN_ERR -2         /* error while trying to connect to remote host */
#define SSH_CMD_ERR -3          /* error while trying to execute the remote cmd */

typedef struct _ConnectionData ConnectionData;
typedef ConnectionData *ConnectionDataPtr;
struct _ConnectionData {
    SSH_SESSION *session;
    virConnectAuthPtr auth;
};

/* This is the lpar (domain) struct that relates
 * the ID with UUID generated by the API
 * */
typedef struct _lpar lpar_t;
typedef lpar_t *lparPtr;
struct _lpar {
    unsigned char uuid[VIR_UUID_BUFLEN];
    int id;
};

/* Struct that holds how many lpars (domains) we're
 * handling and a pointer to an array of lpar structs
 * */
typedef struct _uuid_db uuid_db_t;
typedef uuid_db_t *uuid_dbPtr;
struct _uuid_db {
    int nlpars;
    lparPtr *lpars;
};

int phypGetLparUUID(unsigned char *uuid, int lpar_id, virConnectPtr conn);

void init_uuid_db(virConnectPtr conn);

int phypRegister(void);

void stripPath(char *striped_path, char *path);

void stripNewline(char *striped_string, char *string);

int buffer_add_u8(struct buffer_struct *buffer, u8 data);

int phypGetLparState(virConnectPtr conn, unsigned int lpar_id);

unsigned long phypGetLparMem(virConnectPtr conn,
                             const char *managed_system, int lpar_id,
                             int type);

unsigned long phypGetLparCPU(virConnectPtr conn,
                             const char *managed_system, int lpar_id);

int phypGetRemoteSlot(virConnectPtr conn, const char *managed_system,
                      const char *lpar_name);

char *phypGetBackingDevice(virConnectPtr conn, const char *managed_system,
                           char *lpar_name);

int phypDiskType(virConnectPtr conn, char *backing_device);

SSH_SESSION *openSSHSession(virConnectPtr conn, virConnectAuthPtr auth);

int escape_specialcharacters(char *src, char *dst);
