/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Dee;

namespace Unity {

/* The raw structs that get's passed over DBus to/from the parent Lens */
private struct ScopeInfo
{
  public string dbus_path;
  public string[] sources;
  public bool search_in_global;
  public string private_connection_name;
  public string results_model_name;
  public string global_results_model_name;
  public string filters_model_name;
  public HashTable<string, Variant> hints;
}

private struct ActivationReplyRaw
{
  public string uri;
  public uint handled;
  public HashTable<string, Variant> hints;
}

private struct PreviewReplyRaw
{
  public string uri;
  public string renderer_name;
  HashTable<string, Variant> properties;
}

/**
 * ScopeService:
 *
 * The Scope interface exported on DBus
 */
[DBus (name = "com.canonical.Unity.Scope")]
private interface ScopeService : GLib.Object
{
  public abstract async void info_request () throws IOError;

  public abstract async ActivationReplyRaw activate (string uri,
                                                     uint action_type) throws IOError;

  public abstract async void search (string search_string,
                                     HashTable<string, Variant> hints) throws IOError;

  public abstract async void global_search (string search_string,
                                            HashTable<string, Variant> hints) throws IOError;
  
  public abstract async PreviewReplyRaw preview (string uri) throws IOError;
    
  public abstract async void set_active (bool active) throws IOError;

  public abstract async void set_active_sources (string[] sources) throws IOError;
  
  public signal void changed (ScopeInfo lens_info);
  
  public signal void search_finished (string search_string, HashTable<string, Variant> hints);
  
  public signal void global_search_finished (string search_string, HashTable<string, Variant> hints);
}

} /* namespace unity */
